{
    BSD 3-Clause License
    Copyright (c) 2021, Jerome Shidel
    All rights reserved.
}

{$I DANGER.DEF}
program Smiley_Test_Game;

uses Danger;

type
    TBorderSection = (bsTop, bsBottom, bsSide, bsTopCorner, bsBottomCorner,
        bsTopEdge, bsBottomEdge);

const
    Lives       : integer = 3;
    Score       : LongInt = 0;
    NewScore    : LongInt = 0;
    Speed       : word = 1;
    LifeInc     : LongInt = 250000;
    LifeMax     : word = 6;

    ScoreColor  : TColor = 8;
    WallGap     : integer = 0;
    WallTilt    : integer = 2;
    TiltTicks   : word = 18;
    TextHigh    : integer = -1;
    LastWide    : integer = -1;
    LastScore   : LongInt = -1;
    LastColor   : TColor = 0;
    BackGround  : TColor = {247} {250} {254} 253;
    AutoPilot   : boolean = false;

var
    Border : array [TBorderSection] of PImage;
    Life : PImage;
    LifeMask : PMask;
    Smiley, Paddle : PSprite;
    Corners : array[0..3] of TPoint;
    Tilty : array[0..2] of record
        Count : integer;
        Area  : TArea;
        Direction : array[0..1] of TDirection;
    end;
    LifeNext : LongInt;
    Shove : TPoint;
    LivesXY : TPoint;

procedure DrawBorder;
var
    X, Y : integer;
begin
    X := GetMaxX - Border[bsBottomCorner]^.Width - WallTilt;
    Y := GetMaxY - Border[bsBottomCorner]^.Height - WallTilt;
    SetPoint(X-1, Y-1, Corners[3]); { bottom left inside corner }
    Video^.PutImage(Border[bsBottomCorner], X, Y);
    while X > WallGap + Border[bsBottomEdge]^.Width + Border[bsBottom]^.Width do begin
        Dec(X, Border[bsBottom]^.Width);
        Video^.PutImage(Border[bsBottom], X, Y);
    end;
    SetArea(X, Y,
        GetMaxX - Border[bsBottomCorner]^.Width - WallTilt - 1,
        GetMaxY - WallTilt, Tilty[1].Area);
    Tilty[1].Direction[0] := dmUp;
    Tilty[1].Direction[1] := dmDown;
    Dec(X, Border[bsBottomEdge]^.Width);
    SetPoint(X-1, Y-1, Corners[2]); { bottom left inside edge }
    Video^.PutImage(Border[bsBottomEdge], X, Y);

    X := GetMaxX - Border[bsBottomCorner]^.Width - WallTilt;
    Y := GetMaxY - Border[bsBottomCorner]^.Height - WallTilt;
    SetArea(X, Y, GetMaxX - WallTilt, Y, Tilty[2].Area);
    repeat
        Dec(Y, Border[bsSide]^.Height);
        Video^.PutImage(Border[bsSide], X, Y);
    until  Y <= 14 + Border[bsTopCorner]^.Height + Border[bsSide]^.Height;
    Tilty[2].Area.Top := Y;
    Tilty[2].Direction[0] := dmLeft;
    Tilty[2].Direction[1] := dmRight;
    SetPoint(X-1, Y+1, Corners[1]); { top right inside corner }
    Dec(Y, Border[bsTopCorner]^.Height);
    Video^.PutImage(Border[bsTopCorner], X, Y);

    while X > WallGap + Border[bsTopEdge]^.Width + Border[bsTop]^.Width do begin
        Dec(X, Border[bsTop]^.Width);
        Video^.PutImage(Border[bsTop], X, Y);
    end;
    SetArea(X, Y - WallTilt + 1, Corners[1].X, Y + Border[bsTopEdge]^.Height - 1, Tilty[0].Area);
    Tilty[0].Direction[0] := dmDown;
    Tilty[0].Direction[1] := dmUp;
    Dec(X, Border[bsTopEdge]^.Width);
    SetPoint(X-1, Y+ Border[bsTopEdge]^.Height, Corners[0]); { top left inside edge }
    Video^.PutImage(Border[bsTopEdge], X, Y);
    { Upper wall area }
end;

procedure DrawLives;
var
    I, W : integer;
begin
    Video^.SpriteUndraw(Paddle);
    W := Life^.Width + 2;
    for I := 1 to Lives do begin
        Video^.PutMask(LifeMask, LivesXY.X + (I - 1) * W, LivesXY.Y);
        Video^.PutImageMode(Life, LivesXY.X + (I - 1) * W, LivesXY.Y, imXOR);
    end;
    Video^.Region(LivesXY.Y + Lives * W, LivesXY.Y, WallTilt + (Lives + 1) * W - 1,
        LivesXY.Y + Life^.Height - 1, BackGround);
end;

procedure DrawScore;
var
    Str : String;
    V : LongInt;
    X, E   : Integer;
begin
    if Score <> NewScore then begin
        if NewScore - Score > 10 then
            Inc(Score, (NewScore - Score) shr 1)
        else
            Inc(Score);
    end;
    if Score < 0 then begin
        Score := 0; { rollover }
        NewScore := 0;
    end;
    if (Score = LastScore) and (LastColor = ScoreColor) then Exit;
    if TextHigh = -1 then TextHigh := Video^.TextHeight('0');
    X := GetMaxX - WallTilt - 1;
    if LastWide <> -1 then begin
        Video^.Region(X - LastWide - 1, WallTilt - 1,
            X + 1, TextHigh + WallTilt + 1, BackGround);
    end;
    LastScore := Score;
    LastColor := ScoreColor;
    Str  := ZPad(LastScore, 6);
    LastWide := Video^.TextWidth(Str);
    Val(Str, V, E);
    Video^.PutText(X - LastWide, WallTilt, Str, ScoreColor);
    if Score > LifeNext then begin
       if Lives < LifeMax then begin
            Inc(Lives);
            DrawLives;
       end;
       Inc(LifeNext, LifeInc);
    end;
end;

procedure DrawBackdrop;
begin
    Video^.Fill(BackGround);
end;

procedure ScoreWall;
begin
    Inc(NewScore, Speed *(Tilty[0].Count + Tilty[1].Count + Tilty[2].Count) * 10);
end;

procedure ScorePlus(Amount : word);
begin
    Inc(NewScore, Speed * Amount * (Corners[0].X - Paddle^.Area.Right));
end;

procedure MovePaddle(MX, MY : integer);
var
    XY : TPoint;
begin
    Video^.SpriteWhere(Paddle, XY);
    Inc(MX, Shove.X);
    Inc(MX, XY.X);
    Inc(MY, XY.Y);

    if MX < 1 then
        MX := 1
    else if MX > Corners[0].X - 8 then begin
        MX := Corners[0].X - 8;
    end;
    if MY < -10 then
        MY := -10
    else if MY > GetMaxY + 9 then
        MY := GetMaxY + 9;
    Dec(MX, Shove.X);

    Video^.SpriteMove(Paddle, MX, MY);
end;

procedure SpeedBump;
begin
    case Speed of
        1 : Inc(Speed);
        2 : if Score > 499 then Inc(Speed);
        3 : if Score > 4999 then Inc(Speed);
        4 : if Score > 49999 then Inc(Speed);
        5 : if Score > 99999 then Inc(Speed);
        6 : if Score > 249999 then Inc(Speed);
        7 : if Score > 499999 then Inc(Speed);
        8 : if Score > 999999 then Inc(Speed);
    end;
end;

procedure PaddleFollow(Direct : TDirection);
const
    Repeater : integer = 0;
begin
    Dec(Repeater);
    if Repeater < 1 then begin
        KeysDown[scUp and $ff] := False;
        KeysDown[scDown and $ff] := False;
        Repeater := 0;
    end;
    case Direct of
        dmUpRight : begin
            KeysDown[scUp and $ff] := Smiley^.Area.Bottom < Paddle^.Area.Top;
        end;
        dmDownRight : begin
            KeysDown[scDown and $ff] := Smiley^.Area.Top > Paddle^.Area.Bottom;
        end;
        dmUpLeft : begin
            KeysDown[scUp and $ff] := Smiley^.Area.Top < Paddle^.Area.Top;
        end;
        dmDownLeft : begin
            KeysDown[scDown and $ff] := Smiley^.Area.Bottom > Paddle^.Area.Bottom;
        end;
    end;
    if KeysDown[scUp and $ff] or KeysDown[scDown and $ff] then begin
        if Repeater < 4 then Inc(Repeater);
    end;
end;

procedure Run;
var
    SP, FP  : TRGBPalettes;
    Faded   : integer;
    LTT     : word;
    Event   : TEvent;
    Abort   : boolean;
    I, TMP  : word;
    D, LD   : word;
    PXY,
    Accel   : TPoint;
    IgnoreLag : LongInt;
    Shaker,
    Oops    : integer;
begin
    LifeNext := LifeInc;
    SetPoint(WallTilt+ 1, WallTilt, LivesXY);
    Faded := 100;
    Video^.GetPalettes(SP);
    FP := SP;
    Video^.FadePalettes(FP, Faded);
    Video^.SetPalettes(FP);
    Video^.SetSync(True);
    Video^.SetBuffered(True);
    Video^.SetMonospace(True);
    DrawBackdrop;
    DrawBorder;
    DrawLives;
    DrawScore;
    Abort := False;
    Paddle^.HotSpot.Y := (Paddle^.Area.Bottom - Paddle^.Area.Top) div 2;
    Video^.SpriteMove(Paddle, 0, GetMaxY div 2);
    Video^.SpriteShow(Paddle);
    Paddle^.Animate := -1;
    Video^.SpriteMove(Smiley, GetMaxX div 2, GetMaxY div 2);
    Video^.SpriteShow(Smiley);
    Video^.Update;
    LTT := VRTimer^;
    D := dmNowhere;
    LD := D;
    SetPoint(0,0,Accel);
    SetPoint(0,0,Shove);
    IgnoreLag := 20;
    Oops := 0;
    Shaker := 0;

    { NewScore := 5000;
    Speed := 3;
    AutoPilot := True; }

{    Video^.SpriteMove(Paddle, 10, GetMaxY - 20);
    Video^.SpriteMove(Smiley, 1, 70); }

    repeat
        if GetEvent(Event) then begin
            if Event.Kind = evMouseClick then begin
               Event.Kind := evKeyPress;
               Event.KeyCode := kbSpace;
               Event.ScanCode := 0;
            end;
            if Event.Kind and evKeyboard <> 0 then begin
                if Event.Kind = evKeyPress then begin
                    case Event.Keycode of
                        kbEscape : Abort := True;
                        kbSpace  : begin
                            if (Oops = 0) and (D = dmNowhere) then begin
                                if Random(2) = 1 then begin
                                    D := dmUpRight;
                                    Video^.SpriteSetSeq(Smiley,0);
                                end else begin
                                    D := dmDownRight;
                                    Video^.SpriteSetSeq(Smiley,1);
                                end;
                            end else D := dmNowhere;
                        end; { kbSpace }
                    end { case KeyCode };
                end;
            end else if Event.Kind and evMouseMove <> 0 then begin
                MovePaddle(Event.Movement.X, Event.Movement.Y);
            end;
        end else { GetEvent }
            if AutoPilot then PaddleFollow(D);

        if (Shaker > 0) and (Tilty[0].Count + Tilty[1].Count + Tilty[1].Count = 0) then begin
            Dec(Shaker);
            if not SlowVideoDriver then begin
                Video^.SpriteUndrawAll;
                case Shaker and $03 of
                    0 : begin
                        Video^.Shift(dmUp, 1, BackGround);
                        Dec(LivesXY.Y);
                    end;
                    1 : begin
                        Video^.Shift(dmRight, 1, BackGround);
                        Inc(LivesXY.X);
                    end;
                    2 : begin
                        Video^.Shift(dmDown, 1, BackGround);
                        Inc(LivesXY.Y);
                    end;
                    3 : begin
                        Video^.Shift(dmLeft, 1, BackGround);
                        Dec(LivesXY.X);
                    end;
                end;
            end;
        end;

        if (LTT <> VRTimer^) then begin
            LTT := VRTimer^;

            { Missed animation and Life cycle }
            if (Oops > 1) then begin
                Dec(Oops);
                if (Oops shr 2) and $1 = 1 then begin
                    Dec(Lives);
                    DrawLives;
                    Inc(Lives);
                end else begin
                    DrawLives;
                end;
            end else if (Oops = 1) and (Shaker = 0) then begin
                Oops := 0;
                if Score > 4999 then Speed := 2;
                if Score > 99999 then Speed := 3;
                Dec(Lives);
                DrawLives;
                if Lives >= 0 then begin
                    Video^.SpriteMove(Smiley, GetMaxX div 2, GetMaxY div 2);
                end else begin
                    { GameOver; }
                    Abort := True;
                end;
            end;

            { Keyboard Paddle Control Stuff}
            if KeysDown[scUp and $ff] and KeysDown[scDown and $ff] then begin
                { Vertical Brakes }
                if Accel.Y < -Speed * 2 then Inc(Accel.Y, Speed) else
                if Accel.Y < 0 then Inc(Accel.Y);
                if Accel.Y > Speed * 2 then Dec(Accel.Y, Speed) else
                if Accel.Y > 0 then Dec(Accel.Y);
            end else begin
                if KeysDown[scUp and $ff] then begin
                    if Accel.Y >= -5 then Dec(Accel.Y, 2);
                end else if KeysDown[scDown and $ff] then begin
                    if Accel.Y <= 5 then Inc(Accel.Y, 2);
                end;
            end;
            if KeysDown[scLeft and $ff] and KeysDown[scRight and $ff] then begin
                { Horizontal Brakes }
                if Accel.X < -Speed then Inc(Accel.X, Speed) else
                if Accel.X < 0 then Inc(Accel.X);
                if Accel.X > Speed then Dec(Accel.X, Speed) else
                if Accel.X > 0 then Dec(Accel.X);
            end else begin
                if KeysDown[scLeft and $ff] then begin
                    if Accel.X > -4 then Dec(Accel.X);
                end else if KeysDown[scRight and $ff] then begin
                    if Shove.X > 2 then Dec(Shove.X, 2);
                    if Accel.X < 4 then Inc(Accel.X);
                end;
            end;
            if (Accel.X <> 0) or (Accel.Y <> 0) then begin
                if (Accel.Y < 0) and (not KeysDown[scUp and $ff]) then Inc(Accel.Y);
                if (Accel.Y > 0) and (not KeysDown[scDown and $ff]) then Dec(Accel.Y);
                if (Accel.X < 0) and (not KeysDown[scLeft and $ff]) then Inc(Accel.X);
                if (Accel.X > 0) and (not KeysDown[scRight and $ff]) then Dec(Accel.X);
                MovePaddle(Accel.X, Accel.Y);
            end;

            { Update sprite animations }
            if (LTT and 1 = 0) and (not SlowVideoDriver) then
                Video^.SpriteNextAll(false);

            { Paddle shove and bounce back }
            if Shove.Y > 0 then begin
                Dec(Shove.Y);
                Inc(Shove.X, Shove.Y div 3);
                MovePaddle(0, 0);
            end;

            if LTT and $01 = 0 then begin
                if Shove.X > 0 then begin
                    Dec(Shove.X);
                    MovePaddle(1, 0);
                end
            end;

            { Wall shake }
            for I := 0 to 2 do with Tilty[I] do
                if Count > 0 then begin
                    Dec(Count);
                    if not SlowVideoDriver then
                        Video^.ShiftRegion(
                            Area.Left,Area.Top,
                            Area.Right,Area.Bottom,
                            Direction[Count and 1],1,BackGround);
                end;

             LD := D;

            if Smiley^.Area.Left < Corners[0].X then begin

                if (Smiley^.Area.Right >= Corners[0].X) and
                ((D = dmUpRight) or (D = dmDownRight)) then begin
                    if (Smiley^.Area.Top < Corners[0].Y) then begin
                        if (Smiley^.Area.Bottom > Corners[0].Y - Border[bsTopEdge]^.Height shr 2) then
                            D := dmDownLeft
                        else
                        if (Smiley^.Area.Bottom > Corners[0].Y - Border[bsTopEdge]^.Height) then
                            D := dmUpLeft;
                    end;
                end;

                { Check if died or hit paddle }
                if (Smiley^.Area.Right < 0) or (Smiley^.Area.Bottom < 0) or
                (Smiley^.Area.Top > GetMaxY) then begin
                { Smiley off screen so you died }
                    if (Oops = 0) and (Lives >= 0) then begin
                        Oops := 90;
                        Shaker := 4 * 18;
                        D := dmNowhere;
                        Speed := 1;
                    end;
                end else if Video^.SpriteIntersect(Smiley, Smiley^.Area.Left,
                Smiley^.Area.Top, Paddle) then begin
                    { Smiley hit the paddle somewhere }
                    SpeedBump;
                    if Speed > 1 then begin
                        Inc(Shove.Y,(Speed - 1) * 3);
                        Inc(Shove.X, Speed);
                        MovePaddle(-Speed, 0);
                    end;
                    Video^.SpriteWhere(Paddle, PXY);
                    if Smiley^.Area.Right < Paddle^.Area.Right then begin
                        { Smiley is a lot past paddle face }
                    end else if Smiley^.Area.Left < Paddle^.Area.Right then begin
                        { Smiley is a little past Paddle face }
                        if Smiley^.Area.Bottom < Paddle^.Area.Top + AreaHeight(PAddle^.Area) shr 2 then begin
                            { Smiley hit upper side of paddle }
                            D := dmUpRight;
                            Inc(NewScore, 1 shl (Speed - 1) + Speed shl 1);
                        end else
                        if Smiley^.Area.Top > Paddle^.Area.Top + AreaHeight(PAddle^.Area) shr 2 then begin
                            { Smiley hit Lower side of paddle }
                            D := dmDownRight;
                            Inc(NewScore, 1 shl (Speed - 1) + Speed shl 1);
                        end else begin
                            { Smiley hit middle of paddle }
                            Inc(NewScore, Speed shl 1);
                            case D of
                                dmUpLeft : D := dmUpRight;
                                dmDownLeft : D := dmDownRight;
                            end;
                        end;
                    end else begin
                        { Smiley is not past paddle face }
                        Inc(NewScore, Speed shl 1);
                        case D of
                            dmUpLeft : D := dmUpRight;
                            dmDownLeft : D := dmDownRight;
                        end;
                    end;
                end; { Sprite Intersect }
             end; { Outside Walled Area }

             case D of { Wall testing and smiley movement  }
                dmNowhere : begin
                    TMP := Random(10);
                    if Paddle^.Area.Bottom < Smiley^.Area.Top then
                        Video^.SpriteSetSeq(Smiley, 3)
                    else if Paddle^.Area.Top > Smiley^.Area.Bottom then
                        Video^.SpriteSetSeq(Smiley, 2)
                    else
                        Video^.SpriteSetSeq(Smiley, 4);
                end;
                dmUpRight : begin
                    Video^.SpriteMove(Smiley, Smiley^.Area.Left + Speed, Smiley^.Area.Top - Speed);
                    if Smiley^.Area.Top < Corners[0].Y then begin
                        Video^.SpriteMove(Smiley, Smiley^.Area.Left, Smiley^.Area.Top + Speed);
                        D := dmDownRight;
                        ScoreWall;
                        Inc(Tilty[0].Count, TiltTicks);
                    end;
                    if Smiley^.Area.Right > Corners[1].X then begin
                        ScoreWall;
                        Inc(Tilty[2].Count,TiltTicks);
                        Video^.SpriteMove(Smiley, Smiley^.Area.Left - Speed, Smiley^.Area.Top);
                        if D = dmUpRight then
                            D := dmUpLeft
                        else
                            D := dmDownLeft;
                    end;
                end; { dmUpRight }
                dmDownRight :  begin
                    Video^.SpriteMove(Smiley, Smiley^.Area.Left + Speed, Smiley^.Area.Top + Speed);
                    if Smiley^.Area.Bottom > Corners[3].Y then begin
                        Video^.SpriteMove(Smiley, Smiley^.Area.Left, Smiley^.Area.Top - Speed);
                        ScoreWall;
                        Inc(Tilty[1].Count, TiltTicks);
                        D := dmUpRight;
                    end;
                    if Smiley^.Area.Right > Corners[1].X then begin
                        ScoreWall;
                        Inc(Tilty[2].Count,TiltTicks);
                        Video^.SpriteMove(Smiley, Smiley^.Area.Left - Speed, Smiley^.Area.Top);
                        if D = dmDownRight then
                            D := dmDownLeft
                        else
                            D := dmUpLeft;
                    end;
                end; { dmDownRight }
                dmUpLeft :  begin
                    Video^.SpriteMove(Smiley, Smiley^.Area.Left - Speed, Smiley^.Area.Top - Speed);
                    if (Smiley^.Area.Top < Corners[0].Y) then begin
                        Video^.SpriteMove(Smiley, Smiley^.Area.Left, Smiley^.Area.Top + Speed);
                        ScoreWall;
                        Inc(Tilty[0].Count, TiltTicks);
                        D := dmDownLeft;
                    end;
                end; { dmUpLeft }
                dmDownLeft :  begin
                    Video^.SpriteMove(Smiley, Smiley^.Area.Left - Speed, Smiley^.Area.Top + Speed);
                    if (Smiley^.Area.Bottom > Corners[3].Y) then begin
                        Video^.SpriteMove(Smiley, Smiley^.Area.Left, Smiley^.Area.Top - Speed);
                        ScoreWall;
                        Inc(Tilty[1].Count, TiltTicks);
                        D := dmUpLeft;
                    end;
                end; { dmDownLeft }
            end; { case D - wall testing }

            if LD <> D then begin
                ScorePlus(1);
                case D of
                    dmUpRight : Video^.SpriteSetSeq(Smiley,0);
                    dmDownRight : Video^.SpriteSetSeq(Smiley,1);
                    dmUpLeft : Video^.SpriteSetSeq(Smiley,3);
                    dmDownLeft : Video^.SpriteSetSeq(Smiley,2);
                end;
            end;

            if IgnoreLag > 0 then Dec(IgnoreLag, 1);

            { Startup and Quit fader }
            if Abort then begin
                if Faded < 100 then begin
                    Inc(IgnoreLag, 1);
                    Inc(Faded, 3);
                    if Faded > 100 then Faded:=100;
                    FP := SP;
                    Video^.FadePalettes(FP, Faded);
                    Video^.SetPalettes(FP);
                end;
            end else begin
                if Faded > 0 then begin
                    Inc(IgnoreLag, 1);
                    Dec(Faded, 3);
                    if Faded < 0 then Faded := 0;
                    FP := SP;
                    Video^.FadePalettes(FP, Faded);
                    Video^.SetPalettes(FP);
                end;
            end;

            DrawScore;
        end; { VRTimer tick }

        if IgnoreLag = 0 then begin
            if LagMeter > 5 then begin
                Video^.Region( 160, 0, 200, 14, 0);
                Video^.PutText( 160,0, IntStr(LagMeter), 13);
            end;
        end;

        Video^.Update;
    until Abort and (Faded = 100);
    Video^.Fill(0);
    Video^.Update;
    Video^.SetPalettes(SP);
end;

procedure Options;
var
    Opt : String;
    I, E : integer;
begin
    I := 0;
    while I < ParamCount do begin
        Inc(I);
        Opt := UCase(ParamStr(I));
        if (Opt = '/H') or (Opt = '/?') then begin
            PrintHelp;
        end else
        if Opt = '/BM' then begin
            AppInfo.Driver.Video   := 'BIOSVID.DRV';
            Inc(I);
            if UCase(ParamStr(I)) <> 'LIST' then
                Val(ParamStr(I), AppInfo.VideoMode, E)
            else
                AppInfo.VideoMode:=$ffff;
            Inc(I);
        end else begin
           { Ignore other stuff }
        end;
    end;
end;

procedure Prepare;
var
    P : PAsset;
begin
    AppInfo.Delay.Message := 0;
    ImageCompress := False;
    SetVRTInterval(2);
    Randomize;
    FillChar(Tilty, Sizeof(Tilty), 0);
    Life                    := AssetLoadOrDie('SMILE.IGG',   asDefault, P);
    LifeMask                := Video^.ImageToMask(Life, 0);
    Smiley                  := AssetLoadOrDie('SMILEY.IGS',   asDefault, P);
    Paddle                  := AssetLoadOrDie('PADDLE.IGS',   asDefault, P);
    Smiley^.Level           := $30;
    Paddle^.Level           := $30;
    Border[bsTop]           := AssetLoadOrDie('BORDERT.IGG',  asDefault, P);
    Border[bsBottom]        := AssetLoadOrDie('BORDERB.IGG',  asDefault, P);
    Border[bsSide]          := AssetLoadOrDie('BORDERS.IGG',  asDefault, P);
    Border[bsTopCorner]     := AssetLoadOrDie('BORDERTC.IGG', asDefault, P);
    Border[bsBottomCorner]  := AssetLoadOrDie('BORDERBC.IGG', asDefault, P);
    Border[bsTopEdge]       := AssetLoadOrDie('BORDERTE.IGG', asDefault, P);
    Border[bsBottomEdge]    := AssetLoadOrDie('BORDERBE.IGG', asDefault, P);
end;

procedure Initialize;
begin
    { If assets are attached to the executable, or compiled with D+, or
      drivers and fonts are (by default) available in the EXE's directory,
      then there is no need to add these system paths to the Asset Index }
    AssetIndexSys('DRIVERS\', '');
    AssetIndexSys('FONTS\', '');
    AssetIndexSys('SMILEY\', '');
end;

var
    FS : String;

begin
    Initialize; { settings/changes needed before Danger Engine is started }
    Options;    { parse command line options }
    Ignite;     { start game engine }
    Prepare;    { Prepare for app/game run }
    Run;        { run game/program }
    if (NewScore <> 0) then
      ExitMessage := FormatNLS('FINAL.SCORE', IntStr(NewScore));
    Extinguish; { normal shutdown of game engine }
end.