/*
 *  Copyright (C) 2002-2003 RealVNC Ltd.
 *  Copyright (C) 1999 AT&T Laboratories Cambridge.  All Rights Reserved.
 *
 *  This is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This software is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 *  USA.
 */

/*
 * sockets.c - functions to deal with sockets.
 */

#include <stdio.h>
/* Watterloo-TCP Socket Library */
#include <tcp.h>
#define LOCALPORT 1234

/* BJ - TEMP
#include <sys/socket.h>
#include <errno.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <fcntl.h>
#include <assert.h>
*/
/* BJ - Compile Pas
extern "C" {
#include "viewer.h"
}
*/
#include "viewer.h"
/* BJ - TEMP
#include <rdr/FdInStream.h>
#include <rdr/FdOutStream.h>
#include <rdr/Exception.h>
*/
/* BJ - COMPILE PAS
extern "C" {
*/
  void PrintInHex(char *buf, int len);
/* BJ
}
*/
/*
int rfbsock;
*/
static tcp_Socket socketdata;
tcp_Socket *socket;

/* BJ - TEMP
rdr::FdInStream* fis;
rdr::FdOutStream* fos;
*/
Bool sameMachine = False;

static Bool rfbsockReady = False;

/* BJ - Disabled because linked to X
extern "C" {
static void rfbsockReadyCallback(XtPointer clientData, int *fd, XtInputId *id)
{
  rfbsockReady = True;
  XtRemoveInput(*id);
}
}
*/

/* BJ - Disable because linked to X
static void ProcessXtEvents(void*)
{
  rfbsockReady = False;
  XtAppAddInput(appContext, rfbsock, (XtPointer)XtInputReadMask,
		rfbsockReadyCallback, NULL);
  while (!rfbsockReady) {
    XtAppProcessEvent(appContext, XtIMAll);
    if (!XtAppPending(appContext))
      CheckUpdateNeeded();
  }
}
*/

/*
 * ConnectToRFBServer.
 */
Bool ConnectToRFBServer(const char *hostname, int port)
{
  sock_init();
  
  socket = &socketdata;
  
  if (!ConnectToTcpAddr(hostname, port)) {
    fprintf(stderr,"Unable to connect to VNC server\n");
    return False;
  }
  

  /* BJ return SetRFBSock(sock);*/
  return True;
}

/* BJ - TEMP
Bool SetRFBSock(int sock)
{
  try {
    rfbsock = sock;
    fis = new rdr::FdInStream(rfbsock, ProcessXtEvents);
    fos = new rdr::FdOutStream(rfbsock);

    struct sockaddr_in peeraddr, myaddr;
    VNC_SOCKLEN_T addrlen = sizeof(struct sockaddr_in);

    getpeername(sock, (struct sockaddr *)&peeraddr, &addrlen);
    getsockname(sock, (struct sockaddr *)&myaddr, &addrlen);

    sameMachine = (peeraddr.sin_addr.s_addr == myaddr.sin_addr.s_addr);

    return True;
  } catch (rdr::Exception& e) {
    fprintf(stderr,"initialiseInStream: %s\n",e.str());
  }
  return False;
}
*/

void StartTiming()
{
  /*fis->startTiming();*/
}

void StopTiming()
{
  /*fis->stopTiming();*/
}

int KbitsPerSecond()
{
  /* fprintf(stderr," kbps %d     \r",fis->kbitsPerSecond());
  return fis->kbitsPerSecond();*/
  return 30;
}

int TimeWaitedIn100us()
{
  /* return fis->timeWaited(); */
  return 1000;
}

Bool ReadFromRFBServer(char *out, unsigned int n)
{
  int status = 0;
  int result;
  int avail_bytes;
  int read_bytes = 0;
  int needed_bytes;

  /* Waiting for data */
  /*printf("WriteToRFBServer: Waiting for data (%d octets).\n",n);*/
  avail_bytes = 0;
  while (!avail_bytes) {
      tcp_tick(socket);
      avail_bytes = sock_dataready(socket);
  }
/*  printf("\tData presentes:%d octets dispo.\n",avail_bytes);*/

  while (read_bytes < n) {
      avail_bytes = sock_dataready(socket);
/*      printf("\t%d octets dispo.\n",avail_bytes);*/
      if (read_bytes + avail_bytes <= n) {
          needed_bytes = avail_bytes;
      } else {
          needed_bytes = n - read_bytes;
      }
/*      printf("\t%d octets necessaire.\n",needed_bytes);*/
      read_bytes += sock_read(socket,out + read_bytes,needed_bytes);
/*      printf("\t%d/%d Bytes recus\n",read_bytes,n);*/
  }
  return True;

sock_err:
  printf("Error dans ReadFromRFBServer(). Status=%d",status);
  return False;
}


/*
 * Write an exact number of bytes, and don't return until you've sent them.
 */
Bool WriteToRFBServer(char *buf, int n)
{
  int status = 0;
  int written_bytes = 0;
/*  printf("WriteToRFBServer: %d bytes a envoyer.\n",n);*/
  while (written_bytes < n) {
      written_bytes += sock_write(socket, buf + written_bytes, n - written_bytes);
/*      printf("\t%d/%d Bytes envoyes\n",written_bytes,n);*/
      if (written_bytes <= 0) {
/*          printf("Error a l ecriture. result = %d",written_bytes);*/
      }
  }

/*  printf("\t%d bytes envoyes au total.\n",written_bytes);*/
  return True;

sock_err:
  printf("Error dans WriteToRFBServer(). Status=%d",status);
  return False;
}

/*
 * ConnectToTcpAddr connects to the given host and port.
 */
Bool ConnectToTcpAddr(const char* hostname, int port)
{
  int localport;
  int status;
  
  int sock;
  struct sockaddr_in addr;
  longword host_ip;

  if (!StringToIPAddr(hostname, &host_ip)) {
    fprintf(stderr,"Couldn't convert '%s' to host address\n", hostname);
    return False;
  }
  localport = LOCALPORT;

  if (! tcp_open(socket,localport,host_ip,port,NULL)) {
    fprintf(stderr,"Couldn't open socket on port '%d'\n",port);
    return False;
  }

  sock_wait_established(socket, sock_delay, NULL, &status);

  return True;

sock_err:
   fprintf( stderr, "Socket Error:%d", status);
   return False;
}


/*
 * ListenAtTcpPort starts listening at the given TCP port.
 */
/* BJ - TEMP
int ListenAtTcpPort(int port)
{
  int sock;
  struct sockaddr_in addr;
  int one = 1;

  memset(&addr, 0, sizeof(addr));
  addr.sin_family = AF_INET;
  addr.sin_port = htons(port);
  addr.sin_addr.s_addr = INADDR_ANY;

  sock = socket(AF_INET, SOCK_STREAM, 0);
  if (sock < 0) {
    fprintf(stderr,programName);
    perror(": ListenAtTcpPort: socket");
    return -1;
  }

  if (setsockopt(sock, SOL_SOCKET, SO_REUSEADDR,
		 (const char *)&one, sizeof(one)) < 0) {
    fprintf(stderr,programName);
    perror(": ListenAtTcpPort: setsockopt");
    close(sock);
    return -1;
  }

  if (bind(sock, (struct sockaddr *)&addr, sizeof(addr)) < 0) {
    fprintf(stderr,programName);
    perror(": ListenAtTcpPort: bind");
    close(sock);
    return -1;
  }

  if (listen(sock, 5) < 0) {
    fprintf(stderr,programName);
    perror(": ListenAtTcpPort: listen");
    close(sock);
    return -1;
  }

  return sock;
}
*/


/*
 * AcceptTcpConnection accepts a TCP connection.
 */
/* BJ - TEMP
int AcceptTcpConnection(int listenSock)
{
  int sock;
  struct sockaddr_in addr;
  VNC_SOCKLEN_T addrlen = sizeof(addr);
  int one = 1;

  sock = accept(listenSock, (struct sockaddr *) &addr, &addrlen);
  if (sock < 0) {
    fprintf(stderr,programName);
    perror(": AcceptTcpConnection: accept");
    return -1;
  }

  if (setsockopt(sock, IPPROTO_TCP, TCP_NODELAY,
		 (char *)&one, sizeof(one)) < 0) {
    fprintf(stderr,programName);
    perror(": AcceptTcpConnection: setsockopt");
    close(sock);
    return -1;
  }

  return sock;
}
*/

/*
 * StringToIPAddr - convert a host string to an IP address.
 */
Bool StringToIPAddr(const char *str, longword *ip_addr)
{
  if (strcmp(str,"") == 0) {
    * ip_addr = 0; /* local */
    return True;
  }

  *ip_addr = resolve(str);
  if (*ip_addr) {
    return True;
  }

  return False;
}


/*
 * Print out the contents of a packet for debugging.
 */

void PrintInHex(char *buf, int len)
{
  int i, j;
  char c, str[17];

  str[16] = 0;

  fprintf(stderr,"ReadExact: ");

  for (i = 0; i < len; i++)
    {
      if ((i % 16 == 0) && (i != 0)) {
	fprintf(stderr,"           ");
      }
      c = buf[i];
      str[i % 16] = (((c > 31) && (c < 127)) ? c : '.');
      fprintf(stderr,"%02x ",(unsigned char)c);
      if ((i % 4) == 3)
	fprintf(stderr," ");
      if ((i % 16) == 15)
	{
	  fprintf(stderr,"%s\n",str);
	}
    }
  if ((i % 16) != 0)
    {
      for (j = i % 16; j < 16; j++)
	{
	  fprintf(stderr,"   ");
	  if ((j % 4) == 3) fprintf(stderr," ");
	}
      str[i % 16] = 0;
      fprintf(stderr,"%s\n",str);
    }

  fflush(stderr);
}

Bool isDataAvailable() {
  tcp_tick(socket);
  return sock_dataready(socket);
}
