#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <fcntl.h>
#include <io.h>

// #define DEBUG

int  nl = 0;
int  ll = 0;
char label[16] = ";rem;";
char infnam[256];
char inplin[256];
FILE *infil;
char expand = 0;

char helptext[] = "\n\
 INLINE 1.0 by Jrgen Hoffmann (2012) j_hoff@hrz1.hrz.tu-darmstadt.de\n\n\
 usage: inline [ options ] <filename> | <program>\n\n\
 valid options are:\n\
     /I<lbl> label to search for (default: \";rem;\")\n\
     /X      expand \"\\code\" and \"%%env%%\"\n\
     /H /?   write this help text\n\n\
 recognized codes:\n\
     \\a \\b \\f \\n \\r \\t \\v \\\\ (familiar \"C\" meaning)\n\
     \\e (escape character)        \\q (double quote)\n\
     \\xXX (hex byte)             \\0OOO (octal byte)\n\n\
 example:     \n\
     @echo off\n\
     rem d 0400:0,100\n\
     rem q\n\
     inline /irem %0 | debug\n\n";

void fatal_error(int arg, char *p) {
  fprintf(stderr,"\nERROR: ");
  switch(arg) {
    case  0: fprintf(stderr,"Out of memory   %s",p);                  break;
    case  1: fprintf(stderr,"No input file specified");               break;
    case  2: fprintf(stderr,"Cannot open input file: %s",p);          break;
    case  3: fprintf(stderr,"No label defined");                      break;
    case  4: fprintf(stderr,"No line found beginning with \"%s\"",p); break;
    }
  fprintf(stderr,"\n\nTry INLINE /? for usage hints\n\n");
  exit(3);
  }

void do_expand(char *f) {
  char *t, temp[40];
  while(*f) {
    if(*f=='\\') switch(toupper(*(++f))) {
      case 'A':  putc('\a',  stdout);  break;
      case 'B':  putc('\b',  stdout);  break;
      case 'E':  putc('\033',stdout);  break;
      case 'F':  putc('\f',  stdout);  break;
      case 'N':  putc('\n',  stdout);  break;
      case 'R':  putc('\r',  stdout);  break;
      case 'T':  putc('\t',  stdout);  break;
      case 'V':  putc('\v',  stdout);  break;
      case 'Q':  putc('"',   stdout);  break;
      case 'X':  if(isxdigit(f[1])&&isxdigit(f[2])) {
		   temp[0] = f[1];
		   temp[1] = f[2];
		   temp[2] = '\0';
		   putc(strtoul(temp,NULL,16)&0XFF,stdout);
		   f += 2;
		   }                   break;
      case '0':  t = temp;
		 while((*f>='0')&&(*f<='7')&&(t<&temp[sizeof(temp)-2])) *t++ = *f++;
		 *t = '\0';
		 putc(strtoul(temp,NULL,8)&0XFF,stdout);
		 f--;                  break;
      case '\\': putc('\\',  stdout);  break;
      }
    else if(*f=='%') {
      f++;
      if(*f=='%') putc('%',stdout);
      else {
	t = temp;
	while(*f&&(*f!='%')&&(t<&temp[sizeof(temp)-2])) *t++ = *f++;
	*t = '\0';
	t  = getenv(strupr(temp));
	if(t) printf("%s",t);
	}
      }
    else putc(*f,stdout);
    f++;
    }
  }

void main (int argc, char* argv[]) {
  int   i,j,k;
  char  *p, *q, ch;

  for(i=1; i < argc && ((*argv[i]=='/')||(*argv[i]=='-'));i++) {
    switch (toupper(argv[i][1])) {
      case 'I': if(argv[i][2]) strncpy(label,&argv[i][2],15); break;
      case 'X': expand = 1;                                   break;
      case 'H':
      case '?': printf(helptext);                           exit(2);
      }
    }
  if(i>=argc) fatal_error(1,NULL);
  ll = strlen(label);
  if(ll<1)    fatal_error(3,NULL);
  else strcpy(infnam,argv[i]);
  if((p=strrchr(infnam,'\\'))==NULL) p=strrchr(infnam,':');
  if(p==NULL) p = infnam; else p++;
  if(!strchr(p,'.')) strcat(infnam,".BAT");
  if(NULL==(infil=fopen(infnam,"r"))) fatal_error(2,infnam);
  else while(fgets(inplin,254,infil)) {
    if(!strncmp(inplin,label,ll)) {
      nl++;
      if(expand) do_expand(&inplin[ll]);
      else printf("%s",&inplin[ll]);
      }
    else if(nl) break;
    }
  if(nl<1) fatal_error(4,label);
  fclose(infil);
  exit(0);
  }
