; WINNT.INC--
;
; Some of the MS COFF declarations
; The full declarations can be found in MS PSDK, WinNT.h.
;

; Machine values
IMAGE_FILE_MACHINE_I386		equ 014ch	; Intel 386 or later processors
IMAGE_FILE_MACHINE_AMD64	equ 8664h	; AMD64 (K8)

; Characteristics flags
IMAGE_FILE_RELOCS_STRIPPED	equ 0001h	; no relocations
IMAGE_FILE_EXECUTABLE_IMAGE	equ 0002h	; is executable
IMAGE_FILE_LINE_NUMS_STRIPPED	equ 0004h	; no line number info
IMAGE_FILE_LOCAL_SYMS_STRIPPED	equ 0008h	; no local symbols
IMAGE_FILE_LARGE_ADDRESS_AWARE	equ 0020h	; App can handle >2gb addresses
IMAGE_FILE_32BIT_MACHINE	equ 0100h	; 32 bit word machine.

IMAGE_FILE_HEADER	STRUC
Machine			dw ?
NumberOfSections	dw ?
TimeDateStamp		dd ?
PointerToSymbolTable	dd ?
NumberOfSymbols		dd ?
SizeOfOptionalHeader	dw ?
Characteristics		dw ?
IMAGE_FILE_HEADER	ENDS

IMAGE_SIZEOF_SHORT_NAME		equ 8

IMAGE_SECTION_HEADER	STRUC
_Name			db IMAGE_SIZEOF_SHORT_NAME dup(?)
UNION
    PhysicalAddress	dd ?
    VirtualSize		dd ?
ENDS
VirtualAddress		dd ?
SizeOfRawData		dd ?
PointerToRawData	dd ?
PointerToRelocations	dd ?
PointerToLinenumbers	dd ?
NumberOfRelocations	dw ?
NumberOfLinenumbers	dw ?
Characteristics		dd ?
IMAGE_SECTION_HEADER	ENDS

IMAGE_NUMBEROF_DIRECTORY_ENTRIES equ 16

IMAGE_SCN_TYPE_REG	equ 0
IMAGE_SCN_TYPE_DSECT	equ 1
IMAGE_SCN_TYPE_NOLOAD	equ 2
IMAGE_SCN_TYPE_GROUP	equ 4
IMAGE_SCN_TYPE_NO_PAD	equ 8
IMAGE_SCN_TYPE_COPY	equ 16
IMAGE_SCN_CNT_CODE	equ 00000020h
IMAGE_SCN_CNT_INITIALIZED_DATA	 equ 00000040h
IMAGE_SCN_CNT_UNINITIALIZED_DATA equ 00000080h
IMAGE_SCN_LNK_OTHER	  equ 00000100h
IMAGE_SCN_LNK_INFO	  equ 00000200h
IMAGE_SCN_TYPE_OVER	  equ 00000400h
IMAGE_SCN_LNK_REMOVE	  equ 00000800h
IMAGE_SCN_LNK_COMDAT	  equ 00001000h
IMAGE_SCN_GPREL		  equ 00008000h /* Valid only for IA64 */
IMAGE_SCN_MEM_FARDATA	  equ 00008000h /* Not in PECOFF v8 spec */
IMAGE_SCN_MEM_PURGEABLE	  equ 00020000h
IMAGE_SCN_MEM_16BIT	  equ 00020000h
IMAGE_SCN_MEM_LOCKED	  equ 00040000h
IMAGE_SCN_MEM_PRELOAD	  equ 00080000h
IMAGE_SCN_ALIGN_1BYTES	  equ 00100000h
IMAGE_SCN_ALIGN_2BYTES	  equ 00200000h
IMAGE_SCN_ALIGN_4BYTES	  equ 00300000h
IMAGE_SCN_ALIGN_8BYTES	  equ 00400000h
IMAGE_SCN_ALIGN_16BYTES	  equ 00500000h
IMAGE_SCN_ALIGN_32BYTES	  equ 00600000h
IMAGE_SCN_ALIGN_64BYTES	  equ 00700000h
IMAGE_SCN_ALIGN_128BYTES  equ 00800000h
IMAGE_SCN_ALIGN_256BYTES  equ 00900000h
IMAGE_SCN_ALIGN_512BYTES  equ 00a00000h
IMAGE_SCN_ALIGN_1024BYTES equ 00b00000h
IMAGE_SCN_ALIGN_2048BYTES equ 00c00000h
IMAGE_SCN_ALIGN_4096BYTES equ 00d00000h
IMAGE_SCN_ALIGN_8192BYTES equ 00e00000h
IMAGE_SCN_LNK_NRELOC_OVFL equ 01000000h
IMAGE_SCN_MEM_DISCARDABLE equ 02000000h
IMAGE_SCN_MEM_NOT_CACHED  equ 04000000h
IMAGE_SCN_MEM_NOT_PAGED	  equ 08000000h
IMAGE_SCN_MEM_SHARED	  equ 10000000h
IMAGE_SCN_MEM_EXECUTE	  equ 20000000h
IMAGE_SCN_MEM_READ	  equ 40000000h
IMAGE_SCN_MEM_WRITE	  equ 80000000h

IMAGE_RELOCATION	STRUC
UNION
    VirtualAddress	dd ?
    RelocCount		dd ?
ENDS
SymbolTableIndex	dd ?
_Type			dw ?
IMAGE_RELOCATION	ENDS


IMAGE_REL_I386_ABSOLUTE equ 0000h ; relocation is ignored
IMAGE_REL_I386_DIR16	equ 0001h ; 16bit VA
IMAGE_REL_I386_REL16	equ 0002h ; 16bit PC-relative offset
IMAGE_REL_I386_DIR32	equ 0006h ; 32bit VA
IMAGE_REL_I386_DIR32NB	equ 0007h ; 32bit RVA (IMAGEREL)
IMAGE_REL_I386_SEG12	equ 0009h ; ???
IMAGE_REL_I386_SECTION	equ 000Ah ; 16bit section index
IMAGE_REL_I386_SECREL	equ 000Bh ; 32bit offset (SECTIONREL)
IMAGE_REL_I386_TOKEN	equ 000Ch ; CLR token
IMAGE_REL_I386_SECREL7	equ 000Dh ; 7bit offset
IMAGE_REL_I386_REL32	equ 0014h ; 32bit PC-relative offset

; X86-64 relocations

IMAGE_REL_AMD64_ABSOLUTE	equ 0000h ; Reference is absolute, no relocation is necessary */
IMAGE_REL_AMD64_ADDR64		equ 0001h ; 64-bit address (VA).*/
IMAGE_REL_AMD64_ADDR32		equ 0002h ; 32-bit address (VA).*/
IMAGE_REL_AMD64_ADDR32NB	equ 0003h ; 32-bit address w/o image base (RVA).*/
IMAGE_REL_AMD64_REL32		equ 0004h ; 32-bit relative address from byte following reloc */
IMAGE_REL_AMD64_REL32_1		equ 0005h ; 32-bit relative address from byte distance 1 from reloc */
IMAGE_REL_AMD64_REL32_2		equ 0006h ; 32-bit relative address from byte distance 2 from reloc */
IMAGE_REL_AMD64_REL32_3		equ 0007h ; 32-bit relative address from byte distance 3 from reloc */
IMAGE_REL_AMD64_REL32_4		equ 0008h ; 32-bit relative address from byte distance 4 from reloc */
IMAGE_REL_AMD64_REL32_5		equ 0009h ; 32-bit relative address from byte distance 5 from reloc */
IMAGE_REL_AMD64_SECTION		equ 000Ah ; Section index */
IMAGE_REL_AMD64_SECREL		equ 000Bh ; 32 bit offset from base of section containing target */
IMAGE_REL_AMD64_SECREL7		equ 000Ch ; 7 bit unsigned offset from base of section containing target */
IMAGE_REL_AMD64_TOKEN		equ 000Dh ; 32 bit metadata token */

IMAGE_SIZEOF_SYMBOL		equ 18
IMAGE_SIZEOF_AUX_SYMBOL		equ 18


IMAGE_SYMBOL		STRUC
UNION
    ShortName		db 8 dup(?)
    STRUC
	_Short		dd ?
	_Long		dd ?
    ENDS
    LongName		dd 2 dup(?)
ENDS
Value			dd ?
SectionNumber		dw ?
_Type			dw ?
StorageClass		db ?
NumberOfAuxSymbols	db ?
IMAGE_SYMBOL		ENDS

; special section numbers

IMAGE_SYM_UNDEFINED	equ 0
IMAGE_SYM_ABSOLUTE	equ -1
IMAGE_SYM_DEBUG		equ -2

IMAGE_SYM_TYPE_NULL	equ 0
IMAGE_SYM_TYPE_VOID	equ 1
IMAGE_SYM_TYPE_CHAR	equ 2
IMAGE_SYM_TYPE_SHORT	equ 3
IMAGE_SYM_TYPE_INT	equ 4
IMAGE_SYM_TYPE_LONG	equ 5
IMAGE_SYM_TYPE_FLOAT	equ 6
IMAGE_SYM_TYPE_DOUBLE	equ 7
IMAGE_SYM_TYPE_STRUCT	equ 8
IMAGE_SYM_TYPE_UNION	equ 9
IMAGE_SYM_TYPE_ENUM	equ 10
IMAGE_SYM_TYPE_MOE	equ 11
IMAGE_SYM_TYPE_BYTE	equ 12
IMAGE_SYM_TYPE_WORD	equ 13
IMAGE_SYM_TYPE_UINT	equ 14
IMAGE_SYM_TYPE_DWORD	equ 15
IMAGE_SYM_TYPE_PCODE	equ 32768

IMAGE_SYM_DTYPE_NULL	 equ 0
IMAGE_SYM_DTYPE_POINTER	 equ 1
IMAGE_SYM_DTYPE_FUNCTION equ 2
IMAGE_SYM_DTYPE_ARRAY	 equ 3

; StorageClass values

IMAGE_SYM_CLASS_END_OF_FUNCTION		equ -1
IMAGE_SYM_CLASS_NULL			equ 0
IMAGE_SYM_CLASS_AUTOMATIC		equ 1
IMAGE_SYM_CLASS_EXTERNAL		equ 2
IMAGE_SYM_CLASS_STATIC			equ 3
IMAGE_SYM_CLASS_REGISTER		equ 4
IMAGE_SYM_CLASS_EXTERNAL_DEF		equ 5
IMAGE_SYM_CLASS_LABEL			equ 6
IMAGE_SYM_CLASS_UNDEFINED_LABEL		equ 7
IMAGE_SYM_CLASS_MEMBER_OF_STRUCT	equ 8
IMAGE_SYM_CLASS_ARGUMENT		equ 9
IMAGE_SYM_CLASS_STRUCT_TAG		equ 10
IMAGE_SYM_CLASS_MEMBER_OF_UNION		equ 11
IMAGE_SYM_CLASS_UNION_TAG		equ 12
IMAGE_SYM_CLASS_TYPE_DEFINITION		equ 13
IMAGE_SYM_CLASS_UNDEFINED_STATIC	equ 14
IMAGE_SYM_CLASS_ENUM_TAG		equ 15
IMAGE_SYM_CLASS_MEMBER_OF_ENUM		equ 16
IMAGE_SYM_CLASS_REGISTER_PARAM		equ 17
IMAGE_SYM_CLASS_BIT_FIELD		equ 18
IMAGE_SYM_CLASS_FAR_EXTERNAL		equ 68 ; Not in PECOFF v8 spec
IMAGE_SYM_CLASS_BLOCK			equ 100
IMAGE_SYM_CLASS_FUNCTION		equ 101
IMAGE_SYM_CLASS_END_OF_STRUCT		equ 102
IMAGE_SYM_CLASS_FILE			equ 103
IMAGE_SYM_CLASS_SECTION			equ 104
IMAGE_SYM_CLASS_WEAK_EXTERNAL		equ 105
IMAGE_SYM_CLASS_CLR_TOKEN		equ 107

; values for IMAGE_AUX_SYMBOL.Section.Selection
IMAGE_COMDAT_SELECT_NODUPLICATES	equ 1
IMAGE_COMDAT_SELECT_ANY			equ 2
IMAGE_COMDAT_SELECT_SAME_SIZE		equ 3
IMAGE_COMDAT_SELECT_EXACT_MATCH		equ 4
IMAGE_COMDAT_SELECT_ASSOCIATIVE		equ 5
IMAGE_COMDAT_SELECT_LARGEST		equ 6
IMAGE_COMDAT_SELECT_NEWEST		equ 7

; values for IMAGE_AUX_SYMBOL.Sym.Characteristics(=TotalSize)
IMAGE_WEAK_EXTERN_SEARCH_NOLIBRARY	equ 1
IMAGE_WEAK_EXTERN_SEARCH_LIBRARY	equ 2
IMAGE_WEAK_EXTERN_SEARCH_ALIAS		equ 3

IMAGE_AUX_SYMBOL	UNION
;
; AUX format 2: .bf and .ef entries
;
STRUC
 TagIndex		dd ?
 UNION
  STRUC
    Linenumber		dw ?
    _Size		dw ?
  ENDS
  TotalSize		dd ?
 ENDS
 UNION
  STRUC
   PointerToLinenumber	dd ?
   PointerToNextFunction dd ?
  ENDS
  Dimension		dw 4 dup(?)
 ENDS
 TvIndex		dw ?
ENDS
;
; AUX format 4: file entries
;
STRUC
 _Name			db IMAGE_SIZEOF_SYMBOL dup(?)
ENDS
;
; AUX format 5: section entries
;
STRUC
 _Length		dd ?
 NumberOfRelocations	dw ?
 NumberOfLinenumbers	dw ?
 CheckSum		dd ?
 Number			dw ?
 Selection		db ?
ENDS
IMAGE_AUX_SYMBOL	ENDS


IMAGE_COFF_SYMBOLS_HEADER STRUC
NumberOfSymbols		dd ?
LvaToFirstSymbol	dd ?
NumberOfLinenumbers	dd ?
LvaToFirstLinenumber	dd ?
RvaToFirstByteOfCode	dd ?
RvaToLastByteOfCode	dd ?
RvaToFirstByteOfData	dd ?
RvaToLastByteOfData	dd ?
IMAGE_COFF_SYMBOLS_HEADER ENDS


IMAGE_LINENUMBER	STRUC
UNION
    SymbolTableIndex	dd ?
    VirtualAddress	dd ?
ENDS
Linenumber		dw ?
IMAGE_LINENUMBER	ENDS

