#include <math.h>
#include <string.h>

#define LUA_COMPAT_ALL
#include "../src/lauxlib.h"

static double compute_sin(const double x)
{
  return sin(x);
}

static double compute_cos(const double x)
{
  return cos(x);
}

static int compute_trig_function(lua_State *L)
{
  const double argument = lua_tonumber(L, 1);
  const char *selected_function = lua_tostring(L, 2);
  double result;

  if (strcmp(selected_function, "sin") == 0)
    result = compute_sin(argument);
  else if (strcmp(selected_function, "cos") == 0)
    result = compute_cos(argument);
  else
    return 0;

  lua_pushnumber(L, result);

  return 1;  /* One element returned on stack. */
}

static const struct luaL_Reg djgpp_DXE3_lib[] = {
  {"compute_trig_function", compute_trig_function},
  {NULL, NULL}
};

int luaopen_libtest2(lua_State *L)
{
#if 1
  /*  Deprecated since 5.2.0.  Available if Lua is compiled with LUA_COMPAT_MODULE.  */
  luaL_register(L, "djgpp_DXE3_lib", djgpp_DXE3_lib);  /* Register all functions belonging to djgpp_DXE3_lib module. */
#else
#if 0
  luaL_newlib(L, djgpp_DXE3_lib);  /* Register all functions belonging to djgpp_DXE3_lib module. */
#else
  // get global table onto the stack
  lua_pushglobaltable(L);
  // populate the table on top of the stack with module functions
  luaL_setfuncs(L, djgpp_DXE3_lib, 0);
  // since we don't have a module table, don't return anything
  // require() will return true instead
  return 0;
#endif
#endif
  return 1;
}
