/*
 *  d3d9caps.h  Direct3D 9 capabilities
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2010 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _d3d9CAPS_H
#define _d3d9CAPS_H

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* Direct3D version number */
#ifndef DIRECT3D_VERSION
    #define DIRECT3D_VERSION    0x0900
#endif

/* Direct3D vertex shader capabilities constants */
#define D3DVS20CAPS_PREDICATION             0x00000001L
#define D3DVS20_MAX_DYNAMICFLOWCONTROLDEPTH 24
#define D3DVS20_MIN_DYNAMICFLOWCONTROLDEPTH 0
#define D3DVS20_MAX_NUMTEMPS                32
#define D3DVS20_MIN_NUMTEMPS                12
#define D3DVS20_MAX_STATICFLOWCONTROLDEPTH  4
#define D3DVS20_MIN_STATICFLOWCONTROLDEPTH  1

/* Direct3D pixel shader capabilities constants */
#define D3DPS20CAPS_ARBITRARYSWIZZLE        0x00000001L
#define D3DPS20CAPS_GRADIENTINSTRUCTIONS    0x00000002L
#define D3DPS20CAPS_PREDICATION             0x00000004L
#define D3DPS20CAPS_NODEPENDENTREADLIMIT    0x00000008L
#define D3DPS20CAPS_NOTEXINSTRUCTIONLIMIT   0x00000010L
#define D3DPS20_MAX_DYNAMICFLOWCONTROLDEPTH 24
#define D3DPS20_MIN_DYNAMICFLOWCONTROLDEPTH 0
#define D3DPS20_MAX_NUMTEMPS                32
#define D3DPS20_MIN_NUMTEMPS                12
#define D3DPS20_MAX_STATICFLOWCONTROLDEPTH  4
#define D3DPS20_MIN_STATICFLOWCONTROLDEPTH  0
#define D3DPS20_MAX_NUMINSTRUCTIONSLOTS     512
#define D3DPS20_MIN_NUMINSTRUCTIONSLOTS     96

/* Direct3D shader instruction bounds */
#define D3DMIN30SHADERINSTRUCTIONS  512
#define D3DMAX30SHADERINSTRUCTIONS  32768

/* Direct3D overlay capability flags */
#define D3DOVERLAYCAPS_FULLRANGERGB         0x00000001
#define D3DOVERLAYCAPS_LIMITEDRANGERGB      0x00000002
#define D3DOVERLAYCAPS_YCbCr_BT601          0x00000004
#define D3DOVERLAYCAPS_YCbCr_BT709          0x00000008
#define D3DOVERLAYCAPS_YCbCr_BT601_xvYCC    0x00000010
#define D3DOVERLAYCAPS_YCbCr_BT709_xvYCC    0x00000020
#define D3DOVERLAYCAPS_STRETCHX             0x00000040
#define D3DOVERLAYCAPS_STRETCHY             0x00000080

/* Direct3D content protection capability flags */
#define D3DCPCAPS_SOFTWARE              0x00000001L
#define D3DCPCAPS_HARDWARE              0x00000002L
#define D3DCPCAPS_PROTECTIONALWAYSON    0x00000004L
#define D3DCPCAPS_PARTIALDECRYPTION     0x00000008L
#define D3DCPCAPS_CONTENTKEY            0x00000010L
#define D3DCPCAPS_FRESHENSESSIONKEY     0x00000020L
#define D3DCPCAPS_ENCRYPTEDREADBACK     0x00000040L
#define D3DCPCAPS_ENCRYPTEDREADBACKKEY  0x00000080L
#define D3DCPCAPS_SEQUENTIAL_CTR_IV     0x00000100L
#define D3DCPCAPS_ENCRYPTSLICEDATAONLY  0x00000200L

/* Direct3D capability flags */
#define D3DCAPS_OVERLAY         0x00000800L
#define D3DCAPS_READ_SCANLINE   0x00020000L

/* Direct3D capability flags (level 2) */
#define D3DCAPS2_FULLSCREENGAMMA        0x00020000L
#define D3DCAPS2_CANCALIBRATEGAMMA      0x00100000L
#define D3DCAPS2_CANMANAGERESOURCE      0x10000000L
#define D3DCAPS2_DYNAMICTEXTURES        0x20000000L
#define D3DCAPS2_CANAUTOGENMIPMAP       0x40000000L
#ifndef D3D_DISABLE_9EX
    #define D3DCAPS2_CANSHARERESOURCE   0x80000000L
#endif

/* Direct3D capability flags (level 3) */
#define D3DCAPS3_ALPHA_FULLSCREEN_FLIP_OR_DISCARD   0x00000020L
#define D3DCAPS3_LINEAR_TO_SRGB_PRESENTATION        0x00000080L
#define D3DCAPS3_COPY_TO_VIDMEM                     0x00000100L
#define D3DCAPS3_COPY_TO_SYSTEMMEM                  0x00000200L
#define D3DCAPS3_DXVAHD                             0x00000400L

/* Direct3D presentation intervals */
#define D3DPRESENT_INTERVAL_DEFAULT     0x00000000L
#define D3DPRESENT_INTERVAL_ONE         0x00000001L
#define D3DPRESENT_INTERVAL_TWO         0x00000002L
#define D3DPRESENT_INTERVAL_THREE       0x00000004L
#define D3DPRESENT_INTERVAL_FOUR        0x00000008L
#define D3DPRESENT_INTERVAL_IMMEDIATE   0x80000000L

/* Direct3D cursor capability flags */
#define D3DCURSORCAPS_COLOR     0x00000001L
#define D3DCURSORCAPS_LOWRES    0x00000002L

/* Direct3D device capability flags */
#define D3DDEVCAPS_EXECUTESYSTEMMEMORY      0x00000010L
#define D3DDEVCAPS_EXECUTEVIDEOMEMORY       0x00000020L
#define D3DDEVCAPS_TLVERTEXSYSTEMMEMORY     0x00000040L
#define D3DDEVCAPS_TLVERTEXVIDEOMEMORY      0x00000080L
#define D3DDEVCAPS_TEXTURESYSTEMMEMORY      0x00000100L
#define D3DDEVCAPS_TEXTUREVIDEOMEMORY       0x00000200L
#define D3DDEVCAPS_DRAWPRIMTLVERTEX         0x00000400L
#define D3DDEVCAPS_CANRENDERAFTERFLIP       0x00000800L
#define D3DDEVCAPS_TEXTURENONLOCALVIDMEM    0x00001000L
#define D3DDEVCAPS_DRAWPRIMITIVES2          0x00002000L
#define D3DDEVCAPS_SEPARATETEXTUREMEMORIES  0x00004000L
#define D3DDEVCAPS_DRAWPRIMITIVES2EX        0x00008000L
#define D3DDEVCAPS_HWTRANSFORMANDLIGHT      0x00010000L
#define D3DDEVCAPS_CANBLTSYSTONONLOCAL      0x00020000L
#define D3DDEVCAPS_HWRASTERIZATION          0x00080000L
#define D3DDEVCAPS_PUREDEVICE               0x00100000L
#define D3DDEVCAPS_QUINTICRTPATCHES         0x00200000L
#define D3DDEVCAPS_RTPATCHES                0x00400000L
#define D3DDEVCAPS_RTPATCHHANDLEZERO        0x00800000L
#define D3DDEVCAPS_NPATCHES                 0x01000000L

/* Direct3D primitive miscellaneous capability flags */
#define D3DPMISCCAPS_MASKZ                      0x00000002L
#define D3DPMISCCAPS_CULLNONE                   0x00000010L
#define D3DPMISCCAPS_CULLCW                     0x00000020L
#define D3DPMISCCAPS_CULLCCW                    0x00000040L
#define D3DPMISCCAPS_COLORWRITEENABLE           0x00000080L
#define D3DPMISCCAPS_CLIPPLANESCALEDPOINTS      0x00000100L
#define D3DPMISCCAPS_CLIPTLVERTS                0x00000200L
#define D3DPMISCCAPS_TSSARGTEMP                 0x00000400L
#define D3DPMISCCAPS_BLENDOP                    0x00000800L
#define D3DPMISCCAPS_NULLREFERENCE              0x00001000L
#define D3DPMISCCAPS_INDEPENDENTWRITEMASKS      0x00004000L
#define D3DPMISCCAPS_PERSTAGECONSTANT           0x00008000L
#define D3DPMISCCAPS_FOGANDSPECULARALPHA        0x00010000L
#define D3DPMISCCAPS_SEPARATEALPHABLEND         0x00020000L
#define D3DPMISCCAPS_MRTINDEPENDENTBITDEPTHS    0x00040000L
#define D3DPMISCCAPS_MRTPOSTPIXELSHADERBLENDING 0x00080000L
#define D3DPMISCCAPS_FOGVERTEXCLAMPED           0x00100000L
#ifndef D3D_DISABLE_9EX
    #define D3DPMISCCAPS_POSTBLENDSRGBCONVERT   0x00200000L
#endif

/* Direct3D line capability flags */
#define D3DLINECAPS_TEXTURE     0x00000001L
#define D3DLINECAPS_ZTEST       0x00000002L
#define D3DLINECAPS_BLEND       0x00000004L
#define D3DLINECAPS_ALPHACMP    0x00000008L
#define D3DLINECAPS_FOG         0x00000010L
#define D3DLINECAPS_ANTIALIAS   0x00000020L

/* Direct3D raster capability flags */
#define D3DPRASTERCAPS_DITHER               0x00000001L
#define D3DPRASTERCAPS_ZTEST                0x00000010L
#define D3DPRASTERCAPS_FOGVERTEX            0x00000080L
#define D3DPRASTERCAPS_FOGTABLE             0x00000100L
#define D3DPRASTERCAPS_MIPMAPLODBIAS        0x00002000L
#define D3DPRASTERCAPS_ZBUFFERLESSHSR       0x00008000L
#define D3DPRASTERCAPS_FOGRANGE             0x00010000L
#define D3DPRASTERCAPS_ANISOTROPY           0x00020000L
#define D3DPRASTERCAPS_WBUFFER              0x00040000L
#define D3DPRASTERCAPS_WFOG                 0x00100000L
#define D3DPRASTERCAPS_ZFOG                 0x00200000L
#define D3DPRASTERCAPS_COLORPERSPECTIVE     0x00400000L
#define D3DPRASTERCAPS_SCISSORTEST          0x01000000L
#define D3DPRASTERCAPS_SLOPESCALEDEPTHBIAS  0x02000000L
#define D3DPRASTERCAPS_DEPTHBIAS            0x04000000L
#define D3DPRASTERCAPS_MULTISAMPLE_TOGGLE   0x08000000L

/* Direct3D comparison capability flags */
#define D3DPCMPCAPS_NEVER           0x00000001L
#define D3DPCMPCAPS_LESS            0x00000002L
#define D3DPCMPCAPS_EQUAL           0x00000004L
#define D3DPCMPCAPS_LESSEQUAL       0x00000008L
#define D3DPCMPCAPS_GREATER         0x00000010L
#define D3DPCMPCAPS_NOTEQUAL        0x00000020L
#define D3DPCMPCAPS_GREATEREQUAL    0x00000040L
#define D3DPCMPCAPS_ALWAYS          0x00000080L

/* Direct3D blend capabilities */
#define D3DPBLENDCAPS_ZERO              0x00000001L
#define D3DPBLENDCAPS_ONE               0x00000002L
#define D3DPBLENDCAPS_SRCCOLOR          0x00000004L
#define D3DPBLENDCAPS_INVSRCCOLOR       0x00000008L
#define D3DPBLENDCAPS_SRCALPHA          0x00000010L
#define D3DPBLENDCAPS_INVSRCALPHA       0x00000020L
#define D3DPBLENDCAPS_DESTALPHA         0x00000040L
#define D3DPBLENDCAPS_INVDESTALPHA      0x00000080L
#define D3DPBLENDCAPS_DESTCOLOR         0x00000100L
#define D3DPBLENDCAPS_INVDESTCOLOR      0x00000200L
#define D3DPBLENDCAPS_SRCALPHASAT       0x00000400L
#define D3DPBLENDCAPS_BOTHSRCALPHA      0x00000800L
#define D3DPBLENDCAPS_BOTHINVSRCALPHA   0x00001000L
#define D3DPBLENDCAPS_BLENDFACTOR       0x00002000L
#ifndef D3D_DISABLE_9EX
    #define D3DPBLENDCAPS_SRCCOLOR2     0x00004000L
    #define D3DPBLENDCAPS_INVSRCCOLOR2  0x00008000L
#endif

/* Direct3D shade capability flags */
#define D3DPSHADECAPS_COLORGOURAUDRGB       0x00000008L
#define D3DPSHADECAPS_SPECULARGOURAUDRGB    0x00000200L
#define D3DPSHADECAPS_ALPHAGOURAUDBLEND     0x00004000L
#define D3DPSHADECAPS_FOGGOURAUD            0x00080000L

/* Direct3D texture capability flags */
#define D3DPTEXTURECAPS_PERSPECTIVE                 0x00000001L
#define D3DPTEXTURECAPS_POW2                        0x00000002L
#define D3DPTEXTURECAPS_ALPHA                       0x00000004L
#define D3DPTEXTURECAPS_SQUAREONLY                  0x00000020L
#define D3DPTEXTURECAPS_TEXREPEATNOTSCALEDBYSIZE    0x00000040L
#define D3DPTEXTURECAPS_ALPHAPALETTE                0x00000080L
#define D3DPTEXTURECAPS_NONPOW2CONDITIONAL          0x00000100L
#define D3DPTEXTURECAPS_PROJECTED                   0x00000400L
#define D3DPTEXTURECAPS_CUBEMAP                     0x00000800L
#define D3DPTEXTURECAPS_VOLUMEMAP                   0x00002000L
#define D3DPTEXTURECAPS_MIPMAP                      0x00004000L
#define D3DPTEXTURECAPS_MIPVOLUMEMAP                0x00008000L
#define D3DPTEXTURECAPS_MIPCUBEMAP                  0x00010000L
#define D3DPTEXTURECAPS_CUBEMAP_POW2                0x00020000L
#define D3DPTEXTURECAPS_VOLUMEMAP_POW2              0x00040000L
#define D3DPTEXTURECAPS_NOPROJECTEDBUMPENV          0x00200000L

/* Direct3D texture filter capability flags */
#define D3DPTFILTERCAPS_MINFPOINT           0x00000100L
#define D3DPTFILTERCAPS_MINFLINEAR          0x00000200L
#define D3DPTFILTERCAPS_MINFANISOTROPIC     0x00000400L
#define D3DPTFILTERCAPS_MINFPYRAMIDALQUAD   0x00000800L
#define D3DPTFILTERCAPS_MINFGAUSSIANQUAD    0x00001000L
#define D3DPTFILTERCAPS_MIPFPOINT           0x00010000L
#define D3DPTFILTERCAPS_MIPFLINEAR          0x00020000L
#ifndef D3D_DISABLE_9EX
    #define D3DPTFILTERCAPS_CONVOLUTIONMONO 0x00040000L
#endif
#define D3DPTFILTERCAPS_MAGFPOINT           0x01000000L
#define D3DPTFILTERCAPS_MAGFLINEAR          0x02000000L
#define D3DPTFILTERCAPS_MAGFANISOTROPIC     0x04000000L
#define D3DPTFILTERCAPS_MAGFPYRAMIDALQUAD   0x08000000L
#define D3DPTFILTERCAPS_MAGFGAUSSIANQUAD    0x10000000L

/* Direct3D texture address capability flags */
#define D3DPTADDRESSCAPS_WRAP           0x00000001L
#define D3DPTADDRESSCAPS_MIRROR         0x00000002L
#define D3DPTADDRESSCAPS_CLAMP          0x00000004L
#define D3DPTADDRESSCAPS_BORDER         0x00000008L
#define D3DPTADDRESSCAPS_INDEPENDENTUV  0x00000010L
#define D3DPTADDRESSCAPS_MIRRORONCE     0x00000020L

/* Direct3D stencil capability flags */
#define D3DSTENCILCAPS_KEEP     0x00000001L
#define D3DSTENCILCAPS_ZERO     0x00000002L
#define D3DSTENCILCAPS_REPLACE  0x00000004L
#define D3DSTENCILCAPS_INCRSAT  0x00000008L
#define D3DSTENCILCAPS_DECRSAT  0x00000010L
#define D3DSTENCILCAPS_INVERT   0x00000020L
#define D3DSTENCILCAPS_INCR     0x00000040L
#define D3DSTENCILCAPS_DECR     0x00000080L
#define D3DSTENCILCAPS_TWOSIDED 0x00000100L

/* Direct3D texture operation capability flags */
#define D3DTEXOPCAPS_DISABLE                    0x00000001L
#define D3DTEXOPCAPS_SELECTARG1                 0x00000002L
#define D3DTEXOPCAPS_SELECTARG2                 0x00000004L
#define D3DTEXOPCAPS_MODULATE                   0x00000008L
#define D3DTEXOPCAPS_MODULATE2X                 0x00000010L
#define D3DTEXOPCAPS_MODULATE4X                 0x00000020L
#define D3DTEXOPCAPS_ADD                        0x00000040L
#define D3DTEXOPCAPS_ADDSIGNED                  0x00000080L
#define D3DTEXOPCAPS_ADDSIGNED2X                0x00000100L
#define D3DTEXOPCAPS_SUBTRACT                   0x00000200L
#define D3DTEXOPCAPS_ADDSMOOTH                  0x00000400L
#define D3DTEXOPCAPS_BLENDDIFFUSEALPHA          0x00000800L
#define D3DTEXOPCAPS_BLENDTEXTUREALPHA          0x00001000L
#define D3DTEXOPCAPS_BLENDFACTORALPHA           0x00002000L
#define D3DTEXOPCAPS_BLENDTEXTUREALPHAPM        0x00004000L
#define D3DTEXOPCAPS_BLENDCURRENTALPHA          0x00008000L
#define D3DTEXOPCAPS_PREMODULATE                0x00010000L
#define D3DTEXOPCAPS_MODULATEALPHA_ADDCOLOR     0x00020000L
#define D3DTEXOPCAPS_MODULATECOLOR_ADDALPHA     0x00040000L
#define D3DTEXOPCAPS_MODULATEINVALPHA_ADDCOLOR  0x00080000L
#define D3DTEXOPCAPS_MODULATEINVCOLOR_ADDALPHA  0x00100000L
#define D3DTEXOPCAPS_BUMPENVMAP                 0x00200000L
#define D3DTEXOPCAPS_BUMPENVMAPLUMINANCE        0x00400000L
#define D3DTEXOPCAPS_DOTPRODUCT3                0x00800000L
#define D3DTEXOPCAPS_MULTIPLYADD                0x01000000L
#define D3DTEXOPCAPS_LERP                       0x02000000L

/* Direct3D FVF capability flags */
#define D3DFVFCAPS_TEXCOORDCOUNTMASK    0x0000FFFFL
#define D3DFVFCAPS_DONOTSTRIPELEMENTS   0x00080000L
#define D3DFVFCAPS_PSIZE                0x00100000L

/* Direct3D vertex processing capability flags */
#define D3DVTXPCAPS_TEXGEN                      0x00000001L
#define D3DVTXPCAPS_MATERIALSOURCE7             0x00000002L
#define D3DVTXPCAPS_DIRECTIONALLIGHTS           0x00000008L
#define D3DVTXPCAPS_POSITIONALLIGHTS            0x00000010L
#define D3DVTXPCAPS_LOCALVIEWER                 0x00000020L
#define D3DVTXPCAPS_TWEENING                    0x00000040L
#define D3DVTXPCAPS_TEXGEN_SPHEREMAP            0x00000100L
#define D3DVTXPCAPS_NO_TEXGEN_NONLOCALVIEWER    0x00000200L

/* Direct3D device capability flags (level 2) */
#define D3DDEVCAPS2_STREAMOFFSET                        0x00000001L
#define D3DDEVCAPS2_DMAPNPATCH                          0x00000002L
#define D3DDEVCAPS2_ADAPTIVETESSRTPATCH                 0x00000004L
#define D3DDEVCAPS2_ADAPTIVETESSNPATCH                  0x00000008L
#define D3DDEVCAPS2_CAN_STRETCHRECT_FROM_TEXTURES       0x00000010L
#define D3DDEVCAPS2_PRESAMPLEDDMAPNPATCH                0x00000020L
#define D3DDEVCAPS2_VERTEXELEMENTSCANSHARESTREAMOFFSET  0x00000040L

/* Direct3D declaration type capability flags */
#define D3DDTCAPS_UBYTE4    0x00000001L
#define D3DDTCAPS_UBYTE4N   0x00000002L
#define D3DDTCAPS_SHORT2N   0x00000004L
#define D3DDTCAPS_SHORT4N   0x00000008L
#define D3DDTCAPS_USHORT2N  0x00000010L
#define D3DDTCAPS_USHORT4N  0x00000020L
#define D3DDTCAPS_UDEC3     0x00000040L
#define D3DDTCAPS_DEC3N     0x00000080L
#define D3DDTCAPS_FLOAT16_2 0x00000100L
#define D3DDTCAPS_FLOAT16_4 0x00000200L

/* Direct3D vertex shader capabilities */
typedef struct _D3DVSHADERCAPS2_0 {
    DWORD   Caps;
    INT     DynamicFlowControlDepth;
    INT     NumTemps;
    INT     StaticFlowControlDepth;
} D3DVSHADERCAPS2_0;

/* Direct3D pixel shader capabilities */
typedef struct _D3DPSHADERCAPS2_0 {
    DWORD   Caps;
    INT     DynamicFlowControlDepth;
    INT     NumTemps;
    INT     StaticFlowControlDepth;
    INT     NumInstructionSlots;
} D3DPSHADERCAPS2_0;

/* Direct3D overlay capabilities */
typedef struct _D3DOVERLAYCAPS {
    UINT    Caps;
    UINT    MaxOverlayDisplayWidth;
    UINT    MaxOverlayDisplayHeight;
} D3DOVERLAYCAPS;

/* Direct3D content protection capabilities */
typedef struct _D3DCONTENTPROTECTIONCAPS {
    DWORD       Caps;
    GUID        KeyExchangeType;
    UINT        BufferAlignmentStart;
    UINT        BlockAlignmentStart;
    ULONGLONG   ProtectedMemorySize;
} D3DCONTENTPROTECTIONCAPS;

/* Direct3D capabilites */
typedef struct _D3DCAPS9 {
    D3DDEVTYPE  DeviceType;
    UINT        AdapterOriginal;
    DWORD       Caps;
    DWORD       Caps2;
    DWORD       Caps3;
    DWORD       PresentationIntervals;
    DWORD       CursorCaps;
    DWORD       DevCaps;
    DWORD       PrimitiveMiscCaps;
    DWORD       RasterCaps;
    DWORD       ZCmpCaps;
    DWORD       SrcBlendCaps;
    DWORD       DestBlendCaps;
    DWORD       AlphaCmpCaps;
    DWORD       ShadeCaps;
    DWORD       TextureCaps;
    DWORD       TextureFilterCaps;
    DWORD       CubeTextureFilterCaps;
    DWORD       VolumeTextureFilterCaps;
    DWORD       TextureAddressCaps;
    DWORD       VolumeTextureAddressCaps;
    DWORD       LineCaps;
    DWORD       MaxTextureWidth;
    DWORD       MaxTextureHeight;
    DWORD       MaxVolumeExtent;
    DWORD       MaxTextureRepeat;
    DWORD       MaxTextureAspectRatio;
    DWORD       MaxAnisotropy;
    float       MaxVertexW;
    float       GuardBandLeft;
    float       GuardBandTop;
    float       GuardBandRight;
    float       GuardBandBottom;
    float       ExtendsAdjust;
    DWORD       StencilCaps;
    DWORD       FVFCaps;
    DWORD       TextureOpCaps;
    DWORD       MaxTextureBlendStages;
    DWORD       MaxSimultaneousTextures;
    DWORD       VertexProcessingCaps;
    DWORD       MaxActiveLights;
    DWORD       MaxUserClipPlanes;
    DWORD       MaxVertexBlendMatrices;
    DWORD       MaxVertexBlendMatrixIndex;
    float       MaxPointSize;
    DWORD       MaxPrimitiveCount;
    DWORD       MaxVertexIndex;
    DWORD       MaxStreams;
    DWORD       MaxStreamStride;
    DWORD       VertexShaderVersion;
    DWORD       MaxVertexShaderConst;
    DWORD       PixelShaderVersion;
    float       PixelShader1xMaxValue;
    DWORD       DevCaps2;
    float       MaxNpatchTessellationLevel;
    DWORD       Reserved5;
    UINT        MasterAdapterOrdinal;
    UINT        AdapterOrdinalInGroup;
    UINT        NumberOfAdaptersInGroup;
    DWORD       DeclTypes;
    DWORD       NumSimultaneousRTs;
    DWORD       StretchRectFilterCaps;
    D3DVSHADERCAPS2_0   VS20Caps;
    D3DPSHADERCAPS2_0   PS20Caps;
    DWORD       VertexTextureFilterCaps;
    DWORD       MaxVShaderInstructionsExecuted;
    DWORD       MaxPShaderInstructionsExecuted;
    DWORD       MaxVertexShader30InstructionSlots;
    DWORD       MaxPixelShader30InstructionSlots;
} D3DCAPS9;

/* GUIDs */
EXTERN_C const GUID D3DCRYPTOTYPE_AES128_CTR;
EXTERN_C const GUID D3DCRYPTOTYPE_PROPRIETARY;
EXTERN_C const GUID D3DKEYEXCHANGE_RSAES_OAEP;
EXTERN_C const GUID D3DKEYEXCHANGE_DXVA;

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _d3d9CAPS_H */
