/*
 *  ksmedia.h   Kernel streaming media definitions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2010 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _KSMEDIA_
#define _KSMEDIA_

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* Kernel streaming primitive data types */
typedef BOOL        KSPROPERTY_COMPOSIT_ON;
typedef BOOL        *PKSPROPERTY_COMPOSIT_ON;
typedef LONGLONG    REFERENCE_TIME;
typedef LONG        KS_AM_MaxFullDataRate;
typedef DWORD       KS_AM_Step;

/* Wave format special value */
#if defined( _INC_MMSYSTEM ) && !defined( _INC_MMREG )
    #define WAVE_FORMAT_EXTENSIBLE  0xFFFE
#endif

/* Kernel streaming DirectSound buffer flags */
#define KSDSOUND_BUFFER_PRIMARY     0x00000001L
#define KSDSOUND_BUFFER_STATIC      0x00000002L
#define KSDSOUND_BUFFER_LOCHARDWARE 0x00000004L
#define KSDSOUND_BUFFER_LOCSOFTWARE 0x00000008L

/* Kernel streaming DirectSound buffer control flags */
#define KSDSOUND_BUFFER_CTRL_3D             0x00000001L
#define KSDSOUND_BUFFER_CTRL_FREQUENCY      0x00000002L
#define KSDSOUND_BUFFER_CTRL_PAN            0x00000004L
#define KSDSOUND_BUFFER_CTRL_VOLUME         0x00000008L
#define KSDSOUND_BUFFER_CTRL_POSITIONNOTIFY 0x00000010L

/* Kernel streaming audio stereo speaker geometry values */
#define KSAUDIO_STEREO_SPEAKER_GEOMETRY_HEADPHONE   (-1)
#define KSAUDIO_STEREO_SPEAKER_GEOMETRY_MIN         5
#define KSAUDIO_STEREO_SPEAKER_GEOMETRY_NARROW      10
#define KSAUDIO_STEREO_SPEAKER_GEOMETRY_WIDE        20
#define KSAUDIO_STEREO_SPEAKER_GEOMETRY_MAX         180

/* Kernel streaming DirectSound3D modes */
#define KSDSOUND_3D_MODE_NORMAL         0x00000000L
#define KSDSOUND_3D_MODE_HEADRELATIVE   0x00000001L
#define KSDSOUND_3D_MODE_DISABLE        0x00000002L

/* Kernel streaming DirectSound control flags */
#define KSDSOUND_BUFFER_CTRL_HRTF_3D    0x40000000L

/* Kernel streaming audio qualities */
#define KSAUDIO_QUALITY_WORST       0x00000000L
#define KSAUDIO_QUALITY_PC          0x00000001L
#define KSAUDIO_QUALITY_BASIC       0x00000002L
#define KSAUDIO_QUALITY_ADVANCED    0x00000003L

/* Kernel streaming audio CPU resource constants */
#define KSAUDIO_CPU_RESOURCES_NOT_HOST_CPU  0x00000000L
#define KSAUDIO_CPU_RESOURCES_HOST_CPU      0x7FFFFFFFL

/* Speaker position flags */
#define SPEAKER_FRONT_LEFT              0x00000001L
#define SPEAKER_FRONT_RIGHT             0x00000002L
#define SPEAKER_FRONT_CENTER            0x00000004L
#define SPEAKER_LOW_FREQUENCY           0x00000008L
#define SPEAKER_BACK_LEFT               0x00000010L
#define SPEAKER_BACK_RIGHT              0x00000020L
#define SPEAKER_FRONT_LEFT_OF_CENTER    0x00000040L
#define SPEAKER_FRONT_RIGHT_OF_CENTER   0x00000080L
#define SPEAKER_BACK_CENTER             0x00000100L
#define SPEAKER_SIDE_LEFT               0x00000200L
#define SPEAKER_SIDE_RIGHT              0x00000400L
#define SPEAKER_TOP_CENTER              0x00000800L
#define SPEAKER_TOP_FRONT_LEFT          0x00001000L
#define SPEAKER_TOP_FRONT_CENTER        0x00002000L
#define SPEAKER_TOP_FRONT_RIGHT         0x00004000L
#define SPEAKER_TOP_BACK_LEFT           0x00008000L
#define SPEAKER_TOP_BACK_CENTER         0x00010000L
#define SPEAKER_TOP_BACK_RIGHT          0x00020000L
#define SPEAKER_ALL                     0x80000000L

/* Kernel streaming audio speaker flags */
#if (NTDDI_VERSION >= 0x05010000)
    #define KSAUDIO_SPEAKER_DIRECTOUT   0L
#endif
#define KSAUDIO_SPEAKER_MONO            SPEAKER_FRONT_CENTER
#define KSAUDIO_SPEAKER_STEREO          (SPEAKER_FRONT_LEFT | SPEAKER_FRONT_RIGHT)
#define KSAUDIO_SPEAKER_QUAD \
    (SPEAKER_FRONT_LEFT | SPEAKER_FRONT_RIGHT | SPEAKER_BACK_LEFT | SPEAKER_BACK_RIGHT)
#define KSAUDIO_SPEAKER_SURROUND \
    (SPEAKER_FRONT_LEFT | SPEAKER_FRONT_RIGHT | SPEAKER_FRONT_CENTER | \
    SPEAKER_BACK_CENTER)
#define KSAUDIO_SPEAKER_5POINT1 \
    (SPEAKER_FRONT_LEFT | SPEAKER_FRONT_RIGHT | SPEAKER_FRONT_CENTER | \
    SPEAKER_LOW_FREQUENCY | SPEAKER_BACK_LEFT | SPEAKER_BACK_RIGHT)
#define KSAUDIO_SPEAKER_7POINT1 \
    (SPEAKER_FRONT_LEFT | SPEAKER_FRONT_RIGHT | SPEAKER_FRONT_CENTER | \
    SPEAKER_LOW_FREQUENCY | SPEAKER_BACK_LEFT | SPEAKER_BACK_RIGHT | \
    SPEAKER_FRONT_LEFT_OF_CENTER | SPEAKER_FRONT_RIGHT_OF_CENTER)
#if ((NTDDI_VERSION >= 0x05010200) && (NTDDI_VERSION < 0x05020000)) || \
    (NTDDI_VERSION > 0x05020100)
    #define KSAUDIO_SPEAKER_5POINT1_SURROUND \
        (SPEAKER_FRONT_LEFT | SPEAKER_FRONT_RIGHT | SPEAKER_FRONT_CENTER | \
        SPEAKER_LOW_FREQUENCY | SPEAKER_SIDE_LEFT | SPEAKER_SIDE_RIGHT)
    #define KSAUDIO_SPEAKER_7POINT1_SURROUND \
        (SPEAKER_FRONT_LEFT | SPEAKER_FRONT_RIGHT | SPEAKER_FRONT_CENTER | \
        SPEAKER_FRONT_CENTER | SPEAKER_LOW_FREQUENCY | SPEAKER_BACK_LEFT | \
        SPEAKER_BACK_RIGHT | SPEAKER_SIDE_LEFT | SPEAKER_SIDE_RIGHT)
    #define KSAUDIO_SPEAKER_5POINT1_BACK    KSAUDIO_SPEAKER_5POINT1
    #define KSAUDIO_SPEAKER_7POINT1_WIDE    KSAUDIO_SPEAKER_7POINT1
#endif
#define KSAUDIO_SPEAKER_GROUND_FRONT_LEFT   SPEAKER_FRONT_LEFT
#define KSAUDIO_SPEAKER_GROUND_FRONT_CENTER SPEAKER_FRONT_CENTER
#define KSAUDIO_SPEAKER_GROUND_FRONT_RIGHT  SPEAKER_FRONT_RIGHT
#define KSAUDIO_SPEAKER_GROUND_REAR_LEFT    SPEAKER_BACK_LEFT
#define KSAUDIO_SPEAKER_GROUND_REAR_RIGHT   SPEAKER_BACK_RIGHT
#define KSAUDIO_SPEAKER_TOP_MIDDLE          SPEAKER_TOP_CENTER
#define KSAUDIO_SPEAKER_SUPER_WOOFER        SPEAKER_LOW_FREQUENCY

/* Kernel streaming node pin constants */
#define KSNODEPIN_STANDARD_IN           1
#define KSNODEPIN_STANDARD_OUT          0
#define KSNODEPIN_SUM_MUX_IN            1
#define KSNODEPIN_SUM_MUX_OUT           0
#define KSNODEPIN_DEMUX_IN              0
#define KSNODEPIN_DEMUX_OUT             1
#if (NTDDI_VERSION < 0x06000000)
    #define KSNODEPIN_AEC_RENDER_IN     1
    #define KSNODEPIN_AEC_RENDER_OUT    0
    #define KSNODEPIN_AEC_CAPTURE_IN    2
    #define KSNODEPIN_AEC_CAPTURE_OUT   3
#endif

/* Acoustic echo cancel status flags */
#if (NTDDI_VERSION >= 0x05010000) && (NTDDI_VERSION < 0x06000000)
    #define AEC_STATUS_FD_HISTORY_UNINITIALIZED             0x00000000L
    #define AEC_STATUS_FD_HISTORY_CONTINUOUSLY_CONVERGED    0x00000001L
    #define AEC_STATUS_FD_HISTORY_PREVIOUSLY_DIVERGED       0x00000002L
    #define AEC_STATUS_FD_CURRENTLY_CONVERGED               0x00000008L
#endif

/* Acoustic echo cancel modes */
#if (NTDDI_VERSION >= 0x05010000) && (NTDDI_VERSION < 0x06000000)
    #define AEC_MODE_PASS_THROUGH   0x00000000L
    #define AEC_MODE_HALF_DUPLEX    0x00000001L
    #define AEC_MODE_FULL_DUPLEX    0x00000002L
#endif

/* Kernel streaming wave queued property and method identifiers */
#if (NTDDI_VERSION < 0x05020000)
    #define KSPROPERTY_WAVE_QUEUED_POSITION 0x00000001L
    #define KSMETHOD_WAVE_QUEUED_BREAKLOOP  0x00000001L
#endif

/* Kernel streaming compatibility capabilities device types */
#define KSWAVE_COMPATCAPS_INPUT     0x00000000L
#define KSWAVE_COMPATCAPS_OUTPUT    0x00000001L

/* Kernel streaming wave buffer attribute flags */
#define KSWAVE_BUFFER_ATTRIBUTEF_LOOPING    0x00000001L
#define KSWAVE_BUFFER_ATTRIBUTEF_STATIC     0x00000002L

/* System audio flags */
#if (NTDDI_VERSION < 0x06000000)
    #define SYSAUDIO_FLAGS_DONT_COMBINE_PINS    0x00000001L
#endif
#if (NTDDI_VERSION < 0x05010000)
    #define SYSAUDIO_FLAGS_CLEAR_PREFERRED      0x00000002L
#endif

/* Kernel streaming MPEG video modes */
#define KSMPEGVIDMODE_PANSCAN   0x00000001L
#define KSMPEGVIDMODE_LTRBOX    0x00000002L
#define KSMPEGVIDMODE_SCALE     0x00000004L

/* Kernel streaming AC3 alternate audio dual modes */
#define KSAC3_ALTERNATE_AUDIO_1     1L
#define KSAC3_ALTERNATE_AUDIO_2     2L
#define KSAC3_ALTERNATE_AUDIO_BOTH  3L

/* Kernel streaming AC3 bit stream modes */
#define KSAC3_SERVICE_MAIN_AUDIO        0L
#define KSAC3_SERVICE_NO_DIALOG         1L
#define KSAC3_SERVICE_VISUALLY_IMPAIRED 2L
#define KSAC3_SERVICE_HAIRING_IMPAIRED  3L
#define KSAC3_SERVICE_DIALOG_ONLY       4L
#define KSAC3_SERVICE_COMMENTARY        5L
#define KSAC3_SERVICE_EMERGENCY_FLASH   6L
#define KSAC3_SERVICE_VOICE_OVER        7L

/* Kernel streaming audio decoder output modes */
#define KSAUDDECOUTMODE_STEREO_ANALOG   0x00000001L
#define KSAUDDECOUTMODE_PCM_51          0x00000002L
#define KSAUDDECOUTMODE_SPDIFF          0x00000004L

/* Kernel streaming DVD CGMS copy protection flags */
#define KS_DVD_CGMS_COPY_PROTECT_MASK   0x00000018L
#define KS_DVD_CGMS_COPY_PERMITTED      0x00000000L
#define KS_DVD_CGMS_COPY_ONCE           0x00000010L
#define KS_DVD_CGMS_NO_COPY             0x00000018L
#define KS_DVD_COPYRIGHT_MASK           0x00000040L
#define KS_DVD_NOT_COPYRIGHTED          0x00000000L
#define KS_DVD_COPYRIGHTED              0x00000040L
#define KS_DVD_SECTOR_PROTECT_MASK      0x00000020L
#define KS_DVD_SECTOR_NOT_PROTECTED     0x00000000L
#define KS_DVD_SECTOR_PROTECTED         0x00000020L

/* Kernel streaming bitmap compression types */
#define KS_BI_RGB       0L
#define KS_BI_RLE8      1L
#define KS_BI_RLE4      2L
#define KS_BI_BITFIELDS 3L

/* Kernel streaming palette constants */
#define KS_iPALETTE_COLORS  256
#define KS_iEGA_COLORS      16
#define KS_iMASK_COLORS     3
#define KS_iTRUECOLOR       16
#define KS_iRED             0
#define KS_iGREEN           1
#define KS_iBLUE            2
#define KS_iPALETTE         8
#define KS_iMAXBITS         8

/* Kernel streaming VBI data and sampling rates */
#if (NTDDI_VERSION >= 0x05010000)
    #define KS_VBIDATARATE_NABTS            5727272L
    #define KS_VBIDATARATE_CC               503493L
    #define KS_VBISAMPLINGRATE_4X_NABTS     (4 * KS_VBIDATARATE_NABTS)
    #define KS_VBISAMPLINGRATE_47X_NABTS    27000000L
    #define KS_VBISAMPLINGRATE_5X_NABTS     (5 * KS_VBIDATARATE_NABTS)
    #define KS_47NABTS_SCALER \
        (KS_VBISAMPLINGRATE_47X_NABTS / (double)KS_VBIDATARATE_NABTS)
#endif

/* Kernel streaming TV tuner flags */
#define KS_TVTUNER_CHANGE_BEGIN_TUNE    0x00000001L
#define KS_TVTUNER_CHANGE_END_TUNE      0x00000002L

/* Kernel streaming interlace flags */
#define KS_INTERLACE_IsInterlaced           0x00000001L
#define KS_INTERLACE_1FieldPerSample        0x00000002L
#define KS_INTERLACE_Field1First            0x00000004L
#define KS_INTERLACE_FieldPatternMask       0x00000030L
#define KS_INTERLACE_FieldPatField1Only     0x00000000L
#define KS_INTERLACE_FieldPatField2Only     0x00000010L
#define KS_INTERLACE_FieldPatBothRegular    0x00000020L
#define KS_INTERLACE_FieldPatBothIrregular  0x00000030L
#define KS_INTERLACE_DisplayModeMask        0x000000C0L
#define KS_INTERLACE_DisplayModeBobOnly     0x00000000L
#define KS_INTERLACE_DisplayModeWeaveOnly   0x00000040L
#define KS_INTERLACE_DisplayModeBobOrWeave  0x00000080L

/* Kernel streaming copy protection flags */
#define KS_COPYPROTECT_RestrictDuplication  0x00000001L

/* Kernel streaming MPEG-2 flags */
#define KS_MPEG2_DoPanScan                  0x00000001L
#define KS_MPEG2_DVDLine21Field1            0x00000002L
#define KS_MPEG2_DVDLine21Field2            0x00000004L
#define KS_MPEG2_SourceIsLetterboxed        0x00000008L
#define KS_MPEG2_FilmCameraMode             0x00000010L
#define KS_MPEG2_LetterboxAnalogOut         0x00000020L
#define KS_MPEG2_DSS_UserData               0x00000040L
#define KS_MPEG2_DVB_UserData               0x00000080L
#define KS_MPEG2_27MhzTimebase              0x00000100L
#if (NTDDI_VERSION >= 0x05010000)
    #define KS_MPEG2_WidescreenAnalogOut    0x00000200L
#endif

/* Kernel streaming AM control flags */
#if (NTDDI_VERSION >= 0x05010000)
    #define KS_AMCONTROL_USED               0x00000001L
    #define KS_AMCONTROL_PAD_TO_4x3         0x00000002L
    #define KS_AMCONTROL_PAD_TO_16x9        0x00000004L
    #define KS_AMCONTROL_COLORINFO_PRESENT  0x00000080L
#endif

/* Kernel streaming MPEG audio information flags */
#define KS_MPEGAUDIOINFO_27MhzTimebase  0x00000001L

/* Kernel streaming video stream description flags */
#define KS_VIDEOSTREAM_PREVIEW  0x00000001L
#define KS_VIDEOSTREAM_CAPTURE  0x00000002L
#define KS_VIDEOSTREAM_VBI      0x00000010L
#define KS_VIDEOSTREAM_NABTS    0x00000020L
#define KS_VIDEOSTREAM_CC       0x00000100L
#define KS_VIDEOSTREAM_EDS      0x00000200L
#define KS_VIDEOSTREAM_TELETEXT 0x00000400L
#define KS_VIDEOSTREAM_STILL    0x00001000L
#define KS_VIDEOSTREAM_IS_VPE   0x00008000L

/* Kernel streaming video memory allocation flags */
#define KS_VIDEO_ALLOC_VPE_SYSTEM   0x00000001L
#define KS_VIDEO_ALLOC_VPE_DISPLAY  0x00000002L
#define KS_VIDEO_ALLOC_VPE_AGP      0x00000004L

/* Kernel streaming VBI capture protection flags */
#if (NTDDI_VERSION >= 0x05010000)
    #define KS_VBICAP_PROTECTION_MV_PRESENT     0x00000001L
    #define KS_VBICAP_PROTECTION_MV_HARDWARE    0x00000002L
    #define KS_VBICAP_PROTECTION_MV_DETECTED    0x00000004L
#endif

/* Kernel streaming NABTS group identifiers */
#define KS_NABTS_GROUPID_ORIGINAL_CONTENT_BASE              0x0800
#define KS_NABTS_GROUPID_ORIGINAL_CONTENT_ADVERTISER_BASE   0x0810
#define KS_NABTS_GROUPID_PRODUCTION_COMPANY_CONTENT_BASE    0x0820
#define KS_NABTS_GROUPID_PRODUCTION_COMPANY_ADVERTISER_BASE 0x0830
#define KS_NABTS_GROUPID_SYNDICATED_SHOW_CONTENT_BASE       0x0840
#define KS_NABTS_GROUPID_SYNDICATED_SHOW_ADVERTISER_BASE    0x0850
#define KS_NABTS_GROUPID_NETWORK_WIDE_CONTENT_BASE          0x0860
#define KS_NABTS_GROUPID_NETWORK_WIDE_ADVERTISER_BASE       0x0870
#define KS_NABTS_GROUPID_TELEVISION_STATION_CONTENT_BASE    0x0880
#define KS_NABTS_GROUPID_TELEVISION_STATION_ADVERTISER_BASE 0x0890
#define KS_NABTS_GROUPID_LOCAL_CABLE_SYSTEM_CONTENT_BASE    0x08A0
#define KS_NABTS_GROUPID_LOCAL_CABLE_SYSTEM_ADVERTISER_BASE 0x08B0

/* NABTS constants */
#define MAX_NABTS_VBI_LINES_PER_FIELD   11
#define NABTS_LINES_PER_BUNDLE          16
#define NABTS_PAYLOAD_PER_LINE          28
#define NABTS_BYTES_PER_LINE            36
 
/* Kernel streaming CC substream masks */
#define KS_CC_SUBSTREAM_ODD             0x00000001L
#define KS_CC_SUBSTREAM_EVEN            0x00000002L
#if (NTDDI_VERSION >= 0x05010000)
    #define KS_CC_SUBSTREAM_FIELD1_MASK 0x000000F0L
    #define KS_CC_SUBSTREAM_SERVICE_CC1 0x00000010L
    #define KS_CC_SUBSTREAM_SERVICE_CC2 0x00000020L
    #define KS_CC_SUBSTREAM_SERVICE_T1  0x00000040L
    #define KS_CC_SUBSTREAM_SERVICE_T2  0x00000080L
    #define KS_CC_SUBSTREAM_FIELD2_MASK 0x00001F00L
    #define KS_CC_SUBSTREAM_SERVICE_CC3 0x00000100L
    #define KS_CC_SUBSTREAM_SERVICE_CC4 0x00000200L
    #define KS_CC_SUBSTREAM_SERVICE_T3  0x00000400L
    #define KS_CC_SUBSTREAM_SERVICE_T4  0x00000800L
    #define KS_CC_SUBSTREAM_SERVICE_XDS 0x00001000L
#endif

/* Maximum number of CC hardward decode lines */
#if (NTDDI_VERSION >= 0x05010000)
    #define CC_MAX_HW_DECODE_LINES  12
#endif

/* NABTS buffer picture number support */
#define NABTS_BUFFER_PICTURENUMBER_SUPPORT  1

/* WST TV tuner change flags */
#if (NTDDI_VERSION >= 0x05010000)
    #define WST_TVTUNER_CHANGE_BEGIN_TUNE   0x00001000L
    #define WST_TVTUNER_CHANGE_END_TUNE     0x00002000L
#endif

/* WST constants */
#if (NTDDI_VERSION >= 0x05010000)
    #define MAX_WST_VBI_LINES_PER_FIELD 17
    #define WST_BYTES_PER_LINE          42
#endif

/* Kernel streaming video flags */
#define KS_VIDEO_FLAG_FIELD_MASK    0x00000003L
#define KS_VIDEO_FLAG_FRAME         0x00000000L
#define KS_VIDEO_FLAG_FIELD1        0x00000001L
#define KS_VIDEO_FLAG_FIELD2        0x00000002L
#define KS_VIDEO_FLAG_FIELD1FIRST   0x00000004L
#define KS_VIDEO_FLAG_WEAVE         0x00000008L
#define KS_VIDEO_FLAG_IPB_MASK      0x00000030L
#define KS_VIDEO_FLAG_I_FRAME       0x00000000L
#define KS_VIDEO_FLAG_P_FRAME       0x00000010L
#define KS_VIDEO_FLAG_B_FRAME       0x00000020L
#define KS_VIDEO_FLAG_REPEAT_FIELD  0x00000040L

/* Kernel streaming VBI flags */
#if (NTDDI_VERSION < 0x05010000)
    #define KS_VBI_FLAG_FRAME               0x00000000L
#endif
#define KS_VBI_FLAG_FIELD1                  0x00000001L
#define KS_VBI_FLAG_FIELD2                  0x00000002L
#if (NTDDI_VERSION >= 0x05010000)
    #define KS_VBI_FLAG_MV_PRESENT          0x00000100L
    #define KS_VBI_FLAG_MV_HARDWARE         0x00000200L
    #define KS_VBI_FLAG_MV_DETECTED         0x00000400L
#endif
#define KS_VBI_FLAG_TVTUNER_CHANGE          0x00000010L
#define KS_VBI_FLAG_VBIINFOHEADER_CHANGE    0x00000020L

/* Kernel streaming analog video standard masks */
#define KS_AnalogVideo_NTSC_Mask    0x00000007L
#if (NTDDI_VERSION >= 0x05010000)
    #define KS_AnalogVideo_PAL_Mask 0x00100FF0L
#else
    #define KS_AnalogVideo_PAL_Mask 0x00000FF0L
#endif
#define KS_AnalogVideo_SECAM_Mask   0x000FF000L

/* Kernel streaming video procedure amplifier property flags */
#define KSPROPERTY_VIDEOPROCAMP_FLAGS_AUTO      0x00000001L
#define KSPROPERTY_VIDEOPROCAMP_FLAGS_MANUAL    0x00000002L

/* Kernel streaming camera control property flags */
#define KSPROPERTY_CAMERACONTROL_FLAGS_AUTO     0x00000001L
#define KSPROPERTY_CAMERACONTROL_FLAGS_MANUAL   0x00000002L
#define KSPROPERTY_CAMERACONTROL_FLAGS_ABSOLUTE 0x00000000L
#define KSPROPERTY_CAMERACONTROL_FLAGS_RELATIVE 0x00000010L

/* Kernel streaming TV audio modes */
#define KS_TVAUDIO_MODE_MONO            0x00000001L
#define KS_TVAUDIO_MODE_STEREO          0x00000002L
#define KS_TVAUDIO_MODE_LANG_A          0x00000010L
#define KS_TVAUDIO_MODE_LANG_B          0x00000020L
#define KS_TVAUDIO_MODE_LANG_C          0x00000040L
#if (NTDDI_VERSION >= 0x06000000)
    #define KS_TVAUDIO_PRESET_STEREO    0x00000200L
    #define KS_TVAUDIO_PRESET_LANG_A    0x00001000L
    #define KS_TVAUDIO_PRESET_LANG_B    0x00002000L
    #define KS_TVAUDIO_PRESET_LANG_C    0x00004000L
#endif

/* Kernel streaming ActiveMovie flags */
#define KS_AM_UseNewCSSKey  0x00000001L

/* Maximum sink description name length */
#define MAX_SINK_DESCRIPTION_NAME_LENGTH    32

/* Jack capabilities */
#define JACKDESC2_PRESENCE_DETECT_CAPABILITY        0x00000001L
#define JACKDESC2_DYNAMIC_FORMAT_CHANGE_CAPABILITY  0x00000002L

/* Kernel streaming multiple data property */
typedef struct {
    KSPROPERTY      Property;
    KSMULTIPLE_ITEM MultipleItem;
} KSMULTIPLE_DATA_PROP;
typedef KSMULTIPLE_DATA_PROP    *PKSMULTIPLE_DATA_PROP;

/* Kernel streaming interface media values */
typedef enum {
    KSINTERFACE_MEDIA_MUSIC         = 0,
    KSINTERFACE_MEDIA_WAVE_BUFFERED = 1,
    KSINTERFACE_MEDIA_WAVE_QUEUED   = 2
} KSINTERFACE_MEDIA;

/* Kernel streaming wave format data format */
#if defined( _INC_MMSYSTEM ) || defined( _INC_MMREG )
typedef struct {
    KSDATAFORMAT    DataFormat;
    WAVEFORMATEX    WaveFormatEx;
} KSDATAFORMAT_WAVEFORMATEX;
typedef KSDATAFORMAT_WAVEFORMATEX   *PKSDATAFORMAT_WAVEFORMATEX;
#endif

/* Extensible wave format */
#if defined( _INC_MMSYSTEM ) && !defined( _INC_MMREG )
typedef struct {
    WAVEFORMATEX    Format;
    union {
        WORD    wValidBitsPerSample;
        WORD    wSamplesPerBlock;
        WORD    wReserved;
    } Samples;
    DWORD           dwChannelMask;
    GUID            SubFormat;
} WAVEFORMATEXTENSIBLE;
typedef WAVEFORMATEXTENSIBLE    *PWAVEFORMATEXTENSIBLE;
#endif

/* IEC61937 extensible wave format */
#if defined( _INC_MMSYSTEM ) && !defined( _INC_MMREG )
typedef struct {
    WAVEFORMATEXTENSIBLE    FormatExt;
    DWORD                   dwEncodedSamplesPerSec;
    DWORD                   dwEncodedChannelCount;
    DWORD                   dwAverageBytesPerSec;
} WAVEFORMATEXTENSIBLE_IEC61937;
typedef WAVEFORMATEXTENSIBLE_IEC61937   *PWAVEFORMATEXTENSIBLE_IEC61937;
#endif

/* Kernel streaming DirectSound buffer description */
#if defined( _INC_MMSYSTEM ) || defined( _INC_MMREG )
typedef struct {
    ULONG           Flags;
    ULONG           Control;
    WAVEFORMATEX    WaveFormatEx;
} KSDSOUND_BUFFERDESC;
typedef KSDSOUND_BUFFERDESC *PKSDSOUND_BUFFERDESC;
#endif

/* Kernel streaming DirectSound data format */
#if defined( _INC_MMSYSTEM ) || defined( _INC_MMREG )
typedef struct {
    KSDATAFORMAT        DataFormat;
    KSDSOUND_BUFFERDESC BufferDesc;
} KSDATAFORMAT_DSOUND;
typedef KSDATAFORMAT_DSOUND *PKSDATAFORMAT_DSOUND;
#endif

/* Kernel streaming audio position */
typedef struct {
#ifdef _NTDDK_
    ULONGLONG   PlayOffset;
    ULONGLONG   WriteOffset;
#else
    DWORDLONG   PlayOffset;
    DWORDLONG   WriteOffset;
#endif
} KSAUDIO_POSITION;
typedef KSAUDIO_POSITION    *PKSAUDIO_POSITION;

/* Kernel streaming microphone types */
#if (NTDDI_VERSION >= 0x06000000)
typedef enum {
    KSMICARRAY_MICTYPE_OMNIDIRECTIONAL  = 0,
    KSMICARRAY_MICTYPE_SUBCARDIOID      = 1,
    KSMICARRAY_MICTYPE_CARDIOID         = 2,
    KSMICARRAY_MICTYPE_SUPERCARDIOID    = 3,
    KSMICARRAY_MICTYPE_HYPERCARDIOID    = 4,
    KSMICARRAY_MICTYPE_8SHAPED          = 8,
    KSMICARRAY_MICTYPE_VENDORDEFINED    = 0x0F
} KSMICARRAY_MICTYPE;
#endif

/* Kernel streaming audio microphone coordinates */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct {
    USHORT  usType;
    SHORT   wXCoord;
    SHORT   wYCoord;
    SHORT   wZCoord;
    SHORT   wVerticalAngle;
    SHORT   wHorizontalAngle;
} KSAUDIO_MICROPHONE_COORDINATES;
typedef KSAUDIO_MICROPHONE_COORDINATES  *PKSAUDIO_MICROPHONE_COORDINATES;
#endif

/* Kernel streaming microphone array types */
#if (NTDDI_VERSION >= 0x06000000)
typedef enum {
    KSMICARRAY_MICARRAYTYPE_LINEAR  = 0,
    KSMICARRAY_MICARRAYTYPE_PLANAR  = 1,
    KSMICARRAY_MICARRAYTYPE_3D      = 2
} KSMICARRAY_MICARRAYTYPE;
#endif

/* Kernel streaming audio microphone array geometry */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct {
    USHORT                          usVersion;
    USHORT                          usMicArrayType;
    SHORT                           wVerticalAngleBegin;
    SHORT                           wVerticalAngleEnd;
    SHORT                           wHorizontalAngleBegin;
    SHORT                           wHorizontalAngleEnd;
    USHORT                          usFrequencyBandLo;
    USHORT                          usFrequencyBandHi;
    USHORT                          usNumberOfMicrophones;
    KSAUDIO_MICROPHONE_COORDINATES  KsMicCoord[1];
} KSAUDIO_MIC_ARRAY_GEOMETRY;
typedef KSAUDIO_MIC_ARRAY_GEOMETRY  *PKSAUDIO_MIC_ARRAY_GEOMETRY;
#endif

/* DirectSound3D vector */
typedef struct _DS3DVECTOR {
    union {
        FLOAT   x;
        FLOAT   dvX;
    };
    union {
        FLOAT   y;
        FLOAT   dvY;
    };
    union {
        FLOAT   z;
        FLOAT   dvZ;
    };
} DS3DVECTOR;
typedef DS3DVECTOR  *PDS3DVECTOR;

/* Kernel streaming DirectSound3D listener properties */
typedef enum {
    KSPROPERTY_DIRECTSOUND3DLISTENER_ALL            = 0,
    KSPROPERTY_DIRECTSOUND3DLISTENER_POSITION       = 1,
    KSPROPERTY_DIRECTSOUND3DLISTENER_VELOCITY       = 2,
    KSPROPERTY_DIRECTSOUND3DLISTENER_ORIENTATION    = 3,
    KSPROPERTY_DIRECTSOUND3DLISTENER_DISTANCEFACTOR = 4,
    KSPROPERTY_DIRECTSOUND3DLISTENER_ROLLOFFFACTOR  = 5,
    KSPROPERTY_DIRECTSOUND3DLISTENER_DOPPLERFACTOR  = 6,
    KSPROPERTY_DIRECTSOUND3DLISTENER_BATCH          = 7,
    KSPROPERTY_DIRECTSOUND3DLISTENER_ALLOCATION     = 8
} KSPROPERTY_DIRECTSOUND3DLISTENER;

/* Kernel streaming DirectSound3D listener properties data structure */
typedef struct {
    DS3DVECTOR  Position;
    DS3DVECTOR  Velocity;
    DS3DVECTOR  OrientFront;
    DS3DVECTOR  OrientTop;
    FLOAT       DistanceFactor;
    FLOAT       RolloffFactor;
    FLOAT       DopplerFactor;
} KSDS3D_LISTENER_ALL;
typedef KSDS3D_LISTENER_ALL *PKSDS3D_LISTENER_ALL;

/* Kernel streaming DirectSound3D listen orientation */
typedef struct {
    DS3DVECTOR  Front;
    DS3DVECTOR  Top;
} KSDS3D_LISTENER_ORIENTATION;
typedef KSDS3D_LISTENER_ORIENTATION *PKSDS3D_LISTENER_ORIENTATION;

/* Kernel streaming DirectSound3D buffer properties */
typedef enum {
    KSPROPERTY_DIRECTSOUND3DBUFFER_ALL                  = 0,
    KSPROPERTY_DIRECTSOUND3DBUFFER_POSITION             = 1,
    KSPROPERTY_DIRECTSOUND3DBUFFER_VELOCITY             = 2,
    KSPROPERTY_DIRECTSOUND3DBUFFER_CONEANGLES           = 3,
    KSPROPERTY_DIRECTSOUND3DBUFFER_CONEORIENTATION      = 4,
    KSPROPERTY_DIRECTSOUND3DBUFFER_CONEOUTSIDEVOLUME    = 5,
    KSPROPERTY_DIRECTSOUND3DBUFFER_MINDISTANCE          = 6,
    KSPROPERTY_DIRECTSOUND3DBUFFER_MAXDISTANCE          = 7,
    KSPROPERTY_DIRECTSOUND3DBUFFER_MODE                 = 8
} KSPROPERTY_DIRECTSOUND3DBUFFER;

/* Kernel streaming DirectSound3D buffer properties data structure */
typedef struct {
    DS3DVECTOR  Position;
    DS3DVECTOR  Velocity;
    ULONG       InsideConeAngle;
    ULONG       OutsideConeAngle;
    DS3DVECTOR  ConeOrientation;
    LONG        ConeOutsideVolume;
    FLOAT       MinDistance;
    FLOAT       MaxDistance;
    ULONG       Mode;
} KSDS3D_BUFFER_ALL;
typedef KSDS3D_BUFFER_ALL   *PKSDS3D_BUFFER_ALL;

/* Kernel streaming DirectSound3D buffer cone angles */
typedef struct {
    ULONG   InsideConeAngle;
    ULONG   OutsideConeAngle;
} KSDS3D_BUFFER_CONE_ANGLES;
typedef KSDS3D_BUFFER_CONE_ANGLES   *PKSDS3D_BUFFER_CONE_ANGLES;

/* Kernel streaming DirectSound3D HRTF parameters */
typedef struct {
    ULONG   Size;
    ULONG   Enabled;
    BOOL    SwapChannels;
    BOOL    ZeroAzimuth;
    BOOL    CrossFadeOutput;
    ULONG   FilterSize;
} KSDS3D_HRTF_PARAMS_MSG;
typedef KSDS3D_HRTF_PARAMS_MSG  *PKSDS3D_HRTF_PARAMS_MSG;

/* Kernel streaming DirectSound3D HRTF filter qualities */
typedef enum {
    FULL_FILTER                 = 0,
    LIGHT_FILTER                = 1,
    KSDS3D_FILTER_QUALITY_COUNT = 2
} KSDS3D_HRTF_FILTER_QUALITY;

/* Kernel streaming DirectSound3D HRTF initialize message */
typedef struct {
    ULONG                       Size;
    KSDS3D_HRTF_FILTER_QUALITY  Quality;
    FLOAT                       SampleRate;
    ULONG                       MaxFilterSize;
    ULONG                       FilterTransientMuteLength;
    ULONG                       FilterOverlapBufferLength;
    ULONG                       OutputOverlapBufferLength;
    ULONG                       Reserved;
} KSDS3D_HRTF_INIT_MSG;
typedef KSDS3D_HRTF_INIT_MSG    *PKSDS3D_HRTF_INIT_MSG;

/* Kernel streaming DirectSound3D HRTF coefficient formats */
typedef enum {
    FLOAT_COEFF         = 0,
    SHORT_COEFF         = 1,
    KSDS3D_COEFF_COUNT  = 2
} KSDS3D_HRTF_COEFF_FORMAT;

/* Kernel streaming DirectSound3D HRTF filter methods */
typedef enum {
    DIRECT_FORM                 = 0,
    CASCADE_FORM                = 1,
    KSDS3D_FILTER_METHOD_COUNT  = 2
} KSDS3D_HRTF_FILTER_METHOD;

/* Kernel streaming DirectSound3D HRTF filter versions */
typedef enum {
    DS3D_HRTF_VERSION_1 = 0,
} KSDS3D_HRTF_FILTER_VERSION;

/* Kernel streaming DirectSound3D HRTF filter format message */
typedef struct {
    KSDS3D_HRTF_FILTER_METHOD   FilterMethod;
    KSDS3D_HRTF_COEFF_FORMAT    CoeffFormat;
    KSDS3D_HRTF_FILTER_VERSION  Version;
    ULONG                       Reserved;
} KSDS3D_HRTF_FILTER_FORMAT_MSG;
typedef KSDS3D_HRTF_FILTER_FORMAT_MSG   *PKSDS3D_HRTF_FILTER_FORMAT_MSG;

/* Kernel streaming HRTF3D properties */
typedef enum {
    KSPROPERTY_HRTF3D_PARAMS        = 0,
    KSPROPERTY_HRTF3D_INITIALIZE    = 1,
    KSPROPERTY_HRTF3D_FILTER_FORMAT = 2
} KSPROPERTY_HRTF3D;

/* Kernel streaming DirectSound3D ITD parameters */
typedef struct {
    LONG    Channel;
    FLOAT   VolSmoothScale;
    FLOAT   TotalDryAttenuation;
    FLOAT   TotalWetAttenuation;
    LONG    SmoothFrequency;
    LONG    Delay;
} KSDS3D_ITD_PARAMS;
typedef KSDS3D_ITD_PARAMS   *PKSDS3D_ITD_PARAMS;

/* Kernel streaming DirectSound3D ITD parameters message */
typedef struct {
    ULONG               Enabled;
    KSDS3D_ITD_PARAMS   LeftParams;
    KSDS3D_ITD_PARAMS   RightParams;
    ULONG               Reserved;
} KSDS3D_ITD_PARAMS_MSG;
typedef KSDS3D_ITD_PARAMS_MSG   *PKSDS3D_ITD_PARAMS_MSG;

/* Kernel streaming ITD3D properties */
typedef enum {
    KSPROPERTY_ITD3D_PARAMS = 0
} KSPROPERTY_ITD3D;

/* Kernel streaming audio data range */
typedef struct {
    KSDATARANGE DataRange;
    ULONG       MaximumChannels;
    ULONG       MinimumBitsPerSample;
    ULONG       MaximumBitsPerSample;
    ULONG       MinimumSampleFrequency;
    ULONG       MaximumSampleFrequency;
} KSDATARANGE_AUDIO;
typedef KSDATARANGE_AUDIO   *PKSDATARANGE_AUDIO;

/* Kernel streaming bibliographic properties */
typedef enum {
    KSPROPERTY_BIBLIOGRAPHIC_LEADER                 = 'RDL ',
    KSPROPERTY_BIBLIOGRAPHIC_LCCN                   = '010 ',
    KSPROPERTY_BIBLIOGRAPHIC_ISBN                   = '020 ',
    KSPROPERTY_BIBLIOGRAPHIC_ISSN                   = '220 ',
    KSPROPERTY_BIBLIOGRAPHIC_CATALOGINGSOURCE       = '040 ',
    KSPROPERTY_BIBLIOGRAPHIC_MAINPERSONALNAME       = '001 ',
    KSPROPERTY_BIBLIOGRAPHIC_MAINCORPORATEBODY      = '011 ',
    KSPROPERTY_BIBLIOGRAPHIC_MAINMEETINGNAME        = '111 ',
    KSPROPERTY_BIBLIOGRAPHIC_MAINUNIFORMTITLE       = '031 ',
    KSPROPERTY_BIBLIOGRAPHIC_UNIFORMTITLE           = '042 ',
    KSPROPERTY_BIBLIOGRAPHIC_TITLESTATEMENT         = '542 ',
    KSPROPERTY_BIBLIOGRAPHIC_VARYINGFORMTITLE       = '642 ',
    KSPROPERTY_BIBLIOGRAPHIC_PUBLICATION            = '062 ',
    KSPROPERTY_BIBLIOGRAPHIC_PHYSICALDESCRIPTION    = '003 ',
    KSPROPERTY_BIBLIOGRAPHIC_ADDEDENTRYTITLE        = '044 ',
    KSPROPERTY_BIBLIOGRAPHIC_SERIESSTATEMENT        = '094 ',
    KSPROPERTY_BIBLIOGRAPHIC_GENERALNOTE            = '005 ',
    KSPROPERTY_BIBLIOGRAPHIC_BIBLIOGRAPHYNOTE       = '405 ',
    KSPROPERTY_BIBLIOGRAPHIC_CONTENTSNOTE           = '505 ',
    KSPROPERTY_BIBLIOGRAPHIC_CREATIONCREDIT         = '805 ',
    KSPROPERTY_BIBLIOGRAPHIC_CITATION               = '015 ',
    KSPROPERTY_BIBLIOGRAPHIC_PARTICIPANT            = '115 ',
    KSPROPERTY_BIBLIOGRAPHIC_SUMMARY                = '025 ',
    KSPROPERTY_BIBLIOGRAPHIC_TARGETAUDIENCE         = '125 ',
    KSPROPERTY_BIBLIOGRAPHIC_ADDEDFORMAVAILABLE     = '035 ',
    KSPROPERTY_BIBLIOGRAPHIC_SYSTEMDETAILS          = '835 ',
    KSPROPERTY_BIBLIOGRAPHIC_AWARDS                 = '685 ',
    KSPROPERTY_BIBLIOGRAPHIC_ADDEDENTRYPERSONALNAME = '006 ',
    KSPROPERTY_BIBLIOGRAPHIC_ADDEDENTRYTOPICALTERM  = '056 ',
    KSPROPERTY_BIBLIOGRAPHIC_ADDEDENTRYGEOGRAPHIC   = '156 ',
    KSPROPERTY_BIBLIOGRAPHIC_INDEXTERMGENRE         = '556 ',
    KSPROPERTY_BIBLIOGRAPHIC_INDEXTERMCURRICULUM    = '856 ',
    KSPROPERTY_BIBLIOGRAPHIC_ADDEDENTRYUNIFORMTITLE = '037 ',
    KSPROPERTY_BIBLIOGRAPHIC_ADDEDENTRYRELATED      = '047 ',
    KSPROPERTY_BIBLIOGRAPHIC_SERIESSTATEMENTPERSONALNAME    = '008 ',
    KSPROPERTY_BIBLIOGRAPHIC_SERIESSTATEMENTUNIFORMTITLE    = '038 '
} KSPROPERTY_BIBLIOGRAPHIC;

/* Kernel streaming topology node properties */
typedef enum {
#if (NTDDI_VERSION >= 0x05010000)
    KSPROPERTY_TOPOLOGYNODE_ENABLE  = 1,
    KSPROPERTY_TOPOLOGYNODE_RESET   = 2
#else
    KSPROPERTY_TOPOLOGYNODE_ENABLE  = 1
#endif
} KSPROPERTY_TOPOLOGYNODE;

/* RT audio callback */
#if (NTDDI_VERSION >= 0x05010000) && defined( _NTDDK_ )
typedef NTSTATUS (CALLBACK *PRTAUDIOGETPOSITION)( PFILE_OBJECT, PUCHAR *, PLONG );
#endif

/* Kernel streaming RT audio properties */
#if (NTDDI_VERSION >= 0x05010000)
typedef enum {
#if (NTDDI_VERSION >= 0x06000000)
    KSPROPERTY_RTAUDIO_GETPOSITIONFUNCTION              = 0,
    KSPROPERTY_RTAUDIO_BUFFER                           = 1,
    KSPROPERTY_RTAUDIO_HWLATENCY                        = 2,
    KSPROPERTY_RTAUDIO_POSITIONREGISTER                 = 3,
    KSPROPERTY_RTAUDIO_CLOCKREGISTER                    = 4,
    KSPROPERTY_RTAUDIO_BUFFER_WITH_NOTIFICATION         = 5,
    KSPROPERTY_RTAUDIO_REGISTER_NOTIFICATION_EVENT      = 6,
#if (NTDDI_VERSION >= 0x06010000)
    KSPROPERTY_RTAUDIO_UNREGISTER_NOTIFICATION_EVENT    = 7,
    KSPROPERTY_RTAUDIO_QUERY_NOTIFICATION_SUPPORT       = 8
#else
    KSPROPERTY_RTAUDIO_UNREGISTER_NOTIFICATION_EVENT    = 7
#endif
#else
    KSPROPERTY_RTAUDIO_GETPOSITIONFUNCTION              = 0
#endif
} KSPROPERTY_RTAUDIO;
#endif

/* Kernel streaming RT audio buffer property */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct {
    KSPROPERTY  Property;
    PVOID       BaseAddress;
    ULONG       RequestedBufferSize;
} KSRTAUDIO_BUFFER_PROPERTY;
typedef KSRTAUDIO_BUFFER_PROPERTY   *PKSRTAUDIO_BUFFER_PROPERTY;
#endif

/* Kernel streaming RT audio buffer property (32-bit version) */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct {
    KSPROPERTY  Property;
    ULONG       BaseAddress;
    ULONG       RequestedBufferSize;
} KSRTAUDIO_BUFFER_PROPERTY32;
typedef KSRTAUDIO_BUFFER_PROPERTY32 *PKSRTAUDIO_BUFFER_PROPERTY32;
#endif

/* Kernel streaming RT audio buffer property with notification */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct {
    KSPROPERTY  Property;
    PVOID       BaseAddress;
    ULONG       RequestedBufferSize;
    ULONG       NotificationCount;
} KSRTAUDIO_BUFFER_PROPERTY_WITH_NOTIFICATION;
typedef KSRTAUDIO_BUFFER_PROPERTY_WITH_NOTIFICATION *PKSRTAUDIO_BUFFER_PROPERTY_WITH_NOTIFICATION;
#endif

/* Kernel streaming RT audio buffer property with notification (32-bit version) */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct {
    KSPROPERTY  Property;
    ULONG       BaseAddress;
    ULONG       RequestedBufferSize;
    ULONG       NotificationCount;
} KSRTAUDIO_BUFFER_PROPERTY_WITH_NOTIFICATION32;
typedef KSRTAUDIO_BUFFER_PROPERTY_WITH_NOTIFICATION32   *PKSRTAUDIO_BUFFER_PROPERTY_WITH_NOTIFICATION32;
#endif

/* Kernel streaming RT audio buffer */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct {
    PVOID   BufferAddress;
    ULONG   ActualBufferSize;
    BOOL    CallMemoryBarrier;
} KSRTAUDIO_BUFFER;
typedef KSRTAUDIO_BUFFER    *PKSRTAUDIO_BUFFER;
#endif

/* Kernel streaming RT audio buffer (32-bit version) */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct {
    ULONG   BufferAddress;
    ULONG   ActualBufferSize;
    BOOL    CallMemoryBarrier;
} KSRTAUDIO_BUFFER32;
typedef KSRTAUDIO_BUFFER32  *PKSRTAUDIO_BUFFER32;
#endif

/* Kernel streaming RT audio hardware latency */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct {
    ULONG   FifoSize;
    ULONG   ChipsetDelay;
    ULONG   CodecDelay;
} KSRTAUDIO_HWLATENCY;
typedef KSRTAUDIO_HWLATENCY *PKSRTAUDIO_HWLATENCY;
#endif

/* Kernel streaming RT audio hardware register property */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct {
    KSPROPERTY  Property;
    PVOID       BaseAddress;
} KSRTAUDIO_HWREGISTER_PROPERTY;
typedef KSRTAUDIO_HWREGISTER_PROPERTY   *PKSRTAUDIO_HWREGISTER_PROPERTY;
#endif

/* Kernel streaming RT audio hardware register property (32-bit version) */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct {
    KSPROPERTY  Property;
    ULONG       BaseAddress;
} KSRTAUDIO_HWREGISTER_PROPERTY32;
typedef KSRTAUDIO_HWREGISTER_PROPERTY32 *PKSRTAUDIO_HWREGISTER_PROPERTY32;
#endif

/* Kernel streaming audio hardware register */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct {
    PVOID       Register;
    ULONG       Width;
    ULONGLONG   Numerator;
    ULONGLONG   Denominator;
    ULONG       Accuracy;
} KSRTAUDIO_HWREGISTER;
typedef KSRTAUDIO_HWREGISTER    *PKSRTAUDIO_HWREGISTER;
#endif

/* Kernel streaming audio hardware register (32-bit version) */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct {
    ULONG       Register;
    ULONG       Width;
    ULONGLONG   Numerator;
    ULONGLONG   Denominator;
    ULONG       Accuracy;
} KSRTAUDIO_HWREGISTER32;
typedef KSRTAUDIO_HWREGISTER32  *PKSRTAUDIO_HWREGISTER32;
#endif

/* Kernel streaming RT audio notification event property */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct {
    KSPROPERTY  Property;
    HANDLE      NotificationEvent;
} KSRTAUDIO_NOTIFICATION_EVENT_PROPERTY;
typedef KSRTAUDIO_NOTIFICATION_EVENT_PROPERTY   *PKSRTAUDIO_NOTIFICATION_EVENT_PROPERTY;
#endif

/* Kernel streaming RT audio notification event property (32-bit version) */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct {
    KSPROPERTY  Property;
    ULONG       NotificationEvent;
} KSRTAUDIO_NOTIFICATION_EVENT_PROPERTY32;
typedef KSRTAUDIO_NOTIFICATION_EVENT_PROPERTY32 *PKSRTAUDIO_NOTIFICATION_EVENT_PROPERTY32;
#endif

/* Kernel streaming one-shot properties */
#if (NTDDI_VERSION >= 0x06010000)
enum {
    KSPROPERTY_ONESHOT_RECONNECT    = 0
};
#endif

/* Kernel streaming DRM audio stream properties */
#if (NTDDI_VERSION >= 0x05010000)
typedef enum {
    KSPROPERTY_DRMAUDIOSTREAM_CONTENTID = 0
} KSPROPERTY_DRMAUDIOSTREAM;
#endif

/* Kernel streaming audio properties */
typedef enum {
    KSPROPERTY_AUDIO_LATENCY                = 1,
    KSPROPERTY_AUDIO_COPY_PROTECTION        = 2,
    KSPROPERTY_AUDIO_CHANNEL_CONFIG         = 3,
    KSPROPERTY_AUDIO_VOLUMELEVEL            = 4,
    KSPROPERTY_AUDIO_POSITION               = 5,
    KSPROPERTY_AUDIO_DYNAMIC_RANGE          = 6,
    KSPROPERTY_AUDIO_QUALITY                = 7,
    KSPROPERTY_AUDIO_SAMPLING_RATE          = 8,
    KSPROPERTY_AUDIO_DYNAMIC_SAMPLING_RATE  = 9,
    KSPROPERTY_AUDIO_MIX_LEVEL_TABLE        = 10,
    KSPROPERTY_AUDIO_MIX_LEVEL_CAPS         = 11,
    KSPROPERTY_AUDIO_MUX_SOURCE             = 12,
    KSPROPERTY_AUDIO_MUTE                   = 13,
    KSPROPERTY_AUDIO_BASS                   = 14,
    KSPROPERTY_AUDIO_MID                    = 15,
    KSPROPERTY_AUDIO_TREBLE                 = 16,
    KSPROPERTY_AUDIO_BASS_BOOST             = 17,
    KSPROPERTY_AUDIO_EQ_LEVEL               = 18,
    KSPROPERTY_AUDIO_NUM_EQ_BANDS           = 19,
    KSPROPERTY_AUDIO_EQ_BANDS               = 20,
    KSPROPERTY_AUDIO_AGC                    = 21,
    KSPROPERTY_AUDIO_DELAY                  = 22,
    KSPROPERTY_AUDIO_LOUDNESS               = 23,
    KSPROPERTY_AUDIO_WIDE_MODE              = 24,
    KSPROPERTY_AUDIO_WIDENESS               = 25,
    KSPROPERTY_AUDIO_REVERB_LEVEL           = 26,
    KSPROPERTY_AUDIO_CHORUS_LEVEL           = 27,
    KSPROPERTY_AUDIO_DEV_SPECIFIC           = 28,
    KSPROPERTY_AUDIO_DEMUX_DEST             = 29,
    KSPROPERTY_AUDIO_STEREO_ENHANCE         = 30,
    KSPROPERTY_AUDIO_MANUFACTURE_GUID       = 31,
    KSPROPERTY_AUDIO_PRODUCT_GUID           = 32,
    KSPROPERTY_AUDIO_CPU_RESOURCES          = 33,
    KSPROPERTY_AUDIO_STEREO_SPEAKER_GEOMETRY    = 34,
    KSPROPERTY_AUDIO_SURROUND_ENCODE        = 35,
#if (NTDDI_VERSION >= 0x05010000)
    KSPROPERTY_AUDIO_3D_INTERFACE           = 36,
    KSPROPERTY_AUDIO_PEAKMETER              = 37,
    KSPROPERTY_AUDIO_ALGORITHM_INSTANCE     = 38,
    KSPROPERTY_AUDIO_FILTER_STATE           = 39,
#endif
#if (NTDDI_VERSION >= 0x06000000)
    KSPROPERTY_AUDIO_PREFERRED_STATUS       = 40,
    KSPROPERTY_AUDIO_PEQ_MAX_BANDS          = 41,
    KSPROPERTY_AUDIO_PEQ_NUM_BANDS          = 42,
    KSPROPERTY_AUDIO_PEQ_BAND_CENTER_FREQ   = 43,
    KSPROPERTY_AUDIO_PEQ_BAND_Q_FACTOR      = 44,
    KSPROPERTY_AUDIO_PEQ_BAND_LEVEL         = 45,
    KSPROPERTY_AUDIO_CHORUS_MODULATION_RATE = 46,
    KSPROPERTY_AUDIO_CHORUS_MODULATION_DEPTH    = 47,
    KSPROPERTY_AUDIO_REVERB_TIME            = 48,
    KSPROPERTY_AUDIO_REVERB_DELAY_FEEDBACK  = 49,
    KSPROPERTY_AUDIO_POSITIONEX             = 50,
    KSPROPERTY_AUDIO_MIC_ARRAY_GEOMETRY     = 51
#elif (NTDDI_VERSION >= 0x05010000)
    KSPROPERTY_AUDIO_PREFERRED_STATUS       = 40
#else
    KSPROPERTY_AUDIO_3D_INTERFACE           = 36
#endif
} KSPROPERTY_AUDIO;

/* Kernel streaming audio copy protection */
typedef struct {
    BOOL    fCopyrighted;
    BOOL    fOriginal;
} KSAUDIO_COPY_PROTECTION;
typedef KSAUDIO_COPY_PROTECTION *PKSAUDIO_COPY_PROTECTION;

/* Kernel streaming audio channel configuration */
typedef struct {
    LONG    ActiveSpeakerPositions;
} KSAUDIO_CHANNEL_CONFIG;
typedef KSAUDIO_CHANNEL_CONFIG  *PKSAUDIO_CHANNEL_CONFIG;

/* Kernel streaming audio dynamic range */
typedef struct {
    ULONG   QuietCompression;
    ULONG   LoudCompression;
} KSAUDIO_DYNAMIC_RANGE;
typedef KSAUDIO_DYNAMIC_RANGE   *PKSAUDIO_DYNAMIC_RANGE;

/* Kernel streaming audio mix level */
typedef struct {
    BOOL    Mute;
    LONG    Level;
} KSAUDIO_MIXLEVEL;
typedef KSAUDIO_MIXLEVEL    *PKSAUDIO_MIXLEVEL;

/* Kernel streaming audio mix capabilities */
typedef struct {
    BOOL    Mute;
    LONG    Minimum;
    LONG    Maximum;
    union {
        LONG    Reset;
        LONG    Resolution;
    };
} KSAUDIO_MIX_CAPS;
typedef KSAUDIO_MIX_CAPS    *PKSAUDIO_MIX_CAPS;

/* Kernel streaming audio mix capability table */
typedef struct {
    ULONG               InputChannels;
    ULONG               OutputChannels;
    KSAUDIO_MIX_CAPS    Capabilities[1];
} KSAUDIO_MIXCAP_TABLE;
typedef KSAUDIO_MIXCAP_TABLE    *PKSAUDIO_MIXCAP_TABLE;

/* Stereo enhancement techniques */
typedef enum {
    SE_TECH_NONE                = 0,
    SE_TECH_ANALOG_DEVICES_PHAT = 1,
    SE_TECH_CREATIVE            = 2,
    SE_TECH_NATIONAL_SEMI       = 3,
    SE_TECH_YAMAHA_YMERSION     = 4,
    SE_TECH_BBE                 = 5,
    SE_TECH_CRYSTAL_SEMI        = 6,
    SE_TECH_QSOUND_QXPANDER     = 7,
    SE_TECH_SPATIALIZER         = 8,
    SE_TECH_SRS                 = 9,
    SE_TECH_PLATFORM_TECH       = 10,
    SE_TECH_AKM                 = 11,
    SE_TECH_AUREAL              = 12,
    SE_TECH_AZTECH              = 13,
    SE_TECH_BINAURA             = 14,
    SE_TECH_ESS_TECH            = 15,
    SE_TECH_HARMAN_VMAX         = 16,
    SE_TECH_NVIDEA              = 17,
    SE_TECH_PHILIPS_INCREDIBLE  = 18,
    SE_TECH_TEXAS_INST          = 19,
    SE_TECH_VLSI_TECH           = 20
} SE_TECHNIQUE;

/* Kernel streaming audio stereo enhancement information */
typedef struct {
    SE_TECHNIQUE    Technique;
    ULONG           Center;
    ULONG           Depth;
    ULONG           Reserved;
} KSAUDIO_STEREO_ENHANCE;
typedef KSAUDIO_STEREO_ENHANCE  *PKSAUDIO_STEREO_ENHANCE;

/* Kernel streaming system audio default type properties */
#if (NTDDI_VERSION < 0x06000000)
typedef enum {
    KSPROPERTY_SYSAUDIO_NORMAL_DEFAULT      = 0,
    KSPROPERTY_SYSAUDIO_PLAYBACK_DEFAULT    = 1,
    KSPROPERTY_SYSAUDIO_RECORD_DEFAULT      = 2,
    KSPROPERTY_SYSAUDIO_MIDI_DEFAULT        = 3,
    KSPROPERTY_SYSAUDIO_MIXER_DEFAULT       = 4
} KSPROPERTY_SYSAUDIO_DEFAULT_TYPE;
#endif

/* Kernel streaming audio preferred status */
#if (NTDDI_VERSION >= 0x05010000) && (NTDDI_VERSION < 0x06000000)
typedef struct {
    BOOL                                Enable;
    KSPROPERTY_SYSAUDIO_DEFAULT_TYPE    DeviceType;
    ULONG                               Flags;
    ULONG                               Reserved;
} KSAUDIO_PREFERRED_STATUS;
typedef KSAUDIO_PREFERRED_STATUS    *PKSAUDIO_PREFERRED_STATUS;
#endif

/* Kernel stream audio position (extended version) */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct {
    LARGE_INTEGER       TimerFrequency;
    LARGE_INTEGER       TimeStamp1;
    KSAUDIO_POSITION    Position;
    LARGE_INTEGER       TimeStamp2;
} KSAUDIO_POSITIONEX;
typedef KSAUDIO_POSITIONEX  *PKSAUDIO_POSITIONEX;
#endif

/* Kernel streaming wave table methods */
typedef enum {
    KSMETHOD_WAVETABLE_WAVE_ALLOC   = 0,
    KSMETHOD_WAVETABLE_WAVE_FREE    = 1,
    KSMETHOD_WAVETABLE_WAVE_FIND    = 2,
    KSMETHOD_WAVETABLE_WAVE_WRITE   = 3
} KSMETHOD_WAVETABLE;

/* Kernel streaming wave table wave description */
typedef struct {
    KSIDENTIFIER    Identifier;
    ULONG           Size;
    BOOL            Looped;
    ULONG           LoopPoint;
    BOOL            InROM;
    KSDATAFORMAT    Format;
} KSWAVETABLE_WAVE_DESC;
typedef KSWAVETABLE_WAVE_DESC   *PKSWAVETABLE_WAVE_DESC;

/* Kernel streaming acoutstic echo cancel properties */
#if (NTDDI_VERSION >= 0x05010000) && (NTDDI_VERSION < 0x06000000)
typedef enum {
    KSPROPERTY_AEC_NOISE_FILL_ENABLE    = 0,
    KSPROPERTY_AEC_STATUS               = 1,
    KSPROPERTY_AEC_MODE                 = 2
} KSPROPERTY_AEC;
#endif

/* Kernel streaming wave properties */
typedef enum {
    KSPROPERTY_WAVE_COMPATIBLE_CAPABILITIES = 0,
    KSPROPERTY_WAVE_INPUT_CAPABILITIES      = 1,
    KSPROPERTY_WAVE_OUTPUT_CAPABILITIES     = 2,
    KSPROPERTY_WAVE_BUFFER                  = 3,
    KSPROPERTY_WAVE_FREQUENCY               = 4,
    KSPROPERTY_WAVE_VOLUME                  = 5,
    KSPROPERTY_WAVE_PAN                     = 6
} KSPROPERTY_WAVE;

/* Kernel streaming wave compatibility capabilities */
typedef struct {
    ULONG   ulDeviceType;
} KSWAVE_COMPATCAPS;
typedef KSWAVE_COMPATCAPS   *PKSWAVE_COMPATCAPS;

/* Kernel streaming wave input capabilities */
typedef struct {
    ULONG   MaximumChannelsPerConnection;
    ULONG   MinimumBitsPerSample;
    ULONG   MaximumBitsPerSample;
    ULONG   MinimumSampleFrequency;
    ULONG   MaximumSampleFrequency;
    ULONG   TotalConnections;
    ULONG   ActiveConnections;
} KSWAVE_INPUT_CAPABILITIES;
typedef KSWAVE_INPUT_CAPABILITIES   *PKSWAVE_INPUT_CAPABILITIES;

/* Kernel streaming wave output capabilities */
typedef struct {
    ULONG   MaximumChannelsPerConnection;
    ULONG   MinimumBitsPerSample;
    ULONG   MaximumBitsPerSample;
    ULONG   MinimumSampleFrequency;
    ULONG   MaximumSampleFrequency;
    ULONG   TotalConnections;
    ULONG   StaticConnections;
    ULONG   StreamingConnections;
    ULONG   ActiveConnections;
    ULONG   ActiveStaticConnections;
    ULONG   ActiveStreamingConnections;
    ULONG   Total3DConnections;
    ULONG   Static3DConnections;
    ULONG   Streaming3DConnections;
    ULONG   Active3DConnections;
    ULONG   ActiveStatic3DConnections;
    ULONG   ActiveStreaming3DConnections;
    ULONG   TotalSampleMemory;
    ULONG   FreeSampleMemory;
    ULONG   LargestFreeContiguousSampleMemory;
} KSWAVE_OUTPUT_CAPABILITIES;
typedef KSWAVE_OUTPUT_CAPABILITIES  *PKSWAVE_OUTPUT_CAPABILITIES;

/* Kernel streaming wave volume */
typedef struct {
    LONG    LeftAttenuation;
    LONG    RightAttenuation;
} KSWAVE_VOLUME;
typedef KSWAVE_VOLUME   *PKSWAVE_VOLUME;

/* Kernel streaming wave buffer */
typedef struct {
    ULONG   Attributes;
    ULONG   BufferSize;
    PVOID   BufferAddress;
} KSWAVE_BUFFER;
typedef KSWAVE_BUFFER   *PKSWAVE_BUFFER;

/* Kernel streaming wave table properties */
#if (NTDDI_VERSION < 0x05020000)
typedef enum {
    KSPROPERTY_WAVETABLE_LOAD_SAMPLE    = 0,
    KSPROPERTY_WAVETABLE_UNLOAD_SAMPLE  = 1,
    KSPROPERTY_WAVETABLE_MEMORY         = 2,
    KSPROPERTY_WAVETABLE_VERSION        = 3
} KSPROPERTY_WAVETABLE;
#endif

/* Kernel streaming music data range */
typedef struct {
    KSDATARANGE DataRange;
    GUID        Technology;
    ULONG       Channels;
    ULONG       Notes;
    ULONG       ChannelMask;
} KSDATARANGE_MUSIC;
typedef KSDATARANGE_MUSIC   *PKSDATARANGE_MUSIC;

/* Kernel streaming cyclic time event */
#if (NTDDI_VERSION < 0x05020000)
typedef enum {
    KSEVENT_CYCLIC_TIME_INTERVAL    = 0
} KSEVENT_CYCLIC_TIME;
#endif

/* Kernel streaming cyclic position properties */
typedef enum {
    KSPROPERTY_CYCLIC_POSITION  = 0
} KSPROPERTY_CYCLIC;

/* Kernel streaming audio control change constants */
typedef enum {
    KSEVENT_CONTROL_CHANGE  = 0
} KSEVENT_AUDIO_CONTROL_CHANGE;

/* Kernel streaming looped streaming event */
typedef enum {
    KSEVENT_LOOPEDSTREAMING_POSITION    = 0
} KSEVENT_LOOPEDSTREAMING;

/* Looped streaming position event data */
typedef struct {
    KSEVENTDATA KsEventData;
#ifdef _NTDDK_
    ULONGLONG   Position;
#else
    DWORDLONG   Position;
#endif
} LOOPEDSTREAMING_POSITION_EVENT_DATA;
typedef LOOPEDSTREAMING_POSITION_EVENT_DATA *PLOOPEDSTREAMING_POSITION_EVENT_DATA;

/* Kernel streaming system audio events */
#if (NTDDI_VERSION < 0x05010000)
typedef enum {
#if (NTDDI_VERSION == 0x05010000)
    KSEVENT_SYSAUDIO_ADDREMOVE_DEVICE   = 0,
    KSEVENT_SYSAUDIO_CHANGE_DEVICE      = 1
#else
    KSEVENT_SYSAUDIO_ADDREMOVE_DEVICE   = 0
#endif
} KSEVENT_SYSAUDIO;
#endif

/* Kernel streaming system audio properties */
#if (NTDDI_VERSION < 0x06000000)
typedef enum {
    KSPROPERTY_SYSAUDIO_DEVICE_COUNT                    = 1,
    KSPROPERTY_SYSAUDIO_DEVICE_FRIENDLY_NAME            = 2,
    KSPROPERTY_SYSAUDIO_DEVICE_INSTANCE                 = 3,
    KSPROPERTY_SYSAUDIO_DEVICE_INTERFACE_NAME           = 4,
    KSPROPERTY_SYSAUDIO_SELECT_GRAPH                    = 5,
    KSPROPERTY_SYSAUDIO_CREATE_VIRTUAL_SOURCE           = 6,
    KSPROPERTY_SYSAUDIO_DEVICE_DEFAULT                  = 7,
#if (NTDDI_VERSION < 0x05010000)
    KSPROPERTY_SYSAUDIO_ALWAYS_CREATE_VIRTUAL_SOURCE    = 8,
    KSPROPERTY_SYSAUDIO_ADDREMOVE_LOCK                  = 9,
    KSPROPERTY_SYSAUDIO_ADDREMOVE_UNLOCK                = 10,
    KSPROPERTY_SYSAUDIO_RENDER_PIN_INSTANCES            = 11,
    KSPROPERTY_SYSAUDIO_RENDER_CONNECTION_INDEX         = 12,
    KSPROPERTY_SYSAUDIO_CREATE_VIRTUAL_SOURCE_ONLY      = 13,
#endif
    KSPROPERTY_SYSAUDIO_INSTANCE_INFO                   = 14,
#if (NTDDI_VERSION < 0x05010000)
    KSPROPERTY_SYSAUDIO_PREFERRED_DEVICE                = 15
#else
    KSPROPERTY_SYSAUDIO_COMPONENT_ID                    = 16
#endif
} KSPROPERTY_SYSAUDIO;
#endif

/* System audio create virtual source property */
#if (NTDDI_VERSION < 0x06000000)
typedef struct {
    KSPROPERTY  Property;
    GUID        PinCategory;
    GUID        PinName;
} SYSAUDIO_CREATE_VIRTUAL_SOURCE;
typedef SYSAUDIO_CREATE_VIRTUAL_SOURCE  *PSYSAUDIO_CREATE_VIRTUAL_SOURCE;
#endif

/* System audio select graph property */
#if (NTDDI_VERSION < 0x06000000)
typedef struct {
    KSPROPERTY  Property;
    ULONG       PinId;
    ULONG       NodeId;
    ULONG       Flags;
    ULONG       Reserved;
} SYSAUDIO_SELECT_GRAPH;
typedef SYSAUDIO_SELECT_GRAPH   *PSYSAUDIO_SELECT_GRAPH;
#endif

/* System audio instance information */
#if (NTDDI_VERSION < 0x06000000)
typedef struct {
    KSPROPERTY  Property;
    ULONG       Flags;
    ULONG       DeviceNumber;
} SYSAUDIO_INSTANCE_INFO;
typedef SYSAUDIO_INSTANCE_INFO  *PSYSAUDIO_INSTANCE_INFO;
#endif

/* System audio preferred device */
#if (NTDDI_VERSION < 0x05010000)
typedef struct {
    KSPROPERTY  Property;
    ULONG       Flags;
    ULONG       Index;
} SYSAUDIO_PREFERRED_DEVICE;
typedef SYSAUDIO_PREFERRED_DEVICE   *PSYSAUDIO_PREFERRED_DEVICE;
#endif

/* Kernel streaming system audio pin properties */
#if (NTDDI_VERSION >= 0x05010000) && (NTDDI_VERSION < 0x06000000)
typedef enum {
#if (NTDDI_VERSION >= 0x05010000)
    KSPROPERTY_SYSAUDIO_ATTACH_VIRTUAL_SOURCE   = 1
#else
    KSPROPERTY_SYSAUDIO_TOPOLOGY_CONNECTION_INDEX   = 0,
    KSPROPERTY_SYSAUDIO_ATTACH_VIRTUAL_SOURCE       = 1,
    KSPROPERTY_SYSAUDIO_PIN_VOLUME_NODE             = 2
#endif
} KSPROPERTY_SYSAUDIO_PIN;
#endif

/* System audio attach virtual source property */
#if (NTDDI_VERSION < 0x06000000)
typedef struct {
    KSPROPERTY  Property;
    ULONG       MixerPinId;
    ULONG       Reserved;
} SYSAUDIO_ATTACH_VIRTUAL_SOURCE;
typedef SYSAUDIO_ATTACH_VIRTUAL_SOURCE  *PSYSAUDIO_ATTACH_VIRTUAL_SOURCE;
#endif

/* Kernel streaming node property */
typedef struct {
    KSPROPERTY  Property;
    ULONG       NodeId;
    ULONG       Reserved;
} KSNODEPROPERTY;
typedef KSNODEPROPERTY  *PKSNODEPROPERTY;

/* Kernel streaming audio channel node property */
typedef struct {
    KSNODEPROPERTY  NodeProperty;
    LONG            Channel;
    ULONG           Reserved;
} KSNODEPROPERTY_AUDIO_CHANNEL;
typedef KSNODEPROPERTY_AUDIO_CHANNEL    *PKSNODEPROPERTY_AUDIO_CHANNEL;

/* Kernel streaming audio device specific node channel */
typedef struct {
    KSNODEPROPERTY  NodeProperty;
    ULONG           DevSpecificId;
    ULONG           DeviceInfo;
    ULONG           Length;
} KSNODEPROPERTY_AUDIO_DEV_SPECIFIC;
typedef KSNODEPROPERTY_AUDIO_DEV_SPECIFIC   *PKSNODEPROPERTY_AUDIO_DEV_SPECIFIC;

/* Kernel streaming audio 3D listener node property */
typedef struct {
    KSNODEPROPERTY  NodeProperty;
    PVOID           ListenerId;
    ULONG           Reserved;
} KSNODEPROPERTY_AUDIO_3D_LISTENER;
typedef KSNODEPROPERTY_AUDIO_3D_LISTENER    *PKSNODEPROPERTY_AUDIO_3D_LISTENER;

/* Kernel streaming audio node property */
typedef struct {
    KSNODEPROPERTY  NodeProperty;
    PVOID           AppContext;
    ULONG           Length;
    ULONG           Reserved;
} KSNODEPROPERTY_AUDIO_PROPERTY;
typedef KSNODEPROPERTY_AUDIO_PROPERTY   *PKSNODEPROPERTY_AUDIO_PROPERTY;

/* Kernel streaming audio graphics properties */
#if (NTDDI_VERSION >= 0x05010000) && (NTDDI_VERSION < 0x06000000)
typedef enum {
    KSPROPERTY_AUDIOGFX_RENDERTARGETDEVICEID    = 0,
    KSPROPERTY_AUDIOGFX_CAPTURETARGETDEVICEID   = 1
} KSPROPERTY_AUDIOGFX;
#endif

/* Kernel streaming linear properties */
#if (NTDDI_VERSION < 0x05020000)
typedef enum {
    KSPROPERTY_LINEAR_POSITION  = 0
} KSPROPERTY_LINEAR;
#endif

/* Kernel streaming music format */
typedef struct {
    ULONG   TimeDeltaMs;
    ULONG   ByteCount;
} KSMUSICFORMAT;
typedef KSMUSICFORMAT   *PKSMUSICFORMAT;

/* Kernel streaming MPEG-2 video properties */
typedef enum {
    KSPROPERTY_MPEG2VID_MODES           = 0,
    KSPROPERTY_MPEG2VID_CUR_MODE        = 1,
    KSPROPERTY_MPEG2VID_4_3_RECT        = 2,
    KSPROPERTY_MPEG2VID_16_9_RECT       = 3,
    KSPROPERTY_MPEG2VID_16_9_PANSCAN    = 4
} KSPROPERTY_MPEG2VID;

/* Kernel streaming MPEG video rectangle */
typedef struct _KSMPEGVID_RECT {
    ULONG   StartX;
    ULONG   StartY;
    ULONG   EndX;
    ULONG   EndY;
} KSMPEGVID_RECT;
typedef KSMPEGVID_RECT  *PKSMPEGVID_RECT;

/* Kernel streaming AC3 properties */
typedef enum {
    KSPROPERTY_AC3_ERROR_CONCEALMENT    = 1,
    KSPROPERTY_AC3_ALTERNATE_AUDIO      = 2,
    KSPROPERTY_AC3_DOWNMIX              = 3,
    KSPROPERTY_AC3_BIT_STREAM_MODE      = 4,
    KSPROPERTY_AC3_DIALOGUE_LEVEL       = 5,
    KSPROPERTY_AC3_LANGUAGE_CODE        = 6,
    KSPROPERTY_AC3_ROOM_TYPE            = 7
} KSPROPERTY_AC3;

/* Kernel streaming AC3 error concealment */
typedef struct {
    BOOL    fRepeatPreviousBlock;
    BOOL    fErrorInCurrentBlock;
} KSAC3_ERROR_CONCEALMENT;
typedef KSAC3_ERROR_CONCEALMENT *PKSAC3_ERROR_CONCEALMENT;

/* Kernel streaming AC3 alternate audio */
typedef struct {
    BOOL    fStereo;
    ULONG   DualMode;
} KSAC3_ALTERNATE_AUDIO;
typedef KSAC3_ALTERNATE_AUDIO   *PKSAC3_ALTERNATE_AUDIO;

/* Kernel streaming AC3 down mix */
typedef struct {
    BOOL    fDownMix;
    BOOL    fDolbySurround;
} KSAC3_DOWNMIX;
typedef KSAC3_DOWNMIX   *PKSAC3_DOWNMIX;

/* Kernel streaming AC3 bit stream mode */
typedef struct {
    LONG    BitStreamMode;
} KSAC3_BIT_STREAM_MODE;
typedef KSAC3_BIT_STREAM_MODE   *PKSAC3_BIT_STREAM_MODE;

/* Kernel streaming AC3 dialogue level */
typedef struct {
    ULONG   DialogueLevel;
} KSAC3_DIALOGUE_LEVEL;
typedef KSAC3_DIALOGUE_LEVEL    *PKSAC3_DIALOGUE_LEVEL;

/* Kernel streaming AC3 room type */
typedef struct {
    BOOL    fLargeRoom;
} KSAC3_ROOM_TYPE;
typedef KSAC3_ROOM_TYPE *PKSAC3_ROOM_TYPE;

/* Kernel streaming audio decoder output properties */
typedef enum {
    KSPROPERTY_AUDDECOUT_MODES      = 0,
    KSPROPERTY_AUDDECOUT_CUR_MODE   = 1
} KSPROPERTY_AUDDECOUT;

/* Kernel streaming DVD subpicture properties */
typedef enum {
    KSPROPERTY_DVDSUBPIC_PALETTE        = 0,
    KSPROPERTY_DVDSUBPIC_HLI            = 1,
    KSPROPERTY_DVDSUBPIC_COMPOSIT_ON    = 2
} KSPROPERTY_DVDSUBPIC;

/* Kernel streaming DVD YCrCb color information */
typedef struct _KS_DVD_YCrCb {
    UCHAR   Reserved;
    UCHAR   Y;
    UCHAR   Cr;
    UCHAR   Cb;
} KS_DVD_YCrCb;
typedef KS_DVD_YCrCb    *PKS_DVD_YCrCb;

/* Kernel streaming DVD YUV color information */
typedef struct _KS_DVD_YUV {
    UCHAR   Reserved;
    UCHAR   Y;
    UCHAR   V;
    UCHAR   U;
} KS_DVD_YUV;
typedef KS_DVD_YUV  *PKS_DVD_YUV;

/* Kernel streaming palette property */
typedef struct _KSPROPERTY_SPPAL {
    KS_DVD_YUV  sppal[16];
} KSPROPERTY_SPPAL;
typedef KSPROPERTY_SPPAL    *PKSPROPERTY_SPPAL;

/* Kernel streaming color contrast */
typedef struct _KS_COLCON {
    UCHAR   emph1col    : 4;
    UCHAR   emph2col    : 4;
    UCHAR   backcol     : 4;
    UCHAR   patcol      : 4;
    UCHAR   emph1con    : 4;
    UCHAR   emph2con    : 4;
    UCHAR   backcon     : 4;
    UCHAR   patcon      : 4;
} KS_COLCON;
typedef KS_COLCON   *PKS_COLCON;

/* Kernel streaming HLI property */
typedef struct _KSPROPERTY_SPHLI {
    USHORT      HLISS;
    USHORT      Reserved;
    ULONG       StartPTM;
    ULONG       EndPTM;
    USHORT      StartX;
    USHORT      StartY;
    USHORT      StopX;
    USHORT      StopY;
    KS_COLCON   ColCon;
} KSPROPERTY_SPHLI;
typedef KSPROPERTY_SPHLI    *PKSPROPERTY_SPHLI;

/* Kernel streaming copy protection properties */
typedef enum {
    KSPROPERTY_DVDCOPY_CHLG_KEY         = 1,
    KSPROPERTY_DVDCOPY_DVD_KEY1         = 2,
    KSPROPERTY_DVDCOPY_DEC_KEY2         = 3,
    KSPROPERTY_DVDCOPY_TITLE_KEY        = 4,
    KSPROPERTY_COPY_MACROVISION         = 5,
    KSPROPERTY_DVDCOPY_REGION           = 6,
    KSPROPERTY_DVDCOPY_SET_COPY_STATE   = 7,
    KSPROPERTY_DVDCOPY_DISC_KEY         = 0x80
} KSPROPERTY_COPYPROT;

/* Kernel streaming challenge key property */
typedef struct _KS_DVDCOPY_CHLGKEY {
    BYTE    ChlgKey[10];
    BYTE    Reserved[2];
} KS_DVDCOPY_CHLGKEY;
typedef KS_DVDCOPY_CHLGKEY  *PKS_DVDCOPY_CHLGKEY;

/* Kernel streaming bus key property */
typedef struct _KS_DVDCOPY_BUSKEY {
    BYTE    BusKey[5];
    BYTE    Reserved[1];
} KS_DVDCOPY_BUSKEY;
typedef KS_DVDCOPY_BUSKEY   *PKS_DVDCOPY_BUSKEY;

/* Kernel streaming disc key property */
typedef struct _KS_DVDCOPY_DISCKEY {
    BYTE    DiscKey[2048];
} KS_DVDCOPY_DISCKEY;
typedef KS_DVDCOPY_DISCKEY  *PKS_DVDCOPY_DISCKEY;

/* Kernel streaming region property */
typedef struct _KS_DVDCOPY_REGION {
    UCHAR   Reserved;
    UCHAR   RegionData;
    UCHAR   Reserved2[2];
} KS_DVDCOPY_REGION;
typedef KS_DVDCOPY_REGION   *PKS_DVDCOPY_REGION;

/* Kernel streaming title key property */
typedef struct _KS_DVDCOPY_TITLEKEY {
    ULONG   KeyFlags;
    ULONG   ReservedNT[2];
    UCHAR   TitleKey[6];
    UCHAR   Reserved[2];
} KS_DVDCOPY_TITLEKEY;
typedef KS_DVDCOPY_TITLEKEY *PKS_DVDCOPY_TITLEKEY;

/* Kernel streaming MACROVISION property */
typedef struct _KS_COPY_MACROVISION {
    ULONG   MACROVISIONLevel;
} KS_COPY_MACROVISION;
typedef KS_COPY_MACROVISION *PKS_COPY_MACROVISION;

/* Kernel streaming set copy state property */
typedef struct _KS_DVDCOPY_SET_COPY_STATE {
    ULONG   DVDCopyState;
} KS_DVDCOPY_SET_COPY_STATE;
typedef KS_DVDCOPY_SET_COPY_STATE   *PKS_DVDCOPY_SET_COPY_STATE;

/* Kernel streaming DVD copy states */
typedef enum {
    KS_DVDCOPYSTATE_INITIALIZE                  = 0,
    KS_DVDCOPYSTATE_INITIALIZE_TITLE            = 1,
    KS_DVDCOPYSTATE_AUTHENTICATION_NOT_REQUIRED = 2,
    KS_DVDCOPYSTATE_AUTHENTICATION_REQUIRED     = 3,
    KS_DVDCOPYSTATE_DONE                        = 4
} KS_DVDCOPYSTATE;

/* Kernel streaming copy MACROVISION level */
typedef enum {
    KS_MACROVISION_DISABLED = 0,
    KS_MACROVISION_LEVEL1   = 1,
    KS_MACROVISION_LEVEL2   = 2,
    KS_MACROVISION_LEVEL3   = 3
} KS_COPY_MACROVISION_LEVEL;
typedef KS_COPY_MACROVISION_LEVEL   *PKS_COPY_MACROVISION_LEVEL;

/* Kernel streaming RGB quadruple */
typedef struct tagKS_RGBQUAD {
    BYTE    rgbBlue;
    BYTE    rgbGreen;
    BYTE    rgbRed;
    BYTE    rgbReserved;
} KS_RGBQUAD;
typedef KS_RGBQUAD  *PKS_RGBQUAD;
#define KS_SIZE_EGA_PALETTE (KS_iEGA_COLORS * sizeof( KS_RGBQUAD ))
#define KS_SIZE_PALETTE     (KS_iPALETTE_COLORS * sizeof( KS_RGBQUAD))

/* Kernel streaming bitmap information header */
typedef struct tagKS_BITMAPINFOHEADER {
    DWORD   bSize;
    LONG    biWidth;
    LONG    biHeight;
    WORD    biPlanes;
    WORD    biBitCount;
    DWORD   biCompression;
    DWORD   biSizeImage;
    LONG    biXPelsPerMeter;
    LONG    biYPelsPerMeter;
    DWORD   biClrUsed;
    DWORD   biClrImportant;
} KS_BITMAPINFOHEADER;
typedef KS_BITMAPINFOHEADER *PKS_BITMAPINFOHEADER;

/* Kernel streaming true color information */
typedef struct tag_KS_TRUECOLORINFO {
    DWORD       dwBitMasks[KS_iMASK_COLORS];
    KS_RGBQUAD  bmiColors[KS_iPALETTE_COLORS];
} KS_TRUECOLORINFO;
typedef KS_TRUECOLORINFO    *PKS_TRUECOLORINFO;

/* Kernel streaming DIB size macros */
#define KS_WIDTHBYTES( x )      ((DWORD)(((x) + 31) & ~31) / 8)
#define KS_DIBWIDTHBYTES( x ) \
    KS_WIDTHBYTES( (DWORD)(x).biWidth * (DWORD)(x).biBitCount )
#define KS__DIBSIZE( x )        (KS_DIBWIDTHBYTES( x ) * (DWORD)(x).biHeight)
#define KS_DIBSIZE( x ) \
    ((x).biHeight < 0 ? (-1) * KS__DIBSIZE( x ) : KS__DIBSIZE( x ))

/* Kernel streaming video information header */
typedef struct tagKS_VIDEOINFOHEADER {
    RECT                rcSource;
    RECT                rcTarget;
    DWORD               dwBitRate;
    DWORD               dwBitErrorRate;
    REFERENCE_TIME      AvgTimePerFrame;
    KS_BITMAPINFOHEADER bmiHeader;
} KS_VIDEOINFOHEADER;
typedef KS_VIDEOINFOHEADER  *PKS_VIDEOINFOHEADER;

/* Kernel streaming video information */
typedef struct tagKS_VIDEOINFO {
    RECT                rcSource;
    RECT                rcTarget;
    DWORD               dwBitRate;
    DWORD               dwBitErrorRate;
    REFERENCE_TIME      AvgTimePerFrame;
    KS_BITMAPINFOHEADER bmiHeader;
    union {
        KS_RGBQUAD          bmiColors[KS_iPALETTE_COLORS];
        DWORD               dwBitMasks[KS_iMASK_COLORS];
        KS_TRUECOLORINFO    TrueColorInfo;
    };
} KS_VIDEOINFO;
typedef KS_VIDEOINFO    *PKS_VIDEOINFO;

/* Macros to manipulat video information */
#define KS_SIZE_MASKS               (KS_iMASK_COLORS * sizeof( DWORD ))
#define KS_SIZE_PREHEADER           ((DWORD)&((KS_VIDEOINFOHEADER *)0)->bmiHeader)
#define KS_SIZE_VIDEOHEADER( x )    ((x)->bmiHeader.biSize + KS_SIZE_PREHEADER)

/* Kernel streaming VBI information header */
typedef struct tagKS_VBIINFOHEADER {
    ULONG   StartLine;
    ULONG   EndLine;
    ULONG   SamplingFrequency;
    ULONG   MinLineStartTime;
    ULONG   MaxLineStartTime;
    ULONG   ActualLineStartTime;
    ULONG   ActualLineEndTime;
    ULONG   VideoStandard;
    ULONG   SamplesPerLine;
    ULONG   StrideInBytes;
    ULONG   BufferSize;
} KS_VBIINFOHEADER;
typedef KS_VBIINFOHEADER    *PKS_VBIINFOHEADER;

/* Kernel streaming analog video information */
typedef struct tagKS_AnalogVideoInfo {
    RECT            rcSource;
    RECT            rcTarget;
    DWORD           dwActiveWidth;
    DWORD           dwActiveHeight;
    REFERENCE_TIME  AvgTimePerFrame;
} KS_ANALOGVIDEOINFO;
typedef KS_ANALOGVIDEOINFO  *PKS_ANALOGVIDEOINFO;

/* Kernel streaming TV tuner change information */
typedef struct tagKS_TVTUNER_CHANGE_INFO {
    DWORD   dwFlags;
    DWORD   dwCountryCode;
    DWORD   dwAnalogVideoStandard;
    DWORD   dwChannel;
} KS_TVTUNER_CHANGE_INFO;
typedef KS_TVTUNER_CHANGE_INFO  *PKS_TVTUNER_CHANGE_INFO;

/* Kernel streaming MPEG-2 levels */
typedef enum {
    KS_MPEG2Level_Low       = 0,
    KS_MPEG2Level_Main      = 1,
    KS_MPEG2Level_High1440  = 2,
    KS_MPEG2Level_High      = 3
} KS_MPEG2Level;

/* Kernel streaming MPEG-2 profiles */
typedef enum {
    KS_MPEG2Profile_Simple              = 0,
    KS_MPEG2Profile_Main                = 1,
    KS_MPEG2Profile_SNRScalable         = 2,
    KS_MPEG2Profile_SpatiallyScalable   = 3,
    KS_MPEG2Profile_High                = 4
} KS_MPEG2Profile;

/* Kernel streaming video information header (version 2) */
typedef struct tagKS_VIDEOINFOHEADER2 {
    RECT                rcSource;
    RECT                rcTarget;
    DWORD               dwBitRate;
    DWORD               dwBitErrorRate;
    REFERENCE_TIME      AvgTimePerFrame;
    DWORD               dwInterlaceFlags;
    DWORD               dwCopyProtectFlags;
    DWORD               dwPictAspectRatioX;
    DWORD               dwPictAspectRatioY;
    union {
        DWORD   dwControlFlags;
        DWORD   dwReserved1;
    };
    DWORD               dwReserved2;
    KS_BITMAPINFOHEADER bmiHeader;
} KS_VIDEOINFOHEADER2;
typedef KS_VIDEOINFOHEADER2 *PKS_VIDEOINFOHEADER2;

/* Kernel streaming MPEG-1 video information */
typedef struct tagKS_MPEG1VIDEOINFO {
    KS_VIDEOINFOHEADER  hdr;
    DWORD               dwStartTimeCode;
    DWORD               cbSequenceHeader;
    BYTE                bSequenceHeader[1];
} KS_MPEG1VIDEOINFO;
typedef KS_MPEG1VIDEOINFO   *PKS_MPEG1VIDEOINFO;
#define KS_MAX_SIZE_MPEG1_SEQUENCE_INFO 140
#define KS_SIZE_MPEG1VIDEOINFO( x ) \
    ((DWORD)&((KS_MPEG1VIDEOINFO *)0)->bSequenceHeader[0] + (x)->cbSequenceHeader)
#define KS_MPEG1_SEQUENCE_INFO( x ) \
    ((const BYTE *)(x)->bSequenceHeader)

/* Kernel streaming MPEG video information (version 2) */
typedef struct tagKS_MPEGVIDEOINFO2 {
    KS_VIDEOINFOHEADER2 hdr;
    DWORD               dwStartTimeCode;
    DWORD               cbSequenceHeader;
    DWORD               dwProfile;
    DWORD               dwLevel;
    DWORD               dwFlags;
    DWORD               bSequenceHeader[1];
} KS_MPEGVIDEOINFO2;
typedef KS_MPEGVIDEOINFO2   *PKS_MPEGVIDEOINFO2;
#define KS_SIZE_MPEGVIDEOINFO2( x ) \
    ((DWORD)&((KS_MPEGVIDEOINFO2 *)0)->bSequenceHeader[0]) + (x)->cbSequenceHeader)
#define KS_MPEG1_SEQUENCE_INFO( x ) \
    ((const BYTE *)(x)->bSequenceHeader)

/* Kernel streaming MPEG audio information */
typedef struct tagKS_MPEGAUDIOINFO {
    DWORD   dwFlags;
    DWORD   dwReserved1;
    DWORD   dwReserved2;
    DWORD   dwReserved3;
} KS_MPEGAUDIOINFO;
typedef KS_MPEGAUDIOINFO    *PKS_MPEGAUDIOINFO;

/* Kernel streaming video information header data format */
typedef struct tagKS_DATAFORMAT_VIDEOINFOHEADER {
    KSDATAFORMAT        DataFormat;
    KS_VIDEOINFOHEADER  VideoInfoHeader;
} KS_DATAFORMAT_VIDEOINFOHEADER;
typedef KS_DATAFORMAT_VIDEOINFOHEADER   *PKS_DATAFORMAT_VIDEOINFOHEADER;

/* Kernel streaming video information header data format (version 2) */
typedef struct tagKS_DATAFORMAT_VIDEOINFOHEADER2 {
    KSDATAFORMAT        DataFormat;
    KS_VIDEOINFOHEADER2 VideoInfoHeader2;
} KS_DATAFORMAT_VIDEOINFOHEADER2;
typedef KS_DATAFORMAT_VIDEOINFOHEADER2  *PKS_DATAFORMAT_VIDEOINFOHEADER2;

/* Kernel streaming MPEG video information data format (version 2) */
typedef struct tagKS_DATAFORMAT_MPEGVIDEOINFO2 {
    KSDATAFORMAT        DataFormat;
    KS_MPEGVIDEOINFO2   MpegVideoInfoHeader2;
} KS_DATAFORMAT_MPEGVIDEOINFO2;
typedef KS_DATAFORMAT_MPEGVIDEOINFO2    *PKS_DATAFORMAT_MPEGVIDEOINFO2;

/* Kernel streaming video information palette data format */
typedef struct tagKS_DATAFORMAT_VIDEOINFO_PALETTE {
    KSDATAFORMAT    DataFormat;
    KS_VIDEOINFO    VideoInfo;
} KS_DATAFORMAT_VIDEOINFO_PALETTE;
typedef KS_DATAFORMAT_VIDEOINFO_PALETTE *PKS_DATAFORMAT_VIDEOINFO_PALETTE;

/* Kernel streaming VBI information header data format */
typedef struct tagKS_DATAFORMAT_VBIINFOHEADER {
    KSDATAFORMAT        DataFormat;
    KS_VBIINFOHEADER    VBIInfoHeader;
} KS_DATAFORMAT_VBIINFOHEADER;
typedef KS_DATAFORMAT_VBIINFOHEADER *PKS_DATAFORMAT_VBIINFOHEADER;

/* Kernel streaming video stream configuration capabilities */
typedef struct _KS_VIDEO_STREAM_CONFIG_CAPS {
    GUID        guid;
    ULONG       VideoStandard;
    SIZE        InputSize;
    SIZE        MinCroppingSize;
    SIZE        MaxCroppingSize;
    int         CropGranularityX;
    int         CropGranularityY;
    int         CropAlignX;
    int         CropAlignY;
    SIZE        MinOutputSize;
    SIZE        MaxOutputSize;
    int         OutputGranularityX;
    int         OutputGranularityY;
    int         StretchTapsX;
    int         StretchTapsY;
    int         ShrinkTapsX;
    int         ShrinkTapsY;
    LONGLONG    MinFrameInterval;
    LONGLONG    MaxFrameInterval;
    LONG        MinBitsPerSecond;
    LONG        MaxBitsPerSecond;
} KS_VIDEO_STREAM_CONFIG_CAPS;
typedef KS_VIDEO_STREAM_CONFIG_CAPS *PKS_VIDEO_STREAM_CONFIG_CAPS;

/* Kernel streaming video data range */
typedef struct tagKS_DATARANGE_VIDEO {
    KSDATARANGE                 DataRange;
    BOOL                        bFixedSizeSamples;
    BOOL                        bTemporalCompression;
    DWORD                       StreamDescriptionFlags;
    DWORD                       MemoryAllocationFlags;
    KS_VIDEO_STREAM_CONFIG_CAPS ConfigCaps;
    KS_VIDEOINFOHEADER          VideoInfoHeader;
} KS_DATARANGE_VIDEO;
typedef KS_DATARANGE_VIDEO  *PKS_DATARANGE_VIDEO;

/* Kernel streaming video data range (version 2) */
typedef struct tagKS_DATARANGE_VIDEO2 {
    KSDATARANGE                 DataRange;
    BOOL                        bFixedSizeSamples;
    BOOL                        bTemporalCompression;
    DWORD                       StreamDescriptionFlags;
    DWORD                       MemoryAllocationFlags;
    KS_VIDEO_STREAM_CONFIG_CAPS ConfigCaps;
    KS_VIDEOINFOHEADER2         VideoInfoHeader;
} KS_DATARANGE_VIDEO2;
typedef KS_DATARANGE_VIDEO2 *PKS_DATARANGE_VIDEO2;

/* Kernel streaming MPEG-1 video data range */
typedef struct tagKS_DATARANGE_MPEG1_VIDEO {
    KSDATARANGE                 DataRange;
    BOOL                        bFixedSizeSamples;
    BOOL                        bTemporalCompression;
    DWORD                       StreamDescriptionFlags;
    DWORD                       MemoryAllocationFlags;
    KS_VIDEO_STREAM_CONFIG_CAPS ConfigCaps;
    KS_MPEG1VIDEOINFO           VideoInfoHeader;
} KS_DATARANGE_MPEG1_VIDEO;
typedef KS_DATARANGE_MPEG1_VIDEO    *PKS_DATARANGE_MPEG1_VIDEO;

/* Kernel streaming MPEG-2 video data range */
typedef struct tagKS_DATARANGE_MPEG2_VIDEO {
    KSDATARANGE                 DataRange;
    BOOL                        bFixedSizeSamples;
    BOOL                        bTemporalCompression;
    DWORD                       StreamDescriptionFlags;
    DWORD                       MemoryAllocationFlags;
    KS_VIDEO_STREAM_CONFIG_CAPS ConfigCaps;
    KS_MPEGVIDEOINFO2           VideoInfoHeader;
} KS_DATARANGE_MPEG2_VIDEO;
typedef KS_DATARANGE_MPEG2_VIDEO    *PKS_DATARANGE_MPEG2_VIDEO;

/* Kernel streaming video palette data range */
typedef struct tagKS_DATARANGE_VIDEO_PALETTE {
    KSDATARANGE                 DataRange;
    BOOL                        bFixedSizeSamples;
    BOOL                        bTemporalCompression;
    DWORD                       StreamDescriptionFlags;
    DWORD                       MemoryAllocationFlags;
    KS_VIDEO_STREAM_CONFIG_CAPS ConfigCaps;
    KS_VIDEOINFO                VideoInfo;
} KS_DATARANGE_VIDEO_PALETTE;
typedef KS_DATARANGE_VIDEO_PALETTE  *PKS_DATARANGE_VIDEO_PALETTE;

/* Kernel streaming VBI video data range */
typedef struct tagKS_DATARANGE_VIDEO_VBI {
    KSDATARANGE                 DataRange;
    BOOL                        bFixedSizeSamples;
    BOOL                        bTemporalCompression;
    DWORD                       StreamDescriptionFlags;
    DWORD                       MemoryAllocationFlags;
    KS_VIDEO_STREAM_CONFIG_CAPS ConfigCaps;
    KS_VBIINFOHEADER            VBIInfoHeader;
} KS_DATARANGE_VIDEO_VBI;
typedef KS_DATARANGE_VIDEO_VBI  *PKS_DATARANGE_VIDEO_VBI;

/* Kernel streaming analog video data range */
typedef struct tagKS_DATARANGE_ANALOGVIDEO {
    KSDATARANGE                 DataRange;
    KS_ANALOGVIDEOINFO          AnalogVideoInfo;
} KS_DATARANGE_ANALOGVIDEO;
typedef KS_DATARANGE_ANALOGVIDEO    *PKS_DATARANGE_ANALOGVIDEO;

/* Kernel streaming VBI capture properties */
#if (NTDDI_VERSION >= 0x05010000)
typedef enum {
    KSPROPERTY_VBICAP_PROPERTIES_PROTECTION = 1,
} KSPROPERTY_VBICAP;
#endif

/* VBI capture protection properties */
#if (NTDDI_VERSION >= 0x05010000)
typedef struct _VBICAP_PROPERTIES_PROTECTION_S {
    KSPROPERTY  Property;
    ULONG       StreamIndex;
    ULONG       Status;
} VBICAP_PROPERTIES_PROTECTION_S;
typedef VBICAP_PROPERTIES_PROTECTION_S  *PVBICAP_PROPERTIES_PROTECTION_S;
#endif

/* NABTSFEC buffer */
typedef struct _NABTSFEC_BUFFER {
    ULONG   dataSize;
    USHORT  groupID;
    USHORT  Reserved;
    UCHAR   data[NABTS_LINES_PER_BUNDLE * NABTS_PAYLOAD_PER_LINE];
} NABTSFEC_BUFFER;
typedef NABTSFEC_BUFFER *PNABTSFEC_BUFFER;

/* Kernel streaming VBI codec filtering properties */
typedef enum {
    KSPROPERTY_VBICODECFILTERING_SCANLINES_REQUESTED_BIT_ARRAY      = 1,
    KSPROPERTY_VBICODECFILTERING_SCANLINES_DISCOVERED_BIT_ARRAY     = 2,
    KSPROPERTY_VBICODECFILTERING_SUBSTREAMS_REQUESTED_BIT_ARRAY     = 3,
    KSPROPERTY_VBICODECFILTERING_SUBSTREAMS_DISCOVERED_BIT_ARRAY    = 4,
    KSPROPERTY_VBICODECFILTERING_STATISTICS                         = 5
} KSPROPERTY_VBICODECFILTERING;

/* VBI codec filtering scan lines */
typedef struct _VBICODECFILTERING_SCANLINES {
    DWORD   DwordBitArray[32];
} VBICODECFILTERING_SCANLINES;
typedef VBICODECFILTERING_SCANLINES *PVBICODECFILTERING_SCANLINES;

/* VBI codec filtering NABTS substreams */
typedef struct _VBICODECFILTERING_NABTS_SUBSTREAMS {
    DWORD   SubstreamMask[128];
} VBICODECFILTERING_NABTS_SUBSTREAMS;
typedef VBICODECFILTERING_NABTS_SUBSTREAMS  *PVBICODECFILTERING_NABTS_SUBSTREAMS;

/* VBI codec filtering closed caption substreams */
typedef struct _VBICODECFILTERING_CC_SUBSTREAMS {
    DWORD   SubstreamMask;
} VBICODECFILTERING_CC_SUBSTREAMS;
typedef VBICODECFILTERING_CC_SUBSTREAMS *PVBICODECFILTERING_CC_SUBSTREAMS;

/* Closed caption byte pair */
#if (NTDDI_VERSION >= 0x05010000)
typedef struct _CC_BYTE_PAIR {
    BYTE    Decoded[2];
    USHORT  Reserved;
} CC_BYTE_PAIR;
typedef CC_BYTE_PAIR    *PCC_BYTE_PAIR;
#endif

/* Closed caption hardware field */
#if (NTDDI_VERSION >= 0x05010000)
typedef struct _CC_HW_FIELD {
    VBICODECFILTERING_SCANLINES ScanlinesRequested;
    ULONG                       fieldFlags;
    LONGLONG                    PictureNumber;
    CC_BYTE_PAIR                Lines[CC_MAX_HW_DECODE_LINES];
} CC_HW_FIELD;
typedef CC_HW_FIELD *PCC_HW_FIELD;
#endif

/* NABTS buffer line */
#include <pshpack1.h>
typedef struct _NABTS_BUFFER_LINE {
    BYTE    Confidence;
    BYTE    Bytes[NABTS_BYTES_PER_LINE];
} NABTS_BUFFER_LINE;
typedef NABTS_BUFFER_LINE   *PNABTS_BUFFER_LINE;
#include <poppack.h>

/* NABTS buffer */
#include <pshpack1.h>
typedef struct _NABTS_BUFFER {
    VBICODECFILTERING_SCANLINES ScanlinesRequested;
    LONGLONG                    PictureNumber;
    NABTS_BUFFER_LINE           NabtsLines[MAX_NABTS_VBI_LINES_PER_FIELD];
} NABTS_BUFFER;
typedef NABTS_BUFFER    *PNABTS_BUFFER;
#include <poppack.h>

/* WST buffer line */
#if (NTDDI_VERSION >= 0x05010000)
typedef struct _WST_BUFFER_LINE {
    BYTE    Confidence;
    BYTE    Bytes[WST_BYTES_PER_LINE];
} WST_BUFFER_LINE;
typedef WST_BUFFER_LINE *PWST_BUFFER_LINE;
#endif

/* WST buffer */
#if (NTDDI_VERSION >= 0x05010000)
typedef struct _WST_BUFFER {
    VBICODECFILTERING_SCANLINES ScanlinesRequested;
    WST_BUFFER_LINE             WstLines[MAX_WST_VBI_LINES_PER_FIELD];
} WST_BUFFER;
typedef WST_BUFFER  *PWST_BUFFER;
#endif

/* VBI codec filtering common statistics */
typedef struct _VBICODECFILTERING_STATISTICS_COMMON {
    DWORD   InputSRBsProcessed;
    DWORD   OutputSRBsProcessed;
    DWORD   SRBsIgnored;
    DWORD   InputSRBsMissing;
    DWORD   OutputSRBsMissing;
    DWORD   OutputFailures;
    DWORD   InternalErrors;
    DWORD   ExternalErrors;
    DWORD   InputDiscontinuities;
    DWORD   DSPFailures;
    DWORD   TvTunerChanges;
    DWORD   VBIHeaderChanges;
    DWORD   LineConfidenceAvg;
    DWORD   BytesOutput;
} VBICODECFILTERING_STATISTICS_COMMON;
typedef VBICODECFILTERING_STATISTICS_COMMON *PVBICODECFILTERING_STATISTICS_COMMON;

/* VBI codec filtering common pin statistics */
typedef struct _VBICODECFILTERING_STATISTICS_COMMON_PIN {
    DWORD   SRBsProcessed;
    DWORD   SRBsIgnored;
    DWORD   SRBsMissing;
    DWORD   InternalErrors;
    DWORD   ExternalErrors;
    DWORD   Discontinuities;
    DWORD   LineConfidenceAvg;
    DWORD   BytesOutput;
} VBICODECFILTERING_STATISTICS_COMMON_PIN;
typedef VBICODECFILTERING_STATISTICS_COMMON_PIN *PVBICODECFILTERING_STATISTICS_COMMON_PIN;

/* VBI codec filtering NABTS statistics */
typedef struct _VBICODECFILTERING_STATISTICS_NABTS {
    VBICODECFILTERING_STATISTICS_COMMON Common;
    DWORD                               FECBundleBadLines;
    DWORD                               FECQueueOverflows;
    DWORD                               FECCorrectedLines;
    DWORD                               FECUncorrectableLines;
    DWORD                               BundlesProcessed;
    DWORD                               BundlesSent2IP;
    DWORD                               FilteredLines;
} VBICODECFILTERING_STATISTICS_NABTS;
typedef VBICODECFILTERING_STATISTICS_NABTS  *PVBICODECFILTERING_STATISTICS_NABTS;

/* VBI codec filtering NABTS pin statistics */
typedef struct _VBICODECFILTERING_STATISTICS_NABTS_PIN {
    VBICODECFILTERING_STATISTICS_COMMON_PIN Common;
} VBICODECFILTERING_STATISTICS_NABTS_PIN;
typedef VBICODECFILTERING_STATISTICS_NABTS_PIN  *PVBICODECFILTERING_STATISTICS_NABTS_PIN;

/* VBI codec filtering closed caption statistics */
typedef struct _VBICODECFILTERING_STATISTICS_CC {
    VBICODECFILTERING_STATISTICS_COMMON Common;
} VBICODECFILTERING_STATISTICS_CC;
typedef VBICODECFILTERING_STATISTICS_CC *PVBICODECFILTERING_STATISTICS_CC;

/* VBI codec filtering closed caption pin statistics */
typedef struct _VBICODECFILTERING_STATISTICS_CC_PIN {
    VBICODECFILTERING_STATISTICS_COMMON_PIN Common;
} VBICODECFILTERING_STATISTICS_CC_PIN;
typedef VBICODECFILTERING_STATISTICS_CC_PIN *PVBICODECFILTERING_STATISTICS_CC_PIN;

/* VBI codec filtering Teletext statistics */
#if (NTDDI_VERSION >= 0x05010000)
typedef struct _VBICODECFILTERING_STATISTICS_TELETEXT {
    VBICODECFILTERING_STATISTICS_COMMON Common;
} VBICODECFILTERING_STATISTICS_TELETEXT;
typedef VBICODECFILTERING_STATISTICS_TELETEXT   *PVBICODECFILTERING_STATISTICS_TELETEXT;
#endif

/* VBI codec filtering Teletext pin statistics */
#if (NTDDI_VERSION >= 0x05010000)
typedef struct _VBICODECFILTERING_STATISTICS_TELETEXT_PIN {
    VBICODECFILTERING_STATISTICS_COMMON_PIN Common;
} VBICODECFILTERING_STATISTICS_TELETEXT_PIN;
typedef VBICODECFILTERING_STATISTICS_TELETEXT_PIN   *PVBICODECFILTERING_STATISTICS_TELETEXT_PIN;
#endif

/* Kernel streaming VBI codec filtering scanlines property */
typedef struct {
    KSPROPERTY                  Property;
    VBICODECFILTERING_SCANLINES Scanlines;
} KSPROPERTY_VBICODECFILTERING_SCANLINES_S;
typedef KSPROPERTY_VBICODECFILTERING_SCANLINES_S    *PKSPROPERTY_VBICODECFILTERING_SCANLINES_S;

/* Kernel streaming VBI codec filtering NABTS substreams property */
typedef struct {
    KSPROPERTY                          Property;
    VBICODECFILTERING_NABTS_SUBSTREAMS  Substreams;
} KSPROPERTY_VBICODECFILTERING_NABTS_SUBSTREAMS_S;
typedef KSPROPERTY_VBICODECFILTERING_NABTS_SUBSTREAMS_S *PKSPROPERTY_VBICODECFILTERING_NABTS_SUBSTREAMS_S;

/* Kernel streaming VBI codec filtering closed caption substreams property */
typedef struct {
    KSPROPERTY                      Property;
    VBICODECFILTERING_CC_SUBSTREAMS Substreams;
} KSPROPERTY_VBICODECFILTERING_CC_SUBSTREAMS_S;
typedef KSPROPERTY_VBICODECFILTERING_CC_SUBSTREAMS_S    *PKSPROPERTY_VBICODECFILTERING_CC_SUBSTREAMS_S;

/* Kernel streaming VBI codec filtering common statistics property */
typedef struct {
    KSPROPERTY                          Property;
    VBICODECFILTERING_STATISTICS_COMMON Statistics;
} KSPROPERTY_VBICODECFILTERING_STATISTICS_COMMON_S;
typedef KSPROPERTY_VBICODECFILTERING_STATISTICS_COMMON_S    *PKSPROPERTY_VBICODECFILTERING_STATISTICS_COMMON_S;

/* Kernel streaming VBI codec filtering common pin statistics property */
typedef struct {
    KSPROPERTY                              Property;
    VBICODECFILTERING_STATISTICS_COMMON_PIN Statistics;
} KSPROPERTY_VBICODECFILTERING_STATISTICS_COMMON_PIN_S;
typedef KSPROPERTY_VBICODECFILTERING_STATISTICS_COMMON_PIN_S    *PKSPROPERTY_VBICODECFILTERING_STATISTICS_COMMON_PIN_S;

/* Kernel streaming VBI codec filtering NABTS statistics property */
typedef struct {
    KSPROPERTY                          Property;
    VBICODECFILTERING_STATISTICS_NABTS  Statistics;
} KSPROPERTY_VBICODECFILTERING_STATISTICS_NABTS_S;
typedef KSPROPERTY_VBICODECFILTERING_STATISTICS_NABTS_S *PKSPROPERTY_VBICODECFILTERING_STATISTICS_NABTS_S;

/* Kernel streaming VBI codec filtering NABTS pin statistics property */
typedef struct {
    KSPROPERTY                              Property;
    VBICODECFILTERING_STATISTICS_NABTS_PIN  Statistics;
} KSPROPERTY_VBICODECFILTERING_STATISTICS_NABTS_PIN_S;
typedef KSPROPERTY_VBICODECFILTERING_STATISTICS_NABTS_PIN_S *PKSPROPERTY_VBICODECFILTERING_STATISTICS_NABTS_PIN_S;

/* Kernel streaming VBI codec filtering closed caption statistics property */
typedef struct {
    KSPROPERTY                      Property;
    VBICODECFILTERING_STATISTICS_CC Statistics;
} KSPROPERTY_VBICODECFILTERING_STATISTICS_CC_S;
typedef KSPROPERTY_VBICODECFILTERING_STATISTICS_CC_S    *PKSPROPERTY_VBICODECFILTERING_STATISTICS_CC_S;

/* Kernel streaming VBI codec filtering closed caption pin statistics property */
typedef struct {
    KSPROPERTY                          Property;
    VBICODECFILTERING_STATISTICS_CC_PIN Statistics;
} KSPROPERTY_VBICODECFILTERING_STATISTICS_CC_PIN_S;
typedef KSPROPERTY_VBICODECFILTERING_STATISTICS_CC_PIN_S    *PKSPROPERTY_VBICODECFILTERING_STATISTICS_CC_PIN_S;

/* Kernel streaming capture memory allocation flags */
typedef enum {
    KS_CAPTURE_ALLOC_INVALID        = 0x00000000,
    KS_CAPTURE_ALLOC_SYSTEM         = 0x00000001,
    KS_CAPTURE_ALLOC_VRAM           = 0x00000002,
    KS_CAPTURE_ALLOC_SYSTEM_AGP     = 0x00000004,
    KS_CAPTURE_ALLOC_VRAM_MAPPED    = 0x00000008,
} CAPTURE_MEMORY_ALLOCATION_FLAGS;
typedef CAPTURE_MEMORY_ALLOCATION_FLAGS *PCAPTURE_MEMORY_ALLOCATION_FLAGS;

/* Kernel streaming video memory transport properties */
typedef enum {
    KSPROPERTY_DISPLAY_ADAPTER_GUID                 = 1,
    KSPROPERTY_PREFERRED_CAPTURE_SURFACE            = 2,
    KSPROPERTY_CURRENT_CAPTURE_SURFACE              = 3,
    KSPROPERTY_MAP_CAPTURE_HANDLE_TO_RAM_ADDRESS    = 4
} KSPROPERTY_VIDMEM_TRANSPORT;

/* VRAM surface information */
typedef struct {
    UINT_PTR    hSurface;
    LONGLONG    VramPhysicalAddress;
    DWORD       cbCaptured;
    DWORD       dwWidth;
    DWORD       dwHeight;
    DWORD       dwLinearSize;
    LONG        lPitch;
    ULONGLONG   ullReserved[16];
} VRAM_SURFACE_INFO;
typedef VRAM_SURFACE_INFO   *PVRAM_SURFACE_INFO;

/* VRAM surface information property */
typedef struct {
    KSPROPERTY          Property;
    PVRAM_SURFACE_INFO  pVramSurfaceInfo;
} VRAM_SURFACE_INFO_PROPERTY_S;
typedef VRAM_SURFACE_INFO_PROPERTY_S    *PVRAM_SURFACE_INFO_PROPERTY_S;

/* Kernel streaming property MPEG4 media type attributes */
typedef enum {
    KSPROPERTY_MPEG4_MEDIATYPE_SD_BOX   = 1
} KSPROPERTY_MPEG4_MEDIATYPE_ATTRIBUTES;

/* Kernel streaming dynamic format change events */
enum {
    KSEVENT_DYNAMIC_FORMAT_CHANGE   = 0
};

/* Kernel streaming frame information */
typedef struct tagKS_FRAME_INFO {
    ULONG       ExtendedHeaderSize;
    DWORD       dwFrameFlags;
    LONGLONG    PictureNumber;
    LONGLONG    DropCount;
    HANDLE      hDirectDraw;
    HANDLE      hSurfaceHandle;
    RECT        DirectDrawRect;
    union {
        LONG    lSurfacePitch;
        DWORD   Reserved1;
    };
    DWORD       Reserved2;
    DWORD       Reserved3;
    DWORD       Reserved4;
} KS_FRAME_INFO;
typedef KS_FRAME_INFO   *PKS_FRAME_INFO;

/* Kernel streaming VBI frame information */
typedef struct tagKS_VBI_FRAME_INFO {
    ULONG                   ExtendedHeaderSize;
    DWORD                   dwFrameFlags;
    LONGLONG                PictureNumber;
    LONGLONG                DropCount;
    DWORD                   dwSamplingFrequency;
    KS_TVTUNER_CHANGE_INFO  TvTunerChangeInfo;
    KS_VBIINFOHEADER        VBIInfoHeader;
} KS_VBI_FRAME_INFO;
typedef KS_VBI_FRAME_INFO   *PKS_VBI_FRAME_INFO;

/* Kernel streaming analog video standards */
typedef enum {
    KS_AnalogVideo_None         = 0x00000000,
    KS_AnalogVideo_NTSC_M       = 0x00000001,
    KS_AnalogVideo_NTSC_M_J     = 0x00000002,
    KS_AnalogVideo_NTSC_433     = 0x00000004,
    KS_AnalogVideo_PAL_B        = 0x00000010,
    KS_AnalogVideo_PAL_D        = 0x00000020,
    KS_AnalogVideo_PAL_G        = 0x00000040,
    KS_AnalogVideo_PAL_H        = 0x00000080,
    KS_AnalogVideo_PAL_I        = 0x00000100,
    KS_AnalogVideo_PAL_M        = 0x00000200,
    KS_AnalogVideo_PAL_N        = 0x00000400,
    KS_AnalogVideo_PAL_60       = 0x00000800,
    KS_AnalogVideo_SECAM_B      = 0x00001000,
    KS_AnalogVideo_SECAM_D      = 0x00002000,
    KS_AnalogVideo_SECAM_G      = 0x00004000,
    KS_AnalogVideo_SECAM_H      = 0x00008000,
    KS_AnalogVideo_SECAM_K      = 0x00010000,
    KS_AnalogVideo_SECAM_K1     = 0x00020000,
    KS_AnalogVideo_SECAM_L      = 0x00040000,
#if (NTDDI_VERSION >= 0x05010000)
    KS_AnalogVideo_SECAM_L1     = 0x00080000,
    KS_AnalogVideo_PAL_N_COMBO  = 0x00100000
#else
    KS_AnalogVideo_SECAM_L1     = 0x00080000
#endif
} KS_AnalogVideoStandard;

/* Kernel streaming allocator control properties */
typedef enum {
    KSPROPERTY_ALLOCATOR_CONTROL_HONOR_COUNT        = 0,
#if (NTDDI_VERSION >= 0x05010000)
    KSPROPERTY_ALLOCATOR_CONTROL_SURFACE_SIZE       = 1,
    KSPROPERTY_ALLOCATOR_CONTROL_CAPTURE_CAPS       = 2,
    KSPROPERTY_ALLOCATOR_CONTROL_CAPTURE_INTERLEAVE = 3
#else
    KSPROPERTY_ALLOCATOR_CONTROL_SURFACE_SIZE       = 1
#endif
} KSPROPERTY_ALLOCATOR_CONTROL;

/* Kernel streaming allocator control surface size property */
#if (NTDDI_VERSION >= 0x05010000)
typedef struct {
    ULONG   CX;
    ULONG   CY;
} KSPROPERTY_ALLOCATOR_CONTROL_SURFACE_SIZE_S;
typedef KSPROPERTY_ALLOCATOR_CONTROL_SURFACE_SIZE_S *PKSPROPERTY_ALLOCATOR_CONTROL_SURFACE_SIZE_S;
#endif

/* Kernel streaming allocator control capture capabilities property */
#if (NTDDI_VERSION >= 0x05010000)
typedef struct {
    ULONG   InterleavedCapSupported;
} KSPROPERTY_ALLOCATOR_CONTROL_CAPTURE_CAPS_S;
typedef KSPROPERTY_ALLOCATOR_CONTROL_CAPTURE_CAPS_S *PKSPROPERTY_ALLOCATOR_CONTROL_CAPTURE_CAPS_S;
#endif

/* Kernel streaming allocator control capture interleave property */
#if (NTDDI_VERSION >= 0x05010000)
typedef struct {
    ULONG   InterleavedCapPossible;
} KSPROPERTY_ALLOCATOR_CONTROL_CAPTURE_INTERLEAVE_S;
typedef KSPROPERTY_ALLOCATOR_CONTROL_CAPTURE_INTERLEAVE_S   *PKSPROPERTY_ALLOCATOR_CONTROL_CAPTURE_INTERLEAVE_S;
#endif

/* Kernel streaming video procedure amplifier properties */
typedef enum {
    KSPROPERTY_VIDEOPROCAMP_BRIGHTNESS                  = 0,
    KSPROPERTY_VIDEOPROCAMP_CONTRAST                    = 1,
    KSPROPERTY_VIDEOPROCAMP_HUE                         = 2,
    KSPROPERTY_VIDEOPROCAMP_SATURATION                  = 3,
    KSPROPERTY_VIDEOPROCAMP_SHARPNESS                   = 4,
    KSPROPERTY_VIDEOPROCAMP_GAMMA                       = 5,
    KSPROPERTY_VIDEOPROCAMP_COLORENABLE                 = 6,
    KSPROPERTY_VIDEOPROCAMP_WHITEBALANCE                = 7,
#if (NTDDI_VERSION >= 0x05010000)
    KSPROPERTY_VIDEOPROCAMP_BACKLIGHT_COMPENSATION      = 8,
#if ((NTDDI_VERSION >= 0x05010200) && (NTDDI_VERSION < 0x05020000)) || \
    (NTDDI_VERSION >= 0x05020100)
    KSPROPERTY_VIDEOPROCAMP_GAIN                        = 9,
    KSPROPERTY_VIDEOPROCAMP_DIGITAL_MULTIPLIER          = 10,
    KSPROPERTY_VIDEOPROCAMP_DIGITAL_MULTIPLIER_LIMIT    = 11,
    KSPROPERTY_VIDEOPROCAMP_WHITEBALANCE_COMPONENT      = 12,
    KSPROPERTY_VIDEOPROCAMP_POWERLINE_FREQUENCY         = 13
#else
    KSPROPERTY_VIDEOPROCAMP_GAIN                        = 9
#endif
#else
    KSPROPERTY_VIDEOPROCAMP_BACKLIGHT_COMPENSATION      = 8
#endif
} KSPROPERTY_VIDCAP_VIDEOPROCAMP;

/* Kernel streaming video procedure amplifier property */
typedef struct {
    KSPROPERTY  Property;
    LONG        Value;
    ULONG       Flags;
    ULONG       Capabilities;
} KSPROPERTY_VIDEOPROCAMP_S;
typedef KSPROPERTY_VIDEOPROCAMP_S   *PKSPROPERTY_VIDEOPROCAMP_S;

/* Kernel streaming video procedure amplifier node property */
#if ((NTDDI_VERSION >= 0x05010200) && (NTDDI_VERSION < 0x05020000)) || \
    (NTDDI_VERSION >= 0x05020100)
typedef struct {
    KSP_NODE    NodeProperty;
    LONG        Value;
    ULONG       Flags;
    ULONG       Capabilities;
} KSPROPERTY_VIDEOPROCAMP_NODE_S;
typedef KSPROPERTY_VIDEOPROCAMP_NODE_S  *PKSPROPERTY_VIDEOPROCAMP_NODE_S;
#endif

/* Kernel streaming video procedure amplifier property (version 2) */
#if ((NTDDI_VERSION >= 0x05010200) && (NTDDI_VERSION < 0x05020000)) || \
    (NTDDI_VERSION >= 0x05020100)
typedef struct {
    KSPROPERTY  Property;
    LONG        Value1;
    ULONG       Flags;
    ULONG       Capabilities;
    LONG        Value2;
} KSPROPERTY_VIDEOPROCAMP_S2;
typedef KSPROPERTY_VIDEOPROCAMP_S2  *PKSPROPERTY_VIDEOPROCAMP_S2;
#endif

/* Kernel streaming video procedure amplifier node property (version 2) */
#if ((NTDDI_VERSION >= 0x05010200) && (NTDDI_VERSION < 0x05020000)) || \
    (NTDDI_VERSION >= 0x05020100)
typedef struct {
    KSP_NODE    NodeProperty;
    LONG        Value1;
    ULONG       Flags;
    ULONG       Capabilities;
    LONG        Value2;
} KSPROPERTY_VIDEOPROCAMP_NODE_S2;
typedef KSPROPERTY_VIDEOPROCAMP_NODE_S2 *PKSPROPERTY_VIDEOPROCAMP_NODE_S2;
#endif

/* Kernel streaming video capture selector properties */
#if ((NTDDI_VERSION >= 0x05010200) && (NTDDI_VERSION < 0x05020000)) || \
    (NTDDI_VERSION >= 0x05020100)
typedef enum {
    KSPROPERTY_SELECTOR_SOURCE_NODE_ID  = 0,
    KSPROPERTY_SELECTOR_NUM_SOURCES     = 1
} KSPROPERTY_VIDCAP_SELECTOR;
typedef KSPROPERTY_VIDCAP_SELECTOR  *PKSPROPERTY_VIDCAP_SELECTOR;
#endif

/* Kernel streaming selector property */
#if ((NTDDI_VERSION >= 0x05010200) && (NTDDI_VERSION < 0x05020000)) || \
    (NTDDI_VERSION >= 0x05020100)
typedef struct {
    KSPROPERTY  Property;
    LONG        Value;
    ULONG       Flags;
    ULONG       Capabilities;
} KSPROPERTY_SELECTOR_S;
typedef KSPROPERTY_SELECTOR_S   *PKSPROPERTY_SELECTOR_S;
#endif

/* Kernel streaming selector node property */
#if ((NTDDI_VERSION >= 0x05010200) && (NTDDI_VERSION < 0x05020000)) || \
    (NTDDI_VERSION >= 0x05020100)
typedef struct {
    KSP_NODE    NodeProperty;
    LONG        Value;
    ULONG       Flags;
    ULONG       Capabilities;
} KSPROPERTY_SELECTOR_NODE_S;
typedef KSPROPERTY_SELECTOR_NODE_S  *PKSPROPERTY_SELECTOR_NODE_S;
#endif

/* Kernel streaming tuner properties */
typedef enum {
    KSPROPERTY_TUNER_CAPS                   = 0,
    KSPROPERTY_TUNER_MODE_CAPS              = 1,
    KSPROPERTY_TUNER_MODE                   = 2,
    KSPROPERTY_TUNER_STANDARD               = 3,
    KSPROPERTY_TUNER_FREQUENCY              = 4,
    KSPROPERTY_TUNER_INPUT                  = 5,
    KSPROPERTY_TUNER_STATUS                 = 6,
    KSPROPERTY_TUNER_IF_MEDIUM              = 7,
    KSPROPERTY_TUNER_SCAN_CAPS              = 8,
    KSPROPERTY_TUNER_SCAN_STATUS            = 9,
    KSPROPERTY_TUNER_STANDARD_MODE          = 10,
    KSPROPERTY_TUNER_NETWORKTYPE_SCAN_CAPS  = 11
} KSPROPERTY_TUNER;

/* Kernel streaming tuner modes */
typedef enum {
    KSPROPERTY_TUNER_MODE_TV        = 0x00000001,
    KSPROPERTY_TUNER_MODE_FM_RADIO  = 0x00000002,
    KSPROPERTY_TUNER_MODE_AM_RADIO  = 0x00000004,
    KSPROPERTY_TUNER_MODE_DSS       = 0x00000008,
    KSPROPERTY_TUNER_MODE_ATSC      = 0x00000010
} KSPROPERTY_TUNER_MODES;

/* Kernel streaming tuner tuning flags */
typedef enum {
    KS_TUNER_TUNING_EXACT   = 1,
    KS_TUNER_TUNING_FINE    = 2,
    KS_TUNER_TUNING_COARSE  = 3
} KS_TUNER_TUNING_FLAGS;

/* Kernel streaming tuner strategies */
typedef enum {
    KS_TUNER_STRATEGY_PLL               = 0x00000001,
    KS_TUNER_STRATEGY_SIGNAL_STRENGTH   = 0x00000002,
    KS_TUNER_STRATEGY_DRIVER_TUNES      = 0x00000004
} KS_TUNER_STRATEGY;

/* Kernel streaming tuner capabilities property */
typedef struct {
    KSPROPERTY      Property;
    ULONG           ModesSupported;
    KSPIN_MEDIUM    VideoMedium;
    KSPIN_MEDIUM    TVAudioMedium;
    KSPIN_MEDIUM    RadioAudioMedium;
} KSPROPERTY_TUNER_CAPS_S;
typedef KSPROPERTY_TUNER_CAPS_S *PKSPROPERTY_TUNER_CAPS_S;

/* Kernel streaming tuner interface medium property */
typedef struct {
    KSPROPERTY      Property;
    KSPIN_MEDIUM    IFMedium;
} KSPROPERTY_TUNER_IF_MEDIUM_S;
typedef KSPROPERTY_TUNER_IF_MEDIUM_S    *PKSPROPERTY_TUNER_IF_MEDIUM_S;

/* Kernel streaming tuner mode capabilities property */
typedef struct {
    KSPROPERTY  Property;
    ULONG       Mode;
    ULONG       StandardsSupported;
    ULONG       MinFrequency;
    ULONG       MaxFrequency;
    ULONG       TuningGranularity;
    ULONG       NumberOfInputs;
    ULONG       SettlingTime;
    ULONG       Strategy;
} KSPROPERTY_TUNER_MODE_CAPS_S;
typedef KSPROPERTY_TUNER_MODE_CAPS_S    *PKSPROPERTY_TUNER_MODE_CAPS_S;

/* Kernel streaming tuner mode property */
typedef struct {
    KSPROPERTY  Property;
    ULONG       Mode;
} KSPROPERTY_TUNER_MODE_S;
typedef KSPROPERTY_TUNER_MODE_S *PKSPROPERTY_TUNER_MODE_S;

/* Kernel streaming tuner frequency property */
typedef struct {
    KSPROPERTY  Property;
    ULONG       Frequency;
    ULONG       LastFrequency;
    ULONG       TuningFlags;
    ULONG       VideoSubChannel;
    ULONG       AudioSubChannel;
    ULONG       Channel;
    ULONG       Country;
} KSPROPERTY_TUNER_FREQUENCY_S;
typedef KSPROPERTY_TUNER_FREQUENCY_S    *PKSPROPERTY_TUNER_FREQUENCY_S;

/* Kernel streaming tuner standard property */
typedef struct {
    KSPROPERTY  Property;
    ULONG       Standard;
} KSPROPERTY_TUNER_STANDARD_S;
typedef KSPROPERTY_TUNER_STANDARD_S *PKSPROPERTY_TUNER_STANDARD_S;

/* Kernel streaming tuner standard mode property */
typedef struct {
    KSPROPERTY  Property;
    BOOL        AutoDetect;
} KSPROPERTY_TUNER_STANDARD_MODE_S;
typedef KSPROPERTY_TUNER_STANDARD_MODE_S    *PKSPROPERTY_TUNER_STANDARD_MODE_S;

/* Kernel streaming tuner input property */
typedef struct {
    KSPROPERTY  Property;
    ULONG       InputIndex;
} KSPROPERTY_TUNER_INPUT_S;
typedef KSPROPERTY_TUNER_INPUT_S    *PKSPROPERTY_TUNER_INPUT_S;

/* Kernel streaming tuner status property */
typedef struct {
    KSPROPERTY  Property;
    ULONG       CurrentFrequency;
    ULONG       PLLOffset;
    ULONG       SignalStrength;
    ULONG       Busy;
} KSPROPERTY_TUNER_STATUS_S;
typedef KSPROPERTY_TUNER_STATUS_S   *PKSPROPERTY_TUNER_STATUS_S;

/* Tuner decoder lock types */
typedef enum _TunerDecoderLockType {
    Tuner_LockType_None                         = 0x00000000,
    Tuner_LockType_Within_Scan_Sensing_Range    = 0x00000001,
    Tuner_LockType_Locked                       = 0x00000002
} TunerLockType;

/* Tuner analog capabilities */
typedef struct {
    ULONG   Mode;
    ULONG   StandardsSupported;
    ULONG   MinFrequency;
    ULONG   MaxFrequency;
    ULONG   TuningGranularity;
    ULONG   SettlingTime;
    ULONG   ScanSensingRange;
    ULONG   FineTuneSensingRange;
} TUNER_ANALOG_CAPS_S;
typedef TUNER_ANALOG_CAPS_S *PTUNER_ANALOG_CAPS_S;

/* Kernel streaming tuner events */
typedef enum {
    KSEVENT_TUNER_CHANGED       = 0,
    KSEVENT_TUNER_INITIATE_SCAN = 1
} KSEVENT_TUNER;

/* Kernel streaming tuner scan capabilities property */
typedef struct {
    KSPROPERTY  Property;
    BOOL        fSupportsHardwareAssistedScanning;
    ULONG       SupportedBroadcastStandards;
    PVOID       GUIDBucket;
    ULONG       lengthofBucket;
} KSPROPERTY_TUNER_SCAN_CAPS_S;
typedef KSPROPERTY_TUNER_SCAN_CAPS_S    *PKSPROPERTY_TUNER_SCAN_CAPS_S;

/* Kernel streaming network type scan capabilities property */
typedef struct {
    KSPROPERTY  Property;
    GUID        NetworkType;
    ULONG       BufferSize;
    PVOID       NetworkTunerCapabilities;
} KSPROPERTY_TUNER_NETWORKTYPE_SCAN_CAPS_S;
typedef KSPROPERTY_TUNER_NETWORKTYPE_SCAN_CAPS_S    *PKSPROPERTY_TUNER_NETWORKTYPE_SCAN_CAPS_S;

/* Kernel streaming tuner scan status property */
typedef struct {
    KSPROPERTY      Property;
    TunerLockType   LockStatus;
    ULONG           CurrentFrequency;
} KSPROPERTY_TUNER_SCAN_STATUS_S;
typedef KSPROPERTY_TUNER_SCAN_STATUS_S  *PKSPROPERTY_TUNER_SCAN_STATUS_S;

/* Kernel streaming tuner initiate scan event */
typedef struct {
    KSEVENTDATA EventData;
    ULONG       StartFrequency;
    ULONG       EndFrequency;
} KSEVENT_TUNER_INITIATE_SCAN_S;
typedef KSEVENT_TUNER_INITIATE_SCAN_S   *PKSEVENT_TUNER_INITIATE_SCAN_S;

/* Kernel streaming video encoder properties */
typedef enum {
    KSPROPERTY_VIDEOENCODER_CAPS            = 0,
    KSPROPERTY_VIDEOENCODER_STANDARD        = 1,
    KSPROPERTY_VIDEOENCODER_COPYPROTECTION  = 2,
    KSPROPERTY_VIDEOENCODER_CC_ENABLE       = 3
} KSPROPERTY_VIDCAP_VIDEOENCODER;

/* Kernel streaming video encoder property */
typedef struct {
    KSPROPERTY  Property;
    LONG        Value;
    ULONG       Flags;
    ULONG       Capabilities;
} KSPROPERTY_VIDEOENCODER_S;
typedef KSPROPERTY_VIDEOENCODER_S   *PKSPROPERTY_VIDEOENCODER_S;

/* Kernel streaming video decoder properties */
typedef enum {
    KSPROPERTY_VIDEODECODER_CAPS            = 0,
    KSPROPERTY_VIDEODECODER_STANDARD        = 1,
    KSPROPERTY_VIDEODECODER_STATUS          = 2,
    KSPROPERTY_VIDEODECODER_OUTPUT_ENABLE   = 3,
    KSPROPERTY_VIDEODECODER_VCR_TIMING      = 4,
    KSPROPERTY_VIDEODECODER_STATUS2         = 5
} KSPROPERTY_VIDCAP_VIDEODECODER;

/* Kernel streaming video decoder flags */
typedef enum {
    KS_VIDEOENCODER_FLAGS_CAN_DISABLE_OUTPUT    = 0x00000001,
    KS_VIDEOENCODER_FLAGS_CAN_USE_VCR_LOCKING   = 0x00000002,
    KS_VIDEOENCODER_FLAGS_CAN_INDICATE_LOCKED   = 0x00000004
} KS_VIDEOENCODER_FLAGS;

/* Kernel streaming video decoder capabilities property */
typedef struct {
    KSPROPERTY  Property;
    ULONG       StandardsSupported;
    ULONG       Capabilities;
    ULONG       SettlingTime;
    ULONG       HSyncPerVSync;
} KSPROPERTY_VIDEODECODER_CAPS_S;
typedef KSPROPERTY_VIDEODECODER_CAPS_S  *PKSPROPERTY_VIDEODECODER_CAPS_S;

/* Kernel streaming video decoder status property */
typedef struct {
    KSPROPERTY  Property;
    ULONG       NumberOfLines;
    ULONG       SignalLocked;
} KSPROPERTY_VIDEODECODER_STATUS_S;
typedef KSPROPERTY_VIDEODECODER_STATUS_S    *PKSPROPERTY_VIDEODECODER_STATUS_S;

/* Kernel streaming video decoder status property (version 2) */
typedef struct {
    KSPROPERTY  Property;
    ULONG       NumberOfLines;
    ULONG       SignalLocked;
    ULONG       ChromaLock;
} KSPROPERTY_VIDEODECODER_STATUS2_S;
typedef KSPROPERTY_VIDEODECODER_STATUS2_S   *PKSPROPERTY_VIDEODECODER_STATUS2_S;

/* Kernel streaming video decoder property */
typedef struct {
    KSPROPERTY  Property;
    ULONG       Value;
} KSPROPERTY_VIDEODECODER_S;
typedef KSPROPERTY_VIDEODECODER_S   *PKSPROPERTY_VIDEODECODER_S;

/* Kernel streaming video decoder events */
typedef enum {
    KSEVENT_VIDEODECODER_CHANGED    = 0
} KSEVENT_VIDEODECODER;

/* Kernel streaming camera control properties */
typedef enum {
    KSPROPERTY_CAMERACONTROL_PAN                = 0,
    KSPROPERTY_CAMERACONTROL_TILT               = 1,
    KSPROPERTY_CAMERACONTROL_ROLL               = 2,
    KSPROPERTY_CAMERACONTROL_ZOOM               = 3,
    KSPROPERTY_CAMERACONTROL_EXPOSURE           = 4,
    KSPROPERTY_CAMERACONTROL_IRIS               = 5,
#if ((NTDDI_VERSION >= 0x05010200) && (NTDDI_VERSION < 0x05020000)) || \
    (NTDDI_VERSION >= 0x05020100)
    KSPROPERTY_CAMERACONTROL_FOCUS              = 6,
    KSPROPERTY_CAMERACONTROL_SCANMODE           = 7,
    KSPROPERTY_CAMERACONTROL_PRIVACY            = 8,
    KSPROPERTY_CAMERACONTROL_PANTILT            = 9,
    KSPROPERTY_CAMERACONTROL_PAN_RELATIVE       = 10,
    KSPROPERTY_CAMERACONTROL_TILT_RELATIVE      = 11,
    KSPROPERTY_CAMERACONTROL_ROLL_RELATIVE      = 12,
    KSPROPERTY_CAMERACONTROL_ZOOM_RELATIVE      = 13,
    KSPROPERTY_CAMERACONTROL_EXPOSURE_RELATIVE  = 14,
    KSPROPERTY_CAMERACONTROL_IRIS_RELATIVE      = 15,
    KSPROPERTY_CAMERACONTROL_FOCUS_RELATIVE     = 16,
    KSPROPERTY_CAMERACONTROL_PANTILT_RELATIVE   = 17,
    KSPROPERTY_CAMERACONTROL_FOCAL_LENGTH       = 18,
    KSPROPERTY_CAMERACONTROL_AUTO_EXPOSURE_PRIORITY = 19
#else
    KSPROPERTY_CAMERACONTROL_FOCUS              = 6
#endif
} KSPROPERTY_VIDCAP_CAMERACONTROL;

/* Kernel streaming camera control property */
typedef struct {
    KSPROPERTY  Property;
    LONG        Value;
    ULONG       Flags;
    ULONG       Capabilities;
} KSPROPERTY_CAMERACONTROL_S;
typedef KSPROPERTY_CAMERACONTROL_S  *PKSPROPERTY_CAMERACONTROL_S;

/* Kernel streaming camera control node property */
#if ((NTDDI_VERSION >= 0x05010200) && (NTDDI_VERSION < 0x05020000)) || \
    (NTDDI_VERSION >= 0x05020100)
typedef struct {
    KSP_NODE    NodeProperty;
    LONG        Value;
    ULONG       Flags;
    ULONG       Capabilities;
} KSPROPERTY_CAMERACONTROL_NODE_S;
typedef KSPROPERTY_CAMERACONTROL_NODE_S *PKSPROPERTY_CAMERACONTROL_NODE_S;
#endif

/* Kernel streaming camera control property (version 2) */
#if ((NTDDI_VERSION >= 0x05010200) && (NTDDI_VERSION < 0x05020000)) || \
    (NTDDI_VERSION >= 0x05020100)
typedef struct {
    KSPROPERTY  Property;
    LONG        Value1;
    ULONG       Flags;
    ULONG       Capabilities;
    LONG        Value2;
} KSPROPERTY_CAMERACONTROL_S2;
typedef KSPROPERTY_CAMERACONTROL_S2 *PKSPROPERTY_CAMERACONTROL_S2;
#endif

/* Kernel streaming camera control node property (version 2) */
#if ((NTDDI_VERSION >= 0x05010200) && (NTDDI_VERSION < 0x05020000)) || \
    (NTDDI_VERSION >= 0x05020100)
typedef struct {
    KSP_NODE    NodeProperty;
    LONG        Value1;
    ULONG       Flags;
    ULONG       Capabilities;
    LONG        Value2;
} KSPROPERTY_CAMERACONTROL_NODE_S2;
typedef KSPROPERTY_CAMERACONTROL_NODE_S2    *PKSPROPERTY_CAMERACONTROL_NODE_S2;
#endif

/* Kernel streaming camera control focal length property */
#if ((NTDDI_VERSION >= 0x05010200) && (NTDDI_VERSION < 0x05020000)) || \
    (NTDDI_VERSION >= 0x05020100)
typedef struct {
    KSPROPERTY  Property;
    LONG        lOcularFocalLength;
    LONG        lObjectiveFocalLengthMin;
    LONG        lObjectiveFoaclLengthMax;
} KSPROPERTY_CAMERACONTROL_FOCAL_LENGTH_S;
typedef KSPROPERTY_CAMERACONTROL_FOCAL_LENGTH_S *PKSPROPERTY_CAMERACONTROL_FOCAL_LENGTH_S;
#endif

/* Kernel streaming camera control node focal length property */
#if ((NTDDI_VERSION >= 0x05010200) && (NTDDI_VERSION < 0x05020000)) || \
    (NTDDI_VERSION >= 0x05020100)
typedef struct {
    KSNODEPROPERTY  NodeProperty;
    LONG            lOcularFocalLength;
    LONG            lObjectiveFocalLengthMin;
    LONG            lObjectiveFocalLengthMax;
} KSPROPERTY_CAMERACONTROL_NODE_FOCAL_LENGTH_S;
typedef KSPROPERTY_CAMERACONTROL_NODE_FOCAL_LENGTH_S    *PKSPROPERTY_CAMERACONTROL_NODE_FOCAL_LENGTH_S;
#endif

/* Kernel streaming extended device properties */
#if ((NTDDI_VERSION >= 0x05010200) && (NTDDI_VERSION < 0x05020000)) || \
    (NTDDI_VERSION >= 0x05020100)
typedef enum {
    KSPROPERTY_EXTDEVICE_ID             = 0,
    KSPROPERTY_EXTDEVICE_VERSION        = 1,
    KSPROPERTY_EXTDEVICE_POWER_STATE    = 2,
    KSPROPERTY_EXTDEVICE_PORT           = 3,
    KSPROPERTY_EXTDEVICE_CAPABILITIES   = 4
} KSPROPERTY_EXTDEVICE;
#endif

/* Device capabilities */
#if ((NTDDI_VERSION >= 0x05010200) && (NTDDI_VERSION < 0x05020000)) || \
    (NTDDI_VERSION >= 0x05020100)
typedef struct tagDEVCAPS {
    LONG    CanRecord;
    LONG    CanRecordStrobe;
    LONG    HasAudio;
    LONG    HasVideo;
    LONG    UsesFiles;
    LONG    CanSave;
    LONG    DeviceType;
    LONG    TCRead;
    LONG    TCWrite;
    LONG    CTLRead;
    LONG    IndexRead;
    LONG    Preroll;
    LONG    Postroll;
    LONG    SyncAcc;
    LONG    NormRate;
    LONG    CanPreview;
    LONG    CanMonitorSrc;
    LONG    CanTest;
    LONG    VideoIn;
    LONG    AudioIn;
    LONG    Calibrate;
    LONG    SeekType;
    LONG    SimulatedHardware;
} DEVCAPS;
typedef DEVCAPS *PDEVCAPS;
#endif

/* Kernel streaming extended device property */
#if ((NTDDI_VERSION >= 0x05010200) && (NTDDI_VERSION < 0x05020000)) || \
    (NTDDI_VERSION >= 0x05020100)
typedef struct {
    KSPROPERTY  Property;
    union {
        DEVCAPS Capabilities;
        ULONG   DevPort;
        ULONG   PowerState;
        WCHAR   pawchString[MAX_PATH];
        DWORD   NodeUniqueID[2];
    } u;
} KSPROPERTY_EXTDEVICE_S;
typedef KSPROPERTY_EXTDEVICE_S  *PKSPROPERTY_EXTDEVICE_S;
#endif

/* Kernel streaming extended transport properties */
#if ((NTDDI_VERSION >= 0x05010200) && (NTDDI_VERSION < 0x05020000)) || \
    (NTDDI_VERSION >= 0x05020100)
typedef enum {
    KSPROPERTY_EXTXPORT_CAPABILITIES        = 0,
    KSPROPERTY_EXTXPORT_INPUT_SIGNAL_MODE   = 1,
    KSPROPERTY_EXTXPORT_OUTPUT_SIGNAL_MODE  = 2,
    KSPROPERTY_EXTXPORT_LOAD_MEDIUM         = 3,
    KSPROPERTY_EXTXPORT_MEDIUM_INFO         = 4,
    KSPROPERTY_EXTXPORT_STATE               = 5,
    KSPROPERTY_EXTXPORT_STATE_NOTIFY        = 6,
    KSPROPERTY_EXTXPORT_TIMECODE_SEARCH     = 7,
    KSPROPERTY_EXTXPORT_ATN_SEARCH          = 8,
    KSPROPERTY_EXTXPORT_RTC_SEARCH          = 9,
    KSPROPERTY_RAW_AVC_CMD                  = 10
} KSPROPERTY_EXTXPORT;
#endif

/* Transport status */
#if ((NTDDI_VERSION >= 0x05010200) && (NTDDI_VERSION < 0x05020000)) || \
    (NTDDI_VERSION >= 0x05020100)
typedef struct tagTRANSPORTSTATUS {
    LONG    Mode;
    LONG    LastError;
    LONG    RecordInhibit;
    LONG    ServoLock;
    LONG    MediaPresent;
    LONG    MediaLength;
    LONG    MediaSize;
    LONG    MediaTrackCount;
    LONG    MediaTrackLength;
    LONG    MediaTrackSide;
    LONG    MediaType;
    LONG    LinkMode;
    LONG    NotifyOn;
} TRANSPORTSTATUS;
typedef TRANSPORTSTATUS *PTRANSPORTSTATUS;
#endif

/* Transport basic parameters */
#if ((NTDDI_VERSION >= 0x05010200) && (NTDDI_VERSION < 0x05020000)) || \
    (NTDDI_VERSION >= 0x05020100)
typedef struct tagTRANSPORTBASICPARMS {
    LONG    TimeFormat;
    LONG    TimeReference;
    LONG    Superimpose;
    LONG    EndStopAction;
    LONG    RecordFormat;
    LONG    StepFrames;
    LONG    SetpField;
    LONG    Preroll;
    LONG    RecPreroll;
    LONG    Postroll;
    LONG    EditDelay;
    LONG    PlayTCDelay;
    LONG    RecTCDelay;
    LONG    EditField;
    LONG    FrameServo;
    LONG    ColorFrameServo;
    LONG    ServoRef;
    LONG    WarnGenlock;
    LONG    SetTracking;
    TCHAR   VolumeName[40];
    LONG    Ballistic[20];
    LONG    Speed;
    LONG    CounterFormat;
    LONG    TunerChannel;
    LONG    TunerNumber;
    LONG    TimerEvent;
    LONG    TimerStartDay;
    LONG    TimerStartTime;
    LONG    TimerStopDay;
    LONG    TimerStopTime;
} TRANSPORTBASICPARMS;
typedef TRANSPORTBASICPARMS *PTRANSPORTBASICPARMS;
#endif

/* Transport video parameters */
#if ((NTDDI_VERSION >= 0x05010200) && (NTDDI_VERSION < 0x05020000)) || \
    (NTDDI_VERSION >= 0x05020100)
typedef struct tagTRANSPORTVIDEOPARMS {
    LONG    OutputMode;
    LONG    Input;
} TRANSPORTVIDEOPARMS;
typedef TRANSPORTVIDEOPARMS *PTRANSPORTVIDEOPARMS;
#endif

/* Transport audio parameters */
#if ((NTDDI_VERSION >= 0x05010200) && (NTDDI_VERSION < 0x05020000)) || \
    (NTDDI_VERSION >= 0x05020100)
typedef struct tagTRANSPORTAUDIOPARMS {
    LONG    EnableOutput;
    LONG    EnableRecord;
    LONG    EnableSelSync;
    LONG    Input;
    LONG    MonitorSource;
} TRANSPORTAUDIOPARMS;
typedef TRANSPORTAUDIOPARMS *PTRANSPORTAUDIOPARMS;
#endif

/* Medium information */
#if ((NTDDI_VERSION >= 0x05010200) && (NTDDI_VERSION < 0x05020000)) || \
    (NTDDI_VERSION >= 0x05020100)
typedef struct {
    BOOL    MediaPresent;
    ULONG   MediaType;
    BOOL    RecordInhibit;
} MEDIUM_INFO;
typedef MEDIUM_INFO *PMEDIUM_INFO;
#endif

/* Transport state */
#if ((NTDDI_VERSION >= 0x05010200) && (NTDDI_VERSION < 0x05020000)) || \
    (NTDDI_VERSION >= 0x05020100)
typedef struct {
    ULONG   Mode;
    ULONG   State;
} TRANSPORT_STATE;
typedef TRANSPORT_STATE *PTRANSPORT_STATE;
#endif

/* Kernel streaming extended transport property */
#if ((NTDDI_VERSION >= 0x05010200) && (NTDDI_VERSION < 0x05020000)) || \
    (NTDDI_VERSION >= 0x05020100)
typedef struct {
    KSPROPERTY  Property;
    union {
        ULONG           Capabilities;
        ULONG           SignalMode;
        ULONG           LoadMedium;
        MEDIUM_INFO     MediumInfo;
        TRANSPORT_STATE XPrtState;
        struct {
            BYTE    frame;
            BYTE    second;
            BYTE    minute;
            BYTE    hour;
        } Timecode;
        DWORD           dwTimecode;
        DWORD           dwAbsTrackNumber;
        struct {
            ULONG   PayloadSize;
            BYTE    Payload[512];
        } RawAVC;
    } u;
} KSPROPERTY_EXTXPORT_S;
typedef KSPROPERTY_EXTXPORT_S   *PKSPROPERTY_EXTXPORT_S;
#endif

/* Kernel streaming extended transport node property */
#if ((NTDDI_VERSION >= 0x05010200) && (NTDDI_VERSION < 0x05020000)) || \
    (NTDDI_VERSION >= 0x05020100)
typedef struct {
    KSP_NODE    NodeProperty;
    union {
        ULONG           Capabilities;
        ULONG           SignalMode;
        ULONG           LoadMedium;
        MEDIUM_INFO     MediumInfo;
        TRANSPORT_STATE XPrtState;
        struct {
            BYTE    frame;
            BYTE    second;
            BYTE    minute;
            BYTE    hour;
        } Timecode;
        DWORD           dwTimecode;
        DWORD           dwAbsTrackNumber;
        struct {
            ULONG   PayloadSize;
            BYTE    Payload[512];
        } RawAVC;
    } u;
} KSPROPERTY_EXTXPORT_NODE_S;
typedef KSPROPERTY_EXTXPORT_NODE_S  *PKSPROPERTY_EXTXPORT_NODE_S;
#endif

/* Kernel streaming timecode properties */
#if ((NTDDI_VERSION >= 0x05010200) && (NTDDI_VERSION < 0x05020000)) || \
    (NTDDI_VERSION >= 0x05020100)
typedef enum {
    KSPROPERTY_TIMECODE_READER  = 0,
    KSPROPERTY_ATN_READER       = 1,
    KSPROPERTY_RTC_READER       = 2
} KSPROPERTY_TIMECODE;
#endif

#if ((NTDDI_VERSION >= 0x05010200) && (NTDDI_VERSION < 0x05020000)) || \
    (NTDDI_VERSION >= 0x05020100)
#ifndef TIMECODE_DEFINED
#define TIMECODE_DEFINED

/* Time code */
typedef union _timecode {
    struct {
        WORD    wFrameRate;
        WORD    wFrameFract;
        DWORD   dwFrames;
    };
    DWORDLONG   qw;
} TIMECODE;
typedef TIMECODE    *PTIMECODE;

/* Time code sample */
typedef struct tagTIMECODE_SAMPLE {
    LONGLONG    qwTick;
    TIMECODE    timecode;
    DWORD       dwUser;
    DWORD       dwFlags;
} TIMECODE_SAMPLE;
typedef TIMECODE_SAMPLE *PTIMECODE_SAMPLE;

#endif /* TIMECODE_DEFINED */
#endif /* (NTDDI_VERSION >= 0x05010200) */

/* Kernel streaming timecode property */
#if ((NTDDI_VERSION >= 0x05010200) && (NTDDI_VERSION < 0x05020000)) || \
    (NTDDI_VERSION >= 0x05020100)
typedef struct {
    KSPROPERTY      Property;
    TIMECODE_SAMPLE TimecodeSamp;
} KSPROPERTY_TIMECODE_S;
typedef KSPROPERTY_TIMECODE_S   *PKSPROPERTY_TIMECODE_S;
#endif

/* Kernel streaming timecode node property */
#if ((NTDDI_VERSION >= 0x05010200) && (NTDDI_VERSION < 0x05020000)) || \
    (NTDDI_VERSION >= 0x05020100)
typedef struct {
    KSP_NODE        NodeProperty;
    TIMECODE_SAMPLE TimecodeSamp;
} KSPROPERTY_TIMECODE_NODE_S;
typedef KSPROPERTY_TIMECODE_NODE_S  *PKSPROPERTY_TIMECODE_NODE_S;
#endif

/* Kernel streaming extended device command events */
#if ((NTDDI_VERSION >= 0x05010200) && (NTDDI_VERSION < 0x05020000)) || \
    (NTDDI_VERSION >= 0x05020100)
typedef enum {
    KSEVENT_EXTDEV_COMMAND_NOTIFY_INTERIM_READY     = 0,
    KSEVENT_EXTDEV_COMMAND_CONTROL_INTERIM_READY    = 1,
    KSEVENT_EXTDEV_COMMAND_BUSRESET                 = 2,
    KSEVENT_EXTDEV_TIMECODE_UPDATE                  = 3,
    KSEVENT_EXTDEV_OPERATION_MODE_UPDATE            = 4,
    KSEVENT_EXTDEV_TRANSPORT_STATE_UPDATE           = 5,
    KSEVENT_EXTDEV_NOTIFY_REMOVAL                   = 6,
    KSEVENT_EXTDEV_NOTIFY_MEDIUM_CHANGE             = 7
} KSEVENT_DEVCMD;
#endif

/* Kernel streaming crossbar properties */
typedef enum {
    KSPROPERTY_CROSSBAR_CAPS            = 0,
    KSPROPERTY_CROSSBAR_PININFO         = 1,
    KSPROPERTY_CROSSBAR_CAN_ROUTE       = 2,
    KSPROPERTY_CROSSBAR_ROUTE           = 3,
    KSPROPERTY_CROSSBAR_INPUT_ACTIVE    = 4
} KSPROPERTY_VIDCAP_CROSSBAR;

/* Kernel streaming crossbar capabilities property */
typedef struct {
    KSPROPERTY  Property;
    ULONG       NumberOfInputs;
    ULONG       NumberOfOutputs;
} KSPROPERTY_CROSSBAR_CAPS_S;
typedef KSPROPERTY_CROSSBAR_CAPS_S  *PKSPROPERTY_CROSSBAR_CAPS_S;

/* Kernel streaming crossbar pin information property */
typedef struct {
    KSPROPERTY      Property;
    KSPIN_DATAFLOW  Direction;
    ULONG           Index;
    ULONG           PinType;
    ULONG           RelatedPinType;
    KSPIN_MEDIUM    Medium;
} KSPROPERTY_CROSSBAR_PININFO_S;
typedef KSPROPERTY_CROSSBAR_PININFO_S   *PKSPROPERTY_CROSSBAR_PININFO_S;

/* Kernel streaming crossbar route property */
typedef struct {
    KSPROPERTY  Property;
    ULONG       IndexInputPin;
    ULONG       IndexOutputPin;
    ULONG       CanRoute;
} KSPROPERTY_CROSSBAR_ROUTE_S;
typedef KSPROPERTY_CROSSBAR_ROUTE_S *PKSPROPERTY_CROSSBAR_ROUTE_S;

/* Kernel streaming crossbar active property */
typedef struct {
    KSPROPERTY  Property;
    ULONG       IndexInputPin;
    ULONG       Active;
} KSPROPERTY_CROSSBAR_ACTIVE_S;
typedef KSPROPERTY_CROSSBAR_ACTIVE_S    *PKSPROPERTY_CROSSBAR_ACTIVE_S;

/* Kernel streaming crossbar events */
typedef enum {
    KSEVENT_CROSSBAR_CHANGED    = 0
} KSEVENT_CROSSBAR;

/* Kernel streaming physical connector types */
typedef enum {
    KS_PhysConn_Video_Tuner             = 1,
    KS_PhysConn_Video_Composite         = 2,
    KS_PhysConn_Video_SVideo            = 3,
    KS_PhysConn_Video_RGB               = 4,
    KS_PhysConn_Video_YRYBY             = 5,
    KS_PhysConn_Video_SerialDigital     = 6,
    KS_PhysConn_Video_ParallelDigital   = 7,
    KS_PhysConn_Video_SCSI              = 8,
    KS_PhysConn_Video_AUX               = 9,
    KS_PhysConn_Video_1394              = 10,
    KS_PhysConn_Video_USB               = 11,
    KS_PhysConn_Video_VideoDecoder      = 12,
    KS_PhysConn_Video_VideoEncoder      = 13,
    KS_PhysConn_Video_SCART             = 14,
    KS_PhysConn_Audio_Tuner             = 4096,
    KS_PhysConn_Audio_Line              = 4097,
    KS_PhysConn_Audio_Mic               = 4098,
    KS_PhysConn_Audio_AESDigital        = 4099,
    KS_PhysConn_Audio_SPDIFDigital      = 4100,
    KS_PhysConn_Audio_SCSI              = 4101,
    KS_PhysConn_Audio_AUX               = 4102,
    KS_PhysConn_Audio_1394              = 4103,
    KS_PhysConn_Audio_USB               = 4104,
    KS_PhysConn_Audio_AudioDecoder      = 4105
} KS_PhysicalConnectorType;

/* Kernel streaming TV audio properties */
typedef enum {
    KSPROPERTY_TVAUDIO_CAPS                         = 0,
    KSPROPERTY_TVAUDIO_MODE                         = 1,
    KSPROPERTY_TVAUDIO_CURRENTLY_AVAILABLE_MODES    = 2
} KSPROPERTY_VIDCAP_TVAUDIO;

/* Kernel streaming TV audio capabilities property */
typedef struct {
    KSPROPERTY      Property;
    ULONG           Capabilities;
    KSPIN_MEDIUM    InputMedium;
    KSPIN_MEDIUM    OutputMedium;
} KSPROPERTY_TVAUDIO_CAPS_S;
typedef KSPROPERTY_TVAUDIO_CAPS_S   *PKSPROPERTY_TVAUDIO_CAPS_S;

/* Kernel streaming TV audio property */
typedef struct {
    KSPROPERTY  Property;
    ULONG       Mode;
} KSPROPERTY_TVAUDIO_S;
typedef KSPROPERTY_TVAUDIO_S    *PKSPROPERTY_TVAUDIO_S;

/* Kernel streaming TV audio events */
typedef enum {
    KSEVENT_TVAUDIO_CHANGED = 0
} KSEVENT_TVAUDIO;

/* Kernel streaming video compression properties */
typedef enum {
    KSPROPERTY_VIDEOCOMPRESSION_GETINFO                 = 0,
    KSPROPERTY_VIDEOCOMPRESSION_KEYFRAME_RATE           = 1,
    KSPROPERTY_VIDEOCOMPRESSION_PFRAMES_PER_KEYFRAME    = 2,
    KSPROPERTY_VIDEOCOMPRESSION_QUALITY                 = 3,
    KSPROPERTY_VIDEOCOMPRESSION_OVERRIDE_KEYFRAME       = 4,
    KSPROPERTY_VIDEOCOMPRESSION_OVERRIDE_FRAME_SIZE     = 5,
    KSPROPERTY_VIDEOCOMPRESSION_WINDOWSIZE              = 6
} KSPROPERTY_VIDCAP_VIDEOCOMPRESSION;

/* Kernel streaming compression capabilities */
typedef enum {
    KS_CompressionCaps_CanQuality   = 0x00000001,
    KS_CompressionCaps_CanCrunch    = 0x00000002,
    KS_CompressionCaps_CanKeyFrame  = 0x00000004,
    KS_CompressionCaps_CanBFrame    = 0x00000008,
    KS_CompressionCaps_CanWindow    = 0x00000010
} KS_CompressionCaps;

/* Kernel streaming video streaming hints */
#if ((NTDDI_VERSION >= 0x05010200) && (NTDDI_VERSION < 0x05020000)) || \
    (NTDDI_VERSION >= 0x05020100)
typedef enum {
    KS_StreamingHint_FrameInterval  = 0x00000100,
    KS_StreamingHint_KeyFrameRate   = 0x00000200,
    KS_StreamingHint_PFrameRate     = 0x00000400,
    KS_StreamingHint_CompQuality    = 0x00000800,
    KS_StreamingHint_CompWindowSize = 0x00001000
} KS_VideoStreamingHints;
#endif

/* Kernel streaming video compression get information property */
typedef struct {
    KSPROPERTY  Property;
    ULONG       StreamIndex;
    LONG        DefaultKeyFrameRate;
    LONG        DefaultPFrameRate;
    LONG        DefaultQuality;
    LONG        NumberOfQualitySettings;
    LONG        Capabilities;
} KSPROPERTY_VIDEOCOMPRESSION_GETINFO_S;
typedef KSPROPERTY_VIDEOCOMPRESSION_GETINFO_S   *PKSPROPERTY_VIDEOCOMPRESSION_GETINFO_S;

/* Kernel streaming video compression property */
typedef struct {
    KSPROPERTY  Property;
    ULONG       StreamIndex;
    LONG        Value;
} KSPROPERTY_VIDEOCOMPRESSION_S;
typedef KSPROPERTY_VIDEOCOMPRESSION_S   *PKSPROPERTY_VIDEOCOMPRESSION_S;

/* Kernel streaming video compression property (version 1) */
#if ((NTDDI_VERSION >= 0x05010200) && (NTDDI_VERSION < 0x05020000)) || \
    (NTDDI_VERSION >= 0x05020100)
typedef struct {
    KSPROPERTY  Property;
    ULONG       StreamIndex;
    LONG        Value;
    ULONG       Flags;
} KSPROPERTY_VIDEOCOMPRESSION_S1;
typedef KSPROPERTY_VIDEOCOMPRESSION_S1  *PKSPROPERTY_VIDEOCOMPRESSION_S1;
#endif

/* Kernel streaming overlay update properties */
typedef enum {
    KSPROPERTY_OVERLAYUPDATE_INTERESTS      = 0x00000000,
    KSPROPERTY_OVERLAYUPDATE_CLIPLIST       = 0x00000001,
    KSPROPERTY_OVERLAYUPDATE_PALETTE        = 0x00000002,
    KSPROPERTY_OVERLAYUPDATE_COLORKEY       = 0x00000004,
    KSPROPERTY_OVERLAYUPDATE_VIDEOPOSITION  = 0x00000008,
    KSPROPERTY_OVERLAYUPDATE_DISPLAYCHANGE  = 0x00000010,
    KSPROPERTY_OVERLAYUPDATE_COLORREF       = 0x10000000
} KSPROPERTY_OVERLAYUPDATE;

/* Kernel streaming display change */
typedef struct {
    ULONG   PelsWidth;
    ULONG   PelsHeight;
    ULONG   BitsPerPel;
    WCHAR   DeviceID[1];
} KSDISPLAYCHANGE;
typedef KSDISPLAYCHANGE *PKSDISPLAYCHANGE;

/* Kernel streaming video control properties */
typedef enum {
    KSPROPERTY_VIDEOCONTROL_CAPS                = 0,
    KSPROPERTY_VIDEOCONTROL_ACTUAL_FRAME_RATE   = 1,
    KSPROPERTY_VIDEOCONTROL_FRAME_RATES         = 2,
    KSPROPERTY_VIDEOCONTROL_MODE                = 3
} KSPROPERTY_VIDCAP_VIDEOCONTROL;

/* Kernel streaming video control flags */
typedef enum {
    KS_VideoControlFlag_FlipHorizontal                  = 0x00000001,
    KS_VideoControlFlag_FlipVertical                    = 0x00000002,
    KS_Obsolete_VideoControlFlag_ExternalTriggerEnable  = 0x00000010,
    KS_Obsolete_VideoControlFlag_Trigger                = 0x00000020,
    KS_VideoControlFlag_ExternalTriggerEnable           = 0x00000004,
    KS_VideoControlFlag_Trigger                         = 0x00000008
} KS_VideoControlFlags;

/* Kernel streaming video control capabilities property */
typedef struct {
    KSPROPERTY  Property;
    ULONG       StreamIndex;
    ULONG       VideoControlCaps;
} KSPROPERTY_VIDEOCONTROL_CAPS_S;
typedef KSPROPERTY_VIDEOCONTROL_CAPS_S  *PKSPROPERTY_VIDEOCONTROL_CAPS_S;

/* Kernel streaming video control mode property */
typedef struct {
    KSPROPERTY  Property;
    ULONG       StreamIndex;
    LONG        Mode;
} KSPROPERTY_VIDEOCONTROL_MODE_S;
typedef KSPROPERTY_VIDEOCONTROL_MODE_S  *PKSPROPERTY_VIDEOCONTROL_MODE_S;

/* Kernel streaming video control actual frame rate property */
typedef struct {
    KSPROPERTY  Property;
    ULONG       StreamIndex;
    ULONG       RangeIndex;
    SIZE        Dimensions;
    LONGLONG    CurrentActualFrameRate;
    LONGLONG    CurrentMaxAvailableFrameRate;
} KSPROPERTY_VIDEOCONTROL_ACTUAL_FRAME_RATE_S;
typedef KSPROPERTY_VIDEOCONTROL_ACTUAL_FRAME_RATE_S *PKSPROPERTY_VIDEOCONTROL_ACTUAL_FRAME_RATE_S;

/* Kernel streaming video control frame rate property */
typedef struct {
    KSPROPERTY  Property;
    ULONG       StreamIndex;
    ULONG       RangeIndex;
    SIZE        Dimensions;
} KSPROPERTY_VIDEOCONTROL_FRAME_RATE_S;
typedef KSPROPERTY_VIDEOCONTROL_FRAME_RATE_S    *PKSPROPERTY_VIDEOCONTROL_FRAME_RATE_S;

/* Kernel streaming dropped frames properties */
typedef enum {
    KSPROPERTY_DROPPEDFRAMES_CURRENT    = 0
} KSPROPERTY_VIDCAP_DROPPEDFRAMES;

/* Kernel streaming dropped frames current property */
typedef struct {
    KSPROPERTY  Property;
    LONGLONG    PictureNumber;
    LONGLONG    DropCount;
    ULONG       AverageFrameSize;
} KSPROPERTY_DROPPEDFRAMES_CURRENT_S;
typedef KSPROPERTY_DROPPEDFRAMES_CURRENT_S  *PKSPROPERTY_DROPPEDFRAMES_CURRENT_S;

/* Kernel streaming videoport configuration properties */
typedef enum {
    KSPROPERTY_VPCONFIG_NUMCONNECTINFO          = 0,
    KSPROPERTY_VPCONFIG_GETCONNECTINFO          = 1,
    KSPROPERTY_VPCONFIG_SETCONNECTINFO          = 2,
    KSPROPERTY_VPCONFIG_VPDATAINFO              = 3,
    KSPROPERTY_VPCONFIG_MAXPIXELRATE            = 4,
    KSPROPERTY_VPCONFIG_INFORMVPINPUT           = 5,
    KSPROPERTY_VPCONFIG_NUMVIDEOFORMAT          = 6,
    KSPROPERTY_VPCONFIG_GETVIDEOFORMAT          = 7,
    KSPROPERTY_VPCONFIG_SETVIDEOFORMAT          = 8,
    KSPROPERTY_VPCONFIG_INVERTPOLARITY          = 9,
    KSPROPERTY_VPCONFIG_DECIMATIONCAPABILITY    = 10,
    KSPROPERTY_VPCONFIG_SCALEFACTOR             = 11,
    KSPROPERTY_VPCONFIG_DDRAWHANDLE             = 12,
    KSPROPERTY_VPCONFIG_VIDEOPORTID             = 13,
    KSPROPERTY_VPCONFIG_DDRAWSURFACEHANDLE      = 14,
    KSPROPERTY_VPCONFIG_SURFACEPARAMS           = 15
} KSPROPERTY_VPCONFIG;

/* Kernel streaming ActiveMovie videoport size */
#ifndef __IVPType__
typedef struct tagKS_AMVPSIZE {
    DWORD   dwWidth;
    DWORD   dwHeight;
} KS_AMVPSIZE;
typedef KS_AMVPSIZE *PKS_AMVPSIZE;
#endif

/* Kernel streaming videoport maximum pixel rate */
typedef struct {
#ifdef __IVPType__
    AMVPSIZE    Size;
#else
    KS_AMVPSIZE Size;
#endif
    DWORD       MaxPixelsPerSecond;
    DWORD       Reserved;
} KSVPMAXPIXELRATE;
typedef KSVPMAXPIXELRATE    *PKSVPMAXPIXELRATE;

/* Kernel streaming videoport size property */
typedef struct {
    KSPROPERTY  Property;
#ifdef __IVPType__
    AMVPSIZE    Size;
#else
    KS_AMVPSIZE Size;
#endif
} KSVPSIZE_PROP;
typedef KSVPSIZE_PROP   *PKSVPSIZE_PROP;

/* Kernel streaming videoport surface parameters */
typedef struct {
    DWORD   dwPitch;
    DWORD   dwXOrigin;
    DWORD   dwYOrigin;
} KSVPSURFACEPARAMS;
typedef KSVPSURFACEPARAMS   *PKSVPSURFACEPARAMS;

/* Kernel streaming videoport notify events */
typedef enum {
    KSEVENT_VPNOTIFY_FORMATCHANGE   = 0
} KSEVENT_VPNOTIFY;

/* Kernel streaming video capture to STI events */
typedef enum {
#if ((NTDDI_VERSION >= 0x05010200) && (NTDDI_VERSION < 0x05020000)) || \
    (NTDDI_VERSION >= 0x05020100)
    KSEVENT_VIDCAPTOSTI_EXT_TRIGGER = 0,
    KSEVENT_VIDCAP_AUTO_UPDATE      = 1,
    KSEVENT_VIDCAP_SEARCH           = 2
#else
    KSEVENT_VIDCAPTOSTI_EXT_TRIGGER = 0
#endif
} KSEVENT_VIDCAPTOSTI;

/* Kernel streaming extension unit properties */
#if ((NTDDI_VERSION >= 0x05010200) && (NTDDI_VERSION < 0x05020000)) || \
    (NTDDI_VERSION >= 0x05020100)
typedef enum {
    KSPROPERTY_EXTENSION_UNIT_INFO          = 0,
    KSPROPERTY_EXTENSION_UNIT_CONTROL       = 1,
    KSPROPERTY_EXTENSION_UNIT_PASS_THROUGH  = 0xFFFF
} KSPROPERTY_EXTENSION_UNIT;
typedef KSPROPERTY_EXTENSION_UNIT   *PKSPROPERTY_EXTENSION_UNIT;
#endif

/* Kernel streaming videoport VBI notify events */
typedef enum {
    KSEVENT_VPVBINOTIFY_FORMATCHANGE    = 0
} KSEVENT_VPVBINOTIFY;

/* Kernel streaming GOP user data */
typedef struct _KSGOP_USERDATA {
    ULONG   sc;
    ULONG   reserved1;
    BYTE    cFields;
    CHAR    l21Data[3];
} KSGOP_USERDATA;
typedef KSGOP_USERDATA  *PKSGOP_USERDATA;

/* Kernel streaming ActiveMovie TS rate change property */
typedef enum {
    KS_AM_RATE_SimpleRateChange = 1,
    KS_AM_RATE_ExactRateChange  = 2,
    KS_AM_RATE_MaxFullDataRate  = 3,
    KS_AM_RATE_Step             = 4
} KS_AM_PROPERTY_TS_RATE_CHANGE;

/* Kernel streaming ActiveMovie simple rate change */
typedef struct {
    REFERENCE_TIME  StartTime;
    LONG            Rate;
} KS_AM_SimpleRateChange;
typedef KS_AM_SimpleRateChange  *PKS_AM_SimpleRateChange;

/* Kernel streaming ActiveMovie exact rate change */
typedef struct {
    REFERENCE_TIME  OutputZeroTime;
    LONG            Rate;
} KS_AM_ExactRateChange;
typedef KS_AM_ExactRateChange   *PKS_AM_ExactRateChange;

/* Video encoder bit rate modes */
typedef enum {
    ConstantBitRate         = 0,
    VariableBitRateAverage  = 1,
    VariableBitRatePeak     = 2
} VIDEOENCODER_BITRATE_MODE;

/* Kernel streaming jack properties */
typedef enum {
    KSPROPERTY_JACK_DESCRIPTION     = 1,
    KSPROPERTY_JACK_DESCRIPTION2    = 2,
    KSPROPERTY_JACK_SINK_INFO       = 3
} KSPROPERTY_JACK;

/* Connection types */
typedef enum {
    eConnTypeUnknown                = 0,
    eConnType3Point5mm              = 1,
    eConnTypeQuarter                = 2,
    eConnTypeAtapiInternal          = 3,
    eConnTypeRCA                    = 4,
    eConnTypeOptical                = 5,
    eConnTypeOtherDigital           = 6,
    eConnTypeOtherAnalog            = 7,
    eConnTypeMultichannelAnalogDIN  = 8,
    eConnTypeXlrProfessional        = 9,
    eConnTypeRJ11Modem              = 10,
    eConnTypeCombination            = 11,
} EPcxConnectionType;

/* Geographic locations */
typedef enum {
    eGeoLocRear                 = 1,
    eGeoLocFront                = 2,
    eGeoLocLeft                 = 3,
    eGeoLocRight                = 4,
    eGeoLocTop                  = 5,
    eGeoLocBottom               = 6,
    eGeoLocRearPanel            = 7,
    eGeoLocRiser                = 8,
    eGeoLocInsideMobileLid      = 9,
    eGeoLocDrivebay             = 10,
    eGeoLocHDMI                 = 11,
    eGeoLocOutsideMobileLid     = 12,
    eGeoLocATAPI                = 13,
    EPcxGeoLocation_enum_count  = 16
} EPcxGeoLocation;

/* General locations */
typedef enum {
    eGenLocPrimaryBox           = 0,
    eGenLocInternal             = 1,
    eGenLocSeparate             = 2,
    eGenLocOther                = 3,
    EPcxGenLocation_enum_count  = 4
} EPcxGenLocation;

/* Port connections */
typedef enum {
    ePortConnJack                   = 0,
    ePortConnIntegratedDevice       = 1,
    ePortConnBothIntegratedAndJack  = 2,
    ePortConnUnknown                = 3
} EPxcPortConnection;

/* Kernel streaming jack description */
typedef struct {
    DWORD               ChannelMapping;
    COLORREF            Color;
    EPcxConnectionType  ConnectionType;
    EPcxGeoLocation     GeoLocation;
    EPcxGenLocation     GenLocation;
    EPxcPortConnection  PortConnection;
    BOOL                IsConnected;
} KSJACK_DESCRIPTION;
typedef KSJACK_DESCRIPTION  *PKSJACK_DESCRIPTION;

/* Kernel streaming jack sink connection types */
typedef enum {
    KSJACK_SINK_CONNECTIONTYPE_HDMI         = 0,
    KSJACK_SINK_CONNECTIONTYPE_DISPLAYPORT  = 1
} KSJACK_SINK_CONNECTIONTYPE;

/* Kernel streaming jack sink information */
typedef struct _tagKSJACK_SINK_INFORMATION {
    KSJACK_SINK_CONNECTIONTYPE  ConnType;
    WORD                        ManufacturerId;
    WORD                        ProductId;
    WORD                        AudioLatency;
    BOOL                        HDCPCapable;
    BOOL                        AICapable;
    UCHAR                       SinkDescriptionLength;
    WCHAR                       SinkDescription[MAX_SINK_DESCRIPTION_NAME_LENGTH];
    LUID                        PortId;
} KSJACK_SINK_INFORMATION;
typedef KSJACK_SINK_INFORMATION *PKSJACK_SINK_INFORMATION;

/* Kernel streaming jack description (version 2) */
typedef struct _tagKSJACK_DESCRIPTION2 {
    DWORD   DeviceStateInfo;
    DWORD   JackCapabilities;
} KSJACK_DESCRIPTION2;
typedef KSJACK_DESCRIPTION2 *PKSJACK_DESCRIPTION2;

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _KSMEDIA_ */
