/*
 *  lmaudit.h   LAN Manager auditing functions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2010 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _LMAUDIT_
#define _LMAUDIT_

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#ifdef __cplusplus
extern "C" {
#endif

#ifndef _LMHLOGDEFINED_
#define _LMHLOGDEFINED_

/* Log flags */
#define LOGFLAGS_FORWARD    0x00000000L
#define LOGFLAGS_BACKWARD   0x00000001L
#define LOGFLAGS_SEEK       0x00000002L

/* Error log handle */
typedef struct _HLOG {
    DWORD   time;
    DWORD   last_flags;
    DWORD   offset;
    DWORD   rec_offset;
} HLOG;
typedef HLOG    *PHLOG;
typedef HLOG    *LPHLOG;

#endif /* _LMHLOGDEFINED_ */

/* Lockout actions */
#define ACTION_LOCKOUT      00
#define ACTION_ADMINUNLOCK  01

/* Audit entry types */
#define AE_SRVSTATUS    0L
#define AE_SESSLOGON    1L
#define AE_SESSLOGOFF   2L
#define AE_SESSPWERR    3L
#define AE_CONNSTART    4L
#define AE_CONNSTOP     5L
#define AE_CONNREJ      6L
#define AE_RESACCESS    7L
#define AE_RESACCESSREJ 8L
#define AE_CLOSEFILE    9L
#define AE_SERVICESTART 11L
#define AE_ACLMOD       12L
#define AE_UASMOD       13L
#define AE_NETLOGON     14L
#define AE_NETLOGOFF    15L
#define AE_NETLOGDENIED 16L
#define AE_ACCLIMITEXCD 17L
#define AE_RESACCESS2   18L
#define AE_ACLMODFAIL   19L
#define AE_LOCKOUT      20L
#define AE_GENERIC_TYPE 21L

/* Server states */
#define AE_SRVSTART     0L
#define AE_SRVPAUSED    1L
#define AE_SRVCONT      2L
#define AE_SRVSTOP      3L

/* Session logon privileges */
#define AE_GUEST    0L
#define AE_USER     1L
#define AE_ADMIN    2L

/* Audit entry reasons */
#define AE_NORMAL           0L
#define AE_USERLIMIT        0L
#define AE_GENERAL          0L
#define AE_ERROR            1L
#define AE_SESSDIS          1L
#define AE_BADPW            1L
#define AE_AUTODIS          2L
#define AE_UNSHARE          2L
#define AE_ADMINPRIVREQD    2L
#define AE_ADMINDIS         3L
#define AE_NOACCESSPERM     3L
#define AE_ACCRESTRICT      4L
#define AE_NORMAL_CLOSE     0L
#define AE_SES_CLOSE        1L
#define AE_ADMIN_CLOSE      2L

/* Audit entry subreasons */
#define AE_LIM_UNKNOWN      0L
#define AE_LIM_LOGONHOURS   1L
#define AE_LIM_EXPIRED      2L
#define AE_LIM_INVAL_WKSTA  3L
#define AE_LIM_DISABLED     4L
#define AE_LIM_DELETED      5L

/* Audit entry actions */
#define AE_MOD      0L
#define AE_DELETE   1L
#define AE_ADD      2L

/* UAS record types */
#define AE_UAS_USER     0L
#define AE_UAS_GROUP    1L
#define AE_UAS_MODALS   2L

/* Audit event masks */
#define SVAUD_SERVICE       0x00000001L
#define SVAUD_GOODSESSLOGON 0x00000006L
#define SVAUD_BADSESSLOGON  0x00000018L
#define SVAUD_SESSLOGON     (SVAUD_GOODSESSLOGON | SVAUD_BADSESSLOGON)
#define SVAUD_GOODNETLOGON  0x00000060L
#define SVAUD_BADNETLOGON   0x00000180L
#define SVAUD_NETLOGON      (SVAUD_GOODNETLOGON | SVAUD_BADNETLOGON)
#define SVAUD_LOGON         (SVAUD_NETLOGON | SVAUD_SESSLOGON)
#define SVAUD_GOODUSE       0x00000600L
#define SVAUD_BADUSE        0x00001800L
#define SVAUD_USE           (SVAUD_GOODUSE | SVAUD_BADUSE)
#define SVAUD_USERLIST      0x00002000L
#define SVAUD_PERMISSIONS   0x00004000L
#define SVAUD_RESOURCE      0x00008000L
#define SVAUD_LOGONLIM      0x00010000L

/* Access audit masks */
#define AA_AUDIT_ALL    0x00000001L
#define AA_A_OWNER      0x00000004L
#define AA_CLOSE        0x00000008L
#define AA_S_OPEN       0x00000010L
#define AA_S_WRITE      0x00000020L
#define AA_S_CREATE     0x00000020L
#define AA_S_DELETE     0x00000040L
#define AA_S_ACL        0x00000080L
#define AA_S_ALL        (AA_S_OPEN | AA_S_WRITE | AA_S_DELETE | AA_S_ACL)
#define AA_F_OPEN       0x00000100L
#define AA_F_WRITE      0x00000200L
#define AA_F_CREATE     0x00000200L
#define AA_F_DELETE     0x00000400L
#define AA_F_ACL        0x00000800L
#define AA_F_ALL        (AA_F_OPEN | AA_F_WRITE | AA_F_DELETE | AA_F_ACL)
#define AA_A_OPEN       0x00001000L
#define AA_A_WRITE      0x00002000L
#define AA_A_CREATE     0x00002000L
#define AA_A_DELETE     0x00004000L
#define AA_A_ACL        0x00008000L
#define AA_A_ALL        (AA_F_OPEN | AA_F_WRITE | AA_F_DELETE | AA_F_ACL)

/* Audit entry */
typedef struct _AUDIT_ENTRY {
    DWORD   ae_len;
    DWORD   ae_reserved;
    DWORD   ae_time;
    DWORD   ae_type;
    DWORD   ae_data_offset;
    DWORD   ae_data_size;
} AUDIT_ENTRY;
typedef AUDIT_ENTRY *PAUDIT_ENTRY;
typedef AUDIT_ENTRY *LPAUDIT_ENTRY;

/* The Microsoft version of lmaudit.h defines structure with the audit entry data for
 * specific audit entry types.  However, they have the same names as the AE_* constants
 * and are therefore unusable.  In the interest of not wasting space, they are omitted
 * here.
 */

/* Generic audit entry data */
typedef struct _AE_GENERIC {
    DWORD   ae_ge_msgfile;
    DWORD   ae_ge_msgnum;
    DWORD   ae_ge_params;
    DWORD   ae_ge_param1;
    DWORD   ae_ge_param2;
    DWORD   ae_ge_param3;
    DWORD   ae_ge_param4;
    DWORD   ae_ge_param5;
    DWORD   ae_ge_param6;
    DWORD   ae_ge_param7;
    DWORD   ae_ge_param8;
    DWORD   ae_ge_param9;
} AE_GENERIC;
typedef AE_GENERIC  *PAE_GENERIC;
typedef AE_GENERIC  *LPAE_GENERIC;

/* Functions in NETAPI32.DLL */
NET_API_STATUS NET_API_FUNCTION NetAuditClear( LPCWSTR, LPCWSTR, LPCWSTR );
NET_API_STATUS NET_API_FUNCTION NetAuditRead( LPCWSTR, LPCWSTR, LPHLOG, DWORD, LPDWORD, DWORD, DWORD, LPBYTE *, DWORD, LPDWORD, LPDWORD );
NET_API_STATUS NET_API_FUNCTION NetAuditWrite( DWORD, LPBYTE, DWORD, LPCWSTR, LPBYTE );

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _LMAUDIT_ */
