/*
 *  wsnetbs.h   Windows Sockets Netbios definitions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2010 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _WSNETBS_
#define _WSNETBS_

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* Netbios name length */
#define NETBIOS_NAME_LENGTH 16

/* Netbios name types */
#define NETBIOS_UNIQUE_NAME         0x0000
#define NETBIOS_GROUP_NAME          0x0001
#define NETBIOS_TYPE_QUICK_UNIQUE   0x0002
#define NETBIOS_TYPE_QUICK_GROUP    0x0003

/* Netbios socket address */
typedef struct sockaddr_nb {
    short   snb_family;
    u_short snb_type;
    char    snb_name[NETBIOS_NAME_LENGTH];
} SOCKADDR_NB;
typedef SOCKADDR_NB *PSOCKADDR_NB;
typedef SOCKADDR_NB *LPSOCKADDR_NB;

/* Macro to initialize a Netbios socket address */
#define SET_NETBIOS_SOCKADDR( x, p1, p2, p3 ) \
    { \
        int __i; \
        (x)->snb_family = AF_NETBIOS; \
        (x)->snb_type = (p1); \
        for( __i = 0; __i < NETBIOS_NAME_LENGTH - 1; __i++ ) { \
            (x)->snb_name[__i] = ' '; \
        } \
        for( __i = 0; *((p2) + __i) != '\0' && __i < NETBIOS_NAME_LENGTH - 1; __i++ ) { \
            (x)->snb_name[__i] = *((p2) + __i); \
        } \
        (x)->snb_name[NETBIOS_NAME_LENGTH - 1] = (p3); \
    }

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _WSNETBS_ */
