uses Crt,VenomGFX;


Const
   MaxTrees = 20;
   Iterations = 32000;

type
   TreeType = record
   ox,oy,mull,px,py:real;
   sets:array[1..6,1..6] of real;
   r,g,b:longint;
   exist:boolean;
   end;

var
   Trees:array[1..MaxTrees] of TreeType;
   dtree:array[1..6,1..6] of real;


Procedure Saturate(var r,g,b:longint);
begin
if r>31 then r:=31 else if r<0 then r:=0;
if g>63 then g:=63 else if g<0 then g:=0;
if b>31 then b:=31 else if b<0 then b:=0;
end;

Function AdditiveMix(colr1,rr,gg,bb:longint):longint;
var r,g,b:longint;
begin
r:=Split_R(colr1)+rr;
g:=Split_G(colr1)+gg;
b:=Split_B(colr1)+bb;
Saturate(r,g,b);
Exit(RGB2word(r,g,b));
End;

Procedure AddTree(x,y,m:real;r,g,b:longint;offs:real);
var i,xs,ys,ofo:longint;
    oof:real;
begin
oof:=offs/2;
ofo:=round(offs);
for i:=1 to MaxTrees do
    begin
    if not trees[i].exist then
       begin
       trees[i].exist:=true;
       trees[i].px:=x;
       trees[i].py:=y;
       trees[i].mull:=m;
       for ys:=1 to 6 do
           for xs:=1 to 6 do
               trees[i].sets[xs,ys]:=DTree[xs,ys]+(random(ofo)-oof);
       trees[i].r:=r;
       trees[i].g:=g;
       trees[i].b:=b;
       Break;  {Exit for}
       end;
    end;
end;

label NahlyKonec;
var
   a,b,c,d,e,f,x,y,ox,oy,col:real;
   r,i,hx,hy,p,cnt,rx,ry:longint;
   obr:virtualwindow;

begin
randomize;
Init_Graph(Find_mode(1280,1024));

hx:=1280 div 2;
hy:=1024-10;
DTree[1,1] := 0.0500; DTree[1,2] :=  0.6000; DTree[1,3] :=  0.0000; DTree[1,4] :=  0.0000; DTree[1,5] :=  0.0000; DTree[1,6] :=  0.0000;
DTree[2,1] := 0.0500; DTree[2,2] := -0.5000; DTree[2,3] :=  0.0000; DTree[2,4] :=  0.0000; DTree[2,5] :=  0.0000; DTree[2,6] :=  1.0000;
DTree[3,1] := 0.6000; DTree[3,2] :=  0.5000; DTree[3,3] :=  0.6980; DTree[3,4] :=  0.6980; DTree[3,5] :=  0.0000; DTree[3,6] :=  0.6000;
DTree[4,1] := 0.5000; DTree[4,2] :=  0.4500; DTree[4,3] :=  0.3490; DTree[4,4] :=  0.3492; DTree[4,5] :=  0.0000; DTree[4,6] :=  1.1000;
DTree[5,1] := 0.5000; DTree[5,2] :=  0.5500; DTree[5,3] := -0.5240; DTree[5,4] := -0.5240; DTree[5,5] :=  0.0000; DTree[5,6] :=  1.0000;
DTree[6,1] := 0.6500; DTree[6,2] :=  0.4000; DTree[6,3] := -0.6980; DTree[6,4] := -0.6980; DTree[6,5] :=  0.0000; DTree[6,6] :=  0.7000;

FillChar(trees,sizeof(trees),0);

repeat
If cnt = 6 Then begin Clr(vga,0);cnt:=0;end;
for i:=1 to Random(3) do
    AddTree (random(1280),random(1024-500)+500, random(300)+100, random(16)+16, random(16)+16, 16, 0.05);

For i:=1 To Iterations do
    begin
    For p:=1 To MaxTrees do
        begin
        If Trees[p].exist Then
               begin
                r := random(6)+1;
                A := trees[p].Sets[r,1];
                B := trees[p].Sets[r,2];
                C := trees[p].Sets[r,3];
                D := trees[p].Sets[r,4];
                E := trees[p].Sets[r,5];
                F := trees[p].Sets[r,6];
                x := (A*Cos(C)*trees[p].ox)-(B*Sin(D)*trees[p].oy)+E;
                y := (A*Sin(C)*trees[p].ox)+(B*Cos(D)*trees[p].oy)+F;
                trees[p].ox := x;
                trees[p].oy := y;
                RX := round(trees[p].px-x*trees[p].mull);
                RY := round(trees[p].py-y*trees[p].mull);
                PutClippedPixel(vga,rx,ry,AdditiveMix(GetClippedPixel(vga,rx,ry),trees[p].r,trees[p].g,trees[p].b));
               End;
        if keypressed then if readkey=#27 then Goto NahlyKonec;
        end;
    end;
inc(cnt);
until 1=2;
NahlyKonec:
while keypressed do readkey;
Kill_Graph;
end.