
/* This program was written originally by Raimund Spaeth.
   I have made the following modifications:

	  - SCREEN_ROWS, SCREEN_COLS variable
	  - printd disabled
	  - setting of ANSI colors with original <ESC> sequences
	  - no special file "mbedit.mac" for WIN_32 required

   M. Braun
*/

#if 0
//----------------------------------------------------------------------------
// Bastel-"Lsung", um den von Michael Braun (e-mail: braun-m@t-online.de,
//   http://home.t-online.de/home/braun-m) verffentlichten Multi-Platform
//   Editor "MBEDIT" (FSF GPL >= V2) auch unter Windows NT nutzen zu knnen.
//
// Vielleicht ist ja alles nur ein Miverstndnis: Beim Experimentieren mit
//   Suse Linux 6.4 ist mir zufllig besagter "MBEDIT" aufgefallen.
//   Wegen der netten Kombination von Calculator und Macro Recorder fand
//   ich dann dieses "old-styled" Tool recht ntzlich und wollte es auch
//   unter Windows NT (4.0 SP5) mal ausprobieren.
//
// Da habe ich wohl etwas falsch gemacht: auf dem Bildschirm erschienen
//   Terminal Steuersequenzen statt lesbarem Text. Soweit ich Windows NT
//   kenne, werden <ESC> Sequenzen fr 32 bit Konsol-Anwendungen ja auch
//   nicht untersttzt. Die Variante 16 bit command.com mit mit ANSI.SYS
//   und DOS-Version von "MBEDIT" macht wegen der begrenzten Puffergre
//   in dieser Umgebung sicher keinen Sinn.
//
// Die Frage: Wie komme ich zu einer 32 bit Konsol-Version
//            von "MBEDIT" fr Windows NT?
//
// Experten, bitte nicht lachen: mir ist nichts anderes (als einfache
//   "Lsung") eingefallen, als alle "MBEDIT" Ausgaben abzufangen und
//   die Terminal Steuersequenzen (minimaler Umfang) in Win32 Konsol-
//   funktionen umzusetzen.
//
// DER SOURCECODE IST SCHNELL MAL ZUSAMMENGEFLICKT: Mir fehlte die Mue
//   fr Qualittsarbeit (das generelle Freeware-Problem?). Es fehlt
//   jegliche Fehlerbehandlung, fr maximale Windowsize sind willkrliche
//   Konstanten benutzt .........., die Mngelliste liee sich (fast)
//   endlos fortsetzen. Wenn mal eines Tages so richtig Zeit vom
//   Himmel fllt, wird alles anders .......... Genug, da ich mich
//   aufgerafft habe, diese Zeilen zu schreiben - fr den "MBEDIT"
//   Autor als Feedback.
//
// Die "MBEDIT.MAC" Datei mu natrlich zu dieser einfachen Bastelei
//   passen - siehe gefilterte ESC Sequenzen (was passiert bei SW != 0?
//   was schreibt WriteConsole wohl als "bell" auf den Bildschirm? .....
//   - ich habe es nicht ausprobiert, SW0 ist fr mich o.k. Aber es
//   lauern noch andere Fallgruben bei "unpassender" "MBEDIT.MAC" Datei!

//----------------------------------------------------------------------------
// Was habe ich mit den Original-Quellen von Michael Braun gemacht?
//   Nach dem letzen #include in allen .c Dateien noch ein
//   #include "ansi_out.h" eingefgt, die Dateien ansi_out.h und
//   ansi_out.c in den Trichter ..... UND EIN PASSENDE "MBEDIT.MAC"
//   DATEI NICHT VERGESSEN!
//
// Etwas Raten und Experimentieren zeigte, da alle Ausgaben ber
//   printf() und putchar() laufen. Damit werden durch
//
//     #define   printf       ansi_printf
//     #define   putchar(c)   ansi_putchar(c)
//
//   an passender Stelle alle Ausgaben "umgelenkt".
//
//                    +----------+
//                      MBEDIT  
//                    +----------+
//                             
//              +--------+     +---------+
//               printf       putchar 
//              +--------+     +---------+
//                             
//            +-------------+   
//             ansi_printf    
//            +-------------+   
//                             
//                  +--------------+
//                   ansi_putchar 
//                  +--------------+
//                             
//    +------------------+     +-----------------+
//     char ansi_buf[]        console_putchar 
//     process_ansi_buf                       
//                            WriteConsole    
//     Set..Cursor....       +-----------------+
//     Set..TextAttr..  
//    +------------------+
//
// Ach ja, und noch etwas: Die "MBEDIT" Version hatte ein global.h
//   mit "V8.17". Bei bersetzung mit Microsoft Visual Studio V6.0 SP3
//   macht sich ein Bug in disp_hnd.c bemerkbar,
//
//     [ Die Variable "comment_type" in "disp_1_line()" ist nicht
//       als static deklariert. ]
//
//   der natrich nicht auffllt, wenn Compiler und Betriebssystem
//   zusammen ein glckliches Hndchen haben, und die auto Variable
//   so im Stack liegt, da auch durch evtl. Interupt-Behandlung
//   diese zwischen zwei Aufrufen (es geht ja um die Erkennung von
//   mehrzeiligem Kommentar!) nicht berschrieben wird.
//
// Aber mit GNU (wie in Suse Liniux 6.4 bzw. mingw32 2.95.2-msvcrt)
//   passiert weder unter Suse Linux 6.4 noch unter
//   Windows NT 4.0 SP5 etwas!
//   Die alte Binsenweisheit, da Software manchmal eher zufllig
//   doch funktioniert, ist damit wieder einmal mehr besttigt.
//
// Zum Schlu herzlichen Dank allen, die zum Enstehen von "MBEDIT"
//   beigetragen haben. Ich find es recht praktisch, jetzt unter
//   Windows NT und Linux mit den gleichen Tasten zum gleichen
//   Ergebnis zu kommen - und zum Thema "vi" o.. hier kein weiterer
//   Kommentar!
//
// 8. August 2000, Raimund Spth, 100527.1475@compuserve.com
//
// Jeder Hinweis auf eine einfachere Methode, "MBEDIT" unter
//   Windows NT als 32 bit Applikation zum Laufen zu bringen,
//   ist natrlich herzlich willkommen!

//----------------------------------------------------------------------------
// Last BUT NOT LEAST: Alles gem FSF GPL >= V2!
//
// KEINE GEWHR fr ordnungsgeme Funktion --- EXPERIMENTELLE VERSION!

//----------------------------------------------------------------------------
#endif

#include "config.h"
#include "global.h"

#if 0
#include "standard.h"
#else
#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <windows.h>
#endif

#include "ansi_out.h"
#include "wincon.h"


#define   SCREEN_ROWS   ROWS
#define   SCREEN_COLS   COLUMNS


static const WORD fg_colors [9] =
{
/* 0 = black        */ 0,
/* 1 = red          */ FOREGROUND_RED,
/* 2 = green        */                    FOREGROUND_GREEN,
/* 3 = yellow       */ FOREGROUND_RED   | FOREGROUND_GREEN,
/* 4 = blue         */                                       FOREGROUND_BLUE,
/* 5 = magenta      */ FOREGROUND_RED   |                    FOREGROUND_BLUE,
/* 6 = cyan         */                    FOREGROUND_GREEN | FOREGROUND_BLUE,
/* 7 = white        */ FOREGROUND_RED   | FOREGROUND_GREEN | FOREGROUND_BLUE, 
/* 8 = bright white */ FOREGROUND_RED   | FOREGROUND_GREEN | FOREGROUND_BLUE | FOREGROUND_INTENSITY, 
};

static const WORD bg_colors [9] =
{
/* 0 = black        */ 0,
/* 1 = red          */ BACKGROUND_RED,
/* 2 = green        */                    BACKGROUND_GREEN,
/* 3 = yellow       */ BACKGROUND_RED   | BACKGROUND_GREEN,
/* 4 = blue         */                                       BACKGROUND_BLUE,
/* 5 = magenta      */ BACKGROUND_RED   |                    BACKGROUND_BLUE,
/* 6 = cyan         */                    BACKGROUND_GREEN | BACKGROUND_BLUE,
/* 7 = white        */ BACKGROUND_RED   | BACKGROUND_GREEN | BACKGROUND_BLUE, 
/* 8 = bright white */ BACKGROUND_RED   | BACKGROUND_GREEN | BACKGROUND_BLUE | BACKGROUND_INTENSITY, 
};


/*--------------------------------------------------------------------------*/

static int  display_lines = 0;

static HANDLE Hco = NULL;
static char ansi_buf[40];



void get_screen_lin_col (int *lines, int *columns)
{
static CONSOLE_SCREEN_BUFFER_INFO  psb_info;

	GetConsoleScreenBufferInfo(Hco, &psb_info);

#if 0
	*lines   = psb_info.dwSize.Y;   /* o.k. in Win95, but not in Win2000 */
	*columns = psb_info.dwSize.X;
#else
	*lines   = psb_info.srWindow.Bottom - psb_info.srWindow.Top  + 1;
	*columns = psb_info.srWindow.Right  - psb_info.srWindow.Left + 1;
#endif

	return;
}

#if 0
//----------------------------------------------------------------------------
// Nur zum Testen (englisches Windows NT, die Caption des missbrauchten
//                 Notepad Fensters ist "Untitled - Notepad", fr deutsches
//                 Windows anpassen!).
//
// Fr GDB geplagte Zeitgenossen, die unter Windows arbeiten, aber partout
//   dem Luxus des Microsoft Visual Studio aus dem Weg gehen wollen:
//   Wenn ein Notepad Fenster mit der richtigen Caption gefunden wird,
//   landen alle printd() Ausgaben in diesem Notepad Fenster.
//   Wenn der Puffer voll ist, erscheinen die neuen Ausgaben zwar noch am Ende,
//   aber der vorhergende Text wird abgehackt! (Daher der grosse msg Buffer).
//   Nicht vergessen: Linefeed muss als "\r\n" angeliefert werden, alles
//   geht ungefiltert an das Notepad (und dieses kennt "\n" nur als
//   Graphikzeichen)!
//
// Fr Neugierige: Auch wenn in "MBEDIT.MAC" kein "<ESC>[7m" definiert ist,
//   beim Programmstart kommen einige dieser Sequenzen: Lt sich im Notepad
//   (mit der richtigen Caption!) beobachten!
#endif

#if 0

int printd(char *fmt, ...)
{
    HWND      Nwnd, Cwnd;
    char      s[200];
    va_list   args;
    int       len;
    int       lines;
    char      s_display_lines[10];

static char msg[200000];         /* Nur zum Testen, aber keine Angst vor */
                                 /* groen Zahlen in 32 bit Umgebung!    */

    Nwnd = FindWindow(NULL, "Untitled - Notepad");

    if(Nwnd == NULL)
        return -1;

    Cwnd = GetWindow(Nwnd, GW_CHILD);   /* Notepad hat genau ein         */
                                        /* Edit Control als Child Window */
    if(Cwnd == NULL)
        return -2;

    va_start(args, fmt);
    len = vsprintf(s, fmt, args);
    va_end(args);

    sprintf(s_display_lines, "<%-6d>  ", ++display_lines);

    (void) SendMessage(Cwnd, WM_GETTEXT, sizeof(msg)/sizeof(msg[0]) - 1000,
                       (LPARAM) msg);
    strcat(msg, s_display_lines);
    strcat(msg, s);
    (void) SendMessage(Cwnd, WM_SETTEXT, 0, (LPARAM) msg);

    lines = SendMessage(Cwnd, EM_GETLINECOUNT, 0, 0);

    if(lines > 5)
        (void) SendMessage(Cwnd, EM_LINESCROLL, 0, lines - 3);

    return len;
}

#endif

#if 0
//----------------------------------------------------------------------------
// Ausgabe eines einzelnen Zeichens in Windows NT Konsole.
// Sollte theoretisch auch unter Win9x gehen, aber Vorsicht:
//   Die Konsol-Funktionen in Win9x haben einige "Features"!
#endif

void console_putchar(int c)
{
    char    s[2];
    DWORD   num;

    s[0] = (char) c;
    s[1] = 0;

    if(Hco == NULL)
    {
        Hco = GetStdHandle(STD_OUTPUT_HANDLE);

        if(Hco == NULL)
            return;
    }

    (void) WriteConsole(Hco, s, 1, &num, NULL);
}

#if 0
//----------------------------------------------------------------------------
// Hier werden alle <ESC> Sequenzen bearbeitet.
// Zwischenspeicherung und Erkennung von Anfang/Ende in ansi_putchar.
#endif

void process_ansi_buf()
{
    int                          x, y, n;
    char                         c, c2;
    COORD                        pos;
    DWORD                        num;
    CONSOLE_SCREEN_BUFFER_INFO   CbInfo;
    char                         clear_buf[BUF_256];  /* @@ [SCREEN_COLS + 2]; */
	int							 hl, fg, bg;
	WORD						 fgc, bgc;

    if(Hco == NULL)
    {
        Hco = GetStdHandle(STD_OUTPUT_HANDLE);

		SetConsoleMode(Hco, ENABLE_PROCESSED_OUTPUT); /* turn off ENABLE_WRAP_AT_EOL_OUTPUT, */
		                                              /* silently ignored under Windows 9x ! */

        if(Hco == NULL)
            return;
    }
    

	if(strcmp(ansi_buf, "\033[?25h") == 0)   /* Cursor On */
        return;


    if(strcmp(ansi_buf, "\033[?25l") == 0)   /* Cursor Off */
        return;


    if(strcmp(ansi_buf, "\033[?7h") == 0)    /* Wrap On */
        return;


    if(strcmp(ansi_buf, "\033[?7l") == 0)    /* Wrap Off */
        return;


    if(strcmp(ansi_buf, "\033(0") == 0)      /* Grafik On VT100 */
        return;


    if(strcmp(ansi_buf, "\033(B") == 0)      /* Grafik Off VT100 */
        return;


    if((n = sscanf(ansi_buf, "\x1B[%c%c", &c, &c2)) == 1)
    {                                                    /* Cursor Position +/- 1 */
        (void) GetConsoleScreenBufferInfo(Hco, &CbInfo);

        switch(c)
        {
            case 'A':   --(CbInfo.dwCursorPosition.Y);   /* Up */
                        break;

            case 'B':   ++(CbInfo.dwCursorPosition.Y);   /* Down */
                        break;

            case 'C':   ++(CbInfo.dwCursorPosition.X);   /* Right */
                        break;

            case 'D':   --(CbInfo.dwCursorPosition.X);   /* Left */
                        break;

            default:	/* printd("Hoppla, Cursor +-1 mit ubekannter Richtung!\r\n", c); */
                        break;
        }

        (void) SetConsoleCursorPosition(Hco, CbInfo.dwCursorPosition);

        return;
    }


    if(strcmp(ansi_buf, "\033[0K") == 0)   /* Clear to EOL */
    {
        (void) GetConsoleScreenBufferInfo(Hco, &CbInfo);

        for(n = 0; CbInfo.dwCursorPosition.X + n < SCREEN_COLS; ++n)
            clear_buf[n] = ' ';
        clear_buf[n] = 0;

        (void) WriteConsole(Hco, clear_buf, 
			                ((CbInfo.dwCursorPosition.Y == (SCREEN_ROWS - 1)) ? 
								(unsigned long) (n-1) : (unsigned long) n),
						    &num, NULL);
        return;
    }


    if(strcmp(ansi_buf, "\033[2K") == 0)   /* Clear Line */
    {
        for(n = 0; n < SCREEN_COLS; ++n)
            clear_buf[n] = ' ';
        clear_buf[n] = 0;

        (void) GetConsoleScreenBufferInfo(Hco, &CbInfo);
        CbInfo.dwCursorPosition.X = 0;
        (void) SetConsoleCursorPosition(Hco, CbInfo.dwCursorPosition);
        (void) WriteConsole(Hco, clear_buf,
			                ((CbInfo.dwCursorPosition.Y == (SCREEN_ROWS - 1)) ? 
								(SCREEN_COLS - 1) : SCREEN_COLS),
							&num, NULL);
        return;
    }


    if(strcmp(ansi_buf, "\033[2J") == 0)     /* Clear Screen */
    {
        for(n = 0; n < SCREEN_COLS; ++n)
            clear_buf[n] = ' ';
        clear_buf[n] = 0;

        pos.X = 0;

        for(n = 0; n < SCREEN_ROWS; ++n)
        {
            pos.Y = (SHORT) n;
            (void) SetConsoleCursorPosition(Hco, pos);
            (void) WriteConsole(Hco, clear_buf, 
				                (n == (SCREEN_ROWS - 1) ?
									(SCREEN_COLS - 1) : SCREEN_COLS),
								&num, NULL);
        }

        return;
    }


    if((n = sscanf(ansi_buf, "\x1B[%d;3%d;4%d%c%c", &hl, &fg, &bg, &c, &c2)) == 4 && c == 'm')
    {
		fgc = fg_colors[fg];
		bgc = bg_colors[bg];

		switch (hl)
		{
		case 0:		/* normal */
		case 1:		/* highlighted */
		case 4:		/* underlined */
		case 5:		/* blinking */
		default:
			break;

		case 7:		/* invers */
			fgc = (WORD)(fg_colors[8] - fgc);
			bgc = (WORD)(bg_colors[8] - bgc);
			break;

		case 8:		/* hidden */
			fgc = bgc;		/* ostfriesische Nationalflagge */
			break;
		}  /* switch hl */

		SetConsoleTextAttribute(Hco, (WORD)(fgc | bgc));
		return;
	}


    if((n = sscanf(ansi_buf, "\x1B[%d%c%c", &y, &c, &c2)) == 2 && c == 'm')
    {                                        /* Attribute setzen */
        switch(y)
        {
            /* Normal Video */
            case 0:    (void) SetConsoleTextAttribute(Hco,
                                  BACKGROUND_RED | BACKGROUND_GREEN | BACKGROUND_BLUE |
                                  BACKGROUND_INTENSITY);
                       break;

            /* Reverse Video */
            case 7:    (void) SetConsoleTextAttribute(Hco,
                                  FOREGROUND_RED | FOREGROUND_GREEN | FOREGROUND_BLUE |
                                  FOREGROUND_INTENSITY);
                       break;

            default:
                       break;
        }

        return;
    }


    if((n = sscanf(ansi_buf, "\033[%d;%dH%c", &y, &x, &c)) == 2)
    {                                        /* Cursor Position setzen */
        pos.X = (SHORT) (x - 1);
        pos.Y = (SHORT) (y - 1);
        (void) SetConsoleCursorPosition(Hco, pos);
        return;
    }

	
    /* printd("Hoppla, Es gibt noch eine unbekannte <ESC> Sequenz!\r\n"); */
}

/*---------------------------------------------------------------------------- */
/* Hier kommen alle Zeichen im Gnsemarsch vorbei. */
/* Entweder direkte Ausgabe oder Zwischenspeicherung einer <ESC> Sequenz. */

int ansi_putchar(int c)
{
    char   s[2];

    if(ansi_buf[0] == 0 && c != 0x1B)
    {
        console_putchar(c);
        return c;
    }

    if(ansi_buf[0] == 0)
    {
        ansi_buf[0] = (char) c;
        ansi_buf[1] = 0;
        return c;
    }

    if(strlen(ansi_buf) + 2 < sizeof(ansi_buf))
    {
        s[0] = (char) c;
        s[1] = 0;
        strcat(ansi_buf, s);

        /* Ende einer <ESC> Sequenz erkennen */
        /* Fr den hier erwarteten Subset! */

        if((c >= 'A' && c <= 'Z') || (c >= 'a' && c <= 'z') ||
           (ansi_buf[1] == '(' && ansi_buf[2]))
        {
            process_ansi_buf();
            ansi_buf[0] = 0;
        }
    }
    else
        ansi_buf[0] = 0;

    return c;
}

/*---------------------------------------------------------------------------- */

int ansi_printf(char *fmt, ...)
{
    char      buffer[2000];
    va_list   args;
    int       i, len;

    va_start(args, fmt);
    len = vsprintf(buffer, fmt, args);

    for(i = 0; buffer[i]; ++i)
        (void) ansi_putchar(buffer[i]);   /* Alles mu durch's Nadelhr! */

    va_end(args);

    return len;
}

/*---------------------------------------------------------------------------- */
/* 28.10.03 - comment characters "//" replaced by "/*" */
