#!/bin/awk -f
BEGIN {
  if(nasm){ASM="inv-nasm.asm";INC="inv-nasm.inc"}else ASM="inv-fasm.asm"
  skip1["ASSUME"]  = skip1["Assume"] = skip1["END"]  = \
  skip2["SEGMENT"] = skip2["ENDS"]   = skip2["ENDP"] = 1
  if(nasm)print "%idefine offset\n%define LEA MOV\n" \
    "%define B byte\n%define W word\n%include '" INC "'" >ASM
  else print "OFFSET equ\nOffset equ\nLEA equ MOV" >ASM
}

linenum && (NR % 100)==0 { print "linenum=",NR }
/^;/ || /^ *$/ || $1 in skip1 || $2 in skip2 { next }
/LEA / { print >ASM; next }
/\[[1-9]\]/ { for(i=1;i <= 9;i++) sub("\\["i"\\]","+"i) }
nasm && /[+]BX/ { gsub("\\[|\\]","") }

/ D[BWD] / {
  sub(" DD "," DW 0,")
  if ((nasm) && ($2 ~ /^D[BW]$/))
    printf "%%define s_%s %c\n",$1,substr($2,2,1) >INC
  print >ASM; next
}

{
  sub(";.*|\\[0\\]|40:|Word Ptr","")
  sub(" *PROC .*",":"); sub("ES:\\[","[ES:"); sub(","," ")

  if ($1 ~ /:$/) {
    print $1 >ASM; if($1=="RemoveNewInt9:")cseg++
    for(i=2;i <= NF;i++)$(i-1)=$i; $NF=""; NF--
  }


  if (!($1 in skip1))
    if (((NF > 2) && ($2 ~ /^[A-Z][^ ][^ ][^ ]*/)) ||
       (($1 ~ /DEC|INC/) && ($2 ~ /^[A-Z][^ ][^ ][^ ]*/)))
      if (nasm) $2="s_"$2"["$2"]"; else $2="["$2"]"
    else if (($3 ~ /^[A-Z][^ ][^ ][^ ]*/) && ($3 !~ /^O[fF]/))
      if (nasm) $3="s_"$3"["$3"]"; else $3="["$3"]"

  if (nasm) sub("[+].*\\[","[")
  if ((cseg) && ($0 !~ /\[0/))sub("\\[","[cs:"); if($1=="CLC")cseg--

  for(i=1;i <= NF;i++)
    printf "%s%c%s",$i,(i==2 && NF > 2)?",":" ",(i==NF)?"\n":"" >ASM
}
# EOF
