(*$MAIN+ *)
(* public domain, nenies proprajho, free for any use *)
MODULE inc2tiny;
IMPORT O := Out,F := Myfiles,S := Str;

CONST maxbytenames=60;
TYPE  bytestr = ARRAY 19+1 OF CHAR;
VAR   bytenames:ARRAY maxbytenames OF bytestr;

PROCEDURE getbytenames;
VAR line:ARRAY 31+1 OF CHAR; num,len:INTEGER; nasminc:F.File;
BEGIN num := 0; nasminc := F.Open("inv-nasm.inc","r");
  IF nasminc = NIL THEN O.String("Oops!"); O.Ln; HALT(255) END;
  WHILE ~F.Eof(nasminc) DO
    IF F.readline(nasminc,line) # 0 THEN ; END; len := S.Length(line);
    IF (len > 0) & (line[len-1]="B") THEN
      S.Extract(line,10,len-12,bytenames[num]);
      INC(num)
    END
  END;
  F.Close(nasminc)
END getbytenames;

PROCEDURE isbytename(s:ARRAY OF CHAR):BOOLEAN;
VAR n:INTEGER; done:BOOLEAN;
BEGIN done := FALSE; n := 0;
  WHILE (n < maxbytenames) & ~done DO
    IF bytenames[n] = s THEN done := TRUE END;
    INC(n)
  END;
  RETURN done
END isbytename;

PROCEDURE writenew;
VAR line:ARRAY 150+1 OF CHAR; p,p2:INTEGER; attr:SET;
    myseg:ARRAY 4 OF CHAR; tmp:ARRAY 19+1+2 OF CHAR; oldasm,newasm:F.File;
CONST hasdigit=0; hasbrak=1; hascolon=2; hascomma=3;

  PROCEDURE find(s:ARRAY OF CHAR):INTEGER;
  BEGIN RETURN S.Pos(s,line,0)
  END find;

  PROCEDURE found(s:ARRAY OF CHAR):BOOLEAN;
  BEGIN p := find(s); RETURN p # -1
  END found;

  PROCEDURE ins(s:ARRAY OF CHAR;n:INTEGER);
  BEGIN S.Insert(s,n,line)
  END ins;

  PROCEDURE del(ofs,num:INTEGER);
  BEGIN IF ofs > -1 THEN S.Delete(line,ofs,num) END
  END del;

  PROCEDURE sub(older,newer:ARRAY OF CHAR);
  BEGIN IF found(older) THEN del(p,S.Length(older)); ins(newer,p) END
  END sub;

  PROCEDURE isupper(k:CHAR):BOOLEAN;
  BEGIN RETURN (k >= "A") & (k <= "Z")
  END isupper;

  PROCEDURE fixhexnums;
  VAR hexbegin,hexend:INTEGER;

    PROCEDURE foundhexnum():BOOLEAN;
    VAR y,z,len:INTEGER;

      PROCEDURE isdigit(k:CHAR):BOOLEAN;
      BEGIN RETURN (k >= "0") & (k <= "9")
      END isdigit;

      PROCEDURE isxdigit(k:CHAR):BOOLEAN;
      BEGIN
        RETURN isdigit(k) OR
               (((k >= "a") & (k <= "f")) OR
                ((k >= "A") & (k <= "F")))
      END isxdigit;

    BEGIN (* foundhexnum *) len := S.Length(line);
      FOR y := 0 TO len-1 DO
        IF isdigit(line[y]) & (y < len-1) THEN
          hexbegin := y; z := y+1;
          WHILE isxdigit(line[z]) & (z < len-1) DO INC(z) END;
          IF (CAP(line[z])="H") THEN
            hexend := z-1;
            RETURN TRUE
          END
        END
      END;
      RETURN FALSE
    END foundhexnum;

  BEGIN hexbegin := -1; hexend := -1;
    WHILE foundhexnum() DO del(hexend+1,1); ins("0x",hexbegin) END;
  END fixhexnums;

  PROCEDURE getattr():SET;
  VAR i:INTEGER; s:SET;
  BEGIN i := 0; s := {};
    WHILE (i < S.Length(line)) & (line[i] # ";") DO
      CASE line[i] OF
          "0".."9": INCL(s,hasdigit)
        | "[": INCL(s,hasbrak)
        | ":": INCL(s,hascolon)
        | ",": INCL(s,hascomma)
      ELSE
      END;
      INC(i)
    END;
    RETURN s
  END getattr;

  PROCEDURE isseg(k:CHAR):BOOLEAN;
  BEGIN
    CASE k OF
      'c','C','d','D','e','E','s','S': RETURN TRUE
    ELSE RETURN FALSE
    END
  END isseg;

BEGIN (* writenew *) myseg := "?S "; oldasm := F.Open("inv-nasm.asm","r");
  IF oldasm = NIL THEN O.String("Oops!"); O.Ln; HALT(255) END;
  newasm := F.Open("inv-tiny.asm","w");

  WHILE ~F.Eof(oldasm) DO
    IF F.readline(oldasm,line) # 0 THEN ; END;

    IF (S.Length(line) > 0) & (line[0] # "%") THEN
      p := -1;

      IF line[0] # ";" THEN
        attr := getattr();

        IF hasdigit IN attr THEN fixhexnums END;

        IF (hasbrak IN attr) & found("+BX") THEN
          del(p,3);
          REPEAT DEC(p) UNTIL line[p]="[";
          ins("BX+",p+1)
        END;

        IF {hascolon,hasbrak} * attr = {hascolon,hasbrak} THEN
          IF found(":") & (CAP(line[p-1])="S") & (line[p-3]="[")
             & isseg(line[p-2])
          THEN
            myseg[0] := CAP(line[p-2]); del(p-2,3); ins(myseg,0)
          END
        END;
  
        IF hascomma IN attr THEN
          sub("LEA ","MOV ");
          IF found(",O") & (CAP(line[p+2])="F") THEN del(p+1,7) END
        END;

        IF (hasbrak IN attr) & found("s_") THEN
          p2 := find("["); S.Extract(line,p+2,p2-p-2,tmp);
          IF isbytename(tmp) THEN
            S.Insert("s_",0,tmp); sub(tmp,"byte")
          ELSE
            S.Insert("s_",0,tmp); sub(tmp,"word")
          END
        END;

        IF isupper(line[0]) & (found(" DB ") OR found(" DW ")) THEN
          ins(":",find(" "))
        END;

        IF {hascomma,hasbrak} * attr = {hascomma,hasbrak} THEN
          IF found(",AL") OR found(" AL,") THEN sub("byte[","[")
          ELSIF found(",AX") OR found(" AX,") THEN sub("word[","[")
          END
        END
      END;

      F.WriteString(newasm,line); F.WriteLn(newasm)
    END
  END;

  F.Close(newasm); F.Close(oldasm)
END writenew;

BEGIN getbytenames; writenew
END inc2tiny.
