/*****************************************************************************
*   SETTINGS.APP - settings program for FreeGEM                              *
*   Copyright 1999, 2005 John Elliott                                        *
*                                                                            *
* This program is free software; you can redistribute it and/or              *
* modify it under the terms of the GNU General Public License                *
* as published by the Free Software Foundation; either version 2             *
* of the License, or (at your option) any later version.                     *
*                                                                            *
* This program is distributed in the hope that it will be useful,            *
* but WITHOUT ANY WARRANTY; without even the implied warranty of             *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              *
* GNU General Public License for more details.                               *
*                                                                            *
* You should have received a copy of the GNU General Public License          *
* along with this program; if not, write to the Free Software                *
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.*
*                                                                           *
******************************************************************************/


#include "settings.h"
#include <ctype.h>

//WORD round;
#ifndef SEEK_SET
#define SEEK_SET 0
#define SEEK_CUR 1
#define SEEK_END 2
#endif


MLOCAL BITBLK icon[3];
MLOCAL WORD icondata[192];
MLOCAL WORD sel_icon;
MLOCAL WORD paint_col;

MLOCAL PPDUBLK pre_ublk[2];

VOID set_clip(WORD clip_flag, GRECT *s_area);
WORD do_clrdrop(LPTREE tr, WORD ob);

void draw_syscell(BITBLK *pb, GRECT *rcobj, WORD x, WORD y)
{
	GRECT rc;
	WORD style = 0, index = 0;
	UWORD mask;
	LPWORD data = (LPWORD)(pb->bi_pdata);

	rc.g_x = rcobj->g_x;
	rc.g_y = rcobj->g_y;
	rc.g_w = (rcobj->g_w) / 32;
	rc.g_h = (rcobj->g_h) / 32;
	rc.g_x += (x * rc.g_w);
	rc.g_y += (y * rc.g_h);
	mask = 0x8000 >> (x % 16);

	if (data[y * 2 + (x/16)] & mask) 
		style = 1;
	else	style = 0;
	filled_rect(&rc, pb->bi_color, WHITE, style, index);
}


MLOCAL WORD paint_grid(LPPARM lp)
{
	PARMBLK pb;
	WORD x, y, dx, dy;
	GRECT rc;
	BITBLK *b;	

	LBCOPY((LPBYTE)ADDR(&pb), (LPBYTE)lp ,sizeof(PARMBLK));
	b = &icon[sel_icon];

	dx = pb.pb_w / 32;
	dy = pb.pb_h / 32;
	set_clip(TRUE, (GRECT *) &pb.pb_xc);
	vsl_color(vdi_handle, BLACK);
	vsl_width(vdi_handle, 1);
	vsl_type(vdi_handle, FIS_SOLID);
	for (y = 0; y < 32; y++)
	{
		for (x = 0; x < 32; x++)
		{
			draw_syscell(b, (GRECT *)(&pb.pb_x), x, y);
		}
	}
	vsl_width(vdi_handle, 1);
	vsl_color(vdi_handle, BLACK);
	rc.g_x = pb.pb_x;
	rc.g_y = pb.pb_y;
	rc.g_w = 32 * dx;
	rc.g_h = 32 * dy;
	draw_rect(&rc);
	set_clip(FALSE, (GRECT *)&pb.pb_xc);
	return 0;
}








WORD LSTCPY(LPBYTE d, LPBYTE s);

extern BYTE 	path[256];

WORD rw_bitmaps(BITBLK *pb, WORD *data, int count, int write)
{
	FILE *fprsc;
	RSHDR rshdr;
	LONG lbitblk;
	BITBLK blk;
	int n, nc;

	if (!write)
	{
		for (n = 0; n < count; n++)
		{
			memset(&pb[n], 0, sizeof(BITBLK));
			pb[n].bi_pdata = ADDR(&data[n * 64]);
			pb[n].bi_color = 1;
			pb[n].bi_wb = 4;
			pb[n].bi_hl = 32;
			pb[n].bi_x  = 0;
			pb[n].bi_y  = 0;
		}
	}
	fprsc = rsc_open(write ? "r+b" : "rb");
	if (!fprsc) return 0;
	if (fread(&rshdr, 1, sizeof(rshdr), fprsc) != sizeof(rshdr))
	{
		fclose(fprsc);
		rsrc_alert(1, NORSC);
		return 0;
	}
	nc = 0;
	for (n = 0; n < rshdr.rsh_nimages; n++)
	{
		fseek(fprsc, rshdr.rsh_frimg + 4L * n, SEEK_SET);
		if (fread(&lbitblk, 1, sizeof(lbitblk), fprsc) 
				!= sizeof(lbitblk))
		{
			fclose(fprsc);
			rsrc_alert(1, NORSC);
			return 0;
		}
		fseek(fprsc, lbitblk, SEEK_SET);
		if (fread(&blk, 1, sizeof(blk), fprsc) != sizeof(blk))
		{
			fclose(fprsc);
			rsrc_alert(1, NORSC);
			return 0;
		}
		if (blk.bi_wb != 4 || blk.bi_hl != 32) continue;
/* Write out colour changes (if any) */
		if (write)
		{
			blk.bi_color = pb[n].bi_color;
			fseek(fprsc, lbitblk, SEEK_SET);
			if (fwrite(&blk, 1, sizeof(blk), fprsc) != sizeof(blk))
			{
				fclose(fprsc);
				rsrc_alert(1, NORSC);
				return 0;
			}
		}
		fseek(fprsc, (long)blk.bi_pdata, SEEK_SET);
		if (write)
		{

			if (fwrite(&data[n * 64], 1, 128, fprsc) != 128)
			{
				fclose(fprsc);
				rsrc_alert(1, NORSC);
				return 0;
			}
		}
		else 
		{
			pb[n].bi_color = blk.bi_color;
			if (fread(&data[n * 64], 1, 128, fprsc) != 128)
			{
				fclose(fprsc);
				rsrc_alert(1, NORSC);
				return 0;
			}
		}
		nc++;
		if (nc >= count) break;
	}
	fclose(fprsc);	
	return nc;
}



WORD read_int(FILE *fp)
{
	int c;
	int v = 0;

	do
	{
		c = fgetc(fp);
/* Skip over comment fields */
		if (c == '#') while (c != '\n' && c != EOF) c = fgetc(fp);
	
	} while (!isdigit(c));
	if (c == EOF) return -1;
	while (isdigit(c))	
	{
		v = (v * 10) + (c - '0');
		c = fgetc(fp);
	}
	ungetc(c, fp);	/* Push back the last non-digit */
	if (c == EOF) return -1;
	return v;
}


VOID load_icon(BITBLK *pb)
{
	BYTE magic[2];
	WORD w,h,x,y,v;
	WORD p1, mask;
	LPWORD data;

	FILE *fp = get_file(TRUE, path, "*.PBM", "rb");
	if (!fp) return;

	data = (LPWORD)(pb->bi_pdata);
	if (fread(magic, 1, 2, fp) < 2)
	{
		fclose(fp);
		rsrc_alert(1, NOPBM);
		return;
	}
	if (memcmp(magic, "P4", 2) && memcmp(magic, "P1", 2)) 
	{
		fclose(fp);
		rsrc_alert(1, NOPBM);
		return;
	}
	p1 = (magic[1] == '1');
	w = read_int(fp);
	h = read_int(fp);
	if (w < 0 || h < 0)
	{
		fclose(fp);
		rsrc_alert(1, NOPBM);
		return;
	}

	if (p1)
	{
		for (y = 0; y < h; y++)
		{
			for (x = 0; x < w; x++)
			{
				v = read_int(fp);
				mask = 0x8000 >> (x % 16);
				if (v == 1 && y < 32 && x < 32)
				{
					data[y*2 + (x/16)] |= mask;
				}
				else if (v == 0 && y < 32 && x < 32)
				{
					data[y*2 + (x/16)] &=~ mask;
				}
			}
		}	

	}
	else
	{
		fgetc(fp);
		for (y = 0; y < h; y++)
		{
			for (x = 0; x < w; x += 8)
			{
				v = fgetc(fp);
				if (y < 32 && x < 32)
				{
					pb->bi_pdata[y*4 + (x/8)^1] = v;
				}
			}
		}
	}
	fclose(fp);	
}


VOID save_icon(BITBLK *pb)
{
/* I _could_ save this as BMP, but that would be smashing a tiny walnut with
 * a huge mallet. */
	WORD y;
	LPWORD data;

	FILE *fp = get_wfile(TRUE, path, "*.PBM", "wb");
	if (!fp) return;

	data = (LPWORD)(pb->bi_pdata);
	fwrite("P4 32 32 ", 1, 9, fp);
	for (y = 0; y < 32; y++)
	{
		fputc(data[y*2  ] >>   8, fp);
		fputc(data[y*2  ] & 0xFF, fp);
		fputc(data[y*2+1] >>   8, fp);
		fputc(data[y*2+1] & 0xFF, fp);
	}
	fclose(fp);
}



VOID set_sysicon(LPTREE tr, WORD o)
{
	LPTREE  tree;
	GRECT	or;
	WORD	xdial, ydial, wdial, hdial, exitobj, indial;
	WORD	xo;
	WORD	nc, n;

	clr_vdi_handle(vdi_handle);	
	indial  = 1;
	
	rsrc_gaddr(R_TREE, SYSICONS, (LPVOID *)&tree);
	pre_ublk[0].ub_code = paint_grid;
	pre_ublk[1].ub_code = paint_colour;
	ppd_userdef(tree, ICONEDIT, &pre_ublk[0]);
	ppd_userdef(tree, CHOICE8, &pre_ublk[1]);

	nc = rw_bitmaps(icon, icondata, sizeof(icon)/sizeof(BITBLK), 0);

	for (n = nc; n < (int)(sizeof(icon)/sizeof(BITBLK)); n++)
	{
		tree[ICON0 + n].ob_flags &= ~TOUCHEXIT;
		tree[ICON0 + n].ob_state |= DISABLED;
	}
	ob_xywh(tr, o, &or);
	sel_icon = 0;
	paint_col = 1;
	tree[ICON0].ob_state |= SELECTED;
	for (n = 1; n < (int)(sizeof(icon)/sizeof(BITBLK)); n++)
	{
		tree[ICON0 + n].ob_state &=~ SELECTED;
	}
	tree[CHOICE8].ob_state |= OUTLINED;
	
	form_center(tree, &xdial, &ydial, &wdial, &hdial);
	form_dial(0, or.g_x, or.g_y, or.g_w, or.g_h, xdial, ydial, wdial, hdial);
	form_dial(1, or.g_x, or.g_y, or.g_w, or.g_h, xdial, ydial, wdial, hdial);

	pre_ublk[1].ub_parm = icon[sel_icon].bi_color;
	objc_draw(tree, ROOT, MAX_DEPTH, xdial, ydial, wdial, hdial);

	while (indial)
	{
		exitobj = y_form_do(tree, 0, paint_col, &icon[sel_icon]) & 0x7FFF;

		switch(exitobj)
		{
			case ICON0:
			case ICON1:
			case ICON2:
				if ((exitobj - ICON0) >= nc) break;
				tree[ICON0 + sel_icon].ob_state &= ~SELECTED;
				sel_icon = exitobj - ICON0;
				tree[ICON0 + sel_icon].ob_state |= SELECTED;
				pre_ublk[1].ub_parm = icon[sel_icon].bi_color;
				objc_draw(tree, ICONLIST, 
						1, xdial, ydial, wdial, hdial);
				objc_draw(tree, ICONEDIT, 
						1, xdial, ydial, wdial, hdial);
				objc_draw(tree, ICONCOLS, 1, 
						xdial, ydial, wdial, hdial);
				break;
			case CHOICE8:
			case CHOICE9:
				paint_col = (exitobj == CHOICE8 ) ? 1 : 0;
				tree[CHOICE8 ].ob_state &= ~OUTLINED;
				tree[CHOICE9 ].ob_state &= ~OUTLINED;
				tree[exitobj ].ob_state |= OUTLINED;
				objc_draw(tree, ICONCOLS, 1, 
						xdial, ydial, wdial, hdial);
				break;


			case DROP8:	tree[ICONEDIT].ob_flags |= HIDETREE;
					xo = do_clrdrop(tree, exitobj);
					tree[ICONEDIT].ob_flags &= ~HIDETREE;
					if (xo >= 1)
					{
						pre_ublk[1].ub_parm = icon[sel_icon].bi_color = xo - 1;
					}	
					tree[exitobj].ob_state &= ~SELECTED;
					objc_draw(tree, exitobj, 1, xdial, ydial, wdial, hdial);
					objc_draw(tree, ICONCOLS, 1, xdial, ydial, wdial, hdial);
					objc_draw(tree, ICONEDIT, 1, xdial, ydial, wdial, hdial);
					break;
						
			case ICONHELP:
					rsrc_alert(1, HELPICON);
					tree[exitobj].ob_state &= ~SELECTED;
					objc_draw(tree, exitobj, 1, xdial, ydial, wdial, hdial);
					break;
		
			case ICONOKAY:
			case ICONCNCL:
					indial = 0;		
					tree[exitobj].ob_state &= ~SELECTED;
					break;
			case ICONEXP:	
					save_icon(&icon[sel_icon]);	
					tree[exitobj].ob_state &= ~SELECTED;
					objc_draw(tree, ROOT, MAX_DEPTH, xdial, ydial, wdial, hdial);
					break;
			case ICONIMP:
					load_icon(&icon[sel_icon]);
					tree[exitobj].ob_state &= ~SELECTED;
					objc_draw(tree, ROOT, MAX_DEPTH, xdial, ydial, wdial, hdial);
					break;
		} 
		
	}

	if (exitobj == ICONOKAY)
	{
		rw_bitmaps(icon, icondata, sizeof(icon)/sizeof(BITBLK), 1);
	}


	form_dial(2, or.g_x, or.g_y, or.g_w, or.g_h, xdial, ydial, wdial, hdial);
	form_dial(3, or.g_x, or.g_y, or.g_w, or.g_h, xdial, ydial, wdial, hdial);

	
}



