////////////////////////////////////////////////////////////////////////////////
//
//  Treeview Widget - Header File
//
//	(c) Copyright 2003,2004 Point Mad, Lukas Lipka. All rights reserved.
//
////////////////////////////////////////////////////////////////////////////////
#ifndef _TREEVIEW_H_INCLUDED_
#define _TREEVIEW_H_INCLUDED_

#include "scrollbar.h"
#include "menu.h"

typedef struct TTreeItem *PTreeItem;
typedef struct TTreeItem {

	l_text  Caption;
	l_char  Flags;
	p_bitmap Icon;
	TRect   BufAbs;

	void   *Args;
	void  (*GenerateSubs)(PTreeItem, void*);

	// void (*FreeArgs) ( void* );

	PTreeItem Last;
	PTreeItem Next;
	PTreeItem Prev;
	PTreeItem Parent;

} TTreeItem;

#define TIF_EXPENDED 0x01
#define TIF_SELECTED 0x02
#define TIF_FREEICON 0x04
#define TIF_FREEARGS 0x08

typedef struct TTreeView *PTreeView;
typedef struct TTreeView
{
	struct TScrollWidget o;

	PTreeItem Items;
	PTreeItem Sel;

	PMenu (*GenerateItemMenu) ( PTreeView, PTreeItem );

	l_ulong OnSelMsg;
	l_ulong OnMenuMsg;
	
} TTreeView;

#define TREEVIEW(o) ((PTreeView)(o))

PTreeView CreateTreeView( PApplication App, TRect r, l_ulong OnSelMsg );

void EmptySubTreeItems ( PTreeItem o );
PTreeItem AddTreeItem ( PTreeItem o, l_text Caption, p_bitmap Icon,void  (*GenerateSubs)(PTreeItem,void*), void*Args );

void TreeviewExpendItem ( PTreeView o, PTreeItem i ) ;
void TreeviewUnExpendItem ( PTreeView o, PTreeItem i );

l_text TreeViewRenameItemBox ( PTreeView t, PTreeItem i );
void TreeViewRenameItem ( PTreeView t, PTreeItem i, l_text Caption );
void TreeViewDeleteItem ( PTreeView o, PTreeItem i );

void TreeViewSelectItem ( PTreeView o, PTreeItem i );
void TreeviewScrollBarRecalculate( PTreeView o );

PTreeView InitTreeView( PTreeView b, PApplication App, TRect r, l_ulong OnSelMsg );
l_bool TreeViewEventHandler ( PWidget o, PEvent Ev );

#endif /* _TREEVIEW_H_INCLUDED_ */
