#ifndef _TYPES_H_INCLUDED_
#define _TYPES_H_INCLUDED_

#include "platform.h"

/**
*	Variable types
*/
typedef	long				l_long;
typedef	int					l_int;
#ifdef _OZONE__WIN32_
typedef	unsigned _int64		l_ubig;
#else
typedef	unsigned long long	l_ubig;
#endif
typedef	int					l_bool;
typedef	char				l_char;
typedef short				l_short;
typedef unsigned short		l_ushort;
typedef	unsigned char		l_byte,  l_uchar;
typedef	unsigned int		l_word,  l_uint;
typedef	unsigned long		l_dword, l_ulong;
typedef	char				l_tag[32];
typedef	long				l_rect;
typedef	int					l_color;
typedef	char*				l_text;
typedef	short*			l_utext;// Unicode text
typedef double			l_double;
typedef	void*				l_ptr;

typedef char        l_uid[13]; // Use only 12 first bytes. (13th byte must be '\0') (UTF-8)
  
#ifdef ALLEGRO_H
typedef	BITMAP*			p_bitmap;
#endif

typedef	l_int				t_message;
typedef	void*				t_pointer;
typedef	t_pointer			t_data;

/**
*	DMS specific (see dms.h)
*/
typedef  unsigned long		l_datatype;
typedef  void*				l_data;
typedef  unsigned long		l_dataencode;

#define TYPE_UNKNOW_BINARY 0
#define TYPE_TEXT          1
#define TYPE_UTEXT         2
#define TYPE_IMAGE         3
#define TYPE_ICON          4
#define TYPE_CURSOR        5
#define TYPE_LIST          6
#define TYPE_FILEREF       7
#define TYPE_FILEREFLIST 	 8


#ifndef LOWORD
#define LOWORD(w)	(((w)<<16)>>16)
#endif

#ifndef HIWORD
#define HIWORD(w)	((w)>>16)
#endif

#ifndef NULL
#define NULL ((void*)0)
#endif

#ifndef true
#define true 1
#endif

#ifndef false
#define false 0
#endif

#ifndef TRUE
#define TRUE true
#endif

#ifndef FALSE
#define FALSE false
#endif

#ifndef max
#define max(a,b) ((a)>(b)?(a):(b))
#endif

#ifndef min
#define min(a,b) ((a)<(b)?(a):(b))
#endif

#define ULONG_ID(a, b, c, d) ((a << 24) | (b << 16) | (c << 8) | d)

#define LONG_ID(d, c, b, a) ((a << 24) | (b << 16) | (c << 8) | d)


#define ULID_A(v) ((v & 0xFF000000) >> 24)
#define ULID_B(v) ((v & 0x00FF0000) >> 16)
#define ULID_C(v) ((v & 0x0000FF00) >> 8)
#define ULID_D(v) (v & 0x000000FF)

/**
*	Usefull MACRO tools
*/
#define CLEAR(o)        if (o) memset((o), 0, sizeof(*(o)))
#define NEW(o)          (o *) malloc(sizeof(o))
#define RGB(r,g,b)      makecol(r, g, b)
#define SET(s,o)        s |= (o)
#define UNSET(s,o)      s &=~(o)

#endif /* _TYPES_H_INCLUDED_ */
