#define KERNEL_FILE
#include "kernel.h"
#include "internal.h"
#include "zlib.h"

l_ubig __udivdi3(l_ubig x, l_ubig y);

int ____registered_allegro	= 0;
int ____registered_libc		= 0;

void RegisterAllegro();
void RegisterLibC();

void RegisterExports()
{
	RegisterAllegro();
	RegisterLibC();

	/**
	*	Kernel information
	*/
	SYSEXPORT(KernelName);
	SYSEXPORT(KernelCopyright);
	SYSEXPORT(KernelVersion);
	SYSEXPORT(KernelTextVersion);

	SYSEXPORT(StartRect);
	SYSEXPORT(StartLogo);

	SYSEXPORT(KeyboardSetLayout);
	SYSEXPORT(KeyboardGetLayout);
	SYSEXPORT(KeyboardInstallLayout);
	SYSEXPORT(__KeyboardStop);
	SYSEXPORT(__KeyboardRestart);

	/**
	*	VFS
	*/
	SYSEXPORT(ListDir);
	SYSEXPORT(FileOpen);
	SYSEXPORT(FileClose);
	SYSEXPORT(FileRead);
	SYSEXPORT(FileWrite);
	SYSEXPORT(FileSetPos);
	SYSEXPORT(FileSeek);
	SYSEXPORT(FileGetPos);
	SYSEXPORT(FileLength);
	SYSEXPORT(FileWriteBinString);
	SYSEXPORT(FileReadBinString);
	SYSEXPORT(FileWriteTextString);
	SYSEXPORT(FilePrintf);
	SYSEXPORT(file_read_char);
	SYSEXPORT(file_read_short);
	SYSEXPORT(file_read_long);
	SYSEXPORT(file_write_char);
	SYSEXPORT(file_write_short);
	SYSEXPORT(file_write_long);
	SYSEXPORT(file_get_char);
	SYSEXPORT(file_get_mlong);
	SYSEXPORT(ReadString);
	SYSEXPORT(WriteString);
	SYSEXPORT(FileNameToPath);
	SYSEXPORT(GetPathParent);
	SYSEXPORT(FileGetInfo);
	SYSEXPORT(FreeFileInfo);
	SYSEXPORT(FileSetAttributes);
	SYSEXPORT(AddFileInfoToList);
	SYSEXPORT(AddDrive);
	SYSEXPORT(FileOpen2);
	SYSEXPORT(FreeFileRef);
	SYSEXPORT(NewFileReference);
	SYSEXPORT(ListDir2);
	SYSEXPORT(_GenerateFileRefs);

	/**
	*	DynLD functions
	*/
	SYSEXPORT(DynLdRun);

	/**
	*	Debugging system
	*/
	SYSEXPORT(DebugMessage);
	SYSEXPORT(DebugWarning);
	SYSEXPORT(DebugError);
	SYSEXPORT(DebugFatal);
	SYSEXPORT(DebugCheckPtr);

	/**
	*	Fonts
	*/
	SYSEXPORT(FontLoad);
	SYSEXPORT(default_font);

	/**
	*	Metrics
	*/
	SYSEXPORT(PointAssign);
	SYSEXPORT(PointInRect);
	SYSEXPORT(RectAssign);
	SYSEXPORT(RectMove);
	SYSEXPORT(GetXDelta);
	SYSEXPORT(GetYDelta);
	SYSEXPORT(GetWidth);
	SYSEXPORT(GetHeight);
	//SYSEXPORT(SizeAssign);
	SYSEXPORT(RectOverlay);
	SYSEXPORT(RemoveZoneInList);
	SYSEXPORT(NewListFromRect);
	SYSEXPORT(RectIntersept);

	/**
	*	INI file support
	*/
	SYSEXPORT(INIGet);
	SYSEXPORT(INIGetInteger);
	SYSEXPORT(RegistryGetKey);
	SYSEXPORT(RegistryGetInteger);
	SYSEXPORT(RegistryGetColor);
	SYSEXPORT(INIGetText);
	SYSEXPORT(INIGetNew);
	SYSEXPORT(INIGetColor);

	/**
	*	Image support
	*/
	SYSEXPORT(LoadImage);
	SYSEXPORT(DestroyImage);

	/**
	*	Event system
	*/
	SYSEXPORT(EventGenerators);
	SYSEXPORT(EventHandlers);
	SYSEXPORT(InstallEventGenerator);
	SYSEXPORT(InstallEventHandler);
	SYSEXPORT(RemoveEventHandler);
	SYSEXPORT(EventAssign);
	SYSEXPORT(NewEvent);
	SYSEXPORT(GenerateEvent);
	SYSEXPORT(HandleEvent);
	SYSEXPORT(PollEvents);
	SYSEXPORT(KState);
	SYSEXPORT(KeyboardEventGenerator);

	/**
	*	Tasks support
	*/
	SYSEXPORT(InstallTask);
	SYSEXPORT(RemoveTask);
	//SYSEXPORT(TaskList);
	SYSEXPORT(PollTasks);

	/**
	*	Internal timer
	*/
	SYSEXPORT(TimersPoll);

	/**
	*	Mouse
	*/
	SYSEXPORT(cursor_pointer);
	SYSEXPORT(cursor_resize);
	SYSEXPORT(cursor_clock);
	SYSEXPORT(cursor_pencil);
	SYSEXPORT(_MouseRecap);
	SYSEXPORT(Mouse);
	SYSEXPORT(MouseShow);
	SYSEXPORT(MouseHide);
	SYSEXPORT(MouseSetCursor);
	SYSEXPORT(MouseSetCursorSpeed);
	SYSEXPORT(MouseSetDblClkSpeed);
	
	SYSEXPORT(__MouseStop);
	SYSEXPORT(__MouseRestart);

	/**
	*	ADT - List
	*/
	SYSEXPORT(KickList);

	SYSEXPORT(FreeList);
	SYSEXPORT(NewList);
	SYSEXPORT(ListAdd);
	SYSEXPORT(ListFoundItem);
	SYSEXPORT(ListRemoveItem);
	SYSEXPORT(ListAddItem);
	SYSEXPORT(ListKeyItem);

	SYSEXPORT(ListAt);
	SYSEXPORT(ListFoundIndex);
	SYSEXPORT(ListKey);
	SYSEXPORT(ListKeyCase);
	SYSEXPORT(NewListItemEx);
	SYSEXPORT(ListOrderByData);
	SYSEXPORT(ListKeyCaseItem);


	/**
	*	Screen Exports
	*/
	SYSEXPORT(GSScreenWidth);
	SYSEXPORT(GSScreenHeight);
	SYSEXPORT(GSScreenDepth);
	SYSEXPORT(GSScreenRefreshRate);
	SYSEXPORT(__ScreenRestartGraphics);
	SYSEXPORT(__ScreenTextMode);
	
	SYSEXPORTAS(Me,"SystemApp");
	SYSEXPORT(TimerSetPeriod);

	/**
	*	Text
	*/
	SYSEXPORT(CommonBufferText);

	SYSEXPORT(RectUnMove);
	SYSEXPORT(MakeDir);
	SYSEXPORT(FileEOF);
	SYSEXPORT(FileVPathName);
	SYSEXPORT(FileRename);
	SYSEXPORT(DirRename);

	SYSEXPORT(inflateReset);
	SYSEXPORT(inflate);
	SYSEXPORT(crc32);
	SYSEXPORT(inflateEnd);
	SYSEXPORT(inflateInit_);

	SYSEXPORT(deflateInit2_);
	SYSEXPORT(deflate);
	SYSEXPORT(deflateReset);
	SYSEXPORT(deflateEnd);

	/*
	#ifdef LWP_THREAD
		SYSEXPORTAS(lwp_yield, "Yield");
		SYSEXPORTAS(lwp_spawn, "NewThread");
		SYSEXPORTAS(lwp_kill, "KillThread");
		SYSEXPORTAS(lwp_getpid, "ThreadId");
		SYSEXPORTAS(lwp_thread_enable, "UnPauseMultitasking");
		SYSEXPORTAS(lwp_thread_disable, "PauseMultitasking");
	#else
		SYSEXPORT(Yield);
		SYSEXPORT(NewThread);
		SYSEXPORT(KillThread);
		SYSEXPORT(ThreadId);
		SYSEXPORT(UnPauseMultitasking);
		SYSEXPORT(PauseMultitasking);
	#endif
	*/
}

#include <allegro/internal/aintern.h>

void RegisterAllegro()
{
	if (!____registered_allegro)
	{
		____registered_allegro = 1;

		SYSEXPORT(allegro_404_char);
		SYSEXPORT(getr);
		SYSEXPORT(getg);
		SYSEXPORT(getb);
		SYSEXPORT(screen);
		SYSEXPORT(rectfill);
		SYSEXPORT(line);
		SYSEXPORT(rect);
		SYSEXPORT(font);
		SYSEXPORT(draw_sprite);
		SYSEXPORT(draw_trans_sprite);
		SYSEXPORT(create_bitmap);
		SYSEXPORT(create_bitmap_ex);
		SYSEXPORT(triangle);
		SYSEXPORT(hline);
		SYSEXPORT(vline);
		SYSEXPORT(putpixel);
		SYSEXPORT(floodfill);
		SYSEXPORT(text_height);
		SYSEXPORT(circle);
		SYSEXPORT(set_clip);
		SYSEXPORT(destroy_bitmap);
		SYSEXPORT(stretch_sprite);
		SYSEXPORT(textout);
		SYSEXPORT(textout_centre);
		SYSEXPORT(textout_justify);
		SYSEXPORT(textout_right);
		SYSEXPORT(text_length);
		SYSEXPORT(getpixel);
		SYSEXPORT(ellipse);
		SYSEXPORT(makecol);
		SYSEXPORT(clear_bitmap);
		SYSEXPORT(clear_to_color);
		SYSEXPORT(clear);
		SYSEXPORT(blit);
		SYSEXPORT(masked_blit);
		SYSEXPORT(stretch_blit);
		SYSEXPORT(masked_stretch_blit);
		SYSEXPORT(bitmap_color_depth);
		SYSEXPORT(set_mouse_range);
		SYSEXPORT(mouse_x);
		SYSEXPORT(mouse_x_focus);
		SYSEXPORT(mouse_y);
		SYSEXPORT(mouse_y_focus);
		SYSEXPORT(mouse_sprite);
		SYSEXPORT(create_system_bitmap);
		SYSEXPORT(xor_mode);
		SYSEXPORT(_fixup_loaded_bitmap);
		SYSEXPORT(_color_load_depth);
		SYSEXPORT(generate_332_palette);
		SYSEXPORT(get_palette);
		SYSEXPORT(getb_depth);
		SYSEXPORT(getg_depth);
		SYSEXPORT(getr_depth);
		SYSEXPORT(allegro_errno);
		SYSEXPORT(_rgb_scale_6);
		SYSEXPORT(_rgb_r_shift_24);
		SYSEXPORT(_rgb_g_shift_24);
		SYSEXPORT(_rgb_b_shift_24);
		SYSEXPORT(set_trans_blender);
		SYSEXPORT(textprintf);
		SYSEXPORT(set_mouse_speed);
		SYSEXPORT(drawing_mode);
		SYSEXPORT(solid_mode);
		SYSEXPORT(circlefill);
		SYSEXPORT(_key_ascii_table);
		SYSEXPORT(_key_capslock_table);
		SYSEXPORT(_key_shift_table);
		SYSEXPORT(_key_control_table);
		SYSEXPORT(_key_altgr_lower_table);
		SYSEXPORT(_key_altgr_upper_table);
		SYSEXPORT(_key_accent1_lower_table);
		SYSEXPORT(_key_accent1_upper_table);
		SYSEXPORT(_key_accent2_lower_table);
		SYSEXPORT(_key_accent2_upper_table);
		SYSEXPORT(_key_accent3_lower_table);
		SYSEXPORT(_key_accent3_upper_table);
		SYSEXPORT(_key_accent4_lower_table);
		SYSEXPORT(_key_accent4_upper_table);
		SYSEXPORT(_key_accent1);
		SYSEXPORT(_key_accent2);
		SYSEXPORT(_key_accent3);
		SYSEXPORT(_key_accent4);
		SYSEXPORT(_key_accent1_flag);
		SYSEXPORT(_key_accent2_flag);
		SYSEXPORT(_key_accent3_flag);
		SYSEXPORT(_key_accent4_flag);
		SYSEXPORT(_key_standard_kb);
		SYSEXPORT(get_config_int);
		SYSEXPORT(uconvert);
		SYSEXPORT(uszprintf);
		SYSEXPORT(set_config_data);
		SYSEXPORT(get_config_string);
		SYSEXPORT(_rgb_r_shift_32);
		SYSEXPORT(_rgb_g_shift_32);
		SYSEXPORT(_rgb_b_shift_32);
		SYSEXPORT(_rgb_a_shift_32);
		SYSEXPORT(_rgb_r_shift_16);
		SYSEXPORT(_rgb_g_shift_16);
		SYSEXPORT(_rgb_b_shift_16);
		SYSEXPORT(_rgb_r_shift_15);
		SYSEXPORT(_rgb_g_shift_15);
		SYSEXPORT(_rgb_b_shift_15);
		SYSEXPORT(_rgb_scale_5);
	}
}

/**
 * Linux LIBC
 */
#ifdef _OZONE__LINUX_
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <setjmp.h>
void RegisterLibC()
{
	SYSEXPORT(free);
	SYSEXPORT(malloc);
	SYSEXPORT(realloc);
	SYSEXPORT(strcmp);
	SYSEXPORT(stricmp);
	SYSEXPORT(strcat);
	SYSEXPORT(strlen);
	SYSEXPORT(strdup);
	SYSEXPORT(strcpy);
	SYSEXPORT(fopen);
	SYSEXPORT(fclose);
	SYSEXPORT(fseek);
	SYSEXPORT(fwrite);
	SYSEXPORT(fprintf);
	SYSEXPORT(fgets);
	SYSEXPORT(feof);
	SYSEXPORT(fread);
	SYSEXPORT(fsetpos);
	SYSEXPORT(fgetpos);
	SYSEXPORT(sprintf);
	SYSEXPORT(vsprintf);
	SYSEXPORT(ctime);
	SYSEXPORT(atof);
	SYSEXPORT(atoi);
	SYSEXPORT(sin);
	SYSEXPORT(cos);
	SYSEXPORT(rand);
	SYSEXPORT(srand);
	SYSEXPORT(memcpy);
	SYSEXPORTAS(rand,"random");
	SYSEXPORT(time);
	SYSEXPORT(localtime);
	SYSEXPORT(pow);
	SYSEXPORT(memset);
	SYSEXPORT(setjmp);
	SYSEXPORT(longjmp);
	SYSEXPORT(strtod);
	SYSEXPORT(abort);
	SYSEXPORT(gmtime);
	SYSEXPORT(fflush);

	SYSEXPORTAS(*stderr,"__dj_stderr");
}
#endif

#ifdef _OZONE__WIN32_
#include<math.h>
#include<stdlib.h>
#include<time.h>
#include <setjmp.h>
void RegisterLibC()
{
	SYSEXPORT(time);
	SYSEXPORT(free);
	SYSEXPORT(malloc);
	SYSEXPORT(realloc);
	SYSEXPORT(strcmp);
	SYSEXPORT(stricmp);
	SYSEXPORT(strcat);
	SYSEXPORT(strlen);
	SYSEXPORT(strdup);
	SYSEXPORT(strcpy);
	SYSEXPORT(fopen);
	SYSEXPORT(fclose);
	SYSEXPORT(fseek);
	SYSEXPORT(fwrite);
	SYSEXPORT(fprintf);
	SYSEXPORT(fgets);
	SYSEXPORT(feof);
	SYSEXPORT(fread);
	SYSEXPORT(fsetpos);
	SYSEXPORT(fgetpos);
	SYSEXPORT(sprintf);
	SYSEXPORT(vsprintf);
	SYSEXPORT(ctime);
	SYSEXPORT(atof);
	SYSEXPORT(atoi);
	SYSEXPORT(atol);
	SYSEXPORT(strtod);
	SYSEXPORT(strtol);
	SYSEXPORT(sin);
	SYSEXPORT(cos);
	SYSEXPORT(rand);
	SYSEXPORTAS(rand,"random");
	SYSEXPORT(srand);
	SYSEXPORT(memcpy);
	SYSEXPORT(pow);
	SYSEXPORT(memset);
	SYSEXPORT(setjmp);
	SYSEXPORT(longjmp);
	SYSEXPORT(localtime);
	SYSEXPORT(abort);
	SYSEXPORT(gmtime);
	SYSEXPORT(fflush);
	SYSEXPORT(getchar);
	SYSEXPORT(system);
	SYSEXPORT(puts);
	SYSEXPORT(printf);
	SYSEXPORTAS(*stderr, "__dj_stderr");
}
#endif

#ifdef _OZONE__DJGPP_

#include <setjmp.h>
#include <io.h>
#include <bios.h>
#include <fcntl.h>
#include <dos.h>
#include <stdio.h>
#include <signal.h>
#include <sys/stat.h>
#include <mem.h>
#include <math.h>
#include <string.h>
#include <process.h>
#include <float.h>
#include <dpmi.h>
#include <sys/fsext.h>
#include <errno.h>
#include <crt0.h>
#include <unistd.h>
#include <sys/dxe.h>
#include <go32.h>
#include <sys/timeb.h>
#include <sys/time.h>
#include <time.h>
#include <stdlib.h>
#include <conio.h>
#include <sys/wait.h>
#include <sys/utsname.h>
#include <ctype.h>
#include <dirent.h>
#include <termios.h>
#include <sys/vfs.h>
#include <signal.h>
#include <sys/resource.h>
#include <locale.h>
#include <grp.h>
#include <dir.h>
#include <search.h>
#include <sys/types.h>
#include <regex.h>
#include <signal.h>
#include <sys/mono.h>
#include <utime.h>
#include <sys/times.h>
#include <string.h>
#include <pwd.h>
#include <mntent.h>
#include <pc.h>
#include <netinet/in.h>
#include <sys/mman.h>
#include <sys/movedata.h>
#include <libc/ttyprvt.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <glob.h>
#include <ftw.h>
#include <fnmatch.h>
#include <sys/farptr.h>
#include <sys/nearptr.h>
#include <assert.h>
#include <sys/exceptn.h>

int ____registered = 0;

void RegisterLibC()
{
  if (!____registered)
  {
	____registered = 1;

	SYSEXPORT(srand);
	SYSEXPORT(setjmp);
	SYSEXPORT(longjmp);
	SYSEXPORT(__dpmi_allocate_memory);
	SYSEXPORT(rewinddir);
	SYSEXPORT(__dpmi_clear_debug_watchpoint);
	SYSEXPORT(__exit);
	SYSEXPORT(__dpmi_unlock_linear_region);
	SYSEXPORT(__dj_assert);
	SYSEXPORT(insque);
	SYSEXPORT(mblen);
	SYSEXPORT(__dpmi_get_and_disable_virtual_interrupt_state);
	SYSEXPORT(usleep);
	SYSEXPORT(intensevideo);
	SYSEXPORT(__dpmi_set_multiple_descriptors);
	SYSEXPORT(getpid);
	SYSEXPORT(putchar);
	SYSEXPORT(getgid);
	SYSEXPORT(execl);
	SYSEXPORT(__dpmi_lock_linear_region);
	SYSEXPORT(statfs);
	SYSEXPORT(bioskey);
	SYSEXPORT(symlink);
	SYSEXPORT(outpw);
	SYSEXPORT(strcspn);
	SYSEXPORT(sprintf);
	SYSEXPORT(_dos_gettime);
	SYSEXPORT(textattr);
	SYSEXPORT(__dpmi_set_real_mode_interrupt_vector);
	SYSEXPORT(feof);
	SYSEXPORT(blinkvideo);
	SYSEXPORT(getche);
	SYSEXPORT(_exit);
	SYSEXPORT(__crt0_setup_arguments);
	SYSEXPORT(setcbrk);
	SYSEXPORT(utime);
	SYSEXPORT(_truename);
	SYSEXPORT(getgrent);
	SYSEXPORT(__djgpp_memory_handle);
	SYSEXPORT(tcgetattr);
	SYSEXPORT(free);
	SYSEXPORT(strcat);
	SYSEXPORT(dup);
	SYSEXPORT(gettext);
	SYSEXPORT(strcmp);
	SYSEXPORT(cgets);
	SYSEXPORT(getpass);
	SYSEXPORT(memccpy);
	SYSEXPORT(__dpmi_install_resident_service_provider_callback);
	SYSEXPORT(__dpmi_simulate_real_mode_procedure_retf_stack);
	SYSEXPORT(ScreenUpdate);
	SYSEXPORT(regfree);
	SYSEXPORT(pause);
	SYSEXPORT(getpgrp);
	SYSEXPORT(spawnlp);
	SYSEXPORT(globfree);
	SYSEXPORT(execlp);
	SYSEXPORT(__dpmi_allocate_real_mode_callback);
	SYSEXPORT(lock);
	SYSEXPORT(nice);
	SYSEXPORT(acosh);
	SYSEXPORT(mkdir);
	SYSEXPORT(sleep);
	SYSEXPORT(__dpmi_get_memory_information);
	SYSEXPORT(__djgpp_exception_toggle);
	SYSEXPORT(searchpath);
	SYSEXPORT(mkstemp);
	SYSEXPORT(_go32_dpmi_get_protected_mode_interrupt_vector);
	SYSEXPORT(__djgpp_nearptr_enable);
	SYSEXPORT(vsprintf);
	SYSEXPORT(__dpmi_get_virtual_interrupt_state);
	SYSEXPORT(_go32_info_block);
	SYSEXPORT(log10);
	SYSEXPORT(settime);
	SYSEXPORT(ScreenClear);
	SYSEXPORT(pow10);
	SYSEXPORT(_bios_disk);
	SYSEXPORT(telldir);
	SYSEXPORT(__dpmi_get_vendor_specific_api_entry_point);
	SYSEXPORT(fgetpos);
	SYSEXPORT(glob);
	SYSEXPORT(vprintf);
	SYSEXPORT(__dpmi_get_page_size);
	SYSEXPORT(setlinebuf);
	SYSEXPORT(_dos_lock);
	SYSEXPORT(_write);
	SYSEXPORT(rand);
	SYSEXPORT(__dpmi_serialize_on_shared_memory);
	SYSEXPORT(modf);
	SYSEXPORT(ceil);
	SYSEXPORT(putc);
	SYSEXPORT(clock);
	SYSEXPORT(_bios_timeofday);
	SYSEXPORT(strupr);
	SYSEXPORT(ScreenGetCursor);
	SYSEXPORT(wctomb);
	SYSEXPORT(__dpmi_set_debug_watchpoint);
	SYSEXPORT(__libc_termios_init);
	SYSEXPORT(getc);
	SYSEXPORT(bsearch);
	SYSEXPORT(_djstat_describe_lossage);
	SYSEXPORT(insline);
	SYSEXPORT(ungetc);
	SYSEXPORT(getw);
	SYSEXPORT(putch);
	SYSEXPORT(closedir);
	SYSEXPORT(ScreenRetrieve);
	SYSEXPORT(rewind);
	SYSEXPORT(_dosmemputl);
	SYSEXPORT(_go32_dpmi_allocate_real_mode_callback_retf);
	SYSEXPORT(getlogin);
	SYSEXPORT(biosdisk);
	SYSEXPORT(sysconf);
	SYSEXPORT(_read);
	SYSEXPORT(spawnle);
	SYSEXPORT(_movedataw);
	SYSEXPORT(__dj_stdin);
	SYSEXPORT(setvbuf);
	SYSEXPORT(biosequip);
	SYSEXPORT(ScreenPutString);
	SYSEXPORT(setbuf);
	SYSEXPORT(abs);
	SYSEXPORT(puts);
	SYSEXPORT(_go32_dpmi_remaining_virtual_memory);
	SYSEXPORT(getftime);
	SYSEXPORT(_status87);
	SYSEXPORT(__dpmi_terminate_and_stay_resident);
	SYSEXPORT(strtoull);
	SYSEXPORT(_dos_findnext);
	SYSEXPORT(_dos_setfileattr);
	SYSEXPORT(findfirst);
	SYSEXPORT(setdisk);
	SYSEXPORT(execv);
	SYSEXPORT(select);
	SYSEXPORT(ftime);
	SYSEXPORT(int86);
	SYSEXPORT(__dpmi_relock_real_mode_region);
	SYSEXPORT(rmdir);
	SYSEXPORT(_dos_settime);
	SYSEXPORT(strncat);
	SYSEXPORT(getpagesize);
	SYSEXPORT(_open);
	SYSEXPORT(putenv);
	SYSEXPORT(__dpmi_set_segment_limit);
	SYSEXPORT(strlwr);
	SYSEXPORT(tcsetattr);
	SYSEXPORT(fstat);
	SYSEXPORT(spawnl);
	SYSEXPORT(atanh);
	SYSEXPORT(clreol);
	SYSEXPORT(readdir);
	SYSEXPORT(spawnve);
	SYSEXPORT(fputc);
	SYSEXPORT(regcomp);
	SYSEXPORT(execvp);
	SYSEXPORT(setrlimit);
	SYSEXPORT(chsize);
	SYSEXPORT(__dpmi_yield);
	SYSEXPORT(__dpmi_free_shared_memory);
	SYSEXPORT(cfgetospeed);
	SYSEXPORT(__dpmi_set_extended_exception_handler_vector_rm);
	SYSEXPORT(_fpreset);
	SYSEXPORT(scanf);
	SYSEXPORT(__dpmi_simulate_real_mode_interrupt);
	SYSEXPORT(addmntent);
	SYSEXPORT(getwd);
	SYSEXPORT(__dpmi_allocate_linear_memory);
	SYSEXPORT(gethostname);
	SYSEXPORT(_set_screen_lines);
	SYSEXPORT(fnsplit);
	SYSEXPORT(mktime);
	SYSEXPORT(cputs);
	SYSEXPORT(__dpmi_set_descriptor_access_rights);
	SYSEXPORT(getegid);
	SYSEXPORT(getrusage);
	SYSEXPORT(random);
	SYSEXPORT(fputs);
	SYSEXPORT(setdate);
	SYSEXPORT(ftw);
	SYSEXPORT(rindex);
	SYSEXPORT(_dos_close);
	SYSEXPORT(atof);
	SYSEXPORT(ferror);
	SYSEXPORT(_go32_dpmi_free_real_mode_callback);
	SYSEXPORT(_osmajor);
	SYSEXPORT(isatty);
	SYSEXPORT(sinh);
	SYSEXPORT(movetext);
	SYSEXPORT(strcoll);
	SYSEXPORT(fdopen);
	SYSEXPORT(movedata);
	SYSEXPORT(__dpmi_allocate_dos_memory);
	SYSEXPORT(inportsb);
	SYSEXPORT(open);
	SYSEXPORT(__dpmi_map_conventional_memory_in_memory_block);
	SYSEXPORT(_doprnt);
	SYSEXPORT(sbrk);
	SYSEXPORT(ftruncate);
	SYSEXPORT(_atold);
	SYSEXPORT(_dos_read);
	SYSEXPORT(__dpmi_free_memory);
	SYSEXPORT(__dpmi_set_extended_exception_handler_vector_pm);
	SYSEXPORT(_go32_dpmi_allocate_real_mode_callback_iret);
	SYSEXPORT(mknod);
	SYSEXPORT(fwrite);
	SYSEXPORT(gets);
	SYSEXPORT(fnmatch);
	SYSEXPORT(strncpy);
	SYSEXPORT(outp);
	SYSEXPORT(window);
	SYSEXPORT(__file_tree_walk);
	SYSEXPORT(hasmntopt);
	SYSEXPORT(sys_nerr);
	SYSEXPORT(times);
	SYSEXPORT(endgrent);
	SYSEXPORT(_lfn_get_ftime);
	SYSEXPORT(_dosmemgetb);
	SYSEXPORT(atoi);
	SYSEXPORT(bdos);
	SYSEXPORT(wcstombs);
	SYSEXPORT(getkey);
	SYSEXPORT(rawclock);
	SYSEXPORT(__dpmi_physical_address_mapping);
	SYSEXPORT(biosprint);
	SYSEXPORT(_chmod);
	SYSEXPORT(ttyname);
	SYSEXPORT(regexec);
	SYSEXPORT(_mono_putc);
	SYSEXPORT(_dos_creatnew);
	SYSEXPORT(__dpmi_get_real_mode_interrupt_vector);
	SYSEXPORT(memcpy);
	SYSEXPORT(__dpmi_get_free_memory_information);
	SYSEXPORT(opendir);
	SYSEXPORT(_dos_open);
	SYSEXPORT(execvpe);
	SYSEXPORT(_go32_dpmi_set_real_mode_interrupt_vector);
	SYSEXPORT(getgrgid);
	SYSEXPORT(_go32_interrupt_stack_size);
	SYSEXPORT(popen);
	SYSEXPORT(memset);
	SYSEXPORT(setlocale);
	SYSEXPORT(_go32_dpmi_lock_code);
	SYSEXPORT(settimeofday);
	SYSEXPORT(dosmemget);
	SYSEXPORT(stat);
	SYSEXPORT(_dosmemputw);
	SYSEXPORT(fileno);
	SYSEXPORT(ScreenSetCursor);
	SYSEXPORT(__dpmi_int);
	SYSEXPORT(puttext);
	SYSEXPORT(__dj_ctype_toupper);
	SYSEXPORT(__dpmi_get_raw_mode_switch_addr);
	SYSEXPORT(mprotect);
	SYSEXPORT(_go32_was_ctrl_break_hit);
	SYSEXPORT(bcmp);
	SYSEXPORT(waitpid);
	SYSEXPORT(strerror);
	SYSEXPORT(mkfifo);
	SYSEXPORT(_go32_dpmi_resize_dos_memory);
	SYSEXPORT(outportsw);
	SYSEXPORT(__dpmi_get_descriptor_access_rights);
	SYSEXPORT(remove);
	SYSEXPORT(setpgid);
	SYSEXPORT(_dosexterr);
	SYSEXPORT(chdir);
	SYSEXPORT(getlongpass);
	SYSEXPORT(_control87);
	SYSEXPORT(cfgetispeed);
	SYSEXPORT(mbstowcs);
	SYSEXPORT(ScreenUpdateLine);
	SYSEXPORT(getuid);
	SYSEXPORT(fflush);
	SYSEXPORT(clearerr);
	SYSEXPORT(dosmemput);
	SYSEXPORT(_djstat_flags);
	SYSEXPORT(itoa);
	SYSEXPORT(fpurge);
	SYSEXPORT(__dpmi_get_extended_exception_handler_vector_pm);
	SYSEXPORT(ldiv);
	SYSEXPORT(__dpmi_set_protected_mode_interrupt_vector);
	SYSEXPORT(_strtold);
	SYSEXPORT(asinh);
	SYSEXPORT(strxfrm);
	SYSEXPORT(_dos_setdrive);
	SYSEXPORT(fprintf);
	SYSEXPORT(setitimer);
	SYSEXPORT(llabs);
	SYSEXPORT(wait);
	SYSEXPORT(gettextinfo);
	SYSEXPORT(__dpmi_set_processor_exception_handler_vector);
	SYSEXPORT(_mono_printf);
	SYSEXPORT(lseek);
	SYSEXPORT(delline);
	SYSEXPORT(inportsw);
	SYSEXPORT(strtol);
	SYSEXPORT(getdate);
	SYSEXPORT(getitimer);
	SYSEXPORT(_get_volume_info);
	SYSEXPORT(_clear87);
	SYSEXPORT(log2);
	SYSEXPORT(strdup);
	SYSEXPORT(normvideo);
	SYSEXPORT(setpwent);
	SYSEXPORT(tell);
	SYSEXPORT(__FSEXT_alloc_fd);
	SYSEXPORT(_go32_dpmi_free_iret_wrapper);
	SYSEXPORT(setbuffer);
	SYSEXPORT(strcasecmp);
	SYSEXPORT(outportsb);
	SYSEXPORT(execle);
	SYSEXPORT(fread);
	SYSEXPORT(__dpmi_get_state_of_debug_watchpoint);
	SYSEXPORT(_creat);
	SYSEXPORT(gmtime);
	SYSEXPORT(_dos_getdiskfree);
	SYSEXPORT(getgrnam);
	SYSEXPORT(gppconio_init);
	SYSEXPORT(pow2);
	SYSEXPORT(swab);
	SYSEXPORT(fopen);
	SYSEXPORT(setmode);
	SYSEXPORT(_go32_dpmi_chain_protected_mode_interrupt_vector);
	SYSEXPORT(__dpmi_free_real_mode_callback);
	SYSEXPORT(_dosmemgetl);
	SYSEXPORT(calloc);
	SYSEXPORT(time);
	SYSEXPORT(_fmode);
	SYSEXPORT(__dpmi_get_memory_block_size_and_base);
	SYSEXPORT(getrlimit);
	SYSEXPORT(__dpmi_resize_memory);
	SYSEXPORT(cfsetspeed);
	SYSEXPORT(__dpmi_get_multiple_descriptors);
	SYSEXPORT(ScreenAttrib);
	SYSEXPORT(_go32_rmcb_stack_size);
	SYSEXPORT(strpbrk);
	SYSEXPORT(textbackground);
	SYSEXPORT(getchar);
	SYSEXPORT(__dpmi_set_descriptor);
	SYSEXPORT(ctime);
	SYSEXPORT(stpcpy);
	SYSEXPORT(ScreenPutChar);
	SYSEXPORT(dup2);
	SYSEXPORT(strftime);
	SYSEXPORT(brk);
	SYSEXPORT(hypot);
	SYSEXPORT(outportsl);
	SYSEXPORT(__dpmi_free_serialization_on_shared_memory);
	SYSEXPORT(setmntent);
	SYSEXPORT(_go32_dpmi_get_real_mode_interrupt_vector);
	SYSEXPORT(__dpmi_get_selector_increment_value);
	SYSEXPORT(bcopy);
	SYSEXPORT(getpwnam);
	SYSEXPORT(_dos_setftime);
	SYSEXPORT(cfree);
	SYSEXPORT(tmpnam);
	SYSEXPORT(__dj_stdout);
	SYSEXPORT(realloc);
	SYSEXPORT(getch);
	SYSEXPORT(_go32_dpmi_remaining_physical_memory);
	SYSEXPORT(memchr);
	SYSEXPORT(link);
	SYSEXPORT(sys_errlist);
	SYSEXPORT(tcsendbreak);
	SYSEXPORT(__dpmi_get_segment_base_address);
	SYSEXPORT(__dpmi_get_coprocessor_status);
	SYSEXPORT(fnmerge);
	SYSEXPORT(setgrent);
	SYSEXPORT(getenv);
	SYSEXPORT(_movedatal);
	SYSEXPORT(strncasecmp);
	SYSEXPORT(labs);
	SYSEXPORT(chown);
	SYSEXPORT(access);
	SYSEXPORT(_use_lfn);
	SYSEXPORT(filelength);
	SYSEXPORT(textcolor);
	SYSEXPORT(_dos_findfirst);
	SYSEXPORT(uname);
	SYSEXPORT(creat);
	SYSEXPORT(bioscom);
	SYSEXPORT(__dpmi_simulate_real_mode_procedure_iret);
	SYSEXPORT(__dpmi_get_descriptor);
	SYSEXPORT(spawnv);
	SYSEXPORT(__dpmi_get_capabilities);
	SYSEXPORT(_setcursortype);
	SYSEXPORT(strtod);
	SYSEXPORT(cfmakeraw);
	SYSEXPORT(inpw);
	SYSEXPORT(alarm);
	SYSEXPORT(__djgpp_set_ctrl_c);
	SYSEXPORT(rename);
	SYSEXPORT(__FSEXT_call_open_handlers);
	SYSEXPORT(strchr);
	SYSEXPORT(fsync);
	SYSEXPORT(log);
	SYSEXPORT(uclock);
	SYSEXPORT(__FSEXT_get_function);
	SYSEXPORT(__dpmi_create_alias_descriptor);
	SYSEXPORT(__djgpp_set_page_attributes);
	SYSEXPORT(fgetc);
	SYSEXPORT(__dpmi_segment_to_descriptor);
	SYSEXPORT(cfsetispeed);
	SYSEXPORT(_preserve_fncase);
	SYSEXPORT(signal);
	SYSEXPORT(__dpmi_get_version);
	SYSEXPORT(tcdrain);
	SYSEXPORT(malloc);
	SYSEXPORT(_os_flavor);
	SYSEXPORT(fclose);
	SYSEXPORT(pipe);
	SYSEXPORT(strcpy);
	SYSEXPORT(_go32_want_ctrl_break);
	SYSEXPORT(sscanf);
	SYSEXPORT(cprintf);
	SYSEXPORT(fseek);
	SYSEXPORT(__djgpp_map_physical_memory);
	SYSEXPORT(biosmemory);
	SYSEXPORT(execve);
	SYSEXPORT(memcmp);
	SYSEXPORT(_dos_getdrive);
	SYSEXPORT(_dos_getftime);
	SYSEXPORT(__dpmi_mark_real_mode_region_as_pageable);
	SYSEXPORT(getmntent);
	SYSEXPORT(__dpmi_allocate_ldt_descriptors);
	SYSEXPORT(strspn);
	SYSEXPORT(atexit);
	SYSEXPORT(__dpmi_get_and_set_virtual_interrupt_state);
	SYSEXPORT(chmod);
	SYSEXPORT(_dos_commit);
	SYSEXPORT(perror);
	SYSEXPORT(fpathconf);
	SYSEXPORT(__dpmi_mark_page_as_demand_paging_candidate);
	SYSEXPORT(strtok);
	SYSEXPORT(_get_dev_info);
	SYSEXPORT(_dos_unlock);
	SYSEXPORT(localtime);
	SYSEXPORT(__dpmi_set_segment_base_address);
	SYSEXPORT(execlpe);
	SYSEXPORT(_go32_dpmi_set_protected_mode_interrupt_vector);
	SYSEXPORT(abort);
	SYSEXPORT(_doscan);
	SYSEXPORT(tmpfile);
	SYSEXPORT(__djgpp_memory_handle_list);
	SYSEXPORT(_dos_setdate);
	SYSEXPORT(fgetgrent);
	SYSEXPORT(ScreenCols);
	SYSEXPORT(endmntent);
	SYSEXPORT(modfl);
	SYSEXPORT(asctime);
	SYSEXPORT(wherey);
	SYSEXPORT(_osminor);
	SYSEXPORT(_is_executable);
	SYSEXPORT(__djgpp_nearptr_disable);
	SYSEXPORT(__dj_ctype_flags);
	SYSEXPORT(unlink);
	SYSEXPORT(cscanf);
	SYSEXPORT(lldiv);
	SYSEXPORT(_dos_write);
	SYSEXPORT(_dosmemgetw);
	SYSEXPORT(strtoll);
	SYSEXPORT(fork);
	SYSEXPORT(ScreenGetChar);
	SYSEXPORT(__dpmi_resize_dos_memory);
	SYSEXPORT(tanh);
	SYSEXPORT(pow);
	SYSEXPORT(__dpmi_reset_debug_watchpoint);
	SYSEXPORT(truncate);
	SYSEXPORT(__dpmi_get_protected_mode_interrupt_vector);
	SYSEXPORT(localeconv);
	SYSEXPORT(_dos_getdate);
	SYSEXPORT(ScreenMode);
	SYSEXPORT(__FSEXT_add_open_handler);
	SYSEXPORT(_movedatab);
	SYSEXPORT(sound);
	SYSEXPORT(endpwent);
	SYSEXPORT(getcwd);
	SYSEXPORT(wherex);
	SYSEXPORT(mbtowc);
	SYSEXPORT(strncmp);
	SYSEXPORT(ftell);
	SYSEXPORT(_flush_disk_cache);
	SYSEXPORT(_close);
	SYSEXPORT(gettime);
	SYSEXPORT(write);
	SYSEXPORT(strnicmp);
	SYSEXPORT(utimes);
	SYSEXPORT(__dpmi_free_dos_memory);
	SYSEXPORT(__dpmi_set_page_attributes);
	SYSEXPORT(__dj_ctype_tolower);
	SYSEXPORT(__dpmi_free_physical_address_mapping);
	SYSEXPORT(sync);
	SYSEXPORT(__dpmi_allocate_shared_memory);
	SYSEXPORT(__dpmi_get_and_enable_virtual_interrupt_state);
	SYSEXPORT(ScreenRows);
	SYSEXPORT(highvideo);
	SYSEXPORT(strrchr);
	SYSEXPORT(inportsl);
	SYSEXPORT(_dos_creat);
	SYSEXPORT(getdfree);
	SYSEXPORT(_fixpath);
	SYSEXPORT(strtoul);
	SYSEXPORT(pclose);
	SYSEXPORT(stricmp);
	SYSEXPORT(_mono_clear);
	SYSEXPORT(_go32_dpmi_allocate_dos_memory);
	SYSEXPORT(__dpmi_set_coprocessor_emulation);
	SYSEXPORT(siglongjmp);
	SYSEXPORT(__dpmi_resize_linear_memory);
	SYSEXPORT(srandom);
	SYSEXPORT(remque);
	SYSEXPORT(spawnvp);
	SYSEXPORT(difftime);
	SYSEXPORT(atol);
	SYSEXPORT(getxkey);
	SYSEXPORT(int86x);
	SYSEXPORT(__dpmi_get_state_save_restore_addr);
	SYSEXPORT(fgets);
	SYSEXPORT(div);
	SYSEXPORT(kill);
	SYSEXPORT(lowvideo);
	SYSEXPORT(strsep);
	SYSEXPORT(__dpmi_free_ldt_descriptor);
	SYSEXPORT(strlen);
	SYSEXPORT(spawnvpe);
	SYSEXPORT(errno);
	SYSEXPORT(gettimeofday);
	SYSEXPORT(disable);
	SYSEXPORT(__dpmi_map_device_in_memory_block);
	SYSEXPORT(read);
	SYSEXPORT(getcbrk);
	SYSEXPORT(memmove);
	SYSEXPORT(getdisk);
	SYSEXPORT(_crt0_startup_flags);
	SYSEXPORT(ffs);
	SYSEXPORT(__file_exists);
	SYSEXPORT(tcflow);
	SYSEXPORT(setftime);
	SYSEXPORT(exit);
	SYSEXPORT(tcflush);
	SYSEXPORT(findnext);
	SYSEXPORT(gotoxy);
	SYSEXPORT(inp);
	SYSEXPORT(_dosmemputb);
	SYSEXPORT(__dpmi_get_page_attributes);
	SYSEXPORT(freopen);
	SYSEXPORT(mktemp);
	SYSEXPORT(setenv);
	SYSEXPORT(fsetpos);
	SYSEXPORT(geteuid);
	SYSEXPORT(__FSEXT_set_function);
	SYSEXPORT(printf);
	SYSEXPORT(biostime);
	SYSEXPORT(crlf2nl);
	SYSEXPORT(__dj_stderr);
	SYSEXPORT(putw);
	SYSEXPORT(__dpmi_simulate_real_mode_procedure_retf);
	SYSEXPORT(_go32_dpmi_allocate_iret_wrapper);
	SYSEXPORT(_get_dos_version);
	SYSEXPORT(getopt);
	SYSEXPORT(delay);
	SYSEXPORT(umask);
	SYSEXPORT(sigsetjmp);
	SYSEXPORT(__dpmi_get_processor_exception_handler_vector);
	SYSEXPORT(qsort);
	SYSEXPORT(_go32_dpmi_free_dos_memory);
	SYSEXPORT(ScreenVisualBell);
	SYSEXPORT(unlock);
	SYSEXPORT(getdtablesize);
	SYSEXPORT(fcntl);
	SYSEXPORT(getpwuid);
	SYSEXPORT(getpwent);
	SYSEXPORT(__dpmi_error);
	SYSEXPORT(clrscr);
	SYSEXPORT(spawnlpe);
	SYSEXPORT(_rename);
	SYSEXPORT(cosh);
	SYSEXPORT(ungetch);
	SYSEXPORT(pathconf);
	SYSEXPORT(regerror);
	SYSEXPORT(strstr);
	SYSEXPORT(__crt0_load_environment_file);
	SYSEXPORT(_go32_dpmi_lock_data);
	SYSEXPORT(_lfn_gen_short_fname);
	SYSEXPORT(_djstat_fail_bits);
	SYSEXPORT(vfprintf);
	SYSEXPORT(_dos_getfileattr);
	SYSEXPORT(_conio_kbhit);
	SYSEXPORT(system);
	SYSEXPORT(seekdir);
	SYSEXPORT(__dpmi_allocate_specific_ldt_descriptor);
	SYSEXPORT(__dpmi_get_extended_exception_handler_vector_rm);
	SYSEXPORT(__dpmi_discard_page_contents);
	SYSEXPORT(fscanf);
	SYSEXPORT(close);
	SYSEXPORT(enable);
	SYSEXPORT(cfsetospeed);
	SYSEXPORT(__crt0_glob_function);
	SYSEXPORT(__dpmi_get_segment_limit);
	SYSEXPORT(__udivdi3);
	SYSEXPORT(acos);
	SYSEXPORT(asin);
	SYSEXPORT(atan);
	SYSEXPORT(atan2);
	SYSEXPORT(cos);
	SYSEXPORT(exp);
	SYSEXPORT(fabs);
	SYSEXPORT(floor);
	SYSEXPORT(fmod);
	SYSEXPORT(frexp);
	SYSEXPORT(ldexp);
	SYSEXPORT(sin);
	SYSEXPORT(sqrt);
	SYSEXPORT(tan);
	SYSEXPORT(cbrt);
	SYSEXPORT(exp10);
	SYSEXPORT(exp2);
	SYSEXPORT(expm1);
	SYSEXPORT(log1p);
	SYSEXPORT(powi);
	SYSEXPORT(sincos);
  }
}

#endif

