////////////////////////////////////////////////////////////////////////////////
//
//    List Manager - Core file
//
//  (c) Copyright 2003 Point Mad. All rights reserved.
//
////////////////////////////////////////////////////////////////////////////////
#include <stdio.h>
#include "types.h"
#include "list.h"
#include "text.h"
////////////////////////////////////////////////////////////////////////////////
PListItem NewListItem ( char *Key, void *Data, void (*FreeData) (void*) ) {
	PListItem i = (PListItem)malloc(sizeof(TListItem));
	if ( !i )
	  return NULL;
	memset(i,0,sizeof(TListItem));
	i->Data = Data;

	if ( Key )
		i->Key = (char*)strdup(Key);

	i->FreeData = FreeData;
	return i;
}
////////////////////////////////////////////////////////////////////////////////
PListItem NewListItemEx ( char *Key, void *Data, void (*FreeData) (void*), l_ulong DataType, l_ulong DataSize ) {
	PListItem i = (PListItem)malloc(sizeof(TListItem));
	if ( !i )
	  return NULL;
	memset(i,0,sizeof(TListItem));
	i->Data = Data;

	if ( Key )
		i->Key = (char*)strdup(Key);

	i->FreeData = FreeData;
	i->DataType = DataType;
	i->DataSize = DataSize;
	return i;
}
////////////////////////////////////////////////////////////////////////////////
PListItem ListAddItem ( PList o, PListItem i ) {
	if ( o->Last ) {
		i->Next = o->Last->Next;
		i->Prev = o->Last;
		o->Last->Next->Prev = i;
		o->Last->Next = i;
		o->Last = i;
  } else {
	  i->Next = i;
	  i->Prev = i;
	  o->Last = i;
  }
	return i;
}
////////////////////////////////////////////////////////////////////////////////
PListItem ListAdd ( PList o, char *Key, void *Data, void (*FreeData) (void*) ) {
  PListItem i = NewListItem(Key,Data,FreeData);
  if ( !i )
    return NULL;
	return ListAddItem(o,i);
}
////////////////////////////////////////////////////////////////////////////////
char ListRemoveItem ( PList o, PListItem i ) {
  if ( i->Next == i ) { // Alone in list
	  o->Last = NULL;
	  o->Current = NULL;
  } else {
	  i->Next->Prev = i->Prev;
	  i->Prev->Next = i->Next;
	  if ( o->Last == i ) o->Last = i->Prev;
	  if ( o->Current == i ) o->Current = i->Prev;
  }
  if ( i->Key ) free(i->Key);
	if ( i->Data && i->FreeData ) i->FreeData(i->Data);
	free(i);
  return 1;
}
////////////////////////////////////////////////////////////////////////////////
PListItem ListAtItem ( PList o, unsigned long Index ) {
	PListItem a, b;
  if ( !o->Last ) return NULL;
	a = b = o->Last->Next;
	  Index--;
  if ( a ) do {
	  if ( !Index ) return a;
	  Index--;
	  a = a->Next;
  } while ( a != b );
	return NULL;
}
////////////////////////////////////////////////////////////////////////////////
void *ListAt ( PList o, unsigned long Index ) {
	PListItem a = ListAtItem(o,Index);
	if ( a ) return a->Data;
	return NULL;
}
////////////////////////////////////////////////////////////////////////////////
PListItem ListKeyItem ( PList o, char *Key ) {
	PListItem a, b;
  if ( !o->Last ) return NULL;
	a = b = o->Last->Next;
  if ( a ) do {
	  if ( a->Key ) if ( !TextCompare(Key,a->Key) ) return a;
	  a = a->Next;
  } while ( a != b );
	return NULL;
}
////////////////////////////////////////////////////////////////////////////////
void *ListKey ( PList o, char *Key ) {
	PListItem a = ListKeyItem(o,Key);
	if ( a ) return a->Data;
	return NULL;
}
////////////////////////////////////////////////////////////////////////////////
PListItem ListKeyCaseItem ( PList o, char *Key ) {
	PListItem a, b;
  if ( !o->Last ) return NULL;
	a = b = o->Last->Next;
  if ( a ) do {
	  if ( a->Key ) if ( !TextCaseCompare(Key,a->Key) ) return a;
	  a = a->Next;
  } while ( a != b );
	return NULL;
}
////////////////////////////////////////////////////////////////////////////////
void *ListKeyCase ( PList o, char *Key ) {
	PListItem a = ListKeyCaseItem(o,Key);
	if ( a ) return a->Data;
	return NULL;
}
////////////////////////////////////////////////////////////////////////////////
PListItem ListFoundItem ( PList o, void *Data ) {
	PListItem a, b;
  if ( !o->Last ) return NULL;
	a = b = o->Last->Next;
  if ( a ) do {
	  if ( a->Data == Data ) return a;
	  a = a->Next;
  } while ( a != b );
	return NULL;
}
////////////////////////////////////////////////////////////////////////////////
unsigned long ListFoundIndex ( PList o, void *Data ) {
	PListItem a, b;
	l_ulong i = 1;
  if ( !o->Last ) return 0;
	a = b = o->Last->Next;
  if ( a ) do {
	  if ( a->Data == Data ) return i;
	  a = a->Next;
	  i++;
  } while ( a != b );
	return -1;
}
////////////////////////////////////////////////////////////////////////////////
char ListOrderByData ( PList o, long (*comparator) ( void*,void*) ) {
	PListItem c, a, b;
	TListItem t;
  if ( !o->Last && !comparator ) return 0;
	c = a = o->Last->Next;
	do {
	  b = a;
		do {
      if ( a->Data && b->Data && comparator( a->Data, b->Data ) > 0 ) {
	      /*char * aKey = a->Key;
	      void * aData = a->Data;
	      a->Data = b->Data;
	      a->Key  = b->Key;
	      b->Data = aData;
	      b->Key  = aKey;*/
	      
	     	memcpy((void*)(((long)&t)+8),(void*)(((long)a)+8),sizeof(TListItem)-8);
				memcpy((void*)(((long)a)+8),(void*)(((long)b)+8),sizeof(TListItem)-8);
	      memcpy((void*)(((long)b)+8),(void*)(((long)&t)+8),sizeof(TListItem)-8);
	      
      }
      b = b->Next;
    } while ( c != b );
    a = a->Next;
  } while ( c != a );
  return 1;
}
////////////////////////////////////////////////////////////////////////////////
char ListOrderByItem ( PList o, long (*comparator) ( PListItem,PListItem) ) {
	PListItem c, a, b;
	TListItem t;
  if ( !o->Last && !comparator ) return 0;
	c = a = o->Last->Next;
	do {
	  b = a;
		do {
      if ( comparator( a, b ) > 0 ) {
	      /*char * aKey = a->Key;
	      void * aData = a->Data;
	      a->Data = b->Data;
	      a->Key  = b->Key;
	      b->Data = aData;
	      b->Key  = aKey;*/
	      
	     	memcpy((void*)(((long)&t)+8),(void*)(((long)a)+8),sizeof(TListItem)-8);
				memcpy((void*)(((long)a)+8),(void*)(((long)b)+8),sizeof(TListItem)-8);
	      memcpy((void*)(((long)b)+8),(void*)(((long)&t)+8),sizeof(TListItem)-8);
	      
      }
      b = b->Next;
    } while ( c != b );
    a = a->Next;
  } while ( c != a );
  return 1;
}
////////////////////////////////////////////////////////////////////////////////
PList NewList ( void ) {
	PList o = (PList)malloc(sizeof(TList));
	if ( !o )
	  return NULL;
	memset(o,0,sizeof(TList));
	return o;
}
////////////////////////////////////////////////////////////////////////////////
void FreeList ( PList o ) {
	PListItem a, b,n;
	if ( o->Last ) {
  	a = b = o->Last;
  	do {
	  	n = a->Prev;
	  	if ( a->Key ) free(a->Key);
	  	if ( a->Data && a->FreeData ) a->FreeData(a->Data);
	  	free(a);
	  	a = n;
  	} while ( a != b );
  }
	free(o);
}
////////////////////////////////////////////////////////////////////////////////
void KickList ( PList o ) {
	PListItem a, b,n;
	if ( o->Last ) {
  	a = b = o->Last;
  	do {
	  	n = a->Prev;
	  	if ( a->Key ) free(a->Key);
	  	free(a);
	  	a = n;
  	} while ( a != b );
  }
	free(o);
}
////////////////////////////////////////////////////////////////////////////////
