////////////////////////////////////////////////////////////////////////////////
//
//	Control Panel Deamon
//
//	Copyright (c) 2003 Point Mad, Lukas Lipka. All rights reserved.
//
////////////////////////////////////////////////////////////////////////////////
#include "kernel.h"
#include "fms.h"
#include "cp.h"

l_ulong AppVersion	= ULONG_ID(0,0,0,1);
char    AppName[]	= "Control Panel directory deamon";
l_uid	nUID		= "ControlPanel";

PList CPPanels = NULL;
PFileDriver CPDriver = NULL;
PFileMan    CPMan = NULL;

#define BTNWIDTH 80
#define BTNHEIGHT 22
#define BTNSPACE 5

p_bitmap CPGetIcon ( PFileInfo f, l_ulong Size, l_ulong *ToFree )
{
	if ( ToFree ) *ToFree = 0;
	if ( Size == 16 ) return CPPANEL(f->Ex)->Icon16;
	if ( Size == 32 ) return CPPANEL(f->Ex)->Icon32;
	if ( Size == 48 ) return CPPANEL(f->Ex)->Icon48;

	return NULL;
}

l_bool CPRun ( PFileInfo o, l_text ex )
{
	if ( CPPANEL(o->Ex)->Run )
	{
		CPPANEL(o->Ex)->Run();
	}
	else
	{
		FileRun(CPPANEL(o->Ex)->Command,CPPANEL(o->Ex)->Args);
	}
}

PList CPList ( PDrive d, l_text VDir, l_text Dir, l_uchar Attrib )
{
	PList l = NewList();

	if ( CPPanels->Last )
	{
		PListItem a =CPPanels->Last->Next, b=a;

		do
		{
			AddFileInfoToList(l,CPPANEL(a->Data)->Name,VDir,0,FT_VFILE,0,0,0,0,d,CPMan,a->Data);

			a = a->Next;
		}
		while ( a != b );
	}

	return l;
}

PCPPanel CPAddPanel ( l_text Name, l_text Command, l_text Args, p_bitmap Icon16, p_bitmap Icon32, p_bitmap Icon48, l_bool (*Run)(void))
{
	PCPPanel o = malloc(sizeof(TCPPanel));
	if ( !o ) return NULL;
	memset(o, 0, sizeof(TCPPanel));

	o->Name = TextDup(Name);
	o->Command = TextDup(Command);
	o->Icon16 = Icon16;
	o->Icon32 = Icon32;
	o->Icon48 = Icon48;
	o->Run = Run;
	o->Args = TextDup(Args);

	ListAdd(CPPanels, "", o, NULL);

	return o;
}

l_bool LibMain ( l_text Args )
{
	if ( !Me.Ressource ) {
		DebugError("CP.DL ressource is missing. Control Panel have not been loaded.");
		return false;
	}

	CPPanels = NewList();




	CPAddPanel("Keyboard", "xapps/setkeyb.app", NULL, NULL, NULL,0,0);
	CPAddPanel("Mouse", "xapps/setmouse.app", NULL, NULL, NULL,0,0);
	CPAddPanel("Display device", "xapps/setscr.app",NULL, ListKey(Me.Ressource,"SETSCR16"), ListKey(Me.Ressource,"SETSCR32"), 0,0);
	CPAddPanel("System", "", NULL, NULL, NULL,0,0);
	CPAddPanel("Wallpaper", "xapps/setwall.app", NULL, ListKey(Me.Ressource,"SETWALL16"), ListKey(Me.Ressource,"SETWALL32"),0,0);
	CPAddPanel("Theme manager", "xapps/settheme.app", NULL, 0, 0,0,0);

	CPDriver = malloc(sizeof(TFileDriver));
	memset(CPDriver, 0, sizeof(TFileDriver));
	CPDriver->List = &CPList;
	AddDrive("Control Panel", FT_FOLDER, NULL, NULL, CPDriver);

	CPMan = NewFileManager("Control Panel Deamon", NULL, "CPD", &CPRun, NULL, NULL, NULL, &CPGetIcon, NULL, NULL);

	return true;
}

void Close (void)
{

}
