////////////////////////////////////////////////////////////////////////////////
//
//	Listview - Core file
//
//	(c) Copyright 2003,2004 Point Mad, Lukas Lipka. All rights reserved.
//
////////////////////////////////////////////////////////////////////////////////
#include "kernel.h"
#include "widget.h"
#include "listview.h"
#include "textbox.h"

////////////////////////////////////////////////////////////////////////////////
l_ulong	AppVersion = ULONG_ID(0,0,0,1);
l_char	AppName[] = "Listview Widget";
l_uid	nUID = "listview";
l_uid NeededLibs[] = { "widget", "skin","textbox","" };
////////////////////////////////////////////////////////////////////////////////
#define ITEMWIDTH 65
#define ITEMHEIGHT 65
#define BORDEROFFSET 10
#define BORDERTOPOFFSET 0
////////////////////////////////////////////////////////////////////////////////
PSkin SkinListview = 0;
////////////////////////////////////////////////////////////////////////////////
void ListviewDrawItems (PWidget o, p_bitmap buffer, TRect w)
{
	PListItem a = LISTVIEW(o)->Items->Last, b;
	PListviewItem i = 0;
	l_int SelColor = ( o->Flags & WFFocused ) ? makecol(0,0,255) : makecol(215,215,215);

	
	
	l_int x = o->Absolute.a.x+BORDEROFFSET;
	l_int y = o->Absolute.a.y+BORDERTOPOFFSET-SLLWDG(o)->Pos.y;
	l_int yy= o->Absolute.a.y;
  l_int l  = 0;
	if ( !a ) return;

	a = a->Next;
	b = a;


	if ( LISTVIEW(o)->Style == LVS_ICONS ) {
		yy += ITEMHEIGHT;

		do
		{


			i = (PListviewItem)a->Data;

			l = text_length(SkinListview->Font, i->Caption)+4;

			RectAssign ( &i->BufAbs, x, y, x + ITEMWIDTH,	y + ITEMHEIGHT);

			if ( l > ITEMWIDTH ) {
				
				if ( x+(ITEMWIDTH/2)-(l/2)-3 < o->Absolute.a.x+BORDEROFFSET ) {
					
					
					RectAssign ( &i->BufTop,o->Absolute.a.x+BORDEROFFSET,y,o->Absolute.a.x+BORDEROFFSET+l,y+ITEMHEIGHT);

					
				} else 	if ( x+(ITEMWIDTH/2)+(l/2)+3 > o->Absolute.b.x-BORDEROFFSET  ) {
					
					RectAssign ( &i->BufTop,o->Absolute.b.x-BORDEROFFSET-l,y,o->Absolute.b.x-BORDEROFFSET,y+ITEMHEIGHT);
					
				} else {
					
					
					RectAssign ( &i->BufTop, x+(ITEMWIDTH/2)-(l/2)-3, y,
															 		 x+(ITEMWIDTH/2)+(l/2)+3 ,	y + ITEMHEIGHT);

					
				} 
				
				
			} else {
				RectAssign ( &i->BufTop,x,y,x+ITEMWIDTH,y+ITEMHEIGHT);
			}
															 
			if (_RectOverlay(i->BufAbs,w) && i != LISTVIEW(o)->TopItem)
			{
				if (i->Flags & LVI_SELECTED)
				{
					l = min(l,ITEMWIDTH);
					rectfill(buffer,
					x+(ITEMWIDTH/2)-(l/2)-3,
					y+(ITEMHEIGHT/2)+(16)+3,
	 				x+(ITEMWIDTH/2)+(l/2)+3,
					y+(ITEMHEIGHT/2)+(16)+text_height(SkinListview->Font)+2,
					SelColor);
				}

				if ( i->Icon32 ) draw_sprite( buffer, i->Icon32,
				x+(ITEMWIDTH/2 - 16),
				y+(ITEMHEIGHT/2 - 16));

				DrawNiceTextCenter(buffer, SkinListview->Font,
					x+(ITEMWIDTH/2), y+(ITEMHEIGHT/2+16)+2,
					ITEMWIDTH, i->Caption, (i->Flags & LVI_SELECTED)?makecol(255,255,255):SkinListview->FontColor);
			}

			x += ITEMWIDTH;
			if ( x > o->Absolute.b.x-BORDEROFFSET-ITEMWIDTH ) {
				x  = o->Absolute.a.x+BORDEROFFSET;
				y += ITEMHEIGHT;
				yy += ITEMHEIGHT;
			}

			a = a->Next;
		}
		while ( a != b );

		/*do // Draw tops items...
		{*/
			i = LISTVIEW(o)->TopItem;
			
			if ( i ) 
			if (_RectOverlay(i->BufAbs,w) )
			{
				l = text_length(SkinListview->Font, i->Caption);
				
				if ( i->BufAbs.a.x != i->BufTop.a.x || i->BufAbs.b.x != i->BufTop.b.x ) {
					
					if (i->Flags & LVI_SELECTED)
					{
						rectfill(buffer,
						i->BufTop.a.x,
						i->BufTop.a.y+(ITEMHEIGHT/2)+(16)+3,
		 				i->BufTop.b.x,
						i->BufTop.a.y+(ITEMHEIGHT/2)+(16)+text_height(SkinListview->Font)+2,
						SelColor);
					}
					
					if (  i->Icon32 )
					draw_sprite( buffer, i->Icon32,
					i->BufAbs.a.x+(ITEMWIDTH/2 - 16),
					i->BufAbs.a.y+(ITEMHEIGHT/2 - 16));
					
					textout_centre(buffer, SkinListview->Font, i->Caption,
					(i->BufTop.a.x+i->BufTop.b.x)/2,i->BufAbs.a.y+(ITEMHEIGHT/2+16)+2, (i->Flags & LVI_SELECTED)?makecol(255,255,255):SkinListview->FontColor);

					
				} else {
					if (i->Flags & LVI_SELECTED)
					{
						rectfill(buffer,
						i->BufAbs.a.x+(ITEMWIDTH/2)-(l/2)-3,
						i->BufAbs.a.y+(ITEMHEIGHT/2)+(16)+3,
		 				i->BufAbs.a.x+(ITEMWIDTH/2)+(l/2)+3,
						i->BufAbs.a.y+(ITEMHEIGHT/2)+(16)+text_height(SkinListview->Font)+2,
						SelColor);
					}
					if (  i->Icon32 )
					draw_sprite( buffer, i->Icon32,
					i->BufAbs.a.x+(ITEMWIDTH/2 - 16),
					i->BufAbs.a.y+(ITEMHEIGHT/2 - 16));
					textout_centre(buffer, SkinListview->Font, i->Caption,
					i->BufAbs.a.x+(ITEMWIDTH/2),i->BufAbs.a.y+(ITEMHEIGHT/2+16)+2, (i->Flags & LVI_SELECTED)?makecol(255,255,255):SkinListview->FontColor);
				}
				
			}

			/*a = a->Next;
		}
		while ( a != b );
		*/

	} else if ( LISTVIEW(o)->Style == LVS_LIST ) {

		do
		{
			i = (PListviewItem)a->Data;
			
			l = text_length(SkinListview->Font, i->Caption);
			
			RectAssign ( &i->BufAbs, o->Absolute.a.x+1, y, max(o->Absolute.b.x-1,o->Absolute.a.x+22),	y + 18);
			i->BufTop = i->BufAbs;
			if (_RectOverlay(i->BufAbs,w))
			{
				if (i->Flags & LVI_SELECTED)
				{
					rectfill(buffer,
					i->BufAbs.a.x,
					i->BufAbs.a.y+1,
					i->BufAbs.b.x,
					i->BufAbs.b.y-1,
					SelColor);
				}



				if ( i->Icon16 ) draw_sprite(buffer,i->Icon16,o->Absolute.a.x+1,y+1);
				textout(buffer, SkinListview->Font, i->Caption,o->Absolute.a.x+18,y+((16-text_height(SkinListview->Font))/2)+1, (i->Flags & LVI_SELECTED)?makecol(255,255,255):SkinListview->FontColor);
			}
			y += 18;
			yy += 18;
			a = a->Next;
		}
		while ( a != b );




	}



	if ( yy > o->Absolute.b.y ) 
		ScrollBarSetMaxY(SLLWDG(o),yy-o->Absolute.b.y);
	else
		ScrollBarSetMaxY(SLLWDG(o),0);
}
////////////////////////////////////////////////////////////////////////////////
l_ulong CalculateMax ( PWidget o ) {
	PListItem a = LISTVIEW(o)->Items->Last, b;
	l_int x = o->Absolute.a.x+BORDEROFFSET;
	l_int y = o->Absolute.a.y+BORDERTOPOFFSET-SLLWDG(o)->Pos.y;
	l_int yy= o->Absolute.a.y;
  l_int l  = 0;
	if ( !a ) return;

	a = a->Next;
	b = a;


	if ( LISTVIEW(o)->Style == LVS_ICONS ) {
		yy += ITEMHEIGHT;

		do
		{


			x += ITEMWIDTH;
			if ( x > o->Absolute.b.x-BORDEROFFSET-ITEMWIDTH ) {
				x  = o->Absolute.a.x+BORDEROFFSET;
				y += ITEMHEIGHT;
				yy += ITEMHEIGHT;
			}

			a = a->Next;
		}
		while ( a != b );


				


	} else if ( LISTVIEW(o)->Style == LVS_LIST ) {

		do
		{

			yy += 18;
			a = a->Next;
		}
		while ( a != b );




	}



	if ( yy > o->Absolute.b.y ) 
		ScrollBarSetMaxY(SLLWDG(o),yy-o->Absolute.b.y);
	else
		ScrollBarSetMaxY(SLLWDG(o),0);

}
////////////////////////////////////////////////////////////////////////////////
void ListviewDraw ( PWidget o, p_bitmap buffer, PRect w )
{
	DrawSkin(buffer, SkinListview, o->Absolute.a.x, o->Absolute.a.y, o->Absolute.b.x, o->Absolute.b.y);

	ListviewDrawItems(o, buffer, *w);
}

////////////////////////////////////////////////////////////////////////////////
PListviewItem  GetItemUnderPoint ( PListview o, TPoint p )
{
	PListItem a = LISTVIEW(o)->Items->Last;

	if ( a ) do
	{
		if (PointInRect(p, LISTVIEWITEM(a->Data)->BufAbs))
		{
			return LISTVIEWITEM(a->Data);
		}

		a = a->Prev;
	}
	while ( a != LISTVIEW(o)->Items->Last );

	return 0;
}
////////////////////////////////////////////////////////////////////////////////
PListItem ListviewGetTopListItem ( PListview o ) {
	PListItem a = o->Items->Last, b = a;
	if ( !a ) return NULL;
	do {
		if (LISTVIEWITEM(a->Data) == o->TopItem ) return a;
		a = a->Prev;
	} while ( a != b );
	return NULL;
}
////////////////////////////////////////////////////////////////////////////////
PListviewItem ListviewGetTopItem ( PListview o ) {

	return o->TopItem;
}
////////////////////////////////////////////////////////////////////////////////
l_bool ListviewEventHandler ( PWidget o, PEvent Ev )
{
	if (Ev->Type == EV_KEYBOARD) {
	
		if ( SCANCODE(Ev,KEY_RIGHT) || ( (LISTVIEW(o)->Style == LVS_LIST) && SCANCODE(Ev,KEY_DOWN) )) {
			PListItem a = ListviewGetTopListItem(LISTVIEW(o));
			if ( a ) {
				if ( a != LISTVIEW(o)->Items->Last ) 
					ListviewSelectItemAndTell(LISTVIEW(o),LISTVIEWITEM(a->Next->Data),true,false);
			} else if ( LISTVIEW(o)->Items->Last ) {
				ListviewSelectItemAndTell(LISTVIEW(o),LISTVIEWITEM(LISTVIEW(o)->Items->Last->Next->Data),true,false);
			}
			
		} else if ( SCANCODE(Ev,KEY_LEFT)  || ( (LISTVIEW(o)->Style == LVS_LIST) && SCANCODE(Ev,KEY_UP) )) {
			PListItem a = ListviewGetTopListItem(LISTVIEW(o));
			if ( a ) {
				if ( a != LISTVIEW(o)->Items->Last->Next )	
					ListviewSelectItemAndTell(LISTVIEW(o),LISTVIEWITEM(a->Prev->Data),true,false);
			} else if ( LISTVIEW(o)->Items->Last ) {
				ListviewSelectItemAndTell(LISTVIEW(o),LISTVIEWITEM(LISTVIEW(o)->Items->Last->Next->Data),true,false);
			}
					
					
		} else if ( SCANCODE(Ev,KEY_HOME)) {
			PListItem a = ListviewGetTopListItem(LISTVIEW(o));
			if ( a || LISTVIEW(o)->Items->Last  )
				if ( a != LISTVIEW(o)->Items->Last->Next )	
					ListviewSelectItemAndTell(LISTVIEW(o),LISTVIEWITEM(LISTVIEW(o)->Items->Last->Next->Data),true,false);
					
		} else if ( SCANCODE(Ev,KEY_END)) {
			PListItem a = ListviewGetTopListItem(LISTVIEW(o));
			if ( a || LISTVIEW(o)->Items->Last ) 
				if ( a != LISTVIEW(o)->Items->Last )	
					ListviewSelectItemAndTell(LISTVIEW(o),LISTVIEWITEM(LISTVIEW(o)->Items->Last->Data),true,false);
			
		} else if ( SCANCODE(Ev,KEY_ENTER)) {
			if ( LISTVIEW(o)->TopItem && LISTVIEW(o)->OnValMsg )
				WidgetSendSEvent(o, EV_MESSAGE, LISTVIEW(o)->OnValMsg, LISTVIEW(o)->TopItem);
				
		} else if ( !Ev->Keyb.Shift && LISTVIEW(o)->Items->Last ) {
			l_char sel = ToLower(ASCII(Ev));
			PListItem a = ListviewGetTopListItem(LISTVIEW(o)),b;
			if ( !a ) a = LISTVIEW(o)->Items->Last;
			a = a->Next;
			b = a;
			do {
				if ( ToLower(*LISTVIEWITEM(a->Data)->Caption) == sel ) {
					ListviewSelectItemAndTell(LISTVIEW(o),LISTVIEWITEM(a->Data),true,false);
					return true;	
				}
				a = a->Next;
			} while ( a != b);
		}	
	} else if (Ev->Type == EV_MESSAGE) {
 
		if ( Ev->Message == WEvNotifyLostFocus ) {
			WidgetDraw(o, NULL);
			return true;
		}
		if ( Ev->Message == WEvNotifyFocused ) {
			WidgetDraw(o, NULL);
			return true;
		}
		if ( Ev->Message == WEvNotifySameFocus ) {
			
			return true;
		}
		if ( Ev->Message == MSG_NOTIFY_AUTO_RESIZE ) {
			CalculateMax(o);
			return true;
		}	
	} else if (Ev->Type == EV_MOUSE) {
		if (Ev->Message == WEvMouseLDClk) {
			PListviewItem p = GetItemUnderPoint(LISTVIEW(o), Mouse->State.p);
			if ( p )
				if ( LISTVIEW(o)->OnValMsg ) WidgetSendSEvent(o, EV_MESSAGE, LISTVIEW(o)->OnValMsg, p);
			return true;
		}

		if (Ev->Message == WEvMouseLDown || Ev->Message == WEvMouseRDown)
		{
			PListviewItem p = 0;
			p = GetItemUnderPoint(LISTVIEW(o), Mouse->State.p);
			ListviewSelectItem(LISTVIEW(o),p,false,false);	
			return true;
		}
		
		if ( Ev->Message == WEvMouseLUp || Ev->Message == WEvMouseRUp ) {
			
			PListviewItem p = GetItemUnderPoint(LISTVIEW(o), Mouse->State.p);
			if (p)
			{
				if ( Ev->Message == WEvMouseLUp ) {
					if ( o->Flags & WFExecuting ) {
						if ( LISTVIEW(o)->OnValMsg ) WidgetSendSEvent(o, EV_MESSAGE, LISTVIEW(o)->OnValMsg, p);
					} else
						if ( LISTVIEW(o)->OnSelMsg ) WidgetSendSEvent(o, EV_MESSAGE, LISTVIEW(o)->OnSelMsg, p);
				}
					
				if ( Ev->Message == WEvMouseRUp && LISTVIEW(o)->OnRClkMsg ) 
					WidgetSendSEvent(o, EV_MESSAGE, LISTVIEW(o)->OnRClkMsg, p);
				return true;
			}
		}
	}
	return ScrollWidgetEventHandler(o,Ev);
}
////////////////////////////////////////////////////////////////////////////////
void FreeListviewItem ( PListviewItem p ) {
	if ( p->Caption ) free(p->Caption);
	if ( p->Flags & LVI_FREEICON ) {
		if ( p->Icon32 ) destroy_bitmap(p->Icon32);
		if ( p->Icon16 ) destroy_bitmap(p->Icon16);
	}
	free(p);	
}
////////////////////////////////////////////////////////////////////////////////
PListviewItem ListviewAddItem ( PListview o, char* Caption, BITMAP* Icon32, BITMAP* Icon16 )
{
	PListviewItem p = malloc(sizeof(TListviewItem));
	if (!p) return;
	memset(p, 0, sizeof(TListviewItem));

	p->Caption = TextDup(Caption);
	p->Icon16 = Icon16;
	p->Icon32 = Icon32;
	ListAdd (o->Items, Caption, p, (void*)&FreeListviewItem);

	return p;
}
////////////////////////////////////////////////////////////////////////////////
void ListviewRemoveAllItems ( PListview o )
{
	ScrollBarSetMaxY(SLLWDG(o),0);
	ScrollBarSetMaxX(SLLWDG(o),0);

	if (o->Items) FreeList(o->Items);
	o->Items = NewList();
	o->TopItem = NULL;
}
////////////////////////////////////////////////////////////////////////////////
void ListviewFree ( PWidget o )
{
	FreeList(LISTVIEW(o)->Items);
}
////////////////////////////////////////////////////////////////////////////////
void Scroll ( PScrollWidget o, TPoint p )
{
	if ( WIDGET(o)->Flags & WFForceBuffer )
		WidgetDraw(WIDGET(o),NULL);
	else
	{
		WIDGET(o)->Flags |= WFForceBuffer;
		WidgetDraw(WIDGET(o),NULL);
		WIDGET(o)->Flags &= ~WFForceBuffer;
	}
}
////////////////////////////////////////////////////////////////////////////////
PListviewItem GetSelectedItem ( PListview o ) {
	PListItem a = o->Items->Last;
	PListviewItem p = 0;
	if ( !a ) return NULL;
	do
	{
		if (LISTVIEWITEM(a->Data)->Flags & LVI_SELECTED)return a->Data;
		a = a->Prev;
	}
	while ( a != o->Items->Last );
	return NULL;
}
////////////////////////////////////////////////////////////////////////////////
PListItem GetSelectedListItem ( PListview o ) {
	PListItem a = o->Items->Last;
	PListviewItem p = 0;
	if ( !a ) return NULL;
	do
	{
		if (LISTVIEWITEM(a->Data)->Flags & LVI_SELECTED)return a;
		a = a->Prev;
	}
	while ( a != o->Items->Last );
	return NULL;
}
////////////////////////////////////////////////////////////////////////////////
l_bool ListviewScrollTo ( PListview o, PListviewItem i ) {
	TPoint Old = SLLWDG(o)->Pos;
	
	if ( !i ) return false;
	
	ScrollBarSetPosX(SLLWDG(o),i->BufAbs.a.x-WIDGET(o)->Absolute.a.x+SLLWDG(o)->Pos.x);
	ScrollBarSetPosY(SLLWDG(o),i->BufAbs.a.y-WIDGET(o)->Absolute.a.y+SLLWDG(o)->Pos.y);
	
	return (Old.x != SLLWDG(o)->Pos.x)||(Old.y != SLLWDG(o)->Pos.y);
	
}
////////////////////////////////////////////////////////////////////////////////
void ListviewSelectItemAndTell ( PListview o, PListviewItem p, l_bool Scrol, l_bool Multi ) {
	ListviewSelectItem(o,p,Scrol,Multi);
	if ( o->OnSelMsg ) WidgetSendSEvent(WIDGET(o), EV_MESSAGE, o->OnSelMsg, p);
}
////////////////////////////////////////////////////////////////////////////////
void ListviewSelectItem ( PListview o, PListviewItem p, l_bool Scrol, l_bool Multi ) {
	l_bool RedrawAll = Scrol ? ListviewScrollTo(o,p) : false;
	
	PListItem a = o->Items->Last, b = a;

	if ( !a ) return;

	o->TopItem = NULL;

	
	if ( !Multi ) {
		do {
			if ( LISTVIEWITEM(a->Data)->Flags & LVI_SELECTED ) {
				LISTVIEWITEM(a->Data)->Flags &= ~LVI_SELECTED;
				if ( !RedrawAll ) WidgetDraw(WIDGET(o), &LISTVIEWITEM(a->Data)->BufTop);
		 	}
			a = a->Prev;
		} while ( a != b );
	}
	
	if ( p ) {
		p->Flags |= LVI_SELECTED;
	
		o->TopItem = p;
		
		if ( RedrawAll ) {
			Scroll( SLLWDG(o), SLLWDG(o)->Pos);
			ScrollBarRedraw(SLLWDG(o));
		} else
			WidgetDraw(WIDGET(o), &p->BufTop);
			
	}
	
}
////////////////////////////////////////////////////////////////////////////////
void ListviewSelectIndex ( PListview o, l_ulong Index, l_bool Scroll, l_bool Multi ) {
	if ( Index ) {
		PListviewItem a = ListAt(o->Items,Index);
		if ( a ) ListviewSelectItem(o,a,Scroll,Multi);
	} else
		ListviewSelectItem(o,NULL,Scroll,Multi);
}
////////////////////////////////////////////////////////////////////////////////
l_ulong ListviewItemIndex ( PListview o, PListviewItem a ) {
	return ListFoundIndex(o->Items,a);
}
////////////////////////////////////////////////////////////////////////////////
l_text ListviewRenameItemBox ( PListview o, PListviewItem i ) {
	
	PTextbox tb;
	TRect 		r;
	l_text ret = NULL;

	RectAssign(&r,i->BufTop.a.x,i->BufTop.b.y-15,i->BufTop.b.x,i->BufTop.b.y);
	tb = CreateTextbox(&Me,r,TBF_EDITABLE);
	InsertWidget(DeskTop, WIDGET(tb));
	
	TextBoxSetTextEx(tb,i->Caption);

	tb->SelPos = tb->Text;
	tb->SelPosEnd = tb->Text+TextLen(i->Caption);
	WidgetDraw(WIDGET(tb), NULL);
	
	
	tb->ValidMsg = MSG_OK;

	WidgetSetFocus(WIDGET(tb));
	
	if ( WidgetExecute(WIDGET(tb)) != MSG_CANCEL ) {
		if ( TextCaseCompare(tb->Text,i->Caption) )
			ret = TextDup(tb->Text);
	}
	WidgetDispose(WIDGET(tb));

	return ret;	
}
////////////////////////////////////////////////////////////////////////////////
PListview InitListview( PListview p, PApplication App, TRect r )
{
	if (!p) return NULL;

	memset(p, 0, sizeof(TListview));

	p->Items = NewList();
	//p->AddItem = &ListviewAddItem;
	//p->RemoveAllItems = &ListviewRemoveAllItems;

	InitScrollWidget(SLLWDG(p), App, r, 1);

	WIDGET(p)->Flags |= WFFocusable;
	
	SLLWDG(p)->Delta.y = 20;
	SLLWDG(p)->Scrolled = &Scroll;

	WIDGET(p)->Draw = &ListviewDraw;
	WIDGET(p)->EventHandler = &ListviewEventHandler;
	WIDGET(p)->FreeEx = &ListviewFree;

	return p;
}
////////////////////////////////////////////////////////////////////////////////
PListview CreateListview( PApplication App, TRect r )
{
	PListview p = malloc(sizeof(TListview));
	if (!p) return NULL;
	return InitListview(p,App,r);
}
////////////////////////////////////////////////////////////////////////////////
l_bool LibMain ( l_text Args )
{
	SkinListview = GetSkinItem("Listview");

	APPEXPORT(CreateListview);
	APPEXPORT(InitListview);
	APPEXPORT(ListviewAddItem);
	APPEXPORT(ListviewRemoveAllItems);
	APPEXPORT(ListviewEventHandler);
	APPEXPORT(GetSelectedItem);

	APPEXPORT(ListviewSelectItem);
	APPEXPORT(ListviewSelectIndex);
	APPEXPORT(ListviewItemIndex);
	APPEXPORT(ListviewSelectItemAndTell);
	APPEXPORT(ListviewRenameItemBox);

	return true;
}
////////////////////////////////////////////////////////////////////////////////
void Close (void)
{

}
////////////////////////////////////////////////////////////////////////////////
