#ifdef USE_CRC
#define CRC16 1
/*
 * Calculate, intelligently, the CRC of a dataset incrementally given a
 * buffer full at a time.
 * Initialize crc to 0 for XMODEM, -1 for CCITT.
 *
 * Usage:
 *   newcrc = updcrc( oldcrc, bufadr, buflen )
 *        unsigned int oldcrc, buflen;
 *        char *bufadr;
 *
 * Compile with -DTEST to generate program that prints CRC of stdin to stdout.
 * Compile with -DMAKETAB to print values for crctab to stdout
 */

#include "crc.h"

unsigned short updcrc(unsigned short icrc,
                      unsigned char *icp,
                      unsigned int icnt )
{
      register unsigned short crc = icrc;
      register unsigned char *cp = icp;
      register unsigned int cnt = icnt;

      while( cnt-- )
            crc = (crc<<B) ^ crctab[(crc>>(W-B)) ^ *cp++];

      return( crc );
}

#endif
