; SHA-1 calculation routine in Assembly
; Copyright (C) 2002 Davi T. Figueiredo
;
; Used in sha1.e (version 1.33), available from http://www16.brinkster.com/davitf/
;
; Please read sha1.txt for more information and for its license terms
; and disclaimer.



PUSH EAX                    ;save initial values
PUSH EBX
PUSH ECX
PUSH EDX


MOV ECX,w_address_64

InitW:              ;Init W words

MOV EBX,ECX
SUB EBX,12

MOV EAX,[EBX]
SUB EBX,20
XOR EAX,[EBX]
SUB EBX,24
XOR EAX,[EBX]
SUB EBX,8
XOR EAX,[EBX]
ROL EAX,1

MOV [ECX],EAX

ADD  ECX,  4
CMP  ECX,w_address_320
JB   InitW



MOV ECX,h_address   ;Copy the H words into the A,B,C,D,E words
MOV EDX,words_address

MOV EAX,[ECX]       ;Copy A
MOV [EDX],EAX

ADD ECX,4
ADD EDX,4
MOV EAX,[ECX]       ;Copy B
MOV [EDX],EAX

ADD ECX,4
ADD EDX,4
MOV EAX,[ECX]       ;Copy C
MOV [EDX],EAX

ADD ECX,4
ADD EDX,4
MOV EAX,[ECX]       ;Copy D
MOV [EDX],EAX

ADD ECX,4
ADD EDX,4
MOV EAX,[ECX]       ;Copy E
MOV [EDX],EAX


MOV ECX,w_address

Round1:
MOV EAX,[B_address] ;calculate function F
MOV EBX,EAX
NOT EBX
AND EAX,[C_address]
AND EBX,[D_address]
OR  EBX,EAX         ;EBX now contains the result of function F

MOV EAX,[A_address] ;calculate TEMP
ROL EAX,5

ADD EAX,EBX
ADD EAX,[E_address]
ADD EAX,[ECX]       ;W[temp]
ADD EAX,#5A827999   ;EAX now contains TEMP


MOV EDX,[D_address]
MOV [E_address],EDX ;E=D

MOV EDX,[C_address]
MOV [D_address],EDX ;D=C

MOV EDX,[B_address]
ROL EDX,30
MOV [C_address],EDX ;C=rol(B,30)

MOV EDX,[A_address]
MOV [B_address],EDX ;B=A

MOV [A_address],EAX ;A=TEMP


ADD  ECX,  4
CMP  ECX,w_address_80
JB   Round1






Round2:
MOV EBX,[B_address] ;calculate function F
XOR EBX,[C_address]
XOR EBX,[D_address] ;EBX now contains the result of function F

MOV EAX,[A_address] ;calculate TEMP
ROL EAX,5

ADD EAX,EBX
ADD EAX,[E_address]
ADD EAX,[ECX]       ;W[temp]
ADD EAX,#6ED9EBA1   ;EAX now contains TEMP


MOV EDX,[D_address]
MOV [E_address],EDX ;E=D

MOV EDX,[C_address]
MOV [D_address],EDX ;D=C

MOV EDX,[B_address]
ROL EDX,30
MOV [C_address],EDX ;C=rol(B,30)

MOV EDX,[A_address]
MOV [B_address],EDX ;B=A

MOV [A_address],EAX ;A=TEMP


ADD  ECX,  4
CMP  ECX,w_address_160
JB   Round2



Round3:
MOV EAX,[B_address] ;calculate function F
MOV EBX,EAX         ;EBX contains B
MOV EDX,[C_address] ;EDX contains C
AND EAX,EDX         ;EAX contains B and C
AND EBX,[D_address] ;EBX contains B and D
AND EDX,[D_address] ;EDX contains C and D
OR  EBX,EAX
OR  EBX,EDX         ;EBX now contains the result of function F

MOV EAX,[A_address] ;calculate TEMP
ROL EAX,5

ADD EAX,EBX
ADD EAX,[E_address]
ADD EAX,[ECX]       ;W[temp]
ADD EAX,#8F1BBCDC   ;EAX now contains TEMP


MOV EDX,[D_address]
MOV [E_address],EDX ;E=D

MOV EDX,[C_address]
MOV [D_address],EDX ;D=C

MOV EDX,[B_address]
ROL EDX,30
MOV [C_address],EDX ;C=rol(B,30)

MOV EDX,[A_address]
MOV [B_address],EDX ;B=A

MOV [A_address],EAX ;A=TEMP


ADD  ECX,  4
CMP  ECX,w_address_240
JB   Round3




Round4:
MOV EBX,[B_address] ;calculate function F
XOR EBX,[C_address]
XOR EBX,[D_address] ;EBX now contains the result of function F

MOV EAX,[A_address] ;calculate TEMP
ROL EAX,5

ADD EAX,EBX
ADD EAX,[E_address]
ADD EAX,[ECX]       ;W[temp]
ADD EAX,#CA62C1D6   ;EAX now contains TEMP


MOV EDX,[D_address]
MOV [E_address],EDX ;E=D

MOV EDX,[C_address]
MOV [D_address],EDX ;D=C

MOV EDX,[B_address]
ROL EDX,30
MOV [C_address],EDX ;C=rol(B,30)

MOV EDX,[A_address]
MOV [B_address],EDX ;B=A

MOV [A_address],EAX ;A=TEMP


ADD  ECX,  4
CMP  ECX,w_address_320
JB   Round4


;Update the H words
MOV ECX,h_address   ;Copy the H words to the A,B,C,D,E words
MOV EDX,words_address

MOV EAX,[ECX]       ;Add A to H1
ADD EAX,[EDX]
MOV [ECX],EAX
ADD ECX,4
ADD EDX,4

MOV EAX,[ECX]       ;Add B to H2
ADD EAX,[EDX]
MOV [ECX],EAX
ADD ECX,4
ADD EDX,4

MOV EAX,[ECX]       ;Add C to H3
ADD EAX,[EDX]
MOV [ECX],EAX
ADD ECX,4
ADD EDX,4

MOV EAX,[ECX]       ;Add D to H4
ADD EAX,[EDX]
MOV [ECX],EAX
ADD ECX,4
ADD EDX,4

MOV EAX,[ECX]       ;Add E to H5
ADD EAX,[EDX]
MOV [ECX],EAX


POP  EDX                    ;restore initial values
POP  ECX
POP  EBX
POP  EAX

RET                         ;end


