-- formats.e - Graphic formats reading/writing - HIP 2.1
-- Copyright (C) 2001  Davi Tassinari de Figueiredo
--
-- This program is distributed under the terms of the GNU General
-- Public License. Please read the documentation for more information.
--
-- This file has routines for identifying the file format for a picture
-- and calling the appropriate reader/writer for a specified format.

constant include_name = "formats.e"

include wildcard.e

include errors.e
include constant.e


include fileutil.e
include pal.e



global sequence formats

global
constant FORMAT_NAME=1, FORMAT_ID=2, FORMAT_EXTENSION=3, FORMAT_HEADERS=4,
	 FORMAT_BPPS=5, FORMAT_ROUTINES=6,
	 ROUTINE_READ=1,ROUTINE_SAVE=2

constant routine_extensions = {"_read","_save"}

formats = {}
global function register_img_format (sequence name,
				      sequence id,
				      sequence extension,
				      sequence headers,
				      sequence supported_bpps)

    formats = append(formats,{name,id,extension,headers,supported_bpps,-1})
    return length (formats)

end function

-- include formats here

include bmp.e
include gif.e


integer bytes_to_read

bytes_to_read = 0

procedure get_routine_ids()

    sequence id, ids
    ids = repeat(0, length(routine_extensions))

    for fmt = 1 to length(formats) do
	id = formats [fmt][FORMAT_ID]

	for n = 1 to length(routine_extensions) do
	    ids [n] = routine_id (id & routine_extensions[n])
--            if ids[n] = -1 then puts(1,"Could not find "&id & routine_extensions[n]) abort(1) end if
	end for
	formats [fmt][FORMAT_ROUTINES] = ids

	for n = 1 to length (formats[fmt][FORMAT_HEADERS]) do
	    if length(formats[fmt][FORMAT_HEADERS][n])>bytes_to_read then
		bytes_to_read = length(formats[fmt][FORMAT_HEADERS][n])
	    end if
	end for

    end for

end procedure


get_routine_ids()


global function identify_format_from_filename (sequence filename)


    filename=lower(filename)
    for n=1 to length(formats) do
	if compare ( lower(formats [n][FORMAT_EXTENSION]),
	  filename[length(filename)-length(formats [n][FORMAT_EXTENSION])+1..
	   length(filename)])=0 then -- found extension!

	    return n   -- return format

	end if
    end for

    return 0 -- format not identified
end function

global function read_img (atom fn)
    object img_info
    sequence header --, hip_info

    -- log_info ("get_pic_info: start", LOG_IMPORTANT)
    -- Move to the beginning of the file
    if seek(fn, 0) then
	return ERROR_FILEERROR
    end if

    header = read_bytes (fn, bytes_to_read)

    -- log_info_s("get_pic_info: header = %02x %02x %02x %02x", header, LOG_IMPORTANT)
    -- unexpected eof?
    if length(header) < bytes_to_read then return ERROR_INVALIDBMP end if

    img_info = ERROR_INVALIDBMP
    for fmt = 1 to length(formats) do
	if formats[fmt][FORMAT_ROUTINES][ROUTINE_READ]!=-1 then
	    -- there is a reader
	    for n = 1 to length(formats[fmt][FORMAT_HEADERS]) do
		if compare (formats[fmt][FORMAT_HEADERS][n],
		   header[1..length(formats[fmt][FORMAT_HEADERS][n])])=0 then
		    -- found the format!

		    img_info = call_func (formats[fmt][FORMAT_ROUTINES][ROUTINE_READ],{fn})
		    exit
		end if
	    end for
	end if
    end for

--    if atom (img_info) then return img_info end if

    return img_info

end function



global function save_img (integer format, integer fn, sequence img_info)
    -- save the picture

    if format=0 then
	-- automatically select format
	-- find a format with save capability and which supports the image bpp
	for fmt=1 to length(formats) do
	    if formats [fmt][FORMAT_ROUTINES][ROUTINE_SAVE]!=-1 and
		find(img_info[IMG_BPP],formats[fmt][FORMAT_BPPS]) then

		format = fmt    -- found perfect format
		exit
	    end if

	end for

    end if

    if format<1 or format>length(formats) then
	abort_error (include_name, "save_img", sprintf("invalid picture format number: %d",format))
    end if


    if formats [format][FORMAT_ROUTINES][ROUTINE_SAVE]=-1 then
	-- no saver for format
	return ERROR_INVALIDBMP
    elsif find (img_info[IMG_BPP],formats [format][FORMAT_BPPS])=0 then
	-- unsupported BPP for format
	return ERROR_UNSUPPORTEDBPP
    end if

    return call_func (formats [format][FORMAT_ROUTINES][ROUTINE_SAVE],
	{fn,img_info})

end function

