/******************************************************************************

	Arbitrary Precision Math Library General Public License
		    (Written October 5, 1988)

 Copyright (C) 1988 Lloyd Zusman, Master Byte Software, Los
 Gatos, California.  Everyone is permitted to copy and distribute
 verbatim copies of this license, but changing it is not allowed.
 You can also use this wording to make the terms for other programs.

 The wording of this license is based on that of the
 "GNU EMACS GENERAL PUBLIC LICENSE" by Richard Stallman,
 Copyright (C) 1985, 1987, 1988, version of February 11, 1988,
 but since some of the text has been changed, please be sure to
 READ THIS CAREFULLY!

  This general public license is intended to give everyone the right
to share the Arbitrary Precision Math Library (hereinafter referred to
as the "APM Library").  To make sure that you get the rights we want
you to have, I need to make restrictions that forbid anyone to deny
you these rights or to ask you to surrender the rights.

  Specifically, we want to make sure that you have the right to give
away copies of the APM Library, that you receive source code or else
can get it if you want it, that you can change the APM Library or use
pieces of it in new programs, and that you know you can do these
things.

  To make sure that everyone has such rights, we have to forbid you to
deprive anyone else of these rights.  For example, if you distribute
copies of the APM Library, you must give the recipients all the
rights that you have.  You must make sure that they, too, receive or
can get the source code.  And you must tell them their rights.

  Also, for our own protection, we must make certain that everyone
finds out that there is no warranty for the APM Library.  If the APM
Library is modified by someone else and passed on, we want its
recipients to know that what they have is not what we distributed, so
that any problems introduced by others will not reflect on our
reputation.

  Therefore we (Lloyd Zusman and Master Byte Software) make the
following terms which say what you must do to be allowed to
distribute or change the APM Library.

			COPYING POLICIES

1. You may copy and distribute verbatim copies of the APM Library
source code as you receive it, in any medium, provided that you
conspicuously and appropriately publish on each copy a valid copyright
notice "Copyright (C) 1988 Lloyd Zusman, Master Byte Software, Los
Gatos, California" (or with whatever year is appropriate); keep intact
the notices on all files that refer to this License Agreement and to
the absence of any warranty; and give any other recipients of the the
APM Library program a copy of this License Agreement along with the
program.  You may charge a distribution fee for the physical act of
transferring a copy.

  2. You may modify your copy or copies of the APM Library source code or
any portion of it, and copy and distribute such modifications under
the terms of Paragraph 1 above, provided that you also do the following:

    a) cause the modified files to carry prominent notices stating
    that you changed the files and the date of any change; and

    b) cause the whole of any work that you distribute or publish, that in
    whole or in part contains or is a derivative of the APM Library or any
    part thereof, to be licensed to all third parties on terms identical
    to those contained in this License Agreement (except that you may
    choose to grant more extensive warranty protection to some or all
    third parties, at your option).

    c) You may charge a distribution fee for the physical act of
    transferring a copy, and you may at your option offer warranty
    protection in exchange for a fee.

    d) You may not charge a license fee for the whole of any work that
    you distribute or publish, that in whole or in part contains or is
    a derivative of the APM library or any part thereof, without the
    express written permission of Lloyd Zusman and Master Byte Software;
    whether this permission is granted for free or in return for goods
    services, royalties, or other compensation will be determined
    solely by Lloyd Zusman and Master Byte Software.

Mere aggregation of another unrelated program with this program (or its
derivative) on a volume of a storage or distribution medium does not bring
the other program under the scope of these terms.

  3. You may copy and distribute the APM Library (or a portion or
derivative of it, under Paragraph 2) in object code or executable form
under all the terms of Paragraphs 1 and 2 above provided that you also
do one of the following:

    a) accompany it with the complete corresponding machine-readable
    source code, which must be distributed under the terms of
    Paragraphs 1 and 2 above; or,

    b) accompany it with a written offer, valid for at least three
    years, to give any third party free (except for a nominal
    shipping charge) a complete machine-readable copy of the
    corresponding source code, to be distributed under the terms of
    Paragraphs 1 and 2 above; or,

    c) accompany it with the information you received as to where the
    corresponding source code may be obtained.  (This alternative is
    allowed only for noncommercial distribution and only if you
    received the program in object code or executable form alone.)

For an executable file, complete source code means all the source code
for all modules it contains; but, as a special exception, it need not
include source code for modules which are standard libraries that
accompany the operating system on which the executable file runs.

  4. You may not copy, sublicense, distribute or transfer the APM
Library except as expressly provided under this License Agreement.
Any attempt otherwise to copy, sublicense, distribute or transfer the
APM Library is void and your rights to use the APM Library under this
License agreement shall be automatically terminated.  However, parties
who have received computer software programs from you with this
License Agreement will not have their licenses terminated so long as
such parties remain in full compliance.

  5. If you wish to incorporate parts of the APM Library into other
programs whose distribution conditions are different, write to Lloyd
Zusman at Master Byte Software.  We have not yet worked out a simple
rule that can be stated here, but we will often permit this.  We will
be guided by the goals of (1) preserving the free status of all
derivatives of our free software; of (2) promoting the sharing and
reuse of software; and of (3) not allowing anyone to profit from the
use of our software without us also having the opportunity to share
in these profits.

Your comments and suggestions about our licensing policies and our
software are welcome!  Please contact Lloyd Zusman, Master Byte
Software, 127 Wilder Ave., Los Gatos, California 95030, or call
(408) 395-5693.

			   NO WARRANTY

  BECAUSE THE APM LIBRARY IS LICENSED FREE OF CHARGE, WE PROVIDE
ABSOLUTELY NO WARRANTY, TO THE EXTENT PERMITTED BY APPLICABLE STATE
LAW.  EXCEPT WHEN OTHERWISE STATED IN WRITING, MASTER BYTE SOFTWARE,
LLOYD ZUSMAN AND/OR OTHER PARTIES PROVIDE THE APM LIBRARY "AS IS"
WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS TO THE QUALITY
AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE THE APM
LIBRARY PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY
SERVICING, REPAIR OR CORRECTION.

  IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW WILL MASTER BYTE
SOFTWARE, LLOYD ZUSMAN, AND/OR ANY OTHER PARTY WHO MAY MODIFY AND
REDISTRIBUTE THE APM LIBRARY AS PERMITTED ABOVE, BE LIABLE TO YOU FOR
DAMAGES, INCLUDING ANY LOST PROFITS, LOST MONIES, OR OTHER SPECIAL,
INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR
INABILITY TO USE (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA
BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY THIRD PARTIES OR A
FAILURE OF THE PROGRAM TO OPERATE WITH PROGRAMS NOT DISTRIBUTED BY
MASTER BYTE SOFTWARE) THE PROGRAM, EVEN IF YOU HAVE BEEN ADVISED OF
THE POSSIBILITY OF SUCH DAMAGES, OR FOR ANY CLAIM BY ANY OTHER PARTY.

******************************************************************************/


/*
 * Exported header file for the APM library.
 *
 * $Log:	apm.h,v $
 * Revision 1.0  88/10/05  12:38:09  ljz
 * Initial release.
 *
 */

#ifndef APM_H_INCLUDED
#define APM_H_INCLUDED

/*
 * Defining MSC implies MSDOS.
 * Defining TURBOC implies MSDOS.
 * Defining MSDOS alone implies unknown MSDOS C compiler.
 * Defining MSC undefines TURBOC.
 * Defining TURBOC undefines MSC.
 * MSDOS undefined implies Unix.
 */

#ifdef MSC
# ifndef MSDOS
#  define MSDOS
# endif /* ! MSDOS */
# ifdef TURBOC
#  undef TURBOC
# endif /* TURBOC */
#endif /* MSC */

#ifdef TURBOC
# ifndef MSDOS
#  define MSDOS
# endif /* ! MSDOS */
# ifdef MSC
#  undef MSC
# endif /* MSC */
#endif /* TURBOC */

#ifdef MSC
# include <malloc.h>
#endif /* MSC */

struct apm_struct {
	unsigned long magic;
	int alloclen;
	int length;
	int dp;
	short sign;
	short base;
	short *data;
};

typedef struct apm_struct *APM;

extern int apm_errno;

extern int APM_line;
extern char *APM_file;
extern char *APM_func_name;

extern APM apm_init();
extern int apm_dispose();
extern int apm_add();
extern int apm_subtract();
extern int apm_multiply();
extern int apm_divide();
extern int apm_compare();
extern int apm_compare_long();
extern int apm_sign();
extern int apm_absolute_value();
extern int apm_negate();
extern int apm_reciprocal();
extern int apm_scale();
extern int apm_round();
extern int apm_validate();
extern int apm_assign();
extern int apm_assign_long();
extern int apm_assign_string();
extern int apm_convert();
extern int apm_garbage_collect();
/*extern FILE *apm_debug_file();*/
extern int (*apm_error_func())();
extern int apm_calc();
extern APM apm_op_alloc();
extern int apm_get_register();
extern int apm_set_register();

/*
 * Calculator operation codes.
 */
#define APM_CALC_ABS	(-1)
#define APM_CALC_NEG	(-2)
#define APM_CALC_RECIP	(-3)
#define APM_CALC_ADD	(-4)
#define APM_CALC_SUB	(-5)
#define APM_CALC_MUL	(-6)
#define APM_CALC_DIV	(-7)
#define APM_CALC_CLEAR	(-8)
#define APM_CALC_DUP	(-9)
#define APM_CALC_SWAP	(-10)
#define APM_CALC_SCALE	(-11)
#define APM_CALC_PUSH	(-12)
#define APM_CALC_POP	(-13)

/*
 * Macros
 */

#define APM_FUNC_INFO_(X)	(APM_file = __FILE__, APM_line = __LINE__, APM_func_name = (X))

#define apmInit(X,Y,Z)		(APM_FUNC_INFO_("apmInit"),\
				 apm_init((X),(Y),(Z)))
#define apmNew(X)		(APM_FUNC_INFO_("apmNew"),\
				 apm_init(0L, 0, (X)))
#define apmDispose(X)		(APM_FUNC_INFO_("apmDispose"),\
				 apm_dispose((X)))
#define apmAdd(X,Y,Z)		(APM_FUNC_INFO_("apmAdd"),\
				 apm_add((X),(Y),(Z)))
#define apmSubtract(X,Y,Z)	(APM_FUNC_INFO_("apmSubtract"),\
				 apm_subtract((X),(Y),(Z)))
#define apmMultiply(X,Y,Z)	(APM_FUNC_INFO_("apmMultiply"),\
				 apm_multiply((X),(Y),(Z)))
#define apmDivide(V,W,X,Y,Z)	(APM_FUNC_INFO_("apmDivide"),\
				 apm_divide((V),(W),(X),(Y),(Z)))
#define apmCompare(X,Y)		(APM_FUNC_INFO_("apmCompare"),\
				 apm_compare((X),(Y)))
#define apmCompareLong(W,X,Y,Z)	(APM_FUNC_INFO_("apmCompareLong"),\
				 apm_compare_long((W),(X),(Y),(Z)))
#define apmSign(X)		(APM_FUNC_INFO_("apmSign"),\
				 apm_sign((X)))
#define apmAbsoluteValue(X,Y)	(APM_FUNC_INFO_("apmAbsoluteValue"),\
				 apm_absolute_value((X),(Y)))
#define apmNegate(X,Y)		(APM_FUNC_INFO_("apmNegate"),\
				 apm_negate((X),(Y)))
#define apmReciprocal(X,Y,Z)	(APM_FUNC_INFO_("apmReciprocal"),\
				 apm_reciprocal((X),(Y),(Z)))
#define apmScale(X,Y,Z)		(APM_FUNC_INFO_("apmScale"),\
				 apm_scale((X),(Y),(Z)))
#define apmRound(X,Y,Z)		(APM_FUNC_INFO_("apmRound"),\
				 apm_round((X),(Y),(Z)))
#define apmValidate(X)		(APM_FUNC_INFO_("apmValidate"),\
				 apm_validate((X)))
#define apmAssign(X,Y)		(APM_FUNC_INFO_("apmAssign"),\
				 apm_assign((X),(Y)))
#define apmAssignLong(W,X,Y,Z)	(APM_FUNC_INFO_("apmAssignLong"),\
				 apm_assign_long((W),(X),(Y),(Z)))
#define apmAssignString(X,Y,Z)	(APM_FUNC_INFO_("apmAssignString"),\
				 apm_assign_string((X),(Y),(Z)))
#define apmConvert(U,V,W,X,Y,Z)	(APM_FUNC_INFO_("apmConvert"),\
				 apm_convert((U),(V),(W),(X),(Y),(Z)))
#define apmGarbageCollect()	(APM_FUNC_INFO_("apmGarbageCollect"),\
				 apm_garbage_collect())
#define apmGetRegister(X,Y)	(APM_FUNC_INFO_("apmGetRegister"),\
				 apm_get_register((X),(Y)))
#define apmSetRegister(X,Y,Z)	(APM_FUNC_INFO_("apmSetRegister"),\
				 apm_set_register((X),(Y),(Z)))

#define apmErrorFunc(X)		apm_error_func(X)
#define apmDebugFile(X)		apm_debug_file(X)
#define apmCalc			apm_calc

#define APM_ABS			apm_op_alloc(APM_CALC_ABS, 0)
#define APM_NEG			apm_op_alloc(APM_CALC_NEG, 0)
#define APM_RECIP(N)		apm_op_alloc(APM_CALC_RECIP,(N))
#define APM_ADD			apm_op_alloc(APM_CALC_ADD, 0)
#define APM_SUB			apm_op_alloc(APM_CALC_SUB, 0)
#define APM_MUL			apm_op_alloc(APM_CALC_MUL, 0)
#define APM_DIV(N)		apm_op_alloc(APM_CALC_DIV, (N))
#define APM_CLEAR		apm_op_alloc(APM_CALC_CLEAR, 0)
#define APM_DUP			apm_op_alloc(APM_CALC_DUP, 0)
#define APM_SWAP		apm_op_alloc(APM_CALC_SWAP, 0)
#define APM_SCALE(N)		apm_op_alloc(APM_CALC_SCALE, (N))
#define APM_PUSH(N)		apm_op_alloc(APM_CALC_PUSH, (N))
#define APM_POP(N)		apm_op_alloc(APM_CALC_POP, (N))

/*
 * APM error codes (for apm_errno):  errors are < 0, warnings are > 0.
 */
#define APM_OK		0	/* no error */

#define APM_WNULL	1	/* one or more arguments are null */
#define APM_WDIVBYZERO	2	/* division by zero (yields 0) */
#define APM_WTRUNC	3	/* result truncated */
#define APM_WNOALLOC	4	/* attempt to free unallocated apm value */

#define APM_ENOMEM	(-1)	/* no memory (allocation failed) */
#define APM_EPARM	(-2)	/* invalid parameter passed to function */
#define APM_ENULL	(-3)	/* null APM value */
#define APM_EBADVAL	(-4)	/* APM points to bad data */
#define APM_ENULLVAL	(-5)	/* null (non-APM) value */
#define APM_EFMT	(-6)	/* string is of invalid format */
#define APM_EBASE	(-7)	/* invalid base */
#define APM_ESIZE	(-8)	/* size of destination is too low */
#define APM_EOVERLAP	(-9)	/* result overlaps one or more operands */

#endif /* ! APM_H_INCLUDED */
