unit nadwokna;
{$I defines.inc}
interface
uses Vaznik,Wokna32,W32const,Clanky,Tedradky;

{============================================================================}
{======== S T A N D A R D N I   O D K L E P A V A C I   O K N A =============}
{----------------------------------------------------------------------------}
{Nasledujici blok procedur nema samostatne parametry pro polohu a rozmery.   }
{Defaultne se okno vytvori uprostred obrazovky a velikost se prozpusobi      }
{zobrazovanemu textu. Jestli to chces zmenit, tak pouzij nasledujici funkce  }
{modifikujici parametr TITULEK, tzn funkce OO_XY a OO_SV.                    }
{  Priklady:                                                                 }
{           OKokno('Varovani','Kour v mistnosti');                            }
{           OKokno(OO_XY(350,50)+'Varovani','Kour v mistnosti');             }
{           OKokno(OO_XY(0,0)+OO_SV(300,100)+'Varovani','Kour v mistnosti'); }
{============================================================================}


procedure Okokno(titulek,texty:string);
Procedure OKokno(titulek:string;texty:pchar);      {okna s tlacitkem OK}

function AnoNeOkno(texty:string):boolean;
function AnoNeOkno(titulek,texty:string):boolean;

function anonezrusokno(texty:string):byte;
function anonezrusokno(titulek,texty:string):byte; {dialogove okno Ano,Ne,Zrus}

Function Nabidka(x,y:longint;nabidky:string):byte;
Function Nabidka(x,y:longint;nabidky:string;barva_poz,barva_txt,barva_akt:word):byte;

Function Nabidka(x,y:longint;nabidky:string;var z_tagu_vyznam:longint):byte;
Function Nabidka(x,y:longint;nabidky:string;barva_poz,barva_txt,barva_akt:word;var z_tagu_vyznam:longint):byte;
{Jednoduchy vyber nekolika polozek vypsanych pod sebou}
{Varianty s parametrem Z_TAGU_VYZNAM umeji vratit nejen poradi vybrane polozky,
 ale i hodnotu z tagu VYZNAM (pokud je uveden). To je uzitecne, pokud dopredu
 nevime, jake presne polozky se budou v nabidce zobrazovat.}


(*Function VyberBarvuOkno(nadpis:string;default:byte):word;
Function VyberHicolorBarvuOkno(nadpis:string;default:word):word;
Function NamixujBarvu(nadpis:string;default:word):word;*)
{============================================================================}



{============================================================================}
{======== F I L E S E L E C T O R Y =========================================}
{----------------------------------------------------------------------------}
{Necha uzivatele vybrat soubor a vrati jeho jmeno.
 nadpis - zobrazi se v horni liste okna
 maska - druh souboru, ktery se ma zobrazovat. Muze obsahovat cestu
         napr. "C:\HRY\*.* nebo "..\*.TXT"
         na velikosti pismen nezalezi
 koncovky - muzete specifikovat, ktere soubory maji byt zvyrazneny (jinu barvou)
            uvedte jednu nebo vice pripon. Oddeluji se znakem |
            napr. "MP3" nebo "EXE|COM|BAT". Od verze 1.54 je mozne definovat i
            druhou skupinu. Dela se to pomoci dalsiho znaku |
            Priklad: "EXE|COM|BAT|JPG||PNG||GIF|"

 vyska - vyska okna v pixelech
 moznosti - moznost zobrazeni. Vyuziva se 0. a 1.bit.
    0.bit - 0: zobrazuj adresare
            1: nezobrazuj adresare
            V obou pripadech vraci vysledek i s cestou (napr. C:\TP\AHOJ.PAS)

    1.bit - 0: pri rucnim vstupu nedovoli vytvoreni noveho souboru
               take nepovoli vytvorit novy adresar
            1: dovoli vytvoreni noveho souboru. Vyuzito pro dialogy pred
               ulozenim souboru. Rovnez dovoli vytvorit novy adresar.

    7.bit - 0: zakaz mnohonasobny vyber
            1: povol mnohonasobny vyber

Pri pouziti tlacitka Zrus (nebo klavesy Esc) funkce vraci NIL ci ''(prazdny retezec).

FileSelector dovoli vybrat vice souboru, kdezto
VyberSouborOkno dovoli vybrat jen jeden soubor, ale zato to mas rovnou ve stringu}

{============================================================================}
function Fileselector(nadpis,maska,koncovky:string;vyska:longint;moznosti:byte):PVaznik;
function VyberSouborOkno(nadpis,maska,koncovky:string;vyska:longint;moznosti:byte):string;

Function UlozSouborOkno(nadpis,default:string;vyska:longint;adresare:boolean):string;

const VSNORMAL = 0;
      VS_BEZ_A = 1;
      VS_BEZMULTI = 128;
{============================================================================}





{============================================================================}
{======== D V O J L I S T B O X =============================================}
{----------------------------------------------------------------------------}
{Ukaze okno se dvema panely mezi nimiz lze presouvat polozky. V levem panelu }
{jsou vsechny dostupne polozky a v pravem seznam vybranych. Uzitecne na tvor-}
{bu napr. filelistu apod. Vysledkem funkce je vaznik ukazujici na vybrane    }
{polozky z celkoveho seznamu.                                                }
{K parametrum:                                                               }
{P   je seznam vsech dostupnych polozek                                      }
{P2  je seznam defaultne vubranych polozek. Zde je povolena i hodnota NIL    }
{PRAC je procedura, ktera dokaze z plodu vazniku vyseparovat zobrazitelny    }
{retezec. Jestli jsou v seznamu proste Stringy, tak muzes zadat NIL          }
function Dvojlistbox(nadpis:string;sirka,vyska:longint;p,p2:PVaznik;atributy:byte):PVaznik;
{============================================================================}





{============================================================================}
{======== V Y B E R   A   M I C H A N I   B A R E V =========================}
{----------------------------------------------------------------------------}
function VyberBarvuOkno(nadpis:string;default:byte):word;
{Okno s vyberem barvy pro 256 barev, vraci cislo te vybrane. Ovlada se mysi
nebo klavesnici (sipky, Home, End, Enter/O, Esc/Z).
 nadpis - je zobrazen v horni liste okna, mel by mit max. 19 znaku (jestli
          bude delsi, okno se automaticky rozsiri, ale uz nebude vypadat tak
          hezky). Pokud zadate '', zobrazi se 'Vyber barvu:'.
 default - vychozi barva, ktera je vybrana na zacatku a kterou vraci
           v pripade zruseni
 Pokud uzivatel klepnul na Zrusit, vrati fce. vychozi barvu a nastavi globalni
 promennou VyberBarvuOkno_Zruseno na TRUE (jinak bude FALSE)}
function vyberhicolorbarvuokno(nadpis:string;default:word):word;
{To samy, ale vybira se z celeho spektra sestnactibitovych barev
 Pokud uzivatel klepnul na Zrusit, vrati fce. vychozi barvu a nastavi globalni
 promennou VyberBarvuOkno_Zruseno na TRUE (jinak bude FALSE)}

function NamixujBarvu(nadpis:string;default:word):word;
{Michani barev pomoci soupatek. Tuto funkci muzes pouzit primo, ale je to    }
{zbytecne, protoze je volana i z VyberHiColorBarvuOkno}
{============================================================================}





{============================================================================}
{======== R U Z N E =========================================================}
{----------------------------------------------------------------------------}
Procedure KolacovyGraf(ix,iy,isirka:longint;s:string);
{============================================================================}






type
PHyperText = ^THypertext;
THyperText = object(TChytryText)
            odkazy:PVaznik;      {plody jsou promenne typu POdkaz}
            AktClanek:PClanek;
            aktodkaz:PUzel;
            Constructor Init(ix,iy,isirka,ivyska:longint;iclanek:PClanek;fixni:boolean;ivyznam:longint);
            Procedure NajdiOdkazy;virtual;
            Function ZalozOdkaz(const s:string;v:PItRadek;i,j:longint):pointer;
            Procedure GrafickyUpravOdkaz(v:PItRadek;i,j:longint);
            Procedure NactiText(p:PClanek);virtual;
            Procedure Akce_nic;virtual;
            Procedure Akce_L;virtual;
            Destructor Done;virtual;
            end;


PHyperOkno = ^THyperOkno;
THyperOkno = object(TOkno_s_textem)
     txt:PTextovePole;
     hyper:PHyperText;
     historie:PVaznik; {historie navstivenych stranek}
     MeClanky:PDpole;
     Constructor Init(ix,iy,isirka,ivyska:longint;titulek:string;izdroj:PDpole;inadpis:string);
     Function PripravTexty(texty:pchar):PChytryText;virtual;
     Function OdkazNaPointer(s:string):PClanek;
     Procedure Akce(var i:longint);virtual;
     Procedure KrokVpred;virtual;
     Procedure KrokZpet;virtual;
     Procedure PrechodNaOdkaz;virtual;
     end;


{############################################################################}
{############################################################################}
{############################################################################}
{############################################################################}




implementation
uses Lacrt,VenomGFX,FNfont2,Rezklav,DOS,Filesele,Barvy;

type




PDvojListbox = ^TDvojlistBox;
TDvojlistbox = object(TOkno_s_tlacitky)
    vyb,vse:PListbox;
    p_vse,p_vyb,p_vyb_zal:PVaznik;
    attrb:byte;
    cy:longint;
    Constructor Init(ix,iy,isirka,ivyska:longint;titulek:string;p,p2:PVaznik;iattrb:byte);
    Procedure NatahniListboxy;virtual;
    Procedure Napoveda;virtual;
    Procedure Run;virtual;
    Procedure Akce(var i:longint);virtual;
    Procedure Pridej(var i:longint);
    Procedure Odeber(var i:longint);
    Function  VratMultiHodnotu:PVaznik;
    Destructor Done;virtual;
    end;



POdkaz = ^TOdkaz;
TOdkaz = record
            x1,y1,x2,y2:longint;
            kam:pstring
         end;

{================-Standardni dialogova okna-=================================}

Function TlacitkoveOkno(titulek:string;texty:pchar;tla:string):byte;
var o:POkno_s_textem;
begin
o:=New(POkno_s_textem,Init(NA_STRED,NA_STRED,cil^.breite-40,cil^.hoehe-20,titulek,texty,tla,true,false));
o^.Zobraz;
o^.Run;
TlacitkoveOkno:=o^.retez^.KteryAktivni_I;
Dispose(o,Done);
end;

function anonezrusokno(titulek,texty:string):byte;
begin
texty:=texty+#0;
Exit(TlacitkoveOkno(titulek,@texty[1],w_ANO+#13#10+w_NE+#13#10+w_CANCEL));
End;

function anonezrusokno(texty:string):byte;
begin
Exit(anonezrusokno(w_ANONE_DOTAZ,texty));
End;

function anoneokno(titulek,texty:string):boolean;
begin
texty:=texty+#0;
Exit(TlacitkoveOkno(titulek,@texty[1],w_ANO+#13#10+w_NE)=1);
End;

function anoneokno(texty:string):boolean;
begin
Exit(anoneokno(w_ANONE_DOTAZ,texty));
End;

Procedure OKokno(titulek:string;texty:pchar);
begin
TlacitkoveOkno(titulek,texty,w_OK);
End;{okokno}

Procedure OKokno(titulek,texty:string);
begin
texty:=texty+#0;
OKokno(titulek,@texty[1]);
end;


Function Nabidka(x,y:longint;nabidky:string;barva_poz,barva_txt,barva_akt:word;var z_tagu_vyznam:longint):byte;
{jednoduchy vyber nekolika polozek vypsanych pod sebou}
var ss,sa:PStrom;
    p:pchar;
    sn:PVaznik;
    a,i:byte;
    r:pointer;
    menu:PVybernicek;
    o,xr,yr:longint;
    u,uu:string;

begin
{retezec s nabidkami rozsekame na jednotlive polozky
 napr. s:string="jaro #13#10 leto #13#10 podzim #13#10 zima" rozseka do pole}

a:=1;
sa:=New(PStrom,init(nil,nil,nil));
repeat
i:=Pos(#13#10,nabidky);
if i<>0 then u:=Copy(nabidky,1,i-1) else u:=nabidky;

r:=VytvorPolozku(u,'',a,true);
sa^.InitNext(r);

delete(nabidky,1,i+1);
inc(a);
until (i=0) or (nabidky='');

ss:=New(Pstrom,Init(nil,nil,nil));
ss^.PridejPodstrom(sa);

menu:=New(PVybernicek,Init(0,0,vbPODSEBOU,ss));
menu^.bb_vyb_v:=barva_poz;
menu^.bb_vyb_v_akt:=barva_poz;
menu^.bb_vyb_txt_akt:=barva_txt;
menu^.bb_vyb_v_sti:=barva_akt;

menu^.realne_vykresluj:=false;  {finta, aby se vypocitaly pozice na obrazovce}
menu^.Zobraz;
menu^.realne_vykresluj:=true;   {ale realne aby se nic nevykreslilo}

if x<0 then x:=0;
if y<0 then y:=0;


xr:=menu^.x2+1;    {az tez zname velikosti menu}
yr:=menu^.y2+1;

if x+xr>cil^.breiteminus1 then x:=cil^.breiteminus1-xr+1;
if y+yr>cil^.hoeheminus1 then y:=cil^.hoeheminus1-yr+1;

{coz nam ted dovoluje provest nejake korekce polohy}
menu^.ZmenPozici(x,y);  {ted definitivne urcime polohu}

menu^.Zobraz;   {a naostro zobrazime}


i:=menu^.Vyber_ID(u);
menu^.Schovej;
Dispose(menu,Done);
OdstranPolozky(ss);

z_tagu_vyznam:=0;

if i<>0 then
   begin
   o:=NajdiTag(u,'VYZNAM',uu);
   if o<>0 then begin
      i:=Pos('=',uu);
      if i<>0 then
         begin
         delete(uu,1,i);
         z_tagu_vyznam:=myval(uu);
         end;
      end;
   end;

nabidka:=i;
end;


Function Nabidka(x,y:longint;nabidky:string;var z_tagu_vyznam:longint):byte;
{jednoduchy vyber nekolika polozek vypsanych pod sebou}
begin
Nabidka:=Nabidka(x,y,nabidky,ba_vyb_v,ba_vyb_txt_akt,ba_vyb_v_sti,z_tagu_vyznam);
end;


Function Nabidka(x,y:longint;nabidky:string):byte;
var tag_vyznam:longint;
begin
Nabidka:=Nabidka(x,y,nabidky,tag_vyznam);
end;


Function Nabidka(x,y:longint;nabidky:string;barva_poz,barva_txt,barva_akt:word):byte;
var tag_vyznam:longint;
begin
Nabidka:=Nabidka(x,y,nabidky,barva_poz,barva_txt,barva_akt,tag_vyznam);
end;



Procedure Kill_real_polozky(var p:pointer);
var v:^real;
begin
v:=p;
Dispose(v);
end;

Procedure KolacovyGraf(ix,iy,isirka:longint;s:string);
var p:PVaznik;
    a,c,i:byte;
    r:real;
    rr:^real;
    h:PKolacovyGraf;
    t:string;
begin
p:=New(PVaznik,Init);
s:=s+',';
c:=1;
for a:=1 to Length(s) do
    if s[a]=',' then
       begin
       New(rr);
       t:=Copy(s,c,a-c);
       Val(Copy(s,c,a-c),rr^);
       p^.InitNext(rr);
       c:=a+1;
       end;
h:=New(PKolacovyGraf,Init(ix,iy,isirka,nil,p));
h^.Zobraz;
h^.Done;
Vaznik_Done_All(p,@kill_real_polozky);
end;



Constructor TDvojlistbox.Init(ix,iy,isirka,ivyska:longint;titulek:string;p,p2:PVaznik;iattrb:byte);
var s1,s2:string;
    v1,v2:PProstyText;
    n:PTlacitko;
    hv:boolean;
    i,c:longint;

begin
attrb:=iattrb;
s1:=w_PRIDEJPOL+#13#10+w_UBERPOL+#13#10+w_OK+#13#10+w_CANCEL+#13#10+w_POMOC;

inherited Init(ix,iy,titulek,s1);
if isirka<400 then isirka:=400;
Roztahni(isirka,ivyska);
p_vse:=p^.Duplicate;
if p2=nil then p_vyb:=New(PVaznik,Init) else p_vyb:=p2^.Duplicate;
p_vyb_zal:=p2;

i:=retez^.NejsirsiObjekt;
c:=x+sirka div 2-i div 2;

s1:='<POZADI='+MyStr(BA_vyr_okoli)+'>';
s2:='<SP>';
v1:=New(PProstyText,Init(0,0,s1+w_VYBPOL+s2,0));Retez^.PridejDopredu(v1);
v2:=New(PProstyText,Init(0,0,s1+w_VSEPOL+s2,0));Retez^.PridejDopredu(v2);

Roztahni_a_umisti_tlacitka(c,y+VyskaZahlavi,i,2);
n:=Retez^.Uzel(3);
v1^.ZmenPozici((x+n^.x) div 2-v1^.sirka div 2,y+VyskaZahlavi-2);
v2^.ZmenPozici(((n^.x+n^.sirka-1)+(x+sirka-1)) div 2-v2^.sirka div 2,y+VyskaZahlavi-2);
vse:=nil;
vyb:=nil;
NatahniListboxy;
end;


Procedure TDvojlistbox.NatahniListboxy;
var r:PProstyText;
    v:PTlacitko;
    cx:longint;
begin
r:=Retez^.Uzel(1);
v:=Retez^.Uzel(3);

cx:=v^.x+v^.sirka+4;
vse:=New(PListbox,Init(0,0,x+sirka-cx-2,vyska-VyskaZahlavi-r^.vyska-6,p_vse,true,true,ww_dlb_vse));
vse^.ZmenPozici(cx,r^.y+r^.vyska+2);
Retez^.Pridej(vse);
vyb:=New(PListbox,Init(0,0,v^.x-x-5,vyska-VyskaZahlavi-r^.vyska-6,p_vyb,true,false,ww_dlb_vyb));
vyb^.ZmenPozici(x+2,r^.y+r^.vyska+2);
Retez^.Pridej(vyb);
end;

Procedure TDvojlistbox.Napoveda;
var t:word;
begin
t:=BA_okn_v;
BA_okn_v:=BA_inf_v;
if (attrb and 1)<>0 then OKokno(w_pomoc,w_VYBINFO2)
                    else OKokno(w_pomoc,w_VYBINFO);
BA_okn_v:=t;
end;

Procedure TDvojlistbox.Pridej(var i:longint);
var p:PVaznik;
    j:longint;
begin
if xKlavesa.ASCII<>xESC then
   begin
   i:=ww_dlb_vse;
   p:=vse^.VratMultihodnotu;
   if (attrb and 1)<>0 then
      begin
      p_vse^.ZrusPodvaznik(p);
      vse^.ZmenaDat(p_vse);
      end;

   p_vyb^.AbsorbujVaznikUnikatnimi(p_vyb^.last,p);

   vyb^.ZmenaDat(p_vyb);

   vse^.VsechnoOdznac;
   Retez^.Aktivuj(vse);
   Dispose(p,Done);
   vse^.hotovo:=false;
   vyb^.hotovo:=false;
   Zobraz;
   end;
end;

Procedure TDvojlistbox.Odeber(var i:longint);
var p:PVaznik;
begin
if xKlavesa.ASCII<>xESC then
   begin
   i:=ww_dlb_vyb;
   p:=vyb^.VratMultihodnotu;
   if p<>nil then
      begin
      p_vyb^.ZrusPodvaznik(p);
      vyb^.ZmenaDat(p_vyb);
      if (attrb and 1)<>0 then p_vse^.AbsorbujVaznikUnikatnimi(p_vse^.last,p);
      vyb^.VsechnoOdznac;
      Retez^.Aktivuj(vyb);
      Zobraz;
      Dispose(p,Done);
      end;
   end;
end;

Procedure TDvojlistBox.Akce(var i:longint);
begin
case i of
   ww_pomoc:Napoveda;
   ww_dlb_pridat:Pridej(i);
   ww_dlb_odebrat:Odeber(i);
end;{case}
end;

Procedure TDvojlistbox.Run;
var i:longint;
    p:PVaznik;
begin
repeat
   inherited Run;
   i:=Retez^.VyznamAktivniho(akt_bez);
   if vse^.hotovo then Pridej(i);
   if vyb^.hotovo then Odeber(i);

Zobraz;
until (i=ww_ano) or (i=ww_ne) or (i=ww_zrus);
end;

Function TDvojlistbox.VratMultiHodnotu:PVaznik;
begin
if Retez^.VyznamAktivniho(akt_bez)<>ww_ano then
   begin
   Vaznik_done_all(p_vyb);
   p_vyb:=p_vyb_zal^.Duplicate;
   end;
VratMultiHodnotu:=p_vyb;
end;


Destructor TDvojlistbox.Done;
begin
inherited Done;
Vaznik_Done_all(p_vse);
end;


{============================================================================}

Function NamixujBarvu(nadpis:string;default:word):word;
var t:TMixBarvuOkno;
begin
t.init(NA_STRED,NA_STRED,nadpis,default);
t.zobraz;
t.run;
NamixujBarvu:=t.VratHodnotu;
t.done;
end;


Function VyberBarvuOkno(nadpis:string;default:byte):word;
var t:TVyberBarvuOkno;
begin
t.init(NA_STRED,NA_STRED,nadpis,default);
t.zobraz;
t.run;
VyberBarvuOkno:=t.VratHodnotu;
t.done;
end;


Function VyberHicolorBarvuOkno(nadpis:string;default:word):word;
var t:TVyberBarvu16Okno;
begin
t.init(NA_STRED,NA_STRED,nadpis,default);
t.zobraz;
t.run;
VyberHicolorBarvuOkno:=t.VratHodnotu;
t.done;
end;


Function Fileselector(nadpis,maska,koncovky:string;vyska:longint;moznosti:byte):PVaznik;
var t:TFileselector;
begin
t.Init(NA_STRED,NA_STRED,400,vyska,nadpis,maska,koncovky,moznosti);
t.Zobraz;
t.Run;
Fileselector:=t.VratMultiHodnotu;
t.Done;
end;


Function VyberSouborOkno(nadpis,maska,koncovky:string;vyska:longint;moznosti:byte):string;
var t:TFileselector;
begin
t.Init(NA_STRED,NA_STRED,400,vyska,nadpis,maska,koncovky,moznosti);
t.Zobraz;
t.Run;
VyberSouborOkno:=t.VratHodnotu;
t.Done;
end;


Function Dvojlistbox(nadpis:string;sirka,vyska:longint;p,p2:PVaznik;atributy:byte):PVaznik;
var d:TDvojListBox;
    q:PVaznik;
begin
d.Init(NA_STRED,NA_STRED,sirka,vyska,nadpis,p,p2,atributy);
d.Zobraz;
d.Run;
q:=d.VratMultiHodnotu;
{d.Done;}
Dvojlistbox:=q;
end;

Function UlozSouborOkno(nadpis,default:string;vyska:longint;adresare:boolean):string;
var d:TFileSelector;
    t,s1,s2,s3:string;
    b:boolean;
    m:byte;

begin
if adresare then m:=2 else m:=3;
default:=Fexpand(default);
FSplit(default,s1,s2,s3);
d.Init(NA_STRED,NA_STRED,400,vyska,nadpis,s1+'*.*',s2+s3,m);

repeat
if adresare then d.tpl^.VlozHodnotu(default)
            else d.tpl^.VlozHodnotu(s2+s3);

d.Retez^.Aktivuj(d.tpl);
d.Zobraz;
b:=true;
d.Run;
t:=d.VratHodnotu;
if t='' then begin d.Done;Exit('');end;
if ExistFile(t) {and (Convert_Down(default)<>Convert_Down(t))} then
   b:=AnoNeOkno(w_PREPSATSOUBOR+#13#10+StripNameExt(t));
d.lbs^.hotovo:=false;
d.tpl^.hotovo:=false;
until b=true;
UlozSouborOkno:=t;
d.Done;
end;


Procedure Kill_POdkaz(var p:pointer);
var v:POdkaz;
begin
v:=p;
ZrusPString(v^.kam);
Dispose(v);
end;


Procedure SmazVaznikPOdkazu(var p:PVaznik);
begin
Vaznik_Done_all(p,@Kill_POdkaz);
end;


Constructor THyperText.Init(ix,iy,isirka,ivyska:longint;iclanek:PClanek;fixni:boolean;ivyznam:longint);
begin
odkazy:=NovyVaznik;
aktodkaz:=nil;
AktClanek:=iclanek;
inherited Init(ix,iy,isirka,ivyska,AktClanek^.text,true,fixni,ivyznam);
id:=id_THyperText;
atributy:=atributy or A_VYHRADNIREZIM; {To ma sice uz zdedene, ale pro prehlednst...}
NajdiOdkazy;
end;

Procedure THyperText.NajdiOdkazy;
var v:PItRadek;
    s,t:string;
    i,j:longint;

begin
odkazy:=NovyVaznik;
prvky^.Reset;
while not prvky^.Konec do
   begin
   v:=prvky^.Nacti;
   i:=Najdi_tag_IT(v,1,'OK=',s);
   while i<>0 do
      begin
      j:=Najdi_tag_IT(v,1,'OK/',t);
      if j=0 then j:=v^.up+1;
      ZalozOdkaz(s,v,i,j);
      GrafickyUpravOdkaz(v,i,j);
      i:=Najdi_tag_IT(v,j+1,'OK=',s);
      end;
   end;
end;


Function THyperText.ZalozOdkaz(const s:string;v:PItRadek;i,j:longint):pointer;
var e:POdkaz;
begin
New(e);
e^.kam:=NaPString(Copy(s,4,255));
e^.x1:=Zjisti_X(i,v);
e^.x2:=Zjisti_X(j,v);
e^.y1:=v^.y1;
e^.y2:=v^.y2;
odkazy^.InitNext(e);
ZalozOdkaz:=e;
end;


Procedure THyperText.GrafickyUpravOdkaz(v:PItRadek;i,j:longint);
var g,h,ch:PFnAtrb;
begin
g:=v^.VratUzel(i);
h:=g^.CopyTo(i);
ch:=g^.CopyTo(j);
h^.podtrh:=true;
h^.barva:=FN_color2;
v^.UmistiUzel(h,i);
v^.UmistiUzel(ch,j);
end;


Procedure THyperText.Akce_nic;
var e:POdkaz;
    b:boolean;
    xx,yy:longint;
begin
xx:=Mouse.X-x+Poc_ZobrX;
yy:=Mouse.Y-y+Poc_ZobrY;
b:=false;
odkazy^.Reset;
while not odkazy^.Konec do
   begin
   e:=odkazy^.Nacti;
   if Uvnitr(xx,yy,e^.x1,e^.y1,e^.x2,e^.y2) then
      begin aktodkaz:=odkazy^.Nacteny;b:=true;Break;end;
   end;

if B then if MouseGetCursor<>@HAND_POINTER then MouseSetCursor(MOUSEHND) else
   else begin
   aktodkaz:=nil;
   if MouseGetCursor<>@DEFAULT_POINTER then MouseSetCursor(MOUSEDEF);
   end;
end;

Procedure THyperText.NactiText(p:PClanek);
begin
SmazVaznikPOdkazu(odkazy);
PripravSeNaText;
AktClanek:=p;
NalamejText(p^.text,sirka,vyska,true,true);
NajdiOdkazy;
Zobraz;
end;

Procedure THyperText.Akce_L;
var e:POdkaz;
    p:pchar;
begin
if aktodkaz<>nil then
   begin
   hotovo:=true;
   MouseSetCursor(MOUSEDEF);
   end;
end;

Destructor THyperText.Done;
begin
inherited Done;
SmazVaznikPOdkazu(odkazy);
end;



Constructor THyperOkno.Init(ix,iy,isirka,ivyska:longint;titulek:string;izdroj:PDpole;inadpis:string);
var p:PClanek;
begin
txt:=New(PTextovePole,Init(0,0,isirka-10,'',false,0));

TOkno_s_tlacitky.Init(ix,iy,titulek,w_ZPET+#13#10+w_OK+#13#10+w_VPRED);
fixni:=true;
tagy:=true;
historie:=NovyVaznik;
dec(ivyska,vyska+txt^.vyska);
MeClanky:=izdroj;
p:=hlll(izdroj,inadpis);
hyper:=New(PHyperText,Init(0,0,isirka,ivyska,p,fixni,ww_hypertext));

historie^.InitNext(hyper^.AktClanek);
historie^.poloha:=historie^.first;
VlozNahoru(hyper);
inc(vyska,txt^.vyska+2);
txt^.ZmenPozici(x+2,y+vyska-txt^.vyska-2);
Retez^.Pridej(txt);
SrovnejPozici;
end;


Function THyperOkno.PripravTexty(texty:pchar):PChytryText;
begin
PripravTexty:=nil;
end;


Procedure THyperOkno.Akce(var i:longint);
begin
if i=ww_zpet then KrokZpet else
if i=ww_vpred then KrokVpred else
if i=ww_hypertext then PrechodNaOdkaz;
end;


Function THyperOkno.OdkazNaPointer(s:string):PClanek;
var a,b:longint;
    p:PClanek;
begin
if Hmasis(s,'"')<>2 then Exit(nil);
a:=Search(s,'"',1);
b:=Search(s,'"',a+1);
s:=Mid(s,a+1,b-1);
if s='' then Exit(nil);
p:=hlll(MeClanky,s);
if CL_bylo_nalezeno=false then OdkazNaPointer:=nil
                          else OdkazNaPointer:=p;
end;



Procedure THyperOkno.KrokZpet;
begin
if historie^.poloha^.predchozi<>nil then
   begin
   historie^.poloha:=historie^.poloha^.predchozi;
   hyper^.NactiText(historie^.poloha^.vazba);
   end;
end;

Procedure THyperOkno.KrokVpred;
begin
if historie^.poloha^.dalsi<>nil then
   begin
   historie^.poloha:=historie^.poloha^.dalsi;
   hyper^.NactiText(historie^.poloha^.vazba);
   end;
end;

Procedure THyperOkno.PrechodNaOdkaz;
var e:POdkaz;
    p:PClanek;
begin
hyper^.hotovo:=false;
e:=hyper^.aktodkaz^.vazba;
p:=OdkazNaPointer(e^.kam^);
if p<>nil then
   begin
   while historie^.poloha^.dalsi<>nil do
      historie^.ZrusUzel(historie^.poloha^.dalsi);
   hyper^.NactiText(p);
   historie^.poloha:=historie^.InitNext(hyper^.AktClanek);
   end;
end;

end.
