;********************************;
; WASM Buffered File I/O, Output ;
; By Eric Tauck                  ;
;                                ;
; Defines:                       ;
;                                ;
;   PutByt  write a byte         ;
;   BufPut  write a buffer       ;
;                                ;
; Requires:                      ;
;                                ;
;   BUFFER1.ASM                  ;
;   FILE.ASM                     ;
;********************************;

        jmps    _buffer3_end

;========================================
; Write a byte to a buffer.
;
; In: AL= byte; BX= buffer record
;     address.
;
; Out: AL= DOS error code; CY= set if
;      error.

PutByt  PROC    NEAR

;--- write a byte to the buffer

        mov     dx, [bx + _BUFFER_BYTES]        ;load bytes in buffer
        cmp     dx, [bx + _BUFFER_SIZE]         ;check if full
        je      _bfput1

        inc     WORD [bx + _BUFFER_BYTES]       ;increment bytes in buffer
        inc     WORD [bx + _BUFFER_CURRENT]     ;increment pointer
        push    bx
        push    ds
        lds     bx, [bx + _BUFFER_CURRENT]      ;load buffer location
        mov     [bx - 1], al                    ;store byte to buffer
        pop     ds
        pop     bx

        clc
        ret

;--- write out buffer first

_bfput1 push    ax
        call    BufPut          ;write buffer
        pop     ax
        jnc     PutByt          ;loop back if no error
        ret
        ENDP

;========================================
; Write all bytes in buffer.
;
; In: BX= buffer record address.
;
; Out: AL= DOS error code; CY= set if
;      error.

BufPut  PROC    NEAR
        push    bx
        mov     dx, [bx + _BUFFER_CURRENT + 2]  ;segment of buffer
        mov     ax, [bx + _BUFFER_BASE]         ;buffer base
        mov     cx, [bx + _BUFFER_BYTES]        ;bytes in buffer
        mov     bx, [bx + _BUFFER_HANDLE]       ;file handle
        call    FilWri                          ;write to file
        pop     bx
        jc      _bfwri1                         ;jump if error
        mov     WORD [bx + _BUFFER_BYTES], 0    ;zero bytes in buffer
        push    WORD [bx + _BUFFER_BASE]
        pop     WORD [bx + _BUFFER_CURRENT], ax ;reset base pointer
        clc
_bfwri1 ret
        ENDP

_buffer3_end
