;****************************;
; WASM Environment Access    ;
; By Eric Tauck              ;
;                            ;
; Defines:                   ;
;                            ;
;   EnvPro  get program name ;
;   EnvRes  reset reader     ;
;   EnvGet  get next string  ;
;****************************;

;--- initialization

        mov     _env_prg,0FFFFH ;default unavailable
        mov     ah, 30H         ;get DOS version function
        int     21H             ;execute
        cmp     al, 3           ;check if at least 3
        jb      _env_2          ;jump if not

        push    es
        mov     es, [_ENV_SEG]  ;load segment
        sub     di, di          ;start of environment
        sub     al, al          ;byte to search for
        mov     cx, 0FFFFH      ;bytes to search
        cld
_env_1  repne
        scasb                   ;scan for zero
        seg     es
        cmp     BYTE [di], 0    ;check if end of environment
        jne     _env_1          ;loop back if not

        add     di, 3           ;skip to program name
        mov     _env_prg, di    ;save address
        pop     es

_env_2  call    EnvRes          ;reset environment pointer
        jmps    _enviro_end

;--- data

_ENV_SEG        EQU     2CH     ;address of environment segment
_env_prg        DW      ?       ;offset of program name
_env_ptr        DW      0       ;current read offset

;========================================
; Return the address of the program name.
;
; Out: DX:AX= name address; CY= set if
;      unavailable (i.e. DOS pre-3.0).

EnvPro  PROC    NEAR
        mov     ax, _env_prg    ;load offset
        cmp     ax, 0FFFFH      ;check if illegal
        je      _evprg1         ;jump if so
        mov     dx, [_ENV_SEG]  ;return segment
        clc
        ret
_evprg1 stc
        ret
        ENDP

;========================================
; Reset environment reader.

EnvRes  PROC    NEAR
        push    ds
        mov     ds, [_ENV_SEG]  ;segment
        sub     ax, ax          ;default address
        cmp     BYTE [0], 0     ;check if end of environment strings
        jne     _evres1
        mov     ax, 0FFFFH      ;end flag
_evres1 pop     ds
        mov     _env_ptr, ax    ;save address/flag
        ret
        ENDP

;========================================
; Return address of next string.
;
; Out: DX:AX= next environment string
;      address; CY= set if no more.

EnvGet  PROC    NEAR
        mov     ax, _env_ptr    ;load pointer
        cmp     ax, 0FFFFH      ;check if end of environment strings
        je      _evget2         ;jump if so
        push    ax              ;save for return
        push    di
        push    es
        mov     di, ax          ;search start address
        mov     es, [_ENV_SEG]  ;load segment
        sub     al, al          ;look for end of this string
        mov     cx, 0FFFFH      ;bytes to search
        cld                     ;clear direction
        repne
        scasb                   ;scan for zero
        mov     dx, es          ;return segment in DX
        mov     ax, di          ;pointer to next string
        seg     es
        cmp     BYTE [di], 0    ;check if end of strings
        jne     _evget1
        mov     ax, 0FFFFH      ;end of string flag
_evget1 mov     _env_ptr, ax    ;save next address
        pop     es
        pop     di
        pop     ax
        clc
        ret

;--- no environment string returned

_evget2 stc
        ret
        ENDP

_enviro_end
