;**************************;
; WASM Memory Module       ;
; By Eric Tauck            ;
;                          ;
; Defines:                 ;
;                          ;
;   MemAll  allocate block ;
;   MemRel  release block  ;
;**************************;

        jmps    _memory_end

;========================================
; Allocate a memory block.
;
; In: AX= bytes to allocate (0FFF0H max).
;
; Out: AX= segment of block; DX= bytes
;      allocated or maximum bytes
;      available; CY= set if error.

MemAll  PROC   NEAR
        mov     bx, ax
        mov     cl, 4
        shr     bx, cl          ;convert to paragraph
        test    ax, 1111B       ;check if any low bits set
        jz      _mmall1         ;skip round if not
        inc     bx              ;round paragraph up
_mmall1 mov     ax, bx
        shl     ax, cl          ;convert back to bytes
        push    ax
        mov     ah, 48H         ;allocate function
        int     21H             ;execute
        pop     dx              ;restore byte count
        jnc     _mmall2         ;jump if no error
        shl     bx, cl          ;convert to bytes
        mov     dx, bx          ;return in DX
        stc
_mmall2 ret
        ENDP

;========================================
; Release a memory block.
;
; In: AX= segment of block.

MemRel  PROC   NEAR
        push    es
        mov     es, ax
        mov     ah, 49H         ;release function
        int     21H             ;execute
        pop     es
        ret
        ENDP

_memory_end
