;*********************************;
; WASM Prompting Module           ;
; By Eric Tauck                   ;
;                                 ;
; Defines:                        ;
;                                 ;
;   ProWrt  display prompt        ;
;   ProVer  display verify prompt ;
;   ProEsc  display escape prompt ;
;                                 ;
; Requires:                       ;
;                                 ;
;   VIDEO4.ASM                    ;
;   VIDEO5.ASM                    ;
;*********************************;

        jmps    _prompt_end

_prom_ver       DB      ' (Y/N)? ',0
_prom_esc       DB      ';  Press <ESC>',0

;========================================
; Display a two part prompt.
;
; In: AX= first prompt string; BX=
;     second prompt string (possibly
;     NULL); CL= width.
;
; Out: AL= spaces after prompts.

_ProTwo PROC    NEAR
        push    di
        push    cx

;--- first string

        push    bx
        call    WrtStr          ;display first prompt
        mov     di, cx
        call    CurAdv          ;advance cursor
        pop     ax

;--- second string

        or      ax, ax          ;check if second prompt
        jz      _potwo1         ;skip if not

        call    WrtStr          ;display second prompt
        push    cx
        call    CurAdv          ;advance cursor
        pop     ax

_potwo1 add     ax, di          ;total characters displayed
        pop     cx              ;restore width
        sub     dx, dx
        sub     cl, al          ;spaces on end
        jbe     _potwo2         ;exit if none

        push    cx
        mov     al, ' '         ;space
        call    WrtChrs         ;display
        pop     dx

_potwo2 mov     ax, dx
        pop     di
        ret
        ENDP

;========================================
; Display a prompt.
;
; In: AX= prompt string; CL= width.
;
; Out: AL= spaces after prompt.

ProWrt  PROC    NEAR
        sub     bx, bx
        call    _ProTwo
        ret
        ENDP

;========================================
; Display a verify prompt.
;
; In: AX= prompt string; CL= width.
;
; Out: AL= spaces after prompt.

ProVer  PROC    NEAR
        mov     bx, OFFSET _prom_ver
        call    _ProTwo
        ret
        ENDP

;========================================
; Display an ESC prompt.
;
; In: AX= prompt string; CL= width.
;
; Out: AL= spaces after prompt.

ProEsc  PROC    NEAR
        mov     bx, OFFSET _prom_esc
        call    _ProTwo
        ret
        ENDP

_prompt_end
