;********************************;
; WASM Serial I/O, Block Input   ;
; By Eric Tauck                  ;
;                                ;
; Defines:                       ;
;                                ;
;   ComRea  read a block of data ;
;                                ;
; Requires:                      ;
;                                ;
;   SERIAL1.ASM                  ;
;   SERIAL5.ASM                  ;
;********************************;

        jmps    _serial3_end

;========================================
; Read a block of serial data.
;
; In: BX= record address; AX= buffer
;     address; CX= bytes (non-zero); DX=
;     timeout ticks.
;
; Out: CY= set if bytes not all read; AX=
;      number of bytes read.

ComRea  PROC    NEAR
        push    di
        push    si
        push    bp
        push    cx              ;save bytes
        mov     di, dx          ;save timeout value
        mov     si, ax          ;save buffer address
        mov     bp, bx          ;save record address

;--- loop until all bytes loaded

_cmrea1 push    cx
        mov     bx, bp          
        call    ComGet          ;input a byte
        pop     cx
        jc      _cmrea3         ;jump if unavailable

_cmrea2 mov     [si], al        ;save byte
        inc     si              ;increment pointer
        loop    _cmrea1         ;loop back for next byte

;--- finished, no timeout

        pop     ax              ;return bytes read
        pop     bp
        pop     si
        pop     di
        clc
        ret

;--- byte unavailable

_cmrea3 push    cx
        mov     ax, di
        mov     bx, bp
        call    ComWai          ;wait for byte
        pop     cx
        jnc     _cmrea2         ;reenter read loop if available

;--- finished, timeout

        pop     ax              ;return target bytes
        sub     ax, cx          ;decrement for bytes not read
        pop     bp
        pop     si
        pop     di
        stc
        ret
        ENDP

_serial3_end
