;************************************;
; WASM Keyboard Support, Shift State ;
; By Eric Tauck                      ;
;                                    ;
; Defines:                           ;
;                                    ;
;   KeyShf  return shift state       ;
;************************************;

        jmps    _shift_end

KEY_RIGHT_SHIFT EQU     0000000000000001B
KEY_LEFT_SHIFT  EQU     0000000000000010B
KEY_CTRL        EQU     0000000000000100B
KEY_ALT         EQU     0000000000001000B
KEY_LEFT_CTRL   EQU     0000000100000000B
KEY_LEFT_ALT    EQU     0000001000000000B

;========================================
; Return the shift keys.
;
; Out: AX= shift key bits at 40:17 and
;      40:18.

KeyShf  PROC    NEAR
        push    ds
        sub     ax, ax          ;segment 0
        mov     ds, ax          ;
        mov     ax, [0417H]     ;load keyboard flags
        pop     ds
        ret
        ENDP

_shift_end
