;Donald E. Johnson's Hex display/debugging package
;  MICON Systems, Inc.   or  Computer Science Dept.
;  RT. 3, Box 163D           University of Wis.
;  Menomonie, WI 54751       Eau Claire, WI 54701
;This program may be used without obligation,
;  but NO PART OF IT MAY BE SOLD.
;** Useage: Include the following in your code **
;VIDEO EQU 0B800H ;0B000H for monochrome controller
; INCLUDE 'DHEX.INC' ;this file
; DISP LOC,PARAM ;whenever a hex display is desired
; ;LOC=0-1999 (numeric) = position on the screen
; ;PARAM=byte/word to display as 2 or 4 hex digits
; ; e.g. - VAR, BX, CH, BYTE [DI+BX], 12, 45AH, etc.
;registers are not modified by the DISP macro
	list-		;don't list in user's prog.
  if $=256		;previous code?
	jmps	ovrdb	;execute only if invoked
  endif
dalax	proc	near	;display AL or AX
;video displacement follows call and is:
; + for AL and - for AX display
	push	bp
	mov	bp,sp	;set-up linkage
	pushf
	push word [bp+4] ;AX pushed before call
	push	cx
	push	ds	;all used regs saved
	push word [bp+2] ;location param addr
	add word [bp+2],2 ;skip param on RET
	pop	bp	;param addr
	seg	cs	;param in-line
	mov	bp,[bp] ;video addr
	mov	cx,video ;video start
	mov	ds,cx
	mov	cx,404h ;4 digits, 4 rotates
	neg	bp	;AX if -addr
	jns	dhexl	;if 4 digits
	neg	bp	;2 digits only
	mov	ah,al
	mov	ch,2
dhexl	rol	ax,cl	;msNIB to lsNIB
	push	ax
	and	al,15	;only nibble
	cmp	al,9
	jle	decdg
	add	al,7
decdg	add	al,'0'	;ASCII digit
	seg	ds
	mov	[bp],al ;display digit
	inc	bp
	inc	bp	;next addr
	pop	ax
	dec	ch	;nibbles left
	jne	dhexl
	pop	ds	;restore regs
	pop	cx
	pop	ax
	popf
	pop	bp	;no side-effects
	ret	2	;remove orig AX
	endp	;DALAX
 if offset dalax = 259
ovrdb	;target to jmp around proc
 endif
;******** Display Macro **************
;generate a CALL to DALAX with:
; Stack top = AX for restoration
; AX or AL = value to display
; word following call = video address
;  (negative for AX, positive for AL)
disp	macro	pos,val ;byte or word
  if (video>0) and (pos<1999)
   if size(val) and size(al) ;byte?
	push	ax
     ifn type(val)=type(al)
	mov	al,val	;get byte
     endif
	call	dalax	;display byte
	dw	pos+pos	;+vid addr
   elseif size(val) and size(ax) ;word?
	push	ax
     ifn type(val)=type(ax)
	mov	ax,val	;get word
     endif
	call	dalax	;display it
	dw	-pos-pos ;-vid addr
   endif
  endif
 endm ;disp
;The following is an example program
 if 0	;1 to expand test example
exstr	mov	ax,1234h
	disp	78,ah	;last 2 of line 0
	disp	160,ax	;first 4 of line 2
	mov	di,offset exstr
	disp	200,word[di+1] ;middle, #2
	disp	1,bytvar ;2nd position
	retn	;DOS return
bytvar	db	9ah
 endif ;example program
