;================================================
; CONVERT By Eric Tauck
;
; This program converts a binary file to a text
; format suitable for inclusion into a Turbo C or
; or Turbo Pascal program.
;
; The usage is:
;
;   CONVERT [c | pascal] < input_file > output_file
;
; The input file is any existing file, probably
; an assembled WASM program.  The output_file
; will be created (or overwritten if it already
; exists).  The output is either formatted for
; the Turbo C __emit__ statement or the Turbo
; Pascal Inline statement.
;
; This program makes use of the WASM library
; files.

        INCLUDE '..\..\library\start.asm'
        INCLUDE '..\..\library\parms.asm'
        INCLUDE '..\..\library\string.asm'
        INCLUDE '..\..\library\case1.asm'
        INCLUDE '..\..\library\case2.asm'
        INCLUDE '..\..\library\convert.asm'
        INCLUDE '..\..\library\file.asm'

STDIN           EQU     0       ;standard input device handle
STDOUT          EQU     1       ;standard output device handle

WIDTH           EQU     10      ;number of numbers across

P_FORMAT        EQU     0       ;use Pascal format
C_FORMAT        EQU     1       ;use C format

;--- program entry point, determine format

        mov     format, P_FORMAT        ;default format
        mov     si, OFFSET p_sep        ;Pascal separator
        call    ParGet                  ;get next parameter
        jc      main1                   ;jump if none
        mov     di, ax
        call    StrUpr                  ;convert to uppercase
        mov     bx, di
        mov     ax, OFFSET p_str        ;Pascal option
        call    StrCmp                  ;check if matches
        jnc      main1                  ;jump if so
        mov     format, C_FORMAT        ;default format
        mov     si, OFFSET c_sep        ;C separator
        mov     bx, di
        mov     ax, OFFSET c_str        ;C option
        call    StrCmp                  ;check if matches
        jc      main6                   ;jump if not

;--- loop for each input byte

main1   sub     di, di          ;zero bytes in row
        jmp     main5

main2   or      di, di          ;check if any bytes yet
        jz      main3
        push    ax
        mov     ax, si          ;separator
        call    output          ;output
        pop     ax

main3   cmp     di, WIDTH               ;check if too wide
        jb      main4
        push    ax
        mov     ax, OFFSET eolstr       ;end of line string
        call    output
        sub     di, di                  ;reset column count
        pop     ax

main4   call    putnum          ;output byte
        jc      main6           ;exit loop if error
        inc     di              ;increment bytes in this row

main5   call    input           ;get a byte of input
        jnc     main2           ;loop if byte returned

;--- finished

        mov     ax, 4C00H       ;exit with no error code
        int     21H             ;execute

;--- error

main6   mov     ax, 4CFFH       ;exit with error code
        int     21H             ;execute

;--- data

p_str   DB      'PASCAL',0      ;Pascal type
p_sep   DB      '/',0           ;Pascal separator
c_str   DB      'C',0           ;C type
c_sep   DB      ',',0           ;C separator
eolstr  DB      13,10,0         ;end of line string

;========================================
; Output a 8 bit number.
;
; In: AL= number.

putnum  PROC    NEAR
        push    ax
        mov     ax, OFFSET pstart       ;Pascal header
        cmp     format, P_FORMAT        ;check if Pascal
        je      putnum1                 ;jump if so
        mov     ax, OFFSET cstart       ;C header
putnum1 call    output                  ;output header
        pop     ax                      ;restore value
        call    maknum                  ;convert to number
        call    output                  ;output number
        ret

pstart  DB      '$',0           ;Pascal number header
cstart  DB      '0x',0          ;C number header
        ENDP

;========================================
; Convert an 8 bit number to a string.
;
; In: AL= number.
;
; Out: AX= string address.

maknum  PROC    NEAR
        sub     dx, dx                  ;
        sub     ah, ah                  ;number in DX:AX
        mov     cx, 16                  ;base
        mov     bx, OFFSET numbuff      ;place to put number
        call    Num2Str                 ;convert to string
        mov     ax, OFFSET numbuff      ;number string
        call    StrLen                  ;get length
        sub     ax, 2
        add     ax, OFFSET numbuff      ;add a preceding zero if necessary
        ret

        DB      '0'             ;preceding zero
numbuff DS      3               ;2 digits and a null terminator
        ENDP

;========================================
; Send a string to the standard output
; device.
;
; In: AX= string address; CY= set if
;     error.

output  PROC    NEAR
        push    ax
        call    StrLen          ;get bytes to write
        mov     cx, ax
        pop     ax
        mov     dx, ds
        mov     bx, STDOUT      ;device handle
        call    FilWri          ;write to file
        ret
        ENDP

;========================================
; Read a byte from the standard input
; device.
;
; Out: AL= byte; CY= set if EOF
;      (or error).

input   PROC    NEAR
        mov     ax, OFFSET inpbuf
        mov     dx, ds
        mov     bx, STDIN       ;device handle
        mov     cx, 1           ;read byte
        call    FilRea          ;read from file
        mov     al, inpbuf      ;load byte
        ret
inpbuf  DB      ?               ;single byte input buffer
        ENDP

;========================================
; Uninitialized data.

format  LABEL   BYTE            ;current format
        ORG     +1

END
