;================================================================
; Prime Number Generator
; By Eric Tauck
;
; This program generates all 16 bit prime numbers starting with
; 3.  The numbers are displayed to standard output and may be
; captured to a file with the the DOS redirection commands.
;
; This program makes use of the WASM library files.

        INCLUDE '..\..\library\start.asm'
        INCLUDE '..\..\library\memory.asm'
        INCLUDE '..\..\library\message1.asm'
        INCLUDE '..\..\library\message2.asm'
        INCLUDE '..\..\library\case1.asm'
        INCLUDE '..\..\library\convert.asm'

        mov     ax, OFFSET banner
        call    MesPutL

;--- set up prime table

        mov     ax, 0FFF0H      ;memory to allocate (room for 32760 numbers)
        call    MemAll          ;allocate memory
        jc      main5

        mov     si, ax          ;save segment in SI

        push    ds
        mov     ds, si
        mov     WORD [0], 3     ;first prime in table
        pop     ds
        mov     ax, 5           ;first candidate prime
        mov     di, 1           ;number of primes in table

;--- check if number in BX has factor in prime table

main1   push    ds
        sub     bx, bx          ;starting index into table
        mov     cx, di          ;number of primes so far
        mov     ds, si          ;segment of table

main2   push    ax
        sub     dx, dx          ;zero high part of word
        div     WORD [bx]       ;divide
        pop     ax
        or      dx, dx          ;check if remainder
        jz      main3

        inc     bx
        inc     bx              ;next number to check
        loop    main2           ;loop back if more

;--- factor not found, must be prime

        inc     di              ;increment primes in table
        mov     [bx], ax        ;save at last table entry

;--- next prime candidate

main3   pop     ds
        or      cx, cx          ;check if prime
        jnz     main4           ;skip display if not

        push    ax
        push    bx
        sub     dx, dx                  ;zero high word
        mov     cx, 10                  ;base
        mov     bx, OFFSET numbuffer    ;place to put string
        call    Num2Str                 ;convert to ASCII string
        mov     ax, OFFSET numbuffer    ;address of string
        call    MesPutL                 ;display to screen
        pop     bx
        pop     ax

main4   add     ax, 2           ;next prime candidate
        jnc     main1           ;loop back if no overflow

;--- finished

        mov     ax, si          ;allocated memory segment
        call    MemRel          ;release memory

        mov     ax, 4C00H       ;exit with no error
        int     21H             ;execute

;--- error, not enough memory

main5   mov     ax, OFFSET errmes       ;address of error message
        call    MesErrL                 ;display
        mov     ax, 4CFFH               ;exit with error code
        int     21H                     ;execute

;--- data

banner  DB      'Prime Number Generator', 0
errmes  DB      'Not enough memory', 0

;--- uninitialized data

numbuffer       LABEL   BYTE
                ORG     +6

END
