;Wolfware Assembler
;Copyright (c) 1985-1991 Eric Tauck. All rights reserved.

;===============================================;
;                     Error                     ;
; Handles all errors. Counts errors and prints  ;
; messages. All parameters are passed in AX.    ;
; AL contains the error number. AH contains     ;
; various options. For the following set bits   ;
; the effects are:                              ;
; 1 - Output the operand string specified by    ;
;     FE_START and FE_STOP.                     ;
; 2 - Output a colon, space, and then the       ;
;     number in BX in decimal. Works with       ;
;     critical errors.                          ;
; 3 - Output a colon, space, and then the       ;
;     string at SI immediately following the    ;
;     error  message. Works with critical       ;
;     errors.                                   ;
; 4 - Output a colon, space, and then the       ;
;     number in BX in hex.                      ;
; 5 - Output a colon, space, and then the name  ;
;     of the file at DX. Works with critical    ;
;     errors.                                   ;
; 6 - Output a colon, space, and the character  ;
;     in DL.                                    ;
; 7 - Make the error a comment instead.         ;
; 8 - Critical error. Print error message,      ;
;     termination message, and exit to DOS.     ;
; Non-Critical errors and diagnostics are only  ;
; processed on pass two. Critical error are     ;
; processed whenever they occur. Registers BP,  ;
; BX, CX, DX, DI, and SI are explicitly         ;
; preserved.                                    ;
;===============================================;

Error Proc Near
 Test Ah,80h            ;test if critical error
 Jnz Starterr           ;start error routine if so
 Cmp Pass,2             ;check pass
 Je Starterr            ;start error routine if so
 Ret

;----- start error routine

Starterr
 Push Bp
 Push Bx
 Push Cx
 Push Dx
 Push Di
 Push Si
 Push Ds
 Push Es

 Mov Dx, Cs
 Mov Ds, Dx
 Mov Es, Dx             ;set data segments

 Mov Bl,Al              ;BX has error number
 Sub Bh,Bh
 Shl Bx                 ;offset into error table
 Add Bx,Error_Tabl      ;absolute offset
 Mov Bx,[Bx]            ;get location of message

 Test Ah,80h            ;check if critical error
 Jz Nocerror            ;jump if not
 Jmp Criterr            ;critical error

;----- non-critical error, see if header needed

Nocerror Test List_Stat,First_Head ;see if already done
 Jz Emessp1             ;jump if so

 Push Ax
 Push Bx
 Call Header            ;output header
 Pop Bx
 Pop Ax

;----- first part

Emessp1
 Or Line_Stat,Err_Flag  ;set line error flag
 Inc Flag_Num           ;increment number lines flagged

 Test Ah,Bit7           ;check if comment
 Jz Emessp2

 Or Asm_Stat, Com_Exist ;assembly comment flag
 Mov Si,Offset Begdia   ;comment message
 Jmps Emessp12

Emessp2
 Inc Error_Num          ;increment number of errors
 Or Asm_Stat, Err_Exist ;assembly error flag
 Mov Si,Offset Begerr   ;error message

Emessp12
 Mov Di,Lst_Buffer      ;output buffer
 Store_Str              ;move

;----- store line number

 Push Ax
 Push Bx
 Mov Ax,Line_Num        ;line number
 Mov Cx, 10             ;base
 Call Store_Num         ;store number
 Mov Ax, ') '           ;end of number
 Stosw                  ;store
 Pop Bx
 Pop Ax

;----- put message in buffer

 Mov Si,Bx              ;message offset
 Store_Str              ;move

;----- file name display

 Test Ah,Bit5           ;test if file name
 Jz Emstr               ;jump if not

 Push Ax
 Mov Bp,Sp              ;stack
 Mov Si,[Bp+10]         ;DX out of stack
 Mov Ah,Bit1+Bit2+Bit3  ;entire name
 Call Store_Nam         ;get name

 Mov Si,Name_Buff       ;name location
 Call Err_Str           ;store name
 Pop Ax

;----- operand string display

Emstr Test Ah,Bit1      ;test if extra output
 Jz Emstr2              ;jump if not

 Push Ax
 Mov Ax,203ah           ;colon and space
 Stosw                  ;store

 Mov Si,Fe_Start        ;start of operand
 Mov Cx,Fe_Stop         ;end of operand
 Sub Cx,Si              ;length of string
 Call Skip_Space        ;skip spaces
 Jz Noemstr             ;jump if not

 Rep
 Movsb                  ;move string

Noemstr Pop Ax

;----- string display

Emstr2 Test Ah,Bit3     ;test if extra string output
 Jz Emnum               ;jump if not

 Mov Bp,Sp
 Mov Si,[Bp+4]          ;get source from stack
 Call Err_Str           ;store string

;----- hex number display

Emnum Test Ah,Bit4      ;test if number output
 Jz Emdnum              ;jump if not

 Push Ax
 Mov Ax,203ah           ;colon and space
 Stosw                  ;store

 Mov Bp,Sp
 Mov Ax,[Bp+14]         ;get value from stack
 Mov Cx,16              ;base 16
 Mov Dx,0430h           ;length 4, buffer with '0'
 Call Store_Fnum        ;store number

 Mov Al,'H'             ;H for hex
 Stosb                  ;store
 Pop Ax

;----- decimal number display

Emdnum Test Ah,Bit2     ;test if number output
 Jz Emchar              ;jump if not

 Push Ax
 Mov Ax,203ah           ;colon and space
 Stosw                  ;store

 Push Di
 Mov Bp,Sp
 Mov Ax,[Bp+16]         ;get value from stack
 Mov Cx,10              ;base ten
 Call Number_Con        ;convert to ASCII
 Pop Di

 Mov Si,Num_Buff        ;number storage area
 Store_Str              ;move string
 Pop Ax

;----- single character output

Emchar Test Ah,Bit6     ;test if character output
 Jz Eminc               ;jump if not

 Push Ax
 Mov Ax,203ah           ;colon and space
 Stosw                  ;store

 Mov Bp,Sp              ;stack
 Mov Al,[Bp+10]         ;get DL from stack
 Stosb
 Pop Ax

;----- see if in included file

Eminc Call Error_File   ;special information
 Call Lst_Send          ;send output

 Mov Ax,Flag_Num        ;number of errors and comments
 Cmp Ax,Error_Max       ;check if maximum or more
 Jae Tomanerr           ;jump if so

 Pop Es
 Pop Ds
 Pop Si
 Pop Di
 Pop Dx
 Pop Cx
 Pop Bx
 Pop Bp
 Ret

;----- too many errors, exit

Tomanerr
 Call Line_Out          ;display final source line

 Mov Ah,Bit2            ;number display
 Mov Bx,Offset Maxerr   ;message location
 Mov Dx,Error_Num       ;number of errors
 Mov Bp,Sp              ;stack
 Mov [Bp+12],Dx         ;save as number

;----- critical error

Criterr
 Push Ax
 Push Bx
 Call Restore           ;restore system data and close files
 Call New_Line          ;next line
 Mov Si,Offset Begerr   ;first part
 Call Print_Str         ;print string
 Mov Ax,Line_Num        ;line number
 Mov Cx,10              ;base ten
 Call Number_Con        ;convert number
 Mov Si,Num_Buff        ;number storage area
 Call Print_Str         ;print string
 Mov Si,Offset Enderr   ;second part
 Call Print_Str         ;print string
 Pop Si                 ;message
 Call Print_Str         ;print string
 Pop Ax

;----- file name display

 Test Ah,Bit5           ;test if file name
 Jz Cestr               ;jump if not

 Push Ax
 Call Crit_Colon        ;colon
 Mov Bp,Sp              ;stack
 Mov Si,[Bp+10]         ;DX out of stack
 Mov Ah,Bit1+Bit2+Bit3+Bit4 ;entire name and display
 Call Store_Nam         ;display name
 Pop Ax

;----- string display

Cestr
 Test Ah,Bit3           ;test if extra string output
 Jz Crenum              ;jump if not

 Push Ax
 Call Crit_Colon        ;colon
 Mov Bp,Sp
 Mov Si,[Bp+6]          ;get source from stack
 Call Print_Str
 Pop Ax

;----- number display

Crenum
 Test Ah,Bit2           ;test if number
 Jz Nocrname            ;jump if not

 Push Ax
 Call Crit_Colon        ;colon
 Mov Bp,Sp
 Mov Ax,[Bp+14]         ;get value from stack
 Mov Cx,10              ;base ten
 Call Number_Con        ;number from

 Mov Si,Num_Buff        ;number storage area
 Call Print_Str         ;print string
 Pop Ax

;----- program termination

Nocrname
 Mov Si,Offset Crierr   ;termination message
 Call Print_Str         ;print string
 Dos_Function 4ch, Crt_Err_Code ;exit with error code

;===============================================;
;                    Err_Str                    ;
; Local routine of ERROR to move the string at  ;
; SI (preceded by length) to DI (length is not  ;
; written). Adds colon/space and adds closing   ;
; quotes if string at SI is string type.        ;
;===============================================;

Err_Str Proc Near
 Push Ax

 Mov Ax,203ah           ;colon and space
 Stosw                  ;store

 Mov Bx,Si
 Store_Str              ;move string

 Cmp Byte [Bx+1],Str_Delim ;see if string
 Jne Noster             ;jump if not

 Mov Al,Str_Delim       ;single quote
 Stosb                  ;store it for looks

Noster Pop Ax
 Ret
 Endp                   ;Err_Str

;===============================================;
;                  Crit_Colon                   ;
; Print colon and space for critical error.     ;
;===============================================;

Crit_Colon Proc Near
 Mov Si, Offset Critcoldat ;bytes location
 Call Print_Str         ;print string
 Ret

Critcoldat Db 2, ': '
 Endp                   ;Crit_Colon

;===============================================;
;                  Error Data                   ;
; Error numbers and messages. Errors numbers    ;
; can range from 0-255. The first byte is the   ;
; error number, the second is the length        ;
; (which is set by INITIALIZE). The messages    ;
; must terminate with 00.                       ;
;===============================================;

Def_Error Dw 72         ;number of defined errors

;----- pre-messages

Begerr Db 13,'- - - Error (' ;start of error message
Begdia Db 15,'- - - Comment (' ;start of comment message
Enderr Db 2,') '
Maxerr Db 15,'Too many errors' ;too many errors message
Crierr Db 27,13,10,10,'>>>Cannot Continue<<<',13,10,7 ;crit mess

;----- start of error messages, first byte is error number, second byte is
;----- size (set in initializtion routines), and remaining is message
;----- terminated by a byte zero

Errtop Label Byte       ;start of messages

;----- special error

Undefer Db 255,?,'Undefined error',0

;----- I/O errors

 Db 2,?,'Source file not found',0
 Db 4,?,'Cannot create object file',0
 Db 5,?,'Cannot create list file',0

 Db 24,?,'INCLUDE file not found',0
 Db 36,?,'INCLUDE',39,'s nested too deeply',0
 Db 13,?,'INCLUDE within macro',0

 Db 0,?,'Disk full or write error',0

 Db 7,?,'Source line too long',0

;----- syntax errors

 Db 19,?,'Unrecognized instruction',0
 Db 18,?,'Undefined symbol',0
 Db 22,?,'Illegal operand(s)',0
 Db 120,?,'Illegal operand in declaration',0
 Db 135,?,'Illegal number or symbol',0
 Db 25,?,'Illegal operator or symbol',0
 Db 98,?,'Missing or illegal operator',0

 Db 104,?,'Address error',0
 Db 103,?,'Illegal addressing operand',0
 Db 102,?,'Missing right bracket',0

 Db 20,?,'EQU without symbol',0
 Db 27,?,'LABEL without label',0
 Db 125,?,'Illegal argument for NOT',0
 Db 11,?,'Illegal argument for NEG',0
 Db 124,?,'Illegal argument for OFFSET',0
 Db 126,?,'Illegal argument for NEAR',0
 Db 127,?,'Illegal argument for FAR',0
 Db 128,?,'Illegal argument for BYTE',0
 Db 129,?,'Illegal argument for WORD',0
 Db 130,?,'Illegal argument for DWORD',0
 Db 132,?,'Illegal argument for QWORD',0
 Db 133,?,'Illegal argument for TBYTE',0
 Db 29,?,'Illegal argument for ANYSIZE',0
 Db 131,?,'Illegal argument for ST',0
 Db 17,?,'Undefined assembly directive',0

;----- structure errors

 Db 35,?,'Missing PROC',0
 Db 31,?,'Missing ENDP',0
 Db 30,?,'ENDP without PROC',0
 Db 32,?,'Procedures nested too deeply',0
 Db 1,?,'Parenthetical error',0

 Db 34,?,'Illegal reference',0
 Db 33,?,'Phase error',0

;----- data errors

 Db 123,?,'Operand cannot be combined',0
 Db 99,?,'String not closed',0
 Db 134,?,'Division by zero',0
 Db 97,?,'Illegal printer code',0
 Db 144,?,'Parenthesis nested too deeply',0

;----- size errors

 Db 101,?,'Operands are incompatible sizes',0
 Db 40,?,'Invalid operand size',0
 Db 106,?,'Register size override',0
 Db 122,?,'Ambiguous memory reference',0
 Db 23,?,'Should be byte data',0

 Db 37,?,'Overflow',0
 Db 41,?,'Data too long in declaration',0

 Db 21,?,'Line size out of range',0
 Db 38,?,'Page size out of range',0

;----- jump errors

 Db 51,?,'Too far for short jump',0
 Db 50,?,'Could use JMPS',0

;----- symbol table errors

 Db 12,?,'Unused symbol',0
 Db 136,?,'Invalid character in symbol',0
 Db 60,?,'Duplicate definition',0
 Db 61,?,'Out of memory for symbol table',0

;----- code table errors

 Db 142,?,'Out of memory for code table',0

;----- macro errors

 Db 139,?,'MACRO without symbol',0
 Db 138,?,'Missing ENDM',0
 Db 137,?,'ENDM without MACRO',0
 Db 143,?,'Illegal use of MACRO symbol',0
 Db 6,?,'Macros nested too deeply',0
 Db 3,?,'Too many MACRO parameters',0
 Db 140,?,'Out of memory for macro table',0

;----- conditional assembly errors

 Db 8,?,'Missing IF',0
 Db 9,?,'Missing ENDIF',0
 Db 10,?,'IF statements nested too deeply',0
 Endp                   ;Error

;===============================================;
;                   Err_Tset                    ;
; Store destination and source type bit         ;
; patterns to DI.                               ;
;===============================================;

Err_Tset Proc Near
 Mov Di,Tempbuff        ;storage location
 Mov Al,11              ;len=((<2=numbers> * <5=xxxxH>) + <1=space>)
 Stosb                  ;store string length

 Mov Ax,Dtype           ;destination type
 Call Err_Bitset        ;store bit pattern
 Mov Ax,Stype           ;source type
 Call Err_Bitset        ;store bit pattern
 Ret
 Endp                   ;Err_Tset

;===============================================;
;                   Err_Sset                    ;
; Store the destination and source size bit     ;
; patterns to DI.                               ;
;===============================================;

Err_Sset Proc Near
 Mov Di,Tempbuff        ;storage location
 Mov Al,11              ;len=((<2=numbers> * <5=xxxxH>) + <1=spaces>)
 Stosb                  ;store string length

 Mov Ax,Dsize           ;destination size
 Call Err_Bitset        ;store bit pattern
 Mov Ax,Ssize           ;source size
 Call Err_Bitset        ;store bit pattern
 Ret
 Endp                   ;Err_Sset

;===============================================;
;                   Err_Bitset                  ;
; Stores the bit pattern in AX to the location  ;
; in DI.                                        ;
;===============================================;

Err_Bitset Proc Near
 Mov Cx,16              ;base 16
 Mov Dx,0430h           ;length 4, buffer with '0'
 Call Store_Fnum        ;store number

 Mov Al,'H'             ;H for hex digit
 Stosb                  ;store
 Mov Al,' '             ;space
 Stosb                  ;store
 Ret
 Endp                   ;Err_Bitset

;===============================================;
;                  Error_File                   ;
; Store the file name if included source.       ;
;===============================================;

Error_File Proc Near
 Test Input_Stat,Inc_Flag ;check if in include
 Jz Noerrorf            ;jump if not

 Mov Al,' '
 Stosb
 Mov Al,'('
 Stosb                  ;space and open parenthesis

 Mov Si,Inc_Name        ;name
 Mov Ah,Bit1 Or Bit2 Or Bit3 ;entire name
 Call Store_Nam         ;get name
 Mov Si,Name_Buff       ;name location
 Store_Str              ;store name
 Mov Al,')'
 Stosb                  ;close parenthesis

Noerrorf Ret
 Endp                   ;Error_File
