{ GFX - LOADER      Bilder-Lader fr GIF - DATEIEN                          }
{                   Include fr LOADER.PAS                                  }
{ Letzte nderung : 2005-11-28                                               }

(**** GIF ****)

{ Ldt ein GIF-Bild auf den Bildschirm. Die linke obere
Ecke liegt bei den Koordinaten X0,X0. Die Parameter XE,YE halten die Bild-
breite sowie die Bildhhe fest. Ist das Bild kleiner, werden diese ent-
sprechend korrigiert, sind beide null, dann wird das Bild in seiner vollen
Gre geladen. Ist der Rckgabewert der Funktion < 0, ist ein Fehler
aufgetreten, andernfalls wird die Bildhhe zurckgeliefert.
Bei animierten GIFs wird das mit PicNr angegebene Bild gezeigt. Ist die
angegebe Bildnummer zu gro, wird das letzte Bild dargestellt; ist PicNr = 0
wird das erste Bild dargestellt. }
FUNCTION LoadFile_GIFanim(Name : STRING; PicNr : Word; X0, Y0, XE, YE : Integer) : Integer;

CONST MaxCodes : ARRAY [2..13] OF LongInt
               = (4, 8, 16, $20, $40, $80, $100, $200, $400, $800,
                  $1000, $2000);
      CodeMask : ARRAY [1..8] OF Byte
               = (1, 3, 7, 15, 31, 63, 127, 255);

TYPE tPrefix  = ARRAY [0..4096] OF Integer;
     tSuffix  = ARRAY [0..4096] OF Integer;
     tOutcode = ARRAY [0..1024] OF Integer;
     tPal     = ARRAY [0..255] OF LongInt;

VAR Prefix  : ^tPrefix;
    Suffix  : ^tSuffix;
    OutCode : ^tOutCode;

    Pal                   : ^tPal;
    Background            : Integer;
    Interlaced,
    Transparent           : Boolean;
    PicWidth, PicHeight,  { Hhe, Breite des gesamten Bildes }
    Width, Height,        { Hhe, Breite eines Einzelbildes }
    XStart, YStart        : Integer; { Startkoordinaten eines Einzelbildes }
    PicNum, PicHalt       : Word;
    Pass                  : Byte; { Interlaced }

    f       : tFil;
    XC, YC             : Integer;
    xx0, yy0, xxe, yye : Integer;

PROCEDURE Plot(C : Byte);
VAR x, y : Integer;
BEGIN
  If PicNum > PicHalt THEN Exit; { Alle Bilder bis zur Nr. "PicHalt" eines
                                   GIF-Files anzeigen. Die Bilder davor werden
                                   bentigt, da manche animierten Bilder sich
                                   in den Regionen, in denen sich das Bild
                                   nicht ndert, aus transparenten Bereichen
                                   zusammensetzen. }
  x := xx0 + XC + XStart;
  y := yy0 + YC + YStart;

  IF NOT Transparent THEN PutPixel(X, Y, Pal^[C])
  ELSE IF C <> BackGround THEN PutPixel(X, Y, Pal^[C]);

  { Update the X-coordinate, and if it overflows, update the Y-coordinate }
  Inc(XC);
  IF XC >= Width THEN
  BEGIN
    { If a non-interlaced picture, just increment YC to the next scan line.
      If it's interlaced, deal with the interlace as described in the GIF
      spec. Put the decoded scan line out to the screen if we haven't gone
      past the bottom of it }
    XC := 0;
    IF NOT Interlaced THEN Inc(YC)
    ELSE
      CASE Pass OF
        0 : BEGIN
              Inc(YC, 8);
              IF YC >= Height THEN
              BEGIN
                Inc(Pass);
                YC := 4;
              END;
            END;
        1 : BEGIN
              Inc(YC, 8);
              IF YC >= Height THEN
              BEGIN
                Inc(Pass);
                YC := 2;
              END;
            END;
        2 : BEGIN
              Inc(YC, 4);
              IF YC >= Height THEN
              BEGIN
                Inc(Pass);
                YC := 1;
              END;
            END;
        3 : Inc(YC, 2);
      END; { case }
  END;
END;


VAR TChar       : Integer;
    BitsIn      : Integer;
    BlockLength : Integer;

FUNCTION Gbit : integer;
BEGIN
  Inc(BitsIn);
  IF BitsIn = 8 THEN
  BEGIN
    TChar := GetByte(f);
    BitsIn := 0;
    IF (BlockLength = 0) THEN
    BEGIN
      BlockLength := TChar;
      TChar       := GetByte(f);
    END;
    Dec(BlockLength);
  END;
  IF (TChar AND (1 SHL BitsIn)) = 0 THEN Gbit := 0
                                    ELSE Gbit := 1;
END;

FUNCTION ReadCode (CodeSize : integer) : integer;
VAR aa   : Integer;
    Code : Integer;
BEGIN
  Code := 0;
  FOR aa := 0 TO (CodeSize - 1) DO
    Code := Code OR (Gbit SHL Aa);
  ReadCode := Code;
END;


FUNCTION GIFDecode(VAR F : tFil) : ShortInt;
LABEL NextImage;
VAR
  A, B, I               : Integer;
  dummy                 : Integer;
  BitsPerPixel          : Byte;
  ColorMap              : Boolean;
  CodeSize, ClearCode, EOFCode, FirstFree,
  FreeCode, InitCodeSize, Maxcode,
  Bitmask               : Integer;
  OutCount              : Integer;
  Code, CurCode, OldCode, FinChar,
  InCode                : Integer;
  Col                   : Coltype;
  SchleifenEnde         : Boolean;
BEGIN
  GetArray(f, PicWidth, 2);
  GetArray(f, PicHeight, 2);
  B            := GetByte(f);
  BitsPerPixel := (B AND 7) + 1;
  ColorMap     := B AND $80 = $80; { ColorMap TRUE/FALSE }

  Background := GetByte(f);
  IF GetByte(f) <> 0 THEN { skip byte of 0 }
  BEGIN
    GIFDecode := -2;
    Exit;
  END;

  IF ColorMap THEN
  BEGIN
    Col.Alpha := 0;
    FOR A := 0 TO (Integer(1) SHL BitsPerPixel) - 1 DO
    BEGIN
      Col.R := GetByte(f);
      Col.G := GetByte(f);
      Col.B := GetByte(f);
      Pal^[A] := LongInt(Col);
    END;
  END;

  PicNum := 0;

NextImage:
  Inc(PicNum);
  SchleifenEnde := False;
  REPEAT
    B := GetByte(f);
    CASE B OF
      $3B : BEGIN { Trailer }
              GIFDecode := 0;
              Exit; { Wir sind am Ende der Datei }
            END;
      $21 : BEGIN { Extension Introducer (EI) }
              CASE GetByte(f) OF { what label? }
                $F9 : BEGIN { Graphic Control Extension }
                        A := GetByte(f); { skip Block Size (value = 4) }
                        { get Transparent Flag (Transparent Flag TRUE/FALSE) }
                        Transparent := GetByte(f) AND $01 = $01;
                        GetByte(f); GetByte(f); { skip Delay Time }
                        BackGround := GetByte(f);
                        REPEAT UNTIL GetByte(f) = 0;
                      END;
                $FE : BEGIN { Skip Comment Extension }
                        REPEAT UNTIL GetByte(f) = 0;
                      END;
                $FF : BEGIN { Skip Application Extension }
                        A := GetByte(f); { Length of Application Identifier Block }
                        FOR I := 1 TO A DO GetByte(f); { Skip Application Identifier }
                        A := GetByte(f); { Length of Application Data }
                        WHILE A <> 0 DO { Skip Application Data, if A = 0 then Sub-Block Terminator }
                        BEGIN
                          FOR I := 1 TO A DO GetByte(f);
                          A := GetByte(f);
                        END;
                      END;
                $01 : BEGIN { Skip Plain text Extension }
                        A := GetByte(f); { BlockSize }
                        FOR I := 1 TO A DO GetByte(f);
                        REPEAT UNTIL GetByte(f) = 0;
                      END;
              END;
            END;
      $2C : BEGIN
              GetArray(f, XStart, 2); { Startpunkt im logischen Bild }
              GetArray(f, YStart, 2);
              GetArray(f, Width, 2);
              GetArray(f, Height, 2);
              A := GetByte(f);
              IF (A AND $80) = $80 THEN
              BEGIN
              { Local colormap encountered }
                GIFDecode := -2;
                Exit;
              END;
              Interlaced := (A AND $40) = $40; { Image is interlaced }
            END;
      $00 : ; { Null-Byte abfangen }
      ELSE BEGIN
        CodeSize := B;
        SchleifenEnde := True;
      END;
    END;
  UNTIL SchleifenEnde;

  ClearCode    := Integer(1) SHL CodeSize;
  EOFCode      := ClearCode + 1;
  FirstFree    := ClearCode + 2;
  FreeCode     := FirstFree;
  CodeSize     := CodeSize + 1;
  InitCodeSize := CodeSize;
  Maxcode      := MaxCodes[CodeSize];
  Bitmask      := CodeMask[BitsPerPixel];

  BlockLength  := 0; { Initialisierung der Variablen fr ReadCode }
  Bitsin       := 7;
  OutCount     := 0;

  Pass         := 0; { Interlace pass counter back to 0 }
  XC           := 0;
  YC           := 0;

  { Der eigentliche Decoder: }
  REPEAT
    Code := ReadCode(CodeSize);
    IF (Code <> EOFCode) THEN
    BEGIN
      IF (Code = ClearCode) THEN
      BEGIN
        CodeSize := InitCodeSize;
        Maxcode  := MaxCodes[CodeSize];
        FreeCode := FirstFree;
        Code     := ReadCode(CodeSize);
        CurCode  := Code;
        OldCode  := Code;
        FinChar  := (Code AND Bitmask);
        Plot(FinChar);
      END
      ELSE
      BEGIN
        CurCode := Code;
        InCode  := Code;
        IF (Code >= FreeCode) THEN
        BEGIN
          CurCode            := OldCode;
          Outcode^[OutCount] := FinChar;
          Inc(OutCount);
        END;
        IF (CurCode > Bitmask) THEN
        REPEAT
          Outcode^[OutCount] := Suffix^[CurCode];
          Inc(OutCount);
          CurCode := Prefix^[CurCode];
        UNTIL (CurCode <= Bitmask);
        FinChar           := (CurCode AND Bitmask);
        Outcode^[OutCount] := FinChar;
        Inc(OutCount);
        FOR i := (OutCount - 1) DOWNTO 0 DO
          Plot(Outcode^[i]);

        OutCount         := 0;
        Prefix^[FreeCode] := OldCode;
        Suffix^[FreeCode] := FinChar;
        OldCode          := InCode;
        Inc(FreeCode);
        IF (FreeCode >= Maxcode) THEN
          IF (CodeSize < 12) THEN
          BEGIN
            Inc(CodeSize);
            Maxcode := Maxcode SHL 1;
          END;
      END;
    END;
  UNTIL (Code = EOFCode);

  IF GetByte(f) = 0 THEN GOTO NextImage;

  GIFDecode := -4; { Ein nicht identifizierter Fehler ist aufgetreten }
END;

VAR IDStr : STRING;
    i     : Byte;
BEGIN
  IF NOT InitGetByte(f, Name) THEN
  BEGIN
    LoadFile_GIFanim := -1; { Dateifehler }
    Exit;
  END;

  IDStr := '';
  FOR i := 1 TO 6 DO IDStr := IDStr + Chr(GetByte(f));
  IF (IDStr <> 'GIF87a') AND (IDStr <> 'GIF89a') THEN
  BEGIN
    LoadFile_GIFanim := -2; { Keine GIF-Datei }
    Exit;
  END;

  New(Prefix);
  New(Suffix);
  New(OutCode);
  New(Pal);

  xx0 := X0; yy0 := Y0; xxe := XE; yye := YE;
  IF PicNr = 0 THEN PicHalt := 1
               ELSE PicHalt := PicNr;
  i := GIFDecode(f);

  Dispose(Prefix);
  Dispose(Suffix);
  Dispose(OutCode);
  Dispose(Pal);

  IF i <> 0 THEN
  BEGIN
    LoadFile_GIFanim := -2; { Keine GIF-Datei }
    Exit;
  END;

  OutGetByte(f); { schliee Datei }
  LoadFile_GIFanim := 0;
END;




{ Funktion wie oben. Um kompatibel mit den anderen LoadFile-Routinen zu
bleiben, wird bei animierten GIFs die Darstellung auf das erste Bild be-
schrnkt. }
FUNCTION LoadFile_GIF(Name : STRING; X0, Y0, XE, YE : Integer) : Integer;
BEGIN
  LoadFile_GIF := LoadFile_GIFanim(Name, 0, X0, Y0, XE, YE);
END;
