/*
 * This file is part of the Zmiy project.
 * Copyright (C) 2013-2015 Mateusz Viste
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 */

#ifndef lowlevelio
  #define lowlevelio

  #define MILISLEEP_LOOP 0
  #define MILISLEEP_APM 1
  #define MILISLEEP_DOS 2
  #define MILISLEEP_DPMI 3
  #define MILISLEEP_BIOS 4

  void cursor_set(int startscanline, int endscanline);
  void printchar(int column, int row, char c, unsigned short attr);
  int getkey(void);
  int getkey_ifany(void);
  int detectvga(void);
  int getcurvideomode(void);
  void setvideomode(int mode);
  void setvideomode_80(int rows);
  void milisleep(int ms, int meth);
  void scrollscreen(int offset);
#endif
