////////////////////////////////////////////////////////////////////////////////
//
//	Listview - Header File
//
//	(c) Copyright 2003,2004 Point Mad, Lukas Lipka. All rights reserved.
//
////////////////////////////////////////////////////////////////////////////////

#ifndef _LISTVIEW_H_INCLUDED_
#define _LISTVIEW_H_INCLUDED_

#include "widget.h"
#include "scrollbar.h"
#include "menu.h"

#define LISTVIEW(w) ((PListview)(w))
#define LISTVIEWITEM(w) ((PListviewItem)(w))

typedef struct TListviewItem *PListviewItem;
typedef struct TListviewItem
{
	char* Caption;
	BITMAP* Icon32;
	BITMAP* Icon16;

	TRect BufAbs;
	TRect BufTop;

	l_ulong Flags;	
	
} TListviewItem;


#define LVI_SELECTED 0x01
#define LVI_FREEICON 0x02
#define LVI_FREEICON 0x02




typedef struct TListview *PListview;
typedef struct TListview
{
	struct	TScrollWidget o;

	PList Items;
/*
	void (*AddItem) ( PListview o, char* Caption, BITMAP* Icon );
	void (*RemoveAllItems) ( PListview o );

	*/

	PMenu (*GenerateItemMenu) ( PListview , PListviewItem );


	/*
	l_ulong OnSelectMsg;
	l_ulong OnDblClickMsg;

	*/

	l_ulong OnSelMsg;
	l_ulong OnValMsg;
	l_ulong OnRClkMsg;
	
	
	l_ulong Style;

	
	PListviewItem TopItem;
	
} TListview;


#define LVS_ICONS 0x00
#define LVS_LIST  0x01


PListview CreateListview( PApplication App, TRect r );
PListview InitListview( PListview p, PApplication App, TRect r );

PListviewItem ListviewAddItem ( PListview o, char* Caption, BITMAP* Ico32, BITMAP* Ico16 );

void ListviewRemoveAllItems ( PListview o );

l_bool ListviewEventHandler ( PWidget o, PEvent Ev );

PListviewItem GetSelectedItem ( PListview o );

void ListviewSelectItem ( PListview o, PListviewItem p, l_bool Scroll, l_bool Multi );


void ListviewSelectIndex ( PListview o, l_ulong Index, l_bool Scroll, l_bool Multi );
void ListviewSelectItemAndTell ( PListview o, PListviewItem p, l_bool Scrol, l_bool Multi );

l_ulong ListviewItemIndex ( PListview o, PListviewItem a );
PListItem GetSelectedListItem ( PListview o );
l_text ListviewRenameItemBox ( PListview o, PListviewItem a );


#endif /* _LISTVIEW_H_INCLUDED_ */
