#include "kernel.h"
#include "widget.h"
#include "groupbox.h"

l_ulong	UID = ULONG_ID('G','R','P','B');
l_ulong	AppVersion = ULONG_ID(0,0,0,1);
l_char	AppName[] = "Groupbox Widget";
l_uid	nUID = "groupbox";
l_uid NeededLibs[] = { "widget", "skin","" };

PSkin SkinGroupbox = 0;

void GroupboxDraw ( PWidget o, p_bitmap buffer, PRect w )
{
	DrawSkin(buffer, SkinGroupbox, o->Absolute.a.x, o->Absolute.a.y, o->Absolute.b.x, o->Absolute.b.y);

	rectfill(buffer, o->Absolute.a.x+10, o->Absolute.a.y+1, o->Absolute.a.x+20+text_length(SkinGroupbox->Font, GROUPBOX(o)->Caption), o->Absolute.a.y+2+text_height(SkinGroupbox->Font), getpixel(SkinGroupbox->Skin, SkinGroupbox->Skin->w/2, SkinGroupbox->Skin->h/2));
	textout(buffer, SkinGroupbox->Font, GROUPBOX(o)->Caption, o->Absolute.a.x+18, o->Absolute.a.y+1, SkinGroupbox->FontColor);
}

l_bool GroupboxEventHandler ( PWidget o, PEvent Ev )
{
	return false;
}

PGroupbox CreateGroupbox( PApplication App, TRect r, l_text Caption)
{
	PGroupbox p = malloc(sizeof(TGroupbox));

	if (!p) return NULL;

	memset(p, 0, sizeof(TGroupbox));

	p->Caption = (l_text)strdup(Caption);

	IntialiseWidget(App, WIDGET(p), r, "Groupbox");

	WIDGET(p)->Draw = &GroupboxDraw;
	WIDGET(p)->EventHandler = &GroupboxEventHandler;

	return p;
}

l_bool LibMain ( l_text Args )
{
	SkinGroupbox = GetSkinItem("Groupbox");

	APPEXPORT(CreateGroupbox);

	return true;
}

void Close (void)
{

}
