// This program was written by Jrgen Hoffmann in the year 2009
// and compiled under Borland C++ Version 3.1
// using the Compact model and the "Compile via assembler" option
//
#include <dos.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <conio.h>

#define MAXBUFS     8  	                /* maximum number of Ethernet buffers */
#define BPMASK      7
#define BUFSIZE     1520

#define DOS         0x21
#define GETVECT     0x35

#define INT_FIRST 0x60
#define INT_LAST  0x80
#define PD_DRIVER_INFO	0x1ff
#define PD_ACCESS 	0x200
#define PD_RELEASE	0x300
#define PD_SEND 	0x400
#define PD_GET_ADDRESS	0x600
#define PD_RESET        0x700
#define PD_SET_MODE	0x1400
#define CARRY 		1	        /* carry bit in flags register */

#if defined __TINY__
#define MEMORY_MODEL	"ti"
#elif defined __SMALL__
#define MEMORY_MODEL	"sm"
#elif defined __MEDIUM__
#define MEMORY_MODEL	"me"
#elif defined __COMPACT__
#define MEMORY_MODEL	"co"
#elif defined __LARGE__
#define MEMORY_MODEL	"la"
#else
#define MEMORY_MODEL	"??"
#endif

char *version  = "V1.2";

typedef unsigned short word;            /* 16 bits */
typedef unsigned char  byte;            /*  8 bits */

#define TABLESIZE 10
typedef byte ethernet_address[6];
typedef struct {
  ethernet_address adr[TABLESIZE];
  } address_table;
typedef struct {
  unsigned long src[TABLESIZE+1];
  } table_row;
typedef struct {
  table_row *dst[TABLESIZE+1];
  } table_column;

ethernet_address broadcast = { 0XFF,0XFF,0XFF,0XFF,0XFF,0XFF };
word table_fill   = 0;
word table_size   = TABLESIZE;
address_table *ad = NULL;
table_column  *tbl;

#define SCRCOLS   9
#define SCRROWS  18

byte lcnt      = 0;
char life[6]   = "-\\|/";
word col0      = 1;
word col1;
word row0      = 0;
word row1;
byte byte_mode = 0;
byte proc_mode = 0;
byte scrl_flg  = 0;
byte left_col  = 1;

// forwards and externs
char *eadr2asc(unsigned char *p, int mode);

unsigned long  last_time;
unsigned long  curr_time;
unsigned long *timer = (unsigned long *)MK_FP(0X0040,0X006C);
byte  update = 0;

char  sep_char   = ',';
byte  write_file = 0;
FILE *outfil;
char  filnam[82] = ".\\ETHWHO.CSV";

byte  capabilities;
word  int_first  = INT_FIRST;
word  int_last   = INT_LAST;
word  pkt_interrupt;
word  pkt_type   = 0XFFFF;                /* any tape */
word  pkt_handle;
ethernet_address eth_addr;
char *pkt_line   = "PKT DRVR";
byte  old_driver = 0;

typedef struct {
  word  pkt_len;
  byte  pkt_data[BUFSIZE];
  } pkt_buffer;

byte          overflow  = 0;
unsigned long totl_byte = 0L;
unsigned long pkt_found = 0L;
unsigned long pkt_read  = 0L;
unsigned long pkt_lost  = 0L;
word  pkt_get           = 0;
word  pkt_put           = 0;
word  pkt_seq           = 0;
pkt_buffer pb[MAXBUFS];

// compiled with Borland C++  3.1
// with "Compile via assembler" option
// in Options | Compiler | Code generation ...
void far pkt_callback(void) {
  asm {
    pop  di; // compensate for compiler generated PUSH DI / POP DI
    push ds;                   // save driver's data segment
    mov  di,DGROUP;            // NOT in huge model !!!
    mov  ds,di;                // set C's data segment
    }
  disable();
  if(_AX) {
    pb[pkt_put & BPMASK].pkt_len |= 0X8000;
    pkt_put++;
    }
  else {
    pkt_found++;
    if(pb[pkt_put & BPMASK].pkt_len || _CX >= BUFSIZE) {
      _ES = 0;
      _DI = 0;
      }
    else {
      pb[pkt_put & BPMASK].pkt_len = _CX;
      _ES = FP_SEG(pb[pkt_put & BPMASK].pkt_data);
      _DI = FP_OFF(pb[pkt_put & BPMASK].pkt_data);
      }
    }
  enable();
  asm {
    pop  ds; // restore driver's data segment
    push di; // compensate for compiler generated PUSH DI / POP DI
    }
  }

int pkt_init(void) {
  struct REGPACK regs;
  char far *temp;
  int pd_type;	                /* packet driver type */
  int pd_class;
  for (pkt_interrupt = int_first; pkt_interrupt <= int_last; ++pkt_interrupt ) {
    temp = (char far *)getvect( pkt_interrupt );
    if (!_fmemcmp( &(temp[3]), pkt_line, strlen( pkt_line ))) break;
    }
  if ( pkt_interrupt > int_last ) {
    printf("NO PACKET DRIVER FOUND ");
    if(int_first==int_last) printf("AT INTERRUPT 0x%02X\n",int_first);
    else printf("IN RANGE 0x%02X .. 0x%02X\n",int_first,int_last);
    exit(2);
    }

  /* lets find out about the driver */
  regs.r_ax = PD_DRIVER_INFO;
  intr( pkt_interrupt, &regs );
  capabilities = regs.r_ax & 7;

  /* handle old versions, assume a class and just keep trying */
  if (regs.r_flags & CARRY ) {
    for ( pd_class = 0; pd_class < 19; ++pd_class ) {
      for (pd_type = 1; pd_type < 128; ++pd_type ) {
	regs.r_ax = PD_ACCESS | pd_class;  /* ETH, SLIP */
	regs.r_bx = pd_type;		     /* type */
	regs.r_dx = 0;		     /* if number */
	regs.r_cx = 0;                     // sizeof( pkt_type);
	regs.r_ds = FP_SEG( &pkt_type );
	regs.r_si = FP_OFF( &pkt_type );
	regs.r_es = FP_SEG( pkt_callback );
	regs.r_di = FP_OFF( pkt_callback );
	intr( pkt_interrupt, &regs );
	if ( ! (regs.r_flags & CARRY) ) break;
	}

      if (pd_type < 128 ) {
	/* get ethernet address */
	regs.r_ax = PD_GET_ADDRESS;
	regs.r_bx = regs.r_ax;	/* handle */
	regs.r_es = FP_SEG( eth_addr );
	regs.r_di = FP_OFF( eth_addr );
	regs.r_cx = sizeof( eth_addr );
	intr( pkt_interrupt, &regs );
	/* we have found a working type, so kill it */
	regs.r_ax = PD_RELEASE;
	intr( pkt_interrupt, &regs );
	old_driver++;
	printf("Found OLD type of packet driver\n");
	break;
	}

      if ((pd_type == 128 ) && (pd_class > 18)) {
	printf("ERROR initializing packet driver\n\r");
	return( 1 );
	}
      }
    }
  else {
    pd_type = regs.r_dx;
    pd_class = regs.r_cx >> 8;
    /* get ethernet address */
    regs.r_ax = PD_GET_ADDRESS;
    regs.r_bx = 0;
    regs.r_es = FP_SEG( eth_addr );
    regs.r_di = FP_OFF( eth_addr );
    regs.r_cx = sizeof( eth_addr );
    intr( pkt_interrupt, &regs );
    printf("Found packet driver with basic ");
    switch (capabilities) {
      case 2:
      case 6: printf("and extended ");
	      if(capabilities==2) break;
      case 5: printf("and high-performance ");
      }
    printf("functions\n");
    }
  printf("Vector=%02X class=%d type=%d ethernet address=%s\n",
	    pkt_interrupt, pd_class, pd_type, eadr2asc(eth_addr,0));

  regs.r_ax = PD_ACCESS | pd_class;
  regs.r_bx = pd_type;                // any type
  regs.r_dx = 0;			// if number
  regs.r_cx = 0;                      // sizeof( pkt_type );
  regs.r_ds = FP_SEG( &pkt_type );
  regs.r_si = FP_OFF( &pkt_type );
  regs.r_es = FP_SEG( pkt_callback );
  regs.r_di = FP_OFF( pkt_callback );
  intr( pkt_interrupt, &regs );
  if(regs.r_flags & CARRY) {
    printf("ERROR #%02X accessing packet driver\n",(regs.r_dx>>8));
    return( 1 );
    }
  pkt_handle = regs.r_ax;
  return( 0 );
  }

void pkt_setmode(int mode) {
  struct REGPACK regs;
  // get ethernet address
  regs.r_ax = PD_SET_MODE;
  regs.r_bx = pkt_handle;
  regs.r_cx = mode;
  intr( pkt_interrupt, &regs );
  if(regs.r_flags & CARRY) printf("WARNING cannot set driver into mode: %d\n",mode);
  }

void pkt_release(void) {
  struct REGPACK regs;
  int error;
  regs.r_ax = PD_RELEASE;
  regs.r_bx = pkt_handle;
  intr( pkt_interrupt, &regs );
  if (regs.r_flags & CARRY ) printf("ERROR releasing packet driver\n");
  return;
  }

int pkt_send( char *buffer, int length ) {
  struct REGPACK regs;
  int retries;

  retries = 5;
  while (retries--) {
    regs.r_ax = PD_SEND;
    regs.r_ds = FP_SEG( buffer );
    regs.r_si = FP_OFF( buffer );
    regs.r_cx = length;
    intr( pkt_interrupt, &regs );
    if ( regs.r_flags & CARRY ) continue;
    return( 0 );
    }
  return( 1 );
  }


//---------------------------------------------------------------

char *eadr2asc(unsigned char *p, int mode) {
  static char outbuf[20];
  char *p2;
  int i;
  for(i=0, p2=outbuf; i<6; i++, p++) {
    if(mode) {
      sprintf(p2,"%02X",*p);
      p2 += 2;
      if(i==2) *p2++ = ':';
      }
    else {
      sprintf(p2,"%02X:",*p);
      p2 += 3;
      }
    }
  if(!mode) p2--;
  *p2 = '\0';
  if(mode==2) outbuf[6]='\0';
  if(mode==3) return(&outbuf[7]);
  else return(outbuf);
  }

word htoi(char *p, int count) {
  int i;
  for(i=0; *p && count; p++,count--) {
    if(!isxdigit(*p)) break;
    i <<= 4;
    if(isdigit(*p)) i |= (*p&0x0F);
    else i |= ((*p&0X0F) + 9);
    }
  return(i);
  }

void get_eth_addr(char *p, byte *d) {
  int i;
  for(i=0; *p && i < 6; i++) {
    *d++ = htoi(p,2);
    if(*++p) p++;
    if((*p==':')||(*p=='-')) p++;
    }
  }

word swap(word arg) {
  return((arg & 0xFF00) >> 8) | ((arg & 0xFF) << 8);
  }

//---------------------------------------------------------------

void write_outfile(void) {
  int i,j;
  if(byte_mode) fprintf(outfil,"total_bytes:%ld",totl_byte);
  else fprintf(outfil,"total_packets:%ld",pkt_found);
  for(i=left_col; i<table_fill; i++) fprintf(outfil,"%c%s",sep_char,(!i)?"broadcast":((i<table_size)?eadr2asc(ad->adr[i],1):"others"));
  fprintf(outfil,"\n");
  for(j=0; j<table_fill; j++) {
    if(!j) fprintf(outfil,"broadcast");
    else if(j==table_size) fprintf(outfil,"others");
    else fprintf(outfil,"%s",eadr2asc(ad->adr[j],1));
    for(i=left_col; i<table_fill; i++) fprintf(outfil,"%c%ld",sep_char,tbl->dst[j]->src[i]);
    fprintf(outfil,"\n");
    }
  }

char *outnum(unsigned long num, int mode) {
  static char tmp[10];
  if(!mode) sprintf(tmp,"%6ld",(num>999999L)?999999:num);
  else {
    if(num<99999L) sprintf(tmp,"%6ld",num);
    else {
      num >>= 10;
      if(num<9999L) sprintf(tmp,"%5ldK",num);
      else {
	num >>= 10;
	 sprintf(tmp,"%5ldM",num);
	}
      }
    }
  return(tmp);
  }

char *outproc(unsigned long num, unsigned long ref) {
  static char tmp[10];
  int proc;
  if(num<0X01000000L) num *= 100;
  else ref /= 100;
  proc = num / ref;
  if(proc) sprintf(tmp,"%d%",proc);
  else if(num>0L) sprintf(tmp,"<1%");
  else sprintf(tmp,"0%");
  return(tmp);
  }

void show_table(void) {
  int i,j;
  unsigned long lt;
  clrscr();
  printf("%s ",overflow?"OVERFOLW":"Total");
  if(byte_mode) printf("bytes %s   ",outnum(totl_byte,1));
  printf("packets: %-8ld (%s lost)\n\n",pkt_found,outproc(pkt_lost,pkt_found));
  printf("to%11s","from--");
  col1 = col0 + SCRCOLS;
  if(col1 > table_fill) col1 = table_fill;
  row1 = row0 + SCRROWS;
  if(row1 > table_fill) row1 = table_fill;
  for(i=col0; i<col1; i++) printf("%7s",(!i)?"broad ":((i<table_size)?eadr2asc(ad->adr[i],2):""));
  printf("\n%-13s","|");
  for(i=col0; i<col1; i++) printf("%7s",(!i)?"  cast":((i<table_size)?eadr2asc(ad->adr[i],3):"others"));
  printf("\n");
  for(j=row0; j<row1; j++) {
    if(!j) printf("broadcast adr");
    else if(j==table_size) printf("%13s","others");
    else printf("%-13s",eadr2asc(ad->adr[j],1));
    for(i=col0; i<col1; i++) {
      lt=tbl->dst[j]->src[i];
      if(i != j) {
	if(!proc_mode) printf(" %s",outnum(lt,byte_mode));
	else if(!byte_mode) printf(" %6s",outproc(lt,pkt_found));
	else printf(" %6s",outproc(lt,totl_byte));
	}
      else if(lt > 0L) {
	if(!proc_mode) printf(" %s",outnum(lt,byte_mode));
	else if(!byte_mode) printf(" %6s",outproc(lt,pkt_found));
	else printf(" %5d%%",outproc(lt,totl_byte));
	}
      else printf("%7s","");
      }
    printf("\n");
    }
  if(table_fill > (col0+SCRCOLS)) scrl_flg = 1;
  printf("\n%c  %s<TAB> toggles display  <ESC> terminates\r",life[lcnt],scrl_flg?"<cursor keys> scroll  ":"");
  }

int adr2idx(byte *p) {
  int i;
  for(i=0; i<table_fill; i++)
    if(!memcmp(p,ad->adr[i],sizeof(ethernet_address))) return(i);
  if(table_fill < table_size) {
    memcpy(ad->adr[table_fill++],p,sizeof(ethernet_address));
    return(table_fill-1);
    }
  else {
    table_fill = table_size+1;
    return(table_size);
    }
  }

void process_packet(pkt_buffer *pb) {
  unsigned long hlp;
  int i,j,pl;
  word dst, src;
  if(overflow) return;
  dst = adr2idx(pb->pkt_data);
  src = adr2idx(&pb->pkt_data[6]);
  if(!src) left_col = col0 = 0;
  if(!byte_mode) tbl->dst[dst]->src[src]++;
  else {
    i = pb->pkt_len & 0X7FFF;
    hlp = totl_byte;
    totl_byte += i;
    if(totl_byte<hlp) {
      totl_byte = hlp;
      overflow = 1;
      }
    tbl->dst[dst]->src[src] += i;
    }
  pkt_read++;
  if(pkt_read>0XFFFFFFF0L) overflow = 1;
  update++;
  }

void help_text(void) {
  printf("\n\n\n");
  printf("  ETHWHO %s%s by Jrgen Hoffmann (2009) j_hoff@hrz1.hrz.tu-darmstadt.de\n\n",version,MEMORY_MODEL);
  printf("  usage: ethwho [ options ] [ ethernet_address ... ]\n\n");
  printf("  valid options:\n");
  printf("    /I<int> define packet driver interrupt  (default: automatic)\n");
  printf("    /T<num> define table size               (default: 9)\n");
  printf("    /F[fil] write results to CSV-file \"fil\" (default: .\\ETHWHO.CSV)\n");
  printf("    /C<chr> use <chr> as field separator    (default: \"%c\")\n",sep_char);
  printf("    /B      count transmitted bytes         (default: count packets)\n");
  printf("    /h /?   print this help text\n\n");
  printf("  optional ethernet_address(es) preset the address table with\n");
  printf("  defined values and cause them to appear first in the display\n\n");
  }


void main(int argc, char *argv[]) {
  int  i,j,ch;
  char *p;

  for(i = 1; i < argc; i++)
    if(*argv[i]=='-' || *argv[i]=='/') {
      p = argv[i];
      switch(toupper(p[1])) {
	case 'I': if(isdigit(p[2])) {
		    if(toupper(p[3])=='X') int_first = htoi(&p[4],2);
		    else int_first = atoi(&p[2]);
		    int_last = int_first;
		    }                                               break;
	case 'T': if(isdigit(p[2])) {
		    j = atoi(&p[2]);
		    if((j > 2) && (j < 0X7FFE)) table_size = j+1;
		    }                                               break;
	case 'F': if(p[2]) strncpy(filnam,&p[2],80); write_file++;  break;
	case 'C': if(toupper(p[2])=='T') sep_char=9; // <TAB>
		  else if(isgraph(p[2])&&!isalnum(p[2])&&(p[2]!=':'))
						    sep_char=p[2];  break;
        case 'B': byte_mode = 1;                                    break;
	case 'H':
	case '?': help_text(); exit(1);
	} /* switch */
      } /* if */
  pkt_init();
  pkt_setmode(6);

  if((ad=calloc(table_size,sizeof(ethernet_address)))==NULL) {
    printf("ERROR cannot allocate address table\n");
    exit(2);
    }
  else memcpy(&ad->adr[table_fill++],broadcast,sizeof(ethernet_address));
  if((tbl=calloc(table_size+1,sizeof(void *)))==NULL) {
    printf("ERROR cannot allocate statistics table\n");
    exit(2);
    }
  else for(i=0; i<=table_size; i++) {
    if((tbl->dst[i]=calloc(table_size+1,sizeof(unsigned long)))==NULL) {
      printf("ERROR cannot allocate table row\n");
      exit(2);
      }
    else for(j=0; j<=table_size; j++) tbl->dst[i]->src[j] = 0L;
    }
  for(i = 1; i < argc; i++) if(isxdigit(*argv[i])) {
    if(table_fill < table_size) get_eth_addr(argv[i],ad->adr[table_fill++]);
    }
  printf("Counting %s, the internal tables can hold %d addresses\n",
			 (byte_mode)?"bytes":"packets",table_size-1);
  if(write_file) {
    if(NULL==(outfil=fopen(filnam,"w")))
      printf("ERROR: cannot create file: %s\n",filnam);
      else printf("Writing data to file: %s\n",filnam);
    }
  printf("\n");
  last_time = *timer&0XFFFFFFE0L;
  ch = 0;
  printf("  No packets yet, press <ESC> to terminate ...\r");

  do {
    if(pb[pkt_get & BPMASK].pkt_len&0x8000) {
      process_packet(&pb[pkt_get & BPMASK]);
      pb[pkt_get & BPMASK].pkt_len = 0;
      pkt_get++;
      if(pkt_get >= pkt_put) {
	pkt_lost = pkt_found - pkt_read;
	pkt_get &= BPMASK;
	pkt_put &= BPMASK;
	}
      }
    if((curr_time=*timer&0XFFFFFFE0L)!=last_time) {
      last_time = curr_time;
      if(update) {
	show_table();
	update = 0;
	}
      else printf("%c\r",life[lcnt]);
      lcnt++;
      lcnt &= 3;
      }
    if(kbhit()) {
      ch = getch();
      if(!ch) {
	ch = getch();
	switch (ch) {
	  case 0X47: col0=left_col; row0=0;                update++; break; // cursor home
	  case 0X48: if(row0>0) row0--;                    update++; break; // cursor up
	  case 0X4B: if(col0>left_col) col0--;             update++; break; // cursor left
	  case 0X4D: if((col0+SCRCOLS)<table_fill) col0++; update++; break; // cursor right
	  case 0X50: if((row0+SCRROWS)<table_fill) row0++; update++; break; // cursor down
	  }
	if(update) last_time = 0L;
	}
      else if(ch==9) { proc_mode = !proc_mode; update++; last_time = 0L; }
      }
    } while(ch != 27);
  printf("%-75s\r","");
  if(write_file) write_outfile();

  pkt_setmode(3);
  pkt_release();
  }



