/*
    Template for local message declaration file for msgComp
    Copyright (C) 1995 Steffen Kaiser

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/


/* $RCSfile: cdp_inst.c $
   $Locker: ska $	$Name:  $	$State: Exp $

	Patchen des CDP.COM Programms

   $Log: cdp_inst.c $
   Revision 1.1  1996/02/08 11:25:02  ska
   Initial revision

*/

#include <stdio.h>
#include <file.h>
#include <freedos.h>
#include "decrypt.h"
#include "..\cdp.h"
#include "yerror.h"

#ifndef lint
static char rcsid[] = 
	"$Id: cdp_inst.c 1.1 1996/02/08 11:25:02 ska Exp ska $";
#endif

unsigned char comName[] = "CDP.COM";
unsigned char prgName[] = PRGNAME;
unsigned char drvName[] = "MSCD001";
unsigned char defName[9] = "";
unsigned char defUnit = 0;
unsigned char buf[1024];
char nam[100];
char *dName = NULL;
char tmpName[] = "00000000";
unsigned char appGroup[] = GRSKAUS;

void ff(void)
{	fatal(E_noCDP, comName, comName, appName(), comName);
}

/* void rr(char *buf, int len, FILE *fp, char *nam)
{	if(fget(buf, len, fp) != len)
		error(E_readFile, nam);
}
*/

/*void ww(char *buf, int len, FILE *fp, char *nam)
{	if(fput(buf, len, fp) != len)
		error(E_writeFile, nam);
}
*/
void lww(char *buf, int len, FILE *fp, char *nam)
{	if(write(buf, len, fp->FILE_handle))
		error(E_writeFile, nam);
}

void Lfseek(FILE *fp, int off, char *nam)
{	if(fseek(fp, off < 0? -1: 0, off, 1))
		fatal(E_readFile, nam);
}

int exists(char *s)
{	struct FF_block ff;

	return !findfirst(s, ff, 0x3f);
}

int locate(FILE *fp, unsigned char *str, unsigned len)
{	int c;
	unsigned l;

	rewind(fp);
	l = 0;
	while((c = getc(fp)) != EOF)
		if(c == str[l]) {
			if(++l >= len) return 0;		/* found */
		}
		else {
			if(l) Lfseek(fp, -l, comName);
			l = 0;
		}
	return 1;
}

searchMap(FILE *fp, unsigned char *str, int mode, unsigned len)
{	if(locate(fp, str, len))
		if(mode) ff();
}

search(FILE *fp, char *s, int mode)
{	searchMap(fp, s, mode, strlen(s)); }

chkCopy(FILE *fp)
{	char *p;

	p = strchr(prgName, ' ');
	p = strchr(p + 1, ' ');
	*p = 0;
	search(fp, prgName, 1);
	search(fp, strchr(p+1, ' '), 2);
}

void getApp(FILE *fp, unsigned char *grp)
{	int c;
	char *p;

	if(locate(fp, grp, strlen(grp)))
		ff();
	Lfseek(fp, -strlen(grp), comName);
	p = buf;
	while(*p++ = (c = getc(fp)))
		if(c == EOF)
			error(E_readFile, comName);
}

FILE *copyCOM(FILE *fin, char *path, int mode)
{	char *p;
	FILE *fp;
	int h, l, d, x;
	char yes, no;
	MSGID msg;

	/* determine, if we are in the same directory */
	do {
		concat(nam, path, "\\", tmpName);
		if(!exists(tmpName) && !exists(nam) && (fp = fopen(nam, "wab"))) {
			fseek(fp, 0, 0, 2);
			d = ftell(fp, &h, &l) || h || l;
			fclose(fp);
			x = exists(tmpName);
			if(!d) unlink(nam);
			if(x) fatal(E_sameDir);
			msg = msgLock(M_yes);
			yes = tolower(*msg);
			msgUnlock(msg);
			msg = msgLock(M_no);
			no = tolower(*msg);
			msgUnlock(msg);

			/* OK copy now */
			concat(nam, path, "\\", mode == 'E'? "EJECTCD.COM":
					mode == 'C'? "CLOSECD.COM": "CDP.COM");
			if(isatty(fileno(stdout)) && exists(nam)) {
				do {
					message(stdout, W_exists, appName(), nam);
					h = tolower(kbget());
					putchar('\n');
				} while(h != yes && h != no);
				putchar('\n');
				if(h == no) fatal(E_UserBreak);
			}

			if((fp = fopen(nam, "wb")) <= 0)
				error(E_openFile, nam);
			rewind(fin);
			while((h = fget(buf, sizeof(buf), fin)) > 0)
				if(fput(buf, h, fp) != h)
					error(E_writeFile, nam);
			fclose(fin);
			fflush(fp);			/* empty internal buffer */
			fp->FILE_options &= ~(F_WRITE | F_APPEND);	/* turn off write permission & disable write of internal buffer */
			fp->FILE_options |= F_READ;
			return fp;
		}
		/* try next name */
		p = tmpName + sizeof(tmpName)-2;
mkNameZyk:
		if(++*p > 'Z') {
			*p = '0';
			if(--p < tmpName) fatal(E_internalFailure, 1);
			goto mkNameZyk;
		}
		if(*p > '9') *p = 'A';
	} while(1);
}

void chkDefCDrom(void)
{	struct {
		unsigned char subunit;
		dword addr;
	} drives[32];
	char drvNam[9];
	unsigned i, j;
	FLAG found;
	unsigned first, nr;

	found = 0;
	asm {		/* check if MSCDEX is installed */
		mov  AX,0DADAh
		push AX
		mov  AX,01100h
		int  2Fh
		pop  BX
		cmp  BX,0ADADh
		je  MSCDEX
		xor al, al
MSCDEX:
	}
	if((nargs() & 0xff) == 0xff) {		/* MSCDEX installed */
		asm {
			mov  AX,1500H
			xor  BX,BX
			int  2FH
			/* BX := #drives; CX := first CD-ROM drive */
			mov -2[bp], bx
			mov -4[bp], cx
		}
		if(nargs() != 0xffff && nr != 0) {
			drives;
			asm {
				mov bx, ax ;			/* destination address */
				mov ax, ds
				mov es, ax
				mov  AX,1501h ;		/* ask code */
				int  2Fh
			}
			for(i = 0; i < nr; ++i) {
				copy_seg(get_ds(), drvNam, drives[i].addr.hi
				 , drives[i].addr.lo + 10, 8);
				drvNam[8] = 0;
				informative(M_foundCD, drvNam, drives[i].subunit);
			}
			copy_seg(get_ds(), defName, drives[0].addr.hi
			 , drives[0].addr.lo + 10, 8);
			defName[8] = 0;
			dName = defName;
			defUnit = drives[0].subunit;
			found = 1;
		}
	}
	/* try to determine the CD-ROM driver */
	asm {
		mov ah, 52h
		int 21h
		mov -2[bp], bx ;		/* nr */
		mov -4[bp], es ;		/* es */
	}
	if((j = version()) < 0x300) nr += 0x17;
	else if(j > 0x301) nr += 0x22;
	else nr += 0x28;
	/* first:nr -> NUL device */
	j = 1;
	while((i = peekw(first, nr)) != 0xffff) {
		first = peekw(first, nr + 2);	/* advance to next driver */
		nr = i;
		if((peekb(first, nr + 5) & 0x80) != 0	/* charcter device */
		 && peekb(first, nr + 0x15) > 0		/* supported subunits */
		 && peekb(first, nr + 0x15) < 32) {
			copy_seg(get_ds(), drvNam, first, nr + 10, 8);
			drvNam[8] = 0;
			if(!peekw(first, nr + 0x12)		/* must be zero */
			 && peekb(first, nr + 0x14) < 32
			 || strstr(drvNam, "CD0")) {	/* drive letter */
				if(j) {
					informative(M_possibleCDs);
					j = 0;
					found = 1;
				}
				informative(M_cdDrv, drvNam, peekb(first, nr + 0x15));
			}
		}
	}
	if(!found)
		informative(M_noDefDrv);
}

main(int argc, char **argv)
{	FILE *fcdp;
	unsigned len;
	int autoUnlock, drvUnit, name, c;

	autoUnlock = name = 0;
	drvUnit = 0xffff;
	dName = drvName;

	msgInit();

	chkDefCDrom();
	informative(M_defCDrom, dName, defUnit);

	while((c = getopt1(argc, argv, "?ACEHI", "DU")) != EOF) switch(c) {
		case 'A': 	autoUnlock = 1; break;
		case 'D':	if((dName = optarg) == NULL)
						dName = *defName? defName: drvName;
					break;
		case 'U':	if(optarg) {
						if(strlen(optarg) != strspn(optarg, "0123456789"))
							error(E_numOpt, argv[optind]);
						drvUnit = atoi(optarg);
					}
					else drvUnit = 0xffff;
					break;
		case 'E':	name = 'E'; break;	/* eject */
		case 'C':	name = 'C';	break;	/* close */
		case 'I':	exit(0);
		default:	hlpScreen();
	}

	if(dName && strlen(dName) > 8)
		error(E_lenDrv);

	if(!argv[optind] || argv[optind + 1])
		hlpScreen();

	if(!dName) dName = *defName? defName: drvName;
	if(drvUnit == 0xffff) drvUnit = defUnit;

	/* Try to identify if cdp.com is valid */
	if((fcdp = fopen(comName, "rb")) == NULL)
		fatal(E_openFile, comName);

	chkCopy(fcdp);
	decrypt(appGroup, CRYPT_GROUP);
	getApp(fcdp, appGroup);
	len = crypt(buf, CRYPT_APPLICATION);
	searchMap(fcdp, buf, 5, len);

	fcdp = copyCOM(fcdp, argv[optind], name);

	if(locate(fcdp, drvName, sizeof(drvName)))
		fatal(E_copy);

	Lfseek(fcdp, -(sizeof(drvName) + 4), nam);
	lww(autoUnlock? "\1": "\0", 2, fcdp, nam);
	lww(&drvUnit, 2, fcdp, nam);
	lww(dName, 9, fcdp, nam);
	
	fclose(fcdp);
	informative(M_copied, nam, dName, drvUnit, (autoUnlock? M_yes: M_no),
		GSKAUS);
}

void hlpScreen(void)
{	message(stdout, E_hlpScreen, appName(), comName);
	exit(msgErrorNumber(E_hlpScreen));
}
