/*	$Id$

	Allocate system memory block. This block is not deallocated if
	the process dies.

	This file bases on MISC.C of FreeCOM v0.81 beta 1.

	$Log$
	Revision 1.4  2006/09/11 00:07:22  blairdude
	Fixed compilation completely with Turbo C

	Revision 1.3  2004/06/29 21:57:20  skaus
	fix: /LOW option
	
	Revision 1.2  2004/02/01 13:52:17  skaus
	add/upd: CVS $id$ keywords to/of files
	
	Revision 1.1  2001/04/12 00:33:52  skaus
	chg: new structure
	chg: If DEBUG enabled, no available commands are displayed on startup
	fix: PTCHSIZE also patches min extra size to force to have this amount
	   of memory available on start
	bugfix: CALL doesn't reset options
	add: PTCHSIZE to patch heap size
	add: VSPAWN, /SWAP switch, .SWP resource handling
	bugfix: COMMAND.COM A:\
	bugfix: CALL: if swapOnExec == ERROR, no change of swapOnExec allowed
	add: command MEMORY
	bugfix: runExtension(): destroys command[-2]
	add: clean.bat
	add: localized CRITER strings
	chg: use LNG files for hard-coded strings (hangForEver(), init.c)
		via STRINGS.LIB
	add: DEL.C, COPY.C, CBREAK.C: STRINGS-based prompts
	add: fixstrs.c: prompts & symbolic keys
	add: fixstrs.c: backslash escape sequences
	add: version IDs to DEFAULT.LNG and validation to FIXSTRS.C
	chg: splitted code apart into LIB\*.c and CMD\*.c
	bugfix: IF is now using error system & STRINGS to report errors
	add: CALL: /N
	
 */

#include "../config.h"

#include "mcb.h"
#include "suppl.h"

#include "../include/misc.h"

unsigned allocSysBlk(const unsigned size, const unsigned mode)
{	unsigned segm;
	struct MCB _seg *mcb;

	if((segm = allocMemBlk(size, mode)) != 0) {
		mcb = MK_SEG_PTR (struct MCB, SEG2MCB (segm));
		mcb->mcb_ownerPSP = 8;
		dprintf(("[MEM: allocated system memory block: %04x/%u]\n"
		 , segm, size));
	}

	return segm;
}
