;**************************************************;
; WASM Message Module, Standard Output             ;
; By Eric Tauck                                    ;
;                                                  ;
; Defines:                                         ;
;                                                  ;
;   MesPut   message to standard output            ;
;   MesPutL  message plus CR+LF to standard output ;
;**************************************************;

        jmps    _message1_end

;========================================
; Display an ASCIIZ string.
;
; In: AX= string address.

MesPut  PROC    NEAR
        mov     bx, ax
_mgstd1 mov     dl, [bx]        ;load byte
        or      dl, dl          ;check if done
        jz      _mgstd2         ;exit loop if so
        mov     ah, 2           ;display function
        int     21H             ;execute
        inc     bx              ;next character
        jmps    _mgstd1         ;loop back
_mgstd2 ret
        ENDP

;========================================
; Display an ASCIIZ string followed by a
; carriage return and linefeed.
;
; In: AX= string address.

MesPutL PROC    NEAR
        call    MesPut          ;display string
        mov     ah, 2           ;display function
        mov     dl, 13          ;carriage return
        int     21H             ;execute
        mov     ah, 2           ;display function
        mov     dl, 10          ;linefeed
        int     21H             ;execute
        ret
        ENDP

_message1_end
