;********************************;
; WASM Serial I/O, Break and DTR ;
; By Eric Tauck                  ;
;                                ;
; Defines:                       ;
;                                ;
;   ComBrk  send break signal    ;
;   ComDtr  lower DTR            ;
;                                ;
; Requires:                      ;
;                                ;
;   SERIAL1.ASM                  ;
;   TICKS.ASM                    ;
;********************************;

        jmp     _serial8_end

;========================================
; Send a break signal.
;
; In: AX= ticks to wait; BX= serial
;     record.

ComBrk  PROC    NEAR

;--- raise break signal

        push    ax
        mov     dx, [bx+_COM_LINECTL]   ;line control
        in      al, dx                  ;get byte
        or      al, 40H
        out     dx, al                  ;send byte
        pop     ax

;--- pause

        push    bx
        call    TicWai
        pop     bx

;--- lower break signal

        mov     dx, [bx+_COM_LINECTL]  ;modem control
        in      al, dx                  ;get byte
        and     al, NOT 40H
        out     dx, al                  ;send byte

        ret
        ENDP

;========================================
; Lower DTR.
;
; In: AX= ticks to wait; BX= serial
;     record.

ComDtr  PROC    NEAR

;--- lower DTR

        push    ax
        mov     dx, [bx+_COM_MODEMCTL]  ;modem control
        in      al, dx                  ;get byte
        and     al, NOT _COM_DTR        ;lower DTR
        out     dx, al                  ;send byte
        pop     ax

;--- pause

        push    bx
        call    TicWai
        pop     bx

;--- raise DTR

        mov     dx, [bx+_COM_MODEMCTL]  ;modem control
        in      al, dx                  ;get byte
        or      al, NOT _COM_DTR        ;raise DTR
        out     dx, al                  ;send byte

        ret
        ENDP

_serial8_end
