;*********************************;
; WASM Far String Module          ;
; By Eric Tauck                   ;
;                                 ;
; Defines:                        ;
;                                 ;
;   StrLenF  return string length ;
;   StrCpyF  copy string          ;
;   StrCmpF  compare two strings  ;
;*********************************;

        jmps    _stringf_end

;========================================
; Determine the length of a string.
;
; In: DX:AX= string address.
;
; Out: AX= length.

StrLenF PROC    NEAR
        push    di
        push    es
        mov     di, ax          ;address
        mov     es, dx
        sub     al, al          ;byte to scan for
        mov     cx, 0FFFFH      ;byte to scan
        cld                     ;forward direction
        repne
        scasb                   ;scan for zero
        mov     ax, cx          ;remaining bytes
        inc     ax
        inc     ax              ;adjust
        neg     ax              ;byte count
        pop     es
        pop     di
        ret
        ENDP

;========================================
; Copy a string to a new address.
;
; In: DX:AX= source address; CX:BX=
;     destination address.
;
; Out: AX= length of string copied.

StrCpyF PROC    NEAR
        push    di
        push    si
        push    ds
        push    es
        mov     si, ax          ;load source
        mov     ds, dx
        mov     di, bx          ;load destination
        mov     es, cx
        mov     ax, si
        cld                     ;forward direction
_srcpf1 movsb                   ;copy byte
        cmp     BYTE [si-1], 0  ;check if end of string
        jnz     _srcpf1         ;loop back if not
        sub     ax, si          ;offset difference
        neg     ax              ;adjust
        dec     ax              ;don't count NUL
        pop     es
        pop     ds
        pop     si
        pop     di
        ret
        ENDP

;========================================
; Compare two strings.
;
; In: DX:AX= string one; CX:BX= string
;     two.
;
; Out: CY= set if different.

StrCmpF PROC    NEAR
        push    di
        push    si
        push    ds
        push    es
        mov     si, ax          ;string one
        mov     ds, dx
        mov     di, bx          ;string two
        mov     es, cx
        cld                     ;forward direction

;--- loop for each byte

_srcmf1 cmpsb                   ;compare bytes
        jne     _srcmf2         ;jump if not same
        cmp     BYTE [si-1], 0  ;check if end of string
        jnz     _srcmf1         ;loop back if not

;--- matched

        pop     es
        pop     ds
        pop     si
        pop     di
        clc
        ret

;--- no match

_srcmf2 pop     si
        pop     di
        stc
        ret
        ENDP

_stringf_end
