;***********************;
; SESSION Sound Effects ;
;    By Eric Tauck      ;
;***********************;

sndflg  DW      1       ;sound on

;========================================
; Various beeps.

;--- standard beep

Beep_Std PROC   NEAR
        mov     ax, 1046        ;frequency
        mov     bx, 1           ;duration
        call    Beep            ;sound speaker
        ret
        ENDP

;--- invalid keystroke beep

Beep_Key PROC   NEAR
        mov     ax, 1569        ;frequency
        mov     bx, 1           ;duration
        call    Beep            ;sound speaker
        ret
        ENDP

;--- error beep

Beep_Error PROC NEAR
        mov     ax, 800         ;frequency
        mov     bx, 2           ;duration
        call    Beep            ;sound speaker
        ret
        ENDP

;--- successful transfer beep

Beep_Success PROC NEAR
        call    Beep_Std
        call    Beep_Error
        call    Beep_Key
        ret
        ENDP

;========================================
; Beep.
;
; In: AX= frequency; BX= duration in
;     ticks.

Beep    PROC    NEAR
        cmp     sndflg, 0
        je      beep1

        push    bx
        call    SndOn           ;turn speaker on
        pop     ax
        call    TicWai          ;pause
        call    SndOff          ;turn speaker off

beep1   ret
        ENDP
