;*****************************;
; SESSION Input and Messaging ;
;        By Eric Tauck        ;
;*****************************;

c_lev   DB      0                       ;command window nest level

;========================================
; Open the command line.

Command_Open    PROC    NEAR

;--- save display state if first level

        cmp     c_lev, 0        ;check if first open
        jne     cmdopn1         ;jump if so

        call    CurPos          ;get cursor position
        mov     c_sav1, ax      ;save location
        call    CurGet          ;get cursor state
        mov     c_sav2, al      ;save state

        sub     bx, bx          ;upper left
        sub     ch, ch          ;row zero
        mov     cl, cols        ;columns
        dec     cl
        push    bx
        push    cx
        call    ScrSiz          ;get bytes needed
        call    MemAll          ;allocate memory (assume success)
        pop     cx
        pop     bx
        mov     s_sav, ax       ;save segment
        mov     s_loc1, bx      ;save upper left
        mov     s_loc2, cx      ;save lower right
        mov     dx, ax
        sub     ax, ax
        call    ScrGet          ;copy screen to memory

;--- finished

cmdopn1 sub     al, al          ;zero flag
        call    CurSet          ;turn cursor off
        sub     ax, ax          ;upper left corner
        call    CurMov          ;position cursor

        inc     c_lev           ;increment level
        ret
        ENDP

;========================================
; Close the command line.

Command_Close   PROC    NEAR
        dec     c_lev           ;decrement level
        cmp     c_lev, 0        ;check if level zero
        jne     cmdclo1         ;jump if not

        mov     bx, s_loc1      ;upper left
        mov     cx, s_loc2      ;lower right
        mov     dx, s_sav       ;load segment
        sub     ax, ax          ;offset zero
        call    ScrPut          ;restore screen
        mov     ax, s_sav       ;memory segment
        call    MemRel          ;release memory

        mov     ax, c_sav1      ;saved location
        call    CurMov          ;position cursor
        mov     al, c_sav2      ;saved state
        call    CurSet          ;set state

cmdclo1 ret
        ENDP

;========================================
; Display a status line.
;
; In: AX= prompt address.

Command_Status  PROC    NEAR
        push    ax
        mov     al, attr_stat   ;status color
        call    AtrSet          ;set attribute
        sub     ax, ax          ;upper left corner
        call    CurMov          ;position cursor
        pop     ax              ;restore prompt address
        mov     cl, cols        ;width
        call    ProWrt          ;display
        ret
        ENDP

;========================================
; Display an error message.
;
; In: AX= error message.

Command_Error PROC    NEAR
        push    ax
        call    Command_Open    ;open command line
        mov     al, attr_error  ;color
        call    AtrSet          ;set attribute
        call    Beep_Error      ;error beep
        pop     ax
        mov     cl, cols
        call    InpEsc          ;display prompt and wait for ESC
        call    Command_Close   ;close window
        ret
        ENDP

;========================================
; Confirm an operation.
;
; In: AX= prompt address.
;
; Out: CY= set if abort ('N' or ESC).

Command_Confirm PROC    NEAR
        push    ax
        call    Command_Open    ;open command line
        mov     al, attr_conf   ;status color
        call    AtrSet          ;set attribute
        pop     ax
        mov     cl, cols
        call    InpVer          ;verify
        lahf
        push    ax
        call    Command_Close   ;close window
        pop     ax
        sahf
        ret
        ENDP

;========================================
; Input a string.
;
; In: AX= prompt address; BX= input
;     buffer.
;
; Out: CY= set if cancel input.

Command_Input   PROC    NEAR
        push    ax
        push    bx
        call    Command_Open    ;open command line
        mov     al, attr_inp1   ;prompt color
        call    AtrSet          ;set attribute
        pop     bx
        pop     ax

        mov     cl, cols
        call    InpStr          ;input string
        lahf
        push    ax
        call    Command_Close   ;close window
        pop     ax
        sahf
        ret
        ENDP
