;***********************;
; SESSION Terminal Mode ;
;     By Eric Tauck     ;
;***********************;

FLOWTIME        EQU     91      ;XON timeout, about 5 seconds

t_cflg   DB      0      ;non-zero if byte waiting in "t_cbyt"
t_kflg   DB      0      ;non-zero if byte waiting in "t_kbyt"

t_mes1  DB      '* Terminal ready at ',0
t_mes2  DB      ' bps on port ',0
t_mes3  DB      13,10,'* Press ALT-X to exit, F1 for help',13,10,0

l_err   DB      'Loss of carrier',0

x_mes   DB      'Exit Session program',0

s_mes   DB      'Session Shell --- Type EXIT to return',0
s_err   DB      'Unable to run shell',0

;--- terminal flags

T_ECHO  EQU     0001H   ;local echo
T_SPLIT EQU     0002H   ;split screen
T_SEND  EQU     0004H   ;sending text
T_RECEV EQU     0008H   ;receiving text
T_LINES EQU     0010H   ;add LF's to incomming CR's
T_STRIP EQU     0020H   ;strip high bit from incomming bytes
T_XFAST EQU     0040H   ;fast XMODEM responses
T_X1024 EQU     0080H   ;1024 byte XMODEM blocks
T_ANSI  EQU     0100H   ;ANSI codes enabled
T_CARR  EQU     0200H   ;test carrier
T_OLINE EQU     0400H   ;online flag
T_FILT  EQU     0800H   ;character filter
T_MACRO EQU     1000H   ;running macro
T_DEBUG EQU     2000H   ;display debug info
T_BEGIN EQU     4000H   ;set when macro loaded

trmflg  DW      T_XFAST OR T_ANSI OR T_FILT

;--- terminal help text

t_help  LABEL   BYTE
        DB      10
        DB      'Session Terminal Commands:',10
        DB      10
        DB      'Control                      Transfer',10
        DB      '-------                      --------',10
        DB      10
        DB      'ALT-A  abort process         PgUp   upload binary file',10
        DB      'ALT-C  clear screen          PgDn   download binary file',10
        DB      'ALT-M  run macro',10
        DB      'ALT-R  reset screen          ALT-U  upload text file',10
        DB      'ALT-X  exit program          ALT-D  download text file',10
        DB      'ALT-Z  system shell',10
        DB      10
        DB      'Configure',10
        DB      '---------',10
        DB      10
        DB      'ALT-E  toggle echo           ALT-B  toggle macro debugging',10
        DB      'ALT-S  toggle split',10
        DB      10
        DB      'Press any key to continue ...',10
        DB      0

;========================================
; Test carrier flag and set online flag.

Test_Line PROC  NEAR
        test    trmflg, T_CARR          ;check if test carrier
        jz      tesonl2                 ;jump if not
        mov     bx, di
        call    ComCar                  ;test carrier
        jc      tesonl2                 ;jump if set

;--- off-line

        test    trmflg, T_OLINE         ;check if previously online
        jz      tesonl1                 ;exit if not
        mov     ax, OFFSET l_err        ;message
        call    Command_Error           ;display loss of carrier
        and     trmflg, NOT T_OLINE     ;clear flag
tesonl1 ret

;--- on-line

tesonl2 or      trmflg, T_OLINE         ;set flag
        ret
        ENDP

;========================================
; Check if character should be
; displayed or not.
;
; In: AL= character.
;
; Out: CY= set if no display.

Char_Filter PROC NEAR
        test    trmflg, T_FILT  ;check if filtered
        jz      chrfil1
        cmp     al, BEL
        je      chrfil1
        cmp     al, BS
        je      chrfil1
        cmp     al, TAB
        je      chrfil1
        cmp     al, LF
        je      chrfil1
        cmp     al, FF
        je      chrfil1
        cmp     al, CR
        je      chrfil1
        cmp     al, 127
        je      chrfil2
        cmp     al, 32
        jb      chrfil2

;--- valid character

chrfil1 clc
        ret

;--- invalid character

chrfil2 stc
        ret
        ENDP

;========================================
; Start the pace timer.

Pace_Start PROC NEAR
        mov     si, pacetime    ;load delay
        or      si, si          ;check if pacing enabled
        jz      pacsta1         ;exit if not
        mov     al, PACE_TIMER  ;timer number
        call    TicRes          ;reset timer
pacsta1 ret
        ENDP

;========================================
; Check if within pacing delay.
;
; In: SI= current pace count (non-zero
;     if within delay).
;
; Out: CY= set if delayed.

Pace_Check PROC NEAR
        or      si, si          ;check if delay
        jz      pacchk1         ;exit if not
        mov     al, PACE_TIMER  ;timer number
        call    TicPas          ;get time passed
        cmp     ax, si          ;check if delayed
        jb      pacchk1         ;exit if so
        sub     si, si          ;zero pace count
pacchk1 ret
        ENDP

;========================================
; Capture a byte.
;
; In: AL= byte.

Term_Capture    PROC    NEAR
        test    trmflg, T_RECEV         ;check if receiving
        jz      tercap1                 ;skip if not
        test    trmflg, T_OLINE         ;check if online
        jz      tercap1                 ;skip if not
        call    Text_Write              ;write byte
        jnc     tercap1                 ;jump if okay
        and     trmflg, NOT T_RECEV     ;clear flag on error
tercap1 ret
        ENDP

;========================================
; Send a local byte in terminal mode.
;
; In: AL= character.

Term_Out PROC   NEAR

;--- send byte

        push    ax
        mov     bx, t_ser
        call    ComPut          ;write character
        pop     ax

;--- echo

        call    Char_Filter     ;check if filtered
        jc      trmout2         ;skip echo if so

        test    trmflg, T_ECHO OR T_SPLIT
        jz      trmout1
        push    ax
        call    Local_Type      ;display locally
        pop     ax

        test    trmflg, T_SPLIT
        jnz     trmout1
        push    ax
        call    Term_Capture    ;capture
        pop     ax

trmout1 test    trmflg, T_SPLIT
        jz      trmout2
        cmp     al, CR          ;check if carriage return
        jne     trmout2
        mov     al, LF          ;append linefeed
        call    Local_Type      ;display

trmout2 ret
        ENDP

;========================================
; Receive a remote byte in terminal mode.
;
; In: AL= character.

Term_Inp PROC   NEAR

;--- check if strip high bit

        test    trmflg, T_STRIP ;check if strip high bit
        jz      trminp1
        and     al, NOT 80H     ;clear bit

;--- check for special characters

trminp1 test    trmflg, T_OLINE ;check if online
        jz      trminp3

        cmp     al, XOFF        ;check if flow control character
        jne     trminp2
        test    trmflg, T_SEND  ;check if sending text
        jz      trminp2
        call    Pause           ;pause
        ret

trminp2 cmp     al, ESC         ;check if escape
        jne     trminp3
        test    trmflg, T_ANSI  ;check if ANSI codes
        jz      trminp3
        mov     bx, t_ser
        call    Ansi_Read       ;process ANSI sequence
        ret

trminp3 call    Char_Filter     ;check if filtered
        jc      trminp4

;--- display and capture character

        push    ax
        call    Remote_Type     ;display
        pop     ax

        push    ax
        call    Term_Capture    ;capture
        pop     ax

        test    trmflg, T_LINES ;check if append linefeeds
        jz      trminp4
        cmp     al, CR          ;check if carriage return
        jne     trminp4
        mov     al, LF          ;append linefeed
        call    Remote_Type     ;display
        mov     al, LF          ;append linefeed
        call    Term_Capture    ;capture

trminp4 ret
        ENDP

;========================================
; Terminal mode.
;
; In: AX= macro file or 0 if none; DI=
;     serial pointer.

Terminal PROC   NEAR
        push    si
        mov     t_ser, di       ;save serial record for global routines

        push    ax              ;save macro file

;--- set up screen

        mov     ax, OFFSET Screen_Merge
        test    trmflg, T_SPLIT
        jz      term1
        mov     ax, OFFSET Screen_Split
term1   call    ax

;--- sign-on message

        StkAll  si, 10                  ;allocate space for numbers

        mov     ax, OFFSET banner
        call    System_String

        mov     ax, OFFSET t_mes1
        call    System_String

        mov     ax, c_speed
        sub     dx, dx
        mov     bx, si
        mov     cx, 10
        call    Num2Str

        mov     ax, si
        call    System_String

        mov     ax, OFFSET t_mes2
        call    System_String

        mov     ax, c_port
        sub     dx, dx
        mov     bx, si
        mov     cx, 10
        call    Num2Str

        mov     ax, si
        call    System_String

        mov     ax, OFFSET t_mes3
        call    System_String

        StkRel  10                      ;fix stack

        sub     si, si                  ;zero pace timer

;--- open serial port

        mov     al, BYTE c_port
        mov     ah, BYTE c_party
        mov     cl, BYTE c_data
        mov     ch, BYTE c_stop
        mov     dx, c_speed
        mov     bx, di
        call    ComOpn          ;open serial port

;--- load macro file

        pop     ax
        or      ax, ax          ;check if macro file passed
        jz      term2
        call    Macro_Load      ;load macro
        jc      term2
        or      trmflg, T_MACRO OR T_BEGIN ;set flags

;=== main terminal loop

term2   call    Test_Line       ;check line status first

;--- check for local input

        call    KeyGet          ;get keystroke
        jc      term3
        mov     t_kbyt, ax      ;save keystroke
        inc     t_kflg          ;set flag

;--- check for remote input

term3   mov     bx, di
        call    ComGet          ;get communications byte
        jc      term4
        mov     t_cbyt, al      ;save byte
        inc     t_cflg          ;set flag

;--- run macro

term4   test    trmflg, T_MACRO         ;test if in macro
        jz      term8

        test    trmflg, T_DEBUG         ;check if debugging
        jz      term5
        test    trmflg, T_BEGIN         ;check if beginning execution
        jz      term5
        call    DebugInfo               ;display initial debug info
        jc      term7

term5   and     trmflg, NOT T_BEGIN     ;clear begin flag
        call    MacRun                  ;run macro
        jc      term6                   ;jump if break
        and     trmflg, NOT T_MACRO     ;clear macro flag

term6   test    trmflg, T_DEBUG         ;check if debugging
        jz      term8
        call    DebugInfo               ;display debug info
        jnc     term8

term7   and     trmflg, NOT T_MACRO     ;clear macro flag on debug abort

;--- user input

term8   cmp     t_kflg, 0       ;check if byte waiting
        je      term9           ;jump if not

        dec     t_kflg          ;zero flag
        mov     ax, t_kbyt      ;load keystroke
        or      ah, ah          ;check if extended key
        jnz     termD           ;jump if so

        call    Term_Out        ;terminal output

;--- file input

term9   test    trmflg, T_SEND  ;check if sending text
        jz      termB
        call    Pace_Check      ;check if in pace delay
        jc      termB

        call    Text_Read       ;get a byte
        jc      termE           ;jump if byte unavailable

        cmp     al, CR          ;check if end of line
        jne     termA           ;skip if not
        push    ax
        call    Pace_Start      ;restart pacing
        pop     ax

termA   call    Term_Out        ;terminal output

;--- remote input

termB   cmp     t_cflg, 0       ;check if byte waiting
        je      termC

        dec     t_cflg          ;zero flag
        mov     al, t_cbyt
        call    Term_Inp        ;process byte
termC   jmp     term2

;=== terminal exceptions

;--- non-ASCII user key

termD   cmp     ax, KEY_ALT_X   ;check if exit
        je      termF           ;jump if so

        call    Command         ;do a command
        jmps    term9

;--- failed file read

termE   and     trmflg, NOT T_SEND      ;clear flag
        call    Text_Read_End           ;close file
        jmps    termB                   ;goto start of terminal loop

;--- exit terminal mode

termF   mov     ax, OFFSET x_mes
        call    Command_Confirm ;confirm close
        jc      term9

        call    Text_Write_End  ;close write file
        call    Text_Read_End   ;close read file
        mov     bx, di
        call    ComClo          ;close serial port
        pop     si
        ret
        ENDP

;========================================
; Set xmodem flags.
;
; Out: CL= xmodem flags.

Xmodem_Flags PROC       NEAR
        mov     al, XMODEM_CRC  ;always set CRC
        test    trmflg, T_XFAST ;check if fast speed
        jz      xmdflg1
        or      al, XMODEM_FAST ;set flag
xmdflg1 test    trmflg, T_X1024 ;check if big blocks
        jz      xmdflg2
        or      al, XMODEM_BIG  ;set flag
xmdflg2 mov     cl, al
        ret
        ENDP

;========================================
; Process command.
;
; In: AX= command.

Command PROC    NEAR

;--- abort something

        cmp     ax, KEY_ALT_A           ;check if ALT-A
        jne     commnd3

        test    trmflg, T_SEND          ;check if sending text
        jz      commnd1
        call    Text_Read_End           ;close file
        and     trmflg, NOT T_SEND      ;clear flag
        ret

commnd1 test    trmflg, T_RECEV         ;check if receiving text
        jz      commnd2
        call    Text_Write_End          ;close file
        and     trmflg, NOT T_RECEV     ;clear flag
commnd2 ret

;--- clear screen

commnd3 cmp     ax, KEY_ALT_C   ;check if ALT-C
        jne     commnd4
        call    Clear_Both      ;clear screen
        ret

;--- download

commnd4 cmp     ax, KEY_ALT_D   ;check if ALT-D
        jne     commnd6
        sub     ax, ax          ;no file name
        call    Text_Write_Beg  ;start writing
        jc      commnd5         ;jump if error
        or      trmflg, T_RECEV ;set flag
commnd5 ret

;--- toggle echo

commnd6 cmp     ax, KEY_ALT_E   ;check if ALT-E
        jne     commnd7
        xor     trmflg, T_ECHO  ;toggle flag
        ret

;--- toggle linefeeds

commnd7 cmp     ax, KEY_ALT_L   ;check if ALT-L
        jne     commnd8
        xor     trmflg, T_LINES ;toggle flag
        ret

;--- toggle split screen

commnd8 cmp     ax, KEY_ALT_S           ;check if ALT-S
        jne     commndA
        mov     ax, OFFSET Screen_Split ;split routine
        test    trmflg, T_SPLIT         ;check if split
        jz      commnd9                 ;jump if if so
        mov     ax, OFFSET Screen_Merge ;merge routine
commnd9 xor     trmflg, T_SPLIT         ;toggle flag
        call    ax                      ;split or merge
        ret

;--- text upload

commndA cmp     ax, KEY_ALT_U   ;check if ALT-U
        jne     commndC
        sub     ax, ax          ;no file name
        call    Text_Read_Beg   ;start reading
        jc      commndB         ;jump if error
        or      trmflg, T_SEND  ;set flag
commndB ret

;--- shell

commndC cmp     ax, KEY_ALT_Z   ;check if ALT-Z
        jne     commndD
        call    Shell
        ret

;--- xmodem upload

commndD cmp     ax, KEY_PGUP    ;check if page up
        jne     commndE
        call    Xmodem_Flags    ;set flags
        sub     ax, ax          ;no file name
        mov     bx, di
        call    Xmodem_Upload   ;perform upload
        ret

;--- xmodem download

commndE cmp     ax, KEY_PGDN    ;check if page down
        jne     commndF
        call    Xmodem_Flags    ;set flags
        sub     ax, ax          ;no file name
        mov     bx, di
        call    Xmodem_Download ;perform download
        ret

;--- help

commndF cmp     ax, KEY_F1      ;check if F1
        jne     commndG
        mov     ax, OFFSET t_help
        call    Screen_Display  ;display
        ret

;--- reset screen

commndG cmp     ax, KEY_ALT_R   ;check if ALT-R
        jne     commndH
        call    Display_Setup   ;reinitialize screen
        call    Clear_Both      ;clear screen
        ret

;--- run macro

commndH cmp     ax, KEY_ALT_M   ;check if ALT-M
        jne     commndJ
        sub     ax, ax          ;no file
        call    Macro_Load      ;load macro
        jc      commndI
        or      trmflg, T_MACRO OR T_BEGIN ;set flags
commndI ret

;--- enable/disable debugging (break)

commndJ cmp     ax, KEY_ALT_B   ;check if ALT-B
        jne     commndK
        xor     trmflg, T_DEBUG ;set flag
        ret

;--- invalid command

commndK call    Beep_Key        ;beep
        ret
        ENDP

;========================================
; Execute a command shell.

Shell   PROC    NEAR
        call    Screen_Save     ;save the screen
        jc      shell1
        call    Display_Done    ;terminate display
        mov     ax, OFFSET s_mes;message
        call    MesPut          ;display
        call    RunSys          ;switch to DOS shell
        lahf
        push    ax
        call    Display_Init    ;reinitialize display
        call    Screen_Restore  ;restore screen
        pop     ax
        sahf
        jnc     shell1          ;skip if no error
        mov     ax,OFFSET s_err ;error message
        call    Command_Error   ;process error
shell1  ret
        ENDP

;========================================
; Pause in flow.

Pause   PROC    NEAR

;--- reset timer

pause1  mov     al, TEMP_TIMER  ;timer to use
        call    TicRes          ;reset timer
        jmps    pause3          ;enter loop

;--- check if timeout

pause2  mov     al, TEMP_TIMER  ;timer
        call    TicPas          ;get time passed
        cmp     ax, FLOWTIME    ;check if timeout
        ja      pause4          ;jump if so

;--- check if restart

pause3  mov     bx, di
        call    ComGet          ;get byte
        jc      pause2          ;loop back if not
        cmp     al, XOFF        ;check if continue waiting
        je      pause1

pause4  ret
        ENDP
