/*
 *  ndis.h      Network Driver Interface Specification (NDIS) functions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2010 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _NDIS_
#define _NDIS_

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#include <ntddk.h>
#include <ntstatus.h>
#include <netevent.h>
#include <xfilter.h>
#include <qos.h>

#ifdef __cplusplus
extern "C" {
#endif

#ifndef NDIS_WRAPPER
    #ifdef NDIS_MINIPORT_DRIVER
        #if defined( NDIS620_MINIPORT )
            #define NDIS_MINIPORT_MAJOR_VERSION 6
            #define NDIS_MINIPORT_MINOR_VERSION 20
        #elif defined( NDIS61_MINIPORT )
            #define NDIS_MINIPORT_MAJOR_VERSION 6
            #define NDIS_MINIPORT_MINOR_VERSION 1
        #elif defined( NDIS60_MINIPORT )
            #define NDIS_MINIPORT_MAJOR_VERSION 6
            #define NDIS_MINIPORT_MINOR_VERSION 0
        #elif defined( NDIS51_MINIPORT )
            #define NDIS_MINIPORT_MAJOR_VERSION 5
            #define NDIS_MINIPORT_MINOR_VERSION 1
        #elif defined( NDIS50_MINIPORT )
            #define NDIS_MINIPORT_MAJOR_VERSION 5
            #define NDIS_MINIPORT_MINOR_VERSION 0
        #endif
    #endif
    #if defined( NDIS620 )
        #define NDIS_PROTOCOL_MAJOR_VERSION     6
        #define NDIS_PROTOCOL_MINOR_VERSION     20
        #define NDIS_FILTER_MAJOR_VERSION       6
        #define NDIS_FILTER_MINOR_VERSION       20
    #elif defined( NDIS61 )
        #define NDIS_PROTOCOL_MAJOR_VERSION     6
        #define NDIS_PROTOCOL_MINOR_VERSION     1
        #define NDIS_FILTER_MAJOR_VERSION       6
        #define NDIS_FILTER_MINOR_VERSION       1
    #elif defined( NDIS60 )
        #define NDIS_PROTOCOL_MAJOR_VERSION     6
        #define NDIS_PROTOCOL_MINOR_VERSION     0
        #define NDIS_FILTER_MAJOR_VERSION       6
        #define NDIS_FILTER_MINOR_VERSION       0
    #elif defined( NDIS51 )
        #define NDIS_PROTOCOL_MAJOR_VERSION     5
        #define NDIS_PROTOCOL_MINOR_VERSION     1
    #elif defined( NDIS50 )
        #define NDIS_PROTOCOL_MAJOR_VERSION     5
        #define NDIS_PROTOCOL_MINOR_VERSION     0
    #elif defined( NDIS40 )
        #define NDIS_PROTOCOL_MAJOR_VERSION     4
        #define NDIS_PROTOCOL_MINOR_VERSION     0
    #else
        #define NDIS40
        #define NDIS_PROTOCOL_MAJOR_VERSION     4
        #define NDIS_PROTOCOL_MINOR_VERSION     0
    #endif
#endif
#ifndef NDIS_LEGACY_MINIPORT
    #if defined( NDIS_MINIPORT_DRIVER ) && ((NDIS_MINIPORT_MAJOR_VERSION < 6) || \
        NDIS_WRAPPER)
        #define NDIS_LEGACY_MINIPORT            1
    #else
        #define NDIS_LEGACY_MINIPORT            0
    #endif
#endif
#ifndef NDIS_LEGACY_PROTOCOL
    #if defined( NDIS_PROTOCOL_MAJOR_VERSION ) && ((NDIS_PROTOCOL_MAJOR_VERSION < 6) || \
        NDIS_WRAPPER)
        #define NDIS_LEGACY_PROTOCOL            1
    #else
        #define NDIS_LEGACY_PROTOCOL            0
    #endif
#endif
#ifndef NDIS_LEGACY_DRIVER
    #if NDIS_LEGACY_MINIPORT || NDIS_LEGACY_PROTOCOL || NDIS_WRAPPER
        #define NDIS_LEGACY_DRIVER              1
    #else
        #define NDIS_LEGACY_DRIVER              0
    #endif
#endif
#ifndef NDIS_SUPPORT_NDIS6
    #if (defined( NDIS_MINIPORT_MAJOR_VERSION ) && \
        (NDIS_MINIPORT_MAJOR_VERSION >= 6)) || defined( NDIS60 ) || NDIS_WRAPPER
        #define NDIS_SUPPORT_NDIS6              1
    #else
        #define NDIS_SUPPORT_NDIS6              0
    #endif
#endif
#ifndef NDIS_SUPPORT_NDIS61
    #if (defined( NDIS_MINIPORT_MAJOR_VERSION ) && \
        (NDIS_MINIPORT_MAJOR_VERSION >= 6) && defined( NDIS_MINIPORT_MINOR_VERSION ) && \
        (NDIS_MINIPORT_MINOR_VERSION >= 1)) || defined( NDIS61 ) || NDIS_WRAPPER
        #define NDIS_SUPPORT_NDIS61             1
    #else
        #define NDIS_SUPPORT_NDIS61             0
    #endif
#endif
#ifndef NDIS_SUPPORT_NDIS620
    #if (defined( NDIS_MINIPORT_MAJOR_VERSION ) && \
        (NDIS_MINIPORT_MAJOR_VERSION >= 6) && defined( NDIS_MINIPORT_MINOR_VERSION ) && \
        (NDIS_MINIPORT_MINOR_VERSION >= 20)) || defined( NDIS620 ) || NDIS_WRAPPER
        #define NDIS_SUPPORT_NDIS620            1
    #else
        #define NDIS_SUPPORT_NDIS620            0
    #endif
#endif
#if NDIS_SUPPORT_NDIS620
    #undef NDIS_SUPPORT_NDIS61
    #define NDIS_SUPPORT_NDIS61                 1
#endif
#if NDIS_SUPPORT_NDIS61
    #undef NDIS_SUPPORT_NDIS6
    #define NDIS_SUPPORT_NDIS6                  1
#endif
#if defined( NDIS61_MINIPORT ) || defined( NDIS60_MINIPORT ) || defined( NDIS61 ) || \
    defined( NDIS60 ) || defined( NDIS_WRAPPER ) || defined( NDIS_LEGACY_DRIVER )
    #define NDIS_SUPPORT_60_COMPATIBLE_API  1
#else
    #define NDIS_SUPPORT_60_COMPATIBLE_API  0
#endif

/* Macro to specify NDIS functions */
#ifdef NDIS_WRAPPER
    #define EXPORT
#else
    #define EXPORT  DECLSPEC_IMPORT
#endif

/* Primitive data types */
typedef signed int                      INT;
typedef signed int                      *PINT;
typedef unsigned int                    UINT;
typedef unsigned int                    *PUINT;
typedef UNICODE_STRING                  NDIS_STRING;
typedef UNICODE_STRING                  *PNDIS_STRING;
typedef PVOID                           NDIS_HANDLE;
typedef PVOID                           *PNDIS_HANDLE;
typedef int                             NDIS_STATUS;
typedef int                             *PNDIS_STATUS;
typedef CM_MCA_POS_DATA                 NDIS_MCA_POS_DATA;
typedef CM_MCA_POS_DATA                 *PNDIS_MCA_POS_DATA;
typedef CM_EISA_SLOT_INFORMATION        NDIS_EISA_SLOT_INFORMATION;
typedef CM_EISA_SLOT_INFORMATION        *PNDIS_EISA_SLOT_INFORMATION;
typedef CM_EISA_FUNCTION_INFORMATION    NDIS_EISA_FUNCTION_INFORMATION;
typedef CM_EISA_FUNCTION_INFORMATION    *PNDIS_EISA_FUNCTION_INFORMATION;
typedef KINTERRUPT_MODE                 NDIS_INTERRUPT_MODE;
typedef KINTERRUPT_MODE                 *PNDIS_INTERRUPT_MODE;
typedef CM_PARTIAL_RESOURCE_LIST        NDIS_RESOURCE_LIST;
typedef CM_PARTIAL_RESOURCE_LIST        *PNDIS_RESOURCE_LIST;
typedef MDL                             NDIS_BUFFER;
typedef MDL                             *PNDIS_BUFFER;
typedef ULONG                           NDIS_AF;
typedef ULONG                           *PNDIS_AF;
typedef PHYSICAL_ADDRESS                NDIS_PHYSICAL_ADDRESS;
typedef PHYSICAL_ADDRESS                *PNDIS_PHYSICAL_ADDRESS;
typedef UCHAR                           NDIS_DMA_SIZE;
#if NDIS_LEGACY_DRIVER
typedef NDIS_HANDLE                     PNDIS_PACKET_POOL;
typedef UINT                            IEEE8021PPRIORITY;
#endif
#if !NDIS_LEGACY_DRIVER
typedef struct _NDIS_CALL_MANAGER_CHARACTERISTICS   *PNDIS_CALL_MANAGER_CHARACTERISTICS;
#endif
#if NDIS_SUPPORT_NDIS6
typedef USHORT                          NET_FRAME_TYPE;
typedef USHORT                          *PNET_FRAME_TYPE;
typedef KMUTEX                          NDIS_MUTEX;
typedef KMUTEX                          *PNDIS_MUTEX;
#endif
#if NDIS_SUPPORT_NDIS61
typedef ULONG                           IPSEC_OFFLOAD_V2_SPI_TYPE;
#endif

/* NDIS error code data type */
#define NDIS_ERROR_CODE ULONG

#include <ntddndis.h>
#if NDIS_SUPPORT_NDIS6
    #include <windot11.h>
#endif

/* Macro to make NDIS string constants */
#define NDIS_STRING_CONST( x )  { sizeof( L##x ) - 2, sizeof( L##x ), L##x }

/* Macro to make NDIS physical addresses */
#define NDIS_PHYSICAL_ADDRESS_CONST( p1, p2 )   { (ULONG)(p1), (LONG)(p2) }

/* NDIS interrupt modes */
#define NdisInterruptLatched        Latched
#define NdisInterruptLevelSensitive LevelSensitive

/* NDIS packet flags */
#if NDIS_LEGACY_DRIVER
    #define NDIS_FLAGS_PROTOCOL_ID_MASK         0x0000000FL
    #define NDIS_FLAGS_MULTICAST_PACKET         0x00000010L
    #define NDIS_FLAGS_DONT_LOOPBACK            0x00000080L
    #define NDIS_FLAGS_IS_LOOPBACK_PACKET       0x00000100L
    #define NDIS_FLAGS_LOOPBACK_ONLY            0x00000200L
    #define NDIS_FLAGS_DOUBLE_BUFFERED          0x00000800L
    #define NDIS_FLAGS_SENT_AT_DPC              0x00001000L
    #define NDIS_FLAGS_USES_SG_BUFFER_LIST      0x00002000L
    #define NDIS_FLAGS_USES_ORIGINAL_PACKET     0x00004000L
    #define NDIS_FLAGS_PADDED                   0x00010000L
    #define NDIS_FLAGS_XLATE_AT_TOP             0x00020000L
#endif

/* NDIS reserved packet flags */
#if NDIS_LEGACY_DRIVER
    #define fPACKET_CONTAINS_MEDIA_SPECIFIC_INFO    0x40
    #define fPACKET_ALLOCATED_BY_NDIS               0x80
#endif

/* NDIS address families */
#define CO_ADDRESS_FAMILY_Q2931         0x00000001L
#define CO_ADDRESS_FAMILY_PSCHED        0x00000002L
#define CO_ADDRESS_FAMILY_L2TP          0x00000003L
#define CO_ADDRESS_FAMILY_IRDA          0x00000004L
#define CO_ADDRESS_FAMILY_1394          0x00000005L
#define CO_ADDRESS_FAMILY_PPP           0x00000006L
#define CO_ADDRESS_FAMILY_INFINIBAND    0x00000007L
#define CO_ADDRESS_FAMILY_TAPI          0x00000800L
#define CO_ADDRESS_FAMILY_TAPI_PROXY    0x00000801L
#define CO_ADDRESS_FAMILY_PROXY         0x80000000L

/* NDIS memory types */
#define NDIS_MEMORY_CONTIGUOUS  0x00000001L
#define NDIS_MEMORY_NONCACHED   0x00000002L

/* NDIS open flags */
#define NDIS_OPEN_RECEIVE_NOT_REENTRANT 0x00000001L

/* NDIS status codes */
#define NDIS_STATUS_ONLINE                              0x40010003L
#define NDIS_STATUS_RESET_START                         0x40010004L
#define NDIS_STATUS_RESET_END                           0x40010005L
#define NDIS_STATUS_RING_STATUS                         0x40010006L
#define NDIS_STATUS_CLOSED                              0x40010007L
#define NDIS_STATUS_WAN_LINE_UP                         0x40010008L
#define NDIS_STATUS_WAN_LINE_DOWN                       0x40010009L
#define NDIS_STATUS_WAN_FRAGMENT                        0x4001000AL
#define NDIS_STATUS_MEDIA_CONNECT                       0x4001000BL
#define NDIS_STATUS_MEDIA_DISCONNECT                    0x4001000CL
#define NDIS_STATUS_HARDWARE_LINE_UP                    0x4001000DL
#define NDIS_STATUS_HARDWARE_LINE_DOWN                  0x4001000EL
#define NDIS_STATUS_INTERFACE_UP                        0x4001000FL
#define NDIS_STATUS_INTERFACE_DOWN                      0x40010010L
#define NDIS_STATUS_MEDIA_BUSY                          0x40010011L
#define NDIS_STATUS_MEDIA_SPECIFIC_INDICATION           0x40010012L
#define NDIS_STATUS_WW_INDICATION \
    NDIS_STATUS_MEDIA_SPECIFIC_INDICATION
#define NDIS_STATUS_LINK_SPEED_CHANGE                   0x40010013L
#define NDIS_STATUS_WAN_GET_STATS                       0x40010014L
#define NDIS_STATUS_WAN_CO_FRAGMENT                     0x40010015L
#define NDIS_STATUS_WAN_CO_LINKPARAMS                   0x40010016L
#define NDIS_STATUS_WAN_CO_MTULINKPARAMS                0x40010025L
#if NDIS_SUPPORT_NDIS6
    #define NDIS_STATUS_LINK_STATE                      0x40010017L
    #define NDIS_STATUS_NETWORK_CHANGE                  0x40010018L
    #define NDIS_STATUS_MEDIA_SPECIFIC_INDICATION_EX    0x40010019L
    #define NDIS_STATUS_PORT_STATE                      0x40010022L
    #define NDIS_STATUS_OPER_STATUS                     0x40010023L
    #define NDIS_STATUS_PACKET_FILTER                   0x40010024L
    #define NDIS_STATUS_IP_OPER_STATUS                  0x40010026L
    #define NDIS_STATUS_OFFLOAD_PAUSE                   0x40020001L
    #define NDIS_STATUS_UPLOAD_ALL                      0x40020002L
    #define NDIS_STATUS_OFFLOAD_RESUME                  0x40020003L
    #define NDIS_STATUS_OFFLOAD_PARTIAL_SUCCESS         0x40020004L
    #define NDIS_STATUS_OFFLOAD_STATE_INVALID           0x40020005L
    #define NDIS_STATUS_TASK_OFFLOAD_CURRENT_CONFIG     0x40020006L
    #define NDIS_STATUS_TASK_OFFLOAD_HARDWARE_CAPABILITIES  0x40020007L
    #define NDIS_STATUS_OFFLOAD_ENCAPSULATION_CHANGE    0x40020008L
    #define NDIS_STATUS_TCP_CONNECTION_OFFLOAD_HARDWARE_CAPABILITIES    0x4002000BL
    #define NDIS_STATUS_DOT11_SCAN_CONFIRM              0x40030000L
    #define NDIS_STATUS_DOT11_MPDU_MAX_LENGTH_CHANGED   0x40030001L
    #define NDIS_STATUS_DOT11_ASSOCIATION_START         0x40030002L
    #define NDIS_STATUS_DOT11_ASSOCIATION_COMPLETION    0x40030003L
    #define NDIS_STATUS_DOT11_CONNECTION_START          0x40030004L
    #define NDIS_STATUS_DOT11_CONNECTION_COMPLETION     0x40030005L
    #define NDIS_STATUS_DOT11_ROAMING_START             0x40030006L
    #define NDIS_STATUS_DOT11_ROAMING_COMPLETION        0x40030007L
    #define NDIS_STATUS_DOT11_DISASSOCIATION            0x40030008L
    #define NDIS_STATUS_DOT11_TKIPMIC_FAILURE           0x40030009L
    #define NDIS_STATUS_DOT11_PMKID_CANDIDATE_LIST      0x4003000AL
    #define NDIS_STATUS_DOT11_PHY_STATE_CHANGED         0x4003000BL
    #define NDIS_STATUS_DOT11_LINK_QUALITY              0x4003000CL
    #define NDIS_STATUS_DOT11_INCOMING_ASSOC_STARTED    0x4003000DL
    #define NDIS_STATUS_DOT11_INCOMING_ASSOC_REQUEST_RECEIVED   0x4003000EL
    #define NDIS_STATUS_DOT11_INCOMING_ASSOC_COMPLETION 0x4003000FL
    #define NDIS_STATUS_DOT11_STOP_AP                   0x40030010L
    #define NDIS_STATUS_DOT11_PHY_FREQUENCY_ADOPTED     0x40030011L
    #define NDIS_STATUS_DOT11_CAN_SUSTAIN_AP            0x40030012L
    #define NDIS_STATUS_WWAN_DEVICE_CAPS                0x40041000L
    #define NDIS_STATUS_WWAN_READY_INFO                 0x40041001L
    #define NDIS_STATUS_WWAN_RADIO_STATE                0x40041002L
    #define NDIS_STATUS_WWAN_PIN_INFO                   0x40041003L
    #define NDIS_STATUS_WWAN_PIN_LIST                   0x40041004L
    #define NDIS_STATUS_WWAN_HOME_PROVIDER              0x40041005L
    #define NDIS_STATUS_WWAN_PREFERRED_PROVIDERS        0x40041006L
    #define NDIS_STATUS_WWAN_VISIBLE_PROVIDERS          0x40041007L
    #define NDIS_STATUS_WWAN_REGISTER_STATE             0x40041008L
    #define NDIS_STATUS_WWAN_PACKET_SERVICE             0x40041009L
    #define NDIS_STATUS_WWAN_SIGNAL_STATE               0x4004100AL
    #define NDIS_STATUS_WWAN_CONTEXT_STATE              0x4004100BL
    #define NDIS_STATUS_WWAN_PROVISIONED_CONTEXTS       0x4004100CL
    #define NDIS_STATUS_WWAN_SERVICE_ACTIVATION         0x4004100DL
    #define NDIS_STATUS_WWAN_SMS_CONFIGURATION          0x4004100EL
    #define NDIS_STATUS_WWAN_SMS_RECEIVE                0x4004100FL
    #define NDIS_STATUS_WWAN_SMS_SEND                   0x40041010L
    #define NDIS_STATUS_WWAN_SMS_DELETE                 0x40041011L
    #define NDIS_STATUS_WWAN_SMS_STATUS                 0x40041012L
    #define NDIS_STATUS_WWAN_DNS_ADDRESS                0x40041013L
    #define NDIS_STATUS_WWAN_VENDOR_SPECIFIC            0x40043000L
#endif
#if NDIS_SUPPORT_NDIS61
    #define NDIS_STATUS_HD_SPLIT_CURRENT_CONFIG         0x4002000CL
#endif
#if NDIS_SUPPORT_NDIS620
    #define NDIS_STATUS_RECEIVE_QUEUE_STATE             0x4002000DL
    #define NDIS_STATUS_PM_WOL_PATTERN_REJECTED         0x40030051L
    #define NDIS_STATUS_PM_OFFLOAD_REJECTED             0x40030052L
    #define NDIS_STATUS_PM_CAPABILITIES_CHANGE          0x40030053L
#endif
#define NDIS_STATUS_SUCCESS                             STATUS_SUCCESS
#define NDIS_STATUS_PENDING                             STATUS_PENDING
#define NDIS_STATUS_NOT_RECOGNIZED                      0x00010001L
#define NDIS_STATUS_NOT_COPIED                          0x00010002L
#define NDIS_STATUS_NOT_ACCEPTED                        0x00010003L
#define NDIS_STATUS_CALL_ACTIVE                         0x00010007L
#define NDIS_STATUS_INDICATION_REQUIRED                 STATUS_NDIS_INDICATION_REQUIRED
#define NDIS_STATUS_NOT_RESETTABLE                      0x80010001L
#define NDIS_STATUS_SOFT_ERRORS                         0x80010003L
#define NDIS_STATUS_HARD_ERRORS                         0x80010004L
#define NDIS_STATUS_BUFFER_OVERFLOW                     STATUS_BUFFER_OVERFLOW
#define NDIS_STATUS_FAILURE                             STATUS_UNSUCCESSFUL
#define NDIS_STATUS_RESOURCES                           STATUS_INSUFFICIENT_RESOURCES
#define NDIS_STATUS_CLOSING                             0xC0010002L
#define NDIS_STATUS_BAD_VERSION                         0xC0010004L
#define NDIS_STATUS_BAD_CHARACTERISTICS                 0xC0010005L
#define NDIS_STATUS_ADAPTER_NOT_FOUND                   0xC0010006L
#define NDIS_STATUS_OPEN_FAILED                         0xC0010007L
#define NDIS_STATUS_DEVICE_FAILED                       0xC0010008L
#define NDIS_STATUS_MULTICAST_FULL                      0xC0010009L
#define NDIS_STATUS_MULTICAST_EXISTS                    0xC001000AL
#define NDIS_STATUS_MULTICAST_NOT_FOUND                 0xC001000BL
#define NDIS_STATUS_REQUEST_ABORTED                     0xC001000CL
#define NDIS_STATUS_RESET_IN_PROGRESS                   0xC001000DL
#define NDIS_STATUS_CLOSING_INDICATING                  0xC001000EL
#define NDIS_STATUS_NOT_SUPPORTED                       STATUS_NOT_SUPPORTED
#define NDIS_STATUS_INVALID_PACKET                      0xC001000FL
#define NDIS_STATUS_OPEN_LIST_FULL                      0xC0010010L
#define NDIS_STATUS_ADAPTER_NOT_READY                   0xC0010011L
#define NDIS_STATUS_ADAPTER_NOT_OPEN                    0xC0010012L
#define NDIS_STATUS_NOT_INDICATING                      0xC0010013L
#define NDIS_STATUS_INVALID_LENGTH                      0xC0010014L
#define NDIS_STATUS_INVALID_DATA                        0xC0010015L
#define NDIS_STATUS_BUFFER_TOO_SHORT                    0xC0010016L
#define NDIS_STATUS_INVALID_OID                         0xC0010017L
#define NDIS_STATUS_ADAPTER_REMOVED                     0xC0010018L
#define NDIS_STATUS_UNSUPPORTED_MEDIA                   0xC0010019L
#define NDIS_STATUS_GROUP_ADDRESS_IN_USE                0xC001001AL
#define NDIS_STATUS_FILE_NOT_FOUND                      0xC001001BL
#define NDIS_STATUS_ERROR_READING_FILE                  0xC001001CL
#define NDIS_STATUS_ALREADY_MAPPED                      0xC001001DL
#define NDIS_STATUS_RESOURCE_CONFLICT                   0xC001001EL
#define NDIS_STATUS_NO_CABLE                            0xC001001FL
#define NDIS_STATUS_INVALID_DEVICE_REQUEST              STATUS_INVALID_DEVICE_REQUEST
#define NDIS_STATUS_NETWORK_UNREACHABLE                 STATUS_NETWORK_UNREACHABLE
#define NDIS_STATUS_INVALID_SAP                         0xC0010020L
#define NDIS_STATUS_SAP_IN_USE                          0xC0010021L
#define NDIS_STATUS_INVALID_ADDRESS                     0xC0010022L
#define NDIS_STATUS_VC_NOT_ACTIVATED                    0xC0010023L
#define NDIS_STATUS_DEST_OUT_OF_ORDER                   0xC0010024L
#define NDIS_STATUS_VC_NOT_AVAILABLE                    0xC0010025L
#define NDIS_STATUS_CELLRATE_NOT_AVAILABLE              0xC0010026L
#define NDIS_STATUS_INCOMPATABLE_QOS                    0xC0010027L
#define NDIS_STATUS_AAL_PARAMS_UNSUPPORTED              0xC0010028L
#define NDIS_STATUS_NO_ROUTE_TO_DESTINATION             0xC0010029L
#define NDIS_STATUS_TOKEN_RING_OPEN_ERROR               0xC0011000L
#if NDIS_SUPPORT_NDIS6
    #define NDIS_STATUS_SEND_ABORTED                    STATUS_NDIS_REQUEST_ABORTED
    #define NDIS_STATUS_PAUSED                          STATUS_NDIS_PAUSED
    #define NDIS_STATUS_INTERFACE_NOT_FOUND             STATUS_NDIS_INTERFACE_NOT_FOUND
    #define NDIS_STATUS_INVALID_PARAMETER               STATUS_INVALID_PARAMETER
    #define NDIS_STATUS_UNSUPPORTED_REVISION            STATUS_NDIS_UNSUPPORTED_REVISION
    #define NDIS_STATUS_INVALID_PORT                    STATUS_NDIS_INVALID_PORT
    #define NDIS_STATUS_INVALID_PORT_STATE              STATUS_NDIS_INVALID_PORT_STATE
    #define NDIS_STATUS_INVALID_STATE                   STATUS_INVALID_DEVICE_STATE
    #define NDIS_STATUS_MEDIA_DISCONNECTED              STATUS_NDIS_MEDIA_DISCONNECTED
    #define NDIS_STATUS_LOW_POWER_STATE                 STATUS_NDIS_LOW_POWER_STATE
    #define NDIS_STATUS_DOT11_AUTO_CONFIG_ENABLED \
        STATUS_NDIS_DOT11_AUTO_CONFIG_ENABLED
    #define NDIS_STATUS_DOT11_MEDIA_IN_USE              STATUS_NDIS_DOT11_MEDIA_IN_USE
    #define NDIS_STATUS_DOT11_POWER_STATE_INVALID \
        STATUS_NDIS_DOT11_POWER_STATE_INVALID
    #define NDIS_STATUS_UPLOAD_IN_PROGRESS              0xC0231001L
    #define NDIS_STATUS_REQUEST_UPLOAD                  0xC0231002L
    #define NDIS_STATUS_UPLOAD_REQUESTED                0xC0231003L
    #define NDIS_STATUS_OFFLOAD_TCP_ENTRIES             0xC0231004L
    #define NDIS_STATUS_OFFLOAD_PATH_ENTRIES            0xC0231005L
    #define NDIS_STATUS_OFFLOAD_NEIGHBOR_ENTRIES        0xC0231006L
    #define NDIS_STATUS_OFFLOAD_IP_ADDRESS_ENTRIES      0xC0231007L
    #define NDIS_STATUS_OFFLOAD_HW_ADDRESS_ENTRIES      0xC0231008L
    #define NDIS_STATUS_OFFLOAD_VLAN_ENTRIES            0xC0231009L
    #define NDIS_STATUS_OFFLOAD_TCP_XMIT_BUFFER         0xC023100AL
    #define NDIS_STATUS_OFFLOAD_TCP_RCV_BUFFER          0xC023100BL
    #define NDIS_STATUS_OFFLOAD_TCP_RCV_WINDOW          0xC023100CL
    #define NDIS_STATUS_OFFLOAD_VLAN_MISMATCH           0xC023100DL
    #define NDIS_STATUS_OFFLOAD_DATA_NOT_ACCEPTED       0xC023100EL
    #define NDIS_STATUS_OFFLOAD_POLICY                  0xC023100FL
    #define NDIS_STATUS_OFFLOAD_DATA_PARTIALLY_ACCEPTED 0xC0231010L
    #define NDIS_STATUS_OFFLOAD_REQUEST_RESET           0xC0231011L
#endif
#if NDIS_SUPPORT_NDIS620
    #define NDIS_STATUS_PM_WOL_PATTERN_LIST_FULL \
        STATUS_NDIS_PM_WOL_PATTERN_LIST_FULL
    #define NDIS_STATUS_PM_PROTOCOL_OFFLOAD_LIST_FULL \
        STATUS_NDIS_PM_PROTOCOL_OFFLOAD_LIST_FULL
    #define NDIS_STATUS_OFFLOAD_CONNECTION_REJECTED \
        STATUS_NDIS_OFFLOAD_CONNECTION_REJECTED
#endif

/* NDIS error codes */
#define NDIS_ERROR_CODE_RESOURCE_CONFLICT           EVENT_NDIS_RESOURCE_CONFLICT
#define NDIS_ERROR_CODE_OUT_OF_RESOURCES            EVENT_NDIS_OUT_OF_RESOURCE
#define NDIS_ERROR_CODE_HARDWARE_FAILURE            EVENT_NDIS_HARDWARE_FAILURE
#define NDIS_ERROR_CODE_ADAPTER_NOT_FOUND           EVENT_NDIS_ADAPTER_NOT_FOUND
#define NDIS_ERROR_CODE_INTERRUPT_CONNECT           EVENT_NDIS_INTERRUPT_CONNECT
#define NDIS_ERROR_CODE_DRIVER_FAILURE              EVENT_NDIS_DRIVER_FAILURE
#define NDIS_ERROR_CODE_BAD_VERSION                 EVENT_NDIS_BAD_VERSION
#define NDIS_ERROR_CODE_TIMEOUT                     EVENT_NDIS_TIMEOUT
#define NDIS_ERROR_CODE_NETWORK_ADDRESS             EVENT_NDIS_NETWORK_ADDRESS
#define NDIS_ERROR_CODE_UNSUPPORTED_CONFIGURATION   EVENT_NDIS_UNSUPPORTED_CONFIGURATION
#define NDIS_ERROR_CODE_INVALID_VALUE_FROM_ADAPTER  EVENT_NDIS_INVALID_VALUE_FROM_ADAPTER
#define NDIS_ERROR_CODE_MISSING_CONFIGURATION_PARAMETER \
    EVENT_NDIS_MISSING_CONFIGURATION_PARAMETER
#define NDIS_ERROR_CODE_BAD_IO_BASE_ADDRESS         EVENT_NDIS_BAD_IO_BASE_ADDRESS
#define NDIS_ERROR_CODE_RECEIVE_SPACE_SMALL         EVENT_NDIS_RECEIVE_SPACE_SMALL
#define NDIS_ERROR_CODE_ADAPTER_DISABLED            EVENT_NDIS_ADAPTER_DISABLED

/* NDIS read/write lock flags */
#if NDIS_SUPPORT_NDIS620
    #define NDIS_RWL_AT_DISPATCH_LEVEL  1
#endif

/* NDIS buffer macros */
#define NDIS_BUFFER_TO_SPAN_PAGES( x ) \
    (MmGetMdlByteCount( x ) == 0 ? 1 : (ADDRESS_AND_SIZE_TO_SPAN_PAGES( \
    MmGetMdlVirtualAddress( x ), MmGetMdlByteCount( x ) )))
#define NDIS_BUFFER_LINKAGE( x )    ((x)->Next)

/* NDIS maximum processor count */
#if NDIS_SUPPORT_60_COMPATIBLE_API && !defined( NDIS_WRAPPER )
    #define NDIS_MAX_PROCESSOR_COUNT    32
#endif

/* Macros that alias kernel functions */
#if NDIS_SUPPORT_NDIS6
    #if NDIS_SUPPORT_60_COMPATIBLE_API
        #define NDIS_CURRENT_PROCESSOR_NUMBER   KeGetCurrentProcessorNumber()
    #endif
    #define NDIS_CURRENT_IRQL()                 KeGetCurrentIrql()
    #define NDIS_RAISE_IRQL_TO_DISPATCH( x )    KeRaiseIrql( DISPATCH_LEVEL, x )
    #define NDIS_LOWER_IRQL( p1, p2 ) \
        { \
            if( (p1) != (p2) ) { \
                KeLowerIrql( p1 ); \
            } \
        }
    #define NDIS_INIT_MUTEX( x )                KeInitializeMutex( x, 0xFFFF )
    #define NDIS_RELEASE_MUTEX( x )             KeReleaseMutex( x, FALSE )
    #define NDIS_WAIT_FOR_MUTEX( x ) \
        KeWaitForSingleObject( x, Executive, KernelMode, FALSE, NULL );
#endif

/* NDIS configuration object revision number */
#if NDIS_SUPPORT_NDIS6
    #define NDIS_CONFIGURATION_OBJECT_REVISION_1    1
#endif

/* NDIS configuration flags */
#if NDIS_SUPPORT_NDIS6
    #define NDIS_CONFIG_FLAG_FILTER_INSTANCE_CONFIGURATION  0x00000001L
#endif

/* Network Plug and Play event flags */
#if NDIS_SUPPORT_NDIS6
    #define NET_EVENT_HALT_MINIPORT_ON_LOW_POWER    0x00000001L
#endif

/* Network Plug and Play event notification revision number */
#if NDIS_SUPPORT_NDIS6
    #define NET_PNP_EVENT_NOTIFICATION_REVISION_1   1
#endif

/* NDIS object identifier request constants */
#if NDIS_SUPPORT_NDIS6
    #define NDIS_OID_REQUEST_REVISION_1         1
    #define NDIS_OID_REQUEST_TIMEOUT_INFINITE   0
    #define NDIS_OID_REQUEST_NDIS_RESERVED_SIZE 16
#endif

/* NDIS status indication flags */
#if NDIS_SUPPORT_NDIS6
    #define NDIS_STATUS_INDICATION_FLAGS_MEDIA_CONNECT_TO_CONNECT   0x1000
#endif

/* NDIS status indication revision number */
#if NDIS_SUPPORT_NDIS6
    #define NDIS_STATUS_INDICATION_REVISION_1   1
#endif

/* NDIS timer characteristics revision number */
#if NDIS_SUPPORT_NDIS6
    #define NDIS_TIMER_CHARACTERISTICS_REVISION_1   1
#endif

/* NDIS lookahead size special value */
#if NDIS_SUPPORT_NDIS620
    #define NDIS_MAX_LOOKAHEAD_SIZE_ACCESSED_UNDEFINED  (-1)
#endif

/* NDIS restart general attributes flags */
#if NDIS_SUPPORT_NDIS620
    #define NDIS_RESTART_GENERAL_ATTRIBUTES_MAX_LOOKAHEAD_ACCESSED_DEFINED  0x00000001L
#endif

/* NDIS restart general attributes revision number */
#if NDIS_SUPPORT_NDIS6
    #define NDIS_RESTART_GENERAL_ATTRIBUTES_REVISION_1  1
#endif
#if NDIS_SUPPORT_NDIS620
    #define NDIS_RESTART_GENERAL_ATTRIBUTES_REVISION_2  2
#endif

/* NDIS system processor information revision number */
#if NDIS_SUPPORT_NDIS6 && NDIS_SUPPORT_60_COMPATIBLE_API
    #define NDIS_SYSTEM_PROCESSOR_INFO_REVISION_1   1
#endif

/* NDIS pause parameters */
#if NDIS_SUPPORT_NDIS6
    #define NDIS_PAUSE_NDIS_INTERNAL            0x00000001L
    #define NDIS_PAUSE_LOW_POWER                0x00000002L
    #define NDIS_PAUSE_BIND_PROTOCOL            0x00000004L
    #define NDIS_PAUSE_UNBIND_PROTOCOL          0x00000008L
    #define NDIS_PAUSE_ATTACH_FILTER            0x00000010L
    #define NDIS_PAUSE_DETACH_FILTER            0x00000020L
    #define NDIS_PAUSE_FILTER_RESTART_STACK     0x00000040L
    #define NDIS_PAUSE_MINIPORT_DEVICE_REMOVE   0x00000080L
#endif

/* NDIS filter interface flags */
#if (NTDDI_VERSION == 0x06000000) && (NDIS_LEGACY_DRIVER || NDIS_SUPPORT_NDIS6)
    #define NDIS_FILTER_INTERFACE_IM_FILTER 0x00000001L
    #define NDIS_FILTER_INTERFACE_LW_FILTER 0x00000002L
#endif

/* NDIS filter interface revision number */
#if (NTDDI_VERSION == 0x06000000) && (NDIS_LEGACY_DRIVER || NDIS_SUPPORT_NDIS6)
    #define NDIS_FILTER_INTERFACE_REVISION_1    1
#endif

/* NDIS enumerate filters revision number */
#if (NTDDI_VERSION == 0x06000000) && (NDIS_LEGACY_DRIVER || NDIS_SUPPORT_NDIS6)
    #define NDIS_ENUM_FILTERS_REVISION_1    1
#endif

/* NDIS device object attributes revision number */
#if (NTDDI_VERSION == 0x06000000) && (NDIS_LEGACY_DRIVER || NDIS_SUPPORT_NDIS6)
    #define NDIS_DEVICE_OBJECT_ATTRIBUTES_REVISION_1    1
#endif

/* NDIS object type device wrapper revision number */
#if (NTDDI_VERSION == 0x06000000) && (NDIS_LEGACY_DRIVER || NDIS_SUPPORT_NDIS6)
    #define NDIS_OBJECT_TYPE_DRIVER_WRAPPER_REVISION_1  1
#endif

/* NDIS shared memory parameters flags */
#if NDIS_SUPPORT_NDIS620
    #define NDIS_SHARED_MEM_PARAMETERS_CONTIGUOUS   0x00000001L
#endif

/* NDIS shared memory handle special value */
#if NDIS_SUPPORT_NDIS620
    #define NDIS_SHARED_MEM_HANDLE_HAL_ALLOCATED    NULL
#endif

/* NDIS shared memory parameters revision number */
#if NDIS_SUPPORT_NDIS620
    #define NDIS_SHARED_MEMORY_PARAMETERS_REVISION_1    1
#endif

/* NDIS shared memory provider characteristics revision number */
#if NDIS_SUPPORT_NDIS620
    #define NDIS_SHARED_MEMORY_PROVIDER_CHARACTERISTICS_REVISION_1  1
#endif

/* NDIS receive queue state revision number */
#if NDIS_SUPPORT_NDIS620
    #define NDIS_RECEIVE_QUEUE_STATE_REVISION_1 1
#endif

/* NDIS scatter/gather list parameters revision number */
#if NDIS_SUPPORT_NDIS620
    #define NDIS_SCATTER_GATHER_LIST_PARAMETERS_REVISION_1  1
#endif

/* NDIS NBL media-specific information revision number */
#if NDIS_SUPPORT_NDIS620
    #define NDIS_NBL_MEDIA_SPECIFIC_INFO_REVISION_1 1
#endif

/* NDIS media-specific information tags */
#if NDIS_SUPPORT_NDIS6 || NDIS60
    #define NDIS_MEDIA_SPECIFIC_INFO_TUNDL      0x00010001L
    #define NDIS_MEDIA_SPECIFIC_INFO_FCOE       0x80010000L
    #define NDIS_MEDIA_SPECIFIC_INFO_EAPOL      0x80010001L
    #define NDIS_MEDIA_SPECIFIC_INFO_LLDP       0x80010002L
    #define NDIS_MEDIA_SPECIFIC_INFO_TIMESYNC   0x80010003L
#endif

/* Network buffer list flags */
#if NDIS_SUPPORT_NDIS6 || NDIS60
    #define NBL_FLAGS_PROTOCOL_RESERVED         0xFFF00000L
    #define NBL_FLAGS_MINIPORT_RESERVED         0x0000F000L
    #define NBL_FLAGS_SCRATCH                   0x000F0000L
    #define NBL_FLAGS_NDIS_RESERVED             0x00000FFFL
    #define NDIS_PROT_RSVD_FLAGS                NBL_FLAGS_PROTOCOL_RESERVED
    #define NDIS_NBL_FLAGS_SEND_READ_ONLY       0x00000001L
    #define NDIS_NBL_FLAGS_RECV_READ_ONLY       0x00000002L
    #define NDIS_NBL_FLAGS_IS_LOOPBACK_PACKET   0x00008000L
#endif
#if NDIS_SUPPORT_NDIS61
    #define NDIS_NBL_FLAGS_HD_SPLIT             0x00000100L
    #define NDIS_NBL_FLAGS_IS_IPV4              0x00000200L
    #define NDIS_NBL_FLAGS_IS_IPV6              0x00000400L
    #define NDIS_NBL_FLAGS_IS_TCP               0x00000800L
    #define NDIS_NBL_FLAGS_IS_UDP               0x00001000L
    #define NDIS_NBL_FLAGS_SPLIT_AT_UPPER_LAYER_PROTOCOL_HEADER     0x00002000L
    #define NDIS_NBL_FLAGS_SPLIT_AT_UPPER_LAYER_PROTOCOL_PAYLOAD    0x00004000L
#endif

/* Macros to manipulate network buffer list flags */
#if NDIS_SUPPORT_NDIS6 || NDIS60
    #define NBL_TEST_FLAG( x, p )               (((x)->Flags & (p)) != 0)
    #define NBL_SET_FLAG( x, p )                ((x)->Flags |= (p))
    #define NBL_CLEAR_FLAG( x, p )              ((x)->Flags &= ~(p))
    #define NBL_SET_PROTOCOL_RSVD_FLAG( x, p ) \
        ((x)->Flags |= ((p) & NBL_FLAGS_PROTOCOL_RESERVED))
    #define NBL_CLEAR_PROTOCOL_RSVD_FLAG( x, p ) \
        ((x)->Flags &= ~((p) & NBL_FLAGS_PROTOCOL_RESERVED))
    #define NBL_TEST_PROTOCOL_RSVD_FLAG( x , p ) \
        (((x)->Flags & ((p) & NBL_FLAGS_PROTOCOL_RESERVED)) != 0)
    #define NBL_SET_PROT_RSVD_FLAG( x, p )      NBL_SET_PROTOCOL_RSVD_FLAG( x, p )
    #define NBL_CLEAR_PROT_RSVD_FLAG( x, p )    NBL_CLEAR_PROTOCOL_RSVD_FLAG( x, p )
    #define NBL_TEST_PROT_RSVD_FLAG( x, p )     NBL_TEST_PROTOCOL_RSVD_FLAG( x, p )
#endif

/* Network buffer list pool parameters revision number */
#if NDIS_SUPPORT_NDIS6 || NDIS60
    #define NET_BUFFER_LIST_POOL_PARAMETERS_REVISION_1  1
#endif

/* Network buffer pool parameters revision number */
#if NDIS_SUPPORT_NDIS6 || NDIS60
    #define NET_BUFFER_POOL_PARAMETERS_REVISION_1   1
#endif

/* NDIS send flags */
#if NDIS_SUPPORT_NDIS6 || NDIS60
    #define NDIS_SEND_FLAGS_DISPATCH_LEVEL      0x00000001L
    #define NDIS_SEND_FLAGS_CHECK_FOR_LOOPBACK  0x00000002L
#endif
#if NDIS_SUPPORT_NDIS620
    #define NDIS_SEND_FLAGS_SINGLE_QUEUE        0x00000004L
#endif

/* Macros to manipulate send flags */
#if NDIS_SUPPORT_NDIS6 || NDIS60
    #define NDIS_TEST_SEND_FLAG( x, p ) (((x) & (p)) == (p))
    #define NDIS_SET_SEND_FLAG( x, p )  ((x) |= (p))
    #define NDIS_TEST_SEND_AT_DISPATCH_LEVEL( x ) \
        NDIS_TEST_SEND_FLAG( x, NDIS_SEND_FLAGS_DISPATCH_LEVEL )
#endif

/* NDIS send complete flags */
#if NDIS_SUPPORT_NDIS6 || NDIS60
    #define NDIS_SEND_COMPLETE_FLAGS_DISPATCH_LEVEL 0x00000001L
#endif
#if NDIS_SUPPORT_NDIS620
    #define NDIS_SEND_COMPLETE_FLAGS_SINGLE_QUEUE   0x00000002L
#endif

/* Macros to manipulate send complete flags */
#if NDIS_SUPPORT_NDIS6 || NDIS60
    #define NDIS_TEST_SEND_COMPLETE_FLAG( x, p )    (((x) & (p)) == (p))
    #define NDIS_SET_SEND_COMPLETE_FLAG( x, p )     ((x) |= (p))
    #define NDIS_TEST_SEND_COMPLETE_AT_DISPATCH_LEVEL( x ) \
        NDIS_TEST_SEND_COMPLETE_FLAG( x, NDIS_SEND_COMPLETE_FLAGS_DISPATCH_LEVEL )
#endif

/* NDIS receive flags */
#if NDIS_SUPPORT_NDIS6 || NDIS60
    #define NDIS_RECEIVE_FLAGS_DISPATCH_LEVEL           0x00000001L
    #define NDIS_RECEIVE_FLAGS_RESOURCES                0x00000002L
    #define NDIS_RECEIVE_FLAGS_SINGLE_ETHER_TYPE        0x00000100L
    #define NDIS_RECEIVE_FLAGS_SINGLE_VLAN              0x00000200L
    #define NDIS_RECEIVE_FLAGS_PERFECT_FILTERED         0x00000400L
#endif
#if NDIS_SUPPORT_NDIS620
    #define NDIS_RECEIVE_FLAGS_SINGLE_QUEUE             0x00000800L
    #define NDIS_RECEIVE_FLAGS_SHARED_MEMORY_INFO_VALID 0x00001000L
    #define NDIS_RECEIVE_FLAGS_MORE_NBLS                0x00002000L
#endif

/* Macros to manipulate receive flags */
#if NDIS_SUPPORT_NDIS6 || NDIS60
    #define NDIS_TEST_RECEIVE_FLAG( x, p )  (((x) & (p)) == (p))
    #define NDIS_SET_RECEIVE_FLAG( x, p )   ((x) |= (p))
    #define NDIS_TEST_RECEIVE_AT_DISPATCH_LEVEL( x ) \
        NDIS_TEST_RECEIVE_FLAG( x, NDIS_RECEIVE_FLAGS_DISPATCH_LEVEL )
    #define NDIS_TEST_RECEIVE_CANNOT_PEND( x ) \
        NDIS_TEST_RECEIVE_FLAG( x, NDIS_RECEIVE_FLAGS_RESOURCES )
    #define NDIS_TEST_RECEIVE_CAN_PEND( x ) (((x) & NDIS_RECEIVE_FLAGS_RESOURCES) == 0)
#endif

/* NDIS return flags */
#if NDIS_SUPPORT_NDIS6 || NDIS60
    #define NDIS_RETURN_FLAGS_DISPATCH_LEVEL    0x00000001L
#endif
#if NDIS_SUPPORT_NDIS620
    #define NDIS_RETURN_FLAGS_SINGLE_QUEUE      0x00000002L
#endif

/* Macros to manipulate return flags */
#if NDIS_SUPPORT_NDIS6 || NDIS60
    #define NDIS_TEST_RETURN_FLAG( x, p )   (((x) & (p)) == (p))
    #define NDIS_SET_RETURN_FLAG( x, p )    ((x) |= (p))
    #define NDIS_TEST_RETURN_AT_DISPATCH_LEVEL( x ) \
        NDIS_TEST_RETURN_FLAG( x, NDIS_RETURN_FLAGS_DISPATCH_LEVEL )
#endif

/* NDIS clone flags */
#if NDIS_SUPPORT_NDIS6 || NDIS60
    #define NDIS_CLONE_FLAGS_USE_ORIGINAL_MDLS  0x00000002L
#endif

/* Macro to manipulate clone flags */
#if NDIS_SUPPORT_NDIS6 || NDIS60
    #define NDIS_TEST_CLONE_FLAG( x, p )    (((x) & (p)) == (p))
    #define NDIS_SET_CLONE_FLAG( x, p )     ((x) |= (p))
    #define NDIS_CLEAR_CLONE_FLAG( x, p )   ((x) &= ~(p))
#endif

/* NDIS task offload version number */
#define NDIS_TASK_OFFLOAD_VERSION   1

/* Hash constants */
#define MAX_HASHES          4
#define TRUNCATED_HASH_LEN  12

/* Cryptographic status codes */
#define CRYPTO_SUCCESS                      0
#define CRYPTO_GENERIC_ERROR                1
#define CRYPTO_TRANSPORT_AH_AUTH_FAILED     2
#define CRYPTO_TRANSPORT_ESP_AUTH_FAILED    3
#define CRYPTO_TUNNEL_AH_AUTH_FAILED        4
#define CRYPTO_TUNNEL_ESP_AUTH_FAILED       5
#define CRYPTO_INVALID_PACKET_SYNTAX        6
#define CRYPTO_INVALID_PROTOCOL             7

/* NDIS task TCP large send version number */
#if NDIS_LEGACY_DRIVER
    #define NDIS_TASK_TCP_LARGE_SEND_V0 0
#endif

/* IPsec flags */
#define IPSEC_TPT_UDPESP_ENCAPTYPE_IKE                  0x00000001L
#define IPSEC_TUN_UDPESP_ENCAPTYPE_IKE                  0x00000002L
#define IPSEC_TPTOVERTUN_UDPESP_ENCAPTYPE_IKE           0x00000004L
#define IPSEC_TPT_UDPESP_OVER_PURE_TUN_ENCAPTYPE_IKE    0x00000008L
#define IPSEC_TPT_UDPESP_ENCAPTYPE_OTHER                0x00000010L
#define IPSEC_TUN_UDPESP_ENCAPTYPE_OTHER                0x00000020L
#define IPSEC_TPTOVERTUN_UDPESP_ENCAPTYPE_OTHER         0x00000040L
#define IPSEC_TPT_UDPESP_OVER_PURE_TUN_ENCAPTYPE_OTHER  0x00000080L

/* NDIS large send offload constants */
#if NDIS_SUPPORT_NDIS6 || NDIS60
    #define NDIS_TCP_LARGE_SEND_OFFLOAD_V1_TYPE         0
    #define NDIS_TCP_LARGE_SEND_OFFLOAD_V2_TYPE         1
    #define NDIS_TCP_LARGE_SEND_OFFLOAD_IPv4            0
    #define NDIS_TCP_LARGE_SEND_OFFLOAD_IPv6            1
    #define NDIS_LARGE_SEND_OFFLOAD_MAX_HEADER_LENGTH   128
#endif

/* NDIS offload encapsulation revision number */
#if NDIS_SUPPORT_NDIS6 || NDIS60
    #define NDIS_OFFLOAD_ENCAPSULATION_REVISION_1   1
#endif

/* Maximum number of extension headers */
#if NDIS_SUPPORT_NDIS61
    #define IPSEC_OFFLOAD_V2_MAX_EXTENSION_HEADERS  2
#endif

/* IPsec offload (version 2) flags */
#if NDIS_SUPPORT_NDIS61
    #define IPSEC_OFFLOAD_V2_UDP_ESP_ENCAPSULATION_NONE                     0x00000000L
    #define IPSEC_OFFLOAD_V2_UDP_ESP_ENCAPSULATION_TRANSPORT                0x00000001L
    #define IPSEC_OFFLOAD_V2_UDP_ESP_ENCAPSULATION_TUNNEL                   0x00000002L
    #define IPSEC_OFFLOAD_V2_TRANSPORT_OVER_UDP_ESP_ENCAPSULATION_TUNNEL    0x00000004L
    #define IPSEC_OFFLOAD_V2_UDP_ESP_ENCAPSULATION_TRANSPORT_OVER_TUNNEL    0x00000008L
#endif

/* IPsec offload (version 2) security association flags */
#if NDIS_SUPPORT_NDIS61
    #define IPSEC_OFFLOAD_V2_ESN_SA 0x00000001L
#endif

/* IPsec offload (version 2) add security association flags */
#if NDIS_SUPPORT_NDIS61
    #define IPSEC_OFFLOAD_V2_INBOUND    0x00000001L
    #define IPSEC_OFFLOAD_V2_IPv6       0x00000010L
#endif

/* IPsec offload (version 2) add security association revision number */
#if NDIS_SUPPORT_NDIS61
    #define NDIS_IPSEC_OFFLOAD_V2_ADD_SA_REVISION_1 1
#endif

/* IPsec offload (version 2) delete security association revision number */
#if NDIS_SUPPORT_NDIS61
    #define NDIS_IPSEC_OFFLOAD_V2_DELETE_SA_REVISION_1  1
#endif

/* IPsec offload (version 2) update security association revision number */
#if NDIS_SUPPORT_NDIS61
    #define NDIS_IPSEC_OFFLOAD_V2_UPDATE_SA_REVISION_1  1
#endif

/* Protocol reserved size in packet */
#if NDIS_LEGACY_DRIVER
    #define PROTOCOL_RESERVED_SIZE_IN_PACKET    (4 * sizeof( PVOID ))
#endif

/* NDIS bind parameters revision numbers */
#if NDIS_SUPORT_NDIS6 || NDIS60
    #define NDIS_BIND_PARAMETERS_REVISION_1 1
#endif
#if NDIS_SUPPORT_NDIS61
    #define NDIS_BIND_PARAMETERS_REVISION_2 2
#endif
#if NDIS_SUPPORT_NDIS620
    #define NDIS_BIND_PARAMETERS_REVISION_3 3
#endif

/* NDIS protocol CO characteristics revision number */
#if NDIS_SUPPORT_NDIS6 || NDIS60
    #define NDIS_PROTOCOL_CO_CHARACTERISTICS_REVISION_1 1
#endif

/* NDIS protocol driver characteristics revision number */
#if NDIS_SUPPORT_NDIS6 || NDIS60
    #define NDIS_PROTOCOL_DRIVER_CHARACTERISTICS_REVISION_1 1
#endif
#if NDIS_SUPPORT_NDIS61
    #define NDIS_PROTOCOL_DRIVER_CHARACTERISTICS_REVISION_2 2
#endif

/* NDIS open parameters revision number */
#if NDIS_SUPPORT_NDIS6 || NDIS60
    #define NDIS_OPEN_PARAMETERS_REVISION_1 1
#endif

/* NDIS protocol pause parameters revision number */
#if NDIS_SUPPORT_NDIS6 || NDIS60
    #define NDIS_PROTOCOL_PAUSE_PARAMETERS_REVISION_1   1
#endif

/* NDIS protocol restart parameters revision number */
#if NDIS_SUPPORT_NDIS6 || NDIS60
    #define NDIS_PROTOCOL_RESTART_PARAMETERS_REVISION_1 1
#endif

/* NDIS maximum lookahead */
#define NDIS_M_MAX_LOOKAHEAD    526

/* NDIS miniport interrupt revision number */
#if NDIS_SUPPORT_NDIS6
    #define NDIS_MINIPORT_INTERRUPT_REVISION_1  1
#endif

/* NDIS miniport Plug and Play characteristics revision number */
#if NDIS_SUPPORT_NDIS6
    #define NDIS_MINIPORT_PNP_CHARACTERISTICS_REVISION_1    1
#endif

/* NDIS scatter/gather DMA description flags */
#if NDIS_SUPPORT_NDIS6
    #define NDIS_SG_DMA_64_BIT_ADDRESS  0x00000001L
#endif

/* NDIS scatter/gather DMA description revision number */
#if NDIS_SUPPORT_NDIS6
    #define NDIS_SG_DMA_DESCRIPTION_REVISION_1  1
#endif

/* NDIS miniport initialization parameters revision number */
#if NDIS_SUPPORT_NDIS6
    #define NDIS_MINIPORT_INIT_PARAMETERS_REVISION_1    1
#endif

/* NDIS miniport restart parameters revision number */
#if NDIS_SUPPORT_NDIS6
    #define NDIS_MINIPORT_RESTART_PARAMETERS_REVISION_1 1
#endif

/* NDIS miniport adapter registration attributes revision number */
#if NDIS_SUPPORT_NDIS6
    #define NDIS_MINIPORT_ADAPTER_REGISTRATION_ATTRIBUTES_REVISION_1    1
#endif

/* NDIS supported statistics flags */
#if NDIS_SUPPORT_NDIS6
    #define NDIS_STATISTICS_XMIT_OK_SUPPORTED               0x00000001L
    #define NDIS_STATISTICS_RCV_OK_SUPPORTED                0x00000002L
    #define NDIS_STATISTICS_XMIT_ERROR_SUPPORTED            0x00000004L
    #define NDIS_STATISTICS_RCV_ERROR_SUPPORTED             0x00000008L
    #define NDIS_STATISTICS_RCV_NO_BUFFER_SUPPORTED         0x00000010L
    #define NDIS_STATISTICS_DIRECTED_BYTES_XMIT_SUPPORTED   0x00000020L
    #define NDIS_STATISTICS_DIRECTED_FRAMES_XMIT_SUPPORTED  0x00000040L
    #define NDIS_STATISTICS_MULTICAST_BYTES_XMIT_SUPPORTED  0x00000080L
    #define NDIS_STATISTICS_MULTICAST_FRAMES_XMIT_SUPPORTED 0x00000100L
    #define NDIS_STATISTICS_BROADCAST_BYTES_XMIT_SUPPORTED  0x00000200L
    #define NDIS_STATISTICS_BROADCAST_FRAMES_XMIT_SUPPORTED 0x00000400L
    #define NDIS_STATISTICS_DIRECTED_BYTES_RCV_SUPPORTED    0x00000800L
    #define NDIS_STATISTICS_DIRECTED_FRAMES_RCV_SUPPORTED   0x00001000L
    #define NDIS_STATISTICS_MULTICAST_BYTES_RCV_SUPPORTED   0x00002000L
    #define NDIS_STATISTICS_MULTICAST_FRAMES_RCV_SUPPORTED  0x00004000L
    #define NDIS_STATISTICS_BROADCAST_BYTES_RCV_SUPPORTED   0x00008000L
    #define NDIS_STATISTICS_BROADCAST_FRAMES_RCV_SUPPORTED  0x00010000L
    #define NDIS_STATISTICS_RCV_CRC_ERROR_SUPPORTED         0x00020000L
    #define NDIS_STATISTICS_TRANSMIT_QUEUE_LENGTH_SUPPORTED 0x00040000L
    #define NDIS_STATISTICS_BYTES_RCV_SUPPORTED             0x00080000L
    #define NDIS_STATISTICS_BYTES_XMIT_SUPPORTED            0x00100000L
    #define NDIS_STATISTICS_RCV_DISCARDS_SUPPORTED          0x00200000L
    #define NDIS_STATISTICS_GEN_STATISTICS_SUPPORTED        0x00400000L
    #define NDIS_STATISTICS_XMIT_DISCARDS_SUPPORTED         0x08000000L
#endif

/* NDIS miniport add device registration attributes revision number */
#if NDIS_SUPPORT_NDIS6
    #define NDIS_MINIPORT_ADD_DEVICE_REGISTRATION_ATTRIBUTES_REVISION_1 1
#endif

/* NDIS miniport adapter general attributes revision numbers */
#if NDIS_SUPPORT_NDIS6
    #define NDIS_MINIPORT_ADAPTER_GENERAL_ATTRIBUTES_REVISION_1 1
#endif
#if NDIS_SUPPORT_NDIS620
    #define NDIS_MINIPORT_ADAPTER_GENERAL_ATTRIBUTES_REVISION_2 2
#endif

/* NDIS header/data split attributes revision number */
#if NDIS_SUPPORT_NDIS61
    #define NDIS_HD_SPLIT_ATTRIBUTES_REVISION_1 1
#endif

/* NDIS miniport adapter hardware assist attributes revision number */
#if NDIS_SUPPORT_NDIS61
    #define NDIS_MINIPORT_ADAPTER_HARDWARE_ASSIST_ATTRIBUTES_REVISION_1 1
#endif
#if NDIS_SUPPORT_NDIS620
    #define NDIS_MINIPORT_ADAPTER_HARDWARE_ASSIST_ATTRIBUTES_REVISION_2 2
#endif

/* NDIS miniport adapter offload attributes revision number */
#if NDIS_SUPPORT_NDIS6
    #define NDIS_MINIPORT_ADAPTER_OFFLOAD_ATTRIBUTES_REVISION_1 1
#endif

/* NDIS miniport adapter 802.11 attributes revision numbers */
#if NDIS_SUPPORT_NDIS6
    #define NDIS_MINIPORT_ADAPTER_802_11_ATTRIBUTES_REVISION_1  1
    #define NDIS_MINIPORT_ADAPTER_802_11_ATTRIBUTES_REVISION_2  2
#endif

/* NDIS miniport attributes */
#if NDIS_SUPPORT_NDIS6
    #define NDIS_MINIPORT_ATTRIBUTES_HARDWARE_DEVICE        0x00000001L
    #define NDIS_MINIPORT_ATTRIBUTES_NDIS_WDM               0x00000002L
    #define NDIS_MINIPORT_ATTRIBUTES_SURPRISE_REMOVE_OK     0x00000004L
    #define NDIS_MINIPORT_ATTRIBUTES_NOT_CO_NDIS            0x00000008L
    #define NDIS_MINIPORT_ATTRIBUTES_DO_NOT_BIND_TO_ALL_CO  0x00000010L
    #define NDIS_MINIPORT_ATTRIBUTES_NO_HALT_ON_SUSPEND     0x00000020L
    #define NDIS_MINIPORT_ATTRIBUTES_BUS_MASTER             0x00000040L
    #define NDIS_MINIPORT_ATTRIBUTES_CONTROLS_DEFAULT_PORT  0x00000080L
#endif

/* NDIS miniport pause parameters revision number */
#if NDIS_SUPPORT_NDIS6
    #define NDIS_MINIPORT_PAUSE_PARAMETERS_REVISION_1   1
#endif

/* Network device Plug and Play event revision number */
#if NDIS_SUPPORT_NDIS6
    #define NET_DEVICE_PNP_EVENT_REVISION_1 1
#endif

/* NDIS 6.0 miniport characteristic flags */
#if NDIS_SUPPORT_NDIS6
    #define NDIS_INTERMEDIATE_DRIVER    0x00000001L
    #define NDIS_WDM_DRIVER             0x00000002L
#endif

/* NDIS miniport driver characteristics revision number */
#if NDIS_SUPPORT_NDIS6
    #define NDIS_MINIPORT_DRIVER_CHARACTERISTICS_REVISION_1 1
#endif
#if NDIS_SUPPORT_NDIS61
    #define NDIS_MINIPORT_DRIVER_CHARACTERISTICS_REVISION_2 2
#endif

/* NDIS miniport CO characteristics revision number */
#if NDIS_SUPPORT_NDIS6
    #define NDIS_MINIPORT_CO_CHARACTERISTICS_REVISION_1 1
#endif

/* NDIS DMA sizes */
#define NDIS_DMA_24BITS 0
#define NDIS_DMA_32BITS 1
#define NDIS_DMA_64BITS 2

/* NDIS attributes */
#if NDIS_LEGACY_MINIPORT
    #define NDIS_ATTRIBUTE_IGNORE_PACKET_TIMEOUT        0x00000001L
    #define NDIS_ATTRIBUTE_IGNORE_REQUEST_TIMEOUT       0x00000002L
    #define NDIS_ATTRIBUTE_IGNORE_TOKEN_RING_ERRORS     0x00000004L
    #define NDIS_ATTRIBUTE_BUS_MASTER                   0x00000008L
    #define NDIS_ATTRIBUTE_INTERMEDIATE_DRIVER          0x00000010L
    #define NDIS_ATTRIBUTE_DESERIALIZE                  0x00000020L
    #define NDIS_ATTRIBUTE_NO_HALT_ON_SUSPEND           0x00000040L
    #define NDIS_ATTRIBUTE_SURPRISE_REMOVE_OK           0x00000080L
    #define NDIS_ATTRIBUTE_NOT_CO_NDIS                  0x00000100L
    #define NDIS_ATTRIBUTE_USES_SAFE_BUFFER_APIS        0x00000200L
    #define NDIS_ATTRIBUTE_DO_NOT_BIND_TO_ALL_CO        0x00000400L
    #define NDIS_ATTRIBUTE_MINIPORT_PADS_SHORT_PACKETS  0x00000800L
#endif

/* NDIS MSIX configuration parameters revision number */
#if NDIS_SUPPORT_NDIS61
    #define NDIS_MSIX_CONFIG_PARAMETERS_REVISION_1  1
#endif

/* NdisMAllocateNetBufferSGList() flags */
#if NDIS_SUPPORT_NDIS6
    #define NDIS_SG_LIST_WRITE_TO_DEVICE    0x00000001L
#endif

/* CO send flags */
#define CO_SEND_FLAG_SET_DISCARD_ELIBILITY  0x00000001L

/* CO media parameter flags */
#define RECEIVE_TIME_INDICATION 0x00000001L
#define USE_TIME_STAMPS         0x00000002L
#define TRANSMIT_VC             0x00000004L
#define RECEIVE_VC              0x00000008L
#define INDICATE_ERRED_PACKETS  0x00000010L
#define INDICATE_END_OF_TX      0x00000020L
#define RESERVE_RESOURCES_VC    0x00000040L
#define ROUND_DOWN_FLOW         0x00000080L
#define ROUND_UP_FLOW           0x00000100L

/* Erred packet indication */
#define ERRED_PACKET_INDICATION 0x00000001L

/* CO call parameter flags */
#define PERMANENT_VC            0x00000001L
#define CALL_PARAMETERS_CHANGED 0x00000002L
#define QUERY_CALL_PARAMETERS   0x00000004L
#define BROADCAST_VC            0x00000008L
#define MULTIPOINT_VC           0x00000010L

/* String formats */
#ifndef __NDISTAPI_STRINGFORMATS_DEFINED
    #define __NDISTAPI_STRINGFORMATS_DEFINED
    #define STRINGFORMAT_ASCII      0x00000001L
    #define STRINGFORMAT_DBCS       0x00000002L
    #define STRINGFORMAT_UNICODE    0x00000003L
    #define STRINGFORMAT_BINARY     0x00000004L
#endif

/* NDIS CO client optional handlers revision number */
#if NDIS_SUPPORT_NDIS6
    #define NDIS_CO_CLIENT_OPTIONAL_HANDLERS_REVISION_1 1
#endif

/* NDIS CO call manager optional handlers revision number */
#if NDIS_SUPPORT_NDIS6
    #define NDIS_CO_CALL_MANAGER_OPTIONAL_HANDLERS_REVISION_1   1
#endif

/* NDIS filter attach flags */
#if NDIS_SUPPORT_NDIS6
    #define NDIS_FILTER_ATTACH_FLAGS_IGNORE_MANDATORY   0x00000001L
#endif

/* NDIS filter attach parameters revision numbers */
#if NDIS_SUPPORT_NDIS6
    #define NDIS_FILTER_ATTACH_PARAMETERS_REVISION_1    1
#endif
#if NDIS_SUPPORT_NDIS61
    #define NDIS_FILTER_ATTACH_PARAMETERS_REVISION_2    2
#endif
#if NDIS_SUPPORT_NDIS620
    #define NDIS_FILTER_ATTACH_PARAMETERS_REVISION_3    3
#endif

/* NDIS filter restart parameters revision number */
#if NDIS_SUPPORT_NDIS6
    #define NDIS_FILTER_RESTART_PARAMETERS_REVISION_1   1
#endif

/* NDIS filter pause parameters revision number */
#if NDIS_SUPPORT_NDIS6
    #define NDIS_FILTER_PAUSE_PARAMETERS_REVISION_1 1
#endif

/* NDIS filter partial characteristics revision number */
#if NDIS_SUPPORT_NDIS6
    #define NDIS_FILTER_PARTIAL_CHARACTERISTICS_REVISION_1  1
#endif

/* NDIS filter driver mandatory */
#if NDIS_SUPPORT_NDIS6
    #define NDIS_FILTER_DRIVER_MANDATORY    0x00000001L
#endif

/* NDIS filter characteristics revision numbers */
#if NDIS_SUPPORT_NDIS6
    #define NDIS_FILTER_CHARACTERISTICS_REVISION_1  1
#endif
#if NDIS_SUPPORT_NDIS61
    #define NDIS_FILTER_CHARACTERISTICS_REVISION_2  2
#endif

/* NDIS filter attributes revision number */
#if NDIS_SUPPORT_NDIS6
    #define NDIS_FILTER_ATTRIBUTES_REVISION_1   1
#endif

/* Opaque data types */
#if NDIS_SUPPORT_NDIS620
typedef struct _NDIS_RW_LOCK_EX                     NDIS_RW_LOCK_EX;
typedef struct _NDIS_RW_LOCK_EX                     *PNDIS_RW_LOCK_EX;
#endif
typedef struct _NDIS_WRAPPER_HANDLE                 NDIS_WRAPPER_HANDLE;
typedef struct _NDIS_WRAPPER_HANDLE                 *PNDIS_WRAPPER_HANDLE;
typedef struct _NDIS_PROTOCOL_BLOCK                 NDIS_PROTOCOL_BLOCK;
typedef struct _NDIS_PROTOCOL_BLOCK                 *PNDIS_PROTOCOL_BLOCK;
typedef struct _NDIS_M_DRIVER_BLOCK                 NDIS_M_DRIVER_BLOCK;
typedef struct _NDIS_M_DRIVER_BLOCK                 *PNDIS_M_DRIVER_BLOCK;
typedef struct _CO_CALL_PARAMETERS                  CO_CALL_PARAMETERS;
typedef struct _CO_CALL_PARAMETERS                  *PCO_CALL_PARAMETERS;
typedef struct _CO_MEDIA_PARAMETERS                 CO_MEDIA_PARAMETERS;
typedef struct _CO_MEDIA_PARAMETERS                 *PCO_MEDIA_PARAMETERS;
#if (NTDDI_VERSION < 0x06000000) && !NDIS_SUPPORT_NDIS6
typedef struct _NDIS_OFFLOAD                        NDIS_OFFLOAD;
typedef struct _NDIS_OFFLOAD                        *PNDIS_OFFLOAD;
#endif
typedef struct _NDIS_AF_LIST                        NDIS_AF_LIST;
typedef struct _NDIS_AF_LIST                        *PNDIS_AF_LIST;
typedef struct _X_FILTER                            ETH_FILTER;
typedef struct _X_FILTER                            *PETH_FILTER;
typedef struct _X_FILTER                            TR_FILTER;
typedef struct _X_FILTER                            *PTR_FILTER;
typedef struct _X_FILTER                            NULL_FILTER;
typedef struct _X_FILTER                            *PNULL_FILTER;

/* Network Plug and Play event codes */
typedef enum _NET_PNP_EVENT_CODE {
    NetEventSetPower            = 0,
    NetEventQueryPower          = 1,
    NetEventQueryRemoveDevice   = 2,
    NetEventCancelRemoveDevice  = 3,
    NetEventReconfigure         = 4,
    NetEventBindList            = 5,
    NetEventBindsComplete       = 6,
    NetEventPnPCapabilities     = 7,
    NetEventPause               = 8,
    NetEventRestart             = 9,
    NetEventPortActivation      = 10,
    NetEventPortDeactivation    = 11,
    NetEventIMReEnableDevice    = 12,
    NetEventMaximum             = 13
} NET_PNP_EVENT_CODE;
typedef NET_PNP_EVENT_CODE  *PNET_PNP_EVENT_CODE;

/* Network Plug and Play event */
typedef struct _NET_PNP_EVENT {
    NET_PNP_EVENT_CODE  NetEvent;
    PVOID               Buffer;
    ULONG               BufferLength;
    ULONG_PTR           NdisReserved[4];
    ULONG_PTR           TransportReserved[4];
    ULONG_PTR           TdiReserved[4];
    ULONG_PTR           TdiClientReserved[4];
} NET_PNP_EVENT;
typedef NET_PNP_EVENT   *PNET_PNP_EVENT;

/* Network device power states */
typedef enum _NET_DEVICE_POWER_STATE {
    NetDeviceStateUnspecified   = 0,
    NetDeviceStateD0            = 1,
    NetDeviceStateD1            = 2,
    NetDeviceStateD2            = 3,
    NetDeviceStateD3            = 4,
    NetDeviceStateMaximum       = 5
} NET_DEVICE_POWER_STATE;
typedef NET_DEVICE_POWER_STATE  *PNET_DEVICE_POWER_STATE;

/* NDIS generic object */
#if NDIS_SUPPORT_NDIS6
typedef struct _NDIS_GENERIC_OBJECT {
    NDIS_OBJECT_HEADER  Header;
    PVOID               Caller;
    PVOID               CallersCaller;
    PDRIVER_OBJECT      DriverObject;
} NDIS_GENERIC_OBJECT;
typedef NDIS_GENERIC_OBJECT *PNDIS_GENERIC_OBJECT;
#endif

/* NDIS spin lock */
typedef struct _NDIS_SPIN_LOCK {
    KSPIN_LOCK  SpinLock;
    KIRQL       OldIrql;
} NDIS_SPIN_LOCK;
typedef NDIS_SPIN_LOCK  *PNDIS_SPIN_LOCK;

/* NDIS event */
typedef struct _NDIS_EVENT {
    KEVENT  Event;
} NDIS_EVENT;
typedef NDIS_EVENT  *PNDIS_EVENT;

/* NDIS procedure */
typedef VOID (NTAPI *NDIS_PROC)( struct _NDIS_WORK_ITEM *, PVOID );

/* NDIS work item */
typedef struct _NDIS_WORK_ITEM {
    PVOID       Context;
    NDIS_PROC   Routine;
    UCHAR       WrapperReserved[8 * sizeof( PVOID )];
} NDIS_WORK_ITEM;
typedef NDIS_WORK_ITEM  *PNDIS_WORK_ITEM;

/* NDIS parameter types */
typedef enum _NDIS_PARAMETER_TYPE {
    NdisParameterInteger        = 0,
    NdisParameterHexInteger     = 1,
    NdisParameterString         = 2,
    NdisParameterMultiString    = 3,
    NdisParameterBinary         = 4
} NDIS_PARAMETER_TYPE;
typedef NDIS_PARAMETER_TYPE *PNDIS_PARAMETER_TYPE;

/* Binary data */
typedef struct {
    USHORT  Length;
    PVOID   Buffer;
} BINARY_DATA;

/* NDIS configuration parameter */
typedef struct _NDIS_CONFIGURATION_PARAMETER {
    NDIS_PARAMETER_TYPE ParameterType;
    union {
        ULONG       IntegerData;
        NDIS_STRING StringData;
        BINARY_DATA BinaryData;
    } ParameterData;
} NDIS_CONFIGURATION_PARAMETER;
typedef NDIS_CONFIGURATION_PARAMETER    *PNDIS_CONFIGURATION_PARAMETER;

/* NDIS processor types */
typedef enum _NDIS_PROCESSOR_TYPE {
    NdisProcessorX86    = 0,
    NdisProcessorMips   = 1,
    NdisProcessorAlpha  = 2,
    NdisProcessorPpc    = 3,
    NdisProcessorAmd64  = 4,
    NdisProcessorIA64   = 5
} NDIS_PROCESSOR_TYPE;
typedef NDIS_PROCESSOR_TYPE *PNDIS_PROCESSOR_TYPE;

/* NDIS environment types */
typedef enum _NDIS_ENVIRONMENT_TYPE {
    NdisEnvironmentWindows      = 0,
    NdisEnvironmentWindowsNt    = 1
} NDIS_ENVIRONMENT_TYPE;
typedef NDIS_ENVIRONMENT_TYPE   *PNDIS_ENVIRONMENT_TYPE;

/* NDIS interface types */
typedef enum _NDIS_INTERFACE_TYPE {
    NdisInterfaceInternal           = Internal,
    NdisInterfaceIsa                = Isa,
    NdisInterfaceEisa               = Eisa,
    NdisInterfaceMca                = MicroChannel,
    NdisInterfaceTurboChannel       = TurboChannel,
    NdisInterfacePci                = PCIBus,
    NdisInterfacePcMcia             = PCMCIABus,
    NdisInterfaceCBus               = CBus,
    NdisInterfaceMPIBus             = MPIBus,
    NdisInterfaceMPSABus            = MPSABus,
    NdisInterfaceProcessorInternal  = ProcessorInternal,
    NdisInterfaceInternalPowerBus   = InternalPowerBus,
    NdisInterfacePNPISABus          = PNPISABus,
    NdisInterfacePNPBus             = PNPBus,
    NdisInterfaceUSB                = 16,
    NdisInterfaceIrda               = 17,
    NdisInterface1394               = 18,
    NdisMaximumInterfaceType        = 19
} NDIS_INTERFACE_TYPE;
typedef NDIS_INTERFACE_TYPE *PNDIS_INTERFACE_TYPE;

/* NDIS WAN line up */
typedef struct _NDIS_WAN_LINE_UP {
    ULONG               LinkSpeed;
    ULONG               MaximumTotalSize;
    NDIS_WAN_QUALITY    Quality;
    USHORT              SendWindow;
    UCHAR               RemoteAddress[6];
    UCHAR               LocalAddress[6];
    ULONG               ProtocolBufferLength;
    PUCHAR              ProtocolBuffer;
    USHORT              ProtocolType;
    NDIS_STRING         DeviceName;
} NDIS_WAN_LINE_UP;
typedef NDIS_WAN_LINE_UP    *PNDIS_WAN_LINE_UP;

/* NDIS WAN line down */
typedef struct _NDIS_WAN_LINE_DOWN {
    UCHAR   RemoteAddress[6];
    UCHAR   LocalAddress[6];
} NDIS_WAN_LINE_DOWN;
typedef NDIS_WAN_LINE_DOWN  *PNDIS_WAN_LINE_DOWN;

/* NDIS WAN fragment */
typedef struct _NDIS_WAN_FRAGMENT {
    UCHAR   RemoteAddress[6];
    UCHAR   LocalAddress[6];
} NDIS_WAN_FRAGMENT;
typedef NDIS_WAN_FRAGMENT   *PNDIS_WAN_FRAGMENT;

/* NDIS WAN get statistics */
typedef struct _NDIS_WAN_GET_STATS {
    UCHAR   LocalAddress[6];
    ULONG   BytesSent;
    ULONG   BytesRcvd;
    ULONG   FramesSent;
    ULONG   FramesRcvd;
    ULONG   CRCErrors;
    ULONG   TimeoutErrors;
    ULONG   AlignmentErrors;
    ULONG   SerialOverrunErrors;
    ULONG   FramingErrors;
    ULONG   BufferOverrunErrors;
    ULONG   BytesTransmittedUncompressed;
    ULONG   BytesReceivedUncompressed;
    ULONG   BytesTransmittedCompressed;
    ULONG   BytesReceivedCompressed;
} NDIS_WAN_GET_STATS;
typedef NDIS_WAN_GET_STATS  *PNDIS_WAN_GET_STATS;

/* NDIS private packet */
#if NDIS_LEGACY_DRIVER
typedef struct _NDIS_PACKET_PRIVATE {
    UINT                PhysicalCount;
    UINT                TotalLength;
    PNDIS_BUFFER        Head;
    PNDIS_BUFFER        Tail;
    PNDIS_PACKET_POOL   Pool;
    UINT                Count;
    ULONG               Flags;
    BOOLEAN             ValidCounts;
    UCHAR               NdisPacketFlags;
    USHORT              NdisPacketOobOffset;
} NDIS_PACKET_PRIVATE;
typedef NDIS_PACKET_PRIVATE *PNDIS_PACKET_PRIVATE;
#endif

/* NDIS class identifiers */
typedef enum _NDIS_CLASS_ID {
    NdisClass802_3Priority          = 0,
    NdisClassWirelessWanMbxMailbox  = 1,
    NdisClassIrdaPacketInfo         = 2,
    NdisClassAtmAALInfo             = 3
} NDIS_CLASS_ID;

/* Media specific information */
typedef struct _MEDIA_SPECIFIC_INFORMATION {
    UINT            NextEntryOffset;
    NDIS_CLASS_ID   ClassId;
    UINT            Size;
    UCHAR           ClassInformation[1];
} MEDIA_SPECIFIC_INFORMATION;
typedef MEDIA_SPECIFIC_INFORMATION  *PMEDIA_SPECIFIC_INFORMATION;

/* NDIS packet OOB data */
#if NDIS_LEGACY_DRIVER
typedef struct _NDIS_PACKET_OOB_DATA {
    union {
        ULONGLONG   TimeToSend;
        ULONGLONG   TimeSent;
    };
    ULONGLONG   TimeReceived;
    UINT        HeaderSize;
    UINT        SizeMediaSpecificInfo;
    PVOID       MediaSpecificInformation;
    NDIS_STATUS Status;
} NDIS_PACKET_OOB_DATA;
typedef NDIS_PACKET_OOB_DATA    *PNDIS_PACKET_OOB_DATA;
#endif

/* NDIS packet */
#if NDIS_LEGACY_DRIVER
typedef struct _NDIS_PACKET {
    NDIS_PACKET_PRIVATE Private;
    union {
        struct {
            UCHAR   MiniportReserved[2 * sizeof( PVOID )];
            UCHAR   WrapperReserved[2 * sizeof( PVOID )];
        };
        struct {
            UCHAR   MiniportReservedEx[3 * sizeof( PVOID )];
            UCHAR   WrapperReservedEx[sizeof( PVOID )];
        };
        struct {
            UCHAR   MacReserved[4 * sizeof( PVOID )];
        };
    };
    ULONG_PTR           Reserved[2];
    UCHAR               ProtocolReserved[1];
} NDIS_PACKET;
typedef NDIS_PACKET *PNDIS_PACKET;
typedef NDIS_PACKET **PPNDIS_PACKET;
#endif

/* NDIS per packet information */
typedef enum _NDIS_PER_PACKET_INFO {
    TcpIpChecksumPacketInfo         = 0,
    IpSecPacketInfo                 = 1,
    TcpLargeSendPacketInfo          = 2,
    ClassificationHandlePacketInfo  = 3,
    ScatterGatherListPacketInfo     = 5,
    Ieee8021QInfo                   = 6,
    OriginalPacketInfo              = 7,
    PacketCancelId                  = 8,
    OriginalNetBufferList           = 9,
    CachedNetBufferList             = 10,
    ShortPacketPaddingInfo          = 11,
    MaxPerPacketInfo                = 12
} NDIS_PER_PACKET_INFO;
typedef NDIS_PER_PACKET_INFO    *PNDIS_PER_PACKET_INFO;
#if NDIS_LEGACY_DRIVER
    #define Ieee8021pPriority   Ieee8021QInfo
#endif

/* NDIS packet extension */
#if NDIS_LEGACY_DRIVER
typedef struct _NDIS_PACKET_EXTENSION {
    PVOID   NdisPacketInfo[MaxPerPacketInfo];
} NDIS_PACKET_EXTENSION;
typedef NDIS_PACKET_EXTENSION *PNDIS_PACKET_EXTENSION;
#endif

/* NDIS packet stack */
#if NDIS_LEGACY_DRIVER
typedef struct _NDIS_PACKET_STACK {
    ULONG_PTR   IMReserved[2];
    ULONG_PTR   NdisReserved[4];
} NDIS_PACKET_STACK;
typedef NDIS_PACKET_STACK   *PNDIS_PACKET_STACK;
#endif

/* NDIS TCP/IP checksum packet information */
typedef struct _NDIS_TCP_IP_CHECKSUM_PACKET_INFO {
    union {
        struct {
            ULONG   NdisPacketChecksumV4    : 1;
            ULONG   NdisPacketChecksumV6    : 1;
            ULONG   NdisPacketTcpChecksum   : 1;
            ULONG   NdisPacketUdpChecksum   : 1;
            ULONG   NdisPacketIpChecksum    : 1;
        } Transmit;
        struct {
            ULONG   NdisPacketTcpChecksumFailed     : 1;
            ULONG   NdisPacketUdpChecksumFailed     : 1;
            ULONG   NdisPacketIpChecksumFailed      : 1;
            ULONG   NdisPacketTcpChecksumSucceeded  : 1;
            ULONG   NdisPacketUdpChecksumSucceeded  : 1;
            ULONG   NdisPacketIpChecksumSucceeded   : 1;
            ULONG   NdisPacketLoopback              : 1;
        } Receive;
        ULONG   Value;
    };
} NDIS_TCP_IP_CHECKSUM_PACKET_INFO;
typedef NDIS_TCP_IP_CHECKSUM_PACKET_INFO    *PNDIS_TCP_IP_CHECKSUM_PACKET_INFO;

/* NDIS packet 8021Q information */
typedef struct _NDIS_PACKET_8021Q_INFO {
    union {
        struct {
            UINT32  UserPriority        : 3;
            UINT32  CanonicalFormatId   : 1;
            UINT32  VlanId              : 12;
            UINT32  Reserved            : 16;
        } TagHeader;
        PVOID   Value;
    };
} NDIS_PACKET_8021Q_INFO;
typedef NDIS_PACKET_8021Q_INFO  *PNDIS_PACKET_8021Q_INFO;

/* NDIS WAN packet */
#if NDIS_LEGACY_DRIVER
typedef struct _NDIS_WAN_PACKET {
    LIST_ENTRY  WanPocketQueue;
    PUCHAR      CurrentBuffer;
    ULONG       CurrentLength;
    PUCHAR      StartBuffer;
    PUCHAR      EndBuffer;
    PVOID       ProtocolReserved1;
    PVOID       ProtocolReserved2;
    PVOID       ProtocolReserved3;
    PVOID       ProtocolReserved4;
    PVOID       MacReserved1;
    PVOID       MacReserved2;
    PVOID       MacReserved3;
    PVOID       MacReserved4;
} NDIS_WAN_PACKET;
typedef NDIS_WAN_PACKET *PNDIS_WAN_PACKET;
#endif

/* NDIS request types */
typedef enum _NDIS_REQUEST_TYPE {
    NdisRequestQueryInformation = 0,
    NdisRequestSetInformation   = 1,
    NdisRequestQueryStatistics  = 2,
    NdisRequestOpen             = 3,
    NdisRequestClose            = 4,
    NdisRequestSend             = 5,
    NdisRequestTransferData     = 6,
    NdisRequestReset            = 7,
    NdisRequestGeneric1         = 8,
    NdisRequestGeneric2         = 9,
    NdisRequestGeneric3         = 10,
#if NDIS_SUPPORT_NDIS6
    NdisRequestGeneric4         = 11,
    NdisRequestMethod           = 12
#else
    NdisRequestGeneric4         = 11
#endif
} NDIS_REQUEST_TYPE;
typedef NDIS_REQUEST_TYPE   *PNDIS_REQUEST_TYPE;

/* NDIS request */
#if NDIS_LEGACY_DRIVER
typedef struct _NDIS_REQUEST {
    UCHAR               MacReserved[4 * sizeof( PVOID )];
    NDIS_REQUEST_TYPE   RequestType;
    union _DATA {
        struct _QUERY_INFORMATION {
            NDIS_OID    Oid;
            PVOID       InformationBuffer;
            UINT        InformationBufferLength;
            UINT        BytesWritten;
            UINT        BytesNeeded;
        } QUERY_INFORMATION;
        struct _SET_INFORMATION {
            NDIS_OID    Oid;
            PVOID       InformationBuffer;
            UINT        InformationBufferLength;
            UINT        BytesRead;
            UINT        BytesNeeded;
        } SET_INFORMATION;
    } DATA;
#if defined( NDIS50 ) || defined( NDIS51 ) || defined( NDIS50_MINIPORT ) || \
    defined( NDIS51_MINIPORT )
    UCHAR               NdisReserved[9 * sizeof( PVOID )];
    union {
        UCHAR   CallMgrReserved[2 * sizeof( PVOID )];
        UCHAR   ProtocolReserved[2 * sizeof( PVOID )];
    };
    UCHAR               MiniportReserved[2 * sizeof( PVOID )];
#endif
} NDIS_REQUEST;
typedef NDIS_REQUEST    *PNDIS_REQUEST;
#endif

/* CO address family */
typedef struct {
    NDIS_AF AddressFamily;
    ULONG   MajorVersion;
    ULONG   MinorVersion;
} CO_ADDRESS_FAMILY;
typedef CO_ADDRESS_FAMILY   *PCO_ADDRESS_FAMILY;

/* CO sap */
typedef struct {
    ULONG   SapType;
    ULONG   SapLength;
    UCHAR   Sap[1];
} CO_SAP;
typedef CO_SAP  *PCO_SAP;

/* NDIS physical address unit */
typedef struct _NDIS_PHYSICAL_ADDRESS_UNIT {
    NDIS_PHYSICAL_ADDRESS   PhysicalAddress;
    UINT                    Length;
} NDIS_PHYSICAL_ADDRESS_UNIT;
typedef NDIS_PHYSICAL_ADDRESS_UNIT  *PNDIS_PHYSICAL_ADDRESS_UNIT;

/* Reference */
typedef struct _REFERENCE {
    KSPIN_LOCK  SpinLock;
    USHORT      ReferenceCount;
    BOOLEAN     Closing;
} REFERENCE;
typedef REFERENCE   *PREFERENCE;

/* NDIS read/write lock reference count */
#if NDIS_SUPPORT_60_COMPATIBLE_API
typedef struct _NDIS_RW_LOCK_REFCOUNT {
    ULONG   RefCount;
    UCHAR   cacheLine[16];
} NDIS_RW_LOCK_REFCOUNT;
typedef NDIS_RW_LOCK_REFCOUNT   *PNDIS_RW_LOCK_REFCOUNT;
#endif

/* NDIS read/write lock */
#if NDIS_SUPPORT_60_COMPATIBLE_API
typedef struct _NDIS_RW_LOCK {
    union {
        struct {
            KSPIN_LOCK  SpinLock;
            PVOID       Context;
        };
        UCHAR   Reserved[16];
    };
    union {
        NDIS_RW_LOCK_REFCOUNT   RefCount[MAXIMUM_PROCESSORS];
        ULONG                   RefCountEx[sizeof( NDIS_RW_LOCK_REFCOUNT ) /
                                           sizeof( ULONG ) * MAXIMUM_PROCESSORS];
        struct {
            KSPIN_LOCK          RefCountLock;
            volatile ULONG      SharedRefCount;
            volatile BOOLEAN    WriterWaiting;
        };
    };
} NDIS_RW_LOCK;
typedef NDIS_RW_LOCK    *PNDIS_RW_LOCK;
#endif

/* Lock state */
#if NDIS_SUPPORT_60_COMPATIBLE_API
typedef struct _LOCK_STATE {
    USHORT  LockState;
    KIRQL   OldIrql;
} LOCK_STATE;
typedef LOCK_STATE  *PLOCK_STATE;
#endif

/* Lock state (extended version) */
#if NDIS_SUPPORT_NDIS620
typedef struct _LOCK_STATE_EX {
    KIRQL   OldIrql;
    UCHAR   LockState;
    UCHAR   Flags;
} LOCK_STATE_EX;
typedef LOCK_STATE_EX   *PLOCK_STATE_EX;
#endif

/* NDIS timer callback */
typedef VOID (NTAPI NDIS_TIMER_FUNCTION)( PVOID, PVOID, PVOID, PVOID );
typedef NDIS_TIMER_FUNCTION *PNDIS_TIMER_FUNCTION;

/* NDIS timer */
typedef struct _NDIS_TIMER {
    KTIMER  Timer;
    KDPC    Dpc;
} NDIS_TIMER;
typedef NDIS_TIMER  *PNDIS_TIMER;

/* NDIS restart attributes */
#if NDIS_SUPPORT_NDIS6
typedef struct _NDIS_RESTART_ATTRIBUTES {
    struct _NDIS_RESTART_ATTRIBUTES *Next;
    NDIS_OID                        Oid;
    ULONG                           DataLength;
    UCHAR                           Data[1];
} NDIS_RESTART_ATTRIBUTES;
typedef NDIS_RESTART_ATTRIBUTES *PNDIS_RESTART_ATTRIBUTES;
#endif

/* NDIS handlers */
#if NDIS_SUPPORT_NDIS6
typedef NDIS_STATUS (NTAPI SET_OPTIONS)( NDIS_HANDLE, NDIS_HANDLE );
typedef SET_OPTIONS *SET_OPTIONS_HANDLER;
typedef SET_OPTIONS MINIPORT_SET_OPTIONS;
typedef SET_OPTIONS PROTOCOL_SET_OPTIONS;
typedef SET_OPTIONS FILTER_SET_OPTIONS;
#endif
#if NDIS_LEGACY_DRIVER
typedef NDIS_STATUS (NTAPI *WAN_SEND_HANDLER)( NDIS_HANDLE, NDIS_HANDLE, PVOID );
typedef NDIS_STATUS (NTAPI *SEND_HANDLER)( NDIS_HANDLE, PNDIS_PACKET );
typedef NDIS_STATUS (NTAPI *TRANSFER_DATA_HANDLER)( NDIS_HANDLE, NDIS_HANDLE, UINT, UINT, PNDIS_PACKET, PUINT );
typedef NDIS_STATUS (NTAPI *RESET_HANDLER)( NDIS_HANDLE );
typedef NDIS_STATUS (NTAPI *REQUEST_HANDLER)( NDIS_HANDLE, PNDIS_REQUEST );
typedef VOID (NTAPI *SEND_PACKETS_HANDLER)( NDIS_HANDLE, PPNDIS_PACKET, UINT );
#endif

/* NDIS configuration object */
#if NDIS_SUPPORT_NDIS6
typedef struct _NDIS_CONFIGURATION_OBJECT {
    NDIS_OBJECT_HEADER  Header;
    NDIS_HANDLE         NdisHandle;
    ULONG               Flags;
} NDIS_CONFIGURATION_OBJECT;
typedef NDIS_CONFIGURATION_OBJECT   *PNDIS_CONFIGURATION_OBJECT;
#endif

/* NDIS driver optional handlers */
#if NDIS_SUPPORT_NDIS6
typedef struct _NDIS_DRIVER_OPTIONAL_HANDLERS {
    NDIS_OBJECT_HEADER  Header;
} NDIS_DRIVER_OPTIONAL_HANDLERS;
typedef NDIS_DRIVER_OPTIONAL_HANDLERS   *PNDIS_DRIVER_OPTIONAL_HANDLERS;
#endif

/* Network Plug and Play event notification */
#if NDIS_SUPPORT_NDIS6
typedef struct _NET_PNP_EVENT_NOTIFICATION {
    NDIS_OBJECT_HEADER  Header;
    NDIS_PORT_NUMBER    PortNumber;
    NET_PNP_EVENT       NetPnPEvent;
    ULONG               Flags;
} NET_PNP_EVENT_NOTIFICATION;
typedef NET_PNP_EVENT_NOTIFICATION  *PNET_PNP_EVENT_NOTIFICATION;
#endif

/* NDIS object identifier request */
#if NDIS_SUPPORT_NDIS6
typedef struct _NDIS_OID_REQUEST {
    NDIS_OBJECT_HEADER  Header;
    NDIS_REQUEST_TYPE   RequestType;
    NDIS_PORT_NUMBER    PortNumber;
    UINT                Timeout;
    PVOID               RequestId;
    NDIS_HANDLE         RequestHandle;
    union _REQUEST_DATA {
        struct _QUERY {
            NDIS_OID    Oid;
            PVOID       InformationBuffer;
            UINT        InformationBufferLength;
            UINT        BytesWritten;
            UINT        BytesNeeded;
        } QUERY_INFORMATION;
        struct _SET {
            NDIS_OID    Oid;
            PVOID       InformationBuffer;
            UINT        InformationBufferLength;
            UINT        BytesRead;
            UINT        BytesNeeded;
        } SET_INFORMATION;
        struct _METHOD {
            NDIS_OID    Oid;
            PVOID       InformationBuffer;
            ULONG       InputBufferLength;
            ULONG       OutputBufferLength;
            ULONG       MethodId;
            UINT        BytesWritten;
            UINT        BytesRead;
            UINT        BytesNeeded;
        } METHOD_INFORMATION;
    } DATA;
    UCHAR               NdisReserved[NDIS_OID_REQUEST_NDIS_RESERVED_SIZE * sizeof( PVOID )];
    UCHAR               MiniportReserved[2 * sizeof( PVOID )];
    UCHAR               SourceReserved[2 * sizeof( PVOID )];
    UCHAR               SupportedRevision;
    UCHAR               Reserved1;
    USHORT              Reserved2;
} NDIS_OID_REQUEST;
typedef NDIS_OID_REQUEST    *PNDIS_OID_REQUEST;
#endif

/* NDIS status indication */
#if NDIS_SUPPORT_NDIS6
typedef struct _NDIS_STATUS_INDICATION {
    NDIS_OBJECT_HEADER  Header;
    NDIS_HANDLE         SourceHandle;
    NDIS_PORT_NUMBER    PortNumber;
    NDIS_STATUS         StatusCode;
    ULONG               Flags;
    NDIS_HANDLE         DestinationHandle;
    PVOID               RequestId;
    PVOID               StatusBuffer;
    ULONG               StatusBufferSize;
    GUID                Guid;
    PVOID               NdisReserved[4];
} NDIS_STATUS_INDICATION;
typedef NDIS_STATUS_INDICATION  *PNDIS_STATUS_INDICATION;
#endif

/* NDIS timer characteristics */
#if NDIS_SUPPORT_NDIS6
typedef struct _NDIS_TIMER_CHARACTERISTICS {
    NDIS_OBJECT_HEADER      Header;
    ULONG                   AllocationTag;
    PNDIS_TIMER_FUNCTION    TimerFunction;
    PVOID                   FunctionContext;
} NDIS_TIMER_CHARACTERISTICS;
typedef NDIS_TIMER_CHARACTERISTICS  *PNDIS_TIMER_CHARACTERISTICS;
#endif

/* NDIS restart general attributes */
#if NDIS_SUPPORT_NDIS6
typedef struct _NDIS_RESTART_GENERAL_ATTRIBUTES {
    NDIS_OBJECT_HEADER                  Header;
    ULONG                               MtuSize;
    ULONG64                             MaxXmitLinkSpeed;
    ULONG64                             MaxRcvLinkSpeed;
    ULONG                               LookaheadSize;
    ULONG                               MacOptions;
    ULONG                               SupportedPacketFilters;
    ULONG                               MaxMulticastListSize;
    PNDIS_RECEIVE_SCALE_CAPABILITIES    RecvScaleCapabilities;
    NET_IF_ACCESS_TYPE                  AccessType;
    ULONG                               Flags;
    NET_IF_CONNECTION_TYPE              ConnectionType;
    ULONG                               SupportedStatistics;
    ULONG                               DataBackFillSize;
    ULONG                               ContextBackFillSize;
    PNDIS_OID                           SupportedOidList;
    ULONG                               SupportedOidListLength;
#if NDIS_SUPPORT_NDIS620
    ULONG                               MaxLookaheadSizeAccessed;
#endif
} NDIS_RESTART_GENERAL_ATTRIBUTES;
typedef NDIS_RESTART_GENERAL_ATTRIBUTES *PNDIS_RESTART_GENERAL_ATTRIBUTES;
#endif

/* NDIS processor information */
#if NDIS_SUPPORT_NDIS6 && NDIS_SUPPORT_60_COMPATIBLE_API
typedef struct _NDIS_PROCESSOR_INFO {
    ULONG   CpuNumber;
    ULONG   PhysicalPackageId;
    ULONG   CoreId;
    ULONG   HyperThreadID;
} NDIS_PROCESSOR_INFO;
typedef NDIS_PROCESSOR_INFO *PNDIS_PROCESSOR_INFO;
#endif

/* NDIS system processor information */
#if NDIS_SUPPORT_NDIS6 && NDIS_SUPPORT_60_COMPATIBLE_API
typedef struct _NDIS_SYSTEM_PROCESSOR_INFO {
    NDIS_OBJECT_HEADER      Header;
    ULONG                   Flags;
    NDIS_PROCESSOR_VENDOR   ProcessorVendor;
    ULONG                   NumPhysicalPackages;
    ULONG                   NumCores;
    ULONG                   NumCoresPerPhysicalPackage;
    ULONG                   MaxHyperThreadingCpusPerCore;
    ULONG                   RssBaseCpu;
    ULONG                   RssCpuCount;
    PUCHAR                  RssProcessors;
    NDIS_PROCESSOR_INFO     CpuInfo[MAXIMUM_PROC_PER_GROUP];
} NDIS_SYSTEM_PROCESSOR_INFO;
typedef NDIS_SYSTEM_PROCESSOR_INFO  *PNDIS_SYSTEM_PROCESSOR_INFO;
#endif

/* NDIS filter interface */
#if (NTDDI_VERSION == 0x06000000) && (NDIS_LEGACY_DRIVER || NDIS_SUPPORT_NDIS6)
typedef struct _NDIS_FILTER_INTERFACE {
    NDIS_OBJECT_HEADER  Header;
    ULONG               Flags;
    ULONG               FilterType;
    ULONG               FilterRunType;
    NET_IFINDEX         IfIndex;
    NET_LUID            NetLuid;
    NDIS_STRING         FilterClass;
    NDIS_STRING         FilterInstanceName;
} NDIS_FILTER_INTERFACE;
typedef NDIS_FILTER_INTERFACE   *PNDIS_FILTER_INTERFACE;
#endif

/* NDIS enumerate filters */
#if (NTDDI_VERSION == 0x06000000) && (NDIS_LEGACY_DRIVER || NDIS_SUPPORT_NDIS6)
typedef struct _NDIS_ENUM_FILTERS {
    NDIS_OBJECT_HEADER      Header;
    ULONG                   Flags;
    ULONG                   NumberOfFilters;
    ULONG                   OffsetFirstFilter;
    NDIS_FILTER_INTERFACE   Filter[1];
} NDIS_ENUM_FILTERS;
typedef NDIS_ENUM_FILTERS   *PNDIS_ENUM_FILTERS;
#endif

/* NDIS device object attributes */
#if (NTDDI_VERSION == 0x06000000) && (NDIS_LEGACY_DRIVER || NDIS_SUPPORT_NDIS6)
typedef struct _NDIS_DEVICE_OBJECT_ATTRIBUTES {
    NDIS_OBJECT_HEADER  Header;
    PNDIS_STRING        DeviceName;
    PNDIS_STRING        SymbolicName;
    PDRIVER_DISPATCH    *MajorFunctions;
    ULONG               ExtensionSize;
    PCUNICODE_STRING    DefaultSDDLString;
    LPCGUID             DeviceClassGuid;
} NDIS_DEVICE_OBJECT_ATTRIBUTES;
typedef NDIS_DEVICE_OBJECT_ATTRIBUTES   *PNDIS_DEVICE_OBJECT_ATTRIBUTES;
#endif

/* NDIS driver wrapper handle */
#if (NTDDI_VERSION == 0x06000000) && (NDIS_LEGACY_DRIVER || NDIS_SUPPORT_NDIS6)
typedef struct _NDIS_DRIVER_WRAPPER_HANDLE {
    NDIS_OBJECT_HEADER  Header;
    NDIS_HANDLE         NdisWrapperHandle;
} NDIS_DRIVER_WRAPPER_HANDLE;
typedef NDIS_DRIVER_WRAPPER_HANDLE  *PNDIS_DRIVER_WRAPPER_HANDLE;
#endif

/* NDIS shared memory usage values */
#if NDIS_SUPPORT_NDIS620
typedef enum _NDIS_SHARED_MEMORY_USAGE {
    NdisSharedMemoryUsageUndefined              = 0,
    NdisSharedMemoryUsageXmit                   = 1,
    NdisSharedMemoryUsageXmitHeader             = 2,
    NdisSharedMemoryUsageXmitData               = 3,
    NdisSharedMemoryUsageReceive                = 4,
    NdisSharedMemoryUsageReceiveLookahead       = 5,
    NdisSharedMemoryUsageReceivePostLookahead   = 6,
    NdisSharedMemoryUsageReceiveHeader          = 7,
    NdisSharedMemoryUsageReceiveData            = 8,
    NdisSharedMemoryUsageOther                  = 9,
    NdisSharedMemoryUsageMax                    = 10
} NDIS_SHARED_MEMORY_USAGE;
typedef NDIS_SHARED_MEMORY_USAGE    *PNDIS_SHARED_MEMORY_USAGE;
#endif

/* NDIS shared memory parameters */
#if NDIS_SUPPORT_NDIS620
typedef struct _NDIS_SHARED_MEMORY_PARAMETERS {
    NDIS_OBJECT_HEADER          Header;
    ULONG                       Flags;
    NDIS_RECEIVE_QUEUE_ID       QueueId;
    NDIS_HANDLE                 SharedMemoryHandle;
    NODE_REQUIREMENT            PreferredNode;
    NDIS_SHARED_MEMORY_USAGE    Usage;
    ULONG                       Length;
    PVOID                       VirtualAddress;
    ULONG                       SGListBufferLength;
    PSCATTER_GATHER_LIST        SGListBuffer;
} NDIS_SHARED_MEMORY_PARAMETERS;
typedef NDIS_SHARED_MEMORY_PARAMETERS   *PNDIS_SHARED_MEMORY_PARAMETERS;
#endif

/* Shared memory callbacks */
#if NDIS_SUPPORT_NDIS620
typedef NDIS_STATUS (NTAPI *ALLOCATE_SHARED_MEMORY_HANDLER)( NDIS_HANDLE, PNDIS_SHARED_MEMORY_PARAMETERS );
typedef VOID (NTAPI *FREE_SHARED_MEMORY_HANDLER)( NDIS_HANDLE, NDIS_HANDLE );
#endif

/* NDIS shared memory provider characteristics */
#if NDIS_SUPPORT_NDIS620
typedef struct _NDIS_SHARED_MEMORY_PROVIDER_CHARACTERISTICS {
    NDIS_OBJECT_HEADER              Header;
    ULONG                           Flags;
    NDIS_HANDLE                     ProviderContext;
    ALLOCATE_SHARED_MEMORY_HANDLER  AllocateSharedMemoryHandler;
    FREE_SHARED_MEMORY_HANDLER      FreeSharedMemoryHandler;
} NDIS_SHARED_MEMORY_PROVIDER_CHARACTERISTICS;
typedef NDIS_SHARED_MEMORY_PROVIDER_CHARACTERISTICS *PNDIS_SHARED_MEMORY_PROVIDER_CHARACTERISTICS;
#endif

/* NDIS receive queue state */
#if NDIS_SUPPORT_NDIS620
typedef struct _NDIS_RECEIVE_QUEUE_STATE {
    NDIS_OBJECT_HEADER                      Header;
    ULONG                                   Flags;
    NDIS_RECEIVE_QUEUE_ID                   QueueId;
    NDIS_RECEIVE_QUEUE_OPERATIONAL_STATE    QueueState;
} NDIS_RECEIVE_QUEUE_STATE;
typedef NDIS_RECEIVE_QUEUE_STATE    *PNDIS_RECEIVE_QUEUE_STATE;
#endif

/* NDIS process scatter/gather list handler */
#if NDIS_SUPPORT_NDIS620
typedef VOID (NTAPI NDIS_PROCESS_SG_LIST)( PDEVICE_OBJECT, PVOID, PSCATTER_GATHER_LIST, PVOID );
typedef NDIS_PROCESS_SG_LIST    *NDIS_PROCESS_SG_LIST_HANDLER;
#endif

/* NDIS scatter/gather list parameters */
#if NDIS_SUPPORT_NDIS620
typedef struct _NDIS_SCATTER_GATHER_LIST_PARAMETERS {
    NDIS_OBJECT_HEADER              Header;
    ULONG                           Flags;
    NDIS_RECEIVE_QUEUE_ID           QueueId;
    NDIS_SHARED_MEMORY_USAGE        SharedMemoryUsage;
    PMDL                            Mdl;
    PVOID                           CurrentVa;
    ULONG                           Length;
    NDIS_PROCESS_SG_LIST_HANDLER    ProcessSGListHandler;
    PVOID                           Context;
    PSCATTER_GATHER_LIST            ScatterGatherListBuffer;
    ULONG                           ScatterGatherListBufferSize;
    ULONG                           ScatterGatherListBufferSizeNeeded;
} NDIS_SCATTER_GATHER_LIST_PARAMETERS;
typedef NDIS_SCATTER_GATHER_LIST_PARAMETERS *PNDIS_SCATTER_GATHER_LIST_PARAMETERS;
#endif

/* Network buffer data length */
#if NDIS_SUPPORT_NDIS6 || NDIS60
typedef union _NET_BUFFER_DATA_LENGTH {
    ULONG   DataLength;
    SIZE_T  stDataLength;
} NET_BUFFER_DATA_LENGTH;
typedef NET_BUFFER_DATA_LENGTH  *PNET_BUFFER_DATA_LENGTH;
#endif

/* Network buffer data */
#if NDIS_SUPPORT_NDIS6 || NDIS60
typedef struct _NET_BUFFER_DATA {
    struct _NET_BUFFER      *Next;
    PMDL                    CurrentMdl;
    ULONG                   CurrentMdlOffset;
#ifdef __cplusplus
    NET_BUFFER_DATA_LENGTH  NbDataLength;
#else
    NET_BUFFER_DATA_LENGTH;
#endif
    PMDL                    MdlChain;
    ULONG                   DataOffset;
} NET_BUFFER_DATA;
typedef NET_BUFFER_DATA *PNET_BUFFER_DATA;
#endif

/* Network buffer header */
#if NDIS_SUPPORT_NDIS6 || NDIS60
typedef union _NET_BUFFER_HEADER {
#ifdef __cplusplus
    NET_BUFFER_DATA NetBufferData;
#else
    NET_BUFFER_DATA;
#endif
    SLIST_HEADER    Link;
} NET_BUFFER_HEADER;
typedef NET_BUFFER_HEADER   *PNET_BUFFER_HEADER;
#endif

/* Network buffer shared memory */
#if NDIS_SUPPORT_NDIS620
typedef struct _NET_BUFFER_SHARED_MEMORY {
    struct _NET_BUFFER_SHARED_MEMORY    *NextSharedMemorySegment;
    ULONG                               SharedMemoryFlags;
    NDIS_HANDLE                         SharedMemoryHandle;
    ULONG                               SharedMemoryOffset;
    ULONG                               SharedMemoryLength;
} NET_BUFFER_SHARED_MEMORY;
typedef NET_BUFFER_SHARED_MEMORY    *PNET_BUFFER_SHARED_MEMORY;
#endif

/* Network buffer */
#if NDIS_SUPPORT_NDIS6 || NDIS60
typedef struct _NET_BUFFER {
#ifdef __cplusplus
    NET_BUFFER_HEADER       NetBufferHeader;
#else
    NET_BUFFER_HEADER;
#endif
    USHORT                  ChecksumBias;
    USHORT                  Reserved;
    NDIS_HANDLE             NdisPoolHandle;
    PVOID                   NdisReserved[2];
    PVOID                   ProtocolReserved[6];
    PVOID                   MiniportReserved[4];
    NDIS_PHYSICAL_ADDRESS   DataPhysicalAddress;
#if NDIS_SUPPORT_NDIS620
    union {
        PNET_BUFFER_SHARED_MEMORY   SharedMemoryInfo;
        PSCATTER_GATHER_LIST        ScatterGatherList;
    };
#endif
} NET_BUFFER;
typedef NET_BUFFER  *PNET_BUFFER;
#endif

/* Network buffer list context */
#if NDIS_SUPPORT_NDIS6 || NDIS60
typedef struct _NET_BUFFER_LIST_CONTEXT {
    struct _NET_BUFFER_LIST_CONTEXT *Next;
    USHORT                          Size;
    USHORT                          Offset;
    UCHAR                           ContextData[];
} NET_BUFFER_LIST_CONTEXT;
typedef NET_BUFFER_LIST_CONTEXT *PNET_BUFFER_LIST_CONTEXT;
#endif

/* NDIS network buffer list information */
#if NDIS_SUPPORT_NDIS6 || NDIS60
typedef enum _NDIS_NET_BUFFER_LIST_INFO {
    TcpIpChecksumNetBufferListInfo          = 0,
    TcpOffloadBytesTransferred              = TcpIpChecksumNetBufferListInfo,
    IPsecOffloadV1NetBufferListInfo         = 1,
#if NDIS_SUPPORT_NDIS61
    IPsecOffloadV2NetBufferListInfo         = IPsecOffloadV1NetBufferListInfo,
#endif
    TcpLargeSendNetBufferListInfo           = 2,
    TcpReceiveNoPush                        = TcpLargeSendNetBufferListInfo,
    ClassificationHandleNetBufferListInfo   = 3,
    Ieee8021QNetBufferListInfo              = 4,
    NetBufferListCancelId                   = 5,
    MediaSpecificInformation                = 6,
    NetBufferListFrameType                  = 7,
    NetBufferListProtocolId                 = NetBufferListFrameType,
    NetBufferListHashValue                  = 8,
    NetBufferListHashInfo                   = 9,
    WfpNetBufferListInfo                    = 10,
#if NDIS_SUPPORT_NDIS61
    IPsecOffloadV2TunnelNetBufferListInfo   = 11,
    IPsecOffloadV2HeaderNetBufferListInfo   = 12,
#endif
#if NDIS_SUPPORT_NDIS620
    NetBufferListCorrelationId              = 13,
    NetBufferListFilteringInfo              = 14,
    MediaSpecificInformationEx              = 15,
    NblOriginalInterfaceIfIndex             = 16,
    NblReAuthWfpFlowContext                 = NblOriginalInterfaceIfIndex,
    TcpReceiveBytesTransferred              = 17,
#endif
    MaxNetBufferListInfo                    = 18
} NDIS_NET_BUFFER_LIST_INFO;
typedef NDIS_NET_BUFFER_LIST_INFO   *PNDIS_NET_BUFFER_LIST_INFO;
#endif

/* Network buffer list data */
#if NDIS_SUPPORT_NDIS6 || NDIS60
typedef struct _NET_BUFFER_LIST_DATA {
    struct _NET_BUFFER_LIST *Next;
    PNET_BUFFER             FirstNetBuffer;
} NET_BUFFER_LIST_DATA;
typedef NET_BUFFER_LIST_DATA    *PNET_BUFFER_LIST_DATA;
#endif

/* Network buffer list header */
#if NDIS_SUPPORT_NDIS6 || NDIS60
typedef union _NET_BUFFER_LIST_HEADER {
#ifdef __cplusplus
    NET_BUFFER_LIST_DATA    NetBufferListData;
#else
    NET_BUFFER_LIST_DATA;
#endif
    SLIST_HEADER            Link;
} NET_BUFFER_LIST_HEADER;
typedef NET_BUFFER_LIST_HEADER  *PNET_BUFFER_LIST_HEADER;
#endif

/* Network buffer list */
#if NDIS_SUPPORT_NDIS6 || NDIS60
typedef struct _NET_BUFFER_LIST {
#ifdef __cplusplus
    NET_BUFFER_LIST_HEADER      NetBufferListHeader;
#else
    NET_BUFFER_LIST_HEADER;
#endif
    PNET_BUFFER_LIST_CONTEXT    Context;
    struct _NET_BUFFER_LIST     *ParentNetBufferList;
    NDIS_HANDLE                 NdisPoolHandle;
    PVOID                       NdisReserved[2];
    PVOID                       ProtocolReserved[4];
    PVOID                       MiniportReserved[2];
    PVOID                       Scratch;
    NDIS_HANDLE                 SourceHandle;
    ULONG                       NblFlags;
    LONG                        ChildRefCount;
    ULONG                       Flags;
    NDIS_STATUS                 Status;
    PVOID                       NetBufferListInfo[MaxNetBufferListInfo];
} NET_BUFFER_LIST;
typedef NET_BUFFER_LIST *PNET_BUFFER_LIST;
#endif

/* NDIS network buffer list 8021Q information */
#if NDIS_SUPPORT_NDIS6 || NDIS60
typedef struct _NDIS_NET_BUFFER_LIST_8021Q_INFO {
    union {
        struct {
            UINT32  UserPriority        : 3;
            UINT32  CanonicalFormatId   : 1;
            UINT32  VlanId              : 12;
            UINT32  Reserved            : 16;
        } TagHeader;
        struct {
            UINT32  UserPriority        : 3;
            UINT32  CanonicalFormatId   : 1;
            UINT32  VlanId              : 12;
            UINT32  WMMInfo             : 4;
            UINT32  Reserved            : 12;
        } WLanTagHeader;
        PVOID   Value;
    };
} NDIS_NET_BUFFER_LIST_8021Q_INFO;
typedef NDIS_NET_BUFFER_LIST_8021Q_INFO *PNDIS_NET_BUFFER_LIST_8021Q_INFO;
#endif

/* NDIS network buffer list media-specific information */
#if NDIS_SUPPORT_NDIS6 || NDIS60
typedef struct _NDIS_NET_BUFFER_LIST_MEDIA_SPECIFIC_INFO {
    union {
        PVOID   MediaSpecificInfo;
        PVOID   NativeWifiSpecificInfo;
        PVOID   Value;
    };
} NDIS_NET_BUFFER_LIST_MEDIA_SPECIFIC_INFO;
typedef NDIS_NET_BUFFER_LIST_MEDIA_SPECIFIC_INFO    *PNDIS_NET_BUFFER_LIST_MEDIA_SPECIFIC_INFO;
#endif

/* NDIS NBL media-specific information */
#if NDIS_SUPPORT_NDIS6 || NDIS60
typedef struct _NDIS_NBL_MEDIA_SPECIFIC_INFORMATION {
    struct _NDIS_NBL_MEDIA_SPECIFIC_INFORMATION *NextEntry;
    ULONG                                       Tag;
    UCHAR                                       Data[1];
} NDIS_NBL_MEDIA_SPECIFIC_INFORMATION;
typedef NDIS_NBL_MEDIA_SPECIFIC_INFORMATION *PNDIS_NBL_MEDIA_SPECIFIC_INFORMATION;
#endif

/* NDIS NBL media-specific information (extended version) */
#if NDIS_SUPPORT_NDIS620
typedef struct _NDIS_NBL_MEDIA_SPECIFIC_INFORMATION_EX {
    NDIS_OBJECT_HEADER                              Header;
    struct _NDIS_NBL_MEDIA_SPECIFIC_INFORMATION_EX  *NextEntry;
    ULONG                                           Tag;
    PVOID                                           Data;
} NDIS_NBL_MEDIA_SPECIFIC_INFORMATION_EX;
typedef NDIS_NBL_MEDIA_SPECIFIC_INFORMATION_EX  *PNDIS_NBL_MEDIA_SPECIFIC_INFORMATION_EX;
#endif

/* NDIS network buffer list filtering information */
#if NDIS_SUPPORT_NDIS620
typedef struct _NDIS_NET_BUFFER_LIST_FILTERING_INFO {
    union {
        struct {
            USHORT  FilterId;
            USHORT  QueueId;
        } FilteringInfo;
        PVOID   Value;
    };
} NDIS_NET_BUFFER_LIST_FILTERING_INFO;
typedef NDIS_NET_BUFFER_LIST_FILTERING_INFO *PNDIS_NET_BUFFER_LIST_FILTERING_INFO;
#endif

/* Network buffer list pool parameters */
#if NDIS_SUPPORT_NDIS6 || NDIS60
typedef struct _NET_BUFFER_LIST_POOL_PARAMETERS {
    NDIS_OBJECT_HEADER  Header;
    UCHAR               ProtocolId;
    BOOLEAN             fAllocateNetBuffer;
    USHORT              ContextSize;
    ULONG               PoolTag;
    ULONG               DataSize;
} NET_BUFFER_LIST_POOL_PARAMETERS;
typedef NET_BUFFER_LIST_POOL_PARAMETERS *PNET_BUFFER_LIST_POOL_PARAMETERS;
#endif

/* Network buffer pool parameters */
#if NDIS_SUPPORT_NDIS6 || NDIS60
typedef struct _NET_BUFFER_POOL_PARAMETERS {
    NDIS_OBJECT_HEADER  Header;
    ULONG               PoolTag;
    ULONG               DataSize;
} NET_BUFFER_POOL_PARAMETERS;
typedef NET_BUFFER_POOL_PARAMETERS  *PNET_BUFFER_POOL_PARAMETERS;
#endif

/* Network buffer callbacks */
#if NDIS_SUPPORT_NDIS6 || NDIS60
typedef PMDL (NTAPI *NET_BUFFER_ALLOCATE_MDL_HANDLER)( PULONG );
typedef VOID (NTAPI *NET_BUFFER_FREE_MDL_HANDLER)( PMDL );
#endif

/* NDIS IPsec packet information */
#if NDIS_SUPPORT_NDIS6 || NDIS60
typedef struct _NDIS_IPSEC_PACKET_INFO {
    union {
        struct {
            NDIS_HANDLE OffloadHandle;
            NDIS_HANDLE NextOffloadHandle;
        } Transmit;
        struct {
            ULONG   SA_DELETE_REQ       : 1;
            ULONG   CRYPTO_DONE         : 1;
            ULONG   NEXT_CRYPTO_DONE    : 1;
            ULONG   CryptoStatus;
        } Receive;
    };
} NDIS_IPSEC_PACKET_INFO;
typedef NDIS_IPSEC_PACKET_INFO  *PNDIS_IPSEC_PACKET_INFO;
#endif

/* NDIS IPsec offload network buffer list information (version 1) */
#if NDIS_SUPPORT_NDIS6 || NDIS60
typedef struct _NDIS_IPSEC_OFFLOAD_V1_NET_BUFFER_LIST_INFO {
    union {
        struct {
            NDIS_HANDLE OffloadHandle;
        } Transmit;
        struct {
            USHORT  SaDeleteReq     : 1;
            USHORT  CryptoDone      : 1;
            USHORT  NextCryptoDone  : 1;
            USHORT  Pad             : 13;
            USHORT  CryptoStatus;
        } Receive;
    };
} NDIS_IPSEC_OFFLOAD_V1_NET_BUFFER_LIST_INFO;
typedef NDIS_IPSEC_OFFLOAD_V1_NET_BUFFER_LIST_INFO  *PNDIS_IPSEC_OFFLOAD_V1_NET_BUFFER_LIST_INFO;
#endif

/* NDIS tasks */
#if NDIS_LEGACY_DRIVER
typedef enum _NDIS_TASK {
    TcpIpChecksumNdisTask   = 0,
    IpSecNdisTask           = 1,
    TcpLargeSendNdisTask    = 2,
    MaxNdisTask             = 3
} NDIS_TASK;
typedef NDIS_TASK   *PNDIS_TASK;
#endif

/* NDIS encapsulation values */
#if NDIS_LEGACY_DRIVER
typedef enum _NDIS_ENCAPSULATION {
    UNSPECIFIED_Encapsulation       = 0,
    NULL_Encapsulation              = 1,
    IEEE_802_3_Encapsulation        = 2,
    IEEE_802_5_Encapsulation        = 3,
    LLC_SNAP_ROUTED_Encapsulation   = 4,
    LLC_SNAP_BRIDGED_Encapsulation  = 5
} NDIS_ENCAPSULATION;
#endif

/* NDIS encapsulation format */
#if NDIS_LEGACY_DRIVER
typedef struct _NDIS_ENCAPSULATION_FORMAT {
    NDIS_ENCAPSULATION  Encapsulation;
    struct {
        ULONG   FixedHeaderSize : 1;
        ULONG   Reserved        : 31;
    } Flags;
    ULONG               EncapsulationHeaderSize;
} NDIS_ENCAPSULATION_FORMAT;
typedef NDIS_ENCAPSULATION_FORMAT   *PNDIS_ENCAPSULATION_FORMAT;
#endif

/* NDIS task offload header */
#if NDIS_LEGACY_DRIVER
typedef struct _NDIS_TASK_OFFLOAD_HEADER {
    ULONG                       Version;
    ULONG                       Size;
    ULONG                       Reserved;
    ULONG                       OffsetFirstTask;
    NDIS_ENCAPSULATION_FORMAT   EncapsulationFormat;
} NDIS_TASK_OFFLOAD_HEADER;
typedef NDIS_TASK_OFFLOAD_HEADER    *PNDIS_TASK_OFFLOAD_HEADER;
#endif

/* NDIS task offload */
#if NDIS_LEGACY_DRIVER
typedef struct _NDIS_TASK_OFFLOAD {
    ULONG       Version;
    ULONG       Size;
    NDIS_TASK   Task;
    ULONG       OffsetNextTask;
    ULONG       TaskBufferLength;
    UCHAR       TaskBuffer[1];
} NDIS_TASK_OFFLOAD;
typedef NDIS_TASK_OFFLOAD   *PNDIS_TASK_OFFLOAD;
#endif

/* NDIS task TCP/IP checksum */
#if NDIS_LEGACY_DRIVER
typedef struct _NDIS_TASK_TCP_IP_CHECKSUM {
    struct {
        ULONG   IpOptionsSupported  : 1;
        ULONG   TcpOptionsSupported : 1;
        ULONG   TcpChecksum         : 1;
        ULONG   UdpChecksum         : 1;
        ULONG   IpChecksum          : 1;
    } V4Transmit;
    struct {
        ULONG   IpOptionsSupported  : 1;
        ULONG   TcpOptionsSupported : 1;
        ULONG   TcpChecksum         : 1;
        ULONG   UdpChecksum         : 1;
        ULONG   IpChecksum          : 1;
    } V4Receive;
    struct {
        ULONG   IpOptionsSupported  : 1;
        ULONG   TcpOptionsSupported : 1;
        ULONG   TcpChecksum         : 1;
        ULONG   UdpChecksum         : 1;
    } V6Transmit;
    struct {
        ULONG   IpOptionsSupported  : 1;
        ULONG   TcpOptionsSupported : 1;
        ULONG   TcpChecksum         : 1;
        ULONG   UdpChecksum         : 1;
    } V6Receive;
} NDIS_TASK_TCP_IP_CHECKSUM;
typedef NDIS_TASK_TCP_IP_CHECKSUM   *PNDIS_TASK_TCP_IP_CHECKSUM;
#endif

/* NDIS task TCP large send */
#if NDIS_LEGACY_DRIVER
typedef struct _NDIS_TASK_TCP_LARGE_SEND {
    ULONG   Version;
    ULONG   MaxOffLoadSize;
    ULONG   MinSegmentCount;
    BOOLEAN TcpOptions;
    BOOLEAN IpOptions;
} NDIS_TASK_TCP_LARGE_SEND;
typedef NDIS_TASK_TCP_LARGE_SEND    *PNDIS_TASK_TCP_LARGE_SEND;
#endif

/* NDIS task IPsec */
#if NDIS_LEGACY_DRIVER
typedef struct _NDIS_TASK_IPSEC {
    struct {
        ULONG   AH_ESP_COMBINED;
        ULONG   TRANSPORT_TUNNEL_COMBINED;
        ULONG   V4_OPTIONS;
        ULONG   RESERVED;
    } Supported;
    struct {
        ULONG   MD5         : 1;
        ULONG   SHA_1       : 1;
        ULONG   Transport   : 1;
        ULONG   Tunnel      : 1;
        ULONG   Send        : 1;
        ULONG   Receive     : 1;
    } V4AH;
    struct {
        ULONG   DES         : 1;
        ULONG   RESERVED    : 1;
        ULONG   TRIPLE_DES  : 1;
        ULONG   NULL_ESP    : 1;
        ULONG   Transport   : 1;
        ULONG   Tunnel      : 1;
        ULONG   Send        : 1;
        ULONG   Receive     : 1;
    } V4ESP;
} NDIS_TASK_IPSEC;
typedef NDIS_TASK_IPSEC *PNDIS_TASK_IPSEC;
#endif

/* NDIS TCP large send offload network buffer list information */
#if NDIS_SUPPORT_NDIS6 || NDIS60
typedef struct _NDIS_TCP_LARGE_SEND_OFFLOAD_NET_BUFFER_LIST_INFO {
    union {
        struct {
            ULONG   Unused      : 30;
            ULONG   Type        : 1;
            ULONG   Reserved2   : 1;
        } Transmit;
        struct {
            ULONG   MSS             : 20;
            ULONG   TcpHeaderOffset : 10;
            ULONG   Type            : 1;
            ULONG   Reserved2       : 1;
        } LsoV1Transmit;
        struct {
            ULONG   TcpPayload  : 30;
            ULONG   Type        : 1;
            ULONG   Reserved2   : 1;
        } LsoV1TransmitComplete;
        struct {
            ULONG   MSS             : 20;
            ULONG   TcpHeaderOffset : 10;
            ULONG   Type            : 1;
            ULONG   IPVersion       : 1;
        } LsoV2Transmit;
        struct {
            ULONG   Reserved    : 30;
            ULONG   Type        : 1;
            ULONG   Reserved2   : 1;
        } LsoV2TransmitComplete;
        PVOID   Value;
    };
} NDIS_TCP_LARGE_SEND_OFFLOAD_NET_BUFFER_LIST_INFO;
typedef NDIS_TCP_LARGE_SEND_OFFLOAD_NET_BUFFER_LIST_INFO    *PNDIS_TCP_LARGE_SEND_OFFLOAD_NET_BUFFER_INFO;
#endif

/* NDIS TCP/IP checksum network buffer list information */
#if NDIS_SUPPORT_NDIS6 || NDIS60
typedef struct _NDIS_TCP_IP_CHECKSUM_NET_BUFFER_LIST_INFO {
    union {
        struct {
            ULONG   IsIPv4              : 1;
            ULONG   IsIPv6              : 1;
            ULONG   TcpChecksum         : 1;
            ULONG   UdpChecksum         : 1;
            ULONG   IpHeaderChecksum    : 1;
            ULONG   Reserved            : 11;
            ULONG   TcpHeaderChecksum   : 10;
        } Transmit;
        struct {
            ULONG   TcpChecksumFailed       : 1;
            ULONG   UdpChecksumFailed       : 1;
            ULONG   IpChecksumFailed        : 1;
            ULONG   TcpChecksumSucceeded    : 1;
            ULONG   UdpChecksumSucceeded    : 1;
            ULONG   IpChecksumSucceeded     : 1;
            ULONG   Loopback                : 1;
        } Receive;
        PVOID   Value;
    };
} NDIS_TCP_IP_CHECKSUM_NET_BUFFER_LIST_INFO;
typedef NDIS_TCP_IP_CHECKSUM_NET_BUFFER_LIST_INFO   *PNDIS_TCP_IP_CHECKSUM_NET_BUFFER_LIST_INFO;
#endif

/* NDIS offload encapsulation */
#if NDIS_SUPPORT_NDIS6 || NDIS60
typedef struct _NDIS_OFFLOAD_ENCAPSULATION {
    NDIS_OBJECT_HEADER  Header;
    struct {
        ULONG   Enabled;
        ULONG   EncapsulationType;
        ULONG   HeaderSize;
    } IPv4;
    struct {
        ULONG   Enabled;
        ULONG   EncapsulationType;
        ULONG   HeaderSize;
    } IPv6;
} NDIS_OFFLOAD_ENCAPSULATION;
typedef NDIS_OFFLOAD_ENCAPSULATION  *PNDIS_OFFLOAD_ENCAPSULATION;
#endif

/* NDIS IPsec offload (version 2) network buffer list information */
#if NDIS_SUPPORT_NDIS61
typedef struct _NDIS_IPSEC_OFFLOAD_V2_NET_BUFFER_LIST_INFO {
    union {
        struct {
            PVOID   OffloadHandle;
        } Transmit;
        struct {
            ULONG   SaDeleteReq     : 1;
            ULONG   CryptoDone      : 1;
            ULONG   NextCryptoDone  : 1;
            ULONG   Reserved        : 13;
            ULONG   CryptoStatus    : 16;
        } Receive;
    };
} NDIS_IPSEC_OFFLOAD_V2_NET_BUFFER_LIST_INFO;
typedef NDIS_IPSEC_OFFLOAD_V2_NET_BUFFER_LIST_INFO  *PNDIS_IPSEC_OFFLOAD_V2_NET_BUFFER_LIST_INFO;
#endif

/* NDIS IPsec offload (version 2) tunnel network buffer list information */
#if NDIS_SUPPORT_NDIS61
typedef struct _NDIS_IPSEC_OFFLOAD_V2_TUNNEL_NET_BUFFER_LIST_INFO {
    struct {
        NDIS_HANDLE TunnelHandle;
    } Transmit;
} NDIS_IPSEC_OFFLOAD_V2_TUNNEL_NET_BUFFER_LIST_INFO;
typedef NDIS_IPSEC_OFFLOAD_V2_TUNNEL_NET_BUFFER_LIST_INFO   *PNDIS_IPSEC_OFFLOAD_V2_TUNNEL_NET_BUFFER_LIST_INFO;
#endif

/* NDIS IPsec offload (version 2) header network buffer list information */
#if NDIS_SUPPORT_NDIS61
typedef struct _NDIS_IPSEC_OFFLOAD_V2_HEADER_NET_BUFFER_LIST_INFO {
    union {
        struct {
            ULONG   NextHeader      : 8;
            ULONG   PadLength       : 8;
            ULONG   AhHeaderOffset  : 8;
            ULONG   EspHeaderOffset : 8;
        } Transmit;
        struct {
            ULONG   NextHeader      : 8;
            ULONG   PadLength       : 8;
            ULONG   HeaderInfoSet   : 1;
        } Receive;
    };
} NDIS_IPSEC_OFFLOAD_V2_HEADER_NET_BUFFER_LIST_INFO;
typedef NDIS_IPSEC_OFFLOAD_V2_HEADER_NET_BUFFER_LIST_INFO   *PNDIS_IPSEC_OFFLOAD_V2_HEADER_NET_BUFFER_INFO;
#endif

/* IPsec offload (version 2) operations */
#if NDIS_SUPPORT_NDIS61
typedef enum _IPSEC_OFFLOAD_V2_OPERATION {
    IPsecOffloadV2Ah    = 1,
    IPsecOffloadV2Esp   = 2,
    IPsecOffloadV2Max   = 3
} IPSEC_OFFLOAD_V2_OPERATION;
typedef IPSEC_OFFLOAD_V2_OPERATION  *PIPSEC_OFFLOAD_V2_OPERATION;
#endif

/* IPsec offload (version 2) algorithm information */
#if NDIS_SUPPORT_NDIS61
typedef struct _IPSEC_OFFLOAD_V2_ALGORITHM_INFO {
    ULONG   Identifier;
    ULONG   KeyLength;
    ULONG   KeyOffsetBytes;
    ULONG   AdditionalInfo;
} IPSEC_OFFLOAD_V2_ALGORITHM_INFO;
typedef IPSEC_OFFLOAD_V2_ALGORITHM_INFO *PIPSEC_OFFLOAD_V2_ALGORITHM_INFO;
#endif

/* IPsec offload (version 2) security association */
#if NDIS_SUPPORT_NDIS61
typedef struct _IPSEC_OFFLOAD_V2_SECURITY_ASSOCIATION {
    ULONG                           Flags;
    IPSEC_OFFLOAD_V2_OPERATION      Operation;
    IPSEC_OFFLOAD_V2_SPI_TYPE       Spi;
    IPSEC_OFFLOAD_V2_ALGORITHM_INFO AuthenticationAlgorithm;
    IPSEC_OFFLOAD_V2_ALGORITHM_INFO EncryptionAlgorithm;
    ULONG                           SequenceNumberHighOrder;
} IPSEC_OFFLOAD_V2_SECURITY_ASSOCIATION;
typedef IPSEC_OFFLOAD_V2_SECURITY_ASSOCIATION   *PIPSEC_OFFLOAD_V2_SECURITY_ASSOCIATION;
#endif

/* IPsec offload (version 2) add security association */
#if NDIS_SUPPORT_NDIS61
typedef struct _IPSEC_OFFLOAD_V2_ADD_SA {
    NDIS_OBJECT_HEADER                      Header;
    struct _IPSEC_OFFLOAD_V2_ADD_SA         *Next;
    ULONG                                   NumExtHdrs;
    ULONG                                   Flags;
    union {
        struct {
            IPAddr  SrcAddr;
            IPAddr  DestAddr;
        } IPv4Endpoints;
        struct {
            UCHAR   SrcAddr[16];
            UCHAR   DestAddr[16];
        } IPv6Endpoints;
    };
    NDIS_HANDLE                             OffloadHandle;
    ULONG                                   UdpEspEncapsulation;
    IPSEC_OFFLOAD_V2_SECURITY_ASSOCIATION   SecAssoc[IPSEC_OFFLOAD_V2_MAX_EXTENSION_HEADERS];
    ULONG                                   KeyLength;
    UCHAR                                   KeyData[1];
} IPSEC_OFFLOAD_V2_ADD_SA;
typedef IPSEC_OFFLOAD_V2_ADD_SA *PIPSEC_OFFLOAD_V2_ADD_SA;
#endif

/* IPsec offload (version 2) delete security association */
#if NDIS_SUPPORT_NDIS61
typedef struct _IPSEC_OFFLOAD_V2_DELETE_SA {
    NDIS_OBJECT_HEADER                  Header;
    struct _IPSEC_OFFLOAD_V2_DELETE_SA  *Next;
    NDIS_HANDLE                         OffloadHandle;
} IPSEC_OFFLOAD_V2_DELETE_SA;
typedef IPSEC_OFFLOAD_V2_DELETE_SA  *PIPSEC_OFFLOAD_V2_DELETE_SA;
#endif

/* IPsec offload (version 2) update security association */
#if NDIS_SUPPORT_NDIS61
typedef struct _IPSEC_OFFLOAD_V2_UPDATE_SA {
    NDIS_OBJECT_HEADER          Header;
    NDIS_HANDLE                 OffloadHandle;
    IPSEC_OFFLOAD_V2_OPERATION  Operation;
    IPSEC_OFFLOAD_V2_SPI_TYPE   Spi;
    ULONG                       SequenceNumberHighOrder;
} IPSEC_OFFLOAD_V2_UPDATE_SA;
typedef IPSEC_OFFLOAD_V2_UPDATE_SA  *PIPSEC_OFFLOAD_V2_UPDATE_SA;
#endif

/* NDIS 4.0 protocol characteristics callbacks */
#if NDIS_LEGACY_PROTOCOL
typedef VOID (NTAPI *OPEN_ADAPTER_COMPLETE_HANDLER)( NDIS_HANDLE, NDIS_STATUS, NDIS_STATUS );
typedef VOID (NTAPI *CLOSE_ADAPTER_COMPLETE_HANDLER)( NDIS_HANDLE, NDIS_STATUS );
typedef VOID (NTAPI *RESET_COMPLETE_HANDLER)( NDIS_HANDLE, NDIS_STATUS );
typedef VOID (NTAPI *REQUEST_COMPLETE_HANDLER)( NDIS_HANDLE, PNDIS_REQUEST, NDIS_STATUS );
typedef VOID (NTAPI *STATUS_HANDLER)( NDIS_HANDLE, NDIS_STATUS, PVOID, UINT );
typedef VOID (NTAPI *STATUS_COMPLETE_HANDLER)( NDIS_HANDLE );
typedef VOID (NTAPI *SEND_COMPLETE_HANDLER)( NDIS_HANDLE, PNDIS_PACKET, NDIS_STATUS );
typedef VOID (NTAPI *WAN_SEND_COMPLETE_HANDLER)( NDIS_HANDLE, PNDIS_WAN_PACKET, NDIS_STATUS );
typedef VOID (NTAPI *TRANSFER_DATA_COMPLETE_HANDLER)( NDIS_HANDLE, PNDIS_PACKET, NDIS_STATUS, UINT );
typedef VOID (NTAPI *WAN_TRANSFER_DATA_COMPLETE_HANDLER)( VOID );
typedef NDIS_STATUS (NTAPI *RECEIVE_HANDLER)( NDIS_HANDLE, NDIS_HANDLE, PVOID, UINT, PVOID, UINT, UINT );
typedef NDIS_STATUS (NTAPI *WAN_RECEIVE_HANDLER)( NDIS_HANDLE, PUCHAR, ULONG );
typedef VOID (NTAPI *RECEIVE_COMPLETE_HANDLER)( NDIS_HANDLE );
typedef INT (NTAPI *RECEIVE_PACKET_HANDLER)( NDIS_HANDLE, PNDIS_PACKET );
typedef VOID (NTAPI *BIND_HANDLER)( PNDIS_STATUS, NDIS_HANDLE, PNDIS_STRING, PVOID, PVOID );
typedef VOID (NTAPI *UNBIND_HANDLER)( PNDIS_STATUS, NDIS_HANDLE, NDIS_HANDLE );
typedef NDIS_STATUS (NTAPI *PNP_EVENT_HANDLER)( NDIS_HANDLE, PNET_PNP_EVENT );
typedef VOID (NTAPI *UNLOAD_PROTOCOL_HANDLER)( VOID );
#endif

/* NDIS 4.0 protocol characteristics */
#if NDIS_LEGACY_PROTOCOL
typedef struct _NDIS40_PROTOCOL_CHARACTERISTICS {
    UCHAR                           MajorNdisVersion;
    UCHAR                           MinorNdisVersion;
    USHORT                          Filler;
    union {
        UINT    Reserved;
        UINT    Flags;
    };
    OPEN_ADAPTER_COMPLETE_HANDLER   OpenAdapterCompleteHandler;
    CLOSE_ADAPTER_COMPLETE_HANDLER  CloseAdapterCompleteHandler;
    union {
        SEND_COMPLETE_HANDLER       SendCompleteHandler;
        WAN_SEND_COMPLETE_HANDLER   WanSendCompleteHandler;
    };
    union {
        TRANSFER_DATA_COMPLETE_HANDLER      TransferDataCompleteHandler;
        WAN_TRANSFER_DATA_COMPLETE_HANDLER  WanTransferDataCompleteHandler;
    };
    RESET_COMPLETE_HANDLER          ResetCompleteHandler;
    REQUEST_COMPLETE_HANDLER        RequestCompleteHandler;
    union {
        RECEIVE_HANDLER     ReceiveHandler;
        WAN_RECEIVE_HANDLER WanReceiveHandler;
    };
    RECEIVE_COMPLETE_HANDLER        ReceiveCompleteHandler;
    STATUS_HANDLER                  StatusHandler;
    STATUS_COMPLETE_HANDLER         StatusCompleteHandler;
    NDIS_STRING                     Name;
    RECEIVE_PACKET_HANDLER          ReceivePacketHandler;
    BIND_HANDLER                    BindAdapterHandler;
    UNBIND_HANDLER                  UnbindAdapterHandler;
    PNP_EVENT_HANDLER               PnPEventHandler;
    UNLOAD_PROTOCOL_HANDLER         UnloadHandler;
} NDIS40_PROTOCOL_CHARACTERISTICS;
#endif

/* NDIS 5.0 protocol characteristics callbacks */
#if NDIS_LEGACY_DRIVER
typedef VOID (NTAPI *CO_SEND_COMPLETE_HANDLER)( NDIS_STATUS, NDIS_HANDLE, PNDIS_PACKET );
typedef VOID (NTAPI *CO_STATUS_HANDLER)( NDIS_HANDLE, NDIS_HANDLE, NDIS_STATUS, PVOID, UINT );
typedef UINT (NTAPI *CO_RECEIVE_PACKET_HANDLER)( NDIS_HANDLE, NDIS_HANDLE, PNDIS_PACKET );
typedef NDIS_STATUS (NTAPI *CO_REQUEST_HANDLER)( NDIS_HANDLE, NDIS_HANDLE, NDIS_HANDLE, PNDIS_REQUEST );
typedef VOID (NTAPI *CO_REQUEST_COMPLETE_HANDLER)( NDIS_STATUS, NDIS_HANDLE, NDIS_HANDLE, NDIS_HANDLE, PNDIS_REQUEST );
#endif
#if NDIS_SUPPORT_NDIS6 || NDIS60
typedef NDIS_STATUS (NTAPI PROTOCOL_CO_OID_REQUEST)( NDIS_HANDLE, NDIS_HANDLE, NDIS_HANDLE, PNDIS_OID_REQUEST );
typedef VOID (NTAPI PROTOCOL_CO_OID_REQUEST_COMPLETE)( NDIS_HANDLE, NDIS_HANDLE, NDIS_HANDLE, PNDIS_OID_REQUEST, NDIS_STATUS );
typedef PROTOCOL_CO_OID_REQUEST             *CO_OID_REQUEST_HANDLER;
typedef PROTOCOL_CO_OID_REQUEST_COMPLETE    *CO_OID_REQUEST_COMPLETE_HANDLER;
#endif
typedef NDIS_STATUS (NTAPI PROTOCOL_CO_CREATE_VC)( NDIS_HANDLE, NDIS_HANDLE, PNDIS_HANDLE );
typedef NDIS_STATUS (NTAPI PROTOCOL_CO_DELETE_VC)( NDIS_HANDLE );
typedef VOID (NTAPI PROTOCOL_CO_AF_REGISTER_NOTIFY)( NDIS_HANDLE, PCO_ADDRESS_FAMILY );
typedef PROTOCOL_CO_CREATE_VC               *CO_CREATE_VC_HANDLER;
typedef PROTOCOL_CO_DELETE_VC               *CO_DELETE_VC_HANDLER;
typedef PROTOCOL_CO_AF_REGISTER_NOTIFY      *CO_AF_REGISTER_NOTIFY_HANDLER;

/* NDIS 5.0 protocol characteristics */
#if NDIS_LEGACY_PROTOCOL
typedef struct _NDIS50_PROTOCOL_CHARACTERISTICS {
#ifdef __cplusplus
    NDIS40_PROTOCOL_CHARACTERISTICS Ndis40Chars;
#else
    NDIS40_PROTOCOL_CHARACTERISTICS;
#endif
    PVOID                           ReservedHandlers[4];
    CO_SEND_COMPLETE_HANDLER        CoSendCompleteHandler;
    CO_STATUS_HANDLER               CoStatusHandler;
    CO_RECEIVE_PACKET_HANDLER       CoReceivePacketHandler;
    CO_AF_REGISTER_NOTIFY_HANDLER   CoAfRegisterNotifyHandler;
} NDIS50_PROTOCOL_CHARACTERISTICS;
#endif

/* NDIS 6.0 protocol characteristics callbacks */
#if NDIS_SUPPORT_NDIS6 || NDIS60
typedef VOID (NTAPI PROTOCOL_CO_RECEIVE_NET_BUFFER_LISTS)( NDIS_HANDLE, NDIS_HANDLE, PNET_BUFFER_LIST, ULONG, ULONG );
typedef VOID (NTAPI PROTOCOL_CO_SEND_NET_BUFFER_LISTS_COMPLETE)( NDIS_HANDLE, PNET_BUFFER_LIST, ULONG );
typedef VOID (NTAPI PROTOCOL_CO_STATUS_EX)( NDIS_HANDLE, NDIS_HANDLE, PNDIS_STATUS_INDICATION );
typedef NDIS_STATUS (NTAPI PROTOCOL_CL_NOTIFY_CLOSE_AF)( NDIS_HANDLE );
typedef VOID (NTAPI PROTOCOL_CL_OPEN_AF_COMPLETE_EX)( NDIS_HANDLE, NDIS_HANDLE, NDIS_STATUS );
typedef VOID (NTAPI PROTOCOL_CM_NOTIFY_CLOSE_AF_COMPLETE)( NDIS_HANDLE, NDIS_STATUS );
typedef PROTOCOL_CO_RECEIVE_NET_BUFFER_LISTS    *CO_RECEIVE_NET_BUFFER_LISTS_HANDLER;
typedef PROTOCOL_CO_SEND_NET_BUFFER_LISTS_COMPLETE  *CO_SEND_NET_BUFFER_LISTS_COMPLETE_HANDLER;
typedef PROTOCOL_CO_STATUS_EX                   *CO_STATUS_HANDLER_EX;
typedef PROTOCOL_CL_NOTIFY_CLOSE_AF             *CL_NOTIFY_CLOSE_AF_HANDLER;
typedef PROTOCOL_CL_OPEN_AF_COMPLETE_EX         *CL_OPEN_AF_COMPLETE_HANDLER_EX;
typedef PROTOCOL_CM_NOTIFY_CLOSE_AF_COMPLETE    *CM_NOTIFY_CLOSE_AF_COMPLETE_HANDLER;
#endif

/* TDI callbacks */
typedef NTSTATUS (NTAPI *TDI_REGISTER_CALLBACK)( PUNICODE_STRING, HANDLE * );
typedef NTSTATUS (NTAPI *TDI_PNP_HANDLER)( PUNICODE_STRING, PUNICODE_STRING, PUNICODE_STRING, PVOID, UINT, UINT );

/* NDIS bind parameters */
#if NDIS_SUPPORT_NDIS6 || NDIS60
typedef struct _NDIS_BIND_PARAMETERS {
    NDIS_OBJECT_HEADER              Header;
    PNDIS_STRING                    ProtocolSection;
    PNDIS_STRING                    AdapterName;
    PDEVICE_OBJECT                  PhysicalDeviceObject;
    NDIS_MEDIUM                     MediaType;
    ULONG                           MtuSize;
    ULONG64                         MaxXmitLinkSpeed;
    ULONG64                         XmitLinkSpeed;
    ULONG64                         MaxRcvLinkSpeed;
    ULONG64                         RcvLinkSpeed;
    NDIS_MEDIA_CONNECT_STATE        MediaConnectState;
    NDIS_MEDIA_DUPLEX_STATE         MediaDuplexState;
    ULONG                           LookaheadSize;
    PNDIS_PNP_CAPABILITIES          PowerManagementCapabilities;
    ULONG                           SupportedPacketFilters;
    ULONG                           MaxMulticastListSize;
    USHORT                          MacAddressLength;
    UCHAR                           CurrentMacAddress[NDIS_MAX_PHYS_ADDRESS_LENGTH];
    NDIS_PHYSICAL_MEDIUM            PhysicalMediumType;
    PNDIS_RECEIVE_SCALE_CAPABILITIES    RcvScaleCapabilities;
    NET_LUID                        BoundIfNetluid;
    NET_IFINDEX                     BoundIfIndex;
    NET_LUID                        LowestIfNetluid;
    NET_IFINDEX                     LowestIfIndex;
    NET_IF_ACCESS_TYPE              AccessType;
    NET_IF_DIRECTION_TYPE           DirectionType;
    NET_IF_CONNECTION_TYPE          ConnectionType;
    NET_IFTYPE                      IfType;
    BOOLEAN                         IfConnectorPresent;
    PNDIS_PORT                      ActivePorts;
    ULONG                           DataBackFillSize;
    ULONG                           ContextBackFillSize;
    ULONG                           MacOptions;
    NET_IF_COMPARTMENT_ID           CompartmentId;
    PNDIS_OFFLOAD                   DefaultOffloadConfiguration;
    PNDIS_TCP_CONNECTION_OFFLOAD    TcpConnectionOffloadCapabilities;
    PNDIS_STRING                    BoundAdapterName;
#if NDIS_SUPPORT_NDIS61
    PNDIS_HD_SPLIT_CURRENT_CONFIG   HDSplitCurrentConfig;
#endif
#if NDIS_SUPPORT_NDIS620
    PNDIS_RECEIVE_FILTER_CAPABILITIES   ReceiveFilterCapabilities;
    PNDIS_PM_CAPABILITIES           PowerManagementCapabilitiesEx;
    PNDIS_NIC_SWITCH_CAPABILITIES   NicSwitchCapabilities;
#endif
} NDIS_BIND_PARAMETERS;
typedef NDIS_BIND_PARAMETERS    *PNDIS_BIND_PARAMETERS;
#endif

/* NDIS 6.0 protocol entry points */
#if NDIS_SUPPORT_NDIS6 || NDIS60
typedef VOID (NTAPI PROTOCOL_OID_REQUEST_COMPLETE)( NDIS_HANDLE, PNDIS_OID_REQUEST, NDIS_STATUS );
typedef VOID (NTAPI PROTOCOL_RECEIVE_NET_BUFFER_LISTS)( NDIS_HANDLE, PNET_BUFFER_LIST, NDIS_PORT_NUMBER, ULONG, ULONG );
typedef VOID (NTAPI PROTOCOL_SEND_NET_BUFFER_LISTS_COMPLETE)( NDIS_HANDLE, PNET_BUFFER_LIST, ULONG );
typedef NDIS_STATUS (NTAPI PROTOCOL_BIND_ADAPTER_EX)( NDIS_HANDLE, NDIS_HANDLE, PNDIS_BIND_PARAMETERS );
typedef NDIS_STATUS (NTAPI PROTOCOL_UNBIND_ADAPTER_EX)( NDIS_HANDLE, NDIS_HANDLE );
typedef VOID (NTAPI PROTOCOL_OPEN_ADAPTER_COMPLETE_EX)( NDIS_HANDLE, NDIS_STATUS );
typedef VOID (NTAPI PROTOCOL_CLOSE_ADAPTER_COMPLETE_EX)( NDIS_HANDLE );
typedef VOID (NTAPI PROTOCOL_STATUS_EX)( NDIS_HANDLE, PNDIS_STATUS_INDICATION );
typedef NDIS_STATUS (NTAPI PROTOCOL_NET_PNP_EVENT)( NDIS_HANDLE, PNET_PNP_EVENT_NOTIFICATION );
typedef VOID (NTAPI PROTOCOL_UNINSTALL)( VOID );
typedef PROTOCOL_OID_REQUEST_COMPLETE           *OID_REQUEST_COMPLETE_HANDLER;
typedef PROTOCOL_RECEIVE_NET_BUFFER_LISTS       *RECEIVE_NET_BUFFER_LISTS_HANDLER;
typedef PROTOCOL_SEND_NET_BUFFER_LISTS_COMPLETE *SEND_NET_BUFFER_LISTS_COMPLETE_HANDLER;
typedef PROTOCOL_BIND_ADAPTER_EX                *BIND_HANDLER_EX;
typedef PROTOCOL_UNBIND_ADAPTER_EX              *UNBIND_HANDLER_EX;
typedef PROTOCOL_OPEN_ADAPTER_COMPLETE_EX       *OPEN_ADAPTER_COMPLETE_HANDLER_EX;
typedef PROTOCOL_CLOSE_ADAPTER_COMPLETE_EX      *CLOSE_ADAPTER_COMPLETE_HANDLER_EX;
typedef PROTOCOL_STATUS_EX                      *STATUS_HANDLER_EX;
typedef PROTOCOL_NET_PNP_EVENT                  *NET_PNP_EVENT_HANDLER;
typedef PROTOCOL_UNINSTALL                      *UNINSTALL_PROTOCOL_HANDLER;
#endif
#if NDIS_SUPPORT_NDIS61
typedef VOID (NTAPI PROTOCOL_DIRECT_OID_REQUEST_COMPLETE)( NDIS_HANDLE, PNDIS_OID_REQUEST, NDIS_STATUS );
typedef PROTOCOL_DIRECT_OID_REQUEST_COMPLETE    *DIRECT_OID_REQUEST_COMPLETE_HANDLER;
#endif

/* NDIS protocol CO characteristics */
#if NDIS_SUPPORT_NDIS6 || NDIS60
typedef struct _NDIS_PROTOCOL_CO_CHARACTERISTICS {
    NDIS_OBJECT_HEADER                          Header;
    ULONG                                       Flags;
    CO_STATUS_HANDLER_EX                        CoStatusHandlerEx;
    CO_AF_REGISTER_NOTIFY_HANDLER               CoAfRegisterNotifyHandler;
    CO_RECEIVE_NET_BUFFER_LISTS_HANDLER         CoReceiveNetBufferListsHandler;
    CO_SEND_NET_BUFFER_LISTS_COMPLETE_HANDLER   CoSendNetBufferListsCompleteHandler;
} NDIS_PROTOCOL_CO_CHARACTERISTICS;
typedef NDIS_PROTOCOL_CO_CHARACTERISTICS    *PNDIS_PROTOCOL_CO_CHARACTERISTICS;
#endif

/* NDIS protocol driver characteristics */
#if NDIS_SUPPORT_NDIS6 || NDIS60
typedef struct _NDIS_PROTOCOL_DRIVER_CHARACTERISTICS {
    NDIS_OBJECT_HEADER                      Header;
    UCHAR                                   MajorNdisVersion;
    UCHAR                                   MinorNdisVersion;
    UCHAR                                   MajorDriverVersion;
    UCHAR                                   MinorDriverVersion;
    ULONG                                   Flags;
    NDIS_STRING                             Name;
    SET_OPTIONS_HANDLER                     SetOptionsHandler;
    BIND_HANDLER_EX                         BindAdapterHandlerEx;
    UNBIND_HANDLER_EX                       UnbindAdapterHandlerEx;
    OPEN_ADAPTER_COMPLETE_HANDLER_EX        OpenAdapterCompleteHandlerEx;
    CLOSE_ADAPTER_COMPLETE_HANDLER_EX       CloseAdapterCompleteHandlerEx;
    NET_PNP_EVENT_HANDLER                   NetPnPEventHandler;
    UNINSTALL_PROTOCOL_HANDLER              UninstallHandler;
    OID_REQUEST_COMPLETE_HANDLER            OidRequestCompleteHandler;
    STATUS_HANDLER_EX                       StatusHandlerEx;
    RECEIVE_NET_BUFFER_LISTS_HANDLER        ReceiveNetBufferListsHandler;
    SEND_NET_BUFFER_LISTS_COMPLETE_HANDLER  SendNetBufferListsCompleteHandler;
#if NDIS_SUPPORT_NDIS61
    DIRECT_OID_REQUEST_COMPLETE_HANDLER     DirectOidRequestCompleteHandler;
#endif
} NDIS_PROTOCOL_DRIVER_CHARACTERISTICS;
typedef NDIS_PROTOCOL_DRIVER_CHARACTERISTICS    *PNDIS_PROTOCOL_DRIVER_CHARACTERISTICS;
#endif

/* NDIS protocol characteristics */
#if NDIS_LEGACY_PROTOCOL
#if defined( NDIS50 ) || defined( NDIS51 )
typedef NDIS50_PROTOCOL_CHARACTERISTICS NDIS_PROTOCOL_CHARACTERISTICS;
#else
typedef NDIS40_PROTOCOL_CHARACTERISTICS NDIS_PROTOCOL_CHARACTERISTICS;
#endif
typedef NDIS_PROTOCOL_CHARACTERISTICS   *PNDIS_PROTOCOL_CHARACTERISTICS;
#endif

/* NDIS open parameters */
#if NDIS_SUPPORT_NDIS6 || NDIS60
typedef struct _NDIS_OPEN_PARAMETERS {
    NDIS_OBJECT_HEADER  Header;
    PNDIS_STRING        AdapterName;
    PNDIS_MEDIUM        MediumArray;
    UINT                MediumArraySize;
    PUINT               SelectedMediumIndex;
    PNET_FRAME_TYPE     FrameTypeArray;
    UINT                FrameTypeArraySize;
} NDIS_OPEN_PARAMETERS;
typedef NDIS_OPEN_PARAMETERS    *PNDIS_OPEN_PARAMETERS;
#endif

/* NDIS protocol pause parameters */
#if NDIS_SUPPORT_NDIS6 || NDIS60
typedef struct _NDIS_PROTOCOL_PAUSE_PARAMETERS {
    NDIS_OBJECT_HEADER  Header;
    ULONG               Flags;
    ULONG               PauseReason;
} NDIS_PROTOCOL_PAUSE_PARAMETERS;
typedef NDIS_PROTOCOL_PAUSE_PARAMETERS  *PNDIS_PROTOCOL_PAUSE_PARAMETERS;
#endif

/* NDIS protocol restart parameters */
#if NDIS_SUPPORT_NDIS6 || NDIS60
typedef struct _NDIS_PROTOCOL_RESTART_PARAMETERS {
    NDIS_OBJECT_HEADER          Header;
    PUCHAR                      FilterModuleNameBuffer;
    ULONG                       FilterModuleNameBufferLength;
    PNDIS_RESTART_ATTRIBUTES    RestartAttributes;
    NET_IFINDEX                 BoundIfIndex;
    NET_LUID                    BoundIfNetluid;
    ULONG                       Flags;
} NDIS_PROTOCOL_RESTART_PARAMETERS;
typedef NDIS_PROTOCOL_RESTART_PARAMETERS    *PNDIS_PROTOCOL_RESTART_PARAMETERS;
#endif

/* NDIS common open block */
#if !defined( NDIS_WRAPPER ) && NDIS_LEGACY_PROTOCOL
typedef struct _NDIS_COMMON_OPEN_BLOCK {
    PVOID                           MacHandle;
    NDIS_HANDLE                     BindingHandle;
    NDIS_HANDLE                     Reserved6;
    NDIS_HANDLE                     Reserved7;
    NDIS_HANDLE                     Reserved8;
    PVOID                           Reserved9;
    NDIS_HANDLE                     Reserved10;
    NDIS_HANDLE                     Reserved11;
    BOOLEAN                         Reserved12;
    BOOLEAN                         Reserved2;
    BOOLEAN                         Reserved3;
    BOOLEAN                         Reserved4;
    PVOID                           Reserved13;
    KSPIN_LOCK                      Reserved5;
    NDIS_HANDLE                     Reserved14;
    union {
        SEND_HANDLER        SendHandler;
        WAN_SEND_HANDLER    WanSendHandler;
    };
    TRANSFER_DATA_HANDLER           TransferDataHandler;
    SEND_COMPLETE_HANDLER           SendCompleteHandler;
    TRANSFER_DATA_COMPLETE_HANDLER  TransferDataCompleteHandler;
    RECEIVE_HANDLER                 ReceiveHandler;
    RECEIVE_COMPLETE_HANDLER        ReceiveCompleteHandler;
    WAN_RECEIVE_HANDLER             WanReceiveHandler;
    REQUEST_COMPLETE_HANDLER        RequestCompleteHandler;
    RECEIVE_PACKET_HANDLER          ReceivePacketHandler;
    SEND_PACKETS_HANDLER            SendPacketsHandler;
    RESET_HANDLER                   ResetHandler;
    REQUEST_HANDLER                 RequestHandler;
    RESET_COMPLETE_HANDLER          ResetCompleteHandler;
    STATUS_HANDLER                  StatusHandler;
    STATUS_COMPLETE_HANDLER         StatusCompleteHandler;
} NDIS_COMMON_OPEN_BLOCK;
typedef NDIS_COMMON_OPEN_BLOCK  *PNDIS_COMMON_OPEN_BLOCK;
#endif

/* NDIS open block */
#if !defined( NDIS_WRAPPER ) && NDIS_LEGACY_PROTOCOL
typedef struct _NDIS_OPEN_BLOCK {
#ifdef __cplusplus
    NDIS_COMMON_OPEN_BLOCK  NdisCommonOpenBlock;
#else
    NDIS_COMMON_OPEN_BLOCK;
#endif
} NDIS_OPEN_BLOCK;
typedef NDIS_OPEN_BLOCK *PNDIS_OPEN_BLOCK;
#endif

/* NDIS miniport characteristics callbacks */
#if NDIS_LEGACY_MINIPORT
typedef BOOLEAN (NTAPI *W_CHECK_FOR_HANG_HANDLER)( NDIS_HANDLE );
typedef VOID (NTAPI *W_DISABLE_INTERRUPT_HANDLER)( NDIS_HANDLE );
typedef VOID (NTAPI *W_ENABLE_INTERRUPT_HANDLER)( NDIS_HANDLE );
typedef VOID (NTAPI *W_HALT_HANDLER)( NDIS_HANDLE );
typedef VOID (NTAPI *W_HANDLE_INTERRUPT_HANDLER)( NDIS_HANDLE );
typedef NDIS_STATUS (NTAPI *W_INITIALIZE_HANDLER)( PNDIS_STATUS, PUINT, PNDIS_MEDIUM, UINT, NDIS_HANDLE, NDIS_HANDLE );
typedef VOID (NTAPI *W_ISR_HANDLER)( PBOOLEAN, PBOOLEAN, NDIS_HANDLE );
typedef NDIS_STATUS (NTAPI *W_QUERY_INFORMATION_HANDLER)( NDIS_HANDLE, NDIS_OID, PVOID, ULONG, PULONG, PULONG );
typedef NDIS_STATUS (NTAPI *W_RECONFIGURE_HANDLER)( PNDIS_STATUS, NDIS_HANDLE, NDIS_HANDLE );
typedef NDIS_STATUS (NTAPI *W_RESET_HANDLER)( PBOOLEAN, NDIS_HANDLE );
typedef NDIS_STATUS (NTAPI *W_SEND_HANDLER)( NDIS_HANDLE, PNDIS_PACKET, UINT );
typedef NDIS_STATUS (NTAPI *WM_SEND_HANDLER)( NDIS_HANDLE, NDIS_HANDLE, PNDIS_WAN_PACKET );
typedef NDIS_STATUS (NTAPI *W_SET_INFORMATION_HANDLER)( NDIS_HANDLE, NDIS_OID, PVOID, ULONG, PULONG, PULONG );
typedef NDIS_STATUS (NTAPI *W_TRANSFER_DATA_HANDLER)( PNDIS_PACKET, PUINT, NDIS_HANDLE, NDIS_HANDLE, UINT, UINT );
typedef NDIS_STATUS (NTAPI *WM_TRANSFER_DATA_HANDLER)( VOID );
typedef VOID (NTAPI *ADAPTER_SHUTDOWN_HANDLER)( PVOID );
typedef VOID (NTAPI *W_RETURN_PACKET_HANDLER)( NDIS_HANDLE, PNDIS_PACKET );
typedef VOID (NTAPI *W_SEND_PACKETS_HANDLER)( NDIS_HANDLE, PPNDIS_PACKET, UINT );
typedef VOID (NTAPI *W_ALLOCATE_COMPLETE_HANDLER)( NDIS_HANDLE, PVOID, PNDIS_PHYSICAL_ADDRESS, ULONG, PVOID );
#endif
typedef NDIS_STATUS (NTAPI MINIPORT_CO_CREATE_VC)( NDIS_HANDLE, NDIS_HANDLE, PNDIS_HANDLE );
typedef NDIS_STATUS (NTAPI MINIPORT_CO_DELETE_VC)( NDIS_HANDLE );
typedef NDIS_STATUS (NTAPI MINIPORT_CO_ACTIVATE_VC)( NDIS_HANDLE, PCO_CALL_PARAMETERS );
typedef NDIS_STATUS (NTAPI MINIPORT_CO_DEACTIVATE_VC)( NDIS_HANDLE );
typedef MINIPORT_CO_CREATE_VC       *W_CO_CREATE_VC_HANDLER;
typedef MINIPORT_CO_DELETE_VC       *W_CO_DELETE_VC_HANDLER;
typedef MINIPORT_CO_ACTIVATE_VC     *W_CO_ACTIVATE_VC_HANDLER;
typedef MINIPORT_CO_DEACTIVATE_VC   *W_CO_DEACTIVATE_VC_HANDLER;
#if NDIS_LEGACY_MINIPORT
typedef VOID (NTAPI *W_CO_SEND_PACKETS_HANDLER)( NDIS_HANDLE, PPNDIS_PACKET, UINT );
typedef NDIS_STATUS (NTAPI *W_CO_REQUEST_HANDLER)( NDIS_HANDLE, NDIS_HANDLE, PNDIS_REQUEST );
#endif
#if NDIS_SUPPORT_NDIS6
typedef VOID (NTAPI MINIPORT_CO_SEND_NET_BUFFER_LISTS)( NDIS_HANDLE, PNET_BUFFER_LIST, ULONG );
typedef NDIS_STATUS (NTAPI MINIPORT_CO_OID_REQUEST)( NDIS_HANDLE, NDIS_HANDLE, PNDIS_OID_REQUEST );
typedef MINIPORT_CO_SEND_NET_BUFFER_LISTS   *W_CO_SEND_NET_BUFFER_LISTS_HANDLER;
typedef MINIPORT_CO_OID_REQUEST             *W_CO_OID_REQUEST_HANDLER;
#endif

/* NDIS device Plug and Play events */
typedef enum _NDIS_DEVICE_PNP_EVENT {
    NdisDevicePnPEventQueryRemoved          = 0,
    NdisDevicePnPEventRemoved               = 1,
    NdisDevicePnPEventSurpriseRemoved       = 2,
    NdisDevicePnPEventQueryStopped          = 3,
    NdisDevicePnPEventStopped               = 4,
    NdisDevicePnPEventPowerProfileChanged   = 5,
#if NDIS_SUPPORT_NDIS6
    NdisDevicePnPEventFilterListChanged     = 6,
    NdisDevicePnPEventMaximum               = 7
#else
    NdisDevicePnPEventMaximum               = 6
#endif
} NDIS_DEVICE_PNP_EVENT;
typedef NDIS_DEVICE_PNP_EVENT   *PNDIS_DEVICE_PNP_EVENT;

/* NDIS power profiles */
typedef enum _NDIS_POWER_PROFILE {
    NdisPowerProfileBattery     = 0,
    NdisPowerProfileAcOnLine    = 1
} NDIS_POWER_PROFILE;
typedef NDIS_POWER_PROFILE  *PNDIS_POWER_PROFILE;

/* NDIS 5.0 miniport characteristics */
#if NDIS_LEGACY_MINIPORT
typedef struct _NDIS50_MINIPORT_CHARACTERISTICS {
    UCHAR                       MajorNdisVersion;
    UCHAR                       MinorNdisVersion;
    USHORT                      Filler;
    UINT                        Reserved;
    W_CHECK_FOR_HANG_HANDLER    CheckForHangHandler;
    W_DISABLE_INTERRUPT_HANDLER DisableInterruptHandler;
    W_ENABLE_INTERRUPT_HANDLER  EnableInterruptHandler;
    W_HALT_HANDLER              HaltHandler;
    W_HANDLE_INTERRUPT_HANDLER  HandleInterruptHandler;
    W_INITIALIZE_HANDLER        InitializeHandler;
    W_ISR_HANDLER               ISRHandler;
    W_QUERY_INFORMATION_HANDLER QueryInformationHandler;
    W_RECONFIGURE_HANDLER       ReconfigureHandler;
    W_RESET_HANDLER             ResetHandler;
    union {
        W_SEND_HANDLER  SendHandler;
        WM_SEND_HANDLER WanSendHandler;
    };
    W_SET_INFORMATION_HANDLER   SetInformationHandler;
    union {
        W_TRANSFER_DATA_HANDLER     TransferDataHandler;
        WM_TRANSFER_DATA_HANDLER    WanTransferDataHandler;
    };
    W_RETURN_PACKET_HANDLER     ReturnPacketHandler;
    W_SEND_PACKETS_HANDLER      SendPacketsHandler;
    W_ALLOCATE_COMPLETE_HANDLER AllocateCompleteHandler;
    W_CO_CREATE_VC_HANDLER      CoCreateVcHandler;
    W_CO_DELETE_VC_HANDLER      CoDeleteVcHandler;
    W_CO_ACTIVATE_VC_HANDLER    CoActivateVcHandler;
    W_CO_DEACTIVATE_VC_HANDLER  CoDeactivateVcHandler;
    W_CO_SEND_PACKETS_HANDLER   CoSendPacketsHandler;
    W_CO_REQUEST_HANDLER        CoRequestHandler;
} NDIS50_MINIPORT_CHARACTERISTICS;
#endif

/* NDIS 5.1 miniport characteristics callbacks */
#if NDIS_LEGACY_MINIPORT
#if ((NDIS_MINIPORT_MAJOR_VERSION == 5) && (NDIS_MINIPORT_MINOR_VERSION == 1)) || \
    NDIS_WRAPPER
typedef VOID (NTAPI *W_CANCEL_SEND_PACKETS_HANDLER)( NDIS_HANDLE, PVOID );
typedef VOID (NTAPI *W_PNP_EVENT_NOTIFY_HANDLER)( NDIS_HANDLE, NDIS_DEVICE_PNP_EVENT, PVOID, ULONG );
typedef VOID (NTAPI *W_MINIPORT_SHUTDOWN_HANDLER)( NDIS_HANDLE );
#endif
#endif

/* NDIS receive throttle parameters */
#if NDIS_SUPPORT_NDIS620
typedef struct _NDIS_RECEIVE_THROTTLE_PARAMETERS {
    ULONG   MaxNblsToIndicate;
    ULONG   MoreNblsPending : 1;
} NDIS_RECEIVE_THROTTLE_PARAMETERS;
typedef NDIS_RECEIVE_THROTTLE_PARAMETERS    *PNDIS_RECEIVE_THROTTLE_PARAMETERS;
#endif

/* NDIS 6.0 miniport interrupt characteristics callbacks */
#if NDIS_SUPPORT_NDIS6
typedef BOOLEAN (NTAPI MINIPORT_ISR)( NDIS_HANDLE, PBOOLEAN, PULONG );
typedef VOID (NTAPI MINIPORT_INTERRUPT_DPC)( NDIS_HANDLE, PVOID, PVOID, PVOID );
typedef VOID (NTAPI MINIPORT_DISABLE_INTERRUPT)( NDIS_HANDLE );
typedef VOID (NTAPI MINIPORT_ENABLE_INTERRUPT)( NDIS_HANDLE );
typedef BOOLEAN (NTAPI MINIPORT_MESSAGE_INTERRUPT)( NDIS_HANDLE, ULONG, PBOOLEAN, PULONG );
#if NDIS_SUPPORT_NDIS620
typedef VOID (NTAPI MINIPORT_MESSAGE_INTERRUPT_DPC)( NDIS_HANDLE, ULONG, PVOID, PVOID, PVOID );
#else
typedef VOID (NTAPI MINIPORT_MESSAGE_INTERRUPT_DPC)( NDIS_HANDLE, ULONG, PVOID, PULONG, PULONG );
#endif
typedef VOID (NTAPI MINIPORT_DISABLE_MESSAGE_INTERRUPT)( NDIS_HANDLE, ULONG );
typedef VOID (NTAPI MINIPORT_ENABLE_MESSAGE_INTERRUPT)( NDIS_HANDLE, ULONG );
typedef BOOLEAN (NTAPI MINIPORT_SYNCHRONIZE_INTERRUPT)( NDIS_HANDLE );
typedef MINIPORT_ISR                        *MINIPORT_ISR_HANDLER;
typedef MINIPORT_INTERRUPT_DPC              *MINIPORT_INTERRUPT_DPC_HANDLER;
typedef MINIPORT_DISABLE_INTERRUPT          *MINIPORT_DISABLE_INTERRUPT_HANDLER;
typedef MINIPORT_ENABLE_INTERRUPT           *MINIPORT_ENABLE_INTERRUPT_HANDLER;
typedef MINIPORT_MESSAGE_INTERRUPT          *MINIPORT_MSI_ISR_HANDLER;
typedef MINIPORT_MESSAGE_INTERRUPT_DPC      *MINIPORT_MSI_INTERRUPT_DPC_HANDLER;
typedef MINIPORT_DISABLE_MESSAGE_INTERRUPT  *MINIPORT_DISABLE_MSI_INTERRUPT_HANDLER;
typedef MINIPORT_ENABLE_MESSAGE_INTERRUPT   *MINIPORT_ENABLE_MSI_INTERRUPT_HANDLER;
typedef MINIPORT_SYNCHRONIZE_INTERRUPT      *MINIPORT_SYNCHRONIZE_INTERRUPT_HANDLER;
typedef MINIPORT_SYNCHRONIZE_INTERRUPT      MINIPORT_SYNCHRONIZE_MESSAGE_INTERRUPT;
typedef MINIPORT_SYNCHRONIZE_MESSAGE_INTERRUPT  *MINIPORT_SYNCHRONIZE_MSI_INTERRUPT_HANDLER;
#endif

/* NDIS interrupt types */
#if NDIS_SUPPORT_NDIS6
typedef enum _NDIS_INTERRUPT_TYPE {
    NDIS_CONNECT_LINE_BASED     = 1,
    NDIS_CONNECT_MESSAGE_BASED  = 2
} NDIS_INTERRUPT_TYPE;
typedef NDIS_INTERRUPT_TYPE *PNDIS_INTERRUPT_TYPE;
#endif

/* NDIS miniport interrupt characteristics */
#if NDIS_SUPPORT_NDIS6
typedef struct _NDIS_MINIPORT_INTERRUPT_CHARACTERISTICS {
    NDIS_OBJECT_HEADER                      Header;
    MINIPORT_ISR_HANDLER                    InterruptHandler;
    MINIPORT_INTERRUPT_DPC_HANDLER          InterruptDpcHandler;
    MINIPORT_DISABLE_INTERRUPT_HANDLER      DisableInterruptHandler;
    MINIPORT_ENABLE_INTERRUPT_HANDLER       EnableInterruptHandler;
    BOOLEAN                                 MsiSupported;
    BOOLEAN                                 MsiSyncWithAllMessages;
    MINIPORT_MSI_ISR_HANDLER                MessageInterruptHandler;
    MINIPORT_MSI_INTERRUPT_DPC_HANDLER      MessageInterruptDpcHandler;
    MINIPORT_DISABLE_MSI_INTERRUPT_HANDLER  DisableMessageInterruptHandler;
    MINIPORT_ENABLE_MSI_INTERRUPT_HANDLER   EnableMessageInterruptHandler;
    NDIS_INTERRUPT_TYPE                     InterruptType;
    PIO_INTERRUPT_MESSAGE_INFO              MessageInfoTable;
} NDIS_MINIPORT_INTERRUPT_CHARACTERISTICS;
typedef NDIS_MINIPORT_INTERRUPT_CHARACTERISTICS *PNDIS_MINIPORT_INTERRUPT_CHARACTERISTICS;
#endif

/* NDIS miniport Plug and Play characteristics callbacks */
#if NDIS_SUPPORT_NDIS6
typedef NDIS_STATUS (NTAPI MINIPORT_ADD_DEVICE)( NDIS_HANDLE, NDIS_HANDLE );
typedef VOID (NTAPI MINIPORT_REMOVE_DEVICE)( NDIS_HANDLE );
typedef NDIS_STATUS (NTAPI MINIPORT_PNP_IRP)( NDIS_HANDLE, PIRP );
typedef MINIPORT_ADD_DEVICE     *MINIPORT_ADD_DEVICE_HANDLER;
typedef MINIPORT_REMOVE_DEVICE  *MINIPORT_REMOVE_DEVICE_HANDLER;
typedef MINIPORT_PNP_IRP        *MINIPORT_PNP_IRP_HANDLER;
typedef MINIPORT_PNP_IRP        MINIPORT_START_DEVICE;
typedef MINIPORT_PNP_IRP        *MINIPORT_START_DEVICE_HANDLER;
typedef MINIPORT_PNP_IRP        MINIPORT_FILTER_RESOURCE_REQUIREMENTS;
typedef MINIPORT_PNP_IRP        *MINIPORT_FILTER_RESOURCE_REQUIREMENTS_HANDLER;
#endif

/* NDIS miniport Plug and Play characteristics */
#if NDIS_SUPPORT_NDIS6
typedef struct _NDIS_MINIPORT_PNP_CHARACTERISTICS {
    NDIS_OBJECT_HEADER              Header;
    MINIPORT_ADD_DEVICE_HANDLER     MiniportAddDeviceHandler;
    MINIPORT_REMOVE_DEVICE_HANDLER  MiniportRemoveDeviceHandler;
    MINIPORT_FILTER_RESOURCE_REQUIREMENTS_HANDLER   MiniportFilterResourceRequirementsHandler;
    MINIPORT_START_DEVICE_HANDLER   MiniportStartDeviceHandler;
    ULONG                           Flags;
} NDIS_MINIPORT_PNP_CHARACTERISTICS;
typedef NDIS_MINIPORT_PNP_CHARACTERISTICS   *PNDIS_MINIPORT_PNP_CHARACTERISTICS;
#endif

/* NDIS 5.1 miniport characteristics */
#if NDIS_LEGACY_MINIPORT
#if ((NDIS_MINIPORT_MAJOR_VERSION == 5) && (NDIS_MINIPORT_MINOR_VERSION == 1)) || \
    NDIS_WRAPPER
typedef struct _NDIS51_MINIPORT_CHARACTERISTICS {
#ifdef __cplusplus
    NDIS50_MINIPORT_CHARACTERISTICS Ndis50Chars;
#else
    NDIS50_MINIPORT_CHARACTERISTICS;
#endif
    W_CANCEL_SEND_PACKETS_HANDLER   CancelSendPacketsHandler;
    W_PNP_EVENT_NOTIFY_HANDLER      PnPEventNotifyHandler;
    W_MINIPORT_SHUTDOWN_HANDLER     AdapterShutdownHandler;
    PVOID                           Reserved1;
    PVOID                           Reserved2;
    PVOID                           Reserved3;
    PVOID                           Reserved4;
} NDIS51_MINIPORT_CHARACTERISTICS;
#endif
#endif

/* NDIS miniport interrupt */
#if NDIS_LEGACY_MINIPORT
typedef struct _NDIS_MINIPORT_INTERRUPT {
    PKINTERRUPT                 InterruptObject;
    KSPIN_LOCK                  DpcCountLock;
    PVOID                       Reserved;
    W_ISR_HANDLER               MiniportIsr;
    W_HANDLE_INTERRUPT_HANDLER  MiniportDpc;
    KDPC                        InterruptDpc;
    struct _NDIS_MINIPORT_BLOCK *Miniport;
    UCHAR                       DpcCount;
    BOOLEAN                     Filler1;
    KEVENT                      DpcsCompletedEvent;
    BOOLEAN                     SharedInterrupt;
    BOOLEAN                     IsrRequested;
} NDIS_MINIPORT_INTERRUPT;
typedef NDIS_MINIPORT_INTERRUPT *PNDIS_MINIPORT_INTERRUPT;
#endif

/* NDIS miniport timer */
typedef struct _NDIS_MINIPORT_TIMER {
    KTIMER                      Timer;
    KDPC                        Dpc;
    PNDIS_TIMER_FUNCTION        MiniportTimerFunction;
    PVOID                       MiniportTimerContext;
    struct _NDIS_MINIPORT_BLOCK *Miniport;
    struct _NDIS_MINIPORT_TIMER *NextTimer;
} NDIS_MINIPORT_TIMER;
typedef NDIS_MINIPORT_TIMER *PNDIS_MINIPORT_TIMER;

/* NDIS miniport block callbacks */
#if NDIS_LEGACY_MINIPORT
typedef VOID (NTAPI *ETH_RCV_INDICATE_HANDLER)( PETH_FILTER, NDIS_HANDLE, PCHAR, PVOID, UINT, PVOID, UINT, UINT );
typedef VOID (NTAPI *ETH_RCV_COMPLETE_HANDLER)( PETH_FILTER );
typedef VOID (NTAPI *TR_RCV_INDICATE_HANDLER)( PTR_FILTER, NDIS_HANDLE, PVOID, UINT, PVOID, UINT, UINT );
typedef VOID (NTAPI *TR_RCV_COMPLETE_HANDLER)( PTR_FILTER );
typedef VOID (NTAPI *WAN_RCV_HANDLER)( PNDIS_STATUS, NDIS_HANDLE, NDIS_HANDLE, PUCHAR, ULONG );
typedef VOID (NTAPI *WAN_RCV_COMPLETE_HANDLER)( NDIS_HANDLE, NDIS_HANDLE );
typedef VOID (NTAPI *NDIS_M_SEND_COMPLETE_HANDLER)( NDIS_HANDLE, PNDIS_PACKET, NDIS_STATUS );
typedef VOID (NTAPI *NDIS_WM_SEND_COMPLETE_HANDLER)( NDIS_HANDLE, PVOID, NDIS_STATUS );
typedef VOID (NTAPI *NDIS_M_TD_COMPLETE_HANDLER)( NDIS_HANDLE, PNDIS_PACKET, NDIS_STATUS, UINT );
typedef VOID (NTAPI *NDIS_M_SEND_RESOURCES_HANDLER)( NDIS_HANDLE );
typedef VOID (NTAPI *NDIS_M_STATUS_HANDLER)( NDIS_HANDLE, NDIS_STATUS, PVOID, UINT );
typedef VOID (NTAPI *NDIS_M_STS_COMPLETE_HANDLER)( NDIS_HANDLE );
typedef VOID (NTAPI *NDIS_M_REQ_COMPLETE_HANDLER)( NDIS_HANDLE, NDIS_STATUS );
typedef VOID (NTAPI *NDIS_M_RESET_COMPLETE_HANDLER)( NDIS_HANDLE, NDIS_STATUS, BOOLEAN );
typedef BOOLEAN (FASTCALL *NDIS_M_START_SENDS)( struct _NDIS_MINIPORT_BLOCK * );
#endif

/* Callbacks for NdisMRegisterScatterGatherDma() */
#if NDIS_SUPPORT_NDIS6
typedef VOID (NTAPI MINIPORT_PROCESS_SG_LIST)( PDEVICE_OBJECT, PVOID, PSCATTER_GATHER_LIST, PVOID );
typedef VOID (NTAPI MINIPORT_ALLOCATE_SHARED_MEM_COMPLETE)( NDIS_HANDLE, PVOID, PNDIS_PHYSICAL_ADDRESS, ULONG, PVOID );
typedef MINIPORT_PROCESS_SG_LIST                *MINIPORT_PROCESS_SG_LIST_HANDLER;
typedef MINIPORT_ALLOCATE_SHARED_MEM_COMPLETE   *MINIPORT_ALLOCATE_SHARED_MEM_COMPLETE_HANDLER;
#endif

/* NDIS DMA description */
typedef struct _NDIS_DMA_DESCRIPTION {
    BOOLEAN     DemandMode;
    BOOLEAN     AutoInitialize;
    BOOLEAN     DmaChannelSpecified;
    DMA_WIDTH   DmaWidth;
    DMA_SPEED   DmaSpeed;
    ULONG       DmaPort;
    ULONG       DmaChannel;
} NDIS_DMA_DESCRIPTION;
typedef NDIS_DMA_DESCRIPTION    *PNDIS_DMA_DESCRIPTION;

/* NDIS DMA block */
typedef struct _NDIS_DMA_BLOCK {
    PVOID   MapRegisterBase;
    KEVENT  AllocationEvent;
    PVOID   SystemAdapterObject;
    PVOID   Miniport;
    BOOLEAN InProgress;
} NDIS_DMA_BLOCK;
typedef NDIS_DMA_BLOCK  *PNDIS_DMA_BLOCK;

/* NDIS scatter/gather DMA description */
#if NDIS_SUPPORT_NDIS6
typedef struct _NDIS_SG_DMA_DESCRIPTION {
    NDIS_OBJECT_HEADER                              Header;
    ULONG                                           Flags;
    ULONG                                           MaximumPhysicalMapping;
    MINIPORT_PROCESS_SG_LIST_HANDLER                ProcessSGListHandler;
    MINIPORT_ALLOCATE_SHARED_MEM_COMPLETE_HANDLER   SharedMemAllocateCompleteHandler;
    ULONG                                           ScatterGatherListSize;
} NDIS_SG_DMA_DESCRIPTION;
typedef NDIS_SG_DMA_DESCRIPTION *PNDIS_SG_DMA_DESCRIPTION;
#endif

/* NDIS miniport initialization parameters */
#if NDIS_SUPPORT_NDIS6
typedef struct _NDIS_MINIPORT_INIT_PARAMETERS {
    NDIS_OBJECT_HEADER                      Header;
    ULONG                                   Flags;
    PNDIS_RESOURCE_LIST                     AllocatedResources;
    NDIS_HANDLE                             IMDeviceInstanceContext;
    NDIS_HANDLE                             MiniportAddDeviceContext;
    NET_IFINDEX                             IfIndex;
    NET_LUID                                NetLuid;
    PNDIS_PORT_AUTHENTICATION_PARAMETERS    DefaultPortAuthStates;
    PNDIS_PCI_DEVICE_CUSTOM_PROPERTIES      PciDeviceCustomProperties;
} NDIS_MINIPORT_INIT_PARAMETERS;
typedef NDIS_MINIPORT_INIT_PARAMETERS   *PNDIS_MINIPORT_INIT_PARAMETERS;
#endif

/* NDIS miniport restart parameters */
#if NDIS_SUPPORT_NDIS6
typedef struct _NDIS_MINIPORT_RESTART_PARAMETERS {
    NDIS_OBJECT_HEADER          Header;
    PNDIS_RESTART_ATTRIBUTES    RestartAttributes;
    ULONG                       Flags;
} NDIS_MINIPORT_RESTART_PARAMETERS;
typedef NDIS_MINIPORT_RESTART_PARAMETERS    *PNDIS_MINIPORT_RESTART_PARAMETERS;
#endif

/* NDIS miniport adapter registration attributes */
#if NDIS_SUPPORT_NDIS6
typedef struct _NDIS_MINIPORT_ADAPTER_REGISTRATION_ATTRIBUTES {
    NDIS_OBJECT_HEADER  Header;
    NDIS_HANDLE         MiniportAdapterContext;
    ULONG               AttributeFlags;
    UINT                CheckForHangTimeInSeconds;
    NDIS_INTERFACE_TYPE InterfaceType;
} NDIS_MINIPORT_ADAPTER_REGISTRATION_ATTRIBUTES;
typedef NDIS_MINIPORT_ADAPTER_REGISTRATION_ATTRIBUTES   *PNDIS_MINIPORT_ADAPTER_REGISTRATION_ATTRIBUTES;
#endif

/* NDIS miniport add device registration attributes */
#if NDIS_SUPPORT_NDIS6
typedef struct _NDIS_MINIPORT_ADD_DEVICE_REGISTRATION_ATTRIBUTES {
    NDIS_OBJECT_HEADER  Header;
    NDIS_HANDLE         MiniportAddDeviceContext;
    ULONG               Flags;
} NDIS_MINIPORT_ADD_DEVICE_REGISTRATION_ATTRIBUTES;
typedef NDIS_MINIPORT_ADD_DEVICE_REGISTRATION_ATTRIBUTES    *PNDIS_MINIPORT_ADD_DEVICE_REGISTRATION_ATTRIBUTES;
#endif

/* NDIS miniport adapter general attributes */
#if NDIS_SUPPORT_NDIS6
typedef struct _NDIS_MINIPORT_ADAPTER_GENERAL_ATTRIBUTES {
    NDIS_OBJECT_HEADER          Header;
    ULONG                       Flags;
    NDIS_MEDIUM                 MediaType;
    NDIS_PHYSICAL_MEDIUM        PhysicalMediumType;
    ULONG                       MtuSize;
    ULONG64                     MaxXmitLinkSpeed;
    ULONG64                     XmitLinkSpeed;
    ULONG64                     MaxRcvLinkSpeed;
    ULONG64                     RcvLinkSpeed;
    NDIS_MEDIA_CONNECT_STATE    MediaConnectState;
    NDIS_MEDIA_DUPLEX_STATE     MediaDuplexState;
    ULONG                       LookaheadSize;
    PNDIS_PNP_CAPABILITIES      PowerManagementCapabilities;
    ULONG                       MacOptions;
    ULONG                       SupportedPacketFilters;
    ULONG                       MaxMulticastListSize;
    USHORT                      MacAddressLength;
    UCHAR                       PermanentMacAddress[NDIS_MAX_PHYS_ADDRESS_LENGTH];
    UCHAR                       CurrentMacAddress[NDIS_MAX_PHYS_ADDRESS_LENGTH];
    PNDIS_RECEIVE_SCALE_CAPABILITIES    RecvScaleCapabilities;
    NET_IF_ACCESS_TYPE          AccessType;
    NET_IF_DIRECTION_TYPE       DirectionType;
    NET_IF_CONNECTION_TYPE      ConnectionType;
    NET_IFTYPE                  IfType;
    BOOLEAN                     IfConnectorPresent;
    ULONG                       SupportedStatistics;
    ULONG                       SupportedPauseFunctions;
    ULONG                       DataBackFillSize;
    ULONG                       ContextBackFillSize;
    PNDIS_OID                   SupportedOidList;
    ULONG                       SupportedOidListLength;
    ULONG                       AutoNegotiationFlags;
#if NDIS_SUPPORT_NDIS620
    PNDIS_PM_CAPABILITIES       PowerManagementCapabilitiesEx;
#endif
} NDIS_MINIPORT_ADAPTER_GENERAL_ATTRIBUTES;
typedef NDIS_MINIPORT_ADAPTER_GENERAL_ATTRIBUTES    *PNDIS_MINIPORT_ADAPTER_GENERAL_ATTRIBUTES;
#endif

/* NDIS header/data split attributes */
#if NDIS_SUPPORT_NDIS61
typedef struct _NDIS_HD_SPLIT_ATTRIBUTES {
    NDIS_OBJECT_HEADER  Header;
    ULONG               HardwareCapabilities;
    ULONG               CurrentCapabilities;
    ULONG               HDSplitFlags;
    ULONG               BackfillSize;
    ULONG               MaxHeaderSize;
} NDIS_HD_SPLIT_ATTRIBUTES;
typedef NDIS_HD_SPLIT_ATTRIBUTES    *PNDIS_HD_SPLIT_ATTRIBUTES;
#endif

/* NDIS miniport adapter hardware assist attributes */
#if NDIS_SUPPORT_NDIS61
typedef struct _NDIS_MINIPORT_ADAPTER_HARDWARE_ASSIST_ATTRIBUTES {
    NDIS_OBJECT_HEADER                  Header;
    PNDIS_HD_SPLIT_ATTRIBUTES           HDSplitAttributes;
#if NDIS_SUPPORT_NDIS620
    PNDIS_RECEIVE_FILTER_CAPABILITIES   HardwareReceiveFilterCapabilities;
    PNDIS_RECEIVE_FILTER_CAPABILITIES   CurrentReceiveFilterCapabilities;
    PNDIS_NIC_SWITCH_CAPABILITIES       HardwareNicSwitchCapabilities;
    PNDIS_NIC_SWITCH_CAPABILITIES       CurrentNicSwitchCapabilities;
#endif
} NDIS_MINIPORT_ADAPTER_HARDWARE_ASSIST_ATTRIBUTES;
typedef NDIS_MINIPORT_ADAPTER_HARDWARE_ASSIST_ATTRIBUTES    *PNDIS_MINIPORT_ADAPTER_HARDWARE_ASSIST_ATTRIBUTES;
#endif

/* NDIS miniport adapter offload attributes */
#if NDIS_SUPPORT_NDIS6
typedef struct _NDIS_MINIPORT_ADAPTER_OFFLOAD_ATTRIBUTES {
    NDIS_OBJECT_HEADER              Header;
    PNDIS_OFFLOAD                   DefaultOffloadConfiguration;
    PNDIS_OFFLOAD                   HardwareOffloadCapabilities;
    PNDIS_TCP_CONNECTION_OFFLOAD    DefaultTcpConnectionOffloadConfiguration;
    PNDIS_TCP_CONNECTION_OFFLOAD    TcpConnectionOffloadHardwareCapabilities;
} NDIS_MINIPORT_ADAPTER_OFFLOAD_ATTRIBUTES;
typedef NDIS_MINIPORT_ADAPTER_OFFLOAD_ATTRIBUTES    *PNDIS_MINIPORT_ADAPTER_OFFLOAD_ATTRIBUTES;
#endif

/* NDIS miniport adapter native 802.11 attributes */
#if NDIS_SUPPORT_NDIS6
typedef struct _NDIS_MINIPORT_ADAPTER_NATIVE_802_11_ATTRIBUTES {
    NDIS_OBJECT_HEADER          Header;
    ULONG                       OpModeCapability;
    ULONG                       NumOfTXBuffers;
    ULONG                       NumOfRXBuffers;
    BOOLEAN                     MultiDomainCapabilityImplemented;
    ULONG                       NumSupportedPhys;
    PDOT11_PHY_ATTRIBUTES       SupportedPhyAttributes;
    PDOT11_EXTSTA_ATTRIBUTES    ExtSTAAttributes;
#if NDIS_SUPPORT_NDIS620
    PDOT11_VWIFI_ATTRIBUTES     VWiFiAttributes;
    PDOT11_EXTAP_ATTRIBUTES     ExtAPAttributes;
#endif
} NDIS_MINIPORT_ADAPTER_NATIVE_802_11_ATTRIBUTES;
typedef NDIS_MINIPORT_ADAPTER_NATIVE_802_11_ATTRIBUTES  *PNDIS_MINIPORT_ADAPTER_NATIVE_802_11_ATTRIBUTES;
#endif

/* NDIS miniport adapter attributes */
#if NDIS_SUPPORT_NDIS6
typedef union _NDIS_MINIPORT_ADAPTER_ATTRIBUTES {
    NDIS_MINIPORT_ADD_DEVICE_REGISTRATION_ATTRIBUTES    AddDeviceRegistrationAttributes;
    NDIS_MINIPORT_ADAPTER_REGISTRATION_ATTRIBUTES       RegistrationAttributes;
    NDIS_MINIPORT_ADAPTER_GENERAL_ATTRIBUTES            GeneralAttributes;
    NDIS_MINIPORT_ADAPTER_OFFLOAD_ATTRIBUTES            OffloadAttributes;
    NDIS_MINIPORT_ADAPTER_NATIVE_802_11_ATTRIBUTES      Native_802_11_Attributes;
#if NDIS_SUPPORT_NDIS61
    NDIS_MINIPORT_ADAPTER_HARDWARE_ASSIST_ATTRIBUTES    HardwareAssistAttributes;
#endif
} NDIS_MINIPORT_ADAPTER_ATTRIBUTES;
typedef NDIS_MINIPORT_ADAPTER_ATTRIBUTES    *PNDIS_MINIPORT_ADAPTER_ATTRIBUTES;
#endif

/* NDIS halt actions */
#if NDIS_SUPPORT_NDIS6
typedef enum _NDIS_HALT_ACTION {
    NdisHaltDeviceDisabled              = 0,
    NdisHaltDeviceInstanceDeInitialized = 1,
    NdisHaltDevicePoweredDown           = 2,
    NdisHaltDeviceSurpriseRemoved       = 3,
    NdisHaltDeviceFailed                = 4,
    NdisHaltDeviceInitializationFailed  = 5,
    NdisHaltDeviceStopped               = 6
} NDIS_HALT_ACTION;
typedef NDIS_HALT_ACTION    *PNDIS_HALT_ACTION;
#endif

/* NDIS miniport pause parameters */
#if NDIS_SUPPORT_NDIS6
typedef struct _NDIS_MINIPORT_PAUSE_PARAMETERS {
    NDIS_OBJECT_HEADER  Header;
    ULONG               Flags;
    ULONG               PauseReason;
} NDIS_MINIPORT_PAUSE_PARAMETERS;
typedef NDIS_MINIPORT_PAUSE_PARAMETERS  *PNDIS_MINIPORT_PAUSE_PARAMETERS;
#endif

/* NDIS shutdown actions */
#if NDIS_SUPPORT_NDIS6
typedef enum _NDIS_SHUTDOWN_ACTION {
    NdisShutdownPowerOff    = 0,
    NdisShutdownBugCheck    = 1
} NDIS_SHUTDOWN_ACTION;
typedef NDIS_SHUTDOWN_ACTION    *PNDIS_SHUTDOWN_ACTION;
#endif

/* Network device Plug and Play event */
#if NDIS_SUPPORT_NDIS6
typedef struct _NET_DEVICE_PNP_EVENT {
    NDIS_OBJECT_HEADER      Header;
    NDIS_PORT_NUMBER        PortNumber;
    NDIS_DEVICE_PNP_EVENT   DevicePnPEvent;
    PVOID                   InformationBuffer;
    ULONG                   InformationBufferLength;
    UCHAR                   NdisReserved[2 * sizeof( PVOID )];
} NET_DEVICE_PNP_EVENT;
typedef NET_DEVICE_PNP_EVENT    *PNET_DEVICE_PNP_EVENT;
#endif

/* Miniport handlers */
#if NDIS_SUPPORT_NDIS6
typedef NDIS_STATUS (NTAPI MINIPORT_INITIALIZE)( NDIS_HANDLE, NDIS_HANDLE, PNDIS_MINIPORT_INIT_PARAMETERS );
typedef VOID (NTAPI MINIPORT_HALT)( NDIS_HANDLE, NDIS_HALT_ACTION );
typedef NDIS_STATUS (NTAPI MINIPORT_PAUSE)( NDIS_HANDLE, PNDIS_MINIPORT_PAUSE_PARAMETERS );
typedef NDIS_STATUS (NTAPI MINIPORT_RESTART)( NDIS_HANDLE, PNDIS_MINIPORT_RESTART_PARAMETERS );
typedef NDIS_STATUS (NTAPI MINIPORT_OID_REQUEST)( NDIS_HANDLE, PNDIS_OID_REQUEST );
typedef VOID (NTAPI MINIPORT_UNLOAD)( PDRIVER_OBJECT );
typedef VOID (NTAPI MINIPORT_SHUTDOWN)( NDIS_HANDLE, NDIS_SHUTDOWN_ACTION );
typedef VOID (NTAPI MINIPORT_DEVICE_PNP_EVENT_NOTIFY)( NDIS_HANDLE, PNET_DEVICE_PNP_EVENT );
typedef VOID (NTAPI MINIPORT_CANCEL_SEND)( NDIS_HANDLE, PVOID );
typedef BOOLEAN (NTAPI MINIPORT_CHECK_FOR_HANG)( NDIS_HANDLE );
typedef NDIS_STATUS (NTAPI MINIPORT_RESET)( NDIS_HANDLE, PBOOLEAN );
typedef VOID (NTAPI MINIPORT_CANCEL_OID_REQUEST)( NDIS_HANDLE, PVOID );
typedef VOID (NTAPI MINIPORT_SEND_NET_BUFFER_LISTS)( NDIS_HANDLE, PNET_BUFFER_LIST, NDIS_PORT_NUMBER, ULONG );
typedef VOID (NTAPI MINIPORT_RETURN_NET_BUFFER_LISTS)( NDIS_HANDLE, PNET_BUFFER_LIST, ULONG );
typedef MINIPORT_INITIALIZE                 *MINIPORT_INITIALIZE_HANDLER;
typedef MINIPORT_HALT                       *MINIPORT_HALT_HANDLER;
typedef MINIPORT_PAUSE                      *MINIPORT_PAUSE_HANDLER;
typedef MINIPORT_RESTART                    *MINIPORT_RESTART_HANDLER;
typedef MINIPORT_OID_REQUEST                *MINIPORT_OID_REQUEST_HANDLER;
typedef MINIPORT_UNLOAD                     *MINIPORT_DRIVER_UNLOAD;
typedef MINIPORT_SHUTDOWN                   *MINIPORT_SHUTDOWN_HANDLER;
typedef MINIPORT_DEVICE_PNP_EVENT_NOTIFY    *MINIPORT_DEVICE_PNP_EVENT_NOTIFY_HANDLER;
typedef MINIPORT_CANCEL_SEND                *MINIPORT_CANCEL_SEND_HANDLER;
typedef MINIPORT_CHECK_FOR_HANG             *MINIPORT_CHECK_FOR_HANG_HANDLER;
typedef MINIPORT_RESET                      *MINIPORT_RESET_HANDLER;
typedef MINIPORT_CANCEL_OID_REQUEST         *MINIPORT_CANCEL_OID_REQUEST_HANDLER;
typedef MINIPORT_SEND_NET_BUFFER_LISTS      *MINIPORT_SEND_NET_BUFFER_LISTS_HANDLER;
typedef MINIPORT_RETURN_NET_BUFFER_LISTS    *MINIPORT_RETURN_NET_BUFFER_LISTS_HANDLER;
#endif
#if NDIS_SUPPORT_NDIS61
typedef NDIS_STATUS (NTAPI MINIPORT_DIRECT_OID_REQUEST)( NDIS_HANDLE, PNDIS_OID_REQUEST );
typedef VOID (NTAPI MINIPORT_CANCEL_DIRECT_OID_REQUEST)( NDIS_HANDLE, PVOID );
typedef MINIPORT_DIRECT_OID_REQUEST         *MINIPORT_DIRECT_OID_REQUEST_HANDLER;
typedef MINIPORT_CANCEL_DIRECT_OID_REQUEST  *MINIPORT_CANCEL_DIRECT_OID_REQUEST_HANDLER;
#endif

/* NDIS miniport driver characteristics */
#if NDIS_SUPPORT_NDIS6
typedef struct _NDIS_MINIPORT_DRIVER_CHARACTERISTICS {
    NDIS_OBJECT_HEADER                          Header;
    UCHAR                                       MajorNdisVersion;
    UCHAR                                       MinorNdisVersion;
    UCHAR                                       MajorDriverVersion;
    UCHAR                                       MinorDriverVersion;
    ULONG                                       Flags;
    SET_OPTIONS_HANDLER                         SetOptionsHandler;
    MINIPORT_INITIALIZE_HANDLER                 InitializeHandlerEx;
    MINIPORT_HALT_HANDLER                       HaltHandlerEx;
    MINIPORT_DRIVER_UNLOAD                      UnloadHandler;
    MINIPORT_PAUSE_HANDLER                      PauseHandler;
    MINIPORT_RESTART_HANDLER                    RestartHandler;
    MINIPORT_OID_REQUEST_HANDLER                OidRequestHandler;
    MINIPORT_SEND_NET_BUFFER_LISTS_HANDLER      SendNetBufferListsHandler;
    MINIPORT_RETURN_NET_BUFFER_LISTS_HANDLER    ReturnNetBufferListsHandler;
    MINIPORT_CANCEL_SEND_HANDLER                CancelSendHandler;
    MINIPORT_CHECK_FOR_HANG_HANDLER             CheckForHangHandlerEx;
    MINIPORT_RESET_HANDLER                      ResetHandlerEx;
    MINIPORT_DEVICE_PNP_EVENT_NOTIFY_HANDLER    DevicePnPEventNotifyHandler;
    MINIPORT_SHUTDOWN_HANDLER                   ShutdownHandlerEx;
    MINIPORT_CANCEL_OID_REQUEST_HANDLER         CancelOidRequestHandler;
#if NDIS_SUPPORT_NDIS61
    MINIPORT_DIRECT_OID_REQUEST_HANDLER         DirectOidRequestHandler;
    MINIPORT_CANCEL_DIRECT_OID_REQUEST_HANDLER  CancelDirectOidRequestHandler;
#endif
} NDIS_MINIPORT_DRIVER_CHARACTERISTICS;
typedef NDIS_MINIPORT_DRIVER_CHARACTERISTICS    *PNDIS_MINIPORT_DRIVER_CHARACTERISTICS;
#endif

/* NDIS miniport CO characteristics */
#if NDIS_SUPPORT_NDIS6
typedef struct _NDIS_MINIPORT_CO_CHARACTERISTICS {
    NDIS_OBJECT_HEADER                  Header;
    ULONG                               Flags;
    W_CO_CREATE_VC_HANDLER              CoCreateVcHandler;
    W_CO_DELETE_VC_HANDLER              CoDeleteVcHandler;
    W_CO_ACTIVATE_VC_HANDLER            CoActivateVcHandler;
    W_CO_DEACTIVATE_VC_HANDLER          CoDeactivateVcHandler;
    W_CO_SEND_NET_BUFFER_LISTS_HANDLER  CoSendNetBufferListsHandler;
    W_CO_OID_REQUEST_HANDLER            CoOidRequestHandler;
} NDIS_MINIPORT_CO_CHARACTERISTICS;
typedef NDIS_MINIPORT_CO_CHARACTERISTICS    *PNDIS_MINIPORT_CO_CHARACTERISTICS;
#endif

/* FilterDBS */
typedef struct {
    union {
        PETH_FILTER     EthDB;
        PNULL_FILTER    NullDB;
    };
    PTR_FILTER  TrDB;
    PVOID       YYYDB;
    PVOID       XXXDB;
} FILTERDBS;
typedef FILTERDBS   *PFILTERDBS;

/* Filter packet indication handler */
#if NDIS_LEGACY_MINIPORT
typedef VOID (NTAPI *FILTER_PACKET_INDICATION_HANDLER)( NDIS_HANDLE, PPNDIS_PACKET, UINT );
#endif

/* NDIS miniport block */
#if !NDIS_WRAPPER && NDIS_LEGACY_MINIPORT
typedef struct _NDIS_MINIPORT_BLOCK {
    NDIS_OBJECT_HEADER                  Header;
    struct _NDIS_MINIPORT_BLOCK         *NextMiniport;
    struct _NDIS_MINIPORT_BLOCK         *BaseMiniport;
    NDIS_HANDLE                         MiniportAdapterContext;
    UNICODE_STRING                      Reserved4;
    PVOID                               Reserved10;
    NDIS_HANDLE                         OpenQueue;
    REFERENCE                           ShortRef;
    NDIS_HANDLE                         Reserved12;
    UCHAR                               Padding1;
    UCHAR                               LockAcquired;
    UCHAR                               PmodeOpens;
    UCHAR                               Reserved23;
    KSPIN_LOCK                          Lock;
    PNDIS_REQUEST                       MediaRequest;
    PVOID                               Interrupt;
    ULONG                               Flags;
    ULONG                               PnPFlags;
    LIST_ENTRY                          PacketList;
    PNDIS_PACKET                        FirstPendingPacket;
    PNDIS_PACKET                        ReturnPacketsQueue;
    ULONG                               RequestBuffer;
    PVOID                               SetMCastBuffer;
    struct _NDIS_MINIPORT_BLOCK         *PrimaryMiniport;
    PVOID                               Reserved11;
    PVOID                               BusDataContext;
    ULONG                               Reserved3;
    PCM_RESOURCE_LIST                   Resources;
    NDIS_TIMER                          WakeUpDpcTimer;
    UNICODE_STRING                      Reserved20;
    UNICODE_STRING                      SymbolicLinkName;
    ULONG                               CheckForHandSeconds;
    USHORT                              CFHangTicks;
    USHORT                              CFHangCurrentTick;
    NDIS_STATUS                         ResetStatus;
    NDIS_HANDLE                         ResetOpen;
#ifdef __cplusplus
    FILTERDBS                           FilterDbs;
#else
    FILTERDBS;
#endif
    FILTER_PACKET_INDICATION_HANDLER    PacketIndicateHandler;
    NDIS_M_SEND_COMPLETE_HANDLER        SendCompleteHandler;
    NDIS_M_SEND_RESOURCES_HANDLER       SendResourcesHandler;
    NDIS_M_RESET_COMPLETE_HANDLER       ResetCompleteHandler;
    NDIS_MEDIUM                         MediaType;
    ULONG                               BusNumber;
    NDIS_INTERFACE_TYPE                 BusType;
    NDIS_INTERFACE_TYPE                 AdapterType;
    PDEVICE_OBJECT                      Reserved6;
    PDEVICE_OBJECT                      Reserved7;
    PDEVICE_OBJECT                      Reserved8;
    PVOID                               MiniportSGDmaBlock;
    PNDIS_AF_LIST                       CallMgrAfList;
    PVOID                               MiniportThread;
    PVOID                               SetInfoBuf;
    USHORT                              SetInfoBufLen;
    USHORT                              MaxSendPackets;
    NDIS_STATUS                         FakeStatus;
    PVOID                               Reserved24;
    PUNICODE_STRING                     Reserved9;
    PVOID                               Reserved21;
    UINT                                MacOptions;
    PNDIS_REQUEST                       PendingRequest;
    UINT                                MaximumLongAddresses;
    UINT                                MaximumShortAddresses;
    UINT                                CurrentLookahead;
    UINT                                MaximumLookahead;
    ULONG_PTR                           Reserved1;
    W_DISABLE_INTERRUPT_HANDLER         DisableInterruptHandler;
    W_ENABLE_INTERRUPT_HANDLER          EnableInterruptHandler;
    W_SEND_PACKETS_HANDLER              SendPacketsHandler;
    NDIS_M_START_SENDS                  DeferredSendHandler;
    ETH_RCV_INDICATE_HANDLER            EthRxIndicateHandler;
    TR_RCV_INDICATE_HANDLER             TrRxIndicateHandler;
    PVOID                               Reserved2;
    ETH_RCV_COMPLETE_HANDLER            EthRxCompleteHandler;
    TR_RCV_COMPLETE_HANDLER             TrRxCompleteHandler;
    PVOID                               Reserved22;
    NDIS_M_STATUS_HANDLER               StatusHandler;
    NDIS_M_STS_COMPLETE_HANDLER         StatusCompleteHandler;
    NDIS_M_TD_COMPLETE_HANDLER          TDCompleteHandler;
    NDIS_M_REQ_COMPLETE_HANDLER         QueryCompleteHandler;
    NDIS_M_REQ_COMPLETE_HANDLER         SetCompleteHandler;
    NDIS_WM_SEND_COMPLETE_HANDLER       WanSendCompleteHandler;
    WAN_RCV_HANDLER                     WanRcvHandler;
    WAN_RCV_COMPLETE_HANDLER            WanRcvCompleteHandler;
} NDIS_MINIPORT_BLOCK;
#else
typedef struct _NDIS_MINIPORT_BLOCK NDIS_MINIPORT_BLOCK;
#endif
typedef NDIS_MINIPORT_BLOCK         *PNDIS_MINIPORT_BLOCK;

/* NDIS miniport characteristics */
#if NDIS_LEGACY_MINIPORT
#ifdef NDIS51_MINIPORT
typedef struct _NDIS51_MINIPORT_CHARACTERISTICS NDIS_MINIPORT_CHARACTERISTICS;
#else
#ifdef NDIS50_MINIPORT
typedef struct _NDIS50_MINIPORT_CHARACTERISTICS NDIS_MINIPORT_CHARACTERISTICS;
#else
#ifdef NDIS40_MINIPORT
typedef struct _NDIS40_MINIPORT_CHARACTERISTICS NDIS_MINIPORT_CHARACTERISTICS;
#else
typedef struct _NDIS30_MINIPORT_CHARACTERISTICS NDIS_MINIPORT_CHARACTERISTICS;
#endif
#endif
#endif
typedef NDIS_MINIPORT_CHARACTERISTICS           *PNDIS_MINIPORT_CHARACTERISTICS;
typedef NDIS_MINIPORT_CHARACTERISTICS           NDIS_WAN_MINIPORT_CHARACTERISTICS;
typedef NDIS_WAN_MINIPORT_CHARACTERISTICS       *PNDIS_WAN_MINIPORT_CHARACTERISTICS;
#endif

/* NDIS I/O work item routine */
#if NDIS_SUPPORT_NDIS6
typedef VOID (NTAPI NDIS_IO_WORKITEM_FUNCTION)( PVOID, NDIS_HANDLE );
typedef NDIS_IO_WORKITEM_FUNCTION   *NDIS_IO_WORKITEM_ROUTINE;
#endif

/* NDIS MSIX table configuration operations */
#if NDIS_SUPPORT_NDIS61
typedef enum _NDIS_MSIX_TABLE_CONFIG {
    NdisMSIXTableConfigSetTableEntry    = 0,
    NdisMSIXTableConfigMaskTableEntry   = 1,
    NdisMSIXTableConfigUnmaskTableEntry = 2,
    NdisMSIXTableConfigMax              = 3
} NDIS_MSIX_TABLE_OPERATION;
typedef NDIS_MSIX_TABLE_OPERATION   *PNDIS_MSIX_TABLE_OPERATION;
#endif

/* NDIS MSIX configuration parameters */
#if NDIS_SUPPORT_NDIS61
typedef struct _NDIS_MSIX_CONFIG_PARAMETERS {
    NDIS_OBJECT_HEADER          Header;
    NDIS_MSIX_TABLE_OPERATION   ConfigOperation;
    ULONG                       TableEntry;
    ULONG                       MessageNumber;
} NDIS_MSIX_CONFIG_PARAMETERS;
typedef NDIS_MSIX_CONFIG_PARAMETERS *PNDIS_MSIX_CONFIG_PARAMETERS;
#endif

/* Client handlers */
typedef VOID (NTAPI PROTOCOL_CL_OPEN_AF_COMPLETE)( NDIS_STATUS, NDIS_HANDLE, NDIS_HANDLE );
typedef VOID (NTAPI PROTOCOL_CL_CLOSE_AF_COMPLETE)( NDIS_STATUS, NDIS_HANDLE );
typedef VOID (NTAPI PROTOCOL_CL_REGISTER_SAP_COMPLETE)( NDIS_STATUS, NDIS_HANDLE, PCO_SAP, NDIS_HANDLE );
typedef VOID (NTAPI PROTOCOL_CL_DEREGISTER_SAP_COMPLETE)( NDIS_STATUS, NDIS_HANDLE );
typedef VOID (NTAPI PROTOCOL_CL_MAKE_CALL_COMPLETE)( NDIS_STATUS, NDIS_HANDLE, NDIS_HANDLE, PCO_CALL_PARAMETERS );
typedef VOID (NTAPI PROTOCOL_CL_CLOSE_CALL_COMPLETE)( NDIS_STATUS, NDIS_HANDLE, NDIS_HANDLE );
typedef VOID (NTAPI PROTOCOL_CL_ADD_PARTY_COMPLETE)( NDIS_STATUS, NDIS_HANDLE, NDIS_HANDLE, PCO_CALL_PARAMETERS );
typedef VOID (NTAPI PROTOCOL_CL_DROP_PARTY_COMPLETE)( NDIS_STATUS, NDIS_HANDLE );
typedef NDIS_STATUS (NTAPI PROTOCOL_CL_INCOMING_CALL)( NDIS_STATUS, NDIS_STATUS, PCO_CALL_PARAMETERS );
typedef VOID (NTAPI PROTOCOL_CL_CALL_CONNECTED)( NDIS_HANDLE );
typedef VOID (NTAPI PROTOCOL_CL_INCOMING_CLOSE_CALL)( NDIS_STATUS, NDIS_HANDLE, PVOID, UINT );
typedef VOID (NTAPI PROTOCOL_CL_INCOMING_DROP_PARTY)( NDIS_STATUS, NDIS_HANDLE, PVOID, UINT );
typedef VOID (NTAPI PROTOCOL_CL_MODIFY_CALL_QOS_COMPLETE)( NDIS_STATUS, NDIS_HANDLE, PCO_CALL_PARAMETERS );
typedef VOID (NTAPI PROTOCOL_CL_INCOMING_CALL_QOS_CHANGE)( NDIS_HANDLE, PCO_CALL_PARAMETERS );
typedef PROTOCOL_CL_OPEN_AF_COMPLETE            *CL_OPEN_AF_COMPLETE_HANDLER;
typedef PROTOCOL_CL_CLOSE_AF_COMPLETE           *CL_CLOSE_AF_COMPLETE_HANDLER;
typedef PROTOCOL_CL_REGISTER_SAP_COMPLETE       *CL_REG_SAP_COMPLETE_HANDLER;
typedef PROTOCOL_CL_DEREGISTER_SAP_COMPLETE     *CL_DEREG_SAP_COMPLETE_HANDLER;
typedef PROTOCOL_CL_MAKE_CALL_COMPLETE          *CL_MAKE_CALL_COMPLETE_HANDLER;
typedef PROTOCOL_CL_CLOSE_CALL_COMPLETE         *CL_CLOSE_CALL_COMPLETE_HANDLER;
typedef PROTOCOL_CL_ADD_PARTY_COMPLETE          *CL_ADD_PARTY_COMPLETE_HANDLER;
typedef PROTOCOL_CL_DROP_PARTY_COMPLETE         *CL_DROP_PARTY_COMPLETE_HANDLER;
typedef PROTOCOL_CL_INCOMING_CALL               *CL_INCOMING_CALL_HANDLER;
typedef PROTOCOL_CL_CALL_CONNECTED              *CL_CALL_CONNECTED_HANDLER;
typedef PROTOCOL_CL_INCOMING_CLOSE_CALL         *CL_INCOMING_CLOSE_CALL_HANDLER;
typedef PROTOCOL_CL_INCOMING_DROP_PARTY         *CL_INCOMING_DROP_PARTY_HANDLER;
typedef PROTOCOL_CL_MODIFY_CALL_QOS_COMPLETE    *CL_MODIFY_CALL_QOS_COMPLETE_HANDLER;
typedef PROTOCOL_CL_INCOMING_CALL_QOS_CHANGE    *CL_INCOMING_CALL_QOS_CHANGE_HANDLER;

/* NDIS client characteristics */
#if NDIS_LEGACY_PROTOCOL
typedef struct _NDIS_CLIENT_CHARACTERISTICS {
    UCHAR                               MajorVersion;
    UCHAR                               MinorVersion;
    USHORT                              Filler;
    UINT                                Reserved;
    CO_CREATE_VC_HANDLER                ClCreateVcHandler;
    CO_DELETE_VC_HANDLER                ClDeleteVcHandler;
    CO_REQUEST_HANDLER                  ClRequestHandler;
    CO_REQUEST_COMPLETE_HANDLER         ClRequestCompleteHandler;
    CL_OPEN_AF_COMPLETE_HANDLER         ClOpenAfCompleteHandler;
    CL_CLOSE_AF_COMPLETE_HANDLER        ClCloseAfCompleteHandler;
    CL_REG_SAP_COMPLETE_HANDLER         ClRegisterSapCompleteHandler;
    CL_DEREG_SAP_COMPLETE_HANDLER       ClDeregisterSapCompleteHandler;
    CL_MAKE_CALL_COMPLETE_HANDLER       ClMakeCallCompleteHandler;
    CL_MODIFY_CALL_QOS_COMPLETE_HANDLER ClModifyCallQoSCompleteHandler;
    CL_CLOSE_CALL_COMPLETE_HANDLER      ClCloseCallCompleteHandler;
    CL_ADD_PARTY_COMPLETE_HANDLER       ClAddPartyCompleteHandler;
    CL_DROP_PARTY_COMPLETE_HANDLER      ClDropPartyCompleteHandler;
    CL_INCOMING_CALL_HANDLER            ClIncomingCallHandler;
    CL_INCOMING_CALL_QOS_CHANGE_HANDLER ClIncomingCallQoSChangeHandler;
    CL_INCOMING_CLOSE_CALL_HANDLER      ClIncomingCloseCallHandler;
    CL_INCOMING_DROP_PARTY_HANDLER      ClIncomingDropPartyHandler;
    CL_CALL_CONNECTED_HANDLER           ClCallConnectedHandler;
} NDIS_CLIENT_CHARACTERISTICS;
typedef NDIS_CLIENT_CHARACTERISTICS *PNDIS_CLIENT_CHARACTERISTICS;
#endif

/* Call manager handlers */
typedef NDIS_STATUS (NTAPI PROTOCOL_CM_OPEN_AF)( NDIS_HANDLE, PCO_ADDRESS_FAMILY, NDIS_HANDLE, PNDIS_HANDLE );
typedef NDIS_STATUS (NTAPI PROTOCOL_CM_CLOSE_AF)( NDIS_HANDLE );
typedef NDIS_STATUS (NTAPI PROTOCOL_CM_REG_SAP)( NDIS_HANDLE, PCO_SAP, NDIS_HANDLE, PNDIS_HANDLE );
typedef NDIS_STATUS (NTAPI PROTOCOL_CM_DEREGISTER_SAP)( NDIS_HANDLE );
typedef NDIS_STATUS (NTAPI PROTOCOL_CM_MAKE_CALL)( NDIS_HANDLE, PCO_CALL_PARAMETERS, NDIS_HANDLE, PNDIS_HANDLE );
typedef NDIS_STATUS (NTAPI PROTOCOL_CM_CLOSE_CALL)( NDIS_HANDLE, NDIS_HANDLE, PVOID, UINT );
typedef NDIS_STATUS (NTAPI PROTOCOL_CM_MODIFY_QOS_CALL)( NDIS_HANDLE, PCO_CALL_PARAMETERS );
typedef VOID (NTAPI PROTOCOL_CM_INCOMING_CALL_COMPLETE)( NDIS_STATUS, NDIS_HANDLE, PCO_CALL_PARAMETERS );
typedef VOID (NTAPI PROTOCOL_CM_ACTIVATE_VC_COMPLETE)( NDIS_STATUS, NDIS_HANDLE, PCO_CALL_PARAMETERS );
typedef VOID (NTAPI PROTOCOL_CM_DEACTIVATE_VC_COMPLETE)( NDIS_STATUS, NDIS_HANDLE );
typedef NDIS_STATUS (NTAPI PROTOCOL_CM_ADD_PARTY)( NDIS_HANDLE, PCO_CALL_PARAMETERS, NDIS_HANDLE, PNDIS_HANDLE );
typedef NDIS_STATUS (NTAPI PROTOCOL_CM_DROP_PARTY)( NDIS_HANDLE, PVOID, UINT );
typedef PROTOCOL_CM_OPEN_AF                 *CM_OPEN_AF_HANDLER;
typedef PROTOCOL_CM_CLOSE_AF                *CM_CLOSE_AF_HANDLER;
typedef PROTOCOL_CM_REG_SAP                 *CM_REG_SAP_HANDLER;
typedef PROTOCOL_CM_DEREGISTER_SAP          *CM_DEREG_SAP_HANDLER;
typedef PROTOCOL_CM_MAKE_CALL               *CM_MAKE_CALL_HANDLER;
typedef PROTOCOL_CM_CLOSE_CALL              *CM_CLOSE_CALL_HANDLER;
typedef PROTOCOL_CM_MODIFY_QOS_CALL         *CM_MODIFY_CALL_QOS_HANDLER;
typedef PROTOCOL_CM_INCOMING_CALL_COMPLETE  *CM_INCOMING_CALL_COMPLETE_HANDLER;
typedef PROTOCOL_CM_ACTIVATE_VC_COMPLETE    *CM_ACTIVATE_VC_COMPLETE_HANDLER;
typedef PROTOCOL_CM_DEACTIVATE_VC_COMPLETE  *CM_DEACTIVATE_VC_COMPLETE_HANDLER;
typedef PROTOCOL_CM_ADD_PARTY               *CM_ADD_PARTY_HANDLER;
typedef PROTOCOL_CM_DROP_PARTY              *CM_DROP_PARTY_HANDLER;

/* NDIS call manager characteristics */
#if NDIS_LEGACY_DRIVER
typedef struct _NDIS_CALL_MANAGER_CHARACTERISTICS {
    UCHAR                               MajorVersion;
    UCHAR                               MinorVersion;
    USHORT                              Filler;
    UINT                                Reserved;
    CO_CREATE_VC_HANDLER                CmCreateVcHandler;
    CO_DELETE_VC_HANDLER                CmDeleteVcHandler;
    CM_OPEN_AF_HANDLER                  CmOpenAfHandler;
    CM_CLOSE_AF_HANDLER                 CmCloseAfHandler;
    CM_REG_SAP_HANDLER                  CmRegisterSapHandler;
    CM_DEREG_SAP_HANDLER                CmDeregisterSapHandler;
    CM_MAKE_CALL_HANDLER                CmMakeCallHandler;
    CM_CLOSE_CALL_HANDLER               CmCloseCallHandler;
    CM_INCOMING_CALL_COMPLETE_HANDLER   CmIncomingCallCompleteHandler;
    CM_ADD_PARTY_HANDLER                CmAddPartyHandler;
    CM_DROP_PARTY_HANDLER               CmDropPartyHandler;
    CM_ACTIVATE_VC_COMPLETE_HANDLER     CmActivateVcCompleteHandler;
    CM_DEACTIVATE_VC_COMPLETE_HANDLER   CmDeactivateVcCompleteHandler;
    CM_MODIFY_CALL_QOS_HANDLER          CmModifyCallQoSHandler;
    CO_REQUEST_HANDLER                  CmRequestHandler;
    CO_REQUEST_COMPLETE_HANDLER         CmRequestCompleteHandler;
} NDIS_CALL_MANAGER_CHARACTERISTICS;
typedef NDIS_CALL_MANAGER_CHARACTERISTICS   *PNDIS_CALL_MANAGER_CHARACTERISTICS;
#endif

/* CO address */
typedef struct _CO_ADDRESS {
    ULONG   AddressSize;
    UCHAR   Address[1];
} CO_ADDRESS;
typedef CO_ADDRESS  *PCO_ADDRESS;

/* CO address list */
typedef struct _CO_ADDRESS_LIST {
    ULONG       NumberOfAddressesAvailable;
    ULONG       NumberOfAddresses;
    CO_ADDRESS  AddressList;
} CO_ADDRESS_LIST;
typedef CO_ADDRESS_LIST *PCO_ADDRESS_LIST;

/* CO specific parameters */
typedef struct _CO_SPECIFIC_PARAMETERS {
    ULONG   ParamType;
    ULONG   Length;
    UCHAR   Parameters[1];
} CO_SPECIFIC_PARAMETERS;
typedef CO_SPECIFIC_PARAMETERS  *PCO_SPECIFIC_PARAMETERS;

/* CO call manager parameters */
typedef struct _CO_CALL_MANAGER_PARAMETERS {
    FLOWSPEC                Transmit;
    FLOWSPEC                Receive;
    CO_SPECIFIC_PARAMETERS  CallMgrSpecific;
} CO_CALL_MANAGER_PARAMETERS;
typedef CO_CALL_MANAGER_PARAMETERS  *PCO_CALL_MANAGER_PARAMETERS;

/* CO media parameters */
typedef struct _CO_MEDIA_PARAMETERS {
    ULONG                   Flags;
    ULONG                   ReceivePriority;
    ULONG                   ReceiveSizeHint;
    CO_SPECIFIC_PARAMETERS  MediaSpecific;
} CO_MEDIA_PARAMETERS;
typedef CO_MEDIA_PARAMETERS *PCO_MEDIA_PARAMETERS;

/* CO call parameters */
typedef struct _CO_CALL_PARAMETERS {
    ULONG                       Flags;
    PCO_CALL_MANAGER_PARAMETERS CallMgrParameters;
    PCO_MEDIA_PARAMETERS        MediaParameters;
} CO_CALL_PARAMETERS;
typedef CO_CALL_PARAMETERS  *PCO_CALL_PARAMETERS;

/* CO PVC */
typedef struct _CO_PVC {
    NDIS_HANDLE             NdisAfHandle;
    CO_SPECIFIC_PARAMETERS  PvcParameters;
} CO_PVC;
typedef CO_PVC  *PCO_PVC;

/* Variable string */
#ifndef __NDISTAPI_VAR_STRING_DECLARED
#define __NDISTAPI_VAR_STRING_DECLARED
typedef struct _VAR_STRING {
    ULONG   ulTotalSize;
    ULONG   ulNeededSize;
    ULONG   ulUsedSize;
    ULONG   ulStringFormat;
    ULONG   ulStringSize;
    ULONG   ulStringOffset;
} VAR_STRING;
typedef VAR_STRING  *PVAR_STRING;
#endif

/* NDIS CO client optional handlers */
#if NDIS_SUPPORT_NDIS6
typedef struct _NDIS_CO_CLIENT_OPTIONAL_HANDLERS {
    NDIS_OBJECT_HEADER                  Header;
    ULONG                               Reserved;
    CO_CREATE_VC_HANDLER                ClCreateVcHandler;
    CO_DELETE_VC_HANDLER                ClDeleteVcHandler;
    CO_OID_REQUEST_HANDLER              ClOidRequestHandler;
    CO_OID_REQUEST_COMPLETE_HANDLER     ClOidRequestCompleteHandler;
    CL_OPEN_AF_COMPLETE_HANDLER_EX      ClOpenAfCompleteHandlerEx;
    CL_CLOSE_AF_COMPLETE_HANDLER        ClCloseAfCompleteHandler;
    CL_REG_SAP_COMPLETE_HANDLER         ClRegisterSapCompleteHandler;
    CL_DEREG_SAP_COMPLETE_HANDLER       ClDeregisterSapCompleteHandler;
    CL_MAKE_CALL_COMPLETE_HANDLER       ClMakeCallCompleteHandler;
    CL_MODIFY_CALL_QOS_COMPLETE_HANDLER ClModifyCallQoSCompleteHandler;
    CL_CLOSE_CALL_COMPLETE_HANDLER      ClCloseCallCompleteHandler;
    CL_ADD_PARTY_COMPLETE_HANDLER       ClAddPartyCompleteHandler;
    CL_DROP_PARTY_COMPLETE_HANDLER      ClDropPartyCompleteHandler;
    CL_INCOMING_CALL_HANDLER            ClIncomingCallHandler;
    CL_INCOMING_CALL_QOS_CHANGE_HANDLER ClIncomingCallQoSChangeHandler;
    CL_INCOMING_CLOSE_CALL_HANDLER      ClIncomingCloseCallHandler;
    CL_INCOMING_DROP_PARTY_HANDLER      ClIncomingDropPartyHandler;
    CL_CALL_CONNECTED_HANDLER           ClCallConnectedHandler;
    CL_NOTIFY_CLOSE_AF_HANDLER          ClNotifyCloseAfHandler;
} NDIS_CO_CLIENT_OPTIONAL_HANDLERS;
typedef NDIS_CO_CLIENT_OPTIONAL_HANDLERS    *PNDIS_CO_CLIENT_OPTIONAL_HANDLERS;
#endif

/* NDIS CO call manager optional handlers */
#if NDIS_SUPPORT_NDIS6
typedef struct _NDIS_CO_CALL_MANAGER_OPTIONAL_HANDLERS {
    NDIS_OBJECT_HEADER                  Header;
    ULONG                               Reserved;
    CO_CREATE_VC_HANDLER                CmCreateVcHandler;
    CO_DELETE_VC_HANDLER                CmDeleteVcHandler;
    CM_OPEN_AF_HANDLER                  CmOpenAfHandler;
    CM_CLOSE_AF_HANDLER                 CmCloseAfHandler;
    CM_REG_SAP_HANDLER                  CmRegisterSapHandler;
    CM_DEREG_SAP_HANDLER                CmDeregisterSapHandler;
    CM_MAKE_CALL_HANDLER                CmMakeCallHandler;
    CM_CLOSE_CALL_HANDLER               CmCloseCallHandler;
    CM_INCOMING_CALL_COMPLETE_HANDLER   CmIncomingCallCompleteHandler;
    CM_ADD_PARTY_HANDLER                CmAddPartyHandler;
    CM_DROP_PARTY_HANDLER               CmDropPartyHandler;
    CM_ACTIVATE_VC_COMPLETE_HANDLER     CmActivateVcCompleteHandler;
    CM_DEACTIVATE_VC_COMPLETE_HANDLER   CmDeactivateVcCompleteHandler;
    CM_MODIFY_CALL_QOS_HANDLER          CmModifyCallQoSHandler;
    CO_OID_REQUEST_HANDLER              CmOidRequestHandler;
    CO_OID_REQUEST_COMPLETE_HANDLER     CmOidRequestCompleteHandler;
    CM_NOTIFY_CLOSE_AF_COMPLETE_HANDLER CmNotifyCloseAfCompleteHandler;
} NDIS_CO_CALL_MANAGER_OPTIONAL_HANDLERS;
typedef NDIS_CO_CALL_MANAGER_OPTIONAL_HANDLERS  *PNDIS_CO_CALL_MANAGER_OPTIONAL_HANDLERS;
#endif

/* NDIS filter attach parameters */
#if NDIS_SUPPORT_NDIS6
typedef struct _NDIS_FILTER_ATTACH_PARAMETERS {
    NDIS_OBJECT_HEADER                  Header;
    NET_IFINDEX                         IfIndex;
    NET_LUID                            NetLuid;
    PNDIS_STRING                        FilterModuleGuidName;
    NET_IFINDEX                         BaseMiniportIfIndex;
    PNDIS_STRING                        BaseMiniportInstanceName;
    PNDIS_STRING                        BaseMiniportName;
    NDIS_MEDIA_CONNECT_STATE            MediaConnectState;
    NET_IF_MEDIA_DUPLEX_STATE           MediaDuplexState;
    ULONG64                             XmitLinkSpeed;
    ULONG64                             RcvLinkSpeed;
    NDIS_MEDIUM                         MiniportMediumType;
    NDIS_PHYSICAL_MEDIUM                MiniportPhysicalMediaType;
    NDIS_HANDLE                         MiniportMediaSpecificAttributes;
    PNDIS_OFFLOAD                       DefaultOffloadConfiguration;
    USHORT                              MacAddressLength;
    UCHAR                               CurrentMacAddress[NDIS_MAX_PHYS_ADDRESS_LENGTH];
    NET_LUID                            BaseMiniportNetLuid;
    NET_IFINDEX                         LowerIfIndex;
    NET_LUID                            LowerIfNetLuid;
    ULONG                               Flags;
#if NDIS_SUPPORT_NDIS61
    PNDIS_HD_SPLIT_CURRENT_CONFIG       HDSplitCurrentConfig;
#endif
#if NDIS_SUPPORT_NDIS620
    PNDIS_RECEIVE_FILTER_CAPABILITIES   ReceiveFilterCapabilities;
    PDEVICE_OBJECT                      MiniportPhysicalDeviceObject;
    PNDIS_NIC_SWITCH_CAPABILITIES       NicSwitchCapabilities;
#endif
} NDIS_FILTER_ATTACH_PARAMETERS;
typedef NDIS_FILTER_ATTACH_PARAMETERS   *PNDIS_FILTER_ATTACH_PARAMETERS;
#endif

/* NDIS filter restart parameters */
#if NDIS_SUPPORT_NDIS6
typedef struct _NDIS_FILTER_RESTART_PARAMETERS {
    NDIS_OBJECT_HEADER          Header;
    NDIS_MEDIUM                 MiniportMediaType;
    NDIS_PHYSICAL_MEDIUM        MiniportPhysicalMediaType;
    PNDIS_RESTART_ATTRIBUTES    RestartAttributes;
    NET_IFINDEX                 LowerIfIndex;
    NET_LUID                    LowerIfNetLuid;
    ULONG                       Flags;
} NDIS_FILTER_RESTART_PARAMETERS;
typedef NDIS_FILTER_RESTART_PARAMETERS  *PNDIS_FILTER_RESTART_PARAMETERS;
#endif

/* NDIS filter pause parameters */
#if NDIS_SUPPORT_NDIS6
typedef struct _NDIS_FILTER_PAUSE_PARAMETERS {
    NDIS_OBJECT_HEADER  Header;
    ULONG               Flags;
    ULONG               PauseReason;
} NDIS_FILTER_PAUSE_PARAMETERS;
typedef NDIS_FILTER_PAUSE_PARAMETERS    *PNDIS_FILTER_PAUSE_PARAMETERS;
#endif

/* Filter handlers */
#if NDIS_SUPPORT_NDIS6
typedef NDIS_STATUS (NTAPI FILTER_ATTACH)( NDIS_HANDLE, NDIS_HANDLE, PNDIS_FILTER_ATTACH_PARAMETERS );
typedef VOID (NTAPI FILTER_DETACH)( NDIS_HANDLE );
typedef NDIS_STATUS (NTAPI FILTER_SET_FILTER_MODULE_OPTIONS)( NDIS_HANDLE );
typedef NDIS_STATUS (NTAPI FILTER_RESTART)( NDIS_HANDLE, PNDIS_FILTER_RESTART_PARAMETERS );
typedef NDIS_STATUS (NTAPI FILTER_PAUSE)( NDIS_HANDLE, PNDIS_FILTER_PAUSE_PARAMETERS );
typedef NDIS_STATUS (NTAPI FILTER_OID_REQUEST)( NDIS_HANDLE, PNDIS_OID_REQUEST );
typedef VOID (NTAPI FILTER_CANCEL_OID_REQUEST)( NDIS_HANDLE, PVOID );
typedef VOID (NTAPI FILTER_SEND_NET_BUFFER_LISTS)( NDIS_HANDLE, PNET_BUFFER_LIST, NDIS_PORT_NUMBER, ULONG );
typedef VOID (NTAPI FILTER_CANCEL_SEND_NET_BUFFER_LISTS)( NDIS_HANDLE, PVOID );
typedef VOID (NTAPI FILTER_RETURN_NET_BUFFER_LISTS)( NDIS_HANDLE, PNET_BUFFER_LIST, ULONG );
typedef VOID (NTAPI FILTER_SEND_NET_BUFFER_LISTS_COMPLETE)( NDIS_HANDLE, PNET_BUFFER_LIST, ULONG );
typedef VOID (NTAPI FILTER_RECEIVE_NET_BUFFER_LISTS)( NDIS_HANDLE, PNET_BUFFER_LIST, NDIS_PORT_NUMBER, ULONG, ULONG );
typedef VOID (NTAPI FILTER_DEVICE_PNP_EVENT_NOTIFY)( NDIS_HANDLE, PNET_DEVICE_PNP_EVENT );
typedef NDIS_STATUS (NTAPI FILTER_NET_PNP_EVENT)( NDIS_HANDLE, PNET_PNP_EVENT_NOTIFICATION );
typedef VOID (NTAPI FILTER_STATUS)( NDIS_HANDLE, PNDIS_STATUS_INDICATION );
typedef VOID (NTAPI FILTER_OID_REQUEST_COMPLETE)( NDIS_HANDLE, PNDIS_OID_REQUEST, NDIS_STATUS );
typedef FILTER_ATTACH                       *FILTER_ATTACH_HANDLER;
typedef FILTER_DETACH                       *FILTER_DETACH_HANDLER;
typedef FILTER_SET_FILTER_MODULE_OPTIONS    *FILTER_SET_FILTER_MODULE_OPTIONS_HANDLER;
typedef FILTER_RESTART                      *FILTER_RESTART_HANDLER;
typedef FILTER_PAUSE                        *FILTER_PAUSE_HANDLER;
typedef FILTER_OID_REQUEST                  *FILTER_OID_REQUEST_HANDLER;
typedef FILTER_CANCEL_OID_REQUEST           *FILTER_CANCEL_OID_REQUEST_HANDLER;
typedef FILTER_SEND_NET_BUFFER_LISTS        *FILTER_SEND_NET_BUFFER_LISTS_HANDLER;
typedef FILTER_CANCEL_SEND_NET_BUFFER_LISTS *FILTER_CANCEL_SEND_HANDLER;
typedef FILTER_RETURN_NET_BUFFER_LISTS      *FILTER_RETURN_NET_BUFFER_LISTS_HANDLER;
typedef FILTER_SEND_NET_BUFFER_LISTS_COMPLETE   *FILTER_SEND_NET_BUFFER_LISTS_COMPLETE_HANDLER;
typedef FILTER_RECEIVE_NET_BUFFER_LISTS     *FILTER_RECEIVE_NET_BUFFER_LISTS_HANDLER;
typedef FILTER_DEVICE_PNP_EVENT_NOTIFY      *FILTER_DEVICE_PNP_EVENT_NOTIFY_HANDLER;
typedef FILTER_NET_PNP_EVENT                *FILTER_NET_PNP_EVENT_HANDLER;
typedef FILTER_STATUS                       *FILTER_STATUS_HANDLER;
typedef FILTER_OID_REQUEST_COMPLETE         *FILTER_OID_REQUEST_COMPLETE_HANDLER;
#endif
#if NDIS_SUPPORT_NDIS61
typedef NDIS_STATUS (NTAPI FILTER_DIRECT_OID_REQUEST)( NDIS_HANDLE, PNDIS_OID_REQUEST );
typedef VOID (NTAPI FILTER_DIRECT_OID_REQUEST_COMPLETE)( NDIS_HANDLE, PNDIS_OID_REQUEST, NDIS_STATUS );
typedef VOID (NTAPI FILTER_CANCEL_DIRECT_OID_REQUEST)( NDIS_HANDLE, PVOID );
typedef FILTER_DIRECT_OID_REQUEST           *FILTER_DIRECT_OID_REQUEST_HANDLER;
typedef FILTER_DIRECT_OID_REQUEST_COMPLETE  *FILTER_DIRECT_OID_REQUEST_COMPLETE_HANDLER;
typedef FILTER_CANCEL_DIRECT_OID_REQUEST    *FILTER_CANCEL_DIRECT_OID_REQUEST_HANDLER;
#endif

/* NDIS filter partial characteristics */
#if NDIS_SUPPORT_NDIS6
typedef struct _NDIS_FILTER_PARTIAL_CHARACTERISTICS {
    NDIS_OBJECT_HEADER                              Header;
    ULONG                                           Flags;
    FILTER_SEND_NET_BUFFER_LISTS_HANDLER            SendNetBufferListsHandler;
    FILTER_SEND_NET_BUFFER_LISTS_COMPLETE_HANDLER   SendNetBufferListsCompleteHandler;
    FILTER_CANCEL_SEND_HANDLER                      CancelSendNetBufferListsHandler;
    FILTER_RECEIVE_NET_BUFFER_LISTS_HANDLER         ReceiveNetBufferListsHandler;
    FILTER_RETURN_NET_BUFFER_LISTS_HANDLER          ReturnNetBufferListsHandler;
} NDIS_FILTER_PARTIAL_CHARACTERISTICS;
typedef NDIS_FILTER_PARTIAL_CHARACTERISTICS *PNDIS_FILTER_PARTIAL_CHARACTERISTICS;
#endif

/* NDIS filter driver characteristics */
#if NDIS_SUPPORT_NDIS6
typedef struct _NDIS_FILTER_DRIVER_CHARACTERISTICS {
    NDIS_OBJECT_HEADER                              Header;
    UCHAR                                           MajorNdisVersion;
    UCHAR                                           MinorNdisVersion;
    UCHAR                                           MajorDriverVersion;
    UCHAR                                           MinorDriverVersion;
    ULONG                                           Flags;
    NDIS_STRING                                     FriendlyName;
    NDIS_STRING                                     UniqueName;
    NDIS_STRING                                     ServiceName;
    SET_OPTIONS_HANDLER                             SetOptionsHandler;
    FILTER_SET_FILTER_MODULE_OPTIONS_HANDLER        SetFilterModuleOptionsHandler;
    FILTER_ATTACH_HANDLER                           AttachHandler;
    FILTER_DETACH_HANDLER                           DetachHandler;
    FILTER_RESTART_HANDLER                          RestartHandler;
    FILTER_PAUSE_HANDLER                            PauseHandler;
    FILTER_SEND_NET_BUFFER_LISTS_HANDLER            SendNetBufferListsHandler;
    FILTER_SEND_NET_BUFFER_LISTS_COMPLETE_HANDLER   SendNetBufferListsCompleteHandler;
    FILTER_CANCEL_SEND_HANDLER                      CancelSendNetBufferListsHandler;
    FILTER_RECEIVE_NET_BUFFER_LISTS_HANDLER         ReceiveNetBufferListsHandler;
    FILTER_RETURN_NET_BUFFER_LISTS_HANDLER          ReturnNetBufferListsHandler;
    FILTER_OID_REQUEST_HANDLER                      OidRequestHandler;
    FILTER_OID_REQUEST_COMPLETE_HANDLER             OidRequestCompleteHandler;
    FILTER_CANCEL_OID_REQUEST_HANDLER               CancelOidRequestHandler;
    FILTER_DEVICE_PNP_EVENT_NOTIFY_HANDLER          DevicePnPEventNotifyHandler;
    FILTER_NET_PNP_EVENT_HANDLER                    NetPnPEventHandler;
    FILTER_STATUS_HANDLER                           StatusHandler;
#if NDIS_SUPPORT_NDIS61
    FILTER_DIRECT_OID_REQUEST_HANDLER               DirectOidRequestHandler;
    FILTER_DIRECT_OID_REQUEST_COMPLETE_HANDLER      DirectOidRequestCompleteHandler;
    FILTER_CANCEL_DIRECT_OID_REQUEST_HANDLER        CancelDirectOidRequestHandler;
#endif
} NDIS_FILTER_DRIVER_CHARACTERISTICS;
typedef NDIS_FILTER_DRIVER_CHARACTERISTICS  *PNDIS_FILTER_DRIVER_CHARACTERISTICS;
#endif

/* NDIS filter attributes */
#if NDIS_SUPPORT_NDIS6
typedef struct _NDIS_FILTER_ATTRIBUTES {
    NDIS_OBJECT_HEADER  Header;
    ULONG               Flags;
} NDIS_FILTER_ATTRIBUTES;
typedef NDIS_FILTER_ATTRIBUTES  *PNDIS_FILTER_ATTRIBUTES;
#endif

/* IF provider callbacks */
#if NDIS_SUPPORT_NDIS6 || NDIS60
typedef NDIS_STATUS (NTAPI *IFP_QUERY_OBJECT)( NDIS_HANDLE, NET_IF_OBJECT_ID, PULONG, PVOID );
typedef NDIS_STATUS (NTAPI *IFP_SET_OBJECT)( NDIS_HANDLE, NET_IF_OBJECT_ID, ULONG, PVOID );
#endif

/* NDIS IF provider characteristics */
#if NDIS_SUPPORT_NDIS6 || NDIS60
typedef struct _NDIS_IF_PROVIDER_CHARACTERISTICS {
    NDIS_OBJECT_HEADER  Header;
    IFP_QUERY_OBJECT    QueryObjectHandler;
    IFP_SET_OBJECT      SetObjectHandler;
    PVOID               Reserved1;
    PVOID               Reserved2;
} NDIS_IF_PROVIDER_CHARACTERISTICS;
typedef NDIS_IF_PROVIDER_CHARACTERISTICS    *PNDIS_IF_PROVIDER_CHARACTERISTICS;
#endif

/* Network IF information */
#if NDIS_SUPPORT_NDIS6 || NDIS60
typedef struct _NET_IF_INFORMATION {
    NDIS_OBJECT_HEADER      Header;
    ULONG                   Flags;
    NET_PHYSICAL_LOCATION   PhysicalLocation;
    ULONG                   WanTunnelType;
    ULONG                   PortNumber;
    NET_IF_ACCESS_TYPE      AccessType;
    NET_IF_DIRECTION_TYPE   DirectionType;
    NET_IF_CONNECTION_TYPE  ConnectionType;
    BOOLEAN                 ifConnectorPresent;
    USHORT                  PhysAddressLength;
    USHORT                  PhysAddressOffset;
    USHORT                  PermanentPhysAddressOffset;
    USHORT                  FriendlyNameLength;
    USHORT                  FriendlyNameOffset;
    GUID                    InterfaceGuid;
    NET_IF_NETWORK_GUID     NetworkGuid;
    ULONG                   SupportedStatistics;
    NDIS_MEDIUM             MediaType;
    NDIS_PHYSICAL_MEDIUM    PhysicalMediumType;
} NET_IF_INFORMATION;
typedef NET_IF_INFORMATION  *PNET_IF_INFORMATION;
#endif

/* Functions in NDIS.SYS */
EXPORT NDIS_STATUS NTAPI    NdisAllocateMemoryWithTag( PVOID *, UINT, ULONG );
EXPORT VOID NTAPI           NdisCancelTimer( PNDIS_TIMER, PBOOLEAN );
EXPORT NDIS_STATUS NTAPI    NdisClAddParty( NDIS_HANDLE, NDIS_HANDLE, PCO_CALL_PARAMETERS, PNDIS_HANDLE );
EXPORT NDIS_STATUS NTAPI    NdisClCloseAddressFamily( NDIS_HANDLE );
EXPORT NDIS_STATUS NTAPI    NdisClCloseCall( NDIS_HANDLE, NDIS_HANDLE, PVOID, UINT );
EXPORT NDIS_STATUS NTAPI    NdisClDeregisterSap( NDIS_HANDLE );
EXPORT NDIS_STATUS NTAPI    NdisClDropParty( NDIS_HANDLE, PVOID, UINT );
EXPORT NDIS_STATUS NTAPI    NdisClGetProtocolVcContextFromTapiCallId( UNICODE_STRING, PNDIS_HANDLE );
EXPORT VOID NTAPI           NdisClIncomingCallComplete( NDIS_STATUS, NDIS_HANDLE, PCO_CALL_PARAMETERS );
EXPORT NDIS_STATUS NTAPI    NdisClMakeCall( NDIS_HANDLE, PCO_CALL_PARAMETERS, NDIS_HANDLE, PNDIS_HANDLE );
EXPORT NDIS_STATUS NTAPI    NdisClModifyCallQoS( NDIS_HANDLE, PCO_CALL_PARAMETERS );
EXPORT NDIS_STATUS NTAPI    NdisClRegisterSap( NDIS_HANDLE, NDIS_HANDLE, PCO_SAP, PNDIS_HANDLE );
EXPORT VOID NTAPI           NdisCloseConfiguration( NDIS_HANDLE );
EXPORT VOID NTAPI           NdisCloseFile( PNDIS_HANDLE );
EXPORT NDIS_STATUS NTAPI    NdisCmActivateVc( NDIS_HANDLE, PCO_CALL_PARAMETERS );
EXPORT VOID NTAPI           NdisCmAddPartyComplete( NDIS_STATUS, NDIS_HANDLE, NDIS_HANDLE, PCO_CALL_PARAMETERS );
EXPORT VOID NTAPI           NdisCmCloseAddressFamilyComplete( NDIS_STATUS, NDIS_HANDLE );
EXPORT VOID NTAPI           NdisCmCloseCallComplete( NDIS_STATUS, NDIS_HANDLE, NDIS_HANDLE );
EXPORT NDIS_STATUS NTAPI    NdisCmDeactivateVc( NDIS_HANDLE );
EXPORT VOID NTAPI           NdisCmDeregisterSapComplete( NDIS_STATUS, NDIS_HANDLE );
EXPORT VOID NTAPI           NdisCmDispatchCallConnected( NDIS_HANDLE );
EXPORT NDIS_STATUS NTAPI    NdisCmDispatchIncomingCall( NDIS_HANDLE, NDIS_HANDLE, PCO_CALL_PARAMETERS );
EXPORT VOID NTAPI           NdisCmDispatchIncomingCallQoSChange( NDIS_HANDLE, PCO_CALL_PARAMETERS );
EXPORT VOID NTAPI           NdisCmDispatchIncomingCloseCall( NDIS_STATUS, NDIS_HANDLE, PVOID, UINT );
EXPORT VOID NTAPI           NdisCmDispatchIncomingDropParty( NDIS_STATUS, NDIS_HANDLE, PVOID, UINT );
EXPORT VOID NTAPI           NdisCmDropPartyComplete( NDIS_STATUS, NDIS_HANDLE );
EXPORT VOID NTAPI           NdisCmMakeCallComplete( NDIS_STATUS, NDIS_HANDLE, NDIS_HANDLE, NDIS_HANDLE, PCO_CALL_PARAMETERS );
EXPORT VOID NTAPI           NdisCmModifyCallQoSComplete( NDIS_STATUS, NDIS_HANDLE, PCO_CALL_PARAMETERS );
EXPORT VOID NTAPI           NdisCmOpenAddressFamilyComplete( NDIS_STATUS, NDIS_HANDLE, NDIS_HANDLE );
EXPORT VOID NTAPI           NdisCmRegisterSapComplete( NDIS_STATUS, NDIS_HANDLE, NDIS_HANDLE );
EXPORT NDIS_STATUS NTAPI    NdisCoAssignInstanceName( NDIS_HANDLE, PNDIS_STRING, PNDIS_STRING );
EXPORT NDIS_STATUS NTAPI    NdisCoCreateVc( NDIS_HANDLE, NDIS_HANDLE, NDIS_HANDLE, PNDIS_HANDLE );
EXPORT NDIS_STATUS NTAPI    NdisCoDeleteVc( NDIS_HANDLE );
EXPORT NDIS_STATUS NTAPI    NdisCoGetTapiCallId( NDIS_HANDLE, PVAR_STRING );
EXPORT VOID NTAPI           NdisCompleteDmaTransfer( PNDIS_STATUS, NDIS_HANDLE, PNDIS_BUFFER, ULONG, ULONG, BOOLEAN );
EXPORT VOID NTAPI           NdisCopyBuffer( PNDIS_STATUS, PNDIS_BUFFER *, NDIS_HANDLE, PVOID, UINT, UINT );
EXPORT VOID NTAPI           NdisDeregisterTdiCallBack( VOID );
EXPORT VOID NTAPI           NdisFreeMemory( PVOID, UINT, UINT );
EXPORT VOID NTAPI           NdisFreeMemoryWithTag( PVOID, ULONG );
EXPORT UCHAR NTAPI          NdisGeneratePartialCancelId( VOID );
EXPORT VOID NTAPI           NdisGetCurrentProcessorCounts( PULONG, PULONG, PULONG );
EXPORT VOID NTAPI           NdisGetCurrentProcessorCpuUsage( PULONG );
EXPORT PVOID NTAPI          NdisGetRoutineAddress( PNDIS_STRING );
EXPORT ULONG NTAPI          NdisGetSharedDataAlignment( VOID );
EXPORT UINT NTAPI           NdisGetVersion( VOID );
EXPORT VOID NTAPI           NdisIMAssociateMiniport( NDIS_HANDLE, NDIS_HANDLE );
EXPORT NDIS_STATUS NTAPI    NdisIMCancelInitializeDeviceInstance( NDIS_HANDLE, PNDIS_STRING );
EXPORT NDIS_STATUS NTAPI    NdisIMDeInitializeDeviceInstance( NDIS_HANDLE );
EXPORT NDIS_HANDLE NTAPI    NdisIMGetBindingContext( NDIS_HANDLE );
EXPORT NDIS_STATUS NTAPI    NdisIMInitializeDeviceInstanceEx( NDIS_HANDLE, PNDIS_STRING, NDIS_HANDLE );
EXPORT VOID NTAPI           NdisInitializeEvent( PNDIS_EVENT );
EXPORT VOID NTAPI           NdisInitializeString( PNDIS_STRING, PUCHAR );
EXPORT VOID NTAPI           NdisInitializeTimer( PNDIS_TIMER, PNDIS_TIMER_FUNCTION, PVOID );
EXPORT VOID NTAPI           NdisMAllocateSharedMemory( NDIS_HANDLE, ULONG, BOOLEAN, PVOID *, PNDIS_PHYSICAL_ADDRESS );
EXPORT NDIS_STATUS NTAPI    NdisMAllocateSharedMemoryAsync( NDIS_HANDLE, ULONG, BOOLEAN, PVOID );
EXPORT VOID NTAPI           NdisMCancelTimer( PNDIS_MINIPORT_TIMER, PBOOLEAN );
EXPORT VOID NTAPI           NdisMCloseLog( NDIS_HANDLE );
EXPORT NDIS_STATUS NTAPI    NdisMCmActivateVc( NDIS_HANDLE, PCO_CALL_PARAMETERS );
EXPORT NDIS_STATUS NTAPI    NdisMCmCreateVc( NDIS_HANDLE, NDIS_HANDLE, NDIS_HANDLE, PNDIS_HANDLE );
EXPORT NDIS_STATUS NTAPI    NdisMCmDeactivateVc( NDIS_HANDLE );
EXPORT NDIS_STATUS NTAPI    NdisMCmDeleteVc( NDIS_HANDLE );
EXPORT NDIS_STATUS NTAPI    NdisMCmRegisterAddressFamily( NDIS_HANDLE, PCO_ADDRESS_FAMILY, PNDIS_CALL_MANAGER_CHARACTERISTICS, UINT );
EXPORT VOID NTAPI           NdisMCoActivateVcComplete( NDIS_STATUS, NDIS_HANDLE, PCO_CALL_PARAMETERS );
EXPORT VOID NTAPI           NdisMCoDeactivateVcComplete( NDIS_STATUS, NDIS_HANDLE );
EXPORT NDIS_STATUS NTAPI    NdisMCreateLog( NDIS_HANDLE, UINT, PNDIS_HANDLE );
EXPORT VOID NTAPI           NdisMDeregisterDmaChannel( NDIS_HANDLE );
EXPORT VOID NTAPI           NdisMDeregisterIoPortRange( NDIS_HANDLE, UINT, UINT, PVOID );
EXPORT VOID NTAPI           NdisMFlushLog( NDIS_HANDLE );
EXPORT VOID NTAPI           NdisMFreeSharedMemory( NDIS_HANDLE, ULONG, BOOLEAN, PVOID, NDIS_PHYSICAL_ADDRESS );
EXPORT VOID NTAPI           NdisMGetDeviceProperty( NDIS_HANDLE, PDEVICE_OBJECT *, PDEVICE_OBJECT *, PDEVICE_OBJECT *, PCM_RESOURCE_LIST *, PCM_RESOURCE_LIST * );
EXPORT ULONG NTAPI          NdisMGetDmaAlignment( NDIS_HANDLE );
EXPORT VOID NTAPI           NdisMInitializeTimer( PNDIS_MINIPORT_TIMER, NDIS_HANDLE, PNDIS_TIMER_FUNCTION, PVOID );
EXPORT NDIS_STATUS NTAPI    NdisMMapIoSpace( PVOID *, NDIS_HANDLE, NDIS_PHYSICAL_ADDRESS, UINT );
EXPORT NDIS_STATUS NTAPI    NdisMQueryAdapterInstanceName( PNDIS_STRING, NDIS_HANDLE );
EXPORT ULONG NTAPI          NdisMReadDmaCounter( NDIS_HANDLE );
EXPORT NDIS_STATUS NTAPI    NdisMRegisterDmaChannel( PNDIS_HANDLE, NDIS_HANDLE, UINT, BOOLEAN, PNDIS_DMA_DESCRIPTION, ULONG );
EXPORT NDIS_STATUS NTAPI    NdisMRegisterIoPortRange( PVOID *, NDIS_HANDLE, UINT, UINT );
EXPORT NDIS_STATUS NTAPI    NdisMRemoveMiniport( NDIS_HANDLE );
EXPORT VOID NTAPI           NdisMSetPeriodicTimer( PNDIS_MINIPORT_TIMER, UINT );
EXPORT VOID NTAPI           NdisMSleep( ULONG );
EXPORT VOID NTAPI           NdisMUnmapIoSpace( NDIS_HANDLE, PVOID, UINT );
EXPORT NDIS_STATUS NTAPI    NdisMWriteLogData( NDIS_HANDLE, PVOID, UINT );
EXPORT VOID NTAPI           NdisMapFile( PNDIS_STATUS, PVOID *, NDIS_HANDLE );
EXPORT VOID NTAPI           NdisOpenConfigurationKeyByIndex( PNDIS_STATUS, NDIS_HANDLE, ULONG, PNDIS_STRING, PNDIS_HANDLE );
EXPORT VOID NTAPI           NdisOpenConfigurationKeyByName( PNDIS_STATUS, NDIS_HANDLE, PNDIS_STRING, PNDIS_HANDLE );
EXPORT VOID NTAPI           NdisOpenFile( PNDIS_STATUS, PNDIS_HANDLE, PUINT, PNDIS_STRING, NDIS_PHYSICAL_ADDRESS );
EXPORT NDIS_STATUS NTAPI    NdisQueryAdapterInstanceName( PNDIS_STRING, NDIS_HANDLE );
EXPORT NDIS_STATUS NTAPI    NdisQueryBindInstanceName( PNDIS_STRING, NDIS_HANDLE );
EXPORT VOID NTAPI           NdisReEnumerateProtocolBindings( NDIS_HANDLE );
EXPORT VOID NTAPI           NdisReadConfiguration( PNDIS_STATUS, PNDIS_CONFIGURATION_PARAMETER *, NDIS_HANDLE, PNDIS_STRING, NDIS_PARAMETER_TYPE );
EXPORT VOID NTAPI           NdisReadNetworkAddress( PNDIS_STATUS, PVOID *, PUINT, NDIS_HANDLE );
EXPORT VOID NTAPI           NdisRegisterTdiCallBack( TDI_REGISTER_CALLBACK, TDI_PNP_HANDLER );
EXPORT VOID NTAPI           NdisResetEvent( PNDIS_EVENT );
EXPORT VOID NTAPI           NdisSetEvent( PNDIS_EVENT );
EXPORT VOID NTAPI           NdisSetPeriodicTimer( PNDIS_TIMER, UINT );
EXPORT VOID NTAPI           NdisSetTimer( PNDIS_TIMER, UINT );
EXPORT VOID NTAPI           NdisSetTimerEx( PNDIS_TIMER, UINT, PVOID );
EXPORT VOID NTAPI           NdisSetupDmaTransfer( PNDIS_STATUS, NDIS_HANDLE, PNDIS_BUFFER, ULONG, ULONG, BOOLEAN );
EXPORT VOID NTAPI           NdisUnmapFile( NDIS_HANDLE );
EXPORT VOID NTAPI           NdisUpdateSharedMemory( NDIS_HANDLE, ULONG, PVOID, NDIS_PHYSICAL_ADDRESS );
EXPORT BOOLEAN NTAPI        NdisWaitEvent( PNDIS_EVENT, UINT );
EXPORT VOID NTAPI           NdisWriteConfiguration( PNDIS_STATUS, NDIS_HANDLE, PNDIS_STRING, PNDIS_CONFIGURATION_PARAMETER );
EXPORT VOID __cdecl         NdisWriteErrorLogEntry( NDIS_HANDLE, NDIS_ERROR_CODE, ULONG, ... );
EXPORT NDIS_STATUS NTAPI    NdisWriteEventLogEntry( PVOID, NDIS_STATUS, ULONG, USHORT, PVOID, ULONG, PVOID );
#if NDIS_SUPPORT_60_COMPATIBLE_API
EXPORT VOID NTAPI           NdisAcquireReadWriteLock( PNDIS_RW_LOCK, BOOLEAN, PLOCK_STATE );
EXPORT VOID NTAPI           NdisInitializeReadWriteLock( PNDIS_RW_LOCK );
EXPORT VOID NTAPI           NdisReleaseReadWriteLock( PNDIS_RW_LOCK, PLOCK_STATE );
EXPORT CCHAR NTAPI          NdisSystemProcessorCount( VOID );
#endif
#if NDIS_LEGACY_DRIVER
EXPORT VOID NTAPI           NdisAllocateBuffer( PNDIS_STATUS, PNDIS_BUFFER *, NDIS_HANDLE, PVOID, UINT );
EXPORT VOID NTAPI           NdisAllocateBufferPool( PNDIS_STATUS, PNDIS_HANDLE, UINT );
EXPORT NDIS_STATUS NTAPI    NdisAllocateMemory( PVOID *, UINT, UINT, NDIS_PHYSICAL_ADDRESS );
EXPORT VOID NTAPI           NdisAllocatePacket( PNDIS_STATUS, PNDIS_PACKET *, NDIS_HANDLE );
EXPORT VOID NTAPI           NdisAllocatePacketPool( PNDIS_STATUS, PNDIS_HANDLE, UINT, UINT );
EXPORT VOID NTAPI           NdisAllocatePacketPoolEx( PNDIS_STATUS, PNDIS_HANDLE, UINT, UINT, UINT );
EXPORT NDIS_STATUS NTAPI    NdisCmRegisterAddressFamily( NDIS_HANDLE, PCO_ADDRESS_FAMILY, PNDIS_CALL_MANAGER_CHARACTERISTICS, UINT );
EXPORT VOID NTAPI           NdisCopyFromPacketToPacket( PNDIS_PACKET, UINT, UINT, PNDIS_PACKET, UINT, PUINT );
EXPORT VOID NTAPI           NdisCopyFromPacketToPacketSafe( PNDIS_PACKET, UINT, UINT, PNDIS_PACKET, UINT, PUINT, MM_PAGE_PRIORITY );
EXPORT VOID NTAPI           NdisDprAllocatePacket( PNDIS_STATUS, PNDIS_PACKET *, NDIS_HANDLE );
EXPORT VOID NTAPI           NdisDprAllocatePacketNonInterlocked( PNDIS_STATUS, PNDIS_PACKET *, NDIS_HANDLE );
EXPORT VOID NTAPI           NdisDprFreePacket( PNDIS_PACKET );
EXPORT VOID NTAPI           NdisDprFreePacketNonInterlocked( PNDIS_PACKET );
EXPORT VOID NTAPI           NdisFreeBufferPool( NDIS_HANDLE );
EXPORT VOID NTAPI           NdisFreePacket( PNDIS_PACKET );
EXPORT VOID NTAPI           NdisFreePacketPool( NDIS_HANDLE );
EXPORT NDIS_HANDLE NTAPI    NdisGetPoolFromPacket( PNDIS_PACKET );
EXPORT VOID NTAPI           NdisGetSystemUpTime( PULONG );
EXPORT PNDIS_PACKET_STACK NTAPI NdisIMGetCurrentPacketStack( PNDIS_PACKET, BOOLEAN * );
EXPORT VOID NTAPI           NdisOpenConfiguration( PNDIS_STATUS, PNDIS_HANDLE, NDIS_HANDLE );
EXPORT UINT NTAPI           NdisPacketPoolUsage( NDIS_HANDLE );
EXPORT UINT NTAPI           NdisPacketSize( UINT );
EXPORT NDIS_STATUS NTAPI    NdisScheduleWorkItem( PNDIS_WORK_ITEM );
EXPORT VOID NTAPI           NdisSetPacketPoolProtocolId( NDIS_HANDLE, UINT );
EXPORT VOID NTAPI           NdisSetPacketStatus( PNDIS_PACKET, NDIS_STATUS, NDIS_HANDLE, ULONG );
EXPORT VOID NTAPI           NdisUnchainBufferAtBack( PNDIS_PACKET, PNDIS_BUFFER * );
EXPORT VOID NTAPI           NdisUnchainBufferAtFront( PNDIS_PACKET, PNDIS_BUFFER * );
#endif
#if NDIS_LEGACY_MINIPORT
EXPORT VOID NTAPI           NdisIMCopySendCompletePerPacketInfo( PNDIS_PACKET, PNDIS_PACKET );
EXPORT VOID NTAPI           NdisIMCopySendPerPacketInfo( PNDIS_PACKET, PNDIS_PACKET );
EXPORT VOID NTAPI           NdisIMDeregisterLayeredMiniport( NDIS_HANDLE );
EXPORT NDIS_HANDLE NTAPI    NdisIMGetDeviceContext( NDIS_HANDLE );
EXPORT NDIS_STATUS NTAPI    NdisIMNotifyPnPEvent( NDIS_HANDLE, PNET_PNP_EVENT );
EXPORT NDIS_STATUS NTAPI    NdisIMRegisterLayeredMiniport( NDIS_HANDLE, PNDIS_MINIPORT_CHARACTERISTICS, UINT, PNDIS_HANDLE );
EXPORT VOID NTAPI           NdisInitializeWrapper( PNDIS_HANDLE, PVOID, PVOID, PVOID );
EXPORT NDIS_STATUS NTAPI    NdisMAllocateMapRegisters( NDIS_HANDLE, UINT, NDIS_DMA_SIZE, ULONG, ULONG );
EXPORT NDIS_STATUS NTAPI    NdisMCmRequest( NDIS_HANDLE, NDIS_HANDLE, NDIS_HANDLE, PNDIS_REQUEST );
EXPORT VOID NTAPI           NdisMCoIndicateReceivePacket( NDIS_HANDLE, PPNDIS_PACKET, UINT );
EXPORT VOID NTAPI           NdisMCoIndicateStatus( NDIS_HANDLE, NDIS_HANDLE, NDIS_STATUS, PVOID, ULONG );
EXPORT VOID NTAPI           NdisMCoReceiveComplete( NDIS_HANDLE );
EXPORT VOID NTAPI           NdisMCoRequestComplete( NDIS_STATUS, NDIS_HANDLE, PNDIS_REQUEST );
EXPORT VOID NTAPI           NdisMCoSendComplete( NDIS_STATUS, NDIS_HANDLE, PNDIS_PACKET );
EXPORT VOID NTAPI           NdisMCompleteBufferPhysicalMapping( NDIS_HANDLE, PNDIS_BUFFER, ULONG );
EXPORT VOID NTAPI           NdisMDeregisterAdapterShutdownHandler( NDIS_HANDLE );
EXPORT NDIS_STATUS NTAPI    NdisMDeregisterDevice( NDIS_HANDLE );
EXPORT VOID NTAPI           NdisMDeregisterInterrupt( PNDIS_MINIPORT_INTERRUPT );
EXPORT VOID NTAPI           NdisMFreeMapRegisters( NDIS_HANDLE );
EXPORT VOID NTAPI           NdisMIndicateStatus( NDIS_HANDLE, NDIS_STATUS, PVOID, UINT );
EXPORT VOID NTAPI           NdisMIndicateStatusComplete( NDIS_HANDLE );
EXPORT NDIS_STATUS NTAPI    NdisMInitializeScatterGatherDma( NDIS_HANDLE, BOOLEAN, ULONG );
EXPORT NDIS_STATUS NTAPI    NdisMPciAssignResources( NDIS_HANDLE, ULONG, PNDIS_RESOURCE_LIST * );
EXPORT NDIS_STATUS NTAPI    NdisMPromoteMiniport( NDIS_HANDLE );
EXPORT VOID NTAPI           NdisMQueryAdapterResources( PNDIS_STATUS, NDIS_HANDLE, PNDIS_RESOURCE_LIST, PUINT );
EXPORT VOID NTAPI           NdisMRegisterAdapterShutdownHandler( NDIS_HANDLE, PVOID, ADAPTER_SHUTDOWN_HANDLER );
EXPORT NDIS_STATUS NTAPI    NdisMRegisterDevice( NDIS_HANDLE, PNDIS_STRING, PNDIS_STRING, PDRIVER_DISPATCH [], PDEVICE_OBJECT *, NDIS_HANDLE * );
EXPORT NDIS_STATUS NTAPI    NdisMRegisterInterrupt( PNDIS_MINIPORT_INTERRUPT, NDIS_HANDLE, UINT, UINT, BOOLEAN, BOOLEAN, NDIS_INTERRUPT_MODE );
EXPORT NDIS_STATUS NTAPI    NdisMRegisterMiniport( NDIS_HANDLE, PNDIS_MINIPORT_CHARACTERISTICS, UINT );
EXPORT VOID NTAPI           NdisMRegisterUnloadHandler( NDIS_HANDLE, PDRIVER_UNLOAD );
EXPORT VOID NTAPI           NdisMSetAttributesEx( NDIS_HANDLE, NDIS_HANDLE, UINT, ULONG, NDIS_INTERFACE_TYPE );
EXPORT NDIS_STATUS NTAPI    NdisMSetMiniportSecondary( NDIS_HANDLE, NDIS_HANDLE );
EXPORT VOID NTAPI           NdisMStartBufferPhysicalMapping( NDIS_HANDLE, PNDIS_BUFFER, ULONG, BOOLEAN, PNDIS_PHYSICAL_ADDRESS_UNIT, PUINT );
EXPORT BOOLEAN NTAPI        NdisMSynchronizeWithInterrupt( PNDIS_MINIPORT_INTERRUPT, PVOID, PVOID );
EXPORT ULONG NTAPI          NdisReadPciSlotInformation( NDIS_HANDLE, ULONG, ULONG, PVOID, ULONG );
EXPORT ULONG NTAPI          NdisReadPcmciaAttributeMemory( NDIS_HANDLE, ULONG, PVOID, ULONG );
EXPORT VOID NTAPI           NdisTerminateWrapper( NDIS_HANDLE, PVOID );
EXPORT ULONG NTAPI          NdisWritePciSlotInformation( NDIS_HANDLE, ULONG, ULONG, PVOID, ULONG );
EXPORT ULONG NTAPI          NdisWritePcmciaAttributeMemory( NDIS_HANDLE, ULONG, PVOID, ULONG );
#endif
#if NDIS_LEGACY_PROTOCOL
EXPORT VOID NTAPI           NdisCancelSendPackets( NDIS_HANDLE, PVOID );
EXPORT NDIS_STATUS NTAPI    NdisClOpenAddressFamily( NDIS_HANDLE, PCO_ADDRESS_FAMILY, NDIS_HANDLE, PNDIS_CLIENT_CHARACTERISTICS, UINT, PNDIS_HANDLE );
EXPORT VOID NTAPI           NdisCloseAdapter( PNDIS_STATUS, NDIS_HANDLE );
EXPORT NDIS_STATUS NTAPI    NdisCoRequest( NDIS_HANDLE, NDIS_HANDLE, NDIS_HANDLE, NDIS_HANDLE, PNDIS_REQUEST );
EXPORT VOID NTAPI           NdisCoRequestComplete( NDIS_STATUS, NDIS_HANDLE, NDIS_HANDLE, NDIS_HANDLE, PNDIS_REQUEST );
EXPORT VOID NTAPI           NdisCoSendPackets( NDIS_HANDLE, PPNDIS_PACKET, UINT );
EXPORT VOID NTAPI           NdisCompleteBindAdapter( NDIS_HANDLE, NDIS_STATUS, NDIS_STATUS );
EXPORT VOID NTAPI           NdisCompletePnPEvent( NDIS_STATUS, NDIS_HANDLE, PNET_PNP_EVENT );
EXPORT VOID NTAPI           NdisCompleteUnbindAdapter( NDIS_HANDLE, NDIS_STATUS );
EXPORT VOID NTAPI           NdisDeregisterProtocol( PNDIS_STATUS, NDIS_HANDLE );
EXPORT VOID NTAPI           NdisGetDriverHandle( NDIS_HANDLE, PNDIS_HANDLE );
EXPORT PNDIS_PACKET NTAPI   NdisGetReceivedPacket( NDIS_HANDLE, NDIS_HANDLE );
EXPORT VOID NTAPI           NdisOpenAdapter( PNDIS_STATUS, PNDIS_STATUS, PNDIS_HANDLE, PUINT, PNDIS_MEDIUM, UINT, NDIS_HANDLE, NDIS_HANDLE, PNDIS_STRING, UINT, PSTRING );
EXPORT VOID NTAPI           NdisOpenProtocolConfiguration( PNDIS_STATUS, PNDIS_HANDLE, PNDIS_STRING );
EXPORT NDIS_STATUS NTAPI    NdisQueryPendingIOCount( PVOID, PULONG );
EXPORT NDIS_STATUS NTAPI    NdisRegisterProtocol( PNDIS_STATUS, PNDIS_HANDLE, PNDIS_PROTOCOL_CHARACTERISTICS, UINT );
EXPORT VOID NTAPI           NdisRequest( PNDIS_STATUS, NDIS_HANDLE, PNDIS_REQUEST );
EXPORT VOID NTAPI           NdisReset( PNDIS_STATUS, NDIS_HANDLE );
EXPORT VOID NTAPI           NdisReturnPackets( PNDIS_PACKET *, UINT );
EXPORT VOID NTAPI           NdisSetProtocolFilter( PNDIS_STATUS, NDIS_HANDLE, RECEIVE_HANDLER, RECEIVE_PACKET_HANDLER, NDIS_MEDIUM, UINT, UINT, PUCHAR );
#endif
#if NDIS_SUPPORT_NDIS6
EXPORT NDIS_STATUS NTAPI    NdisAllocateCloneOidRequest( NDIS_HANDLE, PNDIS_OID_REQUEST, UINT, PNDIS_OID_REQUEST * );
EXPORT PNDIS_GENERIC_OBJECT NTAPI   NdisAllocateGenericObject( PDRIVER_OBJECT, ULONG, USHORT );
EXPORT NDIS_HANDLE NTAPI    NdisAllocateIoWorkItem( NDIS_HANDLE );
EXPORT PVOID NTAPI          NdisAllocateMemoryWithTagPriority( NDIS_HANDLE, UINT, ULONG, EX_POOL_PRIORITY );
EXPORT NDIS_STATUS NTAPI    NdisAllocateTimerObject( NDIS_HANDLE, PNDIS_TIMER_CHARACTERISTICS, PNDIS_HANDLE );
EXPORT BOOLEAN NTAPI        NdisCancelTimerObject( NDIS_HANDLE );
EXPORT VOID NTAPI           NdisClNotifyCloseAddressFamilyComplete( NDIS_HANDLE, NDIS_STATUS );
EXPORT NDIS_STATUS NTAPI    NdisClOpenAddressFamilyEx( NDIS_HANDLE, PCO_ADDRESS_FAMILY, NDIS_HANDLE, PNDIS_HANDLE );
EXPORT NDIS_STATUS NTAPI    NdisCmNotifyCloseAddressFamily( NDIS_HANDLE );
EXPORT NDIS_STATUS NTAPI    NdisCmRegisterAddressFamilyEx( NDIS_HANDLE, PCO_ADDRESS_FAMILY );
EXPORT NDIS_STATUS NTAPI    NdisCoOidRequest( NDIS_HANDLE, NDIS_HANDLE, NDIS_HANDLE, NDIS_HANDLE, PNDIS_OID_REQUEST );
EXPORT VOID NTAPI           NdisCoOidRequestComplete( NDIS_HANDLE, NDIS_HANDLE, NDIS_HANDLE, PNDIS_OID_REQUEST, NDIS_STATUS );
EXPORT VOID NTAPI           NdisCoSendNetBufferLists( NDIS_HANDLE, PNET_BUFFER_LIST, ULONG );
EXPORT VOID NTAPI           NdisFCancelOidRequest( NDIS_HANDLE, PVOID );
EXPORT VOID NTAPI           NdisFCancelSendNetBufferLists( NDIS_HANDLE, PVOID );
EXPORT VOID NTAPI           NdisFDeregisterFilterDriver( NDIS_HANDLE );
EXPORT VOID NTAPI           NdisFDevicePnPEventNotify( NDIS_HANDLE, PNET_DEVICE_PNP_EVENT );
EXPORT VOID NTAPI           NdisFIndicateReceiveNetBufferLists( NDIS_HANDLE, PNET_BUFFER_LIST, NDIS_PORT_NUMBER, ULONG, ULONG );
EXPORT VOID NTAPI           NdisFIndicateStatus( NDIS_HANDLE, PNDIS_STATUS_INDICATION );
EXPORT NDIS_STATUS NTAPI    NdisFNetPnPEvent( NDIS_HANDLE, PNET_PNP_EVENT_NOTIFICATION );
EXPORT NDIS_STATUS NTAPI    NdisFOidRequest( NDIS_HANDLE, PNDIS_OID_REQUEST );
EXPORT VOID NTAPI           NdisFOidRequestComplete( NDIS_HANDLE, PNDIS_OID_REQUEST, NDIS_STATUS );
EXPORT VOID NTAPI           NdisFPauseComplete( NDIS_HANDLE );
EXPORT NDIS_STATUS NTAPI    NdisFRegisterFilterDriver( PDRIVER_OBJECT, NDIS_HANDLE, PNDIS_FILTER_DRIVER_CHARACTERISTICS, PNDIS_HANDLE );
EXPORT VOID NTAPI           NdisFRestartComplete( NDIS_HANDLE, NDIS_STATUS );
EXPORT NDIS_STATUS NTAPI    NdisFRestartFilter( NDIS_HANDLE );
EXPORT VOID NTAPI           NdisFReturnNetBufferLists( NDIS_HANDLE, PNET_BUFFER_LIST, ULONG );
EXPORT VOID NTAPI           NdisFSendNetBufferLists( NDIS_HANDLE, PNET_BUFFER_LIST, NDIS_PORT_NUMBER, ULONG );
EXPORT NDIS_STATUS NTAPI    NdisFSetAttributes( NDIS_HANDLE, NDIS_HANDLE, PNDIS_FILTER_ATTRIBUTES );
EXPORT VOID NTAPI           NdisFreeCloneOidRequest( NDIS_HANDLE, PNDIS_OID_REQUEST );
EXPORT VOID NTAPI           NdisFreeGenericObject( PNDIS_GENERIC_OBJECT );
EXPORT VOID NTAPI           NdisFreeIoWorkItem( NDIS_HANDLE );
EXPORT VOID NTAPI           NdisFreeTimerObject( NDIS_HANDLE );
EXPORT VOID NTAPI           NdisGetSystemUpTimeEx( PLARGE_INTEGER );
EXPORT NDIS_STATUS NTAPI    NdisMAllocateNetBufferSGList( NDIS_HANDLE, PNET_BUFFER, PVOID, ULONG, PVOID, ULONG );
EXPORT NDIS_STATUS NTAPI    NdisMAllocatePort( NDIS_HANDLE, PNDIS_PORT_CHARACTERISTICS );
EXPORT NDIS_STATUS NTAPI    NdisMCmOidRequest( NDIS_HANDLE, NDIS_HANDLE, NDIS_HANDLE, PNDIS_OID_REQUEST );
EXPORT NDIS_STATUS NTAPI    NdisMCmRegisterAddressFamilyEx( NDIS_HANDLE, PCO_ADDRESS_FAMILY );
EXPORT VOID NTAPI           NdisMCoIndicateReceiveNetBufferLists( NDIS_HANDLE, PNET_BUFFER_LIST, ULONG, ULONG );
EXPORT VOID NTAPI           NdisMCoIndicateStatusEx( NDIS_HANDLE, NDIS_HANDLE, PNDIS_STATUS_INDICATION );
EXPORT VOID NTAPI           NdisMCoOidRequestComplete( NDIS_HANDLE, NDIS_HANDLE, PNDIS_OID_REQUEST, NDIS_STATUS );
EXPORT VOID NTAPI           NdisMCoSendNetBufferListsComplete( NDIS_HANDLE, PNET_BUFFER_LIST, ULONG );
EXPORT VOID NTAPI           NdisMDeregisterInterruptEx( NDIS_HANDLE );
EXPORT VOID NTAPI           NdisMDeregisterMiniportDriver( NDIS_HANDLE );
EXPORT VOID NTAPI           NdisMDeregisterScatterGatherDma( NDIS_HANDLE );
EXPORT VOID NTAPI           NdisMFreeNetBufferSGList( NDIS_HANDLE, PSCATTER_GATHER_LIST, PNET_BUFFER );
EXPORT NDIS_STATUS NTAPI    NdisMFreePort( NDIS_HANDLE, NDIS_PORT_NUMBER );
EXPORT ULONG NTAPI          NdisMGetBusData( NDIS_HANDLE, ULONG, ULONG, PVOID, ULONG );
EXPORT VOID NTAPI           NdisMIndicateReceiveNetBufferLists( NDIS_HANDLE, PNET_BUFFER_LIST, NDIS_PORT_NUMBER, ULONG, ULONG );
EXPORT VOID NTAPI           NdisMIndicateStatusEx( NDIS_HANDLE, PNDIS_STATUS_INDICATION );
EXPORT NDIS_STATUS NTAPI    NdisMNetPnPEvent( NDIS_HANDLE, PNET_PNP_EVENT_NOTIFICATION );
EXPORT VOID NTAPI           NdisMOidRequestComplete( NDIS_HANDLE, PNDIS_OID_REQUEST, NDIS_STATUS );
EXPORT VOID NTAPI           NdisMPauseComplete( NDIS_HANDLE );
EXPORT NDIS_STATUS NTAPI    NdisMRegisterInterruptEx( NDIS_HANDLE, NDIS_HANDLE, PNDIS_MINIPORT_INTERRUPT_CHARACTERISTICS, PNDIS_HANDLE );
EXPORT NDIS_STATUS NTAPI    NdisMRegisterMiniportDriver( PDRIVER_OBJECT, PUNICODE_STRING, NDIS_HANDLE, PNDIS_MINIPORT_DRIVER_CHARACTERISTICS, PNDIS_HANDLE );
EXPORT NDIS_STATUS NTAPI    NdisMRegisterScatterGatherDma( NDIS_HANDLE, PNDIS_SG_DMA_DESCRIPTION, PNDIS_HANDLE );
EXPORT VOID NTAPI           NdisMResetComplete( NDIS_HANDLE, NDIS_STATUS, BOOLEAN );
EXPORT VOID NTAPI           NdisMRestartComplete( NDIS_HANDLE, NDIS_STATUS );
EXPORT VOID NTAPI           NdisMSendNetBufferListsComplete( NDIS_HANDLE, PNET_BUFFER_LIST, ULONG );
EXPORT ULONG NTAPI          NdisMSetBusData( NDIS_HANDLE, ULONG, ULONG, PVOID, ULONG );
EXPORT NDIS_STATUS NTAPI    NdisMSetMiniportAttributes( NDIS_HANDLE, PNDIS_MINIPORT_ADAPTER_ATTRIBUTES );
EXPORT NDIS_STATUS NTAPI    NdisOpenConfigurationEx( PNDIS_CONFIGURATION_OBJECT, PNDIS_HANDLE );
EXPORT VOID NTAPI           NdisQueueIoWorkItem( NDIS_HANDLE, NDIS_IO_WORKITEM_ROUTINE, PVOID );
EXPORT NDIS_STATUS NTAPI    NdisSetOptionalHandlers( NDIS_HANDLE, PNDIS_DRIVER_OPTIONAL_HANDLERS );
EXPORT BOOLEAN NTAPI        NdisSetTimerObject( NDIS_HANDLE, LARGE_INTEGER, LONG, PVOID );
#if NDIS_SUPPORT_60_COMPATIBLE_API
EXPORT VOID NTAPI           NdisDprAcquireReadWriteLock( PNDIS_RW_LOCK, BOOLEAN, PLOCK_STATE );
EXPORT VOID NTAPI           NdisDprReleaseReadWriteLock( PNDIS_RW_LOCK, PLOCK_STATE );
EXPORT NDIS_STATUS NTAPI    NdisGetProcessorInformation( PNDIS_SYSTEM_PROCESSOR_INFO );
EXPORT ULONG NTAPI          NdisMQueueDpc( NDIS_HANDLE, ULONG, ULONG, PVOID );
EXPORT ULONG NTAPI          NdisSystemActiveProcessorCount( PKAFFINITY );
#endif
#endif
#if NDIS_SUPPORT_NDIS6 || NDIS60
EXPORT VOID NTAPI           NdisAdjustNetBufferCurrentMdl( PNET_BUFFER );
EXPORT VOID NTAPI           NdisAdvanceNetBufferDataStart( PNET_BUFFER, ULONG, BOOLEAN, NET_BUFFER_FREE_MDL_HANDLER );
EXPORT VOID NTAPI           NdisAdvanceNetBufferListDataStart( PNET_BUFFER_LIST, ULONG, BOOLEAN, NET_BUFFER_FREE_MDL_HANDLER );
EXPORT PNET_BUFFER_LIST NTAPI   NdisAllocateCloneNetBufferList( PNET_BUFFER_LIST, NDIS_HANDLE, NDIS_HANDLE, ULONG );
EXPORT PNET_BUFFER_LIST NTAPI   NdisAllocateFragmentNetBufferList( PNET_BUFFER_LIST, NDIS_HANDLE, NDIS_HANDLE, ULONG, ULONG, ULONG, ULONG, ULONG );
EXPORT PMDL NTAPI           NdisAllocateMdl( NDIS_HANDLE, PVOID, UINT );
EXPORT PNET_BUFFER NTAPI    NdisAllocateNetBuffer( NDIS_HANDLE, PMDL, ULONG, SIZE_T );
EXPORT PNET_BUFFER_LIST NTAPI   NdisAllocateNetBufferAndNetBufferList( NDIS_HANDLE, USHORT, USHORT, PMDL, ULONG, SIZE_T );
EXPORT PNET_BUFFER_LIST NTAPI   NdisAllocateNetBufferList( NDIS_HANDLE, USHORT, USHORT );
EXPORT NDIS_STATUS NTAPI    NdisAllocateNetBufferListContext( PNET_BUFFER_LIST, USHORT, USHORT, ULONG );
EXPORT NDIS_HANDLE NTAPI    NdisAllocateNetBufferListPool( NDIS_HANDLE, PNET_BUFFER_LIST_POOL_PARAMETERS );
EXPORT PNET_BUFFER NTAPI    NdisAllocateNetBufferMdlAndData( NDIS_HANDLE );
EXPORT NDIS_HANDLE NTAPI    NdisAllocateNetBufferPool( NDIS_HANDLE, PNET_BUFFER_POOL_PARAMETERS );
EXPORT PNET_BUFFER_LIST NTAPI   NdisAllocateReassembledNetBufferList( PNET_BUFFER_LIST, NDIS_HANDLE, ULONG, ULONG, ULONG, ULONG );
EXPORT VOID NTAPI           NdisCancelOidRequest( NDIS_HANDLE, PVOID );
EXPORT VOID NTAPI           NdisCancelSendNetBufferLists( NDIS_HANDLE, PVOID );
EXPORT NDIS_STATUS NTAPI    NdisCloseAdapterEx( NDIS_HANDLE );
EXPORT VOID NTAPI           NdisCompleteBindAdapterEx( NDIS_HANDLE, NDIS_STATUS );
EXPORT VOID NTAPI           NdisCompleteNetPnPEvent( NDIS_HANDLE, PNET_PNP_EVENT_NOTIFICATION, NDIS_STATUS );
EXPORT VOID NTAPI           NdisCompleteUnbindAdapterEx( NDIS_HANDLE );
EXPORT NDIS_STATUS NTAPI    NdisCopyFromNetBufferToNetBuffer( PNET_BUFFER, ULONG, ULONG, PNET_BUFFER, ULONG, PULONG );
EXPORT VOID NTAPI           NdisCopyReceiveNetBufferListInfo( PNET_BUFFER_LIST, PNET_BUFFER_LIST );
EXPORT VOID NTAPI           NdisCopySendNetBufferListInfo( PNET_BUFFER_LIST, PNET_BUFFER_LIST );
EXPORT VOID NTAPI           NdisDeregisterProtocolDriver( NDIS_HANDLE );
EXPORT VOID NTAPI           NdisFreeCloneNetBufferList( PNET_BUFFER_LIST, ULONG );
EXPORT VOID NTAPI           NdisFreeFragmentNetBufferList( PNET_BUFFER_LIST, ULONG, ULONG );
EXPORT VOID NTAPI           NdisFreeMdl( PMDL );
EXPORT VOID NTAPI           NdisFreeNetBuffer( PNET_BUFFER );
EXPORT VOID NTAPI           NdisFreeNetBufferList( PNET_BUFFER_LIST );
EXPORT VOID NTAPI           NdisFreeNetBufferListContext( PNET_BUFFER_LIST, USHORT );
EXPORT VOID NTAPI           NdisFreeNetBufferListPool( NDIS_HANDLE );
EXPORT VOID NTAPI           NdisFreeNetBufferPool( NDIS_HANDLE );
EXPORT VOID NTAPI           NdisFreeReassembledNetBufferList( PNET_BUFFER_LIST, ULONG, ULONG );
EXPORT PVOID NTAPI          NdisGetDataBuffer( PNET_BUFFER, ULONG, PVOID, UINT, UINT );
EXPORT UCHAR NTAPI          NdisGetNetBufferListProtocolId( PNET_BUFFER_LIST );
EXPORT NDIS_HANDLE NTAPI    NdisGetPoolFromNetBuffer( PNET_BUFFER );
EXPORT NDIS_HANDLE NTAPI    NdisGetPoolFromNetBufferList( PNET_BUFFER_LIST );
EXPORT NDIS_STATUS NTAPI    NdisIfAddIfStackEntry( NET_IFINDEX, NET_IFINDEX );
EXPORT NDIS_STATUS NTAPI    NdisIfAllocateNetLuidIndex( NET_IFTYPE, PUINT32 );
EXPORT VOID NTAPI           NdisIfDeleteIfStackEntry( NET_IFINDEX, NET_IFINDEX );
EXPORT VOID NTAPI           NdisIfDeregisterInterface( NET_IFINDEX );
EXPORT VOID NTAPI           NdisIfDeregisterProvider( NDIS_HANDLE );
EXPORT NDIS_STATUS NTAPI    NdisIfFreeNetLuidIndex( NET_IFTYPE, UINT32 );
EXPORT NDIS_STATUS NTAPI    NdisIfGetInterfaceIndexFromNetLuid( NET_LUID, PNET_IFINDEX );
EXPORT NDIS_STATUS NTAPI    NdisIfGetNetLuidFromInterfaceIndex( NET_IFINDEX, PNET_LUID );
EXPORT NDIS_STATUS NTAPI    NdisIfQueryBindingIfIndex( NDIS_HANDLE, PNET_IFINDEX, PNET_LUID, PNET_IFINDEX, PNET_LUID );
EXPORT NDIS_STATUS NTAPI    NdisIfRegisterInterface( NDIS_HANDLE, NET_LUID, NDIS_HANDLE, PNET_IF_INFORMATION, PNET_IFINDEX );
EXPORT NDIS_STATUS NTAPI    NdisIfRegisterProvider( PNDIS_IF_PROVIDER_CHARACTERISTICS, NDIS_HANDLE, PNDIS_HANDLE );
EXPORT NDIS_STATUS NTAPI    NdisOidRequest( NDIS_HANDLE, PNDIS_OID_REQUEST );
EXPORT NDIS_STATUS NTAPI    NdisOpenAdapterEx( NDIS_HANDLE, NDIS_HANDLE, PNDIS_OPEN_PARAMETERS, NDIS_HANDLE, PNDIS_HANDLE );
EXPORT ULONG NTAPI          NdisQueryNetBufferPhysicalCount( PNET_BUFFER );
EXPORT NDIS_STATUS NTAPI    NdisRegisterProtocolDriver( NDIS_HANDLE, PNDIS_PROTOCOL_DRIVER_CHARACTERISTICS, PNDIS_HANDLE );
EXPORT NDIS_STATUS NTAPI    NdisRetreatNetBufferDataStart( PNET_BUFFER, ULONG, ULONG, NET_BUFFER_ALLOCATE_MDL_HANDLER );
EXPORT NDIS_STATUS NTAPI    NdisRetreatNetBufferListDataStart( PNET_BUFFER_LIST, ULONG, ULONG, NET_BUFFER_ALLOCATE_MDL_HANDLER, NET_BUFFER_FREE_MDL_HANDLER );
EXPORT VOID NTAPI           NdisReturnNetBufferLists( NDIS_HANDLE, PNET_BUFFER_LIST, ULONG );
EXPORT VOID NTAPI           NdisSendNetBufferLists( NDIS_HANDLE, PNET_BUFFER_LIST, NDIS_PORT_NUMBER, ULONG );
EXPORT NDIS_STATUS NTAPI    NdisUnbindAdapter( NDIS_HANDLE );
#endif
#if NDIS_SUPPORT_NDIS61
EXPORT VOID NTAPI           NdisCancelDirectOidRequest( NDIS_HANDLE, PVOID );
EXPORT NDIS_STATUS NTAPI    NdisDirectOidRequest( NDIS_HANDLE, PNDIS_OID_REQUEST );
EXPORT VOID NTAPI           NdisFCancelDirectOidRequest( NDIS_HANDLE, PVOID );
EXPORT NDIS_STATUS NTAPI    NdisFDirectOidRequest( NDIS_HANDLE, PNDIS_OID_REQUEST );
EXPORT VOID NTAPI           NdisFDirectOidRequestComplete( NDIS_HANDLE, PNDIS_OID_REQUEST, NDIS_STATUS );
EXPORT NDIS_STATUS NTAPI    NdisMConfigMSIXTableEntry( NDIS_HANDLE, PNDIS_MSIX_CONFIG_PARAMETERS );
EXPORT VOID NTAPI           NdisMDirectOidRequestComplete( NDIS_HANDLE, PNDIS_OID_REQUEST, NDIS_STATUS );
#endif
#if NDIS_SUPPORT_NDIS620
EXPORT VOID NTAPI           NdisAcquireRWLockRead( PNDIS_RW_LOCK_EX, PLOCK_STATE_EX, UCHAR );
EXPORT VOID NTAPI           NdisAcquireRWLockWrite( PNDIS_RW_LOCK_EX, PLOCK_STATE_EX, UCHAR );
EXPORT USHORT NTAPI         NdisActiveGroupCount( VOID );
EXPORT PNDIS_RW_LOCK_EX NTAPI   NdisAllocateRWLock( NDIS_HANDLE );
EXPORT NDIS_STATUS NTAPI    NdisAllocateSharedMemory( NDIS_HANDLE, PNDIS_SHARED_MEMORY_PARAMETERS, PNDIS_HANDLE );
EXPORT NDIS_STATUS NTAPI    NdisBuildScatterGatherList( NDIS_HANDLE, PNDIS_SCATTER_GATHER_LIST_PARAMETERS );
EXPORT PROCESSOR_NUMBER NTAPI   NdisCurrentGroupAndProcessor( VOID );
EXPORT ULONG NTAPI          NdisCurrentProcessorIndex( VOID );
EXPORT VOID NTAPI           NdisFreeMemoryWithTagPriority( NDIS_HANDLE, PVOID, ULONG );
EXPORT VOID NTAPI           NdisFreeRWLock( PNDIS_RW_LOCK_EX );
EXPORT VOID NTAPI           NdisFreeScatterGatherList( NDIS_HANDLE, PSCATTER_GATHER_LIST, BOOLEAN );
EXPORT VOID NTAPI           NdisFreeSharedMemory( NDIS_HANDLE, NDIS_HANDLE );
EXPORT NDIS_STATUS NTAPI    NdisGetHypervisorInfo( PNDIS_HYPERVISOR_INFO );
EXPORT NDIS_STATUS NTAPI    NdisGetProcessorInformationEx( NDIS_HANDLE, PNDIS_SYSTEM_PROCESSOR_INFO_EX, PSIZE_T );
EXPORT NDIS_STATUS NTAPI    NdisGetRssProcessorInformation( NDIS_HANDLE, PNDIS_RSS_PROCESSOR_INFO, PSIZE_T );
EXPORT ULONG NTAPI          NdisGroupActiveProcessorCount( USHORT );
EXPORT KAFFINITY NTAPI      NdisGroupActiveProcessorMask( USHORT );
EXPORT ULONG NTAPI          NdisGroupMaxProcessorCount( USHORT );
EXPORT KAFFINITY NTAPI      NdisMQueueDpcEx( NDIS_HANDLE, ULONG, PGROUP_AFFINITY, PVOID );
EXPORT USHORT NTAPI         NdisMaxGroupCount( VOID );
EXPORT NTSTATUS NTAPI       NdisProcessorIndexToNumber( ULONG, PPROCESSOR_NUMBER );
EXPORT ULONG NTAPI          NdisProcessorNumberToIndex( PROCESSOR_NUMBER );
EXPORT VOID NTAPI           NdisReleaseRWLock( PNDIS_RW_LOCK_EX, PLOCK_STATE_EX );
EXPORT BOOLEAN NTAPI        NdisSetCoalescableTimerObject( NDIS_HANDLE, LARGE_INTEGER, LONG, PVOID, ULONG );
#endif
#if (NTDDI_VERSION == 0x06000000) && (NDIS_LEGACY_DRIVER || NDIS_SUPPORT_NDIS6)
EXPORT VOID NTAPI           NdisDeregisterDeviceEx( NDIS_HANDLE );
EXPORT NDIS_STATUS NTAPI    NdisEnumerateFilterModules( NDIS_HANDLE, PVOID, ULONG, PULONG, PULONG );
EXPORT PVOID NTAPI          NdisGetDeviceReservedExtension( PDEVICE_OBJECT );
EXPORT NDIS_STATUS NTAPI    NdisRegisterDeviceEx( NDIS_HANDLE, PNDIS_DEVICE_OBJECT_ATTRIBUTES, PDEVICE_OBJECT *, PNDIS_HANDLE );
#endif

/* Functions in NDIS.SYS that are defined differently on different versions
 * of Windows.
 */
#if NDIS_SUPPORT_NDIS620
EXPORT BOOLEAN NTAPI    NdisMSychronizeWithInterruptEx( NDIS_HANDLE, ULONG, MINIPORT_SYNCHRONIZE_INTERRUPT_HANDLER, PVOID );
#elif NDIS_SUPPORT_NDIS6
EXPORT BOOLEAN NTAPI    NdisMSynchronizeWithInterruptEx( NDIS_HANDLE, ULONG, PVOID, PVOID );
#endif

/* Functions implemented as macros */
#define NdisGetPhysicalAddressHigh( x )         ((x).HighPart)
#define NdisSetPhysicalAddressHigh( x, p )      ((x).HighPart) = (p)
#define NdisGetPhysicalAddressLow( x )          ((x).LowPart)
#define NdisSetPhysicalAddressLow( x, p )       ((x).LowPart) = (p)
#define NdisAllocateSpinLock( x )               KeInitializeSpinLock( &(x)->SpinLock )
#define NdisFreeSpinLock( x )
#define NdisAcquireSpinLock( x ) \
    KeAcquireSpinLock( &(x)->SpinLock, &(x)->OldIrql )
#define NdisReleaseSpinLock( x ) \
    KeReleaseSpinLock( &(x)->SpinLock, (x)->OldIrql )
#define NdisDprAcquireSpinLock( x ) \
    KeAcquireSpinLockAtDpcLevel( &(x)->SpinLock )
#define NdisDprReleaseSpinLock( x ) \
    KeReleaseSpinLockFromDpcLevel( &(x)->SpinLock )
#define NdisInterlockedAddUlong( x, p1, p2 ) \
    ExInterlockedAddUlong( x, p1, &(p2)->SpinLock )
#define NdisInterlockedInsertHeadList( x, p1, p2 ) \
    ExInterlockedInsertHeadList( x, p1, &(p2)->SpinLock )
#define NdisInterlockedInsertTailList( x, p1, p2 ) \
    ExInterlockedInsertTailList( x, p1, &(p2)->SpinLock )
#define NdisInterlockedRemoveHeadList( x, p ) \
    ExInterlockedRemoveHeadList( x, &(p)->SpinLock )
#define NdisInterlockedPushEntryList( x, p1, p2 ) \
    ExInterlockedPushEntryList( x, p1, &(p2)->SpinLock )
#define NdisInterlockedPopEntryList( x, p ) \
    ExInterlockedPopEntryList( x, &(p)->SpinLock )
#define NdisInterlockedAddLargeStatistic( x, p ) \
    ExInterlockedAddLargeStatistic( (PLARGE_INTEGER)(x), p )
#define NdisInterlockedPushEntrySList( x, p1, p2 ) \
    ExInterlockedPushEntrySList( x, p1, &(p2)->SpinLock )
#define NdisInterlockedPopEntrySList( x, p ) \
    ExInterlockedPopEntrySList( x, &(p)->SpinLock )
#define NdisQueryBufferState( x, p1, p2, p3 ) \
    { \
        if( (p1) != NULL ) { \
            *(PVOID *)(p1) = MmGetSystemAddressForMdlSafe( x, p3 ); \
        } \
        *(p2) = MmGetMdlByteCount( x ); \
    }
#define NdisQueryBufferOffset( x, p1, p2 ) \
    { \
        *(p1) = MmGetMdlByteOffset( x ); \
        *(p2) = MmGetMdlByteCount( x ); \
    }
#define NdisGetBufferPhysicalArraySize( x, p ) \
    (*(p) = NDIS_BUFFER_TO_SPAN_PAGES( x ))
#define NdisGetNextBuffer( x, p )               { *(p) = (x)->Next; }
#define NdisAdjustBufferLength( x, p )          ((x)->ByteCount = (p))
#define NdisFlushBuffer( x, p )                 KeFlushIoBuffers( x, !(p), TRUE )
#define NdisRawWritePortUchar( p1, p2 ) \
    WRITE_PORT_UCHAR( (PUCHAR)(p1), (UCHAR)(p2) )
#define NdisRawWritePortUshort( p1, p2 ) \
    WRITE_PORT_USHORT( (PUSHORT)(p1), (USHORT)(p2) )
#define NdisRawWritePortUlong( p1, p2 ) \
    WRITE_PORT_ULONG( (PULONG)(p1), (ULONG)(p2) )
#define NdisRawWritePortBufferUchar( p1, p2, p3 ) \
    WRITE_PORT_BUFFER_UCHAR( (PUCHAR)(p1), (PUCHAR)(p2), p3 )
#define NdisRawReadPortUchar( p1, p2 )          *(p2) = READ_PORT_UCHAR( (PUCHAR)(p1) )
#define NdisRawReadPortUshort( p1, p2 )         *(p2) = READ_PORT_USHORT( (PUSHORT)(p1) )
#define NdisRawReadPortUlong( p1, p2 )          *(p2) = READ_PORT_ULONG( (PULONG)(p1) )
#define NdisRawReadPortBufferUchar( p1, p2, p3 ) \
    READ_PORT_BUFFER_UCHAR( (PUCHAR)(p1), (PUCHAR)(p2), p3 )
#define NdisFreeString( x ) \
    NdisFreeMemory( (x).Buffer, (x).MaximumLength, 0 )
#define NdisPrintString( x )                    DbgPrint( "%ls", (x).Buffer );
#define NdisCreateLookaheadBufferFromSharedMemory( p1, p2, p3 ) (*(p3) = (p1))
#define NdisDestroyLookaheadBufferFromSharedMemory( x )
#define NdisAnsiStringToUnicodeString( p1, p2 ) \
    RtlAnsiStringToUnicodeString( p1, p2, FALSE )
#define NdisUnicodeStringToAnsiString( p1, p2 ) \
    RtlUnicodeStringToAnsiString( p1, p2, FALSE )
#define NdisUpcaseUnicodeString( p1, p2 )       RtlUpcaseUnicodeString( p1, p2, FALSE )
#define NdisMSetTimer( x, p )                   NdisSetTimer( (PNDIS_TIMER)(x), p )
#define NdisBufferLength( x )                   MmGetMdlByteCount( x )
#define NdisBufferVirtualAddress( x )           MmGetSystemAddressForMdl( x )
#define NdisBufferVirtualAddressSafe( x, p )    MmGetSystemAddressForMdlSafe( x, p )
#ifdef __cplusplus
    #define WanMiniportSend( x, p1, p2, p3 ) \
        { \
            *(x) = (((PNDIS_OPEN_BLOCK)(p1))->NdisCommonOpenBlock.WanSendHandler)( \
                ((PNDIS_OPEN_BLOCK)(p1))->NdisCommonOpenBlock.BindingHandle, (p2), \
                (PNDIS_PACKET)(p3) ); \
        }
#else
    #define WanMiniportSend( x, p1, p2, p3 ) \
        { \
            *(x) = (((PNDIS_OPEN_BLOCK)(p1))->WanSendHandler)( \
                ((PNDIS_OPEN_BLOCK)(p1))->BindingHandle, (p2), (PNDIS_PACKET)(p3) ); \
        }
#endif
#ifdef _X86_
    #define NdisMoveMappedMemory( p1, p2, p3 )  RtlCopyMemory( p1, p2, p3 )
    #define NdisZeroMappedMemory( p1, p2 )      RtlZeroMemory( p1, p2 )
    #define NdisCopyLookaheadData( p1, p2, p3, p4 ) RtlCopyMemory( p1, p2, p3 )
    #define NdisRawWritePortBufferUshort( p1, p2, p3 ) \
        WRITE_PORT_BUFFER_USHORT( (PUSHORT)(p1), (PUSHORT)(p2), p3 )
    #define NdisRawWritePortBufferUlong( p1, p2, p3 ) \
        WRITE_PORT_BUFFER_ULONG( (PULONG)(p1), (PULONG)(p2), p3 )
    #define NdisRawReadPortBufferUshort( p1, p2, p3 ) \
        READ_PORT_BUFFER_USHORT( (PUSHORT)(p1), (PUSHORT)(p2), p3 )
    #define NdisRawReadPortBufferUlong( p1, p2, p3 ) \
        READ_PORT_BUFFER_ULONG( (PULONG)(p1), (PULONG)(p2), p3 )
    #define NdisReadRegisterUchar( p1, p2 ) \
        *(p2) = *((volatile UCHAR * const)(p1))
    #define NdisReadRegisterUshort( p1, p2 ) \
        *(p2) = *((volatile USHORT * const)(p1))
    #define NdisReadRegisterUlong( p1, p2 ) \
        *(p2) = *((volatile ULONG * const)(p1))
#endif
#if NDIS_LEGACY_DRIVER
    #define NdisSetPacketCancelId( x, p )       NDIS_SET_PACKET_CANCEL_ID( x, p )
    #define NdisGetPacketCancelId( x )          NDIS_GET_PACKET_CANCEL_ID( x )
    #define NdisGetPacketFlags( x )             ((x)->Private.Flags)
    #define NdisSetPacketFlags( x, p )          ((x)->Private.Flags |= (p))
    #define NdisClearPacketFlags( x, p )        ((x)->Private.Flags &= ~(p))
    #define NdisReinitializePacket( x ) \
        { \
            (x)->Private.Head = (PNDIS_BUFFER)NULL; \
            (x)->Private.ValidCounts = FALSE; \
        }
    #define NdisQueryBuffer( x, p1, p2 ) \
        { \
            if( (p1) != NULL ) { \
                *(PVOID *)(p1) = MmGetSystemAddressForMdl( x ); \
            } \
            *(p2) = MmGetMdlByteCount( x ); \
        }
    #define NdisGetFirstBufferFromPacket( x, p1, p2, p3, p4 ) \
        { \
            PNDIS_BUFFER    _v; \
            _v = (x)->Private.Head; \
            *(p1) = _v; \
            if( _v ) { \
                *(p2) = MmGetSystemAddressForMdl( _v ); \
                *(p3) = *(p4) = MmGetMdlByteCount( _v ); \
                for( _v = _v->Next; _v != NULL; _v = _v->Next ) { \
                    *(p4) += MmGetMdlByteCount( _v ); \
                } \
            } else { \
                *(p2) = 0; \
                *(p3) = 0; \
                *(p4) = 0; \
            } \
        }
    #define NdisGetFirstBufferFromPacketSafe( x, p1, p2, p3, p4, p5 ) \
        { \
            PNDIS_BUFFER    _v; \
            _v = (x)->Private.Head; \
            *(p1) = _v; \
            if( _v ) { \
                *(p2) = MmGetSystemAddressForMdlSafe( _v, p5 ); \
                *(p3) = *(p4) = MmGetMdlByteCount( _v ); \
                for( _v = _v->Next; _v != NULL; _v = _v->Next ) { \
                    *(p4) += MmGetMdlByteCount( _v ); \
                } \
            } else { \
                *(p2) = 0; \
                *(p3) = 0; \
                *(p4) = 0; \
            } \
        }
    #define NdisRecalculatePacketCounts( x ) \
        { \
            PNDIS_BUFFER _v = (x)->Private.Head; \
            if( _v ) { \
                while( _v->Next ) { \
                    _v = _v->Next; \
                } \
                (x)->Private.Tail = _v; \
            } \
            (x)->Private.ValidCounts = FALSE; \
        }
    #define NdisChainBufferAtFront( x, p ) \
        { \
            PNDIS_BUFFER _v = (p); \
            for( ;; ) { \
                if( _v->Next == NULL ) { \
                    break; \
                } \
                _v = _v->Next; \
            } \
            if( (x)->Private.Head == NULL ) { \
                (x)->Private.Tail = _v; \
            } \
            _v->Next = (x)->Private.Head; \
            (x)->Private.Head = p; \
            (x)->Private.ValidCounts = FALSE; \
        }
    #define NdisChainBufferAtBack( x, p ) \
        { \
            PNDIS_BUFFER _v = (p); \
            for( ;; ) { \
                if( _v->Next == NULL ) { \
                    break; \
                } \
                _v = _v->Next; \
            } \
            if( (x)->Private.Head != NULL ) { \
                (x)->Private.Tail->Next = p; \
            } else { \
                (x)->Private.Head = p; \
            } \
            (x)->Private.Tail = _v; \
            (x)->Private.ValidCounts = FALSE; \
        }
    #define NdisQueryPacketLength( x, p ) \
        { \
            if( !(x)->Private.ValidCounts ) { \
                NdisQueryPacket( x, NULL, NULL, NULL, p ); \
            } else { \
                *(p) = (x)->Private.TotalLength; \
            } \
        }
    #define NdisInitializeWorkItem( x, p1, p2 ) \
        { \
            (x)->Context = p1; \
            (x)->Context = p2; \
        }
#endif
#if NDIS_LEGACY_PROTOCOL
    #define NdisSetSendFlags( x, p )            (x)->Private.Flags = (p)
    #define NdisQuerySendFlags( x, p )          *(p) = (x)->Private.Flags
    #ifdef __cplusplus
        #define NdisSend( x, p1, p2 ) \
            { \
                *(x) = (((PNDIS_OPEN_BLOCK)(p1))->NdisCommonOpenBlock.SendHandler)( \
                    ((PNDIS_OPEN_BLOCK)(p1))->NdisCommonOpenBlock.BindingHandle, 
                    (p2) ); \
            }
        #define NdisSendPackets( x, p1, p2 ) \
            { \
                (((PNDIS_OPEN_BLOCK)(x))->NdisCommonOpenBlock.SendPacketsHandler)( \
                    (PNDIS_OPEN_BLOCK)(x), (p1), (p2) ); \
            }
        #define NdisTransferData( x, p1, p2, p3, p4, p5, p6 ) \
            { \
                *(x) = (((PNDIS_OPEN_BLOCK)(p1))->NdisCommonOpenBlock.TransferDataHandler)( \
                    ((PNDIS_OPEN_BLOCK)(p1))->NdisCommonOpenBlock.BindingHandle, (p2), \
                    (p3), (p4), (p5), (p6) ); \
            }
    #else
        #define NdisSend( x, p1, p2 ) \
            { \
                *(x) = (((PNDIS_OPEN_BLOCK)(p1))->SendHandler)( \
                    ((PNDIS_OPEN_BLOCK)(p1))->BindingHandle, (p2) ); \
            }
        #define NdisSendPackets( x, p1, p2 ) \
            { \
                (((PNDIS_OPEN_BLOCK)(x))->SendPacketsHandler)( \
                    (PNDIS_OPEN_BLOCK)(x), (p1), (p2) ); \
            }
        #define NdisTransferData( x, p1, p2, p3, p4, p5, p6 ) \
            { \
                *(x) = (((PNDIS_OPEN_BLOCK)(p1))->TransferDataHandler)( \
                    ((PNDIS_OPEN_BLOCK)(p1))->BindingHandle, (p2), (p3), (p4), (p5), \
                    (p6) ); \
            }
    #endif
#endif
#if NDIS_LEGACY_MINIPORT
    #define NdisMUpdateSharedMemory( p1, p2, p3, p4 )
    #define NdisMInitializeWrapper( p1, p2, p3, p4 ) \
        NdisInitializeWrapper( p1, p2, p3, p4 )
    #define NdisIMInitializeDeviceInstance( p1, p2 ) \
        NdisIMInitializeDeviceInstanceEx( p1, p2, NULL )
    #define NdisMSetAttributes( p1, p2, p3, p4 ) \
        NdisMSetAttributesEx( p1, p2, 0, (p3) ? NDIS_ATTRIBUTE_BUS_MASTER : 0, p4 )
    #define NdisMSendComplete( x, p1, p2 ) \
        (*((PNDIS_MINIPORT_BLOCK)(x))->SendCompleteHandler)( x, p1, p2 )
    #define NdisMSendResourcesAvailable( x ) \
        (*((PNDIS_MINIPORT_BLOCK)(x))->SendResourcesHandler)( x )
    #define NdisMTransferDataComplete( x, p1, p2, p3 ) \
        (*((PNDIS_MINIPORT_BLOCK)(x))->TDCompleteHandler)( x, p1, p2, p3 )
    #define NdisMWanSendComplete( x, p1, p2 ) \
        (*((PNDIS_MINIPORT_BLOCK)(x))->WanSendCompleteHandler)( x, p1, p2 )
    #define NdisMQueryInformationComplete( x, p ) \
        (*((PNDIS_MINIPORT_BLOCK)(x))->QueryCompleteHandler)( x, p )
    #define NdisMSetInformationComplete( x, p ) \
        (*((PNDIS_MINIPORT_BLOCK)(x))->SetCompleteHandler)( x, p )
    #define NdisMIndicateReceivePacket( x, p1, p2 ) \
        { (*((PNDIS_MINIPORT_BLOCK)(x))->PacketIndicateHandler)( x, p1, p2 ); }
    #define NdisMWanIndicateReceive( p1, p2, p3, p4, p5 ) \
        (*((PNDIS_MINIPORT_BLOCK)(p2))->WanRcvHandler)( p1, p2, p3, p4, p5 )
    #define NdisMWanIndicateReceiveComplete( x, p ) \
        (*((PNDIS_MINIPORT_BLOCK)(x))->WanRcvCompleteHandler)( x, p )
    #define NdisMCmRequestComplete( p1, p2, p3, p4, p5 ) \
        NdisCoRequestComplete( p1, p2, p3, p4, p5 )
    #ifdef __cplusplus
        #define NdisMEthIndicateReceive( x, p1, p2, p3, p4, p5, p6 ) \
            { (*((PNDIS_MINIPORT_BLOCK)(x))->EthRxIndicateHandler)( \
            ((PNDIS_MINIPORT_BLOCK)(x))->FilterDbs.EthDB, p1, p2, p2, p3, p4, p5, p6 ); }
        #define NdisMTrIndicateReceive( x, p1, p2, p3, p4, p5, p6 ) \
            { (*((PNDIS_MINIPORT_BLOCK)(x))->TrRxIndicateHandler)( \
            ((PNDIS_MINIPORT_BLOCK)(x))->FilterDbs.TrDB, p1, p2, p3, p4, p5, p6 ); }
        #define NdisMEthIndicateReceiveComplete( x ) \
            { (*((PNDIS_MINIPORT_BLOCK)(x))->EthRxCompleteHandler)( \
            ((PNDIS_MINIPORT_BLOCK)(x))->FilterDbs.EthDB ); }
        #define NdisMTrIndicateReceiveComplete( x ) \
            { (*((PNDIS_MINIPORT_BLOCK)(x))->TrRxCompleteHandler)( \
            ((PNDIS_MINIPORT_BLOCK)(x))->FilterDbs.TrDB ); }
    #else
        #define NdisMEthIndicateReceive( x, p1, p2, p3, p4, p5, p6 ) \
            { (*((PNDIS_MINIPORT_BLOCK)(x))->EthRxIndicateHandler)( \
            ((PNDIS_MINIPORT_BLOCK)(x))->EthDB, p1, p2, p2, p3, p4, p5, p6 ); }
        #define NdisMTrIndicateReceive( x, p1, p2, p3, p4, p5, p6 ) \
            { (*((PNDIS_MINIPORT_BLOCK)(x))->TrRxIndicateHandler)( \
            ((PNDIS_MINIPORT_BLOCK)(x))->TrDB, p1, p2, p3, p4, p5, p6 ); }
        #define NdisMEthIndicateReceiveComplete( x ) \
            { (*((PNDIS_MINIPORT_BLOCK)(x))->EthRxCompleteHandler)( \
            ((PNDIS_MINIPORT_BLOCK)(x))->EthDB ); }
        #define NdisMTrIndicateReceiveComplete( x ) \
            { (*((PNDIS_MINIPORT_BLOCK)(x))->TrRxCompleteHandler)( \
            ((PNDIS_MINIPORT_BLOCK)(x))->TrDB ); }
    #endif
    #if NDIS_LEGACY_MINIPORT && !NDIS_WRAPPER && !NDIS_SUPPORT_NDIS6
        #define NdisMResetComplete( x, p1, p2 ) \
            (*((PNDIS_MINIPORT_BLOCK)(x))->ResetCompleteHandler)( x, p1, p2 )
    #endif
#endif
#if NDIS_SUPPORT_NDIS6
    #define NdisAdjustMdlLength( x, p )         ((x)->ByteLength = (p))
#endif
#if NDIS_SUPPORT_NDIS6 || NDIS60
    #define NdisSetNetBufferListProtocolId( x, p ) \
        *((PUCHAR)(&NET_BUFFER_LIST_INFO( x, NetBufferListProtocolId )) = (p)
    #define NdisQueryMdl( x, p1, p2, p3 ) \
        { \
            if( (p1) != NULL ) { \
                *(PVOID *)(p1) = MmGetSystemAddressForMdlSafe( x, p3 ); \
            } \
            *(p2) = MmGetMdlByteCount( x ); \
        }
    #define NdisQueryMdlOffset( x, p1, p2 ) \
        { \
            *(p1) = MmGetMdlByteOffset( x ); \
            *(p2) = MmGetMdlByteCount( x ); \
        }
    #define NdisGetMdlPhysicalArraySize( x, p ) \
        (*(p) = NDIS_MDL_TO_SPAN_PAGES( x ))
    #define NdisGetNextMdl( x, p ) \
        { *(p) = (x)->Next; }
    #define NdisTestNblFlag( x, p )             (((x)->NblFlags & (p)) != 0)
    #define NdisTestNblFlags( x, p )            (((x)->NblFlags & (p)) == (p))
    #define NdisSetNblFlag( x, p )              ((x)->NblFlags |= (p))
    #define NdisClearNblFlag( x, p )            ((x)->NblFlags &= ~(p))
    #define NdisMCmOidRequestComplete( p1, p2, p3, p4, p5 ) \
        NdisCoOidRequestComplete( p1, p2, p3, p4, p5 )
#endif

/* Other macros */
#if NDIS_LEGACY_DRIVER
    #define NDIS_GET_PACKET_PROTOCOL_TYPE( x ) \
        ((x)->Private.Flags & NDIS_PROTOCOL_ID_MASK)
    #define NDIS_OOB_DATA_FROM_PACKET( x ) \
        (PNDIS_PACKET_OOB_DATA)((PUCHAR)(x) + (x)->Private.NdisPacketOobOffset)
    #define NDIS_GET_PACKET_HEADER_SIZE( x ) \
        ((PNDIS_PACKET_OOB_DATA)((PUCHAR)(x) + \
        (x)->Private.NdisPacketOobOffset))->HeaderSize
    #define NDIS_GET_PACKET_STATUS( x ) \
        ((PNDIS_PACKET_OOB_DATA)((PUCHAR)(x) + \
        (x)->Private.NdisPacketOobOffset))->Status
    #define NDIS_GET_PACKET_TIME_TO_SEND( x ) \
        ((PNDIS_PACKET_OOB_DATA)((PUCHAR)(x) + \
        (x)->Private.NdisPacketOobOffset))->TimeToSend
    #define NDIS_GET_PACKET_TIME_SENT( x ) \
        ((PNDIS_PACKET_OOB_DATA)((PUCHAR)(x) + \
        (x)->Private.NdisPacketOobOffset))->TimeSent
    #define NDIS_GET_PACKET_TIME_RECEIVED( x ) \
        ((PNDIS_PACKET_OOB_DATA)((PUCHAR)(x) + \
        (x)->Private.NdisPacketOobOffset))->TimeReceived
    #define NDIS_GET_PACKET_MEDIA_SPECIFIC_INFO( x, p1, p2 ) \
        { \
            if( !((x)->Private.NdisPacketFlags & fPACKET_ALLOCATED_BY_NDIS) || \
                !((x)->Private.NdisPacketFlags & \
                fPACKET_CONTAINS_MEDIA_SPECIFIC_INFO)) { \
                *(p1) = NULL; \
                *(p2) = 0; \
            } else { \
                *(p1) = ((PNDIS_PACKET_OOB_DATA)((PUCHAR)(x) + \
                    (x)->Private.NdisPacketOobOffset))->MediaSpecificInformation; \
                *(p2) = ((PNDIS_PACKET_OOB_DATA)((PUCHAR)(x) + \
                    (x)->Private.NdisPacketOobOffset))->SizeMediaSpecificInfo; \
            } \
        }
    #define NDIS_SET_PACKET_HEADER_SIZE( x, p ) \
        ((PNDIS_PACKET_OOB_DATA)((PUCHAR)(x) + \
        (x)->Private.NdisPacketOobOffset))->HeaderSize = (p)
    #define NDIS_SET_PACKET_STATUS( x, p ) \
        ((PNDIS_PACKET_OOB_DATA)((PUCHAR)(x) + \
        (x)->Private.NdisPacketOobOffset))->Status = (p)
    #define NDIS_SET_PACKET_TIME_TO_SEND( x, p ) \
        ((PNDIS_PACKET_OOB_DATA)((PUCHAR)(x) + \
        (x)->Private.NdisPacketOobOffset))->TimeToSend = (p)
    #define NDIS_SET_PACKET_TIME_SENT( x, p ) \
        ((PNDIS_PACKET_OOB_DATA)((PUCHAR)(x) + \
        (x)->Private.NdisPacketOobOffset))->TimeSent = (p)
    #define NDIS_SET_PACKET_TIME_RECEIVED( x, p ) \
        ((PNDIS_PACKET_OOB_DATA)((PUCHAR)(x) + \
        (x)->Private.NdisPacketOobOffset))->TimeReceived = (p)
    #define NDIS_SET_PACKET_MEDIA_SPECIFIC_INFO( x, p1, p2 ) \
        { \
            if( (x)->Private.NdisPacketFlags & fPACKET_ALLOCATED_BY_NDIS ) { \
                (x)->Private.NdisPacketFlags |= fPACKET_CONTAINS_MEDIA_SPECIFIC_INFO; \
                ((PNDIS_PACKET_OOB_DATA)((PUCHAR)(x) + \
                    (x)->Private.NdisPacketOobOffset))->MediaSpecificInformation = (p1); \
                ((PNDIS_PACKET_OOB_DATA)((PUCHAR)(x) + \
                    (x)->Private.NdisPacketOobOffset))->SizeMediaSpecificInfo = (p2); \
            } \
        }
    #define NDIS_PACKET_EXTENSION_FROM_PACKET( x ) \
        ((PNDIS_PACKET_EXTENSION)((PUCHAR)(x) + (x)->Private.NdisPacketOobOffset + \
        sizeof( NDIS_PACKET_OOB_DATA )))
    #define NDIS_PER_PACKET_INFO_FROM_PACKET( x, p ) \
        ((PNDIS_PACKET_EXTENSION)((PUCHAR)(x) + (x)->Private.NdisPacketOobOffset + \
        sizeof( NDIS_PACKET_OOB_DATA )))->NdisPacketInfo[(p)]
    #define NDIS_GET_ORIGINAL_PACKET( x ) \
        NDIS_PER_PACKET_INFO_FROM_PACKET( x, OriginalPacketInfo )
    #define NDIS_SET_ORIGINAL_PACKET( x, p ) \
        NDIS_PER_PACKET_INFO_FROM_PACKET( x, OriginalPacketInfo ) = (p)
    #define NDIS_GET_PACKET_CANCEL_ID( x ) \
        NDIS_PER_PACKET_INFO_FROM_PACKET( x, PacketCancelId )
    #define NDIS_SET_PACKET_CANCEL_ID( x, p ) \
        NDIS_PER_PACKET_INFO_FROM_PACKET( x, PacketCancelId ) = (p)
    #define NDIS_PACKET_FIRST_NDIS_BUFFER( x )  ((x)->Private.Head)
    #define NDIS_PACKET_LAST_NDIS_BUFFER( x )   ((x)->Private.Tail)
    #define NDIS_PACKET_VALID_COUNTS( x )       ((x)->Private.ValidCounts)
#endif
#if NDIS_SUPPORT_NDIS6
    #define NDIS_STATUS_INDICATION_SET_FLAG( x, p ) ((x)->Flags |= (p))
    #define NDIS_STATUS_INDICATION_TEST_FLAG( x, p )    (((x)->Flags & (p)) != 0)
    #define NDIS_STATUS_INDICATION_CLEAR_FLAG( x, p )   ((x)->Flags &= ~(p))
#endif
#if NDIS_SUPPORT_NDIS6 || NDIS60
    #ifdef __cplusplus 
        #define NET_BUFFER_NEXT_NB( x )         ((x)->NetBufferHeader.NetBufferData.Next)
        #define NET_BUFFER_FIRST_MDL( x ) \
            ((x)->NetBufferHeader.NetBufferData.MdlChain)
        #define NET_BUFFER_DATA_LENGTH( x ) \
            ((x)->NetBufferHeader.NetBufferData.NbDataLength.DataLength)
        #define NET_BUFFER_DATA_OFFSET( x ) \
            ((x)->NetBufferHeader.NetBufferData.DataOffset)
        #define NET_BUFFER_CURRENT_MDL( x ) \
            ((x)->NetBufferHeader.NetBufferData.CurrentMdl)
        #define NET_BUFFER_CURRENT_MDL_OFFSET( x ) \
            ((x)->NetBufferHeader.NetBufferData.CurrentMdlOffset)
        #define NET_BUFFER_LIST_NEXT_NBL( x ) \
            ((x)->NetBufferListHeader.NetBufferListData.Next)
        #define NET_BUFFER_LIST_FIRST_NB( x ) \
            ((x)->NetBufferListHeader.NetBufferListData.FirstNetBuffer)
    #else
        #define NET_BUFFER_NEXT_NB( x )         ((x)->Next)
        #define NET_BUFFER_FIRST_MDL( x )       ((x)->MdlChain)
        #define NET_BUFFER_DATA_LENGTH( x )     ((x)->DataLength)
        #define NET_BUFFER_DATA_OFFSET( x )     ((x)->DataOffset)
        #define NET_BUFFER_CURRENT_MDL( x )     ((x)->CurrentMdl)
        #define NET_BUFFER_CURRENT_MDL_OFFSET( x )  ((x)->CurrentMdlOffset)
        #define NET_BUFFER_LIST_NEXT_NBL( x )   ((x)->Next)
        #define NET_BUFFER_LIST_FIRST_NB( x )   ((x)->FirstNetBuffer)
    #endif
    #define NET_BUFFER_PROTOCOL_RESERVED( x )   ((x)->ProtocolReserved)
    #define NET_BUFFER_MINIPORT_RESERVED( x )   ((x)->MiniportReserved)
    #define NET_BUFFER_CHECKSUM_BIAS( x )       ((x)->ChecksumBias)
    #define NET_BUFFER_LIST_FLAGS( x )          ((x)->Flags)
    #define NET_BUFFER_LIST_NBL_FLAGS( x )      ((x)->NblFlags)
    #define NET_BUFFER_LIST_PROTOCOL_RESERVED( x )  ((x)->ProtocolReserved)
    #define NET_BUFFER_LIST_MINIPORT_RESERVED( x )  ((x)->MiniportReserved)
    #define NET_BUFFER_LIST_CONTEXT_DATA_START( x ) \
        ((PUCHAR)(((x)->Context) + 1) + (x)->Context->Offset)
    #define NET_BUFFER_LIST_CONTEXT_DATA_SIZE( x )  (((x)->Context)->Size)
    #define NET_BUFFER_LIST_INFO( p1, p2 )      ((p1)->NetBufferListInfo[p2])
    #define NET_BUFFER_LIST_STATUS( x )         ((x)->Status)
    #define NDIS_GET_NET_BUFFER_LIST_CANCEL_ID( x ) \
        NET_BUFFER_LIST_INFO( x, NetBufferListCancelId )
    #define NDIS_SET_NET_BUFFER_LIST_CANCEL_ID( x, p ) \
        NET_BUFFER_LIST_INFO( x, NetBufferListCancelId ) = p
    #define NDIS_NBL_ADD_MEDIA_SPECIFIC_INFO( x, p ) \
        { \
            PNDIS_NBL_MEDIA_SPECIFIC_INFORMATION    _v = NULL; \
            if( NET_BUFFER_LIST_INFO( x, MediaSpecificInformation ) != NULL ) { \
                _v = (PNDIS_NBL_MEDIA_SPECIFIC_INFORMATION)(NET_BUFFER_LIST_INFO( x, \
                    MediaSpecificInformation )); \
            } \
            NET_BUFFER_LIST_INFO( x, MediaSpecificInformation ) = (p); \
            (p)->NextEntry = _v; \
        }
    #define NDIS_NBL_REMOVE_MEDIA_SPECIFIC_INFO( x, p ) \
        { \
            PNDIS_NBL_MEDIA_SPECIFIC_INFORMATION    *_v; \
            _v = (PNDIS_NBL_MEDIA_SPECIFIC_INFORMATION *)&(NET_BUFFER_LIST_INFO( x, \
                MediaSpecificInformation )); \
            for( ; *_v != NULL; _v = &(*_v)->NextEntry ) { \
                if( (*_v)->Tag == (p)->Tag ) { \
                    *_v = (*_v)->NextEntry; \
                    break; \
                } \
            } \
        }
    #define NDIS_NBL_GET_MEDIA_SPECIFIC_INFO( x, p1, p2 ) \
        { \
            PNDIS_NBL_MEDIA_SPECIFIC_INFORMATION    _v; \
            (p2) = NULL; \
            _v = (PNDIS_NBL_MEDIA_SPECIFIC_INFORMATION)(NET_BUFFER_LIST_INFO( x, \
                MediaSpecificInformation )); \
            for( ; _v != NULL; _v = _v->NextEntry ) { \
                if( _v->Tag == (p1) ) { \
                    (p2) = _v; \
                    break; \
                } \
            } \
        }
    #define NET_BUFFER_LIST_SET_HASH_TYPE( x, p ) \
        (NET_BUFFER_LIST_INFO( x, NetBufferListHashInfo ) = UlongToPtr( ((PtrToLong( \
        NET_BUFFER_LIST_INFO( x, NetBufferListHashInfo ) ) & ~NDIS_HASH_TYPE_MASK) | \
        ((p) & NDIS_HASH_TYPEMASK)) ))
    #define NET_BUFFER_LIST_SET_HASH_FUNCTION( x, p ) \
        (NET_BUFFER_LIST_INFO( x, NetBufferListHashInfo ) = UlongToPtr( ((PtrToLong( \
        NET_BUFFER_LIST_INFO( x, NetBufferListHashInfo ) ) & \
        ~NDIS_HASH_FUNCTION_MASK) | ((p) & NDIS_HASH_FUNCTION_MASK)) ))
    #define NET_BUFFER_LIST_SET_HASH_VALUE( x, p ) \
        (NET_BUFFER_LIST_INFO( x, NetBufferListHashValue ) = UlongToPtr( p ))
    #define NET_BUFFER_LIST_GET_HASH_TYPE( x ) \
        (PtrToUlong( NET_BUFFER_LIST_INFO( x, NetBufferListHashInfo ) ) & \
        NDIS_HASH_TYPE_MASK)
    #define NET_BUFFER_LIST_GET_HASH_FUNCTION( x ) \
        (PtrToUlong( NET_BUFFER_LIST_INFO( x, NetBufferListHashInfo ) ) & \
        NDIS_HASH_FUNCTION_MASK)
    #define NET_BUFFER_LIST_GET_HASH_VALUE( x ) \
        PtrToUlong( NET_BUFFER_LIST_INFO( x, NetBufferListHashValue ) )
    #define NDIS_MDL_TO_SPAN_PAGES( x ) \
        (MmGetMdlByteCount( x ) == 0 ? 1 : (ADDRESS_AND_SIZE_TO_SPAN_PAGES( \
        MmGetMdlVirtualAddress( x ), MmGetMdlByteCount( x ) )))
    #define NDIS_MDL_LINKAGE( x )               ((x)->Next)
#endif
#if NDIS_SUPPORT_NDIS61
    #define NET_BUFFER_DATA_PHYSICAL_ADDRESS( x )   ((x)->DataPhysicalAddress)
#endif
#if NDIS_SUPPORT_NDIS620
    #define NET_BUFFER_FIRST_SHARED_MEM_INFO( x )   ((x)->SharedMemoryInfo)
    #define NET_BUFFER_SHARED_MEM_NEXT_SEGMENT( x ) ((x)->NextSharedMemorySegment)
    #define NET_BUFFER_SHARED_MEM_FLAGS( x )    ((x)->SharedMemoryFlags)
    #define NET_BUFFER_SHARED_MEM_HANDLE( x )   ((x)->SharedMemoryHandle)
    #define NET_BUFFER_SHARED_MEM_OFFSET( x )   ((x)->SharedMemoryOffset)
    #define NET_BUFFER_SHARED_MEM_LENGTH( x )   ((x)->SharedMemoryLength)
    #define NET_BUFFER_SCATTER_GATHER_LIST( x ) ((x)->ScatterGatherList)
    #define NDIS_NBL_ADD_MEDIA_SPECIFIC_INFO_EX( x, p ) \
        { \
            PNDIS_NBL_MEDIA_SPECIFIC_INFORMATION_EX v; \
            v = NET_BUFFER_LIST_INFO( x, MediaSpecificInformationEx ); \
            NET_BUFFER_LIST_INFO( x, MediaSpecificInformationEx ) = (p); \
            (p)->NextEntry = v; \
        }
    #define NDIS_NBL_REMOVE_MEDIA_SPECIFIC_INFO_EX( x, p ) \
        { \
            PNDIS_NBL_MEDIA_SPECIFIC_INFORMATION_EX *v; \
            v = (PNDIS_NBL_MEDIA_SPECIFIC_INFORMATION_EX *) \
                &NET_BUFFER_LIST_INFO( x, MediaSpecificInformationEx ); \
            while( *v != NULL ) { \
                if( (*v)->Tag == (p)->Tag ) { \
                    *v = (*v)->NextEntry; \
                    break; \
                } \
                v = &(*v)->NextEntry; \
            } \
        }
    #define NDIS_NBL_GET_MEDIA_SPECIFIC_INFO_EX( x, p1, p2 ) \
        { \
            PNDIS_NBL_MEDIA_SPECIFIC_INFORMATION_EX v; \
            p2 = NULL; \
            v = (PNDIS_MEDIA_SPECIFIC_INFORMATION_EX) \
                NET_BUFFER_LIST_INFO( x, MediaSpecificInformationEx ); \
            while( v != NULL ) { \
                if( v->Tag == p1 ) { \
                    p2 = v; \
                    break; \
                } \
                v = v->NextEntry; \
            } \
        }
    #define NET_BUFFER_LIST_RECEIVE_FILTER_ID( x ) \
        (((PNDIS_NET_BUFFER_LIST_FILTERING_INFO)&NET_BUFFER_LIST_INFO( x, \
        NetBufferListFilteringInfo ))->FilteringInfo.FilterId)
    #define NET_BUFFER_LIST_RECEIVE_QUEUE_ID( x ) \
        (((PNDIS_NET_BUFFER_LIST_FILTERING_INFO)&NET_BUFFER_LIST_INFO( x, \
        NetBufferListFilteringInfo ))->FilteringInfo.QueueId)
#endif

/* Aliases */
#define NdisMoveMemory                      RtlCopyMemory
#define NdisZeroMemory                      RtlZeroMemory
#define NdisEqualMemory                     RtlEqualMemory
#define NdisFillMemory                      RtlFillMemory
#define NdisRetrieveUlong                   RtlRetrieveUlong
#define NdisStoreUlong                      RtlStroeUlong
#define NdisMoveToMappedMemory              NdisMoveMappedMemory
#define NdisMoveFromMappedMemory            NdisMoveMappedMemory
#define NdisGetCurrentSystemTime            KeQuerySystemTime
#define NdisInterlockedIncrement            InterlockedIncrement
#define NdisInterlockedDecrement            InterlockedDecrement
#define NdisInterlockedFlushSList           ExInterlockedFlushSList
#define NdisInitializeSListHead             ExInitializeSListHead
#define NdisQueryDepthSList                 ExQueryDepthSList
#define NdisInitializeListHead              InitializeListHead
#define NdisStallExecution                  KeStallExecutionProcessor
#define NdisEqualString                     RtlEqualUnicodeString
#define NdisEqualUnicodeString              RtlEqualUnicodeString
#define NdisInitAnsiString                  RtlInitString
#define NdisInitUnicodeString               RtlInitUnicodeString
#define NdisInitializeNPagedLookasideList   ExInitializeNPagedLookasideList
#define NdisDeleteNPagedLookasideList       ExDeleteNPagedLookasideList
#define NdisAllocateFromNPagedLookasideList ExAllocateFromNPagedLookasideList
#define NdisFreeToNPagedLookasideList       ExFreeToNPagedLookasideList
#define NdisMSetupDmaTransfer               NdisSetupDmaTransfer
#define NdisMCompleteDmaTransfer            NdisCompleteDmaTransfer
#define NdisMCmOpenAddressFamilyComplete    NdisCmOpenAddressFamilyComplete
#define NdisMCmNotifyCloseAddressFamily     NdisCmNotifyCloseAddressFamily
#define NdisMCmCloseAddressFamilyComplete   NdisCmCloseAddressFamilyComplete
#define NdisMCmRegisterSapComplete          NdisCmRegisterSapComplete
#define NdisMCmDeregisterSapComplete        NdisCmDeregisterSapComplete
#define NdisMCmMakeCallComplete             NdisCmMakeCallComplete
#define NdisMCmCloseCallComplete            NdisCmCloseCallComplete
#define NdisMCmAddPartyComplete             NdisCmAddPartyComplete
#define NdisMCmDropPartyComplete            NdisCmDropPartyComplete
#define NdisMCmDispatchIncomingCall         NdisCmDispatchIncomingCall
#define NdisMCmDispatchCallConnected        NdisCmDispatchCallConnected
#define NdisMCmModifyCallQoSComplete        NdisCmModifyCallQoSComplete
#define NdisMCmDispatchIncomingCallQoSChange    NdisCmDispatchIncomingCallQoSChange
#define NdisMCmDispatchIncomingCloseCall    NdisCmDispatchIncomingCloseCall
#define NdisMCmDispatchIncomingDropParty    NdisCmDispatchIncomingDropParty

#ifdef _X86_
    #define NdisWriteRegisterUchar          WRITE_REGISTER_UCHAR
    #define NdisWriteRegisterUshort         WRITE_REGISTER_USHORT
    #define NdisWriteRegisterUlong          WRITE_REGISTER_ULONG
#endif
#if NDIS_LEGACY_DRIVER
    #define NdisFreeBuffer                  IoFreeMdl
#endif
#if NDIS_SUPPORT_NDIS6
    #define NdisMAllocateSharedMemoryAsyncEx    NdisMAllocateSharedMemoryAsync
#endif

#if NDIS_LEGACY_DRIVER

__inline VOID NdisQueryPacket( PNDIS_PACKET x, PUINT p1, PUINT p2, PNDIS_BUFFER *p3,
                               PUINT p4 )
{
    if( p3 != NULL ) {
        PNDIS_BUFFER *v1 = p3;
        *v1 = x->Private.Head;
    }
    if( p1 || p2 || p4 ) {
        if( !x->Private.ValidCounts ) {
            PNDIS_BUFFER    v2 = (x)->Private.Head;
            UINT            v3 = 0;
            UINT            v4 = 0;
            UINT            v5 = 0;
            UINT            v6;
            UINT            v7;
            while( v2 != NULL ) {
                NdisQueryBufferOffset( v2, &v7, &v6 );
                v3 += v6;
                v4 += (UINT)NDIS_BUFFER_TO_SPAN_PAGES( v2 );
                ++v5;
                v2 = v2->Next;
            }
            x->Private.Count = v5;
            x->Private.TotalLength = v3;
            x->Private.PhysicalCount = v4;
            x->Private.ValidCounts = TRUE;
        }
        if( p1 ) {
            *p1 = x->Private.PhysicalCount;
        }
        if( p2 ) {
            *p2 = x->Private.Count;
        }
        if( p4 ) {
            *p4 = x->Private.TotalLength;
        }
    }
}

#endif /* NDIS_LEGACY_DRIVER */

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _NDIS_ */
