/*
 *  iphlpapi.h  IP helper API functions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2010 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef __IPHLPAPI_H__
#define __IPHLPAPI_H__

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#include <iprtrmib.h>
#include <ipexport.h>
#include <iptypes.h>
#include <tcpestats.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Network string flags */
#if (NTDDI_VERSION >= 0x06000000)
    #define NET_STRING_IPV4_ADDRESS             0x00000001L
    #define NET_STRING_IPV4_SERVICE             0x00000002L
    #define NET_STRING_IPV4_NETWORK             0x00000004L
    #define NET_STRING_IPV6_ADDRESS             0x00000008L
    #define NET_STRING_IPV6_ADDRESS_NO_SCOPE    0x00000010L
    #define NET_STRING_IPV6_SERVICE             0x00000020L
    #define NET_STRING_IPV6_SERVICE_NO_SCOPE    0x00000040L
    #define NET_STRING_IPV6_NETWORK             0x00000080L
    #define NET_STRING_NAMED_ADDRESS            0x00000100L
    #define NET_STRING_NAMED_SERVICE            0x00000200L
    #define NET_STRING_IP_STRING \
        (NET_STRING_IPV4_ADDRESS | NET_STRING_IPV6_ADDRESS)
    #define NET_STRING_IP_ADDRESS_NO_SCOPE \
        (NET_STRING_IPV4_ADDRESS | NET_STRING_IPV6_ADDRESS_NO_SCOPE)
    #define NET_STRING_IP_SERVICE \
        (NET_STRING_IPV4_SERVICE | NET_STRING_IPV6_SERVICE)
    #define NET_STRING_IP_SERVICE_NO_SCOPE \
        (NET_STRING_IPV4_SERVICE | NET_STRING_IPV6_SERVICE_NO_SCOPE)
    #define NET_STRING_IP_NETWORK \
        (NET_STRING_IPV4_NETWORK | NET_STRING_IPV6_NETWORK)
    #define NET_STRING_ANY_ADDRESS \
        (NET_STRING_NAMED_ADDRESS | NET_STRING_IP_ADDRESS)
    #define NET_STRING_ANY_ADDRESS_NO_SCOPE \
        (NET_STRING_NAMED_ADDRESS | NET_STRING_IP_ADDRESS_NO_SCOPE)
    #define NET_STRING_ANY_SERVICE \
        (NET_STRING_NAMED_SERVICE | NET_STRING_IP_SERVICE)
    #define NET_STRING_ANY_SERVICE_NO_SCOPE \
        (NET_STRING_NAMED_SERVICE | NET_STRING_IP_SERVICE_NO_SCOPE)
#endif

/* Network address formats */
#if (NTDDI_VERSION >= 0x06000000)
typedef enum NET_ADDRESS_FORMAT_ {
    NET_ADDRESS_FORMAT_UNSPECIFIED  = 0,
    NET_ADDRESS_DNS_NAME            = 1,
    NET_ADDRESS_IPV4                = 2,
    NET_ADDRESS_IPV6                = 3
} NET_ADDRESS_FORMAT;
#endif

/* Network address information */
#if (NTDDI_VERSION >= 0x06000000) && defined( _WS2DEF_ ) && defined( _WS2IPDEF_ ) && \
    defined ( _WINDNS_INCLUDED )
typedef struct NET_ADDRESS_INFO_ {
    NET_ADDRESS_FORMAT  Format;
    union {
        struct {
            WCHAR   Address[DNS_MAX_NAME_BUFFER_LENGTH];
            WCHAR   Port[6];
        } NamedAddress;
        SOCKADDR_IN     Ipv4Address;
        SOCKADDR_IN6    Ipv6Address;
        SOCKADDR        IpAddress;
    };
} NET_ADDRESS_INFO;
typedef NET_ADDRESS_INFO    *PNET_ADDRESS_INFO;
#endif

/* Functions in IPHLPAPI.DLL */
DWORD WINAPI    AddIPAddress( IPAddr, IPMask, DWORD, PULONG, PULONG );
DWORD WINAPI    CreateIpForwardEntry( PMIB_IPFORWARDROW );
DWORD WINAPI    CreateIpNetEntry( PMIB_IPNETROW );
DWORD WINAPI    CreateProxyArpEntry( DWORD, DWORD, DWORD );
DWORD WINAPI    DeleteIPAddress( ULONG );
DWORD WINAPI    DeleteIpForwardEntry( PMIB_IPFORWARDROW );
DWORD WINAPI    DeleteIpNetEntry( PMIB_IPNETROW );
DWORD WINAPI    DeleteProxyArpEntry( DWORD, DWORD, DWORD );
DWORD WINAPI    DisableMediaSense( HANDLE *, OVERLAPPED * );
DWORD WINAPI    EnableRouter( HANDLE *, OVERLAPPED * );
DWORD WINAPI    FlushIpNetTable( DWORD );
DWORD WINAPI    GetAdapterIndex( LPWSTR, PULONG );
PIP_ADAPTER_ORDER_MAP WINAPI    GetAdapterOrderMap( VOID );
ULONG WINAPI    GetAdaptersInfo( PIP_ADAPTER_INFO, PULONG );
DWORD WINAPI    GetBestInterface( IPAddr, PDWORD );
DWORD WINAPI    GetBestInterfaceEx( struct sockaddr *, PDWORD );
DWORD WINAPI    GetBestRoute( DWORD, DWORD, PMIB_IPFORWARDROW );
DWORD WINAPI    GetExtendedTcpTable( PVOID, PDWORD, BOOL, ULONG, TCP_TABLE_CLASS, ULONG );
DWORD WINAPI    GetExtendedUdpTable( PVOID, PDWORD, BOOL, ULONG, UDP_TABLE_CLASS, ULONG );
DWORD WINAPI    GetFriendlyIfIndex( DWORD );
ULONG WINAPI    GetIcmpStatistics( PMIB_ICMP );
DWORD WINAPI    GetIfEntry( PMIB_IFROW );
DWORD WINAPI    GetIfTable( PMIB_IFTABLE, PULONG, BOOL );
DWORD WINAPI    GetInterfaceInfo( PIP_INTERFACE_INFO, PULONG );
DWORD WINAPI    GetIpAddrTable( PMIB_IPADDRTABLE, PULONG, BOOL );
DWORD WINAPI    GetIpForwardTable( PMIB_IPFORWARDTABLE, PULONG, BOOL );
ULONG WINAPI    GetIpNetTable( PMIB_IPNETTABLE, PULONG, BOOL );
DWORD WINAPI    GetNumberOfInterfaces( PDWORD );
DWORD WINAPI    GetOwnerModuleFromPidAndInfo( ULONG, ULONGLONG, TCPIP_OWNER_MODULE_INFO_CLASS, PVOID, PDWORD );
DWORD WINAPI    GetOwnerModuleFromTcpEntry( PMIB_TCPROW_OWNER_MODULE, TCPIP_OWNER_MODULE_INFO_CLASS, PVOID, PDWORD );
DWORD WINAPI    GetOwnerModuleFromUdpEntry( PMIB_UDPROW_OWNER_MODULE, TCPIP_OWNER_MODULE_INFO_CLASS, PVOID, PDWORD );
BOOL WINAPI     GetRTTAndHopCount( IPAddr, PULONG, ULONG, PULONG );
ULONG WINAPI    GetTcpTable( PMIB_TCPTABLE, PULONG, BOOL );
ULONG WINAPI    GetUdpStatistics( PMIB_UDPSTATS );
ULONG WINAPI    GetUdpTable( PMIB_UDPTABLE, PULONG, BOOL );
DWORD WINAPI    GetUniDirectionalAdapterInfo( PIP_UNIDIRECTIONAL_ADAPTER_ADDRESS, PULONG );
DWORD WINAPI    IpReleaseAddress( PIP_ADAPTER_INDEX_MAP );
DWORD WINAPI    IpRenewAddress( PIP_ADAPTER_INDEX_MAP );
DWORD WINAPI    NotifyAddrChange( PHANDLE, LPOVERLAPPED );
DWORD WINAPI    NotifyRouteChange( PHANDLE, LPOVERLAPPED );
DWORD WINAPI    RestoreMediaSense( OVERLAPPED *, LPDWORD );
DWORD WINAPI    SendARP( IPAddr, IPAddr, PVOID, PULONG );
DWORD WINAPI    SetIfEntry( PMIB_IFROW );
DWORD WINAPI    SetIpForwardEntry( PMIB_IPFORWARDROW );
DWORD WINAPI    SetIpTTL( UINT );
DWORD WINAPI    SetIpNetEntry( PMIB_IPNETROW );
DWORD WINAPI    SetTcpEntry( PMIB_TCPROW );
DWORD WINAPI    UnenableRouter( OVERLAPPED *, LPDWORD );
#ifdef _WS2IPDEF_
ULONG WINAPI    GetPerTcp6ConnectionEStats( PMIB_TCP6ROW, TCP_ESTATS_TYPE, PUCHAR, ULONG, ULONG, PUCHAR, ULONG, ULONG, PUCHAR, ULONG, ULONG );
ULONG WINAPI    GetPerTcpConnectionEStats( PMIB_TCPROW, TCP_ESTATS_TYPE, PUCHAR, ULONG, ULONG, PUCHAR, ULONG, ULONG, PUCHAR, ULONG, ULONG );
DWORD WINAPI    GetOwnerModuleFromTcp6Entry( PMIB_TCP6ROW_OWNER_MODULE, TCPIP_OWNER_MODULE_INFO_CLASS, PVOID, PDWORD );
DWORD WINAPI    GetOwnerModuleFromUdp6Entry( PMIB_UDP6ROW_OWNER_MODULE, TCPIP_OWNER_MODULE_INFO_CLASS, PVOID, PDWORD );
ULONG WINAPI    GetUdp6Table( PMIB_UDP6TABLE, PULONG, BOOL );
ULONG WINAPI    SetPerTcp6ConnectionEStats( PMIB_TCP6ROW, TCP_ESTATS_TYPE, PUCHAR, ULONG, ULONG, ULONG );
ULONG WINAPI    SetPerTcpConnectionEStats( PMIB_TCPROW, TCP_ESTATS_TYPE, PUCHAR, ULONG, ULONG, ULONG );
#endif
#ifdef _WINSOCK2API_
ULONG WINAPI    GetAdaptersAddresses( ULONG, ULONG, PVOID, PIP_ADAPTER_ADDRESSES, PULONG );
#endif
#if (NTDDI_VERSION < 0x06000000)
DWORD WINAPI    AllocateAndGetTcpExTableFromStack( PVOID *, BOOL, HANDLE, DWORD, DWORD );
DWORD WINAPI    AllocateAndGetUdpExTableFromStack( PVOID *, BOOL, HANDLE, DWORD, DWORD );
#endif
#if (NTDDI_VERSION >= 0x05000000)
ULONG WINAPI    GetIpStatistics( PMIB_IPSTATS );
ULONG WINAPI    GetTcpStatistics( PMIB_TCPSTATS );
DWORD WINAPI    SetIpStatistics( PMIB_IPSTATS );
#endif
#if (NTDDI_VERSION >= 0x05000100)
DWORD WINAPI    GetNetworkParams( PFIXED_INFO, PULONG );
DWORD WINAPI    GetPerAdapterInfo( ULONG, PIP_PER_ADAPTER_INFO, PULONG );
DWORD WINAPI    NhpAllocateAndGetInterfaceInfoFromStack( IP_INTERFACE_NAME_INFO **, PDWORD, BOOL, HANDLE, DWORD );
#endif
#if (NTDDI_VERSION >= 0x05010000)
ULONG WINAPI    GetIcmpStatisticsEx( PMIB_ICMP_EX, ULONG );
ULONG WINAPI    GetIpStatisticsEx( PMIB_IPSTATS, ULONG );
ULONG WINAPI    GetTcpStatisticsEx( PMIB_TCPSTATS, ULONG );
ULONG WINAPI    GetUdpStatisticsEx( PMIB_UDPSTATS, ULONG );
ULONG WINAPI    SetIpStatisticsEx( PMIB_IPSTATS, ULONG );
#endif
#if (NTDDI_VERSION >= 0x06000000)
ULONG WINAPI    CreatePersistentTcpPortReservation( USHORT, USHORT, PULONG64 );
ULONG WINAPI    CreatePersistentUdpPortReservation( USHORT, USHORT, PULONG64 );
ULONG WINAPI    DeletePersistentTcpPortReservation( USHORT, USHORT );
ULONG WINAPI    DeletePersistentUdpPortReservation( USHORT, USHORT );
DWORD WINAPI    GetIpErrorString( IP_STATUS, PWSTR, PDWORD );
ULONG WINAPI    GetTcpTable2( PMIB_TCPTABLE2, PULONG, BOOL );
ULONG WINAPI    LookupPersistentTcpPortReservation( USHORT, USHORT, PULONG64 );
ULONG WINAPI    LookupPersistentUdpPortReservation( USHORT, USHORT, PULONG64 );
#ifdef _WS2DEF_
ULONG WINAPI    ResolveNeighbor( SOCKADDR *, PVOID, PULONG );
#endif
#ifdef _WS2IPDEF_
ULONG WINAPI    GetTcp6Table( PMIB_TCP6TABLE, PULONG, BOOL );
ULONG WINAPI    GetTcp6Table2( PMIB_TCP6TABLE2, PULONG, BOOL );
#endif
#if defined( _WS2DEF_ ) && defined( _WS2IPDEF_ ) && defined( _WINDNS_INCLUDED )
DWORD WINAPI    ParseNetworkString( CONST WCHAR *, DWORD, PNET_ADDRESS_INFO, USHORT *, BYTE * );
#endif
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* __IPHLPAPI_H__ */
